<?php
//About widget
add_action('widgets_init', 'mweb_register_namad_widget');
function mweb_register_namad_widget()
{
    register_widget('mweb_namad_widget');
}

class mweb_namad_widget extends WP_Widget
{
    function __construct()
    {
        $widget_ops = array('classname' => 'contact-namad-widget', 'description' => '' );
        parent::__construct('mweb_namad_widget','footer - اسلایدر نماد ها' , $widget_ops);
    }

    function widget($args, $instance)
    {
	    extract( $args );
	    $title   = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
	    $namad_samandehi = ( ! empty( $instance['namad_samandehi'] ) ) ? $instance['namad_samandehi'] : '';
	    $namad_electro   = ( ! empty( $instance['namad_electro'] ) ) ? $instance['namad_electro'] : '';
	    $namad_unknown   = ( ! empty( $instance['namad_unknown'] ) ) ? $instance['namad_unknown'] : '';


	    echo $before_widget;

	    if ( ! empty( $title ) ) {
		    echo $before_title . esc_attr( $title ) . $after_title;
	    }else{
			echo '<div class="widget-content">';
		} ?>

		<div class="namad_slider_wrap">
			<?php
			echo '<div class="owl-carousel mw-owl-carousel" data-margin="0" data-nav="false" data-autoplay="true"  data-dots="true"  data-rtl="true" data-loop="true" data-responsiveClass="true" data-responsive=\'{"0":{"items":1},"600":{"items":1},"768":{"items":1},"1000":{"items":1},"1200":{"items":1}}\' >';
			if(!empty($namad_samandehi))
				echo '<div class="item">'.$namad_samandehi.'</div>';
			if(!empty($namad_electro))
				echo '<div class="item">'.$namad_electro.'</div>';
			if(!empty($namad_unknown))
				echo '<div class="item">'.$namad_unknown.'</div>';
			echo '</div>';
			?>
		</div>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
	    $instance               = $old_instance;
	    $instance['title']      = strip_tags( $new_instance['title'] );
	    $instance['namad_samandehi']    = $new_instance['namad_samandehi'];
	    $instance['namad_electro']      = $new_instance['namad_electro'];
	    $instance['namad_unknown']      = $new_instance['namad_unknown'];

	    return $instance;
    }

    function form($instance)
    {
	    $defaults = array(
		    'title'      => esc_html__( 'مجوزها', 'mweb' ),
		    'namad_samandehi'    => '',
		    'namad_electro'      => '',
		    'namad_unknown'      => ''
	    );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>
	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('عنوان:','mweb');?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php if( !empty($instance['title']) ) echo esc_attr($instance['title']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'namad_samandehi' )); ?>"><?php esc_html_e('کد نماد اول :','mweb'); ?></label>
		    <textarea rows="10" cols="50" type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'namad_samandehi' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'namad_samandehi' )); ?>" ><?php if( !empty($instance['namad_samandehi']) ) echo esc_attr($instance['namad_samandehi']); ?></textarea>
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'namad_electro' )); ?>"><?php esc_html_e('کد نماد دوم :','mweb'); ?></label>
		    <textarea rows="10" cols="50" type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'namad_electro' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'namad_electro' )); ?>" ><?php if( !empty($instance['namad_electro']) ) echo esc_attr($instance['namad_electro']); ?></textarea>
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'namad_unknown' )); ?>"><?php esc_html_e('کد نماد سوم :','mweb'); ?></label>
		    <textarea rows="10" cols="50" type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'namad_unknown' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'namad_unknown' )); ?>" ><?php if( !empty($instance['namad_unknown']) ) echo esc_attr($instance['namad_unknown']); ?></textarea>
	    </p>
		
	

    <?php
    }
}
?>
