<?php
//About widget
add_action('widgets_init', 'mweb_register_about_widget');
function mweb_register_about_widget()
{
    register_widget('mweb_about_widget');
}

class mweb_about_widget extends WP_Widget
{
    function __construct()
    {
        $widget_ops = array('classname' => 'about-widget', 'description' => '' );
        parent::__construct('mweb_about_widget', 'footer - درباره ما' , $widget_ops);
    }

    function widget($args, $instance)
    {
	    extract( $args );
	    $title   = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
	    $text    = ( ! empty( $instance['text'] ) ) ? $instance['text'] : '';
	    $name    = ( ! empty( $instance['name'] ) ) ? $instance['name'] : '';
	    $image   = ( ! empty( $instance['logo_image'] ) ) ? $instance['logo_image'] : '';

	    echo $before_widget;

	    if ( ! empty( $title ) ) {
		    echo $before_title . esc_attr( $title ) . $after_title;
	    } ?>


        <?php if (!empty($image)) : ?>
            <div class="about_widget_image">
	            <img data-no-retina src="<?php echo esc_url($image); ?>" alt="<?php bloginfo() ?>"/>
	            <?php if (!empty($name)) : ?>
		            <h3 class="about_name"><?php echo esc_attr($name); ?></h3>
	            <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="about_content_wrap">
            <?php if (!empty($text)) : ?>
                <div class="about_content"><?php echo do_shortcode($text); ?></div>
            <?php endif; ?>
        </div>


        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
	    $instance               = $old_instance;
	    $instance['title']      = strip_tags( $new_instance['title'] );
	    $instance['name']       = strip_tags( $new_instance['name'] );
	    $instance['text']       = $new_instance['text'];
	    $instance['logo_image'] = strip_tags( $new_instance['logo_image'] );

	    return $instance;
    }

    function form($instance)
    {
	    $defaults = array(
		    'title'      => esc_html__( 'درباره ما', 'mweb' ),
		    'text'       => '',
		    'name'       => '',
		    'logo_image' => ''
	    );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>
	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('عنوان:','mweb');?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php if( !empty($instance['title']) ) echo esc_attr($instance['title']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'logo_image' )); ?>"><?php esc_html_e('لینک عکس درباره ما:','mweb'); ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'logo_image' )); ?>" name="<?php echo esc_attr($this->get_field_name('logo_image')); ?>" value="<?php if( !empty($instance['logo_image']) ) echo esc_url($instance['logo_image']); ?>" />
	    </p>
	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'name' )); ?>"><?php esc_html_e('نام:','mweb'); ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'name' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'name' )); ?>" value="<?php if( !empty($instance['name']) ) echo esc_attr($instance['name']); ?>" />
	    </p>
	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'text' )); ?>"><?php esc_html_e('متن قسمت درباره ما:','mweb'); ?></label>
		    <textarea rows="10" cols="50" id="<?php echo esc_html($this->get_field_id( 'text' )); ?>" name="<?php echo esc_html($this->get_field_name('text')); ?>" class="widefat"><?php echo esc_html($instance['text']); ?></textarea>
	    </p>

	  
    <?php
    }
}
?>
