<?php
/**
 * Compare Template
 *
 * @author Transvelo
 * @package electro/templates/shop
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product, $post; ?>
    
<?php if( ! empty( $products ) ) : ?>

<?php 

$fields = array();
foreach( $products as $id ) {
	$product = wc_get_product( $id );
	if( !is_product() ){
		if($product->has_weight())
			$fields['weight'] = 'وزن';
		if($product->has_dimensions())
			$fields['dimensions'] = 'ابعاد';
		
		foreach ( $product->get_attributes() as $attribute_id => $attribute ) {
			if ( !in_array( substr( $attribute_id, 3 ), $fields ) ) {
					$fields[$attribute_id] =  wc_attribute_label( $attribute_id, $product );
			}
		}
	}
}

	
?>
<div class="table-responsive">

    <table class="table table-compare compare-list">
        
        <tbody>

            <?php $fields_displayed = array(); ?>

            <tr>
                <th><?php echo esc_html__( 'محصول', 'mweb' ); ?></th>
                <?php foreach( $products as $key => $product ) : ?>
                    <?php $product_id = mweb_woocommerce::mweb_get_product_id( $product ); ?>
                <td>
                    <a href="<?php echo get_permalink( $product_id ); ?>" class="product">
                        <div class="product-image">
                            <div class="image">
                                <?php 
                                    if( has_post_thumbnail( $product_id ) ) {
                                        echo get_the_post_thumbnail( $product_id, 'shop_catalog' );
                                    } elseif( wc_placeholder_img_src() ) {
                                        echo wc_placeholder_img( 'shop_catalog' );
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="product-info">
                            <h3 class="product-title"><?php echo esc_html( $product->get_title() ); ?></h3>
                            <?php wc_get_template( 'loop/rating.php', array( 'product', $product ) ); ?>
                        </div>
                    </a><!-- /.product -->
                </td>
                <?php 
                    $fields_displayed[] = 'image';
                    $fields_displayed[] = 'title';
                ?>
                <?php endforeach; ?>
            </tr>

            <tr>
                <th><?php echo esc_html__( 'قیمت', 'mweb' ); ?></th>
                <?php foreach( $products as $key => $product ) : ?>
                <td>
                    <div class="product-price price"><?php echo wp_kses_post( $product->get_price_html() ); ?></div>
                </td>
                <?php $fields_displayed[] = 'price'; ?>
                <?php endforeach; ?>
            </tr>

            <tr>
                <th><?php echo esc_html__( 'موجودی', 'mweb' ); ?></th>
                <?php foreach( $products as $key => $product ) :
						$stock_class = 'out-of-stock';
						$availability = $product->get_availability();
							if ( empty( $availability['availability'] ) ) {
								$availability['availability'] = __( 'In stock', 'woocommerce' );
								$stock_class = 'in-stock';
							}
						?>
                <td><?php echo sprintf( '<span class="%s">%s</span>', $stock_class , esc_html( $availability['availability'] ) ); ?></td>
                <?php $fields_displayed[] = 'stock'; ?>
                <?php endforeach; ?>
            </tr>

            <tr>
                <th><?php echo esc_html__( 'توضیحات', 'mweb' ); ?></th>
                <?php foreach( $products as $key => $product ) : ?>
                <td><?php echo wp_kses_post( $product->get_short_description() ); ?></td>
                <?php $fields_displayed[] = 'description'; ?>
                <?php endforeach; ?>
            </tr>

            <?php foreach ( $fields as $field => $name ) : ?>

            <tr class="<?php echo $field ?>">

                <th>
                    <?php echo $name ?>
                    <?php if ( $field == 'image' ) echo '<div class="fixed-th"></div>'; ?>
                </th>

                <?php
                $index = 0;
                foreach( $products as $product_id => $product ) :
                    $product_class = ( $index % 2 == 0 ? 'odd' : 'even' ) . ' product_' . $product_id; ?>
                    <td class="<?php echo $product_class; ?>"><?php
                        switch( $field ) {

                            case 'weight':
								if( $weight = $product->get_weight() ){
									$weight = wc_format_localized_decimal( $weight ) . ' ' . esc_attr( get_option( 'woocommerce_weight_unit' ) );
								}
								else {
									$weight = '-';
								}
								echo sprintf( '<span>%s</span>', esc_html( $weight ) );
                            break;
							case 'dimensions':
								$dimensions = function_exists( 'wc_format_dimensions' ) ? wc_format_dimensions( $product->get_dimensions(false) ) : $product->get_dimensions();
								! $dimensions && $dimensions = '-';
								
								echo sprintf( '<span>%s</span>', esc_html( $dimensions ) );
								break;

                            default:
                                //echo empty( $product->fields[$field] ) ? '&nbsp;' : $product->fields[$field];
								echo $product->get_attribute( $field );
                                break;
                        }
                        ?>
                    </td>
                    <?php
                    ++$index;
                endforeach; ?>

            </tr>

        <?php endforeach; ?>

                

			<tr class="add-to-cart repeated">
				<th><?php echo 'خرید'; ?></th>
				<?php foreach( $products as $key => $product ) : ?>
				<td><?php wc_get_template( 'loop/add-to-cart.php', array( 'product' => $product ) ); ?></td>
				<?php endforeach; ?>
			</tr>

            <tr>
                <th>&nbsp;</th>
                <?php foreach( $products as $i => $product ) : ?>
                <td class="text-center remove-item">
                   <?php 
                        echo '<a class="remove-icon" title="حذف" href="'.esc_url( mweb_get_compare_link( $i, 'remove-from-list' ) ).'"><i class="fa fa-times"></i></a>';
                    ?>
                </td>
                <?php endforeach ?>
            </tr>

        </tbody>
    </table>

</div><!-- /.table-responsive -->


<?php else : ?>

    <div class="outer-bottom-vs outer-top-sm compare-empty">
        <h1 class="lead-title text-center cart-empty">
            <?php esc_html_e( 'جدول مقایسه خالی می باشد', 'mweb' ) ?>
        </h1>
        
        <p class="return-to-shop">
            <a class="wc-backward btn" href="<?php echo apply_filters( 'woocommerce_return_to_shop_redirect', get_permalink( wc_get_page_id( 'shop' ) ) ); ?>">
                <i class="icon fa fa-mail-reply"></i>
                <?php esc_html_e( 'بازگشت به فروشگاه', 'mweb' ) ?>
            </a>
        </p>
    </div>

<?php endif; ?>