<?php
       
   global $post; $post_id = $post->ID;
   $course_id = $post_id;
   $user_id   = get_current_user_id();

   $options = get_option('sfwd_cpt_options');


   $currency = null;

   if ( ! is_null( $options ) ) {
      if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
         $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];

   }

   if( is_null( $currency ) )
      $currency = 'تومان';

   $course_options = get_post_meta($post_id, "_sfwd-courses", true);


   $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : esc_html__( 'Free', 'mweb' );

   $has_access   = sfwd_lms_has_access( $course_id, $user_id );
   $is_completed = learndash_course_completed( $user_id, $course_id );

	if( $price == '' )
		$price .= __( 'رایگان', 'mweb' );

	if ( is_numeric( $price ) ) {
		if ( $currency == "USD" )
			$price = '$' . $price;
		else
			$price .= ' <span class="woocommerce-Price-currencySymbol">'.$currency.'</span>';
	}

	$class       = '';
	$ribbon_text = '';

	if ( $has_access && ! $is_completed ) {
		$class = 'ld_course_grid_price ribbon-enrolled';
		$ribbon_text = __( 'ثبت شده', 'mweb' );
	} elseif ( $has_access && $is_completed ) {
		$class = 'ld_course_grid_price';
		$ribbon_text = __( 'اتمام دوره', 'mweb' );
	} else {
		$class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
	}

   $cat_with_link = '';
   $taxonomy  = 'ld_course_category'; 
   $cat_with_link = get_the_term_list( $course_id, $taxonomy, ' ', '<span class="separator">,</span> ');       
?>
<?php  //echo wp_kses($cat_with_link, 'mweb'); ?>
<div class="product_item clear"> 
	<div class="product_image_area">
		<?php echo mweb_theme_thumbnail::render( 'medium' ); ?>
		
	</div>
	<div class="product_detail_area">
		<h3 class="product_name"><?php mweb_theme_template_part::post_title(); ?></h3>
		
		<div class="product_item_info">
			<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-alt-left"></i></a>
			<div class="price lp_price_loop">
				<span class="amount_p"><?= $price ?></span>
			</div>

		</div>
		<div class="product_item_meta">
			<?php 
				$meta_time = get_post_meta( $course_id, '_product_time', true );
				if( $meta_time ):
				?>
			<div class="item_meta el_product_time">
				<i class="fal fa-clock"></i>
				<span><?php echo mweb_hoursandmins( $meta_time ); ?></span>
			</div>
			<?php endif; ?>
			<?php $student_num = get_post_meta(get_the_ID(), '_student_num', true);
				if(!empty($student_num)):
				?>
			<div class="item_meta el_product_sales">
				<i class="fal fa-users-class"></i>
				<span><?php echo $student_num; ?> </span>
			</div>
			<?php endif; ?>
			<?php if( !empty($ribbon_text ) ): ?>
			<div class="item_meta el_avarage_rate el_ribbon_text">
				<i class="fal fa-user"></i>
				<span><?php echo esc_html($ribbon_text); ?></span>
			</div>
			<?php endif; ?>
			
		</div>
	</div>
</div>