<?php 
$mweb_acc_url = get_permalink( get_option('woocommerce_myaccount_page_id'));
if(is_user_logged_in()):
$current_user = wp_get_current_user();
$mweb_head_logout_url = mweb_theme_util::get_theme_option('mweb_head_logout_url');

$meta_notify = intval(get_user_meta( get_current_user_id() , 'count_notify', true ));
$count_notify = mweb_get_notify_count();
$equal = $count_notify - $meta_notify;

$setting_page = wc_get_endpoint_url('edit-account');
$notify_page = wc_get_endpoint_url('notify');

$lp_profile = get_option('learn_press_profile_page_id');
if( get_the_ID() == $lp_profile ){
	$mweb_acc_url = get_permalink( $lp_profile );
	$current_user = wp_get_current_user();
	$setting_page = learn_press_get_endpoint_url('settings','basic-information',$mweb_acc_url.$current_user->user_login);
	$notify_page = learn_press_get_endpoint_url('notify','',$mweb_acc_url.$current_user->user_login);
}

?>
<header class="user_header">
	<div class="container">
		<div class="row">
			<div class="col-md-3 col-sm-5 col-12">
				<div class="account_head_user">
					<div class="up_small_info">
						<div class="el_img">
							<?php echo get_avatar( $current_user->ID , 45 ); ?>
						</div>
						<span>خوش آمدید</span>
						<a href="<?php echo esc_url($mweb_acc_url); ?>" class="up_small_info_name" title="پنل کاربری"><?php echo $current_user->display_name ; ?></a>
						
					</div>
				</div>
			</div>
			<div class="col-md-9 col-sm-7 col-12 text_align_left">
				<div class="account_head_icon">
					<a class="up_top_notify <?php echo ( $equal > 0 ) ? 'is_active" data-count="'.$equal.'"' : '"'; ?> href="<?php echo esc_url($notify_page); ?>" title="اطلاعیه ها"><i class="fal fa-bell"></i></a>
					<a class="up_top_setting" href="<?php echo esc_url($setting_page); ?>" title="تنظیمات"><i class="fal fa-cog"></i></a>				
					<?php echo '<a href="'.wp_logout_url(esc_url($mweb_head_logout_url)).'" class="up_top_logout" title="خروج از حساب"><i class="fal fa-power-off"></i></a>'; ?>
					<a class="up_top_home" href="<?php echo get_home_url(); ?>"><i class="fal fa-house-flood"></i><span>صفحه نخست</span></a>	
				</div>
			</div>
		</div>
	</div>
</header>

<?php endif; ?>