<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Search Box
 * @since 1.0.0
 */
class Block_Search extends Widget_Base {

	
	public function get_name() {
		return 'block-search';
	}

	
	public function get_title() {
		return __( 'فرم جستجو', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-search';
	}

	
	public function get_categories() {
		return [ 'digiacademy', 'digiacademy_header' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'el_color',
			[
				'label' => __( 'رنگ پس زمینه جستجو', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} form.search_wrap_box' => 'background-color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'el_color_text',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} form.search_wrap_box input' => 'color: {{VALUE}}',
					'{{WRAPPER}} form.search_wrap_box i' => 'color: {{VALUE}}',
				]
			]
		);
		

		$this->end_controls_section();
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<form class="search_wrap_box" id="ajax-search-box" method="get" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
			<i class="fal fa-search"></i>
			<input type="text" id="search-box-key" class="search-field" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" placeholder="کلید واژه مورد نظر ...">
			<button> جستجو </button>
			
			<?php $mweb_search_filter = \mweb_theme_util::get_theme_option( 'search_filter' );
				if ( $mweb_search_filter == true ) {
					echo '<input type="hidden" name="post_type" value="product" />';
				}
			?>
			<div id="search-box-result"></div>
		</form>
		<?php
	}

	
	protected function _content_template() {
		
	}
}
