<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Lession List in Content
 * @since 1.0.0
 */
class Block_Lession extends Widget_Base {

	
	public function get_name() {
		return 'block-lession';
	}

	
	public function get_title() {
		return __( 'سرفصل دوره ها', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-radio';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'list_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		
		$repeater->add_control(
			'list_link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'show_external' => false,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		$repeater->add_control(
			'list_time',
			[
				'label' => __( 'زمان به دقیقه', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
			]
		);
		
		$repeater->add_control(
			'list_free',
			[
				'label' => __( 'رایگان باشد ؟', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$repeater->add_control(
			'list_type',
			[
				'label' => __( 'نوع فایل', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'video',
				'options' => [
					'video'  => __( 'ویدیو', 'mweb' ),
					'file' => __( 'فایل', 'mweb' ),
					'audio' => __( 'صوت', 'mweb' ),
					'custom' => __( 'دیگر', 'mweb' ),
				],
			]
		);
		
		$repeater->add_control(
			'list_show_dl',
			[
				'label' => __( 'نمایش دکمه دانلود', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'list_type!' => ['file'] ]
			]
		);
		
		$repeater->add_control(
			'list_description',
			[
				'label' => __( 'توضیحات', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => __( '', 'mweb' ),
				'placeholder' => __( 'متن مورد نظر ...', 'mweb' ),
			]
		);

		
		$this->add_control(
			'list',
			[
				'label' => __( 'ایتم ها', 'mweb' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		$this->end_controls_section();
		
		
		
		
		$this->end_controls_section();
		
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if(!is_product()){
			return false;
		}
		
		//course_list_title
	
		foreach (  $settings['list'] as $item ) {
			$target = $item['list_link']['is_external'] ? ' target="_blank"' : '';
			$nofollow = $item['list_link']['nofollow'] ? ' rel="nofollow"' : '';
						
			switch($item['list_type']){
				case 'video':
					$icon_t = '<i class="fal fa-play"></i>';
				break;
				case 'audio':
					$icon_t = '<i class="fal fa-compact-disc"></i>';
				break;
				case 'file':
					$icon_t = '<i class="fal fa-file"></i>';
				break;
				default:
					$icon_t = '<i class="fal fa-ellipsis-v-alt"></i>';
			}
			if($item['list_free'] == 'yes'){
				$cr_dl = $item['list_show_dl'] == 'yes' ? '<a class="cr_dl" href="'.esc_url(apply_filters('mweb_private_course_link', $item['list_link']['url'])).'" title="دریافت" ' . $target . $nofollow . '><i class="fal fa-cloud-download-alt"></i></a>' : '';
				if($item['list_type'] == 'video'){
					$cr_title = $item['list_title'].'<span class="free_play">نمایش رایگان</span>';
				}else{
					$cr_title = $item['list_title'];
				}
				
			}else{
				$cr_dl ='<span class="cr_dl"><i class="fal fa-lock-alt"></i></span>';
				$cr_title = $item['list_title'];
			}
			
			$cr_desc = !empty($item['list_description']) ? '<i class="fal fa-angle-down course_arrow"></i>' : '';
			$cr_desc_cls = !empty($item['list_description']) ? 'has_desc' : '';
			$cr_time = '';
			if($item['list_time'])
				$cr_time = '<span class="cr_time"><i class="fal fa-clock"></i>'.mweb_hoursandmins($item['list_time'],'%02d:%02d',true).'</span>';
			if(wc_customer_bought_product( '', get_current_user_id(), get_the_ID() ) && is_user_logged_in() ){
				$cr_dl = $item['list_show_dl'] == 'yes' ? '<a class="cr_dl" href="'.esc_url(apply_filters('mweb_private_course_link', $item['list_link']['url'])).'" title="دریافت" ' . $target . $nofollow . '><i class="fal fa-cloud-download-alt"></i></a>' : '';
				if($item['list_type'] == 'video'){
					$cr_title = $item['list_title'].'<span class="free_play">نمایش</span>';
				}else{
					$cr_title = $item['list_title'];
				}
				
				echo '<div class="course_item is_free '.$cr_desc_cls.'" data-preview="'.esc_attr(apply_filters('mweb_private_course_link', $item['list_link']['url'])).'"><div class="cr_type">'.$icon_t.'</div><h4>'.$cr_title.'</h4>'.$cr_time.$cr_dl.$cr_desc.'</div>';
				if(!empty($item['list_description'])){
					echo '<div class="course_item_content">'.esc_html($item['list_description']).'</div>';
				}
			}else{
				echo '<div class="course_item '.$cr_desc_cls.' '.($item['list_free'] == 'yes' ? 'is_free" data-preview="'.esc_attr(apply_filters('mweb_private_course_link', $item['list_link']['url'])).'"' : '"').'><div class="cr_type">'.$icon_t.'</div><h4>'.$cr_title.'</h4>'.$cr_time.$cr_dl.$cr_desc.'</div>';
				if(!empty($item['list_description'])){
					echo  $item['list_free'] == 'yes' ? '<div class="course_item_content">'.esc_html($item['list_description']).'</div>' : '<div class="course_item_content">'.esc_html__('محتوای این بخش تنها برای خریداران قابل مشاهده است', 'mweb').'</div>';
				}
			}
			
		}

	}

	
	protected function _content_template() {
		
	}
}