<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Featured Hexagon
 * @since 1.0.0
 */
class Block_Featured_Hexagon extends Widget_Base {

	
	public function get_name() {
		return 'block-featured-hexagon';
	}

	
	public function get_title() {
		return __( 'سرویس شش ضلعی', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-call-to-action';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'list_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'list_icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fal fa-box-open',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		$repeater->add_control(
			'list_background',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'fill: {{VALUE}}',
				]
			]
		);
		$repeater->add_control(
			'list_border_color',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'stroke: {{VALUE}}',
				]
			]
		);
		
		$repeater->add_control(
			'list_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} h3' => 'color: {{VALUE}}',
				]
			]
		);
		$repeater->add_control(
			'list_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} i' => 'color: {{VALUE}}',
				]
			]
		);
		$repeater->add_control(
			'list_link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'ایتم ها', 'mweb' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'حالت هاور', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'hover_background',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_hexagon:hover svg' => 'fill: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'hover_border_color',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_hexagon:hover svg' => 'stroke: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'hover_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_hexagon:hover h3' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'hover_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_hexagon:hover i' => 'color: {{VALUE}}',
				]
			]
		);
		
		
		$this->end_controls_section();
		
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( $settings['list'] ) {
			echo '<div class="hexagon_wrap">';
			foreach (  $settings['list'] as $item ) {
				echo '<div class="el_featured_hexagon elementor-repeater-item-' . $item['_id'] . '">';
					if(!empty($item['list_link']['url'])){
						$target = $item['list_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $item['list_link']['nofollow'] ? ' rel="nofollow"' : '';
						echo '<a href="' . esc_url( $item['list_link']['url'] ) . '" title="' . esc_attr( $item['list_title'] ) . '" ' . $target . $nofollow . '>';
					}
					echo '<svg viewBox="0 0 110.74 123.18"><path d="M307.58,232.84l-40.2-23.21a14.17,14.17,0,0,1-7.09-12.27V150.94a14.17,14.17,0,0,1,7.09-12.27l40.2-23.21a14.17,14.17,0,0,1,14.17,0L362,138.67A14.17,14.17,0,0,1,369,150.94v46.42A14.17,14.17,0,0,1,362,209.63l-40.2,23.21A14.17,14.17,0,0,1,307.58,232.84Z" transform="translate(-259.29 -112.56)"></path></svg>';
					if(!empty($item['list_icon'])){
					echo '<i class="'.$item['list_icon'].'"></i>';
					}
					echo '<h3>'.$item['list_title'].'</h3>';
					if(!empty($item['list_link']['url'])){
						echo '</a>';
					}
				echo '</div>';
			}
			echo '</div>';
		}
		
		
	}

	
	protected function _content_template() {
		
	}
}
