<?php
/**
 * The template for displaying all single teacher
 * @package mweb themes
 */
 
//get header
get_header();
?>
<?php

//create single class
$mweb_single_class   = array();
$mweb_single_class[] = 'is-single';
$mweb_single_class[] = 'post_wrapper';
$mweb_single_class   = implode( ' ', $mweb_single_class );


mweb_theme_template_part::open_page_wrap( 'single-wrap ', 'none' );
//mweb_theme_single::mweb_get_breadcrumbs();
mweb_theme_template_part::open_page_inner( 'single-inner', 'none');
mweb_theme_single_layout::open_single_wrap( $mweb_single_class );

//take metafield value            
$description 	 = get_post_meta( get_the_ID(), '_description', true );  
$phone           = get_post_meta( get_the_ID(), '_phone', true );
$email           = get_post_meta( get_the_ID(), '_email', true );
$website         = get_post_meta( get_the_ID(), '_website', true );
$facebook        = get_post_meta( get_the_ID(), '_facebook', true );
$twitter         = get_post_meta( get_the_ID(), '_twitter', true );
$linkedin        = get_post_meta( get_the_ID(), '_linkedin', true );
$instagram       = get_post_meta( get_the_ID(), '_instagram', true );
$telegram        = get_post_meta( get_the_ID(), '_telegram', true );
$whatsapp        = get_post_meta( get_the_ID(), '_whatsapp', true );
$skill_title     = get_post_meta( get_the_ID(), '_skill_title', true );
$skill_value     = get_post_meta( get_the_ID(), '_skill_value', true );

while ( have_posts() ) : the_post();
				
?>

<div class="row">
<div class="col-lg-4 col-md-5 col-12">
	<div class="thr-image"><?php the_post_thumbnail(); ?></div>
	<div class="thr-informations">

		<h4>پل های ارتباطی</h4>
		<ul class="thr-info">

			<?php if($website):?>
				<li class="website">
					<i class="fal fa-globe"></i>
					<a href="<?php echo esc_attr( $website ); ?>" target="_blank"><?php  echo esc_html( $website ); ?></a>
				</li>
			<?php endif;?>
			<?php if($email):?>
				<li class="email">
					<i class="fal fa-mailbox"></i>
					<a href="mailto:<?php echo esc_attr( $email ); ?>"><?php  echo esc_html( $email ); ?></a>
				</li>
			<?php endif;?>
			<?php if($phone):?>
				<li class="phone">
					<i class="fal fa-phone"></i>
					<?php echo esc_html( $phone ); ?>
				</li>
			<?php endif; ?>

		</ul>

		<ul class="thr-social-info">
			<?php if($telegram):?>
				<li><a href="<?php  echo esc_url( $telegram ); ?>" target="_blank"><i class="fab fa-telegram"></i></a></li>
			<?php endif;?>
			<?php if($whatsapp):?>
				<li><a href="<?php  echo esc_url( $whatsapp ); ?>" target="_blank"><i class="fab fa-whatsapp"></i></a></li>
			<?php endif;?>
			<?php if($instagram):?>
				<li><a href="<?php  echo esc_url( $instagram ); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
			<?php endif;?>
			<?php if($linkedin):?>
				<li><a href="<?php  echo esc_url( $linkedin ); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
			<?php endif;?>
			<?php if($twitter):?>
				<li><a href="<?php  echo esc_url( $twitter ); ?>" target="_blank"><i class="fab fa-twitter"></i></a></li>
			<?php endif;?>
			<?php if($facebook):?>
				<li><a href="<?php  echo esc_url( $facebook ); ?>" target="_blank"><i class="fab fa-facebook"></i></a></li>
			<?php endif;?>
		</ul>
	</div>
 
</div>
<div class="col-lg-8 col-md-7 col-12">
	<h2 class="thr-title"><?php the_title(); ?></h2> 
	<?php if(!empty($description)): ?>
		<div class="thr-desc">
			<?php echo wpautop($description); ?>
		</div>
	<?php endif; ?>
	
	<?php if(!empty($skill_title) && !empty($skill_title[0])): ?>
	<h3 class="thr-title-skills">مهارت ها</h3> 
	<div class="thr-skill"> 
		<div class="row">       
			<?php foreach ( $skill_title as $key => $value ) {
				if(empty($value))
					continue;
				?>
				<div class="col-md-6">
					<div class="thr-progress">
						<div class="thr-progress-title">
							<span class="pb-label"><?php echo esc_html($value); ?></span>
							<span class="pb-percent"><?php echo esc_html($skill_value[$key]); ?></span>
						</div>
						<div class="thr-progress-wrap">
							<div class="thr-progress-bar" style="width:<?php echo esc_attr($skill_value[$key]); ?>%"></div>
						</div>
					</div>
				</div>
			<?php } ?>         
		</div>
	</div>
	<?php endif; ?>
				
	<?php get_template_part( 'templates/single/block', 'entry' ); ?>

				
</div>



<?php endwhile; ?>
<?php
mweb_theme_single_layout::close_single_wrap();
mweb_theme_template_part::close_page_inner();
mweb_theme_template_part::close_page_wrap();


get_footer();