<?php
/**
 * The template for displaying learndash single page *
 */

get_header();

if ( have_posts() ) {
	while ( have_posts() ) {
		the_post();
		mweb_theme_post_view_add();
		
		
		global $post; $post_id = $post->ID;
		$course_id = $post_id;
		$user_id   = get_current_user_id();
		$current_id = $post->ID;

		$options = get_option('sfwd_cpt_options');
		$currency = null;

		if ( ! is_null( $options ) ) {
			if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
				$currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
		}

		if( is_null( $currency ) )
			$currency = 'تومان';

		$course_options = get_post_meta($post_id, "_sfwd-courses", true);
		$price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'رایگان', 'mweb' );
		$short_description = @$course_options['sfwd-courses_course_short_description'];

		$has_access   = sfwd_lms_has_access( $course_id, $user_id );
		$is_completed = learndash_course_completed( $user_id, $course_id );

		if( $price == '' )
			$price .= __( 'رایگان', 'mweb' );

		if ( is_numeric( $price ) ) {
			if ( $currency == "USD" )
				$price = '$' . $price;
			else
				$price .= ' <span class="woocommerce-Price-currencySymbol">'.$currency.'</span>';
		}

		$class       = '';
		$ribbon_text = '';

		if ( $has_access && ! $is_completed ) {
			$class = 'ld_course_grid_price ribbon-enrolled';
			$ribbon_text = __( 'شما دانشجوی این دوره هستید', 'mweb' );
		} elseif ( $has_access && $is_completed ) {
			$class = 'ld_course_grid_price';
			$ribbon_text = __( 'شما دوره را به اتمام رسانده اید', 'mweb' );
		} else {
			$class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
		}
	
	

?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="single_title_product">
				<div class="container">
					<?php mweb_theme_single::mweb_get_breadcrumbs(false, '<i class="fal fa-map"></i>', true); ?>
					<h1 class="product_title entry-title"><?php the_title(); ?></h1>
					<?php
					$p_subtitle = get_post_meta( get_the_ID(), '_product_subtitle', true );
					if(!empty($p_subtitle)){
						echo '<span class="sub_head">'.$p_subtitle.'</span>';
					}
					mweb_wishlist::mweb_single_add_wishlist(get_the_ID(),'sfwd-courses');
					?>
				</div>
				<svg width="1170pt" height="68pt" viewBox="0 0 1170 68" version="1.1"
					xmlns="http://www.w3.org/2000/svg">
					<g>
						<path fill="#fbfbfc" opacity="1.00" d=" M 1101.56 0.00 L 1170.00 0.00 L 1170.00 68.00 L 0.00 68.00 L 0.00 67.05 C 92.19 53.41 184.99 44.41 277.83 36.55 C 465.20 21.18 653.03 12.09 840.92 6.07 C 927.78 3.29 1014.68 1.58 1101.56 0.00 Z"></path>
					</g>
				</svg>
			</div>
			
			<div class="container single_wrap">
				<div id="post-<?php the_ID(); ?>" <?php post_class( 'product' ); ?>>
					<div class="primary_block row clearfix">
						<div class="col-lg-9 col-md-12 col-12 single_pright">
							
							<?php mweb_woocommerce::mweb_render_product_videos_preview(); ?>
		
							<div class="ld_content">
								<div class="entry entry-content">
									<?php
										the_content();
									?>
								</div>
							</div>
							
							<?php mweb_related_ld_courses(); ?>
						</div>
						<div class="col-lg-3 col-md-12 col-12 single_pleft">
							<div class="box_wrap entry-summary">
								<div class="sell_course">
									<strong>قیمت :</strong>
									<p class="price">
										<span class="woocommerce-Price-amount amount">
											<?= $price ?>
										</span>
									</p>
								</div>
								 <div class="course-price">
                                    <?php if ( $post->post_type == 'sfwd-courses' && !empty($ribbon_text) ) : ?>
                                        <div class="bought_show <?php echo esc_attr( $class ); ?>">
                                            <?php echo esc_attr( $ribbon_text ); ?>
                                        </div>
                                    <?php endif; ?>
									<?php //echo do_shortcode('[ld_course_info]'); ?>
									<?php echo do_shortcode('[learndash_payment_buttons course_id="'.$current_id.'"]'); ?>
                                </div>   
							</div>
							<div class="box_wrap wc_additional_information">
								<div class="level_of_edu leve_is_2">
									<i class="fal fa-star"></i>
									<i class="fal fa-star"></i>
									<i class="fal fa-star"></i>
									<span>سطح آموزش متوسط</span>
								</div>
								<?php $student_num = get_post_meta(get_the_ID(), '_student_num', true);
									if(!empty($student_num)):
								?>
								<div class="total_sales"><i class="fal fa-user-graduate"></i> تعداد دانشجو : <span><?= $student_num ?></span></div>
								<?php endif; ?>
								<div class="single_product_meta">
									<?php 
									$lesson = learndash_get_course_steps( get_the_ID(), array('sfwd-lessons') );
									$topic  = learndash_get_course_steps( get_the_ID(), array( 'sfwd-topic') );

									 $quiz_args = new wp_Query(array(	
										'post_type' => 'sfwd-quiz',							
										'meta_query' => array( 
											array( 'key' => 'course_id', 
											'value' => get_the_ID()
										))						
									));							
									$quiz = $quiz_args->post_count;  ?>
									<span class="custom_meta imeta_lesson">دروس: <i><?php echo count($lesson);?></i></span>
									<span class="custom_meta imeta_topic">موضوعات: <i><?php echo count($topic);?></i></span>
									<span class="custom_meta imeta_quiz">آزمون ها: <i><?php echo esc_html($quiz);?></i></span>
									<?php 
										mweb_add_product_time();
										mweb_add_publish_date();
										mweb_add_modified_date();
										mweb_add_number_of_views();
									?>
								</div>
								<div class="course_excerpt">
									<?php echo $short_description; ?>
								</div>
							</div>
							<?php mweb_the_rules_and_benefit_fixed(); ?>
							<?php if ( is_active_sidebar( 'ld_sidebar' ) ) : ?>
								<?php dynamic_sidebar( 'ld_sidebar' ); ?>
							<?php else : ?>
								<!-- Time to add some widgets! -->
							<?php endif; ?>

							<div class="box_wrap wc_product_meta_share">
								<?php
									$term_list = get_the_term_list( get_the_ID(), 'ld_course_category', '', ', ', '' ); 
									if ( $term_list ) {
										printf( '<span class="posted_in">دسته: %s</span>', str_replace(',' ,'' ,$term_list) );
									} 
									
									$term_list_tag = get_the_term_list( get_the_ID(), 'ld_course_tag', '', ', ', '' ); 
									if ( $term_list_tag ) {
										printf( '<span class="tagged_as">برچسب: %s</span>', str_replace(',' ,'' ,$term_list_tag) );
									}
								?>
								<?php mweb_theme_template_part::get_product_share(); ?>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		
		

		</main><!-- #main -->
	</div><!-- #primary -->
<?php

	}
}

get_footer();
