<?php
/*
  Template name: سبد خرید و پرداخت
 */

get_header();
?>

<div class="container-wrap page-shopping-cart">
    <div class="container">
        <div class="order-steps">
			<?php if (function_exists('is_wc_endpoint_url')) : ?>
				<?php if (!is_wc_endpoint_url('order-received')) : ?>
					<div class="checkout-breadcrumb">
						<div class="title-cart">
							<i>01</i>
							<a href="<?php echo esc_url(wc_get_cart_url()); ?>">
								<h4><?php esc_html_e('سبد خرید', 'mweb'); ?></h4>
								<p><?php esc_html_e('فهرست اقلام خود را مدیریت کنید', 'mweb'); ?></p>
							</a>
							
						</div>

						<div class="title-checkout">
							<i>02</i>
							<a href="<?php echo esc_url(wc_get_checkout_url()); ?>">
								<h4><?php esc_html_e('جزئیات پرداخت', 'mweb'); ?></h4>
								<p><?php esc_html_e('صورتحساب خود را پرداخت کنید', 'mweb'); ?></p>
							</a>
						</div>
						
						<div class="title-thankyou">
							<i>03</i>
							<h4><?php esc_html_e('تکمیل سفارش', 'mweb'); ?></h4>
							<p><?php esc_html_e('سفارش خود را مرور و ثبت کنید', 'mweb'); ?></p>
						</div>
					</div>
				<?php else : ?>
					<div class="checkout-breadcrumb">
						<div class="title-cart">
							<i>01</i>
							<a href="#">
								<h4><?php esc_html_e('سبد خرید', 'mweb'); ?></h4>
								<p><?php esc_html_e('فهرست اقلام خود را مدیریت کنید', 'mweb'); ?></p>
							</a>
						</div>
						<div class="title-checkout">
							<i>02</i>
							<a href="#">
								<h4><?php esc_html_e('جزئیات پرداخت', 'mweb'); ?></h4>
								<p><?php esc_html_e('صورتحساب خود را پرداخت کنید', 'mweb'); ?></p>
							</a>
							
						</div>
						<div class="title-thankyou mweb-order-complete">
							<i>03</i>
							<h4><?php esc_html_e('تکمیل سفارش', 'mweb'); ?></h4>
							<p><?php esc_html_e('سفارش خود را مرور و ثبت کنید', 'mweb'); ?></p>
						</div>
					</div>
				<?php endif; ?>
			<?php else : ?> 
				<div class="checkout-breadcrumb">
					<div class="title-cart">
						<span>01</span>
						<p><?php esc_html_e('سبد خرید', 'mweb'); ?></p>
					</div>
					<div class="title-checkout">
						<span>02</span>
						<p><?php esc_html_e('جزئیات پرداخت', 'mweb'); ?></p>
					</div>
					<div class="title-thankyou">
						<span>03</span>
						<p><?php esc_html_e('تکمیل سفارش', 'mweb'); ?></p>
					</div>
				</div>
			<?php endif; ?>
        </div>
    </div>
    <div class="container">
        <div id="content" class="blog_body <?php echo is_checkout() ? 'mweb_checkout_page': ''; ?>">
            <?php
            while (have_posts()) :
                the_post();
                the_content();
            endwhile;
            ?>
        </div>
    </div>
</div>

<?php
get_footer();
