<?php
/**
 * this file config meta boxes for theme
 */

 // Re-define meta box path and URL
$mweb_template_directory = get_template_directory();

//including config file
require_once $mweb_template_directory . '/metaboxes/metabox_panels/panel_sidebar.php';
require_once $mweb_template_directory . '/metaboxes/metabox_panels/panel_comment.php';
require_once $mweb_template_directory . '/metaboxes/metabox_panels/panel_post_type.php';


if ( ! function_exists( 'mweb_theme_meta_boxes_config' ) ) {

	 // Change {$redux_opt_name} to your opt_name
    add_action("redux/metaboxes/shop_options/boxes", "mweb_theme_meta_boxes_config");

	/**-------------------------------------------------------------------------------------------------------------------------
	 * @return array
	 * meta box config
	 */
	function mweb_theme_meta_boxes_config($metaboxes) {

		
		
		
		 
		$metabox_comment = array();
		$metabox_comment[] = mweb_metabox_comment_box();

		$metabox_sidebar = array();
		$metabox_sidebar[] = mweb_metabox_sidebar();

		$metabox_gallery = array();
		$metabox_gallery[] = mweb_metabox_post_gallery();

		$metabox_video = array();
		$metabox_video[] = mweb_metabox_post_video();

		$metabox_slider = array();
		$metabox_slider[] = mweb_metabox_slider();

		$metabox_notify = array();
		$metabox_notify[] = mweb_metabox_notify();
		
		$metabox_teacher = array();
		$metabox_teacher[] = mweb_metabox_teacher();
		
		$metabox_learndash = array();
		$metabox_learndash[] = mweb_metabox_learndash();



		$metaboxes = array();
		
		
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_comment_box_options',
            'title'         => __( 'تنظیمات دیدگاه', '' ),
            'post_types'    => array( 'post', 'page' ),
            //'page_template' => array('page-test.php'), // Visibility of box based on page template selector
            'position'      => 'side', // normal, advanced, side
            'priority'      => 'default', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_comment ,
        );
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_sidebar_options',
            'title'         => __( 'تنظیمات سایدبار', '' ),
            'post_types'    => array( 'post', 'page' ),
            'position'      => 'side', // normal, advanced, side
            'priority'      => 'default', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_sidebar ,
        );
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_gallery_options',
            'title'         => __( 'تنظیمات گالری', '' ),
            'post_types'    => array( 'post'),
            'position'      => 'normal', // normal, advanced, side
            'priority'      => 'high', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_gallery ,
        );
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_video_options',
            'title'         => __( 'تنظیمات ویدیو', '' ),
            'post_types'    => array( 'post'),
            'position'      => 'normal', // normal, advanced, side
            'priority'      => 'high', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_video ,
        );
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_slider_options',
            'title'         => __( 'اسلایدر', '' ),
            'post_types'    => array( 'slider'),
            'position'      => 'normal', // normal, advanced, side
            'priority'      => 'high', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_slider ,
        ); 
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_notify_options',
            'title'         => __( 'تنظیمات', '' ),
            'post_types'    => array( 'notify'),
            'position'      => 'side', // normal, advanced, side
            'priority'      => 'high', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_notify ,
        );
		
		$metaboxes[] = array(
            'id'            => 'mweb_metabox_teacher_options',
            'title'         => __( 'مدرس', '' ),
            'post_types'    => array( 'teacher'),
            'position'      => 'normal', // normal, advanced, side
            'priority'      => 'high', // high, core, default, low - Priorities of placement
            'sections'      => $metabox_teacher ,
        ); 
		
		if(is_learndash_activated()){
			$metaboxes[] = array(
				'id'            => 'mweb_metabox_learndash_options',
				'title'         => __( 'تنظیمات', '' ),
				'post_types'    => array( 'sfwd-courses'),
				'position'      => 'normal', // normal, advanced, side
				'priority'      => 'high', // high, core, default, low - Priorities of placement
				'sections'      => $metabox_learndash ,
			);
		}

		

		return $metaboxes;
	}
};




