<?php
/**
 * Template for displaying thumbnail of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/thumbnail.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $post;
$course      = learn_press_get_course();
$video_embed = $course->get_video_embed();

if ( $video_embed ) {
	?>
    <div class="box_wrap product_thumbnail course-video"><?php echo $video_embed; ?></div>
	<?php
}

$video_preview = get_post_meta( get_the_ID(), '_video_preview', true ); 

if ( (! has_post_thumbnail() && !$video_preview) || $video_embed ) {
	return;
}

$video_player = mweb_theme_util::get_theme_option('mweb_video_player');
?>

<div class="box_wrap product_thumbnail player_is_<?= $video_player ?>">
	<?php
		if(!empty($video_preview)){
			$product_thumb_src = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );
			if($video_player == 'videojs'){
				echo '<video class="video-js vjs-default-skin" id="preview_product" controls="controls" width="852" height="479" poster="'.$product_thumb_src[0].'"><source src="'.esc_attr(apply_filters('mweb_private_course_link', $video_preview)).'" type="video/mp4" title="mp4"><p>مرورگر شما از پخش ویدیو پشتیبانی نمی کند</p></video>';
			}else{
				echo '<video style="display:none;width:100%;height:100%;" oncontextmenu="return false;" id="preview_product" controls="controls" width="852" height="479" poster="'.$product_thumb_src[0].'"><source src="'.esc_attr(apply_filters('mweb_private_course_link', $video_preview)).'" type="video/mp4" title="mp4"><p>مرورگر شما از پخش ویدیو پشتیبانی نمی کند</p></video>';
			}
		}elseif(has_post_thumbnail()){
			$image_title   = get_the_title( get_post_thumbnail_id() ) ? esc_attr( get_the_title( get_post_thumbnail_id() ) ) : '';
			$image_caption = get_post( get_post_thumbnail_id() ) ? esc_attr( get_post( get_post_thumbnail_id() )->post_excerpt ) : '""';
			$image_link    = wp_get_attachment_url( get_post_thumbnail_id() );
			$image         = get_the_post_thumbnail( $post->ID, apply_filters( 'single_course_image_size', 'single_course' ), array(
				'title' => $image_title,
				'alt'   => $image_title
			) );

			echo apply_filters(
				'learn_press_single_course_image_html',
				sprintf( '<a href="%s" itemprop="image" class="learn-press-single-thumbnail" title="%s">%s</a>', $image_link, $image_caption, $image ),
				$post->ID
			);
		}
	?>
</div>
