<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-single-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

if ( post_password_required() ) {
	echo get_the_password_form();

	return;
}

echo '<div class="container single_wrap">';
 
/**
 * @deprecated
 */
do_action( 'learn_press_before_main_content' );
do_action( 'learn_press_before_single_course' );
do_action( 'learn_press_before_single_course_summary' );

/**
 * @since 3.0.0
 */
do_action( 'learn-press/before-main-content' );

do_action( 'learn-press/before-single-course' );


$course = LP_Global::course();
//print_r($course);
$user   = LP_Global::user();

?>
<div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div id="learn-press-course" class="primary_block row clearfix single_product_rsidebar">
		<div class="col-lg-9 col-md-12 col-12 single_pright">
			<?php
				/**
				 * @since 3.0.0
				 *
				 * @see learn_press_single_course_summary()
				 */
				//do_action( 'learn-press/single-course-summary' );
			?>
			<?php if ( learn_press_is_learning_course() ) {
				learn_press_get_template( 'single-course/content-learning.php', array( 'course' => $course ) );
			} else {
				learn_press_get_template( 'single-course/content-landing.php' );
			} ?>
		</div>	
		<div class="col-lg-3 col-md-12 col-12 single_pleft">
			<?php do_action('mweb_course_sidebar'); ?>
		</div> 
	</div> 
</div><!-- /.cource -->	
<?php

/**
 * @since 3.0.0
 */
do_action( 'learn-press/after-main-content' );

do_action( 'learn-press/after-single-course' );

/**
 * @deprecated
 */
do_action( 'learn_press_after_single_course_summary' );
do_action( 'learn_press_after_single_course' );
do_action( 'learn_press_after_main_content' );

echo '</div><!-- ./ container -->';