<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$user = LP_Global::user();

// learpress
$course = LP_Global::course();
$course_id = get_the_ID();
?>

<li id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php

    // @since 3.0.0
    do_action( 'learn-press/before-courses-loop-item' );
    ?>
	
	<div class="product_item clear"> 
		<div class="product_image_area">
			<a class="product_image" href="<?php the_permalink(); ?>">
				<?php echo $course->get_image( 'course_thumbnail' ); ?>
			</a>
			<?php mweb_course_off_percentage_loop(); ?>
		</div>
		<div class="product_detail_area">
			<h3 class="product_name"><?php mweb_theme_template_part::post_title(); ?></h3>
			
			<div class="product_item_info">
				<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-alt-left"></i></a>
				<div class="price lp_price_loop">
					
					<?php if ( $course->has_sale_price() ) { ?>
						<ins><span class="amount"><?php echo $course->get_price_html(); ?></span></ins>
						<del><span class="amount"><?php echo $course->get_origin_price_html(); ?></span></del>
					<?php }else{ ?>
						<span class="amount_p"><?php echo $course->get_price_html(); ?></span>
					<?php } ?>
				</div>

			</div>
			<div class="product_item_meta">
				<?php 
					$meta_time = mweb_duration_time_calculator($course_id);
					$meta_rating = mweb_get_single_course_average_rating($course_id,false);
				?>
				<?php if( $meta_rating ): ?>
				<div class="item_meta el_avarage_rate">
					<i class="fal fa-star"></i>
					<span><?php echo $meta_rating; ?></span>
				</div>
				<?php endif; ?>
				<?php if( $meta_time ): ?>
				<div class="item_meta el_product_time">
					<i class="fal fa-clock"></i>
					<span><?php echo $meta_time; ?></span>
				</div>
				<?php endif; ?>
				
				<div class="item_meta el_product_sales">
					<i class="fal fa-users-class"></i>
					<span><?php echo intval($course->count_students());?></span>
				</div>
			</div>
			<div class="meta_teacher"><i class="fal fa-chalkboard-teacher"></i><span>مدرس</span><?php echo ent2ncr($course->get_instructor_html()); ?></div>
		</div>
	</div>
	
	<?php

    // @since 3.0.0
	do_action( 'learn-press/after-courses-loop-item' );

    ?>

</li>