<?php
/**
 * this file render dynamic css for theme
 */

//add css to header
//add_action( 'wp_head', 'mweb_theme_dynamic_css', 99 );
add_action( 'wp_enqueue_scripts', 'mweb_theme_dynamic_css' );

/**
 * @return string
 * this file get options and create css code as string
 */
if ( ! function_exists( 'mweb_theme_dynamic_css' ) ) {
	function mweb_theme_dynamic_css() {

		//get cache
		//	$mweb_dynamic_css_cache = get_option( 'mweb_theme_dynamic_css_cache', '' );

		if ( empty( $mweb_dynamic_css_cache ) ) {
			$str = '';
			//$str .= '<style type="text/css" media="all">';

			$color_main = mweb_theme_util::get_theme_option( 'color_main' );

			$color_sec = mweb_theme_util::get_theme_option( 'color_sec' );
			
			$color_1 = mweb_theme_util::get_theme_option( 'color1' ); // bg
			$color_2 = mweb_theme_util::get_theme_option( 'color2' ); // badge
			
			$color_3 = mweb_theme_util::get_theme_option( 'color3' ); // color footer
			
			$color_5 = mweb_theme_util::get_theme_option( 'color5' ); // add to basket
			

			
			
			$body_background = mweb_theme_util::get_theme_option( 'mweb-body-pat' ); //  body background
			//$header_background = mweb_theme_util::get_theme_option( 'mweb-head-pat' ); //  header background
			$footer_background = mweb_theme_util::get_theme_option( 'mweb-footer-pat' ); //  footer background


			//$under_construction_background = mweb_theme_util::get_theme_option( 'under_construction_background' ); //  under construction background
			
			$mweb_offer_pat = mweb_theme_util::get_theme_option( 'mweb_offer_pat' ); //  offer background
			$mweb_offer_color = mweb_theme_util::get_theme_option( 'mweb_offer_color' ); //  offer text color


			//$mweb_product_title_style = mweb_theme_util::get_theme_option( 'mweb_product_title_style' ); //  product title style


			

			
			/* ----------------------------- color main --------------------------------- */
			if(!empty($color_main)){
				
				$str .= '.notify_item .el_more:hover,.ajax-filter-link.is-active:before,.title-cart i,.deal_timer_single .product-date>div:last-child span.no,.contact_social_wrap a:before,.get_in_touch .location:before,.woo_myaccount_login>ul>li.active a, .woo_myaccount_login>ul>li:hover a, .title-checkout i, .title-thankyou i,.product_item_info a,.morder_item:hover span.or_view,.wc_product_meta_share .posted_in a:hover,.pagination-wrap .page-numbers.current,.tagcloud a:hover,.download_box a,.woocommerce-pagination ul.page-numbers, .pagination ul.page-numbers,.woocommerce .widget_price_filter .ui-slider .ui-slider-range,.tb_price.select h5,.tb_price:hover .tb_btn, .tb_price.select .tb_btn,.btn.btn-shortcode:hover,.btn.btn-shortcode:focus, .wc_product_meta_share .tagged_as a:hover,.mejs-overlay-button,.comments-area>ul li.comment>article .comment-top .comment-meta .action-link a:hover,.mweb-body .mejs-controls .mejs-time-rail .mejs-time-current, .mweb-body .mejs-controls .mejs-time-rail .mejs-time-handle, .mweb-body .mejs-horizontal-volume-slider .mejs-horizontal-volume-current, .mweb-body .mejs-controls .mejs-time-rail .mejs-time-float, .mweb-body .mejs-controls .mejs-sourcechooser-button .mejs-sourcechooser-selector ul li input:checked + label, .mweb-body .mejs-controls .mejs-sourcechooser-button .mejs-sourcechooser-selector ul li:hover label,.menu_wrapper,.widget_search .widget-content>form button,.gototop:hover,.namad_slider_wrap .owl-dots .owl-dot.active span,.contact_item.email i,.ajax-filter-link:not(.is-active):hover,.item_most:hover:before,.list_blog_item:hover .read_more,.block-title .view_more i,.mweb-drop-down .second .inner ul li a:hover .item_text:after,.mweb-drop-down .wide .second .inner>ul>li.sub:before,.blog_post_grid .blog_post_foot .post_format i,.post_format_i,.mweb-swiper-next:hover, .mweb-swiper-prev:hover,.btn:hover, .comment-respond #submit:hover, #searchform #searchsubmit:hover, input[type="submit"]:hover, input[type="button"]:hover, .btn:focus, .comment-respond #submit:focus, #searchform #searchsubmit:focus, input[type="submit"]:focus, input[type="button"]:focus,.woocommerce .type-product.product-type-variable form.cart.variations_form table.variations td.value .option.text:hover span,.woocommerce .type-product.product-type-variable form.cart.variations_form table.variations td.value .option.text.selected span,.entry-content .btn:not(.btn-shortcode):hover, .entry-content input[type="submit"]:hover, .entry-content input[type="button"]:hover, .entry-content .button:not(.compare):hover, .entry-content button:hover, .woocommerce-button:hover, .button:hover ,.footer_type2 .gototop ,.product_item_info a.file_read_more ,.product_item_info a.product_read_more ,.woocommerce-account .woocommerce-MyAccount-navigation ,.account_head_user, .tabs_three .wc-tabs li.active a, .fixed_elm_btn, .nav_elm_list li a:after, .vjs-default-skin .vjs-big-play-button, .thr-progress .thr-progress-bar,.thr-progress .pb-percent:after, .teacher-social{ background-color: '.$color_main.'; }';
				
				$str .= 'blockquote span,.deal_timer_single .deal-text span,.contact_w i,.user_info_warp h1 span,.accordion-item-content li:before,.swiper-wrap-visible .mweb-swiper-next:hover,.swiper-wrap-visible .mweb-swiper-prev:hover,.blog-mweb-caption li:before ,.wc-tabs>li a:before,.download_box .download_box_title i,.widget_product_categories .product-categories li.current-cat-parent>div>a, .widget_product_categories .product-categories li.current-cat>div>a,.widget_product_categories .product-categories li .accr_header a:hover,.widget_product_categories .product-categories li .accr_header.open>a,.block-title.no_black .title i,.ul_tab .active i,.contact_item.phone strong,.list_blog_item .post_meta div span,.price .woocommerce-Price-amount,.top_menu ul li a:hover ,.mweb-body .course_info_buy .course-price .price, .product_acc_title.active:after, .thr-social-info a:hover, .thr-informations h4, .woocommerce ul.cart_list li .amount, .woocommerce ul.product_list_widget li .amount{ color: '.$color_main.' }';
								
				$str .= '.mweb-body .mejs-controls .mejs-time-rail .mejs-time-float,.widget_product_categories .product-categories li .accr_header .btn_accor .ac-tongle:hover,.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .timeline-posts li .meta:before{ border-color: '.$color_main.' }';
												
				$str .= '.woocommerce-MyAccount-navigation ul li.is-active:after{ border-left-color: '.$color_main.' }';
				
				$str .= '.notify_item strong{ border-right-color: '.$color_main.' }';
				
				$str .= '.mweb-body .mejs-controls .mejs-time-rail .mejs-time-float-corner,.mweb-drop-down .second .inner > ul, .mweb-drop-down li.narrow .second .inner ul ,.woo_myaccount_login, .tabs_three .wc-tabs li.active a::after{ border-top-color: '.$color_main.' }';
				
				$str .= '.mweb-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active{ box-shadow: 0 0 0 2px '.$color_main.'; }';
				
				$str .= '.tabs_one .wc-tabs li.active a{ box-shadow: inset 0 3px 0 '.$color_main.'; }';
				
				$str .= '.footer_back svg { fill: '.$color_main.'; }';
				
				if(is_learnpress_activated()){
					$str .= '.learn-press-message:before, body #learn-press-profile-nav, .widget-footer a:before{ background-color: '.$color_main.'; }';
					$str .= '.body #learn-press-profile-nav .tabs > li.active:after{ border-left-color: '.$color_main.'; }';
					$str .= '.mweb-body .course-tab-panel-curriculum .course-curriculum ul.curriculum-sections .section-content .course-item .section-item-link:active ,..mweb-body .course-tab-panel-curriculum .course-curriculum ul.curriculum-sections .section-content .course-item .section-item-link:hover, body .course-item-nav .prev span, body .course-item-nav .next span, body .course-curriculum ul.curriculum-sections .section-content .course-item.current a, body .course-item-nav .prev span:before, body .course-item-nav .next span:before, body .course-curriculum ul.curriculum-sections .section-content .course-item.current a:before, .product_item .product_detail_area .price .amount_p, .lp_price_loop ins>span{ color: '.$color_main.'; }';
				}
								
			
			}
			
			/* ----------------------------- color sec --------------------------------- */
			if(!empty($color_sec)){

				$str .= '.featured_label,.product_item .product-date>div:last-child span.no,.account_action form input[type="submit"] ,.learn-press-progress .progress-bg .progress-active{ background-color: '.$color_sec.'; }';
				
				$str .= '.tel_head strong{ color: '.$color_sec.'; }';
				
				$str .= '.timeline-posts li .meta:before { border-color: '.$color_sec.'; }';
								

			}


		
			/* ----------------------------- color 1 --------------------------------- */
			if(!empty($color_1)){
				$str .= 'body ,.block-title .title,.block-ajax-filter-wrap ,.el_loz_desc:after, .pfile .product_item_info:before{ background-color: '.$color_1.'; }';
				$str .= '.blog_post_grid .blog_post_foot .post_format ,.footer_type2 .gototop{ border-color: '.$color_1.'; }';
				$str .= '.user_info_warp:before, .user_info_warp:after{ color: '.$color_1.'; }';
			}
			
			/* ----------------------------- color 2 --------------------------------- */
			if(!empty($color_2)){
				$str .= '.product_label{ background-color: '.$color_2.'; }';
				$str .= '.info_box i{ color: '.$color_2.'; }';
				$str .= '.product_label:after{ border-bottom-color: '.$color_2.'; }';
			}
		    

			
			
			/* ----------------------------- color 3 --------------------------------- */
			if(!empty($color_3))
		    $str .= '.footer_wrap { background-color: '.$color_3.'; }';		

		
			/* ----------------------------- color 5 --------------------------------- */
			if(!empty($color_5))
		    $str .= '.woocommerce .entry-summary .cart .single_add_to_cart_button, .lp-button.button-purchase-course, .sticky_add_to_cart .single_add_to_cart_button{ background-color: '.$color_5.'; }';		
			
			
			
			
			/* ----------------------------- body background --------------------------------- */

			if( !empty($body_background) && !empty($body_background['background-image']) ){
				$str .= 'body{ background-image: url('.$body_background['background-image'].'); background-position: '.$body_background['background-position'].'; background-repeat: '.$body_background['background-repeat'].'; background-size: '.$body_background['background-size'].'; }';
			}
			
			
			/* ----------------------------- head background --------------------------------- */

			/* if( !empty($header_background) && !empty($header_background['background-image']) ){
				$str .= '.logo_wrap , .full_header_wrap{ background-image: url('.$header_background['background-image'].');	background-position: '.$header_background['background-position'].';	background-repeat: '.$header_background['background-repeat'].';	background-size: '.$header_background['background-size'].';	}';
			} */


			/* ----------------------------- footer background --------------------------------- */

			if(!empty($footer_background) && !empty($footer_background['background-image'])){
				$str .= '.footer_wrap{ background-image: url('.$footer_background['background-image'].'); background-position: '.$footer_background['background-position'].'; background-repeat: '.$footer_background['background-repeat'].'; background-size: '.$footer_background['background-size'].'; }';
			}
			
			
			/* ----------------------------- header alert --------------------------------- */

			if( !empty($mweb_offer_pat) ){
				$str .= '.header_alert{ background-color:'.$mweb_offer_pat['background-color'].';';
				if(!empty($mweb_offer_pat['background-image']))
				$str .= ' background-image: url('.$mweb_offer_pat['background-image'].'); background-position: '.$mweb_offer_pat['background-position'].'; background-repeat: '.$mweb_offer_pat['background-repeat'].';';
				$str .= ' }';
			}
			if( !empty($mweb_offer_color)){
				$str .= '.header_alert a{ color:'.$mweb_offer_color.' }';
			}
			
			
			/* -----------------------------  product title style --------------------------------- */
			/* if( $mweb_product_title_style) {
				$str .= '.single_product_head{padding: 0px 15px 10px; background-color: #f5f6f7;}.woocommerce .entry-summary .product_meta{ padding:0}';
			} */
			
			/* ----------------------------- construction background --------------------------------- */

			/* if( !empty($under_construction_background) && !empty($under_construction_background['background-image']) ){
				$str .= '.under_construction{ background-image: url('.$under_construction_background['background-image'].'); background-position: '.$under_construction_background['background-position'].'; background-repeat: '.$under_construction_background['background-repeat'].'; background-size: '.$under_construction_background['background-size'].'; }';
			} */
			
			
			/* ----------------------------- typography ------------------------------- */
			
			$menu_typ = mweb_theme_util::get_theme_option( 'menu-typography' );
			$content_typ = mweb_theme_util::get_theme_option( 'content-typography' );
			$ch2_typ = mweb_theme_util::get_theme_option( 'ch2-typography' );
			$ch3_typ = mweb_theme_util::get_theme_option( 'ch3-typography' );
			$ch4_typ = mweb_theme_util::get_theme_option( 'ch4-typography' );
			
			$str .= ".mweb-main-menu>ul>li>a{font-size: {$menu_typ['font-size']}; font-weight: {$menu_typ['font-weight']}; color: {$menu_typ['color']}} .mweb-main-menu>ul{line-height: {$menu_typ['line-height']};}";
			
			$str .= ".entry-content, .entry-content>p{font-size: {$content_typ['font-size']}; font-weight: {$content_typ['font-weight']}; color: {$content_typ['color']}; line-height: {$content_typ['line-height']};}";
			
			$str .= ".entry-content>h2{font-size: {$ch2_typ['font-size']}; font-weight: {$ch2_typ['font-weight']}; color: {$ch2_typ['color']}; line-height: {$ch2_typ['line-height']};}";
			
			$str .= ".entry-content>h3{font-size: {$ch3_typ['font-size']}; font-weight: {$ch3_typ['font-weight']}; color: {$ch3_typ['color']}; line-height: {$ch3_typ['line-height']};}";
			
			$str .= ".entry-content>h3{font-size: {$ch4_typ['font-size']}; font-weight: {$ch4_typ['font-weight']}; color: {$ch4_typ['color']}; line-height: {$ch4_typ['line-height']};}";
		

			
			
		




			/************************ USER CUSTOM CSS **********************************/
			$mweb_custom_css = mweb_theme_util::get_theme_option( 'custom_css' );

			if ( ! empty( $mweb_custom_css ) ) {
				$str .= $mweb_custom_css;
			}
			
			
			//$str .= mweb_theme_composer_render::dynamic_style();

			//$str .= '</style>';

			//save to database
			$mweb_save_dynamic_css_cache = addslashes( $str );
			delete_option( 'mweb_theme_dynamic_css_cache' );
			add_option( 'mweb_theme_dynamic_css_cache', $mweb_save_dynamic_css_cache );

			wp_add_inline_style( 'mweb-style', $str );


		} else {
			echo stripcslashes( $mweb_dynamic_css_cache );
		}
	}
}

if ( ! function_exists( 'mweb_theme_delete_dynamic_css_cache' ) ) {
	function mweb_theme_delete_dynamic_css_cache() {
		delete_option( 'mweb_theme_dynamic_css_cache' );
	}
}

// delete css cache
add_action( 'redux/options/mweb_theme_theme_options/saved', 'mweb_theme_delete_dynamic_css_cache' );
add_action( 'redux/options/mweb_theme_theme_options/reset', 'mweb_theme_delete_dynamic_css_cache' );
add_action( 'redux/options/mweb_theme_theme_options/section/reset', 'mweb_theme_delete_dynamic_css_cache' );
add_action( 'save_post', 'mweb_theme_delete_dynamic_css_cache' );