<?php

/* Custom Meta For Taxonomies */


 /**-------------------------------------------------------------------------------------------------------------------------
 * Get field label
 */
if( !function_exists('mweb_get_field_label') ){
	function mweb_get_field_label( $field_id ){
		$labels = array(
			'<label style="display: inline-block;">'.esc_html__( 'آیکن دسته', 'mweb' ).'</label>'
		);

		return $labels[$field_id];
	}
}



/**-------------------------------------------------------------------------------------------------------------------------
 * Get field options for  icon
 */
if( !function_exists('mweb_get_icon_html') ){
	function mweb_get_icon_html( $icon_id = '' ){			
			return '
				<input type="hidden" id="attribute_icon" name="attribute_icon" value="'.( !empty( $icon_id ) ? esc_attr( $icon_id ) : '' ).'">
				<div id="preview_icon_picker" style="float: none; display:inline-block; margin: -5px 50px 0 0;" data-target="#attribute_icon" class="button icon-picker fal '.esc_attr( $icon_id ).'"></div>
			';
	}
}



/**-------------------------------------------------------------------------------------------------------------------------
 * Add icon to term meta - attribute
 */
if( !function_exists('mweb_add_attribute_html') ){
	function mweb_add_attribute_html() {
		echo '
		<div class="form-field">
			'.mweb_get_field_label( 0 ).'
			'.mweb_get_icon_html().'
		</div>
		';
	}
	add_action( 'woocommerce_after_add_attribute_fields', 'mweb_add_attribute_html', 10);
}


/**-------------------------------------------------------------------------------------------------------------------------
 * Edit icon to term meta - attribute
 */
if( !function_exists('mweb_edit_attribute_html') ){
	function mweb_edit_attribute_html( ) {
		$icon_id = get_term_meta( $_GET['edit'], 'attribute_icon', true ) ? get_term_meta( $_GET['edit'], 'attribute_icon', true ) : '';
		?>
		<tr class="form-field form-required">
			<th scope="row">
				<?php echo mweb_get_field_label( 0 ) ?>
			</th>
			<td>
				<?php echo mweb_get_icon_html( $icon_id ) ?>
			</td>
		</tr>
		
		<?php
	}
	add_action( 'woocommerce_after_edit_attribute_fields', 'mweb_edit_attribute_html' , 10 );
}


/**-------------------------------------------------------------------------------------------------------------------------
 * Save icon to term meta - attribute
 */
if( !function_exists('mweb_save_attribute') ){
	function mweb_save_attribute( $term_id ) {
		if ( isset( $_POST['attribute_icon'] ) ) {
			update_term_meta( $term_id, 'attribute_icon', $_POST['attribute_icon'] );
		}
	}  
	add_action( 'woocommerce_attribute_updated', 'mweb_save_attribute', 10 );  
	add_action( 'woocommerce_attribute_added', 'mweb_save_attribute', 10 );
}


/**-------------------------------------------------------------------------------------------------------------------------
 * Delete icon to term meta - attribute
 */
if( !function_exists('mweb_delete_attribute') ){
	function mweb_delete_attribute( $term_id ) {
		delete_term_meta( $term_id, 'attribute_icon' );
	}  
	add_action( 'woocommerce_attribute_deleted', 'mweb_delete_attribute', 10 );
}


?>