(function($) {
    "use strict";

    var mweb_theme = {

        window: $(window),
        html: $('html, body'),
        document: $(document),
        body: $('body'),
        direction: '',
        ajax_filter_item_last_width: [],
        ajax: {},

        document_ready: function() {


            mweb_theme.block_dropdown_filter();
         
            mweb_theme.ajax_data_term();
            mweb_theme.ajax_header_search();
            mweb_theme.ajax_search_box();
            mweb_theme.ajax_discount_filter();
            mweb_theme.ajax_dropdown_filter();
            mweb_theme.ajax_pagination();
            mweb_theme.ajax_loadmore();
            mweb_theme.ajax_like_dislike();
            mweb_theme.ajax_mega_cat_sub();
            mweb_theme.ajax_wishlist();
            //mweb_theme.ajax_tabico_filter();

        },

        document_load: function() {
            mweb_theme.window.on('load',function() {
                mweb_theme.body.addClass('mweb-js-loaded');
            });
        },

        document_reload: function() {
			
			mweb_theme.ajax_view_add();
            mweb_theme.ajax_view_count();
        

        },

        document_resize: function() {
            mweb_theme.window.resize(function() {

                mweb_theme.calc_small_menu();
                clearTimeout(mweb_theme.resize_timer);
                mweb_theme.resize_timer = setTimeout(function() {
                    mweb_theme.block_dropdown_filter();
                }, 150);
            })
        },


        //get width of item
        get_width: function(item) {
            return item.width();
        },

		calc_small_menu: function() {
            var small_menu = $('#mweb-small-menu');
            if (small_menu.length > 0) {
                var num_el = small_menu.find('.small-menu-inner').children().length;
                var menu_wrapper = small_menu.parents('.navbar-inner');
                if (menu_wrapper.length > 0) {
                    var wrapper_width = menu_wrapper.width();
                    if (parseInt(wrapper_width) < ( parseInt(num_el) + 1) * 215) {
                        small_menu.addClass('is-fw-small');
                        small_menu.css('width', wrapper_width);
                    } else {
                        small_menu.removeClass('is-fw-small');
                        small_menu.css('width', 'auto');
                    }
                }
            }
        },



        //ajax filter
        block_dropdown_filter: function() {

            var block_ajax_filter_wrap = $('.block-ajax-filter-wrap');
            if (block_ajax_filter_wrap.length > 0) {
                block_ajax_filter_wrap.each(function() {

                    var block_ajax_filter = $(this);
                    var block_ajax_filter_id = block_ajax_filter.attr('id');
                    var dropdown_counter = 1;
                    var list_counter = 1;
                    var header_inner = block_ajax_filter.parent('.block-title');
                    var header_inner_title = header_inner.find('.title');
                    var block_ajax_filter_max_width = mweb_theme.get_width(header_inner) - mweb_theme.get_width(header_inner_title);
                    var block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);

                    if (block_ajax_filter_width > block_ajax_filter_max_width * 0.5) {

                        while ((block_ajax_filter_width > block_ajax_filter_max_width * 0.5) && (dropdown_counter < 200)) {
                            var dropdown_flag = mweb_theme.block_dropdown_filter_add_el(block_ajax_filter);

                            if (0 == dropdown_flag) {
                                break;
                            }
                            block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);
                            dropdown_counter++;
                        }
                    } else {

                        if ('undefined' == typeof mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id]) {
                            mweb_theme.block_filter_hide_more(block_ajax_filter);
                        } else {

                            var ajax_filter_el_last_width = mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id];
                            while ((block_ajax_filter_width + ajax_filter_el_last_width < block_ajax_filter_max_width * 0.6) && (list_counter < 200)) {
                                var list_flag = mweb_theme.block_list_filter_add_el(block_ajax_filter);

                                if (0 == list_flag) {
                                    break;
                                }

                                block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);
                                list_counter++;
                            }
                        }
                    }

                    //touch action
                    mweb_theme.block_filter_touch_toggle(block_ajax_filter);
                })
            }
        },

        block_dropdown_filter_add_el: function(block_ajax_filter) {
            var block_ajax_filter_id = block_ajax_filter.attr('id');
            var list_ajax_filter = block_ajax_filter.find('.ajax-filter-list');
            var dropdown_ajax_filter = block_ajax_filter.find('.ajax-filter-dropdown-list');
            var list_ajax_filter_last_el = list_ajax_filter.children().last();

            if (list_ajax_filter_last_el.length > 0) {

                mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id] = list_ajax_filter_last_el.width();
                mweb_theme.block_filter_show_more(block_ajax_filter);
                list_ajax_filter_last_el.detach().prependTo(dropdown_ajax_filter);
                return 1;
            } else {
                return 0;
            }
        },

        block_list_filter_add_el: function(block_ajax_filter) {
            var block_ajax_filter_id = block_ajax_filter.attr('id');
            var list_ajax_filter = block_ajax_filter.find('.ajax-filter-list');
            var dropdown_ajax_filter = block_ajax_filter.find('.ajax-filter-dropdown-list');
            var dropdown_ajax_filter_first_el = dropdown_ajax_filter.children().first();

            //add to list
            if (dropdown_ajax_filter_first_el.length > 0) {
                dropdown_ajax_filter_first_el.css('opacity', '.1');
                dropdown_ajax_filter_first_el.detach().appendTo(list_ajax_filter);

                setTimeout(function() {
                    if (dropdown_ajax_filter.children().length == 0) {
                        mweb_theme.block_filter_hide_more(block_ajax_filter)
                    }
                    dropdown_ajax_filter_first_el.css('opacity', '1');
                }, 50);

                mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id] = dropdown_ajax_filter_first_el.width();

                return 1;
            } else {
                return 0;
            }
        },

        //hide if over width
        block_filter_hide_more: function(block_ajax_filter) {
            var block_ajax_filter_btn = block_ajax_filter.find('.ajax-filter-dropdown');
            if (block_ajax_filter_btn.css('display') == 'inline-block') {
                block_ajax_filter_btn.hide();
            }
        },

        block_filter_show_more: function(block_ajax_filter) {
            var block_ajax_filter_btn = block_ajax_filter.find('.ajax-filter-dropdown');
            if (block_ajax_filter_btn.css('display') == 'none') {
                block_ajax_filter_btn.show(350);
            }
        },

        block_filter_touch_toggle: function(block_ajax_filter) {
            if (true === mweb_theme.touch) {
                var dropdown = block_ajax_filter.find('.ajax-filter-dropdown');
                dropdown.addClass('is-touch');
                dropdown.on('click touch', function() {
                    dropdown.toggleClass('touch-active');
                });
            }
        },


        ajax_cache: {

            //set data
            data: {},

            get: function(id) {
                return mweb_theme.ajax_cache.data[id];
            },
            set: function(id, data) {
                mweb_theme.ajax_cache.remove(id);
                mweb_theme.ajax_cache.data[id] = data;
            },
            remove: function(id) {
                delete mweb_theme.ajax_cache.data[id];
            },
            exist: function(id) {
                return mweb_theme.ajax_cache.data.hasOwnProperty(id) && mweb_theme.ajax_cache.data[id] !== null;
            }
        },

        ajax_data_term: function() {
            $('.mweb-block-wrap').each(function() {
                var block = $(this);
                var block_id = block.attr('id');

                if ('undefined' != typeof block_id) {
                    mweb_theme.ajax[block_id + '_category_id'] = block.data('category_id');
                    mweb_theme.ajax[block_id + '_category_ids'] = block.data('category_ids');
                    mweb_theme.ajax[block_id + '_tags'] = block.data('tags');
                    mweb_theme.ajax[block_id + '_orderby'] = block.data('orderby');
                }

                mweb_theme.ajax_pagination_check(block);
                mweb_theme.ajax_loadmore_check(block);
                mweb_theme.ajax_infinite_scroll_check(block);
            })
        },

        ajax_reinitiate_function: function() {

            mweb_theme.html.off();
            mweb_theme.document.off();
            mweb_theme.window.trigger('load');
            mweb_theme.document_reload();
        },

        

        ajax_header_search: function() {

            var delay = (function() {
                var timer = 0;
                return function(callback, ms) {
                    clearTimeout(timer);
                    timer = setTimeout(callback, ms);
                };
            })();

            var search_result_wrapper = $('#ajax-search-result');
            $('#search-form-text').keyup(function() {
                var param = $(this).val();

                delay(function() {
                    if (param) {
                        search_result_wrapper.fadeIn(300).html('<div class="ajax-loader"></div>');
                        var data = {
                            action: 'mweb_theme_ajax_search',
                            s: param
                        };
                        $.post(mweb_ajax_url, data, function(data_response) {
                            data_response = $.parseJSON(data_response);
                            search_result_wrapper.hide().empty().html(data_response).fadeIn(300);
                        });
                    } else  search_result_wrapper.fadeOut(300, function() {
                        $(this).empty();
                    });

                }, 450);
            })
        },
		
		
		
		ajax_search_box: function() {

            var delay = (function() {
                var timer = 0;
                return function(callback, ms) {
                    clearTimeout(timer);
                    timer = setTimeout(callback, ms);
                };
            })();

            var search_result_wrapper = $('#search-box-result');
            $('#search-box-key').keyup(function() {
                var param = $(this).val();

                delay(function() {
                    if (param) {
                        search_result_wrapper.fadeIn(300).html('<div class="ajax-loader"></div>');
                        var data = {
                            action: 'mweb_theme_ajax_search',
                            s: param
                        };
                        $.post(mweb_ajax_url, data, function(data_response) {
                            data_response = $.parseJSON(data_response);
                            search_result_wrapper.hide().empty().html(data_response).fadeIn(300);
                        });
                    } else  search_result_wrapper.fadeOut(300, function() {
                        $(this).empty();
                    });

                }, 450);
            })
        },


        ajax_block_data: function(block) {
            var param = {};
            param.block_id = block.data('block_id');
            param.block_name = block.data('block_name');
            param.post_type = block.data('post_type');
            param.my_column = block.data('column');
            param.posts_per_page = block.data('posts_per_page');
            param.ajax_dropdown = block.data('ajax_dropdown');
            param.block_page_max = block.data('block_page_max');
            param.block_page_current = block.data('block_page_current');
            param.category_id = block.data('category_id');
            param.category_ids = block.data('category_ids');
            param.orderby = block.data('orderby');
            param.authors = block.data('authors');
            param.tags = block.data('tags');
            param.post_format = block.data('post_format');
            param.offset = block.data('offset');
            param.excerpt = block.data('excerpt');
            param.excerpt_classic = block.data('excerpt_classic');
            param.block_style = block.data('block_style');
            param.thumb_position = block.data('thumb_position');
            param.summary_type = block.data('summary_type');
            param.array_range = block.data('array_range');
            param.cat_info = block.data('cat_info');
            param.meta_info = block.data('meta_info');

            return param;
        },
		
		
		// ajax discount filter
        ajax_discount_filter: function() {

            $('.discount_percent li').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var filter_link = $(this);
                var block = filter_link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');
				var var_option = $('.discount_num').find('option:selected');
				var block_perpage = var_option.val();

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }


                var filter_link_val = filter_link.attr('id');
                mweb_theme.ajax[block_id + '_processing'] = true;

                //disable other link
                block.find('.discount_percent li').removeClass('active');
                block.find('.discount_percent li').not(this).addClass('disable');
                filter_link.addClass('active');


                mweb_theme.ajax_animation_start(block);

                var param = mweb_theme.ajax_block_data(block);

				param.array_range = filter_link_val;
                block.data('array_range', filter_link_val);
				param.posts_per_page = block_perpage;
				block.data('posts_per_page', block_perpage);

				
                setTimeout(function() {
                    mweb_theme.ajax_discount_filter_process(block, param);
                }, 500);

            });
        },
		
		
		
		
		//request ajax discount
        ajax_discount_filter_process: function(block, param) {

            var param_cache = param;
            delete param_cache.block_page_max;
            var cache_id = JSON.stringify(param_cache);

            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_max) {
                    block.data('block_page_max', data.block_page_max);
                }

                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_ajax_discount',
                    data: param
                },
                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_max) {
                        block.data('block_page_max', data.block_page_max);
                    }
                    mweb_theme.ajax_cache.set(cache_id, data);
                    mweb_theme.ajax_animation_end(block, data.content);
                }
            });
        },
		

		
        // ajax dropdown filter
        ajax_dropdown_filter: function() {

            $('.ajax-filter-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var filter_link = $(this);
                var block = filter_link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }

                var filter_link_val = filter_link.data('ajax_filter_val');
                mweb_theme.ajax[block_id + '_processing'] = true;

                //disable other link
                block.find('.ajax-link').removeClass('is-active');
                block.find('.ajax-link').not(this).addClass('is-disable');
                filter_link.addClass('is-active');

                if (true === mweb_theme.touch) {
                    var dropdown = filter_link.parents('.ajax-filter-dropdown');
                    dropdown.removeClass('touch-active');
                }

                mweb_theme.ajax_animation_start(block);

                var param = mweb_theme.ajax_block_data(block);
                mweb_theme.ajax_dropdown_reset_param(block, param, filter_link_val);
                setTimeout(function() {
                    mweb_theme.ajax_dropdown_filter_process(block, param);
                }, 500);
            });
        },

        //reset param when filter
        ajax_dropdown_reset_param: function(block, param, filter_link_val) {

            param.block_page_current = 1;

            block.data('block_page_current', 1);
            var block_id = block.attr('id');

            if ('category' == param.ajax_dropdown) {

                if ('undefined' == typeof (mweb_theme.ajax[block_id + '_category_id'])) {
                    mweb_theme.ajax[block_id + '_category_id'] = 0;
                }

                if (0 == filter_link_val) {
                    param.category_id = mweb_theme.ajax[block_id + '_category_id'];
                    param.category_ids = mweb_theme.ajax[block_id + '_category_ids'];

                    block.data('category_id', mweb_theme.ajax[block_id + '_category_id']);
                    block.data('category_ids', mweb_theme.ajax[block_id + '_category_ids']);

                } else {

                    param.category_id = filter_link_val;
                    param.category_ids = 0;

                    block.data('category_id', filter_link_val);
                    block.data('category_ids', 0);
                }
            }

            if ('tag' == param.ajax_dropdown) {
                param.tags = filter_link_val;
                block.data('tags', filter_link_val);
            }

            if ('author' == param.ajax_dropdown) {
                param.authors = filter_link_val;
                block.data('authors', filter_link_val);
            }

            if ('popular' == param.ajax_dropdown) {

                block.data('orderby_term', block.data('orderby'));

                if ('featured' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'featured_product';
                    block.data('tags', '');
                    block.data('orderby', 'featured_product');
                }

                if ('best_selling' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'best_selling';
                    block.data('orderby', 'best_selling');
                    block.data('tags', '');
                }

                if ('top_rate' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'top_rate';
                    block.data('orderby', 'top_rate');
                    block.data('tags', '');
                }
				
				if ('on_sale' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'on_sale';
                    block.data('orderby', 'on_sale');
                    block.data('tags', '');
                }
				
                if (0 == filter_link_val) {
                    param.tags = mweb_theme.ajax[block_id + '_tags'];
                    param.orderby = mweb_theme.ajax[block_id + '_orderby'];
                    if ('undefined' == typeof mweb_theme.ajax[block_id + '_tags']) {
                        block.data('tags', '');
                    } else {
                        block.data('tags', mweb_theme.ajax[block_id + '_tags']);
                    }
                    block.data('orderby', mweb_theme.ajax[block_id + '_orderby']);
                }
            }
        },

        //request ajax dropdown
        ajax_dropdown_filter_process: function(block, param) {

            var param_cache = param;
            delete param_cache.block_page_max;
            var cache_id = JSON.stringify(param_cache);

            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_max) {
                    block.data('block_page_max', data.block_page_max);
                }

                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_theme_ajax_filter_data',
                    data: param
                },
                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_max) {
                        block.data('block_page_max', data.block_page_max);
                    }
					
                    mweb_theme.ajax_cache.set(cache_id, data);
                    //mweb_theme.ajax_animation_end(block, data.content);
					block.find('.ajax-link').removeClass('is-disable');
					block.find('.ajax-filter-more').removeClass('is-disable');

					var block_id = block.attr('id');
					var content_wrap = block.find('.block-content-wrap');
					var content_inner = content_wrap.find('.block-content-inner');

					content_wrap.find('.ajax-loader').remove();
					content_inner.stop();
					content_inner.html(data.content);

					content_inner.fadeTo(500, 1, function() {
					});

					content_inner.removeClass('is-overflow');
					mweb_theme.ajax[block_id + '_processing'] = false;
					
					
                }
            });
        },
		
		
		


        ajax_animation_start: function(block) {

            var content_wrap = block.find('.block-content-wrap');
            var content_inner = content_wrap.find('.block-content-inner');
            var content_inner_height = content_inner.outerHeight();

            //add height for ajax
            content_inner.css('height', content_inner_height);

            //hide content
            content_inner.stop();
            $('.ajax-loader').remove();
            content_wrap.prepend('<div class="ajax-loader">');
            content_inner.addClass('is-overflow');
            content_inner.fadeTo('500', 0.05, 'easeInOutCubic');
        },


        //add animation and append
        ajax_animation_end: function(block, content) {

            block.delay(100).queue(function() {

                block.find('.ajax-link').removeClass('is-disable');
                block.find('.ajax-filter-more').removeClass('is-disable');

                var block_id = block.attr('id');
                var content_wrap = block.find('.block-content-wrap');
                var content_inner = content_wrap.find('.block-content-inner');

                content_wrap.find('.ajax-loader').remove();
                //content_inner.stop();
                content_inner.html(content);

                content_inner.fadeTo(500, 1, function() {
                });

                content_inner.removeClass('is-overflow');

                if (block.hasClass('block-mega-menu')) {
                    setTimeout(function() {
                        content_inner.css('height', 'auto');
                    }, 250);
                } else {
                    setTimeout(function() {
                        content_inner.css('height', 'auto');
                    }, 100);
                }

                mweb_theme.ajax[block_id + '_processing'] = false;
                mweb_theme.ajax_pagination_check(block);
                mweb_theme.ajax_loadmore_check(block);
                mweb_theme.ajax_infinite_scroll_check(block);

                block.dequeue();
            });
        },


        // ajax pagination next prev
        ajax_pagination: function() {

            $('.ajax-pagination-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var link = $(this);
                var block = link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }
                mweb_theme.ajax[block_id + '_processing'] = true;

                block.find('.ajax-link').addClass('is-disable');
                block.find('.ajax-filter-more').addClass('is-disable');

                var pagination_link_val = link.data('ajax_pagination_link');
                var param = mweb_theme.ajax_block_data(block);
                mweb_theme.ajax_animation_start(block);
                setTimeout(function() {
                    mweb_theme.ajax_pagination_process(block, param, pagination_link_val);
                }, 200);
            });
        },

        ajax_pagination_process: function(block, param, pagination_link_val) {

            var page_current = param.block_page_current;
            if ('prev' == pagination_link_val) {
                --page_current;
            } else {
                ++page_current
            }

            param.block_page_next = page_current;

            var param_cache = param;
            delete param_cache.block_page_max;
            param_cache.block_page_current = page_current;

            var cache_id = JSON.stringify(param_cache);
            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_current) {
                    block.data('block_page_current', data.block_page_current);
                }
                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_theme_pagination_data',
                    data: param
                },

                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_current) {
                        block.data('block_page_current', data.block_page_current);
                    }
                    mweb_theme.ajax_cache.set(cache_id, data);
                    mweb_theme.ajax_animation_end(block, data.content);
                }
            });
        },

        ajax_pagination_check: function(block) {

            var param = mweb_theme.ajax_block_data(block);

            if (param.block_page_max < 2) {
                block.find('.ajax-pagination-link').addClass('is-disable');
            }

            if (param.block_page_current >= param.block_page_max) {
                block.find('.ajax-next').addClass('is-disable');
            }

            if (param.block_page_current <= 1) {
                block.find('.ajax-prev').addClass('is-disable');
            }
        },


        ajax_loadmore: function() {
            $('.ajax-loadmore-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var link = $(this);
                var block = link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');
                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }
                var param = mweb_theme.ajax_block_data(block);
                if (param.block_page_current >= param.block_page_max) {
                    return;
                }
                mweb_theme.ajax[block_id + '_processing'] = true;
                var animation = link.next('.ajax-animation');
                link.animate({ opacity: 0 }, 200);
                setTimeout(function() {
                    animation.css({ 'display': 'block' });
                    animation.css({ 'visibility': 'visible' });
                    animation.delay(200).animate({ opacity: 1 }, 200);
                }, 100);
                setTimeout(function() {
                    mweb_theme.ajax_loadmore_process(block, param);
                }, 200);
            })
        },

        ajax_loadmore_process: function(block, param) {

            var block_id = block.attr('id');
            var page_current = param.block_page_current;
            var page_next = ++page_current;

            param.block_page_next = page_next;
            if (page_next <= param.block_page_max) {

                $.ajax({
                    type: 'POST',
                    url: mweb_ajax_url,
                    data: {
                        action: 'mweb_theme_pagination_data',
                        data: param
                    },

                    success: function(data) {

                        data = $.parseJSON(data);

                        if ('undefined' != data.block_page_current) {
                            block.data('block_page_current', data.block_page_current);
                        }

                        block.find('.block-content-inner').append(data.content);
                        mweb_theme.ajax[block_id + '_processing'] = false;

                        setTimeout(function() {
                            mweb_theme.ajax_reinitiate_function();
                        }, 50);

                        if (data.block_page_current < param.block_page_max) {
                            var animation = block.find('.ajax-animation');
                            animation.css({ 'display': 'none' });
                            animation.css({ 'visibility': 'hidden' });
                            animation.css({ 'opacity': 0 });
                            block.find('.ajax-loadmore-link').delay(100).animate({ opacity: 1 }, 200);
                        } else {
                            block.find('.ajax-loadmore-link').hide();
                            block.find('.ajax-animation').hide();
                        }
                    }
                });
            }
        },

        ajax_loadmore_check: function(block) {

            var param = mweb_theme.ajax_block_data(block);
            if (param.block_page_current >= param.block_page_max || param.block_page_max <= 1) {
                block.find('.ajax-loadmore-link').hide();
                block.find('.ajax-animation').hide();
            } else {
                block.find('.ajax-loadmore-link').css('opacity', 1);
                block.find('.ajax-loadmore-link').show();
            }
        },

        //ajax pagination infinite scroll
        ajax_infinite_scroll: function() {

            var infinite_scroll = $('.ajax-infinite-scroll');
            if (infinite_scroll.length > 0) {

                infinite_scroll.each(function() {
                    var infinite_scroll_el = $(this);

                    if (!infinite_scroll_el.hasClass('is-disable')) {

                        var animation = infinite_scroll_el.find('.ajax-animation');
                        var block = infinite_scroll_el.parents('.mweb-block-wrap');
                        var block_id = block.attr('id');

                        if (infinite_scroll_el.length > 0) {
                            mweb_theme.waypoint_item['infinite_scroll'] = new Waypoint({
                                element: infinite_scroll_el,
                                handler: function(direction) {
                                    if ('down' == direction) {

                                        var param = mweb_theme.ajax_block_data(block);

                                        if (param.block_page_current >= param.block_page_max) {
                                            infinite_scroll_el.addClass('is-disable');
                                            return;
                                        }

                                        if (true == mweb_theme.ajax[block_id + '_processing']) {
                                            return;
                                        }

                                        mweb_theme.ajax[block_id + '_processing'] = true;

                                        setTimeout(function() {
                                            animation.css({ 'display': 'block' });
                                            animation.css({ 'visibility': 'visible' });
                                            animation.animate({ opacity: 1 }, 200);
                                        }, 100);

                                        setTimeout(function() {
                                            mweb_theme.ajax_loadmore_process(block, param);
                                            mweb_theme.waypoint_item['infinite_scroll'].destroy();
                                        }, 200);
                                    }
                                },
                                offset: '99%'
                            })
                        }
                    }
                });
            }
        },

        ajax_infinite_scroll_check: function(block) {
            var param = mweb_theme.ajax_block_data(block);
            if (param.block_page_current >= param.block_page_max || param.block_page_max <= 1) {
                block.find('.ajax-infinite-scroll').addClass('is-disable');
            } else {
                block.find('.ajax-infinite-scroll').removeClass('is-disable');
            }
        },

        ajax_mega_cat_sub: function() {

            var hover_timer;
            var cat_sub = $('.mega-category-menu .menu-item');

            cat_sub.hover(function(event) {
                event.stopPropagation();
                cat_sub = $(this);
                cat_sub.addClass('is-current-sub').siblings().removeClass('is-current-sub current-menu-item');
                var wrapper = cat_sub.parents('.mega-category-menu');
                var block = wrapper.find('.block-mega-menu-sub');
                hover_timer = setTimeout(function() {
                    mweb_theme.ajax_cat_sub_process(cat_sub, block);
                }, 200);
            }, function() {
                clearTimeout(hover_timer);
            });
        },

        ajax_cat_sub_process: function(cat_sub, block) {

            var block_id = block.attr('id');
            if (true == mweb_theme.ajax[block_id + '_processing']) {
                return;
            }
            mweb_theme.ajax[block_id + '_processing'] = true;

            var param = mweb_theme.ajax_block_data(block);
            param.category_id = cat_sub.data('mega_sub_filter');
            param.block_page_current = 1;
            param.block_name = 'mweb_theme_mega_block_cat_sub';
            param.posts_per_page = 4;

            block.data('category_id', param.category_id);
            block.data('block_page_current', param.block_page_current);

            mweb_theme.ajax_animation_start(block);
            setTimeout(function() {
                mweb_theme.ajax_dropdown_filter_process(block, param);
            }, 200);
        },
		
		
		
        //ajax view
        ajax_view_count: function() {
            if (mweb_theme.body.hasClass('is-ajax-view')) {
                var ajax_view = $('.mweb-ajax-view');
                if (ajax_view.length > 0) {
                    ajax_view.each(function() {
                        var ajax_view_el = $(this);
                        var post_id = ajax_view_el.data('post_id');
                        ajax_view_el.css('width', ajax_view_el.width());
                        $.ajax({
                            type: 'POST',
                            url: mweb_ajax_url ,
                            data: {
                                action: 'mweb_theme_ajax_view_get',
                                post_id: post_id
                            },
                            success: function(data) {
                                data = $.parseJSON(data);
                                ajax_view_el.html(data);
                                ajax_view_el.css('width', 'auto');
                                ajax_view_el.removeClass('is-invisible');
                            }
                        });
                    })
                }
            }
        },

        //add post view
        ajax_view_add: function() {
            if (mweb_theme.body.hasClass('is-ajax-view')) {
                var ajax_view = $('.mweb-ajax-view-add');
                if (ajax_view.length > 0) {
                    ajax_view.each(function() {
                        var ajax_view_el = $(this);
                        var post_id = ajax_view_el.data('post_id');
                        $.ajax({
                            type: 'POST',
                            url: mweb_ajax_url ,
                            data: {
                                action: 'mweb_theme_ajax_view_add',
                                post_id: post_id
                            },
                            success: function(data) {
                                ajax_view_el.removeClass('mweb-ajax-view-add');
                            }
                        });
                    })
                }
            }
        } ,
		
		mweb_setCookie: function(cname, cvalue, exdays) {
			var d = new Date();
			d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
			var expires = "expires=" + d.toUTCString();
			document.cookie = cname + "=" + cvalue + "; " + expires;
		},

		mweb_getCookie: function(cname) {
			var name = cname + "=";
			var ca = document.cookie.split(';');
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') {
					c = c.substring(1);
				}
				if (c.indexOf(name) == 0) {
					return c.substring(name.length, c.length);
				}
			}
			return "";
		},
		
		ajax_like_dislike: function() {
			var ajax_flag = 0;
				$('.like_dislike_btn').off('click').on('click', function(e) {
				e.preventDefault();
				if (ajax_flag == 0) {
					var restriction = $(this).data('restriction');
					var comment_id = $(this).data('comment-id');
					var trigger_type = $(this).data('trigger-type');
					var selector = $(this);
					var mweb_cookie = mweb_theme.mweb_getCookie('mweb_' + comment_id);
					var current_count = $(this).data('counter');
					var new_count = parseInt(current_count) + 1;
					var ip_check = $(this).attr('data-ip-check');
					var user_check = $(this).attr('data-user-check');
					
					
					var like_dislike_flag = 1;
					if (restriction == 'cookie' && mweb_cookie != '') {
						like_dislike_flag = 0;

					}
					if (restriction == 'ip' && ip_check == '1') {
						like_dislike_flag = 0;

					}
					if(restriction == 'user' && user_check == '1'){
						like_dislike_flag = 0;
					}
					if (like_dislike_flag == 1) {
						$.ajax({
							type: 'post',
							url: mweb_ajax_url,
							data: {
								comment_id: comment_id,
								action: 'mweb_like_dislike_action',
								type: trigger_type,
								_wpnonce: admin_ajax_nonce
							},
							beforeSend: function (xhr) {
								ajax_flag = 1;
								selector.attr('data-counter',new_count);
							},
							success: function (res) {
								ajax_flag = 0;
								res = $.parseJSON(res);
								if (res.success) {
									if (restriction == 'ip') {
										selector.attr('data-ip-check', 1);
									}
									if (restriction == 'user') {
										selector.parent('.like_dislike_wrap').find('a').attr('data-user-check', 1);
									}
									var cookie_name = 'mweb_' + comment_id;
									mweb_theme.mweb_setCookie(cookie_name, 1, 365);
									var latest_count = res.latest_count;
									selector.attr('data-counter',latest_count);
								}
							}

						});
					}
				}
				
			});
		},
		ajax_wishlist: function() {
			
			$('.add_to_wishlist').off('click').on('click', function(e) {				
				var el_btn = $(this);
				if(el_btn.hasClass('user_logged') && !el_btn.parent().hasClass('added')){
					e.preventDefault();
					
					var p_id = el_btn.data('product-id');
					var p_action = el_btn.data('action');
					$.ajax({
						type: 'post',
						url: mweb_ajax_url,
						data: {
							action: 'mweb_wishlist_action',
							type: p_action,
							product_id : p_id,
							security_nonce : admin_ajax_nonce 
						}, 
						beforeSend: function (xhr) {
							el_btn.parent().addClass('loading');
						},
						success: function (res) {
							if (res.success) {
								if(p_action == 'wl_add'){
									el_btn.parent().removeClass('loading').addClass('added');
									el_btn.attr('data-original-title', 'مشاهده علاقه مندی ها');
									el_btn.attr('href', res.data.url);
								}else if(p_action == 'wl_remove'){
									el_btn.closest( "tr" ).remove();
								}
								
							}else{
								el_btn.parent().removeClass('loading');
								if(p_action == 'wl_add'){
									el_btn.attr('data-original-title', 'خطا در عملیات');
								}else if(p_action == 'wl_remove'){
									el_btn.text('خطا');
									setTimeout(function() {
										el_btn.text('تلاش دوباره');
									}, 200);
								}
								
							}
						}

					});
					
				}else{
					$('html,body').animate({scrollTop:0},'slow');
					el_btn.attr('data-original-title', 'ابتدا ورود کنید');
					//$('.login_user_btn').trigger( "click" )
				}

				
				
				
			});
		}
		
		
		
	

	
	}



    $(document).ready(function() {
        mweb_theme.document_ready();
        mweb_theme.document_load();
        mweb_theme.document_reload();
        mweb_theme.document_resize();
		
		$( "#mweb_login" ).submit(function( e ) {
			var $form = $(e.target);
			var $message = $('#message', this);
			var all_data = $form.serializeArray();
			all_data.push({name: 'security-login', value: admin_ajax_nonce});

			e.preventDefault();
			$message.text('در حال ارسال اطلاعات ...');
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: mweb_ajax_url ,
				data: all_data,
				success: function (response) {
				console.log(response);
				$message.html(response.data.message);
					if (response.success && response.data.logged_in) {
							window.location.reload();
						
					} 
				}
			});

		});
		
		$( "#mweb_register" ).submit(function( e ) {
			var $form = $(e.target);
			var $message = $('#message', this);
			var all_data = $form.serializeArray();
			all_data.push({name: 'security-singup', value: admin_ajax_nonce});
			
			e.preventDefault();
			$message.text('در حال ارسال اطلاعات ...');
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: mweb_ajax_url ,
				data: all_data,
				success: function (response) {
				$message.html(response.data.message);
					if (response.success && response.data.logged_in) {
						if(response.data.verify){
							setTimeout(function(){
								window.location.replace(response.data.redirect);
							},3000);
							
						}else{
							window.location.reload();
							
						}

					}
				}
			});

		});
		
		
		function sms_timer(){
			var timer = $('.resend_sms');
			var now = new Date();
			now.setSeconds(now.getSeconds() + 180);
			var resend_time = now.getFullYear()+'/'+(now.getMonth()+1)+'/'+now.getDate()+' '+now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds();
		    timer.countdown(resend_time).on('update.countdown', function(event) {
				var $this = $(this).html(event.strftime('%M:%S ارسال مجدد'));
			}).on('finish.countdown', function(event) {
				$(this).html('');
				$('#get_otp').val('ارسال مجدد کد تایید').show();
			});
		}
		
		$( "#get_otp" ).on('click', function(e) {
			e.preventDefault();
			var this_e = $(this);
			var message = $('.sms_notice');
			var verifycode = $('.verifycode');
			var mobile = $('#phone_nubmber');
			var plable = $('.plable');
			var _nonce = $('#security_nonce_field').val();
			var data_action = (this_e.parents('form').attr('id') == 'verifysms_form') ? 'wp_sms_action_send': 'wp_lost_password_otp_send';
			if(!mobile.val()){
				mobile.focus();
			}else{
				
				message.addClass('on').html('در حال ارسال اطلاعات ...');
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: mweb_ajax_url ,
					data: {
						action: data_action,
						phone_number : mobile.val(),
						security_nonce_field : _nonce
					}, 
					success: function (response) {
						if (response.success) {
							this_e.hide();
							$('#submit_otp').removeClass('hide');
							sms_timer();
							message.html(response.data.message);
							verifycode.removeClass('hide');
							mobile.hide();
							$('#sms_retries').val(response.data.retries);
							plable.html('کد تایید را وارد کنید');							
						}else{
							message.addClass('off').html(response.data.message);
						}
						
					}
				});
			}

		});
		
		
		$( "#submit_otp" ).on('click', function(e) {
			e.preventDefault();
			var this_e = $(this);
			var message = $('.sms_notice');
			var otp_var = $('#sms_otp');
			var verifysms_wrap = $('.verifysms_wrap');
			var data_action = (this_e.parents('form').attr('id') == 'verifysms_form') ? 'wp_sms_action_verify': 'wp_lost_password_otp_verify';
			var _nonce = $('#security_nonce_field').val();
			if(!otp_var.val()){
				otp_var.focus();
			}else{

				message.addClass('on').text('در حال بررسی اطلاعات ...');
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: mweb_ajax_url ,
					data: {
						action: data_action,
						sms_otp : otp_var.val(),
						security_nonce_field : _nonce
					}, 
					success: function (response) {
						if (response.success) {
							if(message.hasClass('off')){
								message.removeClass('off');
							}
							message.addClass('on').html(response.data.message);		
							setTimeout(function(){
								if(response.data.redirect){
									window.location.replace(response.data.redirect);
								}else{
									verifysms_wrap.remove();
								}
								
							},2500);							
						}else{
							message.addClass('off').html(response.data.message);
						}
						
					}
				});
			}

		});
		
			
    });

})(jQuery);