<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */
   

     
	//load imported demo
	require_once get_template_directory() . '/includes/mweb-import.php';

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "shop_options";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

  
	// remove redux menu under the tools
	if ( ! function_exists( 'mweb_remove_redux_menu' ) ) {
		function mweb_remove_redux_menu() {
			remove_submenu_page( 'tools.php', 'redux-about' );
		}

		add_action( 'admin_menu', 'mweb_remove_redux_menu', 12 );
	}

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'دیجی آکادمی', 'mweb' ),
        'page_title'           => esc_html__( 'پنل مدیریت پوسته', 'mweb' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        'page_priority'        => 54,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        'footer_credit'        => 'گروه طراحی و توسعه ماهدیس وب',
        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
		'system_info'          => false,


        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
  
   /*  $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'http://www.mahdisweb.net/contactus/',
        'title' => esc_html__( 'پشتیبانی', 'mweb' ),
    ); */


    // Add content after the form.
    //$args['footer_text'] = '<p>Need help? Visit our dedicated <a href="http://veented.com/support" target="_blank">Support Forums</a>.</p>';

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'mweb' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'mweb' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'mweb' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'mweb' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'mweb' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */
     
	 
	 
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'عمومی', 'mweb' ),
        'id'     => 'mweb-general',
        'desc'   => esc_html__( 'تنظیمات کلی', 'mweb' ),
        'fields' => array(
           

			

			array(
                'id'       => 'mweb-body-pat',
                'type'     => 'background',
				'background-color' => false,
                'title'    => esc_html__( 'تصویر پس زمینه سایت', 'mweb' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( "آپلود کنید", 'mweb' ),
                'default'  => ''
            ),
			
			array(
				'id'		=> 'become_seller_page_id',
				'title'		=> __( 'برگه فروشنده شوید', 'mweb' ),
				'subtitle'	=> __( 'مخصوص حساب کاربری', 'mweb' ),
				'type'		=> 'select',
				'data'		=> 'pages',
			),
			array(
                'id'       => 'search_filter',
                'type'     => 'switch',
                'title'    => esc_html__( 'محدود کردن جستجو به محصول', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'product_type_on',
                'type'     => 'switch',
                'title'    => esc_html__( 'فروش محصولات فیزیکی', 'mweb' ),
                'subtitle' => esc_html__( 'اضافه شدن فیلدهای آدرس و ... در پرداخت', 'mweb' ),
                'default'  => false,
            ),
			array(
                'id'       => 'mweb_myaccount_note',
                'type'     => 'editor',
                'title'    => esc_html__( 'نکته و ... در داشبود پنل کاربری', 'mweb' ),
                'subtitle' => esc_html__( 'برای عدم نمایش فیلد را خالی رها کنید', 'mweb' ),
            ),
			array(
                'id'       => 'sticky_header',
                'type'     => 'switch',
                'title'    => esc_html__( 'منو شناور', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'ajax_register_login',
                'type'     => 'switch',
                'title'    => esc_html__( 'ثبت نام و ورود ایجکس', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_news_cat',
                'type'     => 'select',
				 'data'     => 'category',
                'title'    => esc_html__( 'انتخاب دسته اخبار پنل کاربری', 'mweb' ),
            ),
			array(
                'id'       => 'mweb_slider_cat',
                'type'     => 'select',
				'data'     => 'terms',
				'args' => array(
					'taxonomies' => array( 'slider_category' ),
				),
                'title'    => esc_html__( 'انتخاب دسته اسلایدر پنل کابری', 'mweb' ),
            ),
			array(
                'id'       => 'allow_avatar',
                'type'     => 'switch',
                'title'    => esc_html__( 'امکان تغییر آواتار کاربر', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_thankyou_text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'متن تشکر از خرید', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
            ),
          
        )
    ) );
	
	
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'در دست ساخت', 'mweb' ),
        'id'     => 'mweb-wrench',
        'desc'   => esc_html__( 'تنظیمات در دست ساخت', 'mweb' ),
        'fields' => array(

			array(
				'id'       => 'under_construction',
				'type'     => 'switch',
				'title'    => esc_html__( 'فعال سازی در دست ساخت', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'switch'   => true,
				'default'  => 0
			),
			array(
                'id'       => 'under_construction_title',
                'type'     => 'text',
                'title'    => esc_html__( 'عنوان', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'در دست ساخت',
            ), 
			array(
                'id'       => 'under_construction_content',
                'type'     => 'editor',
                'title'    => esc_html__( 'توضیحات', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => '',
            ), 
			array(
				'id'		=> 'under_construction_time',
				'title'		=> __( 'تایم در دست ساخت', 'mweb' ),
				'subtitle'	=> __( 'راهنمای درج تاریخ و زمان را مانند مثال روبرو وارد کنید', 'mweb' ),
				'type'		=> 'text',
                'default' => esc_html__( "2018-07-24 19:30:00", 'mweb' ),
			),
			
          
        )
    ) );


	
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'سربرگ', 'mweb' ),
        'id'     => 'mweb-header',
        'desc'   => esc_html__( 'تنظیمات بالای صفحه', 'mweb' ),
        'fields' => array(
		
			array(
				'id'       => 'mweb_header_layout',
				'type'     => 'select',
				'title'    => __('انتخاب سربرگ', 'mweb'), 
				'subtitle' => __('', 'mweb'),
				'options'  => array(
							  '1' => 'نوع یک',
							  '3' => 'نوع دو',
						),
				'default' => '1'
			),
			array(
				'id'       => 'mweb_header_wide',
				'type'     => 'switch',
				'title'    => esc_html__( 'فعال سازی سربرگ تمام عرض در صفحه اصلی', 'mweb' ),
				'default'  => true,
			),
            array(
                'id'       => 'mweb_logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'لوگو', 'mweb' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( "آپلود کنید", 'mweb' ),
                //'default'  => array( 'url' => get_template_directory_uri() . '/images/logo.png' ),
            ),
            array(
                'id'       => 'mweb_favicon',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'آیکن', 'mweb' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( "favicon", 'mweb' ),
            ),				
			array(
                'id'       => 'mweb_head_account_url',
                'type'     => 'text',
                'title'    => esc_html__( 'آدرس صفحه حساب کاربری', 'mweb' ),
		        'default'  => 'http://',
            ),
			array(
                'id'       => 'mweb_head_logout_url',
                'type'     => 'text',
                'title'    => esc_html__( 'آدرس دکمه خروج', 'mweb' ),
		        'default'  => 'http://',
            ),
			array(
				'id'       => 'mweb_social_head',
				'type'     => 'sortable',
				'title'    => esc_html__( 'شبکه های اجتماعی سربرگ', 'mweb' ),
				'subtitle' => esc_html__( 'به راحتی میتوانید با کشیدن و رها کردن گزینه ها را جابجا کنید', 'mweb' ),
				'label'    => true,
				'options'  => array(
					'facebook-f' => 'http://your_facebook_page_url',
					'twitter' => '#',
					'instagram' => '',
					'telegram-plane' => '#',
					'pinterest-p' => '',
					'youtube' => '',
					'linkedin-in' => '',
				)
			),
			array(
				'id'       => 'mweb_head_tel',
				'type'     => 'text',
				'title'    => esc_html__( 'شماره تماس', 'mweb' ),
				'subtitle' => __('پیش شماره را با خط تیره خدا کنید', 'mweb'),
				'default'  => '021-88250686',
			),
			array(
                'id'       => 'mweb_head_cart',
                'type'     => 'switch',
                'title'    => esc_html__( 'سبد خرید', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش سبد خرید', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'sticky_header',
                'type'     => 'switch',
                'title'    => esc_html__( 'منو شناور', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			
        )
    ));
	
	
	Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'اطلاعیه سربرگ', 'mweb' ),
		'id'         => 'mweb_head_offer',
		'subsection' => true,
		'fields'     => array(
			
			array(
				'id'       => 'mweb_offer_text',
				'type'     => 'text',
				'url'      => true,
				'title'    => esc_html__( 'متن', 'mweb' ),
			),	
			
			array(
				'id'       => 'mweb_offer_pat',
				'type'     => 'background',
				'background-color' => true,
				'title'    => esc_html__( 'پس زمینه', 'mweb' ),
				'compiler' => 'true',
				'subtitle' => esc_html__( "آپلود کنید", 'mweb' ),
				'default'  => ''
			),
			
			array(
				'id'       => 'mweb_offer_color',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ متن', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'default'  => '',
				'validate' => 'color',
			),	
		
			array(
				'id'       => 'mweb_offer_link',
				'type'     => 'text',
				'title'    => esc_html__( 'لینک', 'mweb' ),
				'default'  => 'http://',
			),
			
	
						
		),
		
	));
		
		
	
    
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'پیامک', 'mweb' ),
        'id'     => 'mweb-verf',
        'desc'   => esc_html__( 'تنظیمات پیامک / ایمیل', 'mweb' ),
        'fields' => array(

			
			array(
				'id'       => 'lostpass_sms_form',
				'type'     => 'switch',
				'title'    => esc_html__( 'فعال سازی بازیابی رمز عبور از طریق پیامک', 'mweb' ),
				'subtitle' => esc_html__( 'این گزینه بعد از نسخه 4 قالب و برای کاربرانی که احراز هویت موبایلی انجام داده اند قابل استفاده  می باشد', 'mweb' ),
				'switch'   => true,
				'default'  => 0
			),
			
			array(
				'id'       => 'verify_status',
				'type'     => 'switch',
				'title'    => esc_html__( 'فعال سازی تایید موبایل', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'switch'   => true,
				'default'  => 0
			),
			array(
				'id'       => 'forced_verify_status',
				'type'     => 'switch',
				'title'    => esc_html__( 'اجباری کردن تایید موبایل ', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'switch'   => true,
				'default'  => 0
			),
			
			
			array(
                'id'       => 'verify_text',
                'type'     => 'textarea',
                'title'    => esc_html__( 'متن تایید شماره موبایل', 'mweb' ),
                'subtitle' => esc_html__( "کد : [code]", 'mweb' ),
                'default'  => 'کاربر گرامی کد تایید عبارت است از : [code]'
            ),
			
			array(
				'id'       => 'mweb_sms_gateway',
				'type'     => 'select',
				'required' => '',
				'title'    => esc_html__( 'سرویس دهنده پیامک', 'mweb' ),
				'subtitle' => 'اگر سرویس دهنده پیامکی دلخواه موجود نیست . از افزونه پیامک ووکامرس فارسی استفاده نمائید',
				'desc'     => 'اگر از افزونه پیامک ووکامرس استفاده می کنید میتوانید تنظیمات درگاه را خالی رها کنید',
				'options'  => array(
					'none'        => esc_html__( 'هیچ کدام', 'mweb' ),
					//'smsir'        => esc_html__( 'sms.ir', 'mweb' ),
					'_0098'        => esc_html__( '0098sms.com', 'mweb' ),
					'kavenegar'        => esc_html__( 'kavenegar.com', 'mweb' ),
					'sabanovin'        => esc_html__( 'sabanovin.com', 'mweb' ),
					'negins'        => esc_html__( 'shahrenovin.com', 'mweb' ),				
				),
				'default'  => 'none'
			),
			array(
                'id'       => 'mweb_sms_gateway_username',
                'type'     => 'text',
                'title'    => esc_html__( 'نام کاربری یا api', 'mweb' ),
                'subtitle' => esc_html__( "", 'mweb' ),
                'default'  => ''
            ),
			array(
                'id'       => 'mweb_sms_gateway_password',
                'type'     => 'text',
                'title'    => esc_html__( 'گذرواژه', 'mweb' ),
                'subtitle' => esc_html__( "", 'mweb' ),
                'default'  => ''
            ),
			array(
                'id'       => 'mweb_sms_gateway_number',
                'type'     => 'text',
                'title'    => esc_html__( 'شماره خط ارسالی', 'mweb' ),
                'subtitle' => esc_html__( "", 'mweb' ),
                'default'  => ''
            ),
			
			
			
          
        )
    ) );	
	
	


	/*Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'خدمات', 'mweb' ),
        'id'         => 'mweb_tools',
        'fields'     => array(
		    array(
                'id'       => 'mweb_tools_icon',
                'type'       => 'repeater',
                'title'    => esc_html__( 'آیکن خدمات', 'mweb' ),
                'subtitle' => esc_html__( '.', 'mweb' ),
                'fields'     => array(
		            array(
						'id'          => 'support_info_title',
						'type'     => 'text',
						'placeholder' => __( 'نام', 'mweb' ),
					),
					array(
						'id'          => 'support_info_link',
						'type'        => 'text',
						'placeholder' => __( 'لینک', 'mweb' ),
					),
		            array(
						'id'       => 'support_info_icon',
						'title'    => esc_html__( 'انتخاب آیکون', 'mweb' ),
						'subtitle' => esc_html__( 'مثال: credit-card', 'mweb' ),
						'type'        => 'text',
						'placeholder' => __( '', 'mweb' ),
					),
		
				)
            ),

        )
        
		));*/
	
    // Singles	
	
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'صفحات داخلی', 'mweb' ),
        'id'     => 'mweb-single',
        'desc'   => esc_html__( 'تنظیمات صفحات داخلی', 'mweb' ),
        'fields' => array(

			
			array(
				'id'       => 'single_sidebar_position',
				'type'     => 'image_select',
				'title'    => 'موقعیت سایدبار',
				'subtitle' => 'انتخاب موقعیت سایدبار',
				'options'  => mweb_theme_config::sidebar_position(),
				'default'  => 'default'
			),
			array(
				'id'       => 'default_single_post_sidebar',
				'type'     => 'select',
				'title'    => esc_html__( 'سایدبار پیشفرض', 'mweb' ),
				'subtitle' => esc_html__( 'انتخاب کنید', 'mweb' ),
				'options'  => mweb_theme_config::sidebar_name(),
				'default'  => 'sidebar_default'
			),
          
        )
    ) );
	
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'مطالب عمومی', 'mweb' ),
        'id'         => 'mweb-single_general',
        'subsection' => true,
        'fields'     => array(
		
			
			array(
                'id'       => 'mweb-tag',
                'type'     => 'switch',
                'title'    => esc_html__( 'برچسب', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش و عدم نمایش برچسب ها.', 'mweb' ),
                'default'  => true,
            ),
			
			array(
                'id'       => 'mweb-single-share',
                'type'     => 'switch',
                'title'    => esc_html__( 'اشتراک گذاری', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش و عدم نمایش دکمه های اشتراک گذاری.', 'mweb' ),
                'default'  => true,
            ),
			
		
			array(
                'id'       => 'mweb_single_comment',
                'type'     => 'switch',
                'title'    => esc_html__( 'نظرات', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش و عدم نمایش قسمت نظرات.', 'mweb' ),
                'default'  => true,
            ),
			
						
        ),
        
		)

	);
	
	


	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'مطالب مرتبط وبلاگ', 'mweb' ),
        'id'         => 'mweb_related_post_section',
        'subsection' => true,
        'fields'     => array(
		
			array(
                'id'       => 'mweb_show_relpost',
                'type'     => 'switch',
                'title'    => esc_html__( 'مطالب مرتبط', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش یا عدم نمایش', 'mweb' ),
                'default'  => true,
            ),
			
			array(
				'id'       => 'single_related_where',
				'type'     => 'select',
				'required' => array( 'mweb_show_relpost', '=', '1' ),
				'title'    => esc_html__( 'براساس :', 'mweb' ),
				'subtitle' => esc_html__( 'نمایش مطالب مرتبط', 'mweb' ),
				'options'  => array(
					'all'        => esc_html__( 'دسته بندی و برچسب', 'mweb' ),
					'tags'       => esc_html__( 'برچسب ها', 'mweb' ),
					'categories' => esc_html__( 'دسته بندی ها', 'mweb' ),
				),
				'default'  => 'all'
			),
			
			array(
                'id'       => 'mweb_num_relpost',
                'type'     => 'slider',
                'title'    => esc_html__( 'تعداد مطالب', 'mweb' ),
                'subtitle' => esc_html__( 'یک مقدار عددی وارد کنید', 'mweb' ),
                'default'  => 3,
				"min"      => 1,
				"step"     => 1,
				"max"      => 10,
            ),
			
			
        ),
        
		)

	);	
	
	
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'محصول', 'mweb' ),
        'id'         => 'mweb-single_product',
        'subsection' => true,
        'fields'     => array(
			
			array(
                'id'       => 'mweb_video_player',
                'type'     => 'select',
                'title'    => esc_html__( 'انتخاب پخش ویدیو', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'options'  => array(
					'mediaelement'  => esc_html__( 'MediaElement.js', 'mweb' ),
					'videojs'  => esc_html__( 'Video.js', 'mweb' ),

				),
				'default'  => 'mediaelement'
            ),
			
			array(
                'id'       => 'mweb_tools_icon_single',
                'type'       => 'repeater',
                'title'    => esc_html__( 'آیکن خدمات', 'mweb' ),
                'subtitle' => esc_html__( 'https://fontawesome.com/icons?d=gallery&s=light', 'mweb' ),
                'fields'     => array(
		            array(
						'id'          => 'wcp_info_title',
						 'type'     => 'text',
						'placeholder' => __( 'نام', 'mweb' ),
					),
					array(
						'id'          => 'wcp_info_link',
						'type'        => 'text',
						'placeholder' => __( 'لینک', 'mweb' ),
					),
					array(
						'id'          => 'wcp_info_img',
						'type'        => 'text',
						'title'    => esc_html__( 'انتخاب آیکن به صورت تصویر', 'mweb' ),
						'placeholder' => __( 'آدرس آیکن دلخواه', 'mweb' ),
					),
		            array(
						'id'          => 'wcp_info_icon',
						'type'        => 'text',
						'placeholder' => __( 'آیکن - مثال archive', 'mweb' ),
					),
		
				)
            ),
			
			array(
                'id'       => 'mweb_the_rules_on_off',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش قوانین و مزایای خرید', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_product_benefit',
                'type'       => 'repeater',
                'title'    => esc_html__( 'مزایای خرید', 'mweb' ),
                'subtitle' => esc_html__( '.', 'mweb' ),
                'fields'     => array(
		            array(
						'id'          => 'mweb_product_benefit_x',
						 'type'     => 'text',
						'placeholder' => __( 'عنوان', 'mweb' ),
					),
				
				)
            ),
			array(
                'id'       => 'mweb_add_tcart_single',
                'type'     => 'text',
                'title'    => esc_html__( 'متن شرکت در دوره', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'دانلود کامل دوره',
            ),
			array(
                'id'       => 'mweb_before_course_price',
                'type'     => 'text',
                'title'    => esc_html__( 'متن قیمت دوره ', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'قیمت دوره',
            ),
			array(
                'id'       => 'mweb_outofstock_text',
                'type'     => 'text',
                'title'    => esc_html__( 'متن غیر فعال یا اتمام دوره', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'امکان خرید دوره وجود ندارد',
            ),
			array(
                'id'       => 'mweb_bought_show',
                'type'     => 'text',
                'title'    => esc_html__( 'متن شرکت کنندگان در دوره', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'به طور مثال : شما دانشجوی این دوره هستید',
            ),
			array(
                'id'       => 'mweb_bought_show_file',
                'type'     => 'text',
                'title'    => esc_html__( 'متن خریداران فایل', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'به طور مثال : شما این فایل را خریداری کرده اید',
            ),
			array(
                'id'       => 'mweb_remove_addtocart',
                'type'     => 'switch',
                'title'    => esc_html__( 'حذف دکمه افزودن به خرید', 'mweb' ),
                'subtitle' => esc_html__( 'مخصوص خریدارن محصول', 'mweb' ),
                'default'  => false,
            ),
			array(
                'id'       => 'mweb_the_rules_title',
                'type'     => 'text',
                'title'    => esc_html__( 'عنوان قوانین استفاده', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => '',
            ),
			array(
                'id'       => 'mweb_the_rules_content',
                'type'     => 'editor',
                'title'    => esc_html__( 'متن قوانین', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => '',
            ),
			array(
                'id'       => 'mweb_count_sell',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش تعداد دانشجو', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_show_modified',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش تاریخ ویرایش', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_show_author',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش نام نویسنده', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			/*array(
                'id'       => 'mweb_product_files',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش فایل های محصول', 'mweb' ),
                'subtitle' => esc_html__( 'ویژه خریدارن', 'mweb' ),
                'default'  => true,
            ),*/
			array(
                'id'       => 'mweb_count_view',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش تعداد بازدید', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_date_publish',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش تاریخ محصول', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_cart_sticky_desktop',
                'type'     => 'switch',
                'title'    => esc_html__( 'افزودن به سبد خرید شناور', 'mweb' ),
                'subtitle' => esc_html__( 'مخصوص ادامه محصول پیشفرض نسخه دسکتاپ', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_cart_sticky_mobile',
                'type'     => 'switch',
                'title'    => esc_html__( 'افزودن به سبد خرید شناور موبایل', 'mweb' ),
                'subtitle' => esc_html__( 'نسخه موبایل', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_product_single_sidebar',
                'type'     => 'switch',
                'title'    => esc_html__( 'سایدبار راست', 'mweb' ),
                'subtitle' => esc_html__( 'بله / خیر', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_like_dislike_restriction',
                'type'     => 'select',
                'title'    => esc_html__( 'محدودیت امتیاز دهی نظرات', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'options'  => array(
					'cookie'  => esc_html__( 'کوکی', 'mweb' ),
					'ip'  => esc_html__( 'آی پی', 'mweb' ),
					'user'  => esc_html__( 'کاربر', 'mweb' ),
					'no'  => esc_html__( 'بدون محدودیت', 'mweb' ),
				),
				'default'  => 'ip'
            ),
			array(
                'id'       => 'mweb_comment_rules',
                'type'     => 'editor',
                'title'    => esc_html__( 'قوانین دیدگاه', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => '',
            ),
			array(
                'id'       => 'mweb_course_tab_title',
                'type'     => 'text',
                'title'    => esc_html__( 'عنوان تب سرفصل های دوره', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => '',
            ),
			array(
				'id'       => 'mweb_product_tab_style',
				'type'     => 'select',
				'required' => '',
				'title'    => esc_html__( 'استایل تب های محصول :', 'mweb' ),
				'subtitle' => '',
				'options'  => array(
					'none'        => esc_html__( 'پیشفرض', 'mweb' ),
					'tabs_one'        => esc_html__( 'یک', 'mweb' ),
					'tabs_two'       => esc_html__( 'دو', 'mweb' ),
					'tabs_three'       => esc_html__( 'سه', 'mweb' )
				),
				'default'  => 'none'
			),
			
			array(
                'id'       => 'mweb_curriculum_enable',
                'type'     => 'switch',
                'title'    => esc_html__( 'فعال سازی تقویم آموزشی', 'mweb' ),
                'subtitle' => esc_html__( 'بله / خیر', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_curriculum_title',
                'type'     => 'text',
                'title'    => esc_html__( 'عنوان تقویم آموزشی', 'mweb' ),
				'required' => array('mweb_curriculum_enable', '=' , '1'),
				'default'  => 'تقویم آموزشی',
            ),
			
			array(
                'id'       => 'mweb_faq_enable',
                'type'     => 'switch',
                'title'    => esc_html__( 'فعال سازی راهنما یا سوالات متداول و ...', 'mweb' ),
                'subtitle' => esc_html__( 'بله / خیر', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_faq_title',
                'type'     => 'text',
                'title'    => esc_html__( 'عنوان راهنما یا سوالات متداول و ...', 'mweb' ),
				'required' => array('mweb_faq_enable', '=' , '1'),
				'default'  => 'سوالات متداول',
            ),
		
			
        ),
        
		)

	);




	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'مطالب مرتبط محصولات', 'mweb' ),
        'id'         => 'mweb_related_product_section',
        'subsection' => true,
        'fields'     => array(

			array(
                'id'       => 'mweb_num_relproduct',
                'type'     => 'slider',
                'title'    => esc_html__( 'تعداد محصول', 'mweb' ),
                'subtitle' => esc_html__( 'یک مقدار عددی وارد کنید', 'mweb' ),
                'default'  => '5',
				"min"      => 1,
				"step"     => 1,
				"max"      => 10,
            ),
			
        ),
        
		)
	);	
	
	
	
    // blog
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'وبلاگ', 'mweb' ),
        'id'     => 'mweb_blog_home',
        'desc'   => esc_html__( 'تنظیمات وبلاگ', 'mweb' ),
        'fields' => array(
		
			array(
				'id'       => 'home_sidebar',
				'type'     => 'select',
				'title'    => 'سایدبار',
				'subtitle' => 'انتخاب سایدبار',
				'options'  => mweb_theme_config::sidebar_name(),
				'default'  => 'sidebar_default'
			),
			array(
				'id'       => 'home_sidebar_position',
				'type'     => 'image_select',
				'title'    => 'موقعیت سایدبار',
				'subtitle' => 'انتخاب موقعیت سایدبار',
				'options'  => mweb_theme_config::sidebar_position(),
				'default'  => 'default'
			)		    
           
			
    	)
    ) );    
	
	
	
	
	// page
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'برگه', 'mweb' ),
        'id'     => 'mweb_page_option',
        'desc'   => esc_html__( 'تنظیمات برگه', 'mweb' ),
        'fields' => array(
		
			array(
				'id'       => 'page_sidebar',
				'type'     => 'select',
				'title'    => 'سایدبار',
				'subtitle' => 'انتخاب سایدبار',
				'options'  => mweb_theme_config::sidebar_name(),
				'default'  => 'sidebar_default'
			),
			array(
				'id'       => 'page_sidebar_position',
				'type'     => 'image_select',
				'title'    => 'موقعیت سایدبار',
				'subtitle' => 'انتخاب موقعیت سایدبار',
				'options'  => mweb_theme_config::sidebar_position(),
				'default'  => 'default'
			)		    
           
			
    	)
    ) );  
	
	
	
	
	// archive post
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'آرشیو', 'mweb' ),
        'id'     => 'mweb_archive_home',
        'desc'   => esc_html__( 'تنظیمات آرشیو', 'mweb' ),
        'fields' => array(
		
		
			array(
				'id'       => 'archive_sidebar',
				'type'     => 'select',
				'title'    => 'سایدبار',
				'subtitle' => 'انتخاب سایدبار',
				'options'  => mweb_theme_config::sidebar_name(),
				'default'  => 'sidebar_default'
			),
			array(
				'id'       => 'archive_sidebar_position',
				'type'     => 'image_select',
				'title'    => 'موقعیت سایدبار',
				'subtitle' => 'انتخاب موقعیت سایدبار',
				'options'  => mweb_theme_config::sidebar_position(),
				'default'  => 'default'
			),
			
    	)
    ) );   
	

	
	
	// archive product
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'آرشیو محصولات', 'mweb' ),
        'id'     => 'mweb_product_archive_home',
        'desc'   => esc_html__( 'تنظیمات آرشیو', 'mweb' ),
        'fields'     => array(

			array(
                'id'       => 'mweb_num_product',
                'type'     => 'slider',
                'title'    => esc_html__( 'تعداد محصول', 'mweb' ),
                'subtitle' => esc_html__( 'یک مقدار عددی وارد کنید', 'mweb' ),
                'default'  => '12',
				"min"      => 1,
				"step"     => 1,
				"max"      => 30,
            ),
			
			array(
				'id'       => 'mweb_product_sidebar',
				'type'     => 'select',
				'title'    => 'سایدبار',
				'subtitle' => 'انتخاب سایدبار',
				'options'  => mweb_theme_config::sidebar_name(),
				'default'  => 'sidebar_default'
			),
			
			array(
				'id'       => 'product_archive_sidebar_position',
				'type'     => 'image_select',
				'title'    => 'موقعیت سایدبار',
				'subtitle' => 'انتخاب موقعیت سایدبار',
				'options'  => mweb_theme_config::sidebar_position(),
				'default'  => 'default'
			),
			array(
				'id'       => 'badge_style',
				'type'     => 'select',
				'title'    => esc_html__( 'استایل برچسب محصول', 'mweb' ),
				'options'  => array(
					'circle'        => esc_html__( 'دایره ', 'mweb' ),
					'square'       => esc_html__( 'مربع', 'mweb' ),
				),
				'default'  => 'circle'
			),
			
        ),
        
		)
	);	
	
	
	
	
	// dokan
    
    /*Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'دکان', 'mweb' ),
        'id'     => 'mweb_store',
        'desc'   => esc_html__( 'در صورت استفاده از افزونه چند فروشندگی', 'mweb' ),
        'fields' => array(
		
		array(
                'id'       => 'mweb_vendor_earning',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش میزان درآمد', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
		array(
                'id'       => 'mweb_vendor_buy',
                'type'     => 'switch',
                'title'    => esc_html__( 'نمایش تعداد خرید', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
		
			
           
			
    	)
    ) );   */
	
	
	
	// popup
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'پاپ آپ', 'mweb' ),
        'id'     => 'mweb_popup',
        'desc'   => esc_html__( 'تنظیمات آرشیو', 'mweb' ),
        'fields'     => array(
			array(
				'id'       => 'mweb_popup_pic',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'عکس پاپ آپ', 'mweb' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( "آپلود کنید", 'mweb' ),
			), 
			array(
                'id'       => 'mweb_popup_link',
                'type'     => 'text',
                'title'    => esc_html__( 'لینک', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'http://',
            ), 
			array(
                'id'       => 'mweb_popup_day',
                'type'     => 'slider',
                'title'    => esc_html__( 'تعداد روز کوکی ', 'mweb' ),
                'subtitle' => esc_html__( 'مدت زمان از بستن پنجره پاپ آپ تا بارگذاری مجدد ان', 'mweb' ),
                'default'  => '12',
				"min"      => 1,
				"step"     => 1,
				"max"      => 30,
            ),

        ),
        
		)
	);	


    

	
	// Sidebars
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'سایدبار', 'mweb' ),
        'id'     => 'mweb-sidebars',
        'fields' => array(
            array(
                'id'       => 'mweb_multi_sidebar',
                'type'     => 'multi_text',
                'title'    => esc_html__( 'ایجاد سایدبار', 'mweb' ),
                'subtitle' => esc_html__( 'از حروف انگلیسی استفاده کنید', 'mweb' ),
				'default'  => array()
            ),
			/* array(
                'id'       => 'sticky_sidebar',
                'type'     => 'switch',
                'title'    => esc_html__( 'سایدبار شناور', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => false,
            ) */
			
            
    	)
    ) );
	
	
	// typography
	
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'تایپوگرافی', 'mweb' ),
        'id'     => 'mweb-typography',
        'fields' => array(
			array(
				'id'          => 'menu-typography',
				'type'        => 'typography', 
				'title'       => __('منو اصلی', 'mweb'),
				'google'      => false, 
				'font-family' => false, 
				'text-align'  => false, 
				'font-style'  => false, 
				'font-weight' => true, 
				//'output'      => array('h2.site-description'),
				'units'       =>'px',
				//'subtitle'    => __('', 'mweb'),
				'default'     => array(
					'color'       => '#333', 
					'font-weight'  => '500', 
					'font-size'   => '12px', 
					'line-height' => '49px'
				),
			),
			array(
				'id'          => 'content-typography',
				'type'        => 'typography', 
				'title'       => __('محتوای محصولات و وبلاگ', 'mweb'),
				'google'      => false, 
				'font-family' => false, 
				'text-align'  => false, 
				'font-style'  => false, 
				'font-weight' => true, 
				//'output'      => array('h2.site-description'),
				'units'       =>'px',
				//'subtitle'    => __('', 'mweb'),
				'default'     => array(
					'font-size'   => '12px', 
					'line-height' => '23px'
				),
			),
			array(
				'id'          => 'ch2-typography',
				'type'        => 'typography', 
				'title'       => __('تگ H2', 'mweb'),
				'google'      => false, 
				'font-family' => false, 
				'text-align'  => false, 
				'font-style'  => false, 
				'font-weight' => true, 
				//'output'      => array('h2.site-description'),
				'units'       =>'px',
				//'subtitle'    => __('', 'mweb'),
				'default'     => array(
					'font-weight'   => '500', 
				),
			),
			array(
				'id'          => 'ch3-typography',
				'type'        => 'typography', 
				'title'       => __('تگ H3', 'mweb'),
				'google'      => false, 
				'font-family' => false, 
				'text-align'  => false, 
				'font-style'  => false, 
				'font-weight' => true, 
				//'output'      => array('h2.site-description'),
				'units'       =>'px',
				//'subtitle'    => __('', 'mweb'),
				'default'     => array(
					'font-weight'   => '500', 
				),
			),
			array(
				'id'          => 'ch4-typography',
				'type'        => 'typography', 
				'title'       => __('تگ H4', 'mweb'),
				'google'      => false, 
				'font-family' => false, 
				'text-align'  => false, 
				'font-style'  => false, 
				'font-weight' => true, 
				//'output'      => array('h2.site-description'),
				'units'       =>'px',
				//'subtitle'    => __('', 'mweb'),
				'default'     => array(
					'font-weight'   => '500', 
				),
			),
           
			
            
    	)
    ) );
	

	
	 // color

	 Redux::setSection( $opt_name, array(
			'title'  => esc_html__( 'رنگبندی', 'mweb' ),
			'id'     => 'mweb_colors',
			'desc'   => esc_html__( 'تنظیمات رنگبندی', 'mweb' ),
			'fields' => array(

			array(
				'id'       => 'color_main',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ اصلی', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),
			array(
				'id'       => 'color_sec',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ فرعی', 'mweb' ),
				'subtitle' => esc_html__( '', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),
			array(
				'id'       => 'color1',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ 1', 'mweb' ),
				'subtitle' => esc_html__( 'پس زمینه سایت', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),
			array(
				'id'       => 'color2',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ 2', 'mweb' ),
				'subtitle' => esc_html__( 'رنگ برچسب', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),	
			array(
				'id'       => 'color3',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ 3', 'mweb' ),
				'subtitle' => esc_html__( 'رنگ پس زمینه پابرگ', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),	
			array(
				'id'       => 'color5',
				'type'     => 'color',
				'title'    => esc_html__( 'رنگ 4', 'mweb' ),
				'subtitle' => esc_html__( 'رنگ دکمه افزودن به سبد خرید', 'mweb' ),
				'default'  => '',
	 			'validate' => 'color',
			),	

        )
    ) );
	
	
	
	
    // Social Icons
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'شبکه اجتماعی', 'mweb' ),
        'id'     => 'socialicons',
        'fields' => array(
		array(
			'id'       => 'mweb_social_icons',
			'type'     => 'sortable',
			'title'    => esc_html__( 'شبکه های اجتماعی سایت', 'mweb' ),
			'subtitle' => esc_html__( 'به راحتی میتوانید با کشیدن و رها کردن گزینه ها را جابجا کنید', 'mweb' ),
			'label'    => true,
			'options'  => array(
				'facebook' => 'http://your_facebook_page_url',
				'twitter' => '#',
				'instagram' => '',
				'telegram' => '#',
				'flickr' => '',
				'youtube' => '',
				'aparat' => '',
				'digg' => '',
				'dribble' => '',
				'dropbox' => '',
				'github' => '',
				'linkedin' => '',
				'pinterest' => '',
				'soundcloud' => '',
				'spotify' => '',
				'stack-overflow' => '',
				'vine' => '',
				'vimeo-square' => '',
		   
			)
		),
		array(
                'id'       => 'sharing_social_medias',
                'type'     => 'select',
                'multi'    => true,
                'title'    => esc_html__( 'اشتراک مطالب', 'mweb' ),
                'subtitle' => esc_html__( 'به راحتی میتوانید با کشیدن و رها کردن گزینه ها را جابجا کنید', 'mweb' ),
                'options'  => array(
                    'facebook' => 'فیسبوک',
                    'twitter' => 'تویتر',
                    'telegram' => 'تلگرام',
                    'whatsapp' => 'واتس آپ',
                    //'youtube' => 'یوتیوب',
                    'linkedin' => 'لینکدین',
                    'pinterest' => 'پینترست',
                )
            ),
			
		array(
                'id'       => 'sharing_social_product',
                'type'     => 'select',
                'multi'    => true,
                'title'    => esc_html__( 'اشتراک محصول', 'mweb' ),
                'subtitle' => esc_html__( 'به راحتی میتوانید با کشیدن و رها کردن گزینه ها را جابجا کنید', 'mweb' ),
                'options'  => array(
                    'facebook' => 'فیسبوک',
                    'twitter' => 'تویتر',
                    'telegram' => 'تلگرام',
                    //'whatsapp' => 'واتس آپ',
                    //'youtube' => 'یوتیوب',
                    'linkedin' => 'لینکدین',
                    'pinterest' => 'پینترست',
                )
            ),
            
    	)
    ) );  




	

	

    // Footer
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'پابرگ', 'mweb' ),
        'id'     => 'mweb_footer',
        'desc'   => esc_html__( 'تنظیمات پابرگ', 'mweb' ),
        'fields' => array(
			array(
                'id'       => 'mweb_footer_switch',
                'type'     => 'select',
                'title'    => esc_html__( 'نوع پابرگ', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'options'  => array(
					'1'  => esc_html__( 'یک', 'mweb' ),
					'2'  => esc_html__( 'دو', 'mweb' ),
				),
				'default'  => '1'
            ),
            array(
                'id'       => 'mweb_copyright',
                'type'     => 'textarea',
                'title'    => esc_html__( 'متن کپی رایت', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => 'کلیه حقوق مادی و معنوی برای این سایت محفوظ می باشد',
            ), 
						
			array(
                'id'       => 'mweb_gototop',
                'type'     => 'switch',
                'title'    => esc_html__( 'رفتن به بالا', 'mweb' ),
                'subtitle' => esc_html__( 'نمایش و عدم نمایش دکمه رفتن به بالا.', 'mweb' ),
                'default'  => true,
            ),
			array(
                'id'       => 'mweb_footer_column',
                'type'     => 'select',
                'title'    => esc_html__( 'ستون بندی پابرگ', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'options'  => array(
					'12'  => esc_html__( '12', 'mweb' ),
					'3_3_3_3'  => esc_html__( '3/3/3/3', 'mweb' ),
					'4_4_4'  => esc_html__( '4/4/4', 'mweb' ),
					'3_3_6'  => esc_html__( '3/3/6', 'mweb' ),
					'3_4_5'  => esc_html__( '3/4/5', 'mweb' ),
					'2_2_2_6'  => esc_html__( '2/2/2/6', 'mweb' ),
					'2_3_3_4'  => esc_html__( '2/3/3/4', 'mweb' ),
					'2_2_4_4'  => esc_html__( '2/3/3/4', 'mweb' ),
					'2_2_2_3_3'  => esc_html__( '2/2/2/3/3', 'mweb' ),
				),
				'default'  => '2_3_3_4'
            ),
			array(
                'id'       => 'mweb_footer_column_reverse',
                'type'     => 'switch',
                'title'    => esc_html__( 'معکوس کردن ترتیب ستون ها', 'mweb' ),
                'subtitle' => esc_html__( 'تنها تغییر در اندازه ستون های اعمال میشود', 'mweb' ),
                'default'  => false,
            ),
			
			
			array(
                'id'       => 'mweb-footer-pat',
                'type'     => 'background',
				'background-color' => false,
                'title'    => esc_html__( 'تصویر پس زمینه پابرگ', 'mweb' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( "آپلود کنید", 'mweb' ),
                'default'  => ''
            ),
			
			array(
                'id'    => 'mweb_mahdisweb',
                'type'  => 'info',
                'title' => __('حذف لوگو ماهدیس وب', 'mweb'),
                'style' => 'warning',
                'desc'  => __('لطفا برای حمایت از ما جهت ارائه اپدیت های منظم کپی رایت را حفظ کنید', 'mweb')
            ),
			array(
                'id'       => 'mweb_mahdisweb_switch',
                'type'     => 'switch',
                'title'    => esc_html__( 'عدم نمایش کپی رایت', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => true,
            ),
			
    	)
    ) );   


	Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'منو شناور', 'mweb' ),
		'id'         => 'mweb_btn_elm',
		'subsection' => true,
		'fields'     => array(
			
			array(
				'id'       => 'mweb_btn_elm_icon',
				'type'     => 'text',
				'title'    => esc_html__( 'آیکن منو', 'mweb' ),
                'subtitle' => esc_html__( 'https://fontawesome.com/icons?d=gallery&s=light', 'mweb' ),
				'default'  => 'fal fa-question-circle'
			),	
			array(
				'id'		=> 'mweb_btn_elm_menu',
				'title'		=> __( 'انتخاب منو', 'mweb' ),
				'subtitle'	=> __( '', 'mweb' ),
				'type'		=> 'select',
				'data'		=> 'menus',
			),
			array(
				'id'      => 'mweb_btn_elm_cdn',
				'type'    => 'sorter',
				'title'   => 'فعال سازی در',
				'desc'    => '',
				'options' => array(
					'enabled'  => array(
					),
					'disabled' => array(
						'btn_elm_desktop' => 'دسکتاپ',
						'btn_elm_mobile'  => 'موبایل',
					)
				),
			),
			
			
	
						
		),
		
	));
			
    

		
		
		
	Redux::setSection( $opt_name, array(
	'title'      => esc_html__( 'برگه ارتباط با ما', 'mweb' ),
	'id'         => 'mweb_contact_page',
	'fields'     => array(
				
		array(
			'id'       => 'mweb_contact_map',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'عکس ادرس روی نقشه', 'mweb' ),
			'compiler' => 'true',
			'subtitle' => esc_html__( "آپلود کنید - 465x360", 'mweb' ),
			//'default'  => array( 'url' => get_template_directory_uri() . '/images/logo.png' ),
		),
		array(
			'id'          => 'mweb_contact_address',
			'type'        => 'text',
			'title'    => esc_html__( 'آدرس', 'mweb' ),
		),
		array(
			'id'          => 'mweb_contact_email',
			'type'        => 'text',
			'title'    => esc_html__( 'ایمیل', 'mweb' ),
		),
		array(
			'id'          => 'mweb_contact_tell',
			'type'        => 'text',
			'title'    => esc_html__( 'تلفن', 'mweb' ),
		),
		array(
			'id'          => 'mweb_cform',
			'type'        => 'text',
			'title'    => esc_html__( 'شورتکد فرم ارتباط با ما', 'mweb' ),
		),
		
	)
	));
	


    
    // Advanced 
    
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'پیشرفته', 'mweb' ),
        'id'     => 'mweb_advanced',
        'fields' => array(
            array(
                'id'       => 'custom_css',
                'type'     => 'ace_editor',
                'title'    => esc_html__( 'کد CSS سفارشی', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'mode'     => 'css',
                'theme'    => 'monokai',
                'default'  => "#header{\n   margin: 0 auto;\n}"
            ),
			array(
                'id'       => 'mweb_custom_file_cssjs',
                'type'     => 'switch',
                'title'    => esc_html__( 'بارگذاری فایل های پیشرفته js و css', 'mweb' ),
                'subtitle' => esc_html__( '', 'mweb' ),
                'default'  => false,
            ),
    	)
    ) );


    
  

    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */


    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {

            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'mweb' ),
                'desc'   => esc_html__( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'mweb' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

	

