/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-05-13 18:23:58 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3473 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=118535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=7491 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=299 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=878 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `currency` varchar(5) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_customer` (
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_1` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_2` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `postcode` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `fk_order_customer_order_idx` (`order_id`),
  CONSTRAINT `fk_order_customer_order` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `tax_class` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_total` int(11) DEFAULT NULL,
  `subtotal` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_order_item_order1_idx` (`order_id`),
  CONSTRAINT `fk_order_item_order1` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_nice_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_transaction_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_transaction_order1_idx` (`order_id`),
  CONSTRAINT `fk_transaction_order1` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_session` (
  `key` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expiry` datetime NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_download_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_ip` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `download_id` bigint(20) NOT NULL,
  `version_id` bigint(20) NOT NULL,
  `version` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `download_date` datetime DEFAULT NULL,
  `download_status` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `download_status_message` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`download_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8930 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jet_smart_filters_indexer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int(10) unsigned DEFAULT NULL,
  `item_query` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_key` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_value` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mweb_sms_verify` (
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `id` mediumint(8) DEFAULT NULL,
  `counter` int(11) DEFAULT 0,
  `last` int(11) DEFAULT 0,
  `code` mediumint(8) DEFAULT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=718717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=37111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2603 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=53705 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT 1,
  `module_id` int(11) unsigned NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `match_url` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `match_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `regex` int(11) unsigned NOT NULL DEFAULT 0,
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  `last_count` int(10) unsigned NOT NULL DEFAULT 0,
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `match_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sent_to` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_data` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect_by` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_sm_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` longtext COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tags` longtext COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `scope` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'global',
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=248 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=36793 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=1471 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8607 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  `content_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `product_or_parent_id_term_id` (`product_or_parent_id`,`term_id`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woo_wallet_transaction_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woo_wallet_transactions` (
  `transaction_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) unsigned NOT NULL DEFAULT 1,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `amount` decimal(16,8) DEFAULT NULL,
  `balance` decimal(16,8) DEFAULT NULL,
  `currency` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` bigint(20) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`transaction_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM AUTO_INCREMENT=975 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8 COLLATE utf8_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=6508 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=724 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=1717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yith_wcan_filter_sessions` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` char(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_vars` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `filter_hash` (`hash`),
  UNIQUE KEY `filter_token` (`token`),
  KEY `filter_expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `prod_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `session_id` varchar(255) DEFAULT NULL,
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  UNIQUE KEY `wishlist_token_2` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=MyISAM AUTO_INCREMENT=155 DEFAULT CHARSET=utf8;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES 
("3282","wc-admin_import_customers","complete","2022-04-14 18:37:51","2022-04-14 23:07:51","[900]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1649961471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1649961471;}","4","1","2022-04-14 18:38:10","2022-04-14 23:08:10","0",NULL),
("3283","wc-admin_import_customers","complete","2022-04-15 12:25:32","2022-04-15 16:55:32","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1650025532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1650025532;}","4","1","2022-04-15 12:26:13","2022-04-15 16:56:13","0",NULL),
("3284","wc-admin_import_customers","complete","2022-04-15 21:17:41","2022-04-16 01:47:41","[900]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1650057461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1650057461;}","4","1","2022-04-15 21:20:42","2022-04-16 01:50:42","0",NULL),
("3285","wc-admin_import_customers","complete","2022-04-17 10:42:47","2022-04-17 15:12:47","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1650192167;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1650192167;}","4","1","2022-04-17 10:43:11","2022-04-17 15:13:11","0",NULL),
("3286","wc-admin_import_customers","complete","2022-04-19 16:45:07","2022-04-19 21:15:07","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1650386707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1650386707;}","4","1","2022-04-19 16:47:02","2022-04-19 21:17:02","0",NULL),
("3287","wc-admin_import_customers","complete","2022-04-26 09:00:30","2022-04-26 13:30:30","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1650963630;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1650963630;}","4","1","2022-04-26 09:02:48","2022-04-26 13:32:48","0",NULL),
("3288","wc-admin_import_customers","complete","2022-04-30 04:17:40","2022-04-30 08:47:40","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651292260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651292260;}","4","1","2022-04-30 04:18:01","2022-04-30 08:48:01","0",NULL),
("3289","wc-admin_import_customers","complete","2022-05-01 10:03:22","2022-05-01 14:33:22","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651399402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651399402;}","4","1","2022-05-01 10:04:11","2022-05-01 14:34:11","0",NULL),
("3290","wc-admin_import_customers","complete","2022-05-01 10:05:42","2022-05-01 14:35:42","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651399542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651399542;}","4","1","2022-05-01 10:06:16","2022-05-01 14:36:16","0",NULL),
("3291","woocommerce_run_update_callback","complete","2022-05-01 10:20:07","2022-05-01 14:50:07","{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400407;}","2","1","2022-05-01 10:20:09","2022-05-01 14:50:09","0",NULL),
("3292","woocommerce_run_update_callback","complete","2022-05-01 10:20:08","2022-05-01 14:50:08","{\"update_callback\":\"wc_update_630_db_version\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400408;}","2","1","2022-05-01 10:20:09","2022-05-01 14:50:09","0",NULL),
("3293","woocommerce_update_db_to_current_version","complete","2022-05-01 10:20:09","2022-05-01 14:50:09","{\"version\":\"6.3.1\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400409;}","2","1","2022-05-01 10:20:09","2022-05-01 14:50:09","0",NULL),
("3294","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2022-05-01 10:20:10","2022-05-01 14:50:10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400410;}","2","1","2022-05-01 10:21:00","2022-05-01 14:51:00","0",NULL),
("3295","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2022-05-01 10:21:01","2022-05-01 14:51:01","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400461;}","2","1","2022-05-01 10:21:07","2022-05-01 14:51:07","0",NULL),
("3296","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2022-05-01 10:21:08","2022-05-01 14:51:08","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400468;}","2","1","2022-05-01 10:21:14","2022-05-01 14:51:14","0",NULL),
("3297","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2022-05-01 10:21:15","2022-05-01 14:51:15","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400475;}","2","1","2022-05-01 10:21:20","2022-05-01 14:51:20","0",NULL),
("3298","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2022-05-01 10:21:21","2022-05-01 14:51:21","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651400481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651400481;}","2","1","2022-05-01 10:21:27","2022-05-01 14:51:27","0",NULL),
("3299","wc-admin_import_customers","complete","2022-05-02 08:56:34","2022-05-02 13:26:34","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651481794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651481794;}","4","1","2022-05-02 08:57:29","2022-05-02 13:27:29","0",NULL),
("3300","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:02:02","2022-05-02 17:32:02","0",NULL),
("3301","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-02 13:01:51","2022-05-02 17:31:51","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496511;}","2","1","2022-05-02 13:02:02","2022-05-02 17:32:02","0",NULL),
("3302","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:02:02","2022-05-02 17:32:02","0",NULL),
("3303","wc-admin_import_customers","complete","2022-05-02 13:02:21","2022-05-02 17:32:21","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496541;}","4","1","2022-05-02 13:02:53","2022-05-02 17:32:53","0",NULL),
("3304","wc-admin_import_orders","complete","2022-05-02 13:02:21","2022-05-02 17:32:21","[2592]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496541;}","4","1","2022-05-02 13:02:53","2022-05-02 17:32:53","0",NULL),
("3305","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:02:53","2022-05-02 17:32:53","0",NULL),
("3306","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-02 13:02:40","2022-05-02 17:32:40","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496560;}","2","1","2022-05-02 13:02:53","2022-05-02 17:32:53","0",NULL),
("3307","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:03:16","2022-05-02 17:33:16","0",NULL),
("3308","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-02 13:03:02","2022-05-02 17:33:02","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496582;}","2","1","2022-05-02 13:03:16","2022-05-02 17:33:16","0",NULL),
("3309","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:05:34","2022-05-02 17:35:34","0",NULL),
("3310","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-02 13:05:22","2022-05-02 17:35:22","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496722;}","2","1","2022-05-02 13:05:35","2022-05-02 17:35:35","0",NULL),
("3311","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:07:56","2022-05-02 17:37:56","0",NULL),
("3312","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-02 13:07:01","2022-05-02 17:37:01","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651496821;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651496821;}","2","1","2022-05-02 13:07:56","2022-05-02 17:37:56","0",NULL),
("3313","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-02 13:07:56","2022-05-02 17:37:56","0",NULL),
("3314","wc-admin_import_customers","complete","2022-05-03 02:23:06","2022-05-03 06:53:06","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651544586;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651544586;}","4","1","2022-05-03 02:23:09","2022-05-03 06:53:09","0",NULL),
("3315","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 02:40:43","2022-05-03 07:10:43","0",NULL),
("3316","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 02:40:27","2022-05-03 07:10:27","[1752,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651545627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651545627;}","2","1","2022-05-03 02:40:43","2022-05-03 07:10:43","0",NULL),
("3317","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 02:40:43","2022-05-03 07:10:43","0",NULL),
("3318","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 02:40:43","2022-05-03 07:10:43","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651545643;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651545643;}","2","1","2022-05-03 02:40:43","2022-05-03 07:10:43","0",NULL),
("3319","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 02:52:30","2022-05-03 07:22:30","0",NULL),
("3320","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 02:52:30","2022-05-03 07:22:30","[1752,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651546350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651546350;}","2","1","2022-05-03 02:52:30","2022-05-03 07:22:30","0",NULL),
("3321","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 02:53:37","2022-05-03 07:23:37","0",NULL),
("3322","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 02:52:47","2022-05-03 07:22:47","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651546367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651546367;}","2","1","2022-05-03 02:53:37","2022-05-03 07:23:37","0",NULL),
("3323","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 03:37:14","2022-05-03 08:07:14","0",NULL),
("3324","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:37:14","2022-05-03 08:07:14","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651549034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651549034;}","2","1","2022-05-03 03:37:15","2022-05-03 08:07:15","0",NULL),
("3325","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 03:44:02","2022-05-03 08:14:02","0",NULL),
("3326","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:43:37","2022-05-03 08:13:37","[1779,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651549417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651549417;}","2","1","2022-05-03 03:44:02","2022-05-03 08:14:02","0",NULL),
("3327","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 03:47:24","2022-05-03 08:17:24","0",NULL),
("3328","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:47:00","2022-05-03 08:17:00","[1779,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651549620;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651549620;}","2","1","2022-05-03 03:47:24","2022-05-03 08:17:24","0",NULL),
("3329","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 03:47:24","2022-05-03 08:17:24","0",NULL),
("3330","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:47:18","2022-05-03 08:17:18","[1702,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651549638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651549638;}","2","1","2022-05-03 03:47:24","2022-05-03 08:17:24","0",NULL),
("3331","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 03:48:05","2022-05-03 08:18:05","0",NULL),
("3332","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:47:40","2022-05-03 08:17:40","[1779,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651549660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651549660;}","2","1","2022-05-03 03:48:05","2022-05-03 08:18:05","0",NULL),
("3333","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:00:11","2022-05-03 08:30:11","0",NULL),
("3334","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 03:59:53","2022-05-03 08:29:53","[1779,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651550393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651550393;}","2","1","2022-05-03 04:00:11","2022-05-03 08:30:11","0",NULL),
("3335","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:10:49","2022-05-03 08:40:49","0",NULL),
("3336","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:09:58","2022-05-03 08:39:58","[1800,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651550998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651550998;}","2","1","2022-05-03 04:10:50","2022-05-03 08:40:50","0",NULL),
("3337","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:10:49","2022-05-03 08:40:49","0",NULL),
("3338","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:10:49","2022-05-03 08:40:49","0",NULL),
("3339","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:10:30","2022-05-03 08:40:30","[1779,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651551030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651551030;}","2","1","2022-05-03 04:10:50","2022-05-03 08:40:50","0",NULL),
("3340","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:14:05","2022-05-03 08:44:05","0",NULL),
("3341","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:13:41","2022-05-03 08:43:41","[1810,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651551221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651551221;}","2","1","2022-05-03 04:14:05","2022-05-03 08:44:05","0",NULL),
("3342","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:17:47","2022-05-03 08:47:47","0",NULL),
("3343","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:17:24","2022-05-03 08:47:24","[1810,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651551444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651551444;}","2","1","2022-05-03 04:17:47","2022-05-03 08:47:47","0",NULL),
("3344","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:39:10","2022-05-03 09:09:10","0",NULL),
("3345","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:39:09","2022-05-03 09:09:09","[1839,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651552749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651552749;}","2","1","2022-05-03 04:39:10","2022-05-03 09:09:10","0",NULL),
("3346","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:39:30","2022-05-03 09:09:30","0",NULL),
("3347","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:39:27","2022-05-03 09:09:27","[1834,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651552767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651552767;}","2","1","2022-05-03 04:39:31","2022-05-03 09:09:31","0",NULL),
("3348","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:40:01","2022-05-03 09:10:01","0",NULL),
("3349","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:39:35","2022-05-03 09:09:35","[1843,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651552775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651552775;}","2","1","2022-05-03 04:40:02","2022-05-03 09:10:02","0",NULL),
("3350","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:43:32","2022-05-03 09:13:32","0",NULL),
("3351","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:43:31","2022-05-03 09:13:31","[1846,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651553011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651553011;}","2","1","2022-05-03 04:43:33","2022-05-03 09:13:33","0",NULL),
("3352","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 04:46:01","2022-05-03 09:16:01","0",NULL),
("3353","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 04:45:00","2022-05-03 09:15:00","[1846,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651553100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651553100;}","2","1","2022-05-03 04:46:02","2022-05-03 09:16:02","0",NULL),
("3354","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 05:18:53","2022-05-03 09:48:53","0",NULL),
("3355","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 05:18:51","2022-05-03 09:48:51","[1846,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651555131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651555131;}","2","1","2022-05-03 05:18:53","2022-05-03 09:48:53","0",NULL),
("3356","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 05:46:13","2022-05-03 10:16:13","0",NULL),
("3357","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 05:45:21","2022-05-03 10:15:21","[1846,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651556721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651556721;}","2","1","2022-05-03 05:46:13","2022-05-03 10:16:13","0",NULL),
("3358","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:11:31","2022-05-03 22:41:31","0",NULL),
("3359","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:10:31","2022-05-03 22:40:31","[1850,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601431;}","2","1","2022-05-03 18:11:31","2022-05-03 22:41:31","0",NULL),
("3360","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:14:33","2022-05-03 22:44:33","0",NULL),
("3361","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:14:24","2022-05-03 22:44:24","[1853,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601664;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601664;}","2","1","2022-05-03 18:14:33","2022-05-03 22:44:33","0",NULL),
("3362","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:15:33","2022-05-03 22:45:33","0",NULL),
("3363","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:14:55","2022-05-03 22:44:55","[1853,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601695;}","2","1","2022-05-03 18:15:33","2022-05-03 22:45:33","0",NULL),
("3364","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:16:42","2022-05-03 22:46:42","0",NULL),
("3365","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:15:41","2022-05-03 22:45:41","[1856,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601741;}","2","1","2022-05-03 18:16:42","2022-05-03 22:46:42","0",NULL),
("3366","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:16:42","2022-05-03 22:46:42","0",NULL),
("3367","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:18:55","2022-05-03 22:48:55","0",NULL),
("3368","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:18:40","2022-05-03 22:48:40","[1861,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601920;}","2","1","2022-05-03 18:18:55","2022-05-03 22:48:55","0",NULL),
("3369","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:19:50","2022-05-03 22:49:50","0",NULL),
("3370","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:19:35","2022-05-03 22:49:35","[1853,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601975;}","2","1","2022-05-03 18:19:50","2022-05-03 22:49:50","0",NULL),
("3371","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:19:50","2022-05-03 22:49:50","0",NULL),
("3372","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:19:51","2022-05-03 22:49:51","[1856,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601991;}","2","1","2022-05-03 18:19:57","2022-05-03 22:49:57","0",NULL),
("3373","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 18:19:58","2022-05-03 22:49:58","0",NULL),
("3374","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 18:19:59","2022-05-03 22:49:59","[1861,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651601999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651601999;}","2","1","2022-05-03 18:20:01","2022-05-03 22:50:01","0",NULL),
("3375","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:25:25","2022-05-04 02:55:25","0",NULL),
("3376","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:25:23","2022-05-04 02:55:23","[1861,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651616723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651616723;}","2","1","2022-05-03 22:25:25","2022-05-04 02:55:25","0",NULL),
("3377","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:27:45","2022-05-04 02:57:45","0",NULL),
("3378","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:26:58","2022-05-04 02:56:58","[1864,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651616818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651616818;}","2","1","2022-05-03 22:27:45","2022-05-04 02:57:45","0",NULL),
("3379","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:28:51","2022-05-04 02:58:51","0",NULL),
("3380","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:28:42","2022-05-04 02:58:42","[1867,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651616922;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651616922;}","2","1","2022-05-03 22:28:51","2022-05-04 02:58:51","0",NULL),
("3381","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:29:45","2022-05-04 02:59:45","0",NULL),
("3382","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:29:17","2022-05-04 02:59:17","[1867,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651616957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651616957;}","2","1","2022-05-03 22:29:45","2022-05-04 02:59:45","0",NULL),
("3383","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:33:28","2022-05-04 03:03:28","0",NULL),
("3384","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:32:53","2022-05-04 03:02:53","[1870,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617173;}","2","1","2022-05-03 22:33:29","2022-05-04 03:03:29","0",NULL),
("3385","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:33:28","2022-05-04 03:03:28","0",NULL),
("3386","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:33:26","2022-05-04 03:03:26","[1902,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617206;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617206;}","2","1","2022-05-03 22:33:29","2022-05-04 03:03:29","0",NULL),
("3387","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:33:57","2022-05-04 03:03:57","0",NULL),
("3388","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:33:56","2022-05-04 03:03:56","[1906,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617236;}","2","1","2022-05-03 22:33:57","2022-05-04 03:03:57","0",NULL),
("3389","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:34:33","2022-05-04 03:04:33","0",NULL),
("3390","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:34:15","2022-05-04 03:04:15","[1910,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617255;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617255;}","2","1","2022-05-03 22:34:33","2022-05-04 03:04:33","0",NULL),
("3391","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:34:33","2022-05-04 03:04:33","0",NULL),
("3392","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:34:33","2022-05-04 03:04:33","[1913,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617273;}","2","1","2022-05-03 22:34:34","2022-05-04 03:04:34","0",NULL),
("3393","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:37:38","2022-05-04 03:07:38","0",NULL),
("3394","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:36:37","2022-05-04 03:06:37","[1913,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617397;}","2","1","2022-05-03 22:37:38","2022-05-04 03:07:38","0",NULL),
("3395","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:38:47","2022-05-04 03:08:47","0",NULL),
("3396","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:37:46","2022-05-04 03:07:46","[1935,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617466;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617466;}","2","1","2022-05-03 22:38:47","2022-05-04 03:08:47","0",NULL),
("3397","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:39:22","2022-05-04 03:09:22","0",NULL),
("3398","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:39:19","2022-05-04 03:09:19","[1938,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617559;}","2","1","2022-05-03 22:39:22","2022-05-04 03:09:22","0",NULL),
("3399","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:39:56","2022-05-04 03:09:56","0",NULL),
("3400","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:39:34","2022-05-04 03:09:34","[1941,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617574;}","2","1","2022-05-03 22:39:57","2022-05-04 03:09:57","0",NULL),
("3401","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:39:56","2022-05-04 03:09:56","0",NULL),
("3402","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:39:52","2022-05-04 03:09:52","[1944,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617592;}","2","1","2022-05-03 22:39:57","2022-05-04 03:09:57","0",NULL),
("3403","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:40:30","2022-05-04 03:10:30","0",NULL),
("3404","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:40:10","2022-05-04 03:10:10","[1947,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617610;}","2","1","2022-05-03 22:40:31","2022-05-04 03:10:31","0",NULL),
("3405","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:40:30","2022-05-04 03:10:30","0",NULL),
("3406","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:40:19","2022-05-04 03:10:19","[1950,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617619;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617619;}","2","1","2022-05-03 22:40:31","2022-05-04 03:10:31","0",NULL),
("3407","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:41:03","2022-05-04 03:11:03","0",NULL),
("3408","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:41:01","2022-05-04 03:11:01","[1953,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617661;}","2","1","2022-05-03 22:41:03","2022-05-04 03:11:03","0",NULL),
("3409","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:44:11","2022-05-04 03:14:11","0",NULL),
("3410","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:44:09","2022-05-04 03:14:09","[1956,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617849;}","2","1","2022-05-03 22:44:11","2022-05-04 03:14:11","0",NULL),
("3411","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:44:11","2022-05-04 03:14:11","0",NULL),
("3412","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:44:09","2022-05-04 03:14:09","[1953,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617849;}","2","1","2022-05-03 22:44:11","2022-05-04 03:14:11","0",NULL),
("3413","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-03 22:46:09","2022-05-04 03:16:09","0",NULL),
("3414","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-03 22:46:09","2022-05-04 03:16:09","[1959,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651617969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651617969;}","2","1","2022-05-03 22:46:09","2022-05-04 03:16:09","0",NULL),
("3415","wc-admin_import_customers","complete","2022-05-04 05:43:40","2022-05-04 10:13:40","[793]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651643020;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651643020;}","4","1","2022-05-04 05:43:57","2022-05-04 10:13:57","0",NULL),
("3416","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:30:28","2022-05-04 14:00:28","0",NULL),
("3417","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:29:47","2022-05-04 13:59:47","[2505,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656587;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656587;}","2","1","2022-05-04 09:30:29","2022-05-04 14:00:29","0",NULL),
("3418","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:30:28","2022-05-04 14:00:28","0",NULL),
("3419","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:30:02","2022-05-04 14:00:02","[2503,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656602;}","2","1","2022-05-04 09:30:30","2022-05-04 14:00:30","0",NULL),
("3420","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:30:29","2022-05-04 14:00:29","0",NULL),
("3421","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:30:13","2022-05-04 14:00:13","[2501,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656613;}","2","1","2022-05-04 09:30:30","2022-05-04 14:00:30","0",NULL),
("3422","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:30:29","2022-05-04 14:00:29","0",NULL),
("3423","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:30:26","2022-05-04 14:00:26","[2499,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656626;}","2","1","2022-05-04 09:30:30","2022-05-04 14:00:30","0",NULL),
("3424","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:30:59","2022-05-04 14:00:59","0",NULL),
("3425","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:30:55","2022-05-04 14:00:55","[2497,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656655;}","2","1","2022-05-04 09:30:59","2022-05-04 14:00:59","0",NULL),
("3426","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:31:44","2022-05-04 14:01:44","0",NULL),
("3427","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:31:32","2022-05-04 14:01:32","[2497,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656692;}","2","1","2022-05-04 09:31:44","2022-05-04 14:01:44","0",NULL),
("3428","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:31:44","2022-05-04 14:01:44","0",NULL),
("3429","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:31:39","2022-05-04 14:01:39","[2495,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656699;}","2","1","2022-05-04 09:31:44","2022-05-04 14:01:44","0",NULL),
("3430","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:32:03","2022-05-04 14:02:03","0",NULL),
("3431","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:31:57","2022-05-04 14:01:57","[2493,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656717;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656717;}","2","1","2022-05-04 09:32:03","2022-05-04 14:02:03","0",NULL),
("3432","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:33:01","2022-05-04 14:03:01","0",NULL),
("3433","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:32:05","2022-05-04 14:02:05","[2490,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656725;}","2","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3434","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3435","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:32:19","2022-05-04 14:02:19","[2482,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656739;}","2","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3436","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3437","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:32:29","2022-05-04 14:02:29","[2460,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656749;}","2","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3438","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3439","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:32:37","2022-05-04 14:02:37","[2419,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656757;}","2","1","2022-05-04 09:33:02","2022-05-04 14:03:02","0",NULL),
("3440","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:34:57","2022-05-04 14:04:57","0",NULL),
("3441","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:34:16","2022-05-04 14:04:16","[2023,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656856;}","2","1","2022-05-04 09:34:58","2022-05-04 14:04:58","0",NULL),
("3442","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:34:57","2022-05-04 14:04:57","0",NULL),
("3443","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:34:37","2022-05-04 14:04:37","[2020,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656877;}","2","1","2022-05-04 09:34:58","2022-05-04 14:04:58","0",NULL),
("3444","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:34:58","2022-05-04 14:04:58","0",NULL),
("3445","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:34:44","2022-05-04 14:04:44","[2016,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656884;}","2","1","2022-05-04 09:34:58","2022-05-04 14:04:58","0",NULL),
("3446","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:35:19","2022-05-04 14:05:19","0",NULL),
("3447","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:35:12","2022-05-04 14:05:12","[2012,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651656912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651656912;}","2","1","2022-05-04 09:35:20","2022-05-04 14:05:20","0",NULL),
("3448","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:41:16","2022-05-04 14:11:16","0",NULL),
("3449","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:41:17","2022-05-04 14:11:17","[1995,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657277;}","2","1","2022-05-04 09:41:35","2022-05-04 14:11:35","0",NULL),
("3450","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:44:11","2022-05-04 14:14:11","0",NULL),
("3451","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:44:11","2022-05-04 14:14:11","[1992,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657451;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657451;}","2","1","2022-05-04 09:44:11","2022-05-04 14:14:11","0",NULL),
("3452","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:45:02","2022-05-04 14:15:02","0",NULL),
("3453","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:44:18","2022-05-04 14:14:18","[1995,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657458;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657458;}","2","1","2022-05-04 09:45:02","2022-05-04 14:15:02","0",NULL),
("3454","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:47:12","2022-05-04 14:17:12","0",NULL),
("3455","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:46:29","2022-05-04 14:16:29","[1986,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657589;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657589;}","2","1","2022-05-04 09:47:12","2022-05-04 14:17:12","0",NULL),
("3456","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:49:39","2022-05-04 14:19:39","0",NULL),
("3457","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:48:32","2022-05-04 14:18:32","[1962,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657712;}","2","1","2022-05-04 09:49:39","2022-05-04 14:19:39","0",NULL),
("3458","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:49:39","2022-05-04 14:19:39","0",NULL),
("3459","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:48:55","2022-05-04 14:18:55","[1986,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657735;}","2","1","2022-05-04 09:49:39","2022-05-04 14:19:39","0",NULL),
("3460","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:49:39","2022-05-04 14:19:39","0",NULL),
("3461","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:54:13","2022-05-04 14:24:13","0",NULL),
("3462","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:53:14","2022-05-04 14:23:14","[2000,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651657994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651657994;}","2","1","2022-05-04 09:54:13","2022-05-04 14:24:13","0",NULL),
("3463","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2022-05-04 09:56:40","2022-05-04 14:26:40","0",NULL),
("3464","woocommerce_run_product_attribute_lookup_update_callback","complete","2022-05-04 09:56:36","2022-05-04 14:26:36","[2012,2]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651658196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651658196;}","2","1","2022-05-04 09:56:40","2022-05-04 14:26:40","0",NULL),
("3465","wc-admin_import_customers","complete","2022-05-04 11:20:56","2022-05-04 15:50:56","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651663256;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651663256;}","4","1","2022-05-04 11:21:11","2022-05-04 15:51:11","0",NULL),
("3466","wc-admin_import_customers","complete","2022-05-08 10:09:08","2022-05-08 14:39:08","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652004548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652004548;}","4","1","2022-05-08 14:42:37","2022-05-08 19:12:37","0",NULL),
("3467","wc-admin_import_customers","complete","2022-05-09 10:15:44","2022-05-09 14:45:44","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652091344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652091344;}","4","1","2022-05-09 10:17:17","2022-05-09 14:47:17","0",NULL),
("3468","wc-admin_import_customers","complete","2022-05-09 10:28:58","2022-05-09 14:58:58","[795]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652092138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652092138;}","4","1","2022-05-09 10:29:11","2022-05-09 14:59:11","0",NULL),
("3469","wc-admin_import_customers","complete","2022-05-10 13:32:21","2022-05-10 18:02:21","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652189541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652189541;}","4","1","2022-05-10 13:33:21","2022-05-10 18:03:21","0",NULL),
("3470","action_scheduler/migration_hook","complete","2022-05-10 15:35:14","2022-05-10 20:05:14","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652196914;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652196914;}","1","1","2022-05-10 15:36:08","2022-05-10 20:06:08","0",NULL),
("3471","action_scheduler/migration_hook","complete","2022-05-10 15:37:08","2022-05-10 20:07:08","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652197028;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652197028;}","1","1","2022-05-10 15:37:10","2022-05-10 20:07:10","0",NULL),
("3472","wc-admin_import_customers","complete","2022-05-13 16:17:56","2022-05-13 20:47:56","[792]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652458676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652458676;}","4","1","2022-05-13 16:18:10","2022-05-13 20:48:10","0",NULL);


/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","woocommerce-db-updates"),
("3","wc_update_product_lookup_tables"),
("4","wc-admin-data"),
("5","wc_update_product_default_cat");


/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES 
("6918","3282","ایجاد فعالیت","2022-04-14 18:37:46","2022-04-14 23:07:46"),
("6919","3282","عملیات توسط WP Cron شروع شد","2022-04-14 18:38:10","2022-04-14 23:08:10"),
("6920","3282","عملیات توسط WP Cron کامل شد","2022-04-14 18:38:10","2022-04-14 23:08:10"),
("6921","3283","ایجاد فعالیت","2022-04-15 12:25:27","2022-04-15 16:55:27"),
("6922","3283","عملیات توسط WP Cron شروع شد","2022-04-15 12:26:13","2022-04-15 16:56:13"),
("6923","3283","عملیات توسط WP Cron کامل شد","2022-04-15 12:26:13","2022-04-15 16:56:13"),
("6924","3284","ایجاد فعالیت","2022-04-15 21:17:36","2022-04-16 01:47:36"),
("6925","3284","عملیات توسط WP Cron شروع شد","2022-04-15 21:20:42","2022-04-16 01:50:42"),
("6926","3284","عملیات توسط WP Cron کامل شد","2022-04-15 21:20:42","2022-04-16 01:50:42"),
("6927","3285","ایجاد فعالیت","2022-04-17 10:42:42","2022-04-17 15:12:42"),
("6928","3285","عملیات توسط WP Cron شروع شد","2022-04-17 10:43:11","2022-04-17 15:13:11"),
("6929","3285","عملیات توسط WP Cron کامل شد","2022-04-17 10:43:11","2022-04-17 15:13:11"),
("6930","3286","ایجاد فعالیت","2022-04-19 16:45:02","2022-04-19 21:15:02"),
("6931","3286","عملیات توسط WP Cron شروع شد","2022-04-19 16:47:02","2022-04-19 21:17:02"),
("6932","3286","عملیات توسط WP Cron کامل شد","2022-04-19 16:47:02","2022-04-19 21:17:02"),
("6933","3287","ایجاد فعالیت","2022-04-26 09:00:25","2022-04-26 13:30:25"),
("6934","3287","عملیات توسط WP Cron شروع شد","2022-04-26 09:02:48","2022-04-26 13:32:48"),
("6935","3287","عملیات توسط WP Cron کامل شد","2022-04-26 09:02:48","2022-04-26 13:32:48"),
("6936","3288","ایجاد فعالیت","2022-04-30 04:17:35","2022-04-30 08:47:35"),
("6937","3288","عملیات توسط WP Cron شروع شد","2022-04-30 04:18:01","2022-04-30 08:48:01"),
("6938","3288","عملیات توسط WP Cron کامل شد","2022-04-30 04:18:01","2022-04-30 08:48:01"),
("6939","3289","ایجاد فعالیت","2022-05-01 10:03:17","2022-05-01 14:33:17"),
("6940","3289","عملیات توسط WP Cron شروع شد","2022-05-01 10:04:11","2022-05-01 14:34:11"),
("6941","3289","عملیات توسط WP Cron کامل شد","2022-05-01 10:04:11","2022-05-01 14:34:11"),
("6942","3290","ایجاد فعالیت","2022-05-01 10:05:37","2022-05-01 14:35:37"),
("6943","3290","عملیات توسط WP Cron شروع شد","2022-05-01 10:06:16","2022-05-01 14:36:16"),
("6944","3290","عملیات توسط WP Cron کامل شد","2022-05-01 10:06:16","2022-05-01 14:36:16"),
("6945","3291","ایجاد فعالیت","2022-05-01 10:20:07","2022-05-01 14:50:07"),
("6946","3292","ایجاد فعالیت","2022-05-01 10:20:07","2022-05-01 14:50:07"),
("6947","3293","ایجاد فعالیت","2022-05-01 10:20:07","2022-05-01 14:50:07"),
("6948","3291","عملیات توسط WP Cron شروع شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6949","3294","ایجاد فعالیت","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6950","3291","عملیات توسط WP Cron کامل شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6951","3292","عملیات توسط WP Cron شروع شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6952","3292","عملیات توسط WP Cron کامل شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6953","3293","عملیات توسط WP Cron شروع شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6954","3293","عملیات توسط WP Cron کامل شد","2022-05-01 10:20:09","2022-05-01 14:50:09"),
("6955","3294","عملیات توسط Async Request شروع شد","2022-05-01 10:20:59","2022-05-01 14:50:59"),
("6956","3295","ایجاد فعالیت","2022-05-01 10:21:00","2022-05-01 14:51:00"),
("6957","3294","عملیات توسط Async Request کامل شد","2022-05-01 10:21:00","2022-05-01 14:51:00"),
("6958","3295","عملیات توسط Async Request شروع شد","2022-05-01 10:21:06","2022-05-01 14:51:06"),
("6959","3296","ایجاد فعالیت","2022-05-01 10:21:07","2022-05-01 14:51:07"),
("6960","3295","عملیات توسط Async Request کامل شد","2022-05-01 10:21:07","2022-05-01 14:51:07"),
("6961","3296","عملیات توسط Async Request شروع شد","2022-05-01 10:21:13","2022-05-01 14:51:13"),
("6962","3297","ایجاد فعالیت","2022-05-01 10:21:14","2022-05-01 14:51:14"),
("6963","3296","عملیات توسط Async Request کامل شد","2022-05-01 10:21:14","2022-05-01 14:51:14"),
("6964","3297","عملیات توسط Async Request شروع شد","2022-05-01 10:21:20","2022-05-01 14:51:20"),
("6965","3298","ایجاد فعالیت","2022-05-01 10:21:20","2022-05-01 14:51:20"),
("6966","3297","عملیات توسط Async Request کامل شد","2022-05-01 10:21:20","2022-05-01 14:51:20"),
("6967","3298","عملیات توسط Async Request شروع شد","2022-05-01 10:21:27","2022-05-01 14:51:27"),
("6968","3298","عملیات توسط Async Request کامل شد","2022-05-01 10:21:27","2022-05-01 14:51:27"),
("6969","3299","ایجاد فعالیت","2022-05-02 08:56:29","2022-05-02 13:26:29"),
("6970","3299","عملیات توسط WP Cron شروع شد","2022-05-02 08:57:29","2022-05-02 13:27:29"),
("6971","3299","عملیات توسط WP Cron کامل شد","2022-05-02 08:57:29","2022-05-02 13:27:29"),
("6972","3300","ایجاد فعالیت","2022-05-02 13:01:49","2022-05-02 17:31:49"),
("6973","3301","ایجاد فعالیت","2022-05-02 13:01:50","2022-05-02 17:31:50"),
("6974","3302","ایجاد فعالیت","2022-05-02 13:01:59","2022-05-02 17:31:59"),
("6975","3300","عملیات توسط Async Request شروع شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6976","3300","عملیات توسط Async Request کامل شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6977","3302","عملیات توسط Async Request شروع شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6978","3302","عملیات توسط Async Request کامل شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6979","3301","عملیات توسط Async Request شروع شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6980","3301","عملیات توسط Async Request کامل شد","2022-05-02 13:02:02","2022-05-02 17:32:02"),
("6981","3303","ایجاد فعالیت","2022-05-02 13:02:16","2022-05-02 17:32:16"),
("6982","3304","ایجاد فعالیت","2022-05-02 13:02:16","2022-05-02 17:32:16"),
("6983","3305","ایجاد فعالیت","2022-05-02 13:02:39","2022-05-02 17:32:39"),
("6984","3306","ایجاد فعالیت","2022-05-02 13:02:39","2022-05-02 17:32:39"),
("6985","3305","عملیات توسط WP Cron شروع شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6986","3305","عملیات توسط WP Cron کامل شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6987","3303","عملیات توسط WP Cron شروع شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6988","3303","عملیات توسط WP Cron کامل شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6989","3304","عملیات توسط WP Cron شروع شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6990","3304","عملیات توسط WP Cron کامل شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6991","3306","عملیات توسط WP Cron شروع شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6992","3306","عملیات توسط WP Cron کامل شد","2022-05-02 13:02:53","2022-05-02 17:32:53"),
("6993","3307","ایجاد فعالیت","2022-05-02 13:03:01","2022-05-02 17:33:01"),
("6994","3308","ایجاد فعالیت","2022-05-02 13:03:01","2022-05-02 17:33:01"),
("6995","3307","عملیات توسط Async Request شروع شد","2022-05-02 13:03:16","2022-05-02 17:33:16"),
("6996","3307","عملیات توسط Async Request کامل شد","2022-05-02 13:03:16","2022-05-02 17:33:16"),
("6997","3308","عملیات توسط Async Request شروع شد","2022-05-02 13:03:16","2022-05-02 17:33:16"),
("6998","3308","عملیات توسط Async Request کامل شد","2022-05-02 13:03:16","2022-05-02 17:33:16"),
("6999","3309","ایجاد فعالیت","2022-05-02 13:05:21","2022-05-02 17:35:21"),
("7000","3310","ایجاد فعالیت","2022-05-02 13:05:22","2022-05-02 17:35:22"),
("7001","3309","عملیات توسط Async Request شروع شد","2022-05-02 13:05:34","2022-05-02 17:35:34"),
("7002","3309","عملیات توسط Async Request کامل شد","2022-05-02 13:05:34","2022-05-02 17:35:34"),
("7003","3310","عملیات توسط Async Request شروع شد","2022-05-02 13:05:35","2022-05-02 17:35:35"),
("7004","3310","عملیات توسط Async Request کامل شد","2022-05-02 13:05:35","2022-05-02 17:35:35"),
("7005","3311","ایجاد فعالیت","2022-05-02 13:07:00","2022-05-02 17:37:00"),
("7006","3312","ایجاد فعالیت","2022-05-02 13:07:00","2022-05-02 17:37:00"),
("7007","3313","ایجاد فعالیت","2022-05-02 13:07:54","2022-05-02 17:37:54"),
("7008","3311","عملیات توسط Async Request شروع شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7009","3311","عملیات توسط Async Request کامل شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7010","3313","عملیات توسط Async Request شروع شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7011","3313","عملیات توسط Async Request کامل شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7012","3312","عملیات توسط Async Request شروع شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7013","3312","عملیات توسط Async Request کامل شد","2022-05-02 13:07:56","2022-05-02 17:37:56"),
("7014","3314","ایجاد فعالیت","2022-05-03 02:23:01","2022-05-03 06:53:01"),
("7015","3314","عملیات توسط WP Cron شروع شد","2022-05-03 02:23:09","2022-05-03 06:53:09"),
("7016","3314","عملیات توسط WP Cron کامل شد","2022-05-03 02:23:09","2022-05-03 06:53:09"),
("7017","3315","ایجاد فعالیت","2022-05-03 02:40:26","2022-05-03 07:10:26"),
("7018","3316","ایجاد فعالیت","2022-05-03 02:40:26","2022-05-03 07:10:26"),
("7019","3317","ایجاد فعالیت","2022-05-03 02:40:42","2022-05-03 07:10:42"),
("7020","3318","ایجاد فعالیت","2022-05-03 02:40:42","2022-05-03 07:10:42"),
("7021","3315","عملیات توسط Async Request شروع شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7022","3315","عملیات توسط Async Request کامل شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7023","3317","عملیات توسط Async Request شروع شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7024","3317","عملیات توسط Async Request کامل شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7025","3316","عملیات توسط Async Request شروع شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7026","3316","عملیات توسط Async Request کامل شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7027","3318","عملیات توسط Async Request شروع شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7028","3318","عملیات توسط Async Request کامل شد","2022-05-03 02:40:43","2022-05-03 07:10:43"),
("7029","3319","ایجاد فعالیت","2022-05-03 02:52:28","2022-05-03 07:22:28"),
("7030","3320","ایجاد فعالیت","2022-05-03 02:52:29","2022-05-03 07:22:29"),
("7031","3319","عملیات توسط Async Request شروع شد","2022-05-03 02:52:30","2022-05-03 07:22:30"),
("7032","3319","عملیات توسط Async Request کامل شد","2022-05-03 02:52:30","2022-05-03 07:22:30"),
("7033","3320","عملیات توسط Async Request شروع شد","2022-05-03 02:52:30","2022-05-03 07:22:30"),
("7034","3320","عملیات توسط Async Request کامل شد","2022-05-03 02:52:30","2022-05-03 07:22:30"),
("7035","3321","ایجاد فعالیت","2022-05-03 02:52:46","2022-05-03 07:22:46"),
("7036","3322","ایجاد فعالیت","2022-05-03 02:52:46","2022-05-03 07:22:46"),
("7037","3321","عملیات توسط WP Cron شروع شد","2022-05-03 02:53:37","2022-05-03 07:23:37"),
("7038","3321","عملیات توسط WP Cron کامل شد","2022-05-03 02:53:37","2022-05-03 07:23:37"),
("7039","3322","عملیات توسط WP Cron شروع شد","2022-05-03 02:53:37","2022-05-03 07:23:37"),
("7040","3322","عملیات توسط WP Cron کامل شد","2022-05-03 02:53:37","2022-05-03 07:23:37"),
("7041","3323","ایجاد فعالیت","2022-05-03 03:37:13","2022-05-03 08:07:13"),
("7042","3324","ایجاد فعالیت","2022-05-03 03:37:13","2022-05-03 08:07:13"),
("7043","3323","عملیات توسط WP Cron شروع شد","2022-05-03 03:37:14","2022-05-03 08:07:14"),
("7044","3323","عملیات توسط WP Cron کامل شد","2022-05-03 03:37:14","2022-05-03 08:07:14"),
("7045","3324","عملیات توسط WP Cron شروع شد","2022-05-03 03:37:14","2022-05-03 08:07:14"),
("7046","3324","عملیات توسط WP Cron کامل شد","2022-05-03 03:37:15","2022-05-03 08:07:15"),
("7047","3325","ایجاد فعالیت","2022-05-03 03:43:36","2022-05-03 08:13:36"),
("7048","3326","ایجاد فعالیت","2022-05-03 03:43:36","2022-05-03 08:13:36"),
("7049","3325","عملیات توسط Async Request شروع شد","2022-05-03 03:44:02","2022-05-03 08:14:02"),
("7050","3325","عملیات توسط Async Request کامل شد","2022-05-03 03:44:02","2022-05-03 08:14:02"),
("7051","3326","عملیات توسط Async Request شروع شد","2022-05-03 03:44:02","2022-05-03 08:14:02"),
("7052","3326","عملیات توسط Async Request کامل شد","2022-05-03 03:44:02","2022-05-03 08:14:02"),
("7053","3327","ایجاد فعالیت","2022-05-03 03:46:59","2022-05-03 08:16:59"),
("7054","3328","ایجاد فعالیت","2022-05-03 03:46:59","2022-05-03 08:16:59"),
("7055","3329","ایجاد فعالیت","2022-05-03 03:47:17","2022-05-03 08:17:17"),
("7056","3330","ایجاد فعالیت","2022-05-03 03:47:17","2022-05-03 08:17:17"),
("7057","3327","عملیات توسط Async Request شروع شد","2022-05-03 03:47:23","2022-05-03 08:17:23"),
("7058","3327","عملیات توسط Async Request کامل شد","2022-05-03 03:47:23","2022-05-03 08:17:23"),
("7059","3329","عملیات توسط Async Request شروع شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7060","3329","عملیات توسط Async Request کامل شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7061","3328","عملیات توسط Async Request شروع شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7062","3328","عملیات توسط Async Request کامل شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7063","3330","عملیات توسط Async Request شروع شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7064","3330","عملیات توسط Async Request کامل شد","2022-05-03 03:47:24","2022-05-03 08:17:24"),
("7065","3331","ایجاد فعالیت","2022-05-03 03:47:39","2022-05-03 08:17:39"),
("7066","3332","ایجاد فعالیت","2022-05-03 03:47:39","2022-05-03 08:17:39"),
("7067","3331","عملیات توسط WP Cron شروع شد","2022-05-03 03:48:04","2022-05-03 08:18:04"),
("7068","3331","عملیات توسط WP Cron کامل شد","2022-05-03 03:48:05","2022-05-03 08:18:05"),
("7069","3332","عملیات توسط WP Cron شروع شد","2022-05-03 03:48:05","2022-05-03 08:18:05"),
("7070","3332","عملیات توسط WP Cron کامل شد","2022-05-03 03:48:05","2022-05-03 08:18:05"),
("7071","3333","ایجاد فعالیت","2022-05-03 03:59:52","2022-05-03 08:29:52"),
("7072","3334","ایجاد فعالیت","2022-05-03 03:59:52","2022-05-03 08:29:52"),
("7073","3333","عملیات توسط Async Request شروع شد","2022-05-03 04:00:11","2022-05-03 08:30:11"),
("7074","3333","عملیات توسط Async Request کامل شد","2022-05-03 04:00:11","2022-05-03 08:30:11"),
("7075","3334","عملیات توسط Async Request شروع شد","2022-05-03 04:00:11","2022-05-03 08:30:11"),
("7076","3334","عملیات توسط Async Request کامل شد","2022-05-03 04:00:11","2022-05-03 08:30:11"),
("7077","3335","ایجاد فعالیت","2022-05-03 04:09:57","2022-05-03 08:39:57"),
("7078","3336","ایجاد فعالیت","2022-05-03 04:09:57","2022-05-03 08:39:57"),
("7079","3337","ایجاد فعالیت","2022-05-03 04:10:22","2022-05-03 08:40:22"),
("7080","3338","ایجاد فعالیت","2022-05-03 04:10:29","2022-05-03 08:40:29"),
("7081","3339","ایجاد فعالیت","2022-05-03 04:10:29","2022-05-03 08:40:29"),
("7082","3335","عملیات توسط Async Request شروع شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7083","3335","عملیات توسط Async Request کامل شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7084","3337","عملیات توسط Async Request شروع شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7085","3337","عملیات توسط Async Request کامل شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7086","3338","عملیات توسط Async Request شروع شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7087","3338","عملیات توسط Async Request کامل شد","2022-05-03 04:10:49","2022-05-03 08:40:49"),
("7088","3336","عملیات توسط Async Request شروع شد","2022-05-03 04:10:50","2022-05-03 08:40:50"),
("7089","3336","عملیات توسط Async Request کامل شد","2022-05-03 04:10:50","2022-05-03 08:40:50"),
("7090","3339","عملیات توسط Async Request شروع شد","2022-05-03 04:10:50","2022-05-03 08:40:50"),
("7091","3339","عملیات توسط Async Request کامل شد","2022-05-03 04:10:50","2022-05-03 08:40:50"),
("7092","3340","ایجاد فعالیت","2022-05-03 04:13:40","2022-05-03 08:43:40"),
("7093","3341","ایجاد فعالیت","2022-05-03 04:13:40","2022-05-03 08:43:40"),
("7094","3340","عملیات توسط Async Request شروع شد","2022-05-03 04:14:05","2022-05-03 08:44:05"),
("7095","3340","عملیات توسط Async Request کامل شد","2022-05-03 04:14:05","2022-05-03 08:44:05"),
("7096","3341","عملیات توسط Async Request شروع شد","2022-05-03 04:14:05","2022-05-03 08:44:05"),
("7097","3341","عملیات توسط Async Request کامل شد","2022-05-03 04:14:05","2022-05-03 08:44:05"),
("7098","3342","ایجاد فعالیت","2022-05-03 04:17:23","2022-05-03 08:47:23"),
("7099","3343","ایجاد فعالیت","2022-05-03 04:17:23","2022-05-03 08:47:23"),
("7100","3342","عملیات توسط WP Cron شروع شد","2022-05-03 04:17:47","2022-05-03 08:47:47"),
("7101","3342","عملیات توسط WP Cron کامل شد","2022-05-03 04:17:47","2022-05-03 08:47:47"),
("7102","3343","عملیات توسط WP Cron شروع شد","2022-05-03 04:17:47","2022-05-03 08:47:47"),
("7103","3343","عملیات توسط WP Cron کامل شد","2022-05-03 04:17:47","2022-05-03 08:47:47"),
("7104","3344","ایجاد فعالیت","2022-05-03 04:39:08","2022-05-03 09:09:08"),
("7105","3345","ایجاد فعالیت","2022-05-03 04:39:08","2022-05-03 09:09:08"),
("7106","3344","عملیات توسط WP Cron شروع شد","2022-05-03 04:39:10","2022-05-03 09:09:10"),
("7107","3344","عملیات توسط WP Cron کامل شد","2022-05-03 04:39:10","2022-05-03 09:09:10"),
("7108","3345","عملیات توسط WP Cron شروع شد","2022-05-03 04:39:10","2022-05-03 09:09:10"),
("7109","3345","عملیات توسط WP Cron کامل شد","2022-05-03 04:39:10","2022-05-03 09:09:10"),
("7110","3346","ایجاد فعالیت","2022-05-03 04:39:26","2022-05-03 09:09:26"),
("7111","3347","ایجاد فعالیت","2022-05-03 04:39:26","2022-05-03 09:09:26"),
("7112","3346","عملیات توسط WP Cron شروع شد","2022-05-03 04:39:30","2022-05-03 09:09:30"),
("7113","3346","عملیات توسط WP Cron کامل شد","2022-05-03 04:39:30","2022-05-03 09:09:30"),
("7114","3347","عملیات توسط WP Cron شروع شد","2022-05-03 04:39:30","2022-05-03 09:09:30"),
("7115","3347","عملیات توسط WP Cron کامل شد","2022-05-03 04:39:30","2022-05-03 09:09:30"),
("7116","3348","ایجاد فعالیت","2022-05-03 04:39:34","2022-05-03 09:09:34"),
("7117","3349","ایجاد فعالیت","2022-05-03 04:39:34","2022-05-03 09:09:34"),
("7118","3348","عملیات توسط Async Request شروع شد","2022-05-03 04:40:01","2022-05-03 09:10:01"),
("7119","3348","عملیات توسط Async Request کامل شد","2022-05-03 04:40:01","2022-05-03 09:10:01"),
("7120","3349","عملیات توسط Async Request شروع شد","2022-05-03 04:40:01","2022-05-03 09:10:01"),
("7121","3349","عملیات توسط Async Request کامل شد","2022-05-03 04:40:01","2022-05-03 09:10:01"),
("7122","3350","ایجاد فعالیت","2022-05-03 04:43:30","2022-05-03 09:13:30"),
("7123","3351","ایجاد فعالیت","2022-05-03 04:43:30","2022-05-03 09:13:30"),
("7124","3350","عملیات توسط Async Request شروع شد","2022-05-03 04:43:32","2022-05-03 09:13:32"),
("7125","3350","عملیات توسط Async Request کامل شد","2022-05-03 04:43:32","2022-05-03 09:13:32"),
("7126","3351","عملیات توسط Async Request شروع شد","2022-05-03 04:43:33","2022-05-03 09:13:33"),
("7127","3351","عملیات توسط Async Request کامل شد","2022-05-03 04:43:33","2022-05-03 09:13:33"),
("7128","3352","ایجاد فعالیت","2022-05-03 04:44:59","2022-05-03 09:14:59"),
("7129","3353","ایجاد فعالیت","2022-05-03 04:44:59","2022-05-03 09:14:59"),
("7130","3352","عملیات توسط Async Request شروع شد","2022-05-03 04:46:01","2022-05-03 09:16:01"),
("7131","3352","عملیات توسط Async Request کامل شد","2022-05-03 04:46:01","2022-05-03 09:16:01"),
("7132","3353","عملیات توسط Async Request شروع شد","2022-05-03 04:46:01","2022-05-03 09:16:01"),
("7133","3353","عملیات توسط Async Request کامل شد","2022-05-03 04:46:02","2022-05-03 09:16:02"),
("7134","3354","ایجاد فعالیت","2022-05-03 05:18:50","2022-05-03 09:48:50"),
("7135","3355","ایجاد فعالیت","2022-05-03 05:18:50","2022-05-03 09:48:50"),
("7136","3354","عملیات توسط Async Request شروع شد","2022-05-03 05:18:53","2022-05-03 09:48:53"),
("7137","3354","عملیات توسط Async Request کامل شد","2022-05-03 05:18:53","2022-05-03 09:48:53"),
("7138","3355","عملیات توسط Async Request شروع شد","2022-05-03 05:18:53","2022-05-03 09:48:53"),
("7139","3355","عملیات توسط Async Request کامل شد","2022-05-03 05:18:53","2022-05-03 09:48:53"),
("7140","3356","ایجاد فعالیت","2022-05-03 05:45:20","2022-05-03 10:15:20"),
("7141","3357","ایجاد فعالیت","2022-05-03 05:45:20","2022-05-03 10:15:20"),
("7142","3356","عملیات توسط Async Request شروع شد","2022-05-03 05:46:13","2022-05-03 10:16:13"),
("7143","3356","عملیات توسط Async Request کامل شد","2022-05-03 05:46:13","2022-05-03 10:16:13"),
("7144","3357","عملیات توسط Async Request شروع شد","2022-05-03 05:46:13","2022-05-03 10:16:13"),
("7145","3357","عملیات توسط Async Request کامل شد","2022-05-03 05:46:13","2022-05-03 10:16:13"),
("7146","3358","ایجاد فعالیت","2022-05-03 18:10:30","2022-05-03 22:40:30"),
("7147","3359","ایجاد فعالیت","2022-05-03 18:10:30","2022-05-03 22:40:30"),
("7148","3358","عملیات توسط Async Request شروع شد","2022-05-03 18:11:31","2022-05-03 22:41:31"),
("7149","3358","عملیات توسط Async Request کامل شد","2022-05-03 18:11:31","2022-05-03 22:41:31"),
("7150","3359","عملیات توسط Async Request شروع شد","2022-05-03 18:11:31","2022-05-03 22:41:31"),
("7151","3359","عملیات توسط Async Request کامل شد","2022-05-03 18:11:31","2022-05-03 22:41:31"),
("7152","3360","ایجاد فعالیت","2022-05-03 18:14:23","2022-05-03 22:44:23"),
("7153","3361","ایجاد فعالیت","2022-05-03 18:14:23","2022-05-03 22:44:23"),
("7154","3360","عملیات توسط Async Request شروع شد","2022-05-03 18:14:32","2022-05-03 22:44:32"),
("7155","3360","عملیات توسط Async Request کامل شد","2022-05-03 18:14:33","2022-05-03 22:44:33"),
("7156","3361","عملیات توسط Async Request شروع شد","2022-05-03 18:14:33","2022-05-03 22:44:33"),
("7157","3361","عملیات توسط Async Request کامل شد","2022-05-03 18:14:33","2022-05-03 22:44:33"),
("7158","3362","ایجاد فعالیت","2022-05-03 18:14:54","2022-05-03 22:44:54"),
("7159","3363","ایجاد فعالیت","2022-05-03 18:14:54","2022-05-03 22:44:54"),
("7160","3362","عملیات توسط WP Cron شروع شد","2022-05-03 18:15:33","2022-05-03 22:45:33"),
("7161","3362","عملیات توسط WP Cron کامل شد","2022-05-03 18:15:33","2022-05-03 22:45:33"),
("7162","3363","عملیات توسط WP Cron شروع شد","2022-05-03 18:15:33","2022-05-03 22:45:33"),
("7163","3363","عملیات توسط WP Cron کامل شد","2022-05-03 18:15:33","2022-05-03 22:45:33"),
("7164","3364","ایجاد فعالیت","2022-05-03 18:15:40","2022-05-03 22:45:40"),
("7165","3365","ایجاد فعالیت","2022-05-03 18:15:40","2022-05-03 22:45:40"),
("7166","3366","ایجاد فعالیت","2022-05-03 18:15:57","2022-05-03 22:45:57"),
("7167","3364","عملیات توسط Async Request شروع شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7168","3364","عملیات توسط Async Request کامل شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7169","3366","عملیات توسط Async Request شروع شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7170","3366","عملیات توسط Async Request کامل شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7171","3365","عملیات توسط Async Request شروع شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7172","3365","عملیات توسط Async Request کامل شد","2022-05-03 18:16:42","2022-05-03 22:46:42"),
("7173","3367","ایجاد فعالیت","2022-05-03 18:18:39","2022-05-03 22:48:39"),
("7174","3368","ایجاد فعالیت","2022-05-03 18:18:39","2022-05-03 22:48:39"),
("7175","3367","عملیات توسط Async Request شروع شد","2022-05-03 18:18:54","2022-05-03 22:48:54"),
("7176","3367","عملیات توسط Async Request کامل شد","2022-05-03 18:18:55","2022-05-03 22:48:55"),
("7177","3368","عملیات توسط Async Request شروع شد","2022-05-03 18:18:55","2022-05-03 22:48:55"),
("7178","3368","عملیات توسط Async Request کامل شد","2022-05-03 18:18:55","2022-05-03 22:48:55"),
("7179","3369","ایجاد فعالیت","2022-05-03 18:19:34","2022-05-03 22:49:34"),
("7180","3370","ایجاد فعالیت","2022-05-03 18:19:34","2022-05-03 22:49:34"),
("7181","3369","عملیات توسط WP Cron شروع شد","2022-05-03 18:19:49","2022-05-03 22:49:49"),
("7182","3371","ایجاد فعالیت","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7183","3369","عملیات توسط WP Cron کامل شد","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7184","3370","عملیات توسط WP Cron شروع شد","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7185","3370","عملیات توسط WP Cron کامل شد","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7186","3372","ایجاد فعالیت","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7187","3371","عملیات توسط WP Cron شروع شد","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7188","3371","عملیات توسط WP Cron کامل شد","2022-05-03 18:19:50","2022-05-03 22:49:50"),
("7189","3372","عملیات توسط Async Request شروع شد","2022-05-03 18:19:57","2022-05-03 22:49:57"),
("7190","3372","عملیات توسط Async Request کامل شد","2022-05-03 18:19:57","2022-05-03 22:49:57"),
("7191","3373","ایجاد فعالیت","2022-05-03 18:19:58","2022-05-03 22:49:58"),
("7192","3374","ایجاد فعالیت","2022-05-03 18:19:58","2022-05-03 22:49:58"),
("7193","3373","عملیات توسط Async Request شروع شد","2022-05-03 18:19:58","2022-05-03 22:49:58"),
("7194","3373","عملیات توسط Async Request کامل شد","2022-05-03 18:19:58","2022-05-03 22:49:58"),
("7195","3374","عملیات توسط Async Request شروع شد","2022-05-03 18:20:01","2022-05-03 22:50:01"),
("7196","3374","عملیات توسط Async Request کامل شد","2022-05-03 18:20:01","2022-05-03 22:50:01"),
("7197","3375","ایجاد فعالیت","2022-05-03 22:25:22","2022-05-04 02:55:22"),
("7198","3376","ایجاد فعالیت","2022-05-03 22:25:22","2022-05-04 02:55:22"),
("7199","3375","عملیات توسط WP Cron شروع شد","2022-05-03 22:25:25","2022-05-04 02:55:25"),
("7200","3375","عملیات توسط WP Cron کامل شد","2022-05-03 22:25:25","2022-05-04 02:55:25"),
("7201","3376","عملیات توسط WP Cron شروع شد","2022-05-03 22:25:25","2022-05-04 02:55:25"),
("7202","3376","عملیات توسط WP Cron کامل شد","2022-05-03 22:25:25","2022-05-04 02:55:25"),
("7203","3377","ایجاد فعالیت","2022-05-03 22:26:57","2022-05-04 02:56:57"),
("7204","3378","ایجاد فعالیت","2022-05-03 22:26:57","2022-05-04 02:56:57"),
("7205","3377","عملیات توسط Async Request شروع شد","2022-05-03 22:27:45","2022-05-04 02:57:45"),
("7206","3377","عملیات توسط Async Request کامل شد","2022-05-03 22:27:45","2022-05-04 02:57:45"),
("7207","3378","عملیات توسط Async Request شروع شد","2022-05-03 22:27:45","2022-05-04 02:57:45"),
("7208","3378","عملیات توسط Async Request کامل شد","2022-05-03 22:27:45","2022-05-04 02:57:45"),
("7209","3379","ایجاد فعالیت","2022-05-03 22:28:41","2022-05-04 02:58:41"),
("7210","3380","ایجاد فعالیت","2022-05-03 22:28:41","2022-05-04 02:58:41"),
("7211","3379","عملیات توسط Async Request شروع شد","2022-05-03 22:28:51","2022-05-04 02:58:51"),
("7212","3379","عملیات توسط Async Request کامل شد","2022-05-03 22:28:51","2022-05-04 02:58:51"),
("7213","3380","عملیات توسط Async Request شروع شد","2022-05-03 22:28:51","2022-05-04 02:58:51"),
("7214","3380","عملیات توسط Async Request کامل شد","2022-05-03 22:28:51","2022-05-04 02:58:51"),
("7215","3381","ایجاد فعالیت","2022-05-03 22:29:16","2022-05-04 02:59:16"),
("7216","3382","ایجاد فعالیت","2022-05-03 22:29:16","2022-05-04 02:59:16"),
("7217","3381","عملیات توسط WP Cron شروع شد","2022-05-03 22:29:45","2022-05-04 02:59:45"),
("7218","3381","عملیات توسط WP Cron کامل شد","2022-05-03 22:29:45","2022-05-04 02:59:45"),
("7219","3382","عملیات توسط WP Cron شروع شد","2022-05-03 22:29:45","2022-05-04 02:59:45"),
("7220","3382","عملیات توسط WP Cron کامل شد","2022-05-03 22:29:45","2022-05-04 02:59:45"),
("7221","3383","ایجاد فعالیت","2022-05-03 22:32:52","2022-05-04 03:02:52"),
("7222","3384","ایجاد فعالیت","2022-05-03 22:32:52","2022-05-04 03:02:52"),
("7223","3385","ایجاد فعالیت","2022-05-03 22:33:25","2022-05-04 03:03:25"),
("7224","3386","ایجاد فعالیت","2022-05-03 22:33:25","2022-05-04 03:03:25"),
("7225","3383","عملیات توسط Async Request شروع شد","2022-05-03 22:33:28","2022-05-04 03:03:28"),
("7226","3383","عملیات توسط Async Request کامل شد","2022-05-03 22:33:28","2022-05-04 03:03:28"),
("7227","3385","عملیات توسط Async Request شروع شد","2022-05-03 22:33:28","2022-05-04 03:03:28"),
("7228","3385","عملیات توسط Async Request کامل شد","2022-05-03 22:33:28","2022-05-04 03:03:28"),
("7229","3384","عملیات توسط Async Request شروع شد","2022-05-03 22:33:28","2022-05-04 03:03:28"),
("7230","3384","عملیات توسط Async Request کامل شد","2022-05-03 22:33:29","2022-05-04 03:03:29"),
("7231","3386","عملیات توسط Async Request شروع شد","2022-05-03 22:33:29","2022-05-04 03:03:29"),
("7232","3386","عملیات توسط Async Request کامل شد","2022-05-03 22:33:29","2022-05-04 03:03:29"),
("7233","3387","ایجاد فعالیت","2022-05-03 22:33:55","2022-05-04 03:03:55"),
("7234","3388","ایجاد فعالیت","2022-05-03 22:33:55","2022-05-04 03:03:55"),
("7235","3387","عملیات توسط WP Cron شروع شد","2022-05-03 22:33:57","2022-05-04 03:03:57"),
("7236","3387","عملیات توسط WP Cron کامل شد","2022-05-03 22:33:57","2022-05-04 03:03:57"),
("7237","3388","عملیات توسط WP Cron شروع شد","2022-05-03 22:33:57","2022-05-04 03:03:57"),
("7238","3388","عملیات توسط WP Cron کامل شد","2022-05-03 22:33:57","2022-05-04 03:03:57"),
("7239","3389","ایجاد فعالیت","2022-05-03 22:34:14","2022-05-04 03:04:14"),
("7240","3390","ایجاد فعالیت","2022-05-03 22:34:14","2022-05-04 03:04:14"),
("7241","3391","ایجاد فعالیت","2022-05-03 22:34:32","2022-05-04 03:04:32"),
("7242","3392","ایجاد فعالیت","2022-05-03 22:34:32","2022-05-04 03:04:32"),
("7243","3389","عملیات توسط Async Request شروع شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7244","3389","عملیات توسط Async Request کامل شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7245","3391","عملیات توسط Async Request شروع شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7246","3391","عملیات توسط Async Request کامل شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7247","3390","عملیات توسط Async Request شروع شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7248","3390","عملیات توسط Async Request کامل شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7249","3392","عملیات توسط Async Request شروع شد","2022-05-03 22:34:33","2022-05-04 03:04:33"),
("7250","3392","عملیات توسط Async Request کامل شد","2022-05-03 22:34:34","2022-05-04 03:04:34"),
("7251","3393","ایجاد فعالیت","2022-05-03 22:36:36","2022-05-04 03:06:36"),
("7252","3394","ایجاد فعالیت","2022-05-03 22:36:36","2022-05-04 03:06:36"),
("7253","3393","عملیات توسط Async Request شروع شد","2022-05-03 22:37:38","2022-05-04 03:07:38"),
("7254","3393","عملیات توسط Async Request کامل شد","2022-05-03 22:37:38","2022-05-04 03:07:38"),
("7255","3394","عملیات توسط Async Request شروع شد","2022-05-03 22:37:38","2022-05-04 03:07:38"),
("7256","3394","عملیات توسط Async Request کامل شد","2022-05-03 22:37:38","2022-05-04 03:07:38"),
("7257","3395","ایجاد فعالیت","2022-05-03 22:37:45","2022-05-04 03:07:45"),
("7258","3396","ایجاد فعالیت","2022-05-03 22:37:45","2022-05-04 03:07:45"),
("7259","3395","عملیات توسط Async Request شروع شد","2022-05-03 22:38:47","2022-05-04 03:08:47"),
("7260","3395","عملیات توسط Async Request کامل شد","2022-05-03 22:38:47","2022-05-04 03:08:47"),
("7261","3396","عملیات توسط Async Request شروع شد","2022-05-03 22:38:47","2022-05-04 03:08:47"),
("7262","3396","عملیات توسط Async Request کامل شد","2022-05-03 22:38:47","2022-05-04 03:08:47"),
("7263","3397","ایجاد فعالیت","2022-05-03 22:39:18","2022-05-04 03:09:18"),
("7264","3398","ایجاد فعالیت","2022-05-03 22:39:18","2022-05-04 03:09:18"),
("7265","3397","عملیات توسط WP Cron شروع شد","2022-05-03 22:39:22","2022-05-04 03:09:22"),
("7266","3397","عملیات توسط WP Cron کامل شد","2022-05-03 22:39:22","2022-05-04 03:09:22"),
("7267","3398","عملیات توسط WP Cron شروع شد","2022-05-03 22:39:22","2022-05-04 03:09:22"),
("7268","3398","عملیات توسط WP Cron کامل شد","2022-05-03 22:39:22","2022-05-04 03:09:22"),
("7269","3399","ایجاد فعالیت","2022-05-03 22:39:33","2022-05-04 03:09:33"),
("7270","3400","ایجاد فعالیت","2022-05-03 22:39:33","2022-05-04 03:09:33"),
("7271","3401","ایجاد فعالیت","2022-05-03 22:39:51","2022-05-04 03:09:51"),
("7272","3402","ایجاد فعالیت","2022-05-03 22:39:51","2022-05-04 03:09:51"),
("7273","3399","عملیات توسط Async Request شروع شد","2022-05-03 22:39:56","2022-05-04 03:09:56"),
("7274","3399","عملیات توسط Async Request کامل شد","2022-05-03 22:39:56","2022-05-04 03:09:56"),
("7275","3401","عملیات توسط Async Request شروع شد","2022-05-03 22:39:56","2022-05-04 03:09:56"),
("7276","3401","عملیات توسط Async Request کامل شد","2022-05-03 22:39:56","2022-05-04 03:09:56"),
("7277","3400","عملیات توسط Async Request شروع شد","2022-05-03 22:39:56","2022-05-04 03:09:56"),
("7278","3400","عملیات توسط Async Request کامل شد","2022-05-03 22:39:57","2022-05-04 03:09:57"),
("7279","3402","عملیات توسط Async Request شروع شد","2022-05-03 22:39:57","2022-05-04 03:09:57"),
("7280","3402","عملیات توسط Async Request کامل شد","2022-05-03 22:39:57","2022-05-04 03:09:57"),
("7281","3403","ایجاد فعالیت","2022-05-03 22:40:09","2022-05-04 03:10:09"),
("7282","3404","ایجاد فعالیت","2022-05-03 22:40:09","2022-05-04 03:10:09"),
("7283","3405","ایجاد فعالیت","2022-05-03 22:40:18","2022-05-04 03:10:18"),
("7284","3406","ایجاد فعالیت","2022-05-03 22:40:18","2022-05-04 03:10:18"),
("7285","3403","عملیات توسط WP Cron شروع شد","2022-05-03 22:40:30","2022-05-04 03:10:30"),
("7286","3403","عملیات توسط WP Cron کامل شد","2022-05-03 22:40:30","2022-05-04 03:10:30"),
("7287","3405","عملیات توسط WP Cron شروع شد","2022-05-03 22:40:30","2022-05-04 03:10:30"),
("7288","3405","عملیات توسط WP Cron کامل شد","2022-05-03 22:40:30","2022-05-04 03:10:30"),
("7289","3404","عملیات توسط WP Cron شروع شد","2022-05-03 22:40:30","2022-05-04 03:10:30"),
("7290","3404","عملیات توسط WP Cron کامل شد","2022-05-03 22:40:31","2022-05-04 03:10:31"),
("7291","3406","عملیات توسط WP Cron شروع شد","2022-05-03 22:40:31","2022-05-04 03:10:31"),
("7292","3406","عملیات توسط WP Cron کامل شد","2022-05-03 22:40:31","2022-05-04 03:10:31"),
("7293","3407","ایجاد فعالیت","2022-05-03 22:41:00","2022-05-04 03:11:00"),
("7294","3408","ایجاد فعالیت","2022-05-03 22:41:01","2022-05-04 03:11:01"),
("7295","3407","عملیات توسط Async Request شروع شد","2022-05-03 22:41:03","2022-05-04 03:11:03"),
("7296","3407","عملیات توسط Async Request کامل شد","2022-05-03 22:41:03","2022-05-04 03:11:03"),
("7297","3408","عملیات توسط Async Request شروع شد","2022-05-03 22:41:03","2022-05-04 03:11:03"),
("7298","3408","عملیات توسط Async Request کامل شد","2022-05-03 22:41:03","2022-05-04 03:11:03"),
("7299","3409","ایجاد فعالیت","2022-05-03 22:44:07","2022-05-04 03:14:07"),
("7300","3410","ایجاد فعالیت","2022-05-03 22:44:08","2022-05-04 03:14:08"),
("7301","3411","ایجاد فعالیت","2022-05-03 22:44:08","2022-05-04 03:14:08"),
("7302","3412","ایجاد فعالیت","2022-05-03 22:44:09","2022-05-04 03:14:09"),
("7303","3409","عملیات توسط WP Cron شروع شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7304","3409","عملیات توسط WP Cron کامل شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7305","3411","عملیات توسط WP Cron شروع شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7306","3411","عملیات توسط WP Cron کامل شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7307","3410","عملیات توسط WP Cron شروع شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7308","3410","عملیات توسط WP Cron کامل شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7309","3412","عملیات توسط WP Cron شروع شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7310","3412","عملیات توسط WP Cron کامل شد","2022-05-03 22:44:11","2022-05-04 03:14:11"),
("7311","3413","ایجاد فعالیت","2022-05-03 22:46:08","2022-05-04 03:16:08"),
("7312","3414","ایجاد فعالیت","2022-05-03 22:46:08","2022-05-04 03:16:08"),
("7313","3413","عملیات توسط WP Cron شروع شد","2022-05-03 22:46:09","2022-05-04 03:16:09"),
("7314","3413","عملیات توسط WP Cron کامل شد","2022-05-03 22:46:09","2022-05-04 03:16:09"),
("7315","3414","عملیات توسط WP Cron شروع شد","2022-05-03 22:46:09","2022-05-04 03:16:09"),
("7316","3414","عملیات توسط WP Cron کامل شد","2022-05-03 22:46:09","2022-05-04 03:16:09"),
("7317","3415","ایجاد فعالیت","2022-05-04 05:43:35","2022-05-04 10:13:35"),
("7318","3415","عملیات توسط Async Request شروع شد","2022-05-04 05:43:57","2022-05-04 10:13:57"),
("7319","3415","عملیات توسط Async Request کامل شد","2022-05-04 05:43:57","2022-05-04 10:13:57"),
("7320","3416","ایجاد فعالیت","2022-05-04 09:29:46","2022-05-04 13:59:46"),
("7321","3417","ایجاد فعالیت","2022-05-04 09:29:46","2022-05-04 13:59:46"),
("7322","3418","ایجاد فعالیت","2022-05-04 09:30:01","2022-05-04 14:00:01"),
("7323","3419","ایجاد فعالیت","2022-05-04 09:30:01","2022-05-04 14:00:01"),
("7324","3420","ایجاد فعالیت","2022-05-04 09:30:12","2022-05-04 14:00:12"),
("7325","3421","ایجاد فعالیت","2022-05-04 09:30:12","2022-05-04 14:00:12"),
("7326","3422","ایجاد فعالیت","2022-05-04 09:30:24","2022-05-04 14:00:24"),
("7327","3423","ایجاد فعالیت","2022-05-04 09:30:25","2022-05-04 14:00:25"),
("7328","3416","عملیات توسط Async Request شروع شد","2022-05-04 09:30:28","2022-05-04 14:00:28"),
("7329","3416","عملیات توسط Async Request کامل شد","2022-05-04 09:30:28","2022-05-04 14:00:28"),
("7330","3418","عملیات توسط Async Request شروع شد","2022-05-04 09:30:28","2022-05-04 14:00:28"),
("7331","3418","عملیات توسط Async Request کامل شد","2022-05-04 09:30:28","2022-05-04 14:00:28"),
("7332","3420","عملیات توسط Async Request شروع شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7333","3420","عملیات توسط Async Request کامل شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7334","3422","عملیات توسط Async Request شروع شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7335","3422","عملیات توسط Async Request کامل شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7336","3417","عملیات توسط Async Request شروع شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7337","3417","عملیات توسط Async Request کامل شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7338","3419","عملیات توسط Async Request شروع شد","2022-05-04 09:30:29","2022-05-04 14:00:29"),
("7339","3419","عملیات توسط Async Request کامل شد","2022-05-04 09:30:30","2022-05-04 14:00:30"),
("7340","3421","عملیات توسط Async Request شروع شد","2022-05-04 09:30:30","2022-05-04 14:00:30"),
("7341","3421","عملیات توسط Async Request کامل شد","2022-05-04 09:30:30","2022-05-04 14:00:30"),
("7342","3423","عملیات توسط Async Request شروع شد","2022-05-04 09:30:30","2022-05-04 14:00:30"),
("7343","3423","عملیات توسط Async Request کامل شد","2022-05-04 09:30:30","2022-05-04 14:00:30"),
("7344","3424","ایجاد فعالیت","2022-05-04 09:30:53","2022-05-04 14:00:53"),
("7345","3425","ایجاد فعالیت","2022-05-04 09:30:54","2022-05-04 14:00:54"),
("7346","3424","عملیات توسط WP Cron شروع شد","2022-05-04 09:30:59","2022-05-04 14:00:59"),
("7347","3424","عملیات توسط WP Cron کامل شد","2022-05-04 09:30:59","2022-05-04 14:00:59"),
("7348","3425","عملیات توسط WP Cron شروع شد","2022-05-04 09:30:59","2022-05-04 14:00:59"),
("7349","3425","عملیات توسط WP Cron کامل شد","2022-05-04 09:30:59","2022-05-04 14:00:59"),
("7350","3426","ایجاد فعالیت","2022-05-04 09:31:31","2022-05-04 14:01:31"),
("7351","3427","ایجاد فعالیت","2022-05-04 09:31:31","2022-05-04 14:01:31"),
("7352","3428","ایجاد فعالیت","2022-05-04 09:31:38","2022-05-04 14:01:38"),
("7353","3429","ایجاد فعالیت","2022-05-04 09:31:38","2022-05-04 14:01:38"),
("7354","3426","عملیات توسط Async Request شروع شد","2022-05-04 09:31:43","2022-05-04 14:01:43"),
("7355","3426","عملیات توسط Async Request کامل شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7356","3428","عملیات توسط Async Request شروع شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7357","3428","عملیات توسط Async Request کامل شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7358","3427","عملیات توسط Async Request شروع شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7359","3427","عملیات توسط Async Request کامل شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7360","3429","عملیات توسط Async Request شروع شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7361","3429","عملیات توسط Async Request کامل شد","2022-05-04 09:31:44","2022-05-04 14:01:44"),
("7362","3430","ایجاد فعالیت","2022-05-04 09:31:56","2022-05-04 14:01:56"),
("7363","3431","ایجاد فعالیت","2022-05-04 09:31:56","2022-05-04 14:01:56"),
("7364","3430","عملیات توسط WP Cron شروع شد","2022-05-04 09:32:02","2022-05-04 14:02:02"),
("7365","3430","عملیات توسط WP Cron کامل شد","2022-05-04 09:32:03","2022-05-04 14:02:03"),
("7366","3431","عملیات توسط WP Cron شروع شد","2022-05-04 09:32:03","2022-05-04 14:02:03"),
("7367","3431","عملیات توسط WP Cron کامل شد","2022-05-04 09:32:03","2022-05-04 14:02:03"),
("7368","3432","ایجاد فعالیت","2022-05-04 09:32:04","2022-05-04 14:02:04"),
("7369","3433","ایجاد فعالیت","2022-05-04 09:32:05","2022-05-04 14:02:05"),
("7370","3434","ایجاد فعالیت","2022-05-04 09:32:18","2022-05-04 14:02:18"),
("7371","3435","ایجاد فعالیت","2022-05-04 09:32:19","2022-05-04 14:02:19"),
("7372","3436","ایجاد فعالیت","2022-05-04 09:32:27","2022-05-04 14:02:27"),
("7373","3437","ایجاد فعالیت","2022-05-04 09:32:28","2022-05-04 14:02:28"),
("7374","3438","ایجاد فعالیت","2022-05-04 09:32:35","2022-05-04 14:02:35"),
("7375","3439","ایجاد فعالیت","2022-05-04 09:32:36","2022-05-04 14:02:36"),
("7376","3432","عملیات توسط Async Request شروع شد","2022-05-04 09:33:01","2022-05-04 14:03:01"),
("7377","3432","عملیات توسط Async Request کامل شد","2022-05-04 09:33:01","2022-05-04 14:03:01"),
("7378","3434","عملیات توسط Async Request شروع شد","2022-05-04 09:33:01","2022-05-04 14:03:01"),
("7379","3434","عملیات توسط Async Request کامل شد","2022-05-04 09:33:01","2022-05-04 14:03:01"),
("7380","3436","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7381","3436","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7382","3438","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7383","3438","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7384","3433","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7385","3433","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7386","3435","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7387","3435","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7388","3437","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7389","3437","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7390","3439","عملیات توسط Async Request شروع شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7391","3439","عملیات توسط Async Request کامل شد","2022-05-04 09:33:02","2022-05-04 14:03:02"),
("7392","3440","ایجاد فعالیت","2022-05-04 09:34:15","2022-05-04 14:04:15"),
("7393","3441","ایجاد فعالیت","2022-05-04 09:34:15","2022-05-04 14:04:15"),
("7394","3442","ایجاد فعالیت","2022-05-04 09:34:36","2022-05-04 14:04:36"),
("7395","3443","ایجاد فعالیت","2022-05-04 09:34:36","2022-05-04 14:04:36"),
("7396","3444","ایجاد فعالیت","2022-05-04 09:34:43","2022-05-04 14:04:43"),
("7397","3445","ایجاد فعالیت","2022-05-04 09:34:43","2022-05-04 14:04:43"),
("7398","3440","عملیات توسط Async Request شروع شد","2022-05-04 09:34:57","2022-05-04 14:04:57"),
("7399","3440","عملیات توسط Async Request کامل شد","2022-05-04 09:34:57","2022-05-04 14:04:57"),
("7400","3442","عملیات توسط Async Request شروع شد","2022-05-04 09:34:57","2022-05-04 14:04:57"),
("7401","3442","عملیات توسط Async Request کامل شد","2022-05-04 09:34:57","2022-05-04 14:04:57"),
("7402","3444","عملیات توسط Async Request شروع شد","2022-05-04 09:34:57","2022-05-04 14:04:57"),
("7403","3444","عملیات توسط Async Request کامل شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7404","3441","عملیات توسط Async Request شروع شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7405","3441","عملیات توسط Async Request کامل شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7406","3443","عملیات توسط Async Request شروع شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7407","3443","عملیات توسط Async Request کامل شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7408","3445","عملیات توسط Async Request شروع شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7409","3445","عملیات توسط Async Request کامل شد","2022-05-04 09:34:58","2022-05-04 14:04:58"),
("7410","3446","ایجاد فعالیت","2022-05-04 09:35:11","2022-05-04 14:05:11"),
("7411","3447","ایجاد فعالیت","2022-05-04 09:35:11","2022-05-04 14:05:11"),
("7412","3446","عملیات توسط WP Cron شروع شد","2022-05-04 09:35:19","2022-05-04 14:05:19"),
("7413","3446","عملیات توسط WP Cron کامل شد","2022-05-04 09:35:19","2022-05-04 14:05:19"),
("7414","3447","عملیات توسط WP Cron شروع شد","2022-05-04 09:35:19","2022-05-04 14:05:19"),
("7415","3447","عملیات توسط WP Cron کامل شد","2022-05-04 09:35:20","2022-05-04 14:05:20"),
("7416","3448","ایجاد فعالیت","2022-05-04 09:41:16","2022-05-04 14:11:16"),
("7417","3449","ایجاد فعالیت","2022-05-04 09:41:16","2022-05-04 14:11:16");

INSERT INTO `wp_actionscheduler_logs` VALUES 
("7418","3448","عملیات توسط WP Cron شروع شد","2022-05-04 09:41:16","2022-05-04 14:11:16"),
("7419","3448","عملیات توسط WP Cron کامل شد","2022-05-04 09:41:16","2022-05-04 14:11:16"),
("7420","3449","عملیات توسط Async Request شروع شد","2022-05-04 09:41:35","2022-05-04 14:11:35"),
("7421","3449","عملیات توسط Async Request کامل شد","2022-05-04 09:41:35","2022-05-04 14:11:35"),
("7422","3450","ایجاد فعالیت","2022-05-04 09:44:09","2022-05-04 14:14:09"),
("7423","3451","ایجاد فعالیت","2022-05-04 09:44:10","2022-05-04 14:14:10"),
("7424","3450","عملیات توسط WP Cron شروع شد","2022-05-04 09:44:11","2022-05-04 14:14:11"),
("7425","3450","عملیات توسط WP Cron کامل شد","2022-05-04 09:44:11","2022-05-04 14:14:11"),
("7426","3451","عملیات توسط WP Cron شروع شد","2022-05-04 09:44:11","2022-05-04 14:14:11"),
("7427","3451","عملیات توسط WP Cron کامل شد","2022-05-04 09:44:11","2022-05-04 14:14:11"),
("7428","3452","ایجاد فعالیت","2022-05-04 09:44:17","2022-05-04 14:14:17"),
("7429","3453","ایجاد فعالیت","2022-05-04 09:44:18","2022-05-04 14:14:18"),
("7430","3452","عملیات توسط Async Request شروع شد","2022-05-04 09:45:02","2022-05-04 14:15:02"),
("7431","3452","عملیات توسط Async Request کامل شد","2022-05-04 09:45:02","2022-05-04 14:15:02"),
("7432","3453","عملیات توسط Async Request شروع شد","2022-05-04 09:45:02","2022-05-04 14:15:02"),
("7433","3453","عملیات توسط Async Request کامل شد","2022-05-04 09:45:02","2022-05-04 14:15:02"),
("7434","3454","ایجاد فعالیت","2022-05-04 09:46:28","2022-05-04 14:16:28"),
("7435","3455","ایجاد فعالیت","2022-05-04 09:46:28","2022-05-04 14:16:28"),
("7436","3454","عملیات توسط Async Request شروع شد","2022-05-04 09:47:12","2022-05-04 14:17:12"),
("7437","3454","عملیات توسط Async Request کامل شد","2022-05-04 09:47:12","2022-05-04 14:17:12"),
("7438","3455","عملیات توسط Async Request شروع شد","2022-05-04 09:47:12","2022-05-04 14:17:12"),
("7439","3455","عملیات توسط Async Request کامل شد","2022-05-04 09:47:12","2022-05-04 14:17:12"),
("7440","3456","ایجاد فعالیت","2022-05-04 09:48:31","2022-05-04 14:18:31"),
("7441","3457","ایجاد فعالیت","2022-05-04 09:48:31","2022-05-04 14:18:31"),
("7442","3458","ایجاد فعالیت","2022-05-04 09:48:53","2022-05-04 14:18:53"),
("7443","3459","ایجاد فعالیت","2022-05-04 09:48:54","2022-05-04 14:18:54"),
("7444","3460","ایجاد فعالیت","2022-05-04 09:48:57","2022-05-04 14:18:57"),
("7445","3456","عملیات توسط WP Cron شروع شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7446","3456","عملیات توسط WP Cron کامل شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7447","3458","عملیات توسط WP Cron شروع شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7448","3458","عملیات توسط WP Cron کامل شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7449","3460","عملیات توسط WP Cron شروع شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7450","3460","عملیات توسط WP Cron کامل شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7451","3457","عملیات توسط WP Cron شروع شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7452","3457","عملیات توسط WP Cron کامل شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7453","3459","عملیات توسط WP Cron شروع شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7454","3459","عملیات توسط WP Cron کامل شد","2022-05-04 09:49:39","2022-05-04 14:19:39"),
("7455","3461","ایجاد فعالیت","2022-05-04 09:53:13","2022-05-04 14:23:13"),
("7456","3462","ایجاد فعالیت","2022-05-04 09:53:13","2022-05-04 14:23:13"),
("7457","3461","عملیات توسط Async Request شروع شد","2022-05-04 09:54:13","2022-05-04 14:24:13"),
("7458","3461","عملیات توسط Async Request کامل شد","2022-05-04 09:54:13","2022-05-04 14:24:13"),
("7459","3462","عملیات توسط Async Request شروع شد","2022-05-04 09:54:13","2022-05-04 14:24:13"),
("7460","3462","عملیات توسط Async Request کامل شد","2022-05-04 09:54:13","2022-05-04 14:24:13"),
("7461","3463","ایجاد فعالیت","2022-05-04 09:56:34","2022-05-04 14:26:34"),
("7462","3464","ایجاد فعالیت","2022-05-04 09:56:35","2022-05-04 14:26:35"),
("7463","3463","عملیات توسط WP Cron شروع شد","2022-05-04 09:56:40","2022-05-04 14:26:40"),
("7464","3463","عملیات توسط WP Cron کامل شد","2022-05-04 09:56:40","2022-05-04 14:26:40"),
("7465","3464","عملیات توسط WP Cron شروع شد","2022-05-04 09:56:40","2022-05-04 14:26:40"),
("7466","3464","عملیات توسط WP Cron کامل شد","2022-05-04 09:56:40","2022-05-04 14:26:40"),
("7467","3465","ایجاد فعالیت","2022-05-04 11:20:51","2022-05-04 15:50:51"),
("7468","3465","عملیات توسط WP Cron شروع شد","2022-05-04 11:21:11","2022-05-04 15:51:11"),
("7469","3465","عملیات توسط WP Cron کامل شد","2022-05-04 11:21:11","2022-05-04 15:51:11"),
("7470","3466","ایجاد فعالیت","2022-05-08 10:09:03","2022-05-08 14:39:03"),
("7471","3466","عملیات توسط WP Cron شروع شد","2022-05-08 14:42:37","2022-05-08 19:12:37"),
("7472","3466","عملیات توسط WP Cron کامل شد","2022-05-08 14:42:37","2022-05-08 19:12:37"),
("7473","3467","ایجاد فعالیت","2022-05-09 10:15:39","2022-05-09 14:45:39"),
("7474","3467","عملیات توسط WP Cron شروع شد","2022-05-09 10:17:17","2022-05-09 14:47:17"),
("7475","3467","عملیات توسط WP Cron کامل شد","2022-05-09 10:17:17","2022-05-09 14:47:17"),
("7476","3468","ایجاد فعالیت","2022-05-09 10:28:53","2022-05-09 14:58:53"),
("7477","3468","عملیات توسط WP Cron شروع شد","2022-05-09 10:29:11","2022-05-09 14:59:11"),
("7478","3468","عملیات توسط WP Cron کامل شد","2022-05-09 10:29:11","2022-05-09 14:59:11"),
("7479","3469","ایجاد فعالیت","2022-05-10 13:32:16","2022-05-10 18:02:16"),
("7480","3469","عملیات توسط WP Cron شروع شد","2022-05-10 13:33:21","2022-05-10 18:03:21"),
("7481","3469","عملیات توسط WP Cron کامل شد","2022-05-10 13:33:21","2022-05-10 18:03:21"),
("7482","3470","ایجاد فعالیت","2022-05-10 15:34:14","2022-05-10 20:04:14"),
("7483","3470","عملیات توسط WP Cron شروع شد","2022-05-10 15:36:08","2022-05-10 20:06:08"),
("7484","3470","عملیات توسط WP Cron کامل شد","2022-05-10 15:36:08","2022-05-10 20:06:08"),
("7485","3471","ایجاد فعالیت","2022-05-10 15:36:08","2022-05-10 20:06:08"),
("7486","3471","عملیات توسط WP Cron شروع شد","2022-05-10 15:37:10","2022-05-10 20:07:10"),
("7487","3471","عملیات توسط WP Cron کامل شد","2022-05-10 15:37:10","2022-05-10 20:07:10"),
("7488","3472","ایجاد فعالیت","2022-05-13 16:17:51","2022-05-13 20:47:51"),
("7489","3472","عملیات توسط WP Cron شروع شد","2022-05-13 16:18:10","2022-05-13 20:48:10"),
("7490","3472","عملیات توسط WP Cron کامل شد","2022-05-13 16:18:10","2022-05-13 20:48:10");


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES 
("271","865","verified","0"),
("272","866","verified","0"),
("273","867","verified","0"),
("274","868","verified","0"),
("275","869","verified","0"),
("276","870","verified","0"),
("277","871","verified","0"),
("278","872","verified","0"),
("279","873","verified","0"),
("280","775","_wp_trash_meta_status","0"),
("281","775","_wp_trash_meta_time","1651400502"),
("282","774","_wp_trash_meta_status","0"),
("283","774","_wp_trash_meta_time","1651400502"),
("284","710","_wp_trash_meta_status","0"),
("285","710","_wp_trash_meta_time","1651400502"),
("286","693","_wp_trash_meta_status","0"),
("287","693","_wp_trash_meta_time","1651400502"),
("288","680","_wp_trash_meta_status","0"),
("289","680","_wp_trash_meta_time","1651400502"),
("290","679","_wp_trash_meta_status","0"),
("291","679","_wp_trash_meta_time","1651400502"),
("292","678","_wp_trash_meta_status","0"),
("293","678","_wp_trash_meta_time","1651400502"),
("294","673","_wp_trash_meta_status","0"),
("295","673","_wp_trash_meta_time","1651400502"),
("296","875","verified","0"),
("263","857","verified","0"),
("264","858","verified","0"),
("265","859","verified","0"),
("266","860","verified","0"),
("267","861","verified","0"),
("268","862","verified","0"),
("269","863","verified","0"),
("270","864","verified","0"),
("252","826","verified","0"),
("253","827","verified","0"),
("254","828","verified","0"),
("255","840","verified","0"),
("256","846","verified","0"),
("257","847","verified","0"),
("258","848","verified","0"),
("259","849","verified","0"),
("260","850","verified","0"),
("261","851","verified","0"),
("262","852","verified","0"),
("297","876","verified","0"),
("298","877","verified","0");


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES 
("857","1992","🔥 Aimee is interested in you! More info: http://inx.lv/wrxj?h=3cf81b074f9c205849eb1284e22794e4- 🔥","deathgiver101@suttal.com","","188.122.68.228","2022-03-29 22:23:31","2022-03-29 17:53:31","ulsihb1","0","0","Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.112 Amigo/45.0.2454.112 MRCHROME SOC Safari/537.36","review","0","0"),
("858","1986","❤️ Alison want to meet you! Click here: https://clck.ru/ec76F?h=3588dc7c677b164fdedcf35938c0c578- ❤️","deathgiver101@suttal.com","","188.122.68.228","2022-03-29 22:24:36","2022-03-29 17:54:36","7sd6t4","0","0","Mozilla/5.0 (X11; U; Linux x86_64; pl-PL; rv:2.0) Gecko/20110307 Firefox/4.0","review","0","0"),
("859","2023","🔥 Krystal is interested in you! More info: http://inx.lv/wg82?h=f96e6afc4480178ca016b6ae793429ea- 🔥","deathgiver101@suttal.com","","5.200.14.12","2022-03-29 22:24:54","2022-03-29 17:54:54","grru0q20","0","0","Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.46 Safari/535.11 MRCHROME","review","0","0"),
("860","2490","💌 You have unread messages (4) from Susanna! Read now: https://clck.ru/ec76F?h=df90a33ea087f9580ca737998534f702- 💌","deathgiver101@suttal.com","","188.122.68.228","2022-03-29 22:25:51","2022-03-29 17:55:51","e67bxp1","0","0","Mozilla/5.0 (Windows NT 5.1; rv:14.0) Gecko/20100101 Firefox/14.0.1","review","0","0"),
("861","1839","💌 You have unread messages (4) from Lauren! Read now: https://clck.ru/ec76F?h=8904d1f7a84893d98b7ac5b4661cc860- 💌","deathgiver101@suttal.com","","188.122.68.228","2022-03-29 22:26:24","2022-03-29 17:56:24","k709c04","0","0","Mozilla/5.0 (Windows NT 5.1; rv:19.0) Gecko/20100101 Firefox/19.0","review","0","0"),
("862","2020","❤️‍🔥 Kristal is interested in your profile! More info: http://inx.lv/wg82?h=059d79f71e519ada1fb3614c65548ee5- ❤️‍🔥","deathgiver101@suttal.com","","5.200.14.12","2022-03-29 22:27:29","2022-03-29 17:57:29","l3yxhsu","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:36.0) Gecko/20100101 Firefox/36.0","review","0","0"),
("863","1853","❤️ Ane want to meet you! Click here: http://inx.lv/wg82?h=248efa209a63e26d31920448aa7ee3f4- ❤️","deathgiver101@suttal.com","","188.122.68.228","2022-03-29 22:28:42","2022-03-29 17:58:42","mzyd1x6","0","0","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.86 YaBrowser/15.12.1.6476 Yowser/2.5 Safari/537.36","review","0","0"),
("864","1959","Marco Bou","marco.bou@msn.com","","5.154.174.1","2022-04-14 17:51:49","2022-04-14 13:21:49","Hello\r\n\r\nIf you ever need Negative SEO or a de-rank strategy, you can hire us here\r\n\r\nhttps://www.speed-seo.net/product/negative-seo-service/","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("865","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.217.20","2022-04-16 03:08:43","2022-04-15 22:38:43","Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found pishraftsch.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://talkwithwebtraffic.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://talkwithwebtraffic.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("866","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.213.20","2022-04-18 03:56:31","2022-04-17 23:26:31","Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found pishraftsch.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("33","182","سارا عبادی","infeloenser@yahoo.com","","46.245.96.214","2019-10-22 18:06:14","2019-10-22 14:36:14","لشکر گوسفندان که توسط یک شیر اداره می‌شود، می‌تواند لشکر شیران را که توسط یک گوسفند اداره می‌شود، شکست دهد.","0","1","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","comment","0","0"),
("34","202","دیدگاه نویس","matrix@gmail.com","","46.245.96.214","2019-10-22 18:07:11","2019-10-22 14:37:11","مردمی که به میل خود در تاریکی نشسته‌اند، نیازی به روشنایی ندارند!","0","1","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","comment","0","0"),
("35","202","جواد مرادی","pishraftsch.com@gmail.com","","46.245.96.214","2019-10-22 18:13:13","2019-10-22 14:43:13","ناامیدی ترسناک‌تر از پیری است، در پیری جسم ما مچاله می‌شود، در ناامیدی روح ما.","0","1","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","comment","0","1"),
("36","202","جواد مرادی","pishraftsch.com@gmail.com","","46.245.96.214","2019-10-22 18:13:37","2019-10-22 14:43:37","چرا نمی‌توانیم زندگی‌های مختلفی را امتحان کنیم مثل لباس‌های گوناگون تا ببینیم کدام بیشتر به ما می‌آید؟","0","1","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","comment","34","1"),
("792","1664","ووکامرس","","","","2022-02-11 02:10:19","2022-02-10 22:40:19","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("793","1707","ووکامرس","","","","2022-02-11 13:54:37","2022-02-11 10:24:37","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("794","1827","ووکامرس","","","","2022-02-11 18:30:50","2022-02-11 15:00:50","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("795","1828","ووکامرس","","","","2022-02-11 18:50:46","2022-02-11 15:20:46","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("796","1829","ووکامرس","","","","2022-02-11 19:25:49","2022-02-11 15:55:49","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("797","1830","ووکامرس","","","","2022-02-11 19:42:28","2022-02-11 16:12:28","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("798","1831","ووکامرس","","","","2022-02-11 19:50:46","2022-02-11 16:20:46","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("799","1836","ووکامرس","","","","2022-02-11 20:09:52","2022-02-11 16:39:52","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("800","1841","ووکامرس","","","","2022-02-11 22:27:08","2022-02-11 18:57:08","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("801","1842","ووکامرس","","","","2022-02-11 22:27:35","2022-02-11 18:57:35","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("802","1845","ووکامرس","","","","2022-02-11 22:40:23","2022-02-11 19:10:23","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("803","1848","ووکامرس","","","","2022-02-11 22:48:54","2022-02-11 19:18:54","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("804","1852","ووکامرس","","","","2022-02-11 23:02:18","2022-02-11 19:32:18","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("805","1855","ووکامرس","","","","2022-02-11 23:50:15","2022-02-11 20:20:15","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("806","1858","ووکامرس","","","","2022-02-12 00:00:46","2022-02-11 20:30:46","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("807","1863","ووکامرس","","","","2022-02-12 00:31:35","2022-02-11 21:01:35","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("808","1866","ووکامرس","","","","2022-02-12 01:09:16","2022-02-11 21:39:16","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("809","1869","ووکامرس","","","","2022-02-12 01:20:25","2022-02-11 21:50:25","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("810","1872","ووکامرس","","","","2022-02-12 01:30:42","2022-02-11 22:00:42","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("811","1908","ووکامرس","","","","2022-02-14 13:35:43","2022-02-14 10:05:43","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("812","1912","ووکامرس","","","","2022-02-14 15:01:31","2022-02-14 11:31:31","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("813","1915","ووکامرس","","","","2022-02-14 15:09:14","2022-02-14 11:39:14","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("814","1937","ووکامرس","","","","2022-02-14 15:51:30","2022-02-14 12:21:30","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("815","1940","ووکامرس","","","","2022-02-14 16:06:23","2022-02-14 12:36:23","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("816","1943","ووکامرس","","","","2022-02-14 16:17:29","2022-02-14 12:47:29","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("817","1946","ووکامرس","","","","2022-02-14 16:33:21","2022-02-14 13:03:21","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("818","1949","ووکامرس","","","","2022-02-14 17:43:03","2022-02-14 14:13:03","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("819","1952","ووکامرس","","","","2022-02-14 17:50:44","2022-02-14 14:20:44","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("820","1955","ووکامرس","","","","2022-02-14 18:34:30","2022-02-14 15:04:30","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("821","1958","ووکامرس","","","","2022-02-14 18:45:13","2022-02-14 15:15:13","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("822","1961","ووکامرس","","","","2022-02-14 19:15:02","2022-02-14 15:45:02","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("823","1964","ووکامرس","","","","2022-02-14 19:35:45","2022-02-14 16:05:45","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("824","1966","ووکامرس","","","","2022-02-16 09:32:48","2022-02-16 06:02:48","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("825","1970","ووکامرس","","","","2022-02-16 11:28:44","2022-02-16 07:58:44","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("826","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.197.20","2022-02-17 02:12:54","2022-02-16 22:42:54","Hi, my name is Eric and I’m betting you’d like your website pishraftsch.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at pishraftsch.com.\r\n\r\nTalk With Web Visitor – CLICK HERE https://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("827","1959","Eric Jones","eric.jones.z.mail@gmail.com","","188.122.68.228","2022-02-17 11:35:22","2022-02-17 08:05:22","Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with pishraftsch.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out pishraftsch.com.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("673","182","مشاور کنکور","davidlane@mail.com","","31.14.80.26","2021-01-22 15:51:07","2021-01-22 12:21:07","لشکر گوسفندان که توسط یک شیر اداره می‌شود، می‌تواند لشکر شیران را که توسط یک گوسفند اداره می‌شود، شکست دهد.","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36","comment","0","0"),
("828","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.213.20","2022-02-17 11:40:50","2022-02-17 08:10:50","My name’s Eric and I just came across your website - pishraftsch.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like pishraftsch.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("678","40","رضا","awas@gmail.com","","31.14.87.29","2021-01-30 01:20:59","2021-01-29 21:50:59","طبیلیبرطظیبظیبظیب","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.104 Safari/537.36","comment","0","0"),
("679","40","یطیبطیبطی","awas@gmail.com","","31.14.87.29","2021-01-30 01:21:29","2021-01-29 21:51:29","طیبطیبسذیقبلاتیلاذطبلاسذیبلاسیبللیبل","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.104 Safari/537.36","comment","678","0"),
("680","8","رضا","davidlane@mail.com","","31.14.87.12","2021-01-30 11:32:45","2021-01-30 08:02:45","تست","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.104 Safari/537.36","comment","0","0"),
("693","182","ابوالفضل","isari1298@gmail.com","","5.120.67.247","2021-02-12 22:54:52","2021-02-12 19:24:52","مقاله هاتون عالیه","0","trash","Mozilla/5.0 (Linux; U; Android 10; fa-ir; Redmi Note 8 Build/QKQ1.200114.002) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/12.8.3-gn","comment","0","0"),
("829","1974","ووکامرس","","","","2022-02-20 19:19:41","2022-02-20 15:49:41","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("830","1988","ووکامرس","","","","2022-02-25 12:34:04","2022-02-25 09:04:04","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("831","1989","ووکامرس","","","","2022-02-25 12:35:22","2022-02-25 09:05:22","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("832","1990","ووکامرس","","","","2022-02-25 12:36:10","2022-02-25 09:06:10","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("833","1994","ووکامرس","","","","2022-02-25 13:43:41","2022-02-25 10:13:41","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("834","1999","ووکامرس","","","","2022-02-25 15:40:42","2022-02-25 12:10:42","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("710","182","مهرانی","it-ce@imani.ir","","80.191.223.244","2021-03-03 12:54:27","2021-03-03 09:24:27","لشکر شیران هم عالی بودند","0","trash","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0","comment","33","0"),
("848","1959","Eric Jones","eric.jones.z.mail@gmail.com","","138.128.141.20","2022-03-10 23:33:34","2022-03-10 20:03:34","Cool website!\r\n\r\nMy name’s Eric, and I just found your site - pishraftsch.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across pishraftsch.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("849","1959","Eric Jones","eric.jones.z.mail@gmail.com","","188.122.68.228","2022-03-12 20:02:49","2022-03-12 16:32:49","Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found pishraftsch.com after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("733","1549","ووکامرس","","","","2021-03-21 11:34:19","2021-03-21 08:04:19","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("734","1549","جواد مرادی","pishraftsch.com@gmail.com","","","2021-03-21 11:34:42","2021-03-21 08:04:42","وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("735","1550","ووکامرس","","","","2021-03-22 12:47:44","2021-03-22 08:17:44","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("736","1550","جواد مرادی","pishraftsch.com@gmail.com","","","2021-03-22 12:47:58","2021-03-22 08:17:58","وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("856","254","Crypto","90489@gmail.com","https://bit.ly/3iCfby0","188.122.80.244","2022-03-29 18:34:38","2022-03-29 14:04:38","$300-$500 Daily With Crypto - https://bit.ly/37Py4LO","0","0","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36","comment","0","0"),
("835","2008","ووکامرس","","","","2022-02-25 16:05:44","2022-02-25 12:35:44","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("836","2014","ووکامرس","","","","2022-02-25 16:35:44","2022-02-25 13:05:44","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("837","2019","ووکامرس","","","","2022-02-25 16:41:27","2022-02-25 13:11:27","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("838","2022","ووکامرس","","","","2022-02-25 16:50:43","2022-02-25 13:20:43","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("839","2025","ووکامرس","","","","2022-02-25 17:00:20","2022-02-25 13:30:20","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("840","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.213.20","2022-02-26 10:14:20","2022-02-26 06:44:20","Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at pishraftsch.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("841","2067","ووکامرس","","","","2022-02-26 12:06:54","2022-02-26 08:36:54","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("842","2107","ووکامرس","","","","2022-02-26 19:22:51","2022-02-26 15:52:51","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("843","2422","ووکامرس","","","","2022-03-01 03:29:52","2022-02-28 23:59:52","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("844","2424","ووکامرس","","","","2022-03-01 04:22:52","2022-03-01 00:52:52","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("845","2520","ووکامرس","","","","2022-03-02 19:32:03","2022-03-02 16:02:03","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("846","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.197.20","2022-03-05 05:45:57","2022-03-05 02:15:57","Hey, this is Eric and I ran across pishraftsch.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://talkwithwebtraffic.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://talkwithwebtraffic.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("847","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.217.20","2022-03-10 20:40:44","2022-03-10 17:10:44","Cool website!\r\n\r\nMy name’s Eric, and I just found your site - pishraftsch.com - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across pishraftsch.com, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("774","202","علی","Ali@dali.com","","46.167.142.56","2021-04-19 18:46:34","2021-04-19 14:16:34","خوبه ولی می تونست شرایط رو هم همراه با این ها بررسی کند. اگر ممکن است این را بیان کن \r\nتست تست تست","0","trash","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36","comment","0","0"),
("775","202","محمد دخت هاشم","Mohammad@gmail.com","","46.167.142.56","2021-04-19 18:50:43","2021-04-19 14:20:43","خب این هم می شود","0","trash","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36","comment","35","0"),
("850","1959","Eric Jones","eric.jones.z.mail@gmail.com","","198.240.91.158","2022-03-13 21:00:44","2022-03-13 17:30:44","Hey, this is Eric and I ran across pishraftsch.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("851","1959","Eric Jones","eric.jones.z.mail@gmail.com","","5.157.43.229","2022-03-14 15:26:49","2022-03-14 11:56:49","My name’s Eric and I just found your site pishraftsch.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("852","1959","Eric Jones","eric.jones.z.mail@gmail.com","","138.128.139.148","2022-03-20 09:50:17","2022-03-20 06:20:17","Hello, my name’s Eric and I just ran across your website at pishraftsch.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("853","2521","ووکامرس","","","","2022-03-22 23:29:32","2022-03-22 18:59:32","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("854","2522","ووکامرس","","","","2022-03-22 23:32:52","2022-03-22 19:02:52","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("855","2523","ووکامرس","","","","2022-03-22 23:34:48","2022-03-22 19:04:48","پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("867","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.213.20","2022-04-21 14:33:12","2022-04-21 10:03:12","Hi, Eric here with a quick thought about your website pishraftsch.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("868","1959","Eric Jones","eric.jones.z.mail@gmail.com","","5.200.14.12","2022-04-25 07:13:21","2022-04-25 02:43:21","My name’s Eric and I just came across your website - pishraftsch.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like pishraftsch.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://talkwithwebtraffic.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://talkwithwebtraffic.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://talkwithwebtraffic.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("869","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.217.20","2022-04-25 20:27:28","2022-04-25 15:57:28","Hey, this is Eric and I ran across pishraftsch.com a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("870","1959","Arlen Guertin","arlen.guertin@outlook.com","","188.122.68.228","2022-04-27 02:36:31","2022-04-26 22:06:31","Hi there\r\nDo you want to get backlinks from domains that have tons of ranking keywords?\r\n\r\nhttps://www.monkeydigital.co/semrush-backlinks/","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("871","1959","Eric Jones","eric.jones.z.mail@gmail.com","","109.200.195.68","2022-04-28 02:06:35","2022-04-27 21:36:35","Hi, my name is Eric and I’m betting you’d like your website pishraftsch.com to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at pishraftsch.com.\r\n\r\nTalk With Web Visitor – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("872","1959","Eric Jones","eric.jones.z.mail@gmail.com","","5.200.14.12","2022-04-29 14:40:25","2022-04-29 10:10:25","Hi, Eric here with a quick thought about your website pishraftsch.com...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://talkwithwebtraffic.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://talkwithwebtraffic.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://talkwithwebtraffic.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("873","1959","Eric Jones","eric.jones.z.mail@gmail.com","","213.179.217.20","2022-05-01 12:59:52","2022-05-01 08:29:52","My name’s Eric and I just came across your website - pishraftsch.com - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like pishraftsch.com will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Talk With Web Visitor.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("874","2592","ووکامرس","","","","2022-05-02 17:32:19","2022-05-02 13:02:19","وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.","0","1","WooCommerce","order_note","0","0"),
("875","1959","Eric Jones","eric.jones.z.mail@gmail.com","","103.194.164.28","2022-05-04 22:52:58","2022-05-04 18:22:58","Hello, my name’s Eric and I just ran across your website at pishraftsch.com...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("876","1959","Eric Jones","eric.jones.z.mail@gmail.com","","138.128.141.20","2022-05-10 21:53:46","2022-05-10 17:23:46","Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at pishraftsch.com.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://talkwithwebtraffic.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://talkwithwebtraffic.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://talkwithwebtraffic.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0"),
("877","1959","Eric Jones","eric.jones.z.mail@gmail.com","","5.200.14.12","2022-05-11 00:06:46","2022-05-10 19:36:46","Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with pishraftsch.com definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out pishraftsch.com.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=pishraftsch.com","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3432.3 Safari/537.36","review","0","0");


/* INSERT TABLE DATA: wp_download_log */
INSERT INTO `wp_download_log` VALUES 
("1","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","58","","2019-10-10 20:18:47","redirected","تغییر مسیر به فایل راه دور.",NULL),
("2","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:20:51","completed","",NULL),
("3","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:20:52","completed","",NULL),
("4","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:20:56","completed","",NULL),
("5","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:21:38","completed","",NULL),
("6","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:21:43","completed","",NULL),
("7","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:25:36","completed","",NULL),
("8","1","5.117.199.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-10 20:45:35","completed","",NULL),
("9","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:12:53","completed","",NULL),
("10","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:13:15","completed","",NULL),
("11","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:15:13","completed","",NULL),
("12","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:16:53","completed","",NULL),
("13","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:54:52","completed","",NULL),
("14","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:57:27","completed","",NULL),
("15","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 09:59:14","completed","",NULL),
("16","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:03:17","completed","",NULL),
("17","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:09:28","completed","",NULL),
("18","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:10:30","completed","",NULL),
("19","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:11:04","completed","",NULL),
("20","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:18:10","completed","",NULL),
("21","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:18:18","completed","",NULL),
("22","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:18:35","completed","",NULL),
("23","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:19:37","completed","",NULL),
("24","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:21:31","completed","",NULL),
("25","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:21:35","completed","",NULL),
("26","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:23:10","completed","",NULL),
("27","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:25:16","completed","",NULL),
("28","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:29","completed","",NULL),
("29","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:38","completed","",NULL),
("30","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:42","completed","",NULL),
("31","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:42","completed","",NULL),
("32","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:46","completed","",NULL),
("33","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:38:49","completed","",NULL),
("34","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:54:12","completed","",NULL),
("35","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 10:54:21","completed","",NULL),
("36","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:54:30","completed","",NULL),
("37","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:56:36","completed","",NULL),
("38","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:57:06","completed","",NULL),
("39","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","70","71","","2019-10-11 10:57:15","completed","",NULL),
("40","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:57:24","completed","",NULL),
("41","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:57:36","completed","",NULL),
("42","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 10:57:36","completed","",NULL),
("43","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:03:15","completed","",NULL),
("44","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:06:29","completed","",NULL),
("45","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:06:29","completed","",NULL),
("46","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:06:36","completed","",NULL),
("47","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 11:06:45","completed","",NULL),
("48","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:07:06","completed","",NULL),
("49","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-11 11:25:40","completed","",NULL),
("50","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-11 11:27:04","completed","",NULL),
("51","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:30:15","completed","",NULL),
("52","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 11:30:25","completed","",NULL),
("53","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 11:32:08","completed","",NULL),
("54","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 12:10:54","completed","",NULL),
("55","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 12:15:10","completed","",NULL),
("56","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 12:22:09","completed","",NULL),
("57","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 12:22:46","completed","",NULL),
("58","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 12:41:27","completed","",NULL),
("59","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 12:58:02","completed","",NULL),
("60","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2019-10-11 12:59:05","completed","",NULL),
("61","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","97","98","","2019-10-11 12:59:10","completed","",NULL),
("62","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 12:59:31","completed","",NULL),
("63","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 12:59:33","completed","",NULL),
("64","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 12:59:47","completed","",NULL),
("65","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 13:00:39","completed","",NULL),
("66","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 13:00:52","completed","",NULL),
("67","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-11 14:13:26","completed","",NULL),
("68","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 14:13:59","completed","",NULL),
("69","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 14:22:50","completed","",NULL),
("70","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 14:23:28","completed","",NULL),
("71","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-11 14:23:36","completed","",NULL),
("72","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 14:25:17","completed","",NULL),
("73","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 14:38:47","completed","",NULL),
("74","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-11 14:46:36","completed","",NULL),
("75","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 15:35:00","completed","",NULL),
("76","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 15:35:12","completed","",NULL),
("77","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 15:47:14","completed","",NULL),
("78","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-11 15:47:24","completed","",NULL),
("79","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-11 19:33:47","completed","",NULL),
("80","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-11 19:33:58","completed","",NULL),
("81","1","5.117.65.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-11 19:34:23","completed","",NULL),
("82","1","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 19:37:11","completed","",NULL),
("83","1","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 19:37:34","completed","",NULL),
("84","1","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-11 19:38:53","completed","",NULL),
("85","1","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-11 19:51:57","completed","",NULL),
("86","0","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-11 19:52:55","completed","",NULL),
("87","1","5.117.16.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-11 19:55:33","completed","",NULL),
("88","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-12 09:56:34","completed","",NULL),
("89","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-12 09:57:21","completed","",NULL),
("90","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-12 09:57:28","completed","",NULL),
("91","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-12 09:59:12","completed","",NULL),
("92","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-12 10:00:08","completed","",NULL),
("93","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 10:01:41","completed","",NULL),
("94","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 10:02:10","completed","",NULL),
("95","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","66","67","","2019-10-12 10:02:26","completed","",NULL),
("96","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 10:37:12","completed","",NULL),
("97","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 11:01:21","completed","",NULL),
("98","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 11:15:54","completed","",NULL),
("99","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 11:28:18","completed","",NULL),
("100","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 11:29:35","completed","",NULL),
("101","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 12:52:40","completed","",NULL),
("102","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 12:52:57","completed","",NULL),
("103","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 13:31:58","completed","",NULL),
("104","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 13:33:11","completed","",NULL),
("105","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 13:33:36","completed","",NULL),
("106","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-12 13:54:06","completed","",NULL),
("107","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","101","102","","2019-10-12 13:54:21","completed","",NULL),
("108","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-12 13:54:41","completed","",NULL),
("109","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-12 13:54:49","completed","",NULL),
("110","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-12 13:54:56","completed","",NULL),
("111","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","68","69","","2019-10-12 14:20:49","completed","",NULL),
("112","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 14:21:02","completed","",NULL),
("113","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 14:27:46","completed","",NULL),
("114","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 14:28:17","completed","",NULL),
("115","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 14:36:03","completed","",NULL),
("116","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 14:36:04","completed","",NULL),
("117","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 14:36:37","completed","",NULL),
("118","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 14:44:43","completed","",NULL),
("119","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 14:45:12","completed","",NULL),
("120","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 14:55:07","completed","",NULL),
("121","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 15:02:23","completed","",NULL),
("122","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 15:04:21","completed","",NULL),
("123","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 15:04:25","completed","",NULL),
("124","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 15:09:36","completed","",NULL),
("125","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 15:13:14","completed","",NULL),
("126","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 15:19:16","completed","",NULL),
("127","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 15:26:35","completed","",NULL),
("128","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-12 15:27:05","completed","",NULL),
("129","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","57","59","","2019-10-12 16:31:26","completed","",NULL),
("130","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 16:44:05","completed","",NULL),
("131","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-12 16:46:01","completed","",NULL),
("132","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 10:21:29","completed","",NULL),
("133","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 10:37:01","completed","",NULL),
("134","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 11:02:11","completed","",NULL),
("135","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 11:47:24","completed","",NULL),
("136","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 12:41:18","completed","",NULL),
("137","1","5.115.123.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 13:27:30","completed","",NULL),
("138","1","5.117.136.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 14:01:26","completed","",NULL),
("139","0","212.103.50.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 14:29:54","completed","",NULL),
("140","1","5.117.136.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 14:56:42","completed","",NULL),
("141","1","5.117.136.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 14:56:57","completed","",NULL),
("142","0","212.103.50.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 15:53:34","completed","",NULL),
("143","1","5.117.136.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-13 16:23:30","completed","",NULL),
("144","1","5.117.136.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-13 19:52:23","completed","",NULL),
("145","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-14 15:37:01","completed","",NULL),
("146","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-14 15:37:02","completed","",NULL),
("147","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-14 15:38:32","completed","",NULL),
("148","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-14 15:39:10","completed","",NULL),
("149","1","5.116.218.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-14 16:47:14","completed","",NULL),
("150","1","5.116.218.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-15 10:48:05","completed","",NULL),
("151","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-10-16 11:11:52","completed","",NULL),
("152","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 13:06:25","completed","",NULL),
("153","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 13:07:35","completed","",NULL),
("154","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:42:13","completed","",NULL),
("155","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:43:37","completed","",NULL),
("156","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:44:49","completed","",NULL),
("157","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:45:06","completed","",NULL),
("158","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:45:44","completed","",NULL),
("159","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 09:45:57","completed","",NULL),
("160","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 09:46:08","completed","",NULL),
("161","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 09:47:14","completed","",NULL),
("162","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 09:48:35","completed","",NULL),
("163","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:49:06","completed","",NULL),
("164","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:49:06","completed","",NULL),
("165","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:49:24","completed","",NULL),
("166","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:49:29","completed","",NULL),
("167","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:50:00","completed","",NULL),
("168","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 09:51:11","completed","",NULL),
("169","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:21:26","completed","",NULL),
("170","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:21:39","completed","",NULL),
("171","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:21:44","completed","",NULL),
("172","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:22:42","completed","",NULL),
("173","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:23:50","completed","",NULL),
("174","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:24:21","completed","",NULL),
("175","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:25:24","completed","",NULL),
("176","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:25:45","completed","",NULL),
("177","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:26:17","completed","",NULL),
("178","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:26:41","completed","",NULL),
("179","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:26:57","completed","",NULL),
("180","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:27:19","completed","",NULL),
("181","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 10:28:30","completed","",NULL),
("182","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 10:28:44","completed","",NULL),
("183","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 10:29:05","completed","",NULL),
("184","2","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 10:30:18","completed","",NULL),
("185","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:36:15","completed","",NULL),
("186","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 10:54:30","completed","",NULL),
("187","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 11:50:08","completed","",NULL),
("188","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 11:50:41","completed","",NULL),
("189","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 11:51:12","completed","",NULL),
("190","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 11:52:20","completed","",NULL),
("191","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:34:02","completed","",NULL),
("192","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:36:26","completed","",NULL),
("193","1","95.82.6.188","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 12:37:30","completed","",NULL),
("194","1","95.82.6.188","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-17 12:37:40","completed","",NULL),
("195","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:38:17","completed","",NULL),
("196","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:56:32","completed","",NULL),
("197","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:57:44","completed","",NULL),
("198","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:58:13","completed","",NULL),
("199","1","5.116.186.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-17 12:58:53","completed","",NULL),
("200","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-18 10:41:14","completed","",NULL),
("201","2","5.117.211.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","57","59","","2019-10-18 11:59:04","completed","",NULL),
("202","2","5.117.211.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","57","59","","2019-10-18 11:59:05","completed","",NULL),
("203","1","95.82.52.119","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-18 11:59:42","completed","",NULL),
("204","1","95.82.52.119","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-18 11:59:43","completed","",NULL),
("205","2","5.117.211.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-18 12:01:23","completed","",NULL),
("206","2","5.117.211.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-18 12:01:24","completed","",NULL),
("207","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:29:26","completed","",NULL),
("208","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:29:42","completed","",NULL),
("209","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:30:11","completed","",NULL),
("210","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:30:27","completed","",NULL),
("211","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:30:54","completed","",NULL),
("212","0","5.116.13.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 11:34:03","completed","",NULL),
("213","1","5.116.209.249","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 14:55:21","completed","",NULL),
("214","1","5.116.209.249","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-19 15:11:31","completed","",NULL),
("215","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 16:13:45","completed","",NULL),
("216","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-19 16:13:55","completed","",NULL),
("217","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 08:55:29","completed","",NULL),
("218","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:17:00","completed","",NULL),
("219","0","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:20:14","completed","",NULL),
("220","2","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:20:31","completed","",NULL),
("221","2","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:21:10","completed","",NULL),
("222","2","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 09:21:41","completed","",NULL),
("223","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:22:02","completed","",NULL),
("224","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 09:22:44","completed","",NULL),
("225","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 09:23:32","completed","",NULL),
("226","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 09:23:44","completed","",NULL),
("227","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 09:24:47","completed","",NULL),
("228","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 11:44:00","completed","",NULL),
("229","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 11:45:11","completed","",NULL),
("230","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 11:52:01","completed","",NULL),
("231","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 11:52:10","completed","",NULL),
("232","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 11:52:17","completed","",NULL),
("233","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 11:52:24","completed","",NULL),
("234","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 11:52:32","completed","",NULL),
("235","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 12:18:33","completed","",NULL),
("236","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 12:19:20","completed","",NULL),
("237","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 12:40:50","completed","",NULL),
("238","1","5.117.15.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-20 12:41:42","completed","",NULL),
("239","1","5.117.33.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 18:01:52","completed","",NULL),
("240","1","5.117.33.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-20 18:01:52","completed","",NULL),
("241","0","5.117.197.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 22:03:58","completed","",NULL),
("242","0","5.117.197.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 22:04:02","completed","",NULL),
("243","0","188.213.100.244","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-20 22:37:38","completed","",NULL),
("244","3","188.213.100.244","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-20 22:39:03","completed","",NULL),
("245","3","188.213.100.244","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-20 22:40:23","completed","",NULL),
("246","0","46.143.68.230","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-20 22:50:34","completed","",NULL),
("247","0","46.143.68.230","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","124","125","","2019-10-20 22:53:11","completed","",NULL),
("248","0","62.201.241.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 23:07:23","completed","",NULL),
("249","0","62.201.241.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-20 23:07:31","completed","",NULL),
("250","0","5.122.253.90","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 23:23:33","completed","",NULL),
("251","0","5.122.253.90","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 23:23:37","completed","",NULL),
("252","0","5.122.253.90","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-20 23:24:58","completed","",NULL),
("253","0","91.98.179.144","Mozilla/5.0 (Windows NT 6.1; rv:69.0) Gecko/20100101 Firefox/69.0","93","94","","2019-10-21 00:39:25","completed","",NULL),
("254","0","91.98.179.144","Mozilla/5.0 (Windows NT 6.1; rv:69.0) Gecko/20100101 Firefox/69.0","93","94","","2019-10-21 00:39:36","completed","",NULL),
("255","0","93.110.123.96","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","124","125","","2019-10-21 00:42:39","completed","",NULL),
("256","0","93.110.123.96","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","124","125","","2019-10-21 00:43:46","completed","",NULL),
("257","0","212.103.50.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 09:44:53","completed","",NULL),
("258","0","212.103.50.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 09:45:06","completed","",NULL),
("259","0","212.103.50.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-10-21 09:45:16","completed","",NULL),
("260","3","5.234.132.104","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","124","125","","2019-10-21 15:16:54","completed","",NULL),
("261","3","5.234.132.104","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","124","125","","2019-10-21 15:16:55","completed","",NULL),
("262","0","46.41.211.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-21 18:10:31","completed","",NULL),
("263","0","130.255.215.44","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-21 20:43:33","completed","",NULL),
("264","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-21 22:18:21","completed","",NULL),
("265","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-21 22:18:37","completed","",NULL),
("266","0","66.249.93.47","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","93","94","","2019-10-21 22:19:58","completed","",NULL),
("267","0","80.210.137.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:21:36","completed","",NULL),
("268","0","66.249.93.43","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","93","94","","2019-10-21 22:21:55","completed","",NULL),
("269","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-21 22:22:10","completed","",NULL),
("270","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-21 22:22:14","completed","",NULL),
("271","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-21 22:22:21","completed","",NULL),
("272","0","89.196.36.165","Mozilla/5.0 (Linux; Android 9; SM-J610FN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Mobile Safari/537.36","66","67","","2019-10-21 22:23:22","completed","",NULL),
("273","0","89.196.36.165","Mozilla/5.0 (Linux; Android 9; SM-J610FN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Mobile Safari/537.36","66","67","","2019-10-21 22:24:06","completed","",NULL),
("274","0","46.62.252.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-21 22:24:09","completed","",NULL),
("275","0","89.196.36.165","Mozilla/5.0 (Linux; Android 9; SM-J610FN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Mobile Safari/537.36","124","125","","2019-10-21 22:24:43","completed","",NULL),
("276","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:27:33","completed","",NULL),
("277","0","5.234.13.109","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:27:55","completed","",NULL),
("278","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:27:59","completed","",NULL),
("279","0","46.225.180.82","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:28:20","completed","",NULL),
("280","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:28:53","completed","",NULL),
("281","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:29:00","completed","",NULL),
("282","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:29:21","redirected","تغییر مسیر به فایل راه دور.",NULL),
("283","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:29:38","completed","",NULL),
("284","0","5.215.161.15","Mozilla/5.0 (Linux; Android 9; SM-A750F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-21 22:29:42","completed","",NULL),
("285","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:29:43","completed","",NULL),
("286","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:29:59","completed","",NULL),
("287","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:30:31","completed","",NULL),
("288","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:30:34","completed","",NULL),
("289","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:30:36","completed","",NULL),
("290","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:30:46","completed","",NULL),
("291","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:30:49","completed","",NULL),
("292","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:32:29","completed","",NULL),
("293","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:32:32","completed","",NULL),
("294","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:33:18","completed","",NULL),
("295","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:33:31","completed","",NULL),
("296","0","185.153.151.26","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:33:53","redirected","تغییر مسیر به فایل راه دور.",NULL),
("297","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:34:25","completed","",NULL),
("298","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:35:53","completed","",NULL),
("299","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:35:57","completed","",NULL),
("300","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:37:02","completed","",NULL),
("301","0","37.120.135.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:38:09","completed","",NULL),
("302","0","77.42.113.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 22:38:23","completed","",NULL),
("303","0","37.120.135.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 22:38:30","completed","",NULL),
("304","0","37.120.135.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-21 22:38:59","completed","",NULL),
("305","0","188.213.191.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-21 22:50:09","completed","",NULL),
("306","0","66.102.6.111","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-21 23:04:31","completed","",NULL),
("307","0","66.102.6.111","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-21 23:04:36","completed","",NULL),
("308","0","64.233.173.175","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","66","67","","2019-10-21 23:04:53","completed","",NULL),
("309","0","66.102.6.109","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-21 23:05:02","completed","",NULL),
("310","0","64.233.173.171","Mozilla/5.0 (Linux; U; Android 4.0.3; en-us; LG-L160L Build/IML74K) AppleWebkit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/77.0.3865.99 Mobile Safari/537.36","66","67","","2019-10-21 23:05:09","completed","",NULL),
("311","0","64.233.173.171","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","68","69","","2019-10-21 23:05:15","completed","",NULL),
("312","0","64.233.173.171","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","66","67","","2019-10-21 23:05:19","completed","",NULL),
("313","0","49.228.177.145","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/D99A42","66","67","","2019-10-21 23:05:26","completed","",NULL),
("314","0","66.249.93.43","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","93","94","","2019-10-21 23:08:54","completed","",NULL),
("315","0","66.249.93.47","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","93","94","","2019-10-21 23:08:56","completed","",NULL),
("316","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:09:16","completed","",NULL),
("317","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:09:28","completed","",NULL),
("318","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 23:10:57","completed","",NULL),
("319","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:11:16","completed","",NULL),
("320","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:11:18","completed","",NULL),
("321","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-21 23:12:12","completed","",NULL),
("322","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:12:31","completed","",NULL),
("323","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:12:41","completed","",NULL),
("324","4","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:12:51","completed","",NULL),
("325","0","185.224.179.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:31:53","completed","",NULL),
("326","0","89.41.11.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-21 23:48:03","completed","",NULL),
("327","0","84.47.240.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-21 23:48:44","completed","",NULL),
("328","0","5.233.163.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 00:09:01","completed","",NULL),
("329","0","93.117.19.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-22 00:11:21","completed","",NULL),
("330","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:14:01","completed","",NULL),
("331","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:14:03","completed","",NULL),
("332","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:14:05","completed","",NULL),
("333","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:14:08","completed","",NULL),
("334","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:14:09","completed","",NULL),
("335","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:15:22","completed","",NULL),
("336","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:15:24","completed","",NULL),
("337","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:15:26","completed","",NULL),
("338","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:15:29","completed","",NULL),
("339","0","151.233.227.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 00:15:30","completed","",NULL),
("340","0","89.41.11.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 00:26:14","completed","",NULL),
("341","0","193.176.86.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 02:08:57","completed","",NULL),
("342","0","5.127.51.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 02:30:08","completed","",NULL),
("343","0","5.127.51.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 02:32:59","completed","",NULL),
("344","0","5.127.51.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 02:33:03","completed","",NULL),
("345","0","5.127.51.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 02:33:09","completed","",NULL),
("346","0","5.121.64.182","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 03:44:56","completed","",NULL),
("347","0","5.122.193.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-22 04:29:25","completed","",NULL),
("348","0","5.122.193.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-22 04:29:30","completed","",NULL),
("349","0","192.15.138.73","Mozilla/5.0 (Linux; Android 8.0.0; MI 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-22 08:01:01","completed","",NULL),
("350","0","192.15.138.73","Mozilla/5.0 (Linux; Android 8.0.0; MI 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","93","94","","2019-10-22 08:01:11","completed","",NULL),
("351","0","192.15.138.73","Mozilla/5.0 (Linux; Android 8.0.0; MI 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","93","94","","2019-10-22 08:01:23","completed","",NULL),
("352","0","93.117.181.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-22 08:13:16","completed","",NULL),
("353","0","93.117.181.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","99","100","","2019-10-22 08:14:45","completed","",NULL),
("354","0","93.117.181.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-22 08:15:13","completed","",NULL),
("355","0","185.23.128.144","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-22 08:50:00","completed","",NULL),
("356","0","78.110.115.200","Mozilla/5.0 (Windows NT 6.1; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-22 09:13:59","completed","",NULL),
("357","0","78.110.115.200","Mozilla/5.0 (Windows NT 6.1; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-22 09:14:36","completed","",NULL),
("358","0","93.117.185.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 09:46:48","completed","",NULL),
("359","0","93.117.185.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 09:46:55","completed","",NULL),
("360","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 10:46:06","completed","",NULL),
("361","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 10:46:16","completed","",NULL),
("362","0","185.132.132.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-22 10:54:27","completed","",NULL),
("363","0","185.132.132.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-22 10:55:05","completed","",NULL),
("364","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 10:59:13","completed","",NULL),
("365","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 11:00:18","completed","",NULL),
("366","0","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 11:00:57","completed","",NULL),
("367","0","104.237.225.36","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-22 11:10:16","completed","",NULL),
("368","0","80.210.25.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 11:37:37","completed","",NULL),
("369","0","80.210.25.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 11:38:53","completed","",NULL),
("370","0","80.210.25.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-22 11:40:37","completed","",NULL),
("371","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 12:03:27","completed","",NULL),
("372","1","5.116.75.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 12:03:40","completed","",NULL),
("373","0","151.235.140.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 13:01:10","completed","",NULL),
("374","0","64.42.178.84","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 14:26:28","completed","",NULL),
("375","0","87.107.77.224","Mozilla/5.0 (Linux; Android 9; POCOPHONE F1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.136 Mobile Safari/537.36","66","67","","2019-10-22 18:36:36","completed","",NULL),
("376","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:40:33","completed","",NULL),
("377","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:40:39","completed","",NULL),
("378","0","66.249.93.45","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:40:44","completed","",NULL),
("379","0","66.249.93.45","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:40:50","completed","",NULL),
("380","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:40:55","completed","",NULL),
("381","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:41:02","completed","",NULL),
("382","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:41:14","completed","",NULL),
("383","0","66.249.93.45","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:41:16","completed","",NULL),
("384","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:55:28","completed","",NULL),
("385","0","66.249.93.45","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:55:33","completed","",NULL),
("386","0","66.249.93.45","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:55:40","completed","",NULL),
("387","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:55:43","completed","",NULL),
("388","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:55:51","completed","",NULL),
("389","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:56:10","completed","",NULL),
("390","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:56:11","completed","",NULL),
("391","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; LG-H870DS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-22 19:56:13","completed","",NULL),
("392","0","93.119.212.192","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 20:23:46","completed","",NULL),
("393","0","93.119.212.192","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-22 20:24:57","completed","",NULL),
("394","0","185.153.151.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 22:03:31","completed","",NULL),
("395","0","89.219.220.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 22:12:54","completed","",NULL),
("396","0","46.100.112.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","93","94","","2019-10-22 22:40:17","completed","",NULL),
("397","0","5.75.17.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-22 22:40:51","completed","",NULL),
("398","0","5.75.17.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 22:41:26","completed","",NULL),
("399","0","5.75.17.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-22 22:41:36","completed","",NULL),
("400","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","93","94","","2019-10-22 23:34:12","completed","",NULL),
("401","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","93","94","","2019-10-22 23:34:15","completed","",NULL),
("402","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","93","94","","2019-10-22 23:34:38","completed","",NULL),
("403","0","5.117.112.212","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-22 23:47:22","completed","",NULL),
("404","0","5.123.122.180","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-23 00:12:58","completed","",NULL),
("405","0","5.123.122.180","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-23 00:22:38","completed","",NULL),
("406","0","188.40.162.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-23 00:42:45","completed","",NULL),
("407","0","188.40.162.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-23 00:42:52","completed","",NULL),
("408","0","77.77.103.162","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-23 04:22:46","completed","",NULL),
("409","0","5.210.7.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","66","67","","2019-10-23 06:25:43","completed","",NULL),
("410","0","5.210.7.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","66","67","","2019-10-23 06:25:53","completed","",NULL),
("411","0","5.210.7.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","99","100","","2019-10-23 06:26:14","completed","",NULL),
("412","0","5.210.7.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","66","67","","2019-10-23 06:26:27","completed","",NULL),
("413","0","93.117.181.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","124","125","","2019-10-23 09:34:45","completed","",NULL),
("414","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-23 09:38:40","completed","",NULL),
("415","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-23 09:39:43","completed","",NULL),
("416","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-23 09:41:18","completed","",NULL),
("417","0","31.58.165.135","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-23 11:37:04","completed","",NULL),
("418","0","31.58.165.135","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-23 11:42:53","completed","",NULL),
("419","0","31.59.203.114","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2019-10-23 12:32:51","completed","",NULL),
("420","0","46.4.157.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-23 14:30:57","completed","",NULL),
("421","0","46.4.157.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-23 14:31:42","completed","",NULL),
("422","0","46.4.157.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-23 14:32:08","completed","",NULL),
("423","0","46.4.157.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-23 14:32:31","completed","",NULL),
("424","0","46.4.157.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","113","114","","2019-10-23 14:34:36","completed","",NULL),
("425","0","66.249.81.43","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36","93","94","","2019-10-23 15:58:59","completed","",NULL),
("426","0","66.249.81.45","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36","93","94","","2019-10-23 15:59:32","completed","",NULL),
("427","0","66.249.81.47","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36","93","94","","2019-10-23 15:59:34","completed","",NULL),
("428","0","78.39.78.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-23 18:16:33","completed","",NULL),
("429","0","78.39.78.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-23 18:16:46","completed","",NULL),
("430","0","78.39.78.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-23 18:17:45","completed","",NULL),
("431","0","78.39.78.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-10-23 18:18:05","completed","",NULL),
("432","0","37.27.196.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-23 18:24:46","completed","",NULL),
("433","0","37.27.196.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-23 18:25:44","completed","",NULL),
("434","0","37.27.196.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-23 18:25:51","completed","",NULL),
("435","0","89.187.177.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","93","94","","2019-10-23 18:56:27","completed","",NULL),
("436","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-23 19:24:36","completed","",NULL),
("437","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-23 19:24:40","completed","",NULL),
("438","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-23 19:25:01","completed","",NULL),
("439","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-23 19:25:18","completed","",NULL),
("440","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","124","125","","2019-10-23 19:26:27","completed","",NULL),
("441","0","151.240.40.124","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","124","125","","2019-10-23 19:26:28","completed","",NULL),
("442","0","46.245.76.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","66","67","","2019-10-23 23:29:27","completed","",NULL),
("443","0","46.245.76.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","93","94","","2019-10-23 23:29:56","completed","",NULL),
("444","0","5.122.176.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 01:14:51","completed","",NULL),
("445","0","46.245.22.148","Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 08:57:27","completed","",NULL),
("446","0","46.245.22.148","Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 08:59:48","completed","",NULL),
("447","0","46.245.22.148","Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 09:00:11","completed","",NULL),
("448","0","5.117.105.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","93","94","","2019-10-24 10:42:39","completed","",NULL),
("449","0","5.117.105.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","93","94","","2019-10-24 10:42:55","completed","",NULL),
("450","0","37.148.59.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 13:10:51","completed","",NULL),
("451","0","37.148.59.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 13:11:15","completed","",NULL),
("452","6","37.148.59.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 13:12:39","completed","",NULL),
("453","6","37.148.59.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-24 13:33:08","completed","",NULL),
("454","0","81.19.208.121","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 14:06:47","completed","",NULL),
("455","0","81.19.208.121","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-24 14:06:56","completed","",NULL),
("456","0","81.19.208.121","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-24 14:10:26","completed","",NULL),
("457","0","81.19.208.121","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-24 14:10:30","completed","",NULL),
("458","0","81.19.208.121","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-24 14:12:00","completed","",NULL),
("459","0","5.123.129.12","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-24 14:50:37","completed","",NULL),
("460","0","109.169.65.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-24 19:40:53","completed","",NULL),
("461","0","109.169.65.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-24 19:41:11","completed","",NULL),
("462","0","109.169.65.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-24 19:43:01","completed","",NULL),
("463","0","5.120.175.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-24 20:03:08","completed","",NULL),
("464","0","5.120.175.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-24 20:03:17","completed","",NULL),
("465","0","151.238.207.57","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-25 01:27:27","completed","",NULL),
("466","0","5.235.21.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-10-25 10:43:46","completed","",NULL),
("467","0","5.122.176.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-25 13:21:10","completed","",NULL),
("468","0","66.249.81.45","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","93","94","","2019-10-25 14:24:19","completed","",NULL),
("469","0","5.117.205.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-25 17:22:49","completed","",NULL),
("470","0","5.117.205.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","68","69","","2019-10-25 17:23:55","completed","",NULL),
("471","0","5.134.161.187","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-25 23:08:48","completed","",NULL),
("472","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 00:35:18","completed","",NULL),
("473","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 00:36:07","completed","",NULL),
("474","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 00:37:19","completed","",NULL),
("475","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 00:38:18","completed","",NULL),
("476","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 00:38:25","completed","",NULL),
("477","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-26 00:44:27","completed","",NULL),
("478","0","37.148.91.169","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-26 09:38:45","completed","",NULL),
("479","0","37.148.91.169","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 09:39:02","completed","",NULL),
("480","0","37.148.91.169","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 09:40:37","completed","",NULL),
("481","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 09:48:13","completed","",NULL),
("482","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 09:48:33","completed","",NULL),
("483","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 10:31:35","completed","",NULL),
("484","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 10:37:24","completed","",NULL),
("485","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 10:37:53","completed","",NULL),
("486","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 10:47:15","completed","",NULL),
("487","0","5.115.141.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 10:47:51","completed","",NULL),
("488","0","31.58.165.135","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-26 13:22:48","completed","",NULL),
("489","0","185.239.174.58","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","93","94","","2019-10-26 13:24:34","completed","",NULL),
("490","0","45.132.172.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 13:49:52","completed","",NULL),
("491","0","45.132.172.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 13:50:02","completed","",NULL),
("492","0","45.132.172.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 13:50:10","completed","",NULL),
("493","0","188.158.140.135","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 13:55:56","completed","",NULL),
("494","0","5.126.215.139","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:04:17","completed","",NULL),
("495","0","31.56.72.226","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G965F Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/9.4 Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-10-26 14:08:51","completed","",NULL),
("496","0","31.56.72.226","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G965F Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/9.4 Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-10-26 14:09:06","completed","",NULL),
("497","0","31.56.72.226","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G965F Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/9.4 Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-10-26 14:10:18","completed","",NULL),
("498","0","5.233.60.87","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:12:07","completed","",NULL),
("499","0","5.233.60.87","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:12:22","completed","",NULL),
("500","0","5.233.60.87","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:12:58","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("501","0","185.117.139.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 14:26:41","completed","",NULL),
("502","0","5.196.102.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:27:37","completed","",NULL),
("503","0","185.117.139.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 14:27:45","completed","",NULL),
("504","0","93.114.31.82","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:27:50","completed","",NULL),
("505","0","5.233.60.87","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:28:39","completed","",NULL),
("506","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-26 14:37:03","completed","",NULL),
("507","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 14:37:26","completed","",NULL),
("508","0","93.114.31.82","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:39:32","completed","",NULL),
("509","0","93.114.31.82","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:39:39","completed","",NULL),
("510","0","188.210.168.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:43:05","completed","",NULL),
("511","0","188.210.168.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:43:07","completed","",NULL),
("512","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-26 14:46:56","completed","",NULL),
("513","0","151.233.158.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:55:32","completed","",NULL),
("514","0","151.233.158.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:55:35","completed","",NULL),
("515","0","151.233.158.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:55:41","completed","",NULL),
("516","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:55:58","completed","",NULL),
("517","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:56:12","completed","",NULL),
("518","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:57:18","completed","",NULL),
("519","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:57:24","completed","",NULL),
("520","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:57:24","completed","",NULL),
("521","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 14:57:25","completed","",NULL),
("522","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:57:33","completed","",NULL),
("523","0","77.81.81.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 14:58:18","completed","",NULL),
("524","0","77.81.81.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-26 14:58:48","completed","",NULL),
("525","0","77.81.81.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 14:59:10","completed","",NULL),
("526","0","46.100.74.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 15:03:40","completed","",NULL),
("527","0","46.100.74.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 15:03:59","completed","",NULL),
("528","0","178.62.241.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36 Edg/78.0.276.20","66","67","","2019-10-26 15:04:15","completed","",NULL),
("529","0","178.62.241.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36 Edg/78.0.276.20","113","114","","2019-10-26 15:04:25","completed","",NULL),
("530","0","46.100.74.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 15:05:34","completed","",NULL),
("531","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:06:33","completed","",NULL),
("532","0","178.63.238.138","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:07:55","completed","",NULL),
("533","3","5.116.94.67","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-26 15:08:15","completed","",NULL),
("534","0","5.116.94.67","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-26 15:09:03","completed","",NULL),
("535","0","84.241.34.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:09:37","completed","",NULL),
("536","0","5.116.94.67","Mozilla/5.0 (Linux; Android 7.1.2; KIW-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-26 15:09:47","completed","",NULL),
("537","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:16:16","completed","",NULL),
("538","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:17:55","completed","",NULL),
("539","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:18:17","completed","",NULL),
("540","0","31.130.179.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 15:19:12","completed","",NULL),
("541","0","46.225.187.99","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 15:21:12","completed","",NULL),
("542","0","46.225.187.99","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 15:21:19","completed","",NULL),
("543","0","5.116.214.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:21:29","completed","",NULL),
("544","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:22:35","completed","",NULL),
("545","0","46.225.187.99","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-26 15:22:43","completed","",NULL),
("546","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:22:54","completed","",NULL),
("547","0","5.116.214.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:23:00","completed","",NULL),
("548","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 15:27:19","completed","",NULL),
("549","0","94.241.142.18","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:29:55","completed","",NULL),
("550","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 15:31:25","completed","",NULL),
("551","0","198.147.24.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 15:31:30","completed","",NULL),
("552","0","91.109.30.121","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:33:12","completed","",NULL),
("553","0","91.109.30.121","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:34:02","completed","",NULL),
("554","0","94.241.142.18","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:41:07","completed","",NULL),
("555","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-G955F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 15:50:07","completed","",NULL),
("556","0","66.249.81.45","Mozilla/5.0 (Linux; Android 9; SM-G955F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 15:50:12","completed","",NULL),
("557","0","66.249.81.45","Mozilla/5.0 (Linux; Android 9; SM-G955F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 15:50:19","completed","",NULL),
("558","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-G955F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 15:50:26","completed","",NULL),
("559","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-26 15:50:40","completed","",NULL),
("560","0","66.249.81.47","Mozilla/5.0 (Linux; Android 9; SM-G955F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 15:50:41","completed","",NULL),
("561","0","95.159.88.125","Mozilla/5.0 (Linux; U; Android 9; en-us; MI 9 Build/PKQ1.181121.001) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.1.7-g","93","94","","2019-10-26 15:52:09","completed","",NULL),
("562","0","178.252.135.137","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:58:35","completed","",NULL),
("563","0","85.133.163.119","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:58:42","completed","",NULL),
("564","0","5.116.214.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:59:21","completed","",NULL),
("565","0","5.116.214.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:59:35","completed","",NULL),
("566","0","5.116.214.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 15:59:35","completed","",NULL),
("567","0","204.18.50.100","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-26 16:01:25","completed","",NULL),
("568","0","204.18.50.100","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-26 16:01:31","completed","",NULL),
("569","0","204.18.50.100","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-26 16:01:42","completed","",NULL),
("570","0","31.7.125.24","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-10-26 16:07:50","completed","",NULL),
("571","0","5.119.138.143","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-26 16:08:22","completed","",NULL),
("572","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","113","114","","2019-10-26 16:10:30","completed","",NULL),
("573","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","113","114","","2019-10-26 16:10:34","completed","",NULL),
("574","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","113","114","","2019-10-26 16:10:39","completed","",NULL),
("575","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","113","114","","2019-10-26 16:10:41","completed","",NULL),
("576","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","113","114","","2019-10-26 16:10:46","completed","",NULL),
("577","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","66","67","","2019-10-26 16:27:38","completed","",NULL),
("578","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","66","67","","2019-10-26 16:28:42","completed","",NULL),
("579","0","46.224.53.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 16:33:23","completed","",NULL),
("580","5","87.107.139.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0","93","94","","2019-10-26 16:35:02","completed","",NULL),
("581","0","83.120.98.210","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-26 16:38:05","completed","",NULL),
("582","0","83.120.98.210","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","93","94","","2019-10-26 16:38:07","completed","",NULL),
("583","0","83.120.98.210","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-26 16:38:27","completed","",NULL),
("584","0","83.120.98.210","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","113","114","","2019-10-26 16:38:44","completed","",NULL),
("585","0","46.4.192.224","Mozilla/5.0 (Linux; Android 9; SM-N950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 16:44:32","completed","",NULL),
("586","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 16:44:52","completed","",NULL),
("587","0","46.4.192.224","Mozilla/5.0 (Linux; Android 9; SM-N950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 16:46:12","completed","",NULL),
("588","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 16:48:14","completed","",NULL),
("589","7","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 16:49:19","completed","",NULL),
("590","0","94.139.161.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-26 16:49:30","completed","",NULL),
("591","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 16:51:02","completed","",NULL),
("592","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-26 16:51:22","completed","",NULL),
("593","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-26 16:56:55","completed","",NULL),
("594","0","2.180.68.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:00:02","completed","",NULL),
("595","0","2.180.68.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-10-26 17:01:16","completed","",NULL),
("596","0","2.180.68.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-10-26 17:01:20","completed","",NULL),
("597","0","2.180.68.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-10-26 17:01:21","completed","",NULL),
("598","0","2.180.68.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-10-26 17:01:25","completed","",NULL),
("599","0","77.42.27.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:02:18","completed","",NULL),
("600","0","77.42.27.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:03:32","completed","",NULL),
("601","0","46.224.243.198","Mozilla/5.0 (Linux; Android 9; SM-J701F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","93","94","","2019-10-26 17:04:14","completed","",NULL),
("602","0","46.224.243.198","Mozilla/5.0 (Linux; Android 9; SM-J701F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","99","100","","2019-10-26 17:04:36","completed","",NULL),
("603","0","46.224.243.198","Mozilla/5.0 (Linux; Android 9; SM-J701F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","93","94","","2019-10-26 17:04:49","completed","",NULL),
("604","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-26 17:05:33","completed","",NULL),
("605","0","46.224.243.198","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Safari/537.36","66","67","","2019-10-26 17:05:34","completed","",NULL),
("606","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-26 17:05:43","completed","",NULL),
("607","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:05:53","completed","",NULL),
("608","0","31.2.192.29","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:07:10","completed","",NULL),
("609","0","46.224.243.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:10:58","completed","",NULL),
("610","0","46.224.243.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:11:27","completed","",NULL),
("611","0","46.224.243.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-26 17:11:55","completed","",NULL),
("612","0","95.82.60.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 17:11:55","completed","",NULL),
("613","0","2.185.246.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-26 17:11:57","redirected","تغییر مسیر به فایل راه دور.",NULL),
("614","0","46.224.243.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:14:09","completed","",NULL),
("615","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-10-26 17:15:31","completed","",NULL),
("616","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-26 17:15:33","completed","",NULL),
("617","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-26 17:39:00","completed","",NULL),
("618","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:39:23","completed","",NULL),
("619","0","178.131.77.169","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:40:58","completed","",NULL),
("620","0","46.143.77.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 17:46:05","completed","",NULL),
("621","0","83.123.250.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-26 17:52:39","completed","",NULL),
("622","0","93.114.24.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:52:55","completed","",NULL),
("623","0","93.114.24.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-26 17:53:28","completed","",NULL),
("624","0","37.27.75.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 17:58:16","completed","",NULL),
("625","0","37.27.75.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:59:15","completed","",NULL),
("626","0","37.27.75.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:59:19","completed","",NULL),
("627","0","37.27.75.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 17:59:22","completed","",NULL),
("628","0","31.2.172.42","Mozilla/5.0 (Linux; Android 9; SM-N960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 18:02:34","completed","",NULL),
("629","0","31.2.172.42","Mozilla/5.0 (Linux; Android 9; SM-N960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-26 18:02:35","completed","",NULL),
("630","0","5.126.115.190","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 18:06:32","completed","",NULL),
("631","0","5.235.224.129","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 18:38:50","completed","",NULL),
("632","0","5.235.224.129","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 18:38:58","completed","",NULL),
("633","0","51.38.89.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 18:49:05","completed","",NULL),
("634","0","5.126.215.139","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","124","125","","2019-10-26 18:50:24","completed","",NULL),
("635","0","51.38.89.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 18:50:56","completed","",NULL),
("636","0","51.38.89.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 18:51:31","completed","",NULL),
("637","0","94.184.116.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 18:54:45","completed","",NULL),
("638","0","94.184.116.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 18:55:18","completed","",NULL),
("639","0","46.62.246.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 19:21:05","completed","",NULL),
("640","0","46.62.246.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-26 19:21:54","completed","",NULL),
("641","0","46.62.246.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 19:22:33","completed","",NULL),
("642","0","46.62.246.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 19:22:40","completed","",NULL),
("643","0","46.62.246.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 19:22:47","completed","",NULL),
("644","0","5.124.56.39","Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko","93","94","","2019-10-26 19:23:24","completed","",NULL),
("645","0","5.124.56.39","Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko","93","94","","2019-10-26 19:23:25","completed","",NULL),
("646","0","46.224.243.198","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Safari/537.36","66","67","","2019-10-26 19:49:35","completed","",NULL),
("647","0","31.57.48.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 19:54:17","completed","",NULL),
("648","0","5.122.197.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 20:22:08","completed","",NULL),
("649","0","93.114.24.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 20:24:18","completed","",NULL),
("650","0","93.114.24.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-26 20:26:39","completed","",NULL),
("651","0","78.39.232.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 20:37:17","completed","",NULL),
("652","0","78.39.232.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-26 20:42:17","completed","",NULL),
("653","0","5.117.186.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 20:43:26","completed","",NULL),
("654","0","5.123.69.182","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 20:56:07","completed","",NULL),
("655","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-26 21:01:41","completed","",NULL),
("656","0","184.154.0.5","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-26 21:03:30","completed","",NULL),
("657","0","184.154.0.5","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","101","102","","2019-10-26 21:03:42","completed","",NULL),
("658","0","5.117.224.9","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/77.0.3865.69 Mobile/15E148 Safari/605.1","66","67","","2019-10-26 21:32:43","completed","",NULL),
("659","0","66.249.88.47","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","124","125","","2019-10-26 22:09:13","completed","",NULL),
("660","0","66.249.88.43","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-26 22:09:20","completed","",NULL),
("661","0","66.249.88.43","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-26 22:09:21","completed","",NULL),
("662","0","5.122.9.246","Mozilla/5.0 (Linux; Android 6.0.1; SM-A9100) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.111 Mobile Safari/537.36","66","67","","2019-10-26 22:13:46","completed","",NULL),
("663","0","5.122.9.246","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.111 Safari/537.36","66","67","","2019-10-26 22:13:56","completed","",NULL),
("664","0","185.180.15.240","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 22:33:57","completed","",NULL),
("665","0","198.16.74.204","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-26 23:12:14","completed","",NULL),
("666","0","198.16.74.204","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-26 23:16:06","completed","",NULL),
("667","0","198.16.74.204","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-26 23:17:11","completed","",NULL),
("668","0","198.16.74.204","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-26 23:17:33","completed","",NULL),
("669","0","46.225.52.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 23:41:05","completed","",NULL),
("670","0","5.115.53.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 23:56:58","completed","",NULL),
("671","0","5.115.53.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 23:57:04","completed","",NULL),
("672","0","5.115.53.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-26 23:58:17","completed","",NULL),
("673","0","5.115.53.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-26 23:58:38","completed","",NULL),
("674","0","5.117.33.187","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-26 23:59:05","completed","",NULL),
("675","0","5.117.33.187","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 00:00:15","completed","",NULL),
("676","0","145.239.101.136","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-10-27 00:00:27","completed","",NULL),
("677","0","89.187.177.68","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 00:02:57","completed","",NULL),
("678","8","5.117.33.187","Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Mobile Safari/537.36","124","125","","2019-10-27 00:05:55","completed","",NULL),
("679","0","5.121.92.125","Mozilla/5.0 (Linux; Android 7.0; SM-A310F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-10-27 00:29:06","completed","",NULL),
("680","0","5.134.156.137","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 00:54:08","completed","",NULL),
("681","9","5.126.216.124","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 00:54:24","completed","",NULL),
("682","9","5.126.216.124","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 00:54:25","completed","",NULL),
("683","9","5.126.216.124","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 00:55:04","completed","",NULL),
("684","9","5.126.216.124","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 00:55:06","completed","",NULL),
("685","9","5.126.216.124","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 00:55:23","completed","",NULL),
("686","0","204.18.244.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 01:01:22","completed","",NULL),
("687","0","204.18.244.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 01:13:13","completed","",NULL),
("688","0","82.102.8.172","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 01:49:47","completed","",NULL),
("689","0","82.102.8.172","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 01:51:15","completed","",NULL),
("690","0","82.102.8.172","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","64","65","","2019-10-27 01:51:34","completed","",NULL),
("691","0","82.102.8.172","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 01:51:41","completed","",NULL),
("692","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; BLA-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-27 01:53:17","completed","",NULL),
("693","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; BLA-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-27 01:53:21","completed","",NULL),
("694","0","66.249.81.45","Mozilla/5.0 (Linux; Android 9; BLA-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-27 01:53:28","completed","",NULL),
("695","0","66.249.81.47","Mozilla/5.0 (Linux; Android 9; BLA-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-27 01:53:30","completed","",NULL),
("696","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; BLA-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-27 01:53:33","completed","",NULL),
("697","0","91.184.76.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 02:40:40","completed","",NULL),
("698","0","91.184.76.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 02:40:43","completed","",NULL),
("699","0","5.119.55.242","Mozilla/5.0 (Linux; Android 9; SM-A750GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","124","125","","2019-10-27 03:03:47","completed","",NULL),
("700","0","91.184.76.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 03:08:53","completed","",NULL),
("701","0","204.18.244.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 03:18:23","completed","",NULL),
("702","0","204.18.244.160","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 03:56:09","completed","",NULL),
("703","0","204.18.244.160","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 03:56:10","completed","",NULL),
("704","0","204.18.244.160","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-27 03:58:48","completed","",NULL),
("705","0","204.18.244.160","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-27 03:58:56","completed","",NULL),
("706","0","204.18.244.160","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-27 03:59:07","completed","",NULL),
("707","0","5.115.147.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 04:00:49","completed","",NULL),
("708","0","5.115.147.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 04:02:19","completed","",NULL),
("709","0","5.115.147.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 04:02:52","completed","",NULL),
("710","0","5.115.147.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 04:02:56","completed","",NULL),
("711","0","5.115.147.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 04:03:00","completed","",NULL),
("712","0","5.239.60.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 04:09:46","completed","",NULL),
("713","0","66.249.93.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 05:55:27","completed","",NULL),
("714","0","66.249.93.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 05:55:34","completed","",NULL),
("715","0","37.156.48.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 06:00:13","completed","",NULL),
("716","0","37.156.48.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 06:00:24","completed","",NULL),
("717","0","5.120.116.90","Mozilla/5.0 (Linux; Android 9; SM-A750GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","124","125","","2019-10-27 06:00:44","completed","",NULL),
("718","10","109.72.206.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 06:31:03","completed","",NULL),
("719","10","109.72.206.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 06:31:06","completed","",NULL),
("720","10","109.72.206.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 06:35:19","completed","",NULL),
("721","0","66.249.81.47","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:02:24","completed","",NULL),
("722","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:02:31","completed","",NULL),
("723","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:02:39","completed","",NULL),
("724","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:03:00","completed","",NULL),
("725","0","66.249.81.47","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:03:01","completed","",NULL),
("726","0","66.249.81.47","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:03:01","completed","",NULL),
("727","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:03:13","completed","",NULL),
("728","0","66.249.81.43","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","66","67","","2019-10-27 07:03:13","completed","",NULL),
("729","0","188.215.169.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 08:17:46","completed","",NULL),
("730","0","188.215.169.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 08:17:59","completed","",NULL),
("731","0","188.215.169.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-10-27 08:19:00","completed","",NULL),
("732","0","188.215.169.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-10-27 08:19:07","completed","",NULL),
("733","0","188.215.169.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-10-27 08:19:20","completed","",NULL),
("734","0","88.198.118.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 08:46:47","completed","",NULL),
("735","0","88.198.118.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 08:47:21","completed","",NULL),
("736","0","185.220.70.51","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 09:05:00","completed","",NULL),
("737","0","185.220.70.51","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 09:05:18","completed","",NULL),
("738","0","83.120.233.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 09:55:20","completed","",NULL),
("739","0","83.120.233.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 09:55:49","completed","",NULL),
("740","0","83.120.233.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 09:57:25","completed","",NULL),
("741","0","2.176.150.23","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 10:02:38","completed","",NULL),
("742","0","2.176.150.23","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 10:02:47","completed","",NULL),
("743","0","2.176.150.23","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 10:02:49","completed","",NULL),
("744","0","2.176.150.23","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 10:03:08","completed","",NULL),
("745","0","5.120.118.43","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 10:04:57","completed","",NULL),
("746","0","5.120.118.43","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 10:05:17","completed","",NULL),
("747","0","86.57.31.22","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 10:11:14","completed","",NULL),
("748","0","86.57.31.22","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 10:11:20","completed","",NULL),
("749","0","2.179.150.130","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 10:16:18","completed","",NULL),
("750","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:24:19","completed","",NULL),
("751","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:24:36","completed","",NULL),
("752","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:24:41","completed","",NULL),
("753","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:24:44","completed","",NULL),
("754","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:24:49","completed","",NULL),
("755","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:00","completed","",NULL),
("756","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:10","completed","",NULL),
("757","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:15","completed","",NULL),
("758","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:21","completed","",NULL),
("759","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:21","completed","",NULL),
("760","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:24","completed","",NULL),
("761","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:27","completed","",NULL),
("762","0","151.242.163.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","113","114","","2019-10-27 10:25:33","completed","",NULL),
("763","0","128.199.60.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 10:54:36","completed","",NULL),
("764","0","128.199.60.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 10:57:47","completed","",NULL),
("765","0","128.199.60.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 10:57:58","completed","",NULL),
("766","0","185.145.9.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-27 11:01:31","completed","",NULL),
("767","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:04:32","completed","",NULL),
("768","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:04:43","completed","",NULL),
("769","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:04:51","completed","",NULL),
("770","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:05:07","completed","",NULL),
("771","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:05:08","completed","",NULL),
("772","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:05:26","completed","",NULL),
("773","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:05:31","completed","",NULL),
("774","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:06:02","completed","",NULL),
("775","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:06:08","completed","",NULL),
("776","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:06:14","completed","",NULL),
("777","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:06:36","completed","",NULL),
("778","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:06:38","completed","",NULL),
("779","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:06:50","completed","",NULL),
("780","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:07:04","completed","",NULL),
("781","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:07:12","completed","",NULL),
("782","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:07:42","completed","",NULL),
("783","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:08:11","completed","",NULL),
("784","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:08:20","completed","",NULL),
("785","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:08:27","completed","",NULL),
("786","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:08:50","completed","",NULL),
("787","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:08:52","completed","",NULL),
("788","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:09:12","completed","",NULL),
("789","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:09:26","completed","",NULL),
("790","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:10:21","completed","",NULL),
("791","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:11:04","redirected","تغییر مسیر به فایل راه دور.",NULL),
("792","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:11:05","redirected","تغییر مسیر به فایل راه دور.",NULL),
("793","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:11:06","redirected","تغییر مسیر به فایل راه دور.",NULL),
("794","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:11:09","completed","",NULL),
("795","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:11:16","completed","",NULL),
("796","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:11:27","completed","",NULL),
("797","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:11:39","completed","",NULL),
("798","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:12:01","completed","",NULL),
("799","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:12:13","completed","",NULL),
("800","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:12:16","completed","",NULL),
("801","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:19:37","completed","",NULL),
("802","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:20:01","completed","",NULL),
("803","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:20:16","completed","",NULL),
("804","0","94.241.142.18","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 11:20:25","completed","",NULL),
("805","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:21:01","completed","",NULL),
("806","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:21:33","completed","",NULL),
("807","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:22:07","completed","",NULL),
("808","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:22:51","completed","",NULL),
("809","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:22:51","redirected","تغییر مسیر به فایل راه دور.",NULL),
("810","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:22:52","redirected","تغییر مسیر به فایل راه دور.",NULL),
("811","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:23:40","completed","",NULL),
("812","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:23:45","completed","",NULL),
("813","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:24:31","completed","",NULL),
("814","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:24:33","completed","",NULL),
("815","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:25:18","completed","",NULL),
("816","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-27 11:25:51","completed","",NULL),
("817","0","37.254.242.34","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","66","67","","2019-10-27 11:26:17","completed","",NULL),
("818","0","89.165.17.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-27 11:27:39","completed","",NULL),
("819","0","164.215.229.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 11:42:18","completed","",NULL),
("820","0","95.82.7.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 11:42:32","completed","",NULL),
("821","0","178.63.131.74","Mozilla/5.0 (Linux; Android 8.0.0; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.101 Mobile Safari/537.36","66","67","","2019-10-27 11:45:04","completed","",NULL),
("822","0","89.165.17.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 11:53:26","completed","",NULL),
("823","0","89.165.17.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 11:53:31","completed","",NULL),
("824","0","89.165.17.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 11:55:26","completed","",NULL),
("825","0","37.255.92.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-27 12:02:10","completed","",NULL),
("826","0","37.255.92.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-27 12:02:31","completed","",NULL),
("827","0","5.122.55.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 12:10:59","completed","",NULL),
("828","0","5.122.55.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-10-27 12:12:10","completed","",NULL),
("829","0","5.122.55.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-10-27 12:12:17","completed","",NULL),
("830","0","80.84.49.83","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 12:15:58","completed","",NULL),
("831","0","5.126.217.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 12:17:03","completed","",NULL),
("832","0","5.126.217.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 12:18:33","completed","",NULL),
("833","0","217.146.82.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-10-27 12:35:10","completed","",NULL),
("834","0","77.42.27.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 12:36:52","completed","",NULL),
("835","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 13:00:08","completed","",NULL),
("836","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 13:01:17","completed","",NULL),
("837","0","5.115.139.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 13:12:30","completed","",NULL),
("838","0","5.115.139.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 13:12:35","completed","",NULL),
("839","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:20:29","completed","",NULL),
("840","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:26:26","completed","",NULL),
("841","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:27:44","completed","",NULL),
("842","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:27:54","completed","",NULL),
("843","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:28:09","completed","",NULL),
("844","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:28:09","completed","",NULL),
("845","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:28:10","completed","",NULL),
("846","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:28:18","completed","",NULL),
("847","0","204.18.3.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:28:18","completed","",NULL),
("848","0","5.126.217.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 13:34:50","completed","",NULL),
("849","0","37.254.6.238","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:52:14","completed","",NULL),
("850","0","37.254.6.238","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 13:52:29","completed","",NULL),
("851","0","5.117.193.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 13:56:21","completed","",NULL),
("852","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 14:06:52","completed","",NULL),
("853","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 14:22:11","completed","",NULL),
("854","0","50.7.142.180","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 14:22:26","completed","",NULL),
("855","0","89.47.199.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 14:57:50","completed","",NULL),
("856","0","89.47.199.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-10-27 14:58:25","completed","",NULL),
("857","0","89.47.199.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-10-27 15:00:51","completed","",NULL),
("858","0","89.47.199.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-10-27 15:00:54","completed","",NULL),
("859","0","89.41.240.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 15:12:44","completed","",NULL),
("860","0","104.222.32.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 15:16:06","completed","",NULL),
("861","0","104.222.32.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 15:16:29","completed","",NULL),
("862","0","5.126.128.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 15:20:30","completed","",NULL),
("863","0","2.191.78.153","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 15:34:34","completed","",NULL),
("864","0","5.114.67.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 16:00:46","completed","",NULL),
("865","0","5.114.67.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 16:00:58","completed","",NULL),
("866","0","151.233.174.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36 OPR/63.0.3368.107","66","67","","2019-10-27 16:01:13","completed","",NULL),
("867","0","5.115.139.255","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-27 16:28:43","completed","",NULL),
("868","0","5.115.139.255","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","99","100","","2019-10-27 16:29:13","completed","",NULL),
("869","0","5.115.139.255","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-27 16:29:14","completed","",NULL),
("870","0","5.115.139.255","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-10-27 16:29:56","completed","",NULL),
("871","0","5.236.137.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 16:31:12","completed","",NULL),
("872","0","5.236.137.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 16:31:43","completed","",NULL),
("873","0","5.236.137.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 16:31:47","completed","",NULL),
("874","0","5.236.137.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 16:31:49","completed","",NULL),
("875","0","5.236.137.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 16:31:52","completed","",NULL),
("876","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 16:55:23","completed","",NULL),
("877","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 16:55:47","completed","",NULL),
("878","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 16:55:54","completed","",NULL),
("879","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 16:56:00","completed","",NULL),
("880","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 16:56:02","completed","",NULL),
("881","0","185.134.23.141","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 16:56:45","completed","",NULL),
("882","0","5.119.249.180","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 17:18:44","completed","",NULL),
("883","0","46.225.217.255","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 17:22:08","completed","",NULL),
("884","0","188.211.34.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 17:26:03","completed","",NULL),
("885","0","188.211.34.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 17:26:23","completed","",NULL),
("886","0","188.211.34.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 17:26:32","completed","",NULL),
("887","0","188.211.34.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 17:26:36","completed","",NULL),
("888","0","31.14.93.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 17:28:54","completed","",NULL),
("889","0","31.14.93.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 17:30:12","completed","",NULL),
("890","0","66.249.83.11","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-27 17:41:43","completed","",NULL),
("891","0","66.249.83.15","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-27 17:41:47","completed","",NULL),
("892","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-27 17:41:58","completed","",NULL),
("893","0","66.249.83.11","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-27 17:42:05","completed","",NULL),
("894","0","66.249.83.15","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-27 17:42:08","completed","",NULL),
("895","0","66.249.93.47","Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-27 17:42:16","completed","",NULL),
("896","0","66.249.83.11","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-27 17:42:21","completed","",NULL),
("897","0","66.249.93.43","Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-27 17:42:31","completed","",NULL),
("898","0","66.249.83.13","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-27 17:42:32","completed","",NULL),
("899","0","5.239.49.90","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 17:48:22","completed","",NULL),
("900","0","5.239.49.90","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 17:48:22","completed","",NULL),
("901","0","31.57.48.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:05:47","completed","",NULL),
("902","0","46.225.192.58","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 18:05:49","completed","",NULL),
("903","0","31.57.48.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:06:43","completed","",NULL),
("904","0","31.57.48.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:10:47","completed","",NULL),
("905","0","31.57.48.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-10-27 18:10:56","completed","",NULL),
("906","0","31.57.48.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 18:10:59","completed","",NULL),
("907","0","85.239.214.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 18:14:39","completed","",NULL),
("908","0","85.239.214.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 18:15:13","completed","",NULL),
("909","0","85.239.214.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 18:15:47","completed","",NULL),
("910","0","85.239.214.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-27 18:23:06","completed","",NULL),
("911","0","199.182.204.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:25:55","completed","",NULL),
("912","0","199.182.204.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:26:10","completed","",NULL),
("913","0","85.239.214.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 18:29:12","completed","",NULL),
("914","0","5.122.16.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 18:37:42","completed","",NULL),
("915","0","46.224.166.252","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 18:52:35","completed","",NULL),
("916","0","188.215.207.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-10-27 18:58:10","completed","",NULL),
("917","0","46.224.166.252","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 18:58:10","completed","",NULL),
("918","0","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 18:59:06","completed","",NULL),
("919","0","5.125.4.80","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 18:59:08","completed","",NULL),
("920","0","5.125.4.80","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 18:59:30","completed","",NULL),
("921","0","5.125.4.80","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","101","102","","2019-10-27 18:59:32","completed","",NULL),
("922","0","178.236.97.55","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 19:02:43","completed","",NULL),
("923","0","148.251.55.70","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 19:33:35","completed","",NULL),
("924","0","151.240.234.48","Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36","93","94","","2019-10-27 19:34:17","completed","",NULL),
("925","0","192.119.14.236","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 19:38:15","completed","",NULL),
("926","0","5.208.150.231","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 20:00:24","completed","",NULL),
("927","0","82.145.55.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-27 20:21:14","completed","",NULL),
("928","0","31.58.242.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 20:26:58","completed","",NULL),
("929","0","31.58.242.160","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-M305F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-10-27 20:31:17","completed","",NULL),
("930","0","31.58.242.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 20:32:59","completed","",NULL),
("931","0","31.58.242.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 20:33:15","completed","",NULL),
("932","0","31.58.242.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 20:33:27","completed","",NULL),
("933","0","5.208.150.231","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 20:34:45","completed","",NULL),
("934","0","5.208.150.231","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 20:35:31","completed","",NULL),
("935","0","188.159.131.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-27 20:50:29","completed","",NULL),
("936","0","188.159.131.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-27 20:50:48","completed","",NULL),
("937","0","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 20:54:46","completed","",NULL),
("938","0","192.119.14.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 20:55:04","completed","",NULL),
("939","0","86.57.10.92","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 20:59:01","completed","",NULL),
("940","11","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 21:04:38","completed","",NULL),
("941","11","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-27 21:04:58","completed","",NULL),
("942","11","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-27 21:05:05","completed","",NULL),
("943","0","5.200.135.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 21:11:27","completed","",NULL),
("944","0","5.200.135.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 21:14:22","completed","",NULL),
("945","0","5.200.135.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 21:14:29","completed","",NULL),
("946","0","188.210.172.207","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 21:16:41","completed","",NULL),
("947","0","188.210.172.207","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 21:16:50","completed","",NULL),
("948","11","185.180.15.230","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-27 21:26:14","completed","",NULL),
("949","0","5.117.248.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 21:27:23","completed","",NULL),
("950","0","5.134.165.199","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 21:57:36","completed","",NULL),
("951","0","108.61.188.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 22:00:46","completed","",NULL),
("952","0","89.34.51.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 22:07:34","completed","",NULL),
("953","0","89.34.51.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-27 22:07:48","completed","",NULL),
("954","0","89.34.51.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 22:07:57","completed","",NULL),
("955","0","89.34.51.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-27 22:08:02","completed","",NULL),
("956","0","89.34.51.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-27 22:08:32","completed","",NULL),
("957","0","5.212.95.16","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-27 22:13:18","completed","",NULL),
("958","0","46.225.47.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 22:22:34","completed","",NULL),
("959","0","104.222.32.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 22:33:05","completed","",NULL),
("960","12","104.222.32.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 22:35:05","completed","",NULL),
("961","0","151.240.134.186","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 22:44:53","completed","",NULL),
("962","0","151.240.134.186","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 22:45:17","completed","",NULL),
("963","13","151.240.134.186","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 22:47:16","completed","",NULL),
("964","13","151.240.134.186","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 22:47:18","completed","",NULL),
("965","0","217.172.124.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 22:48:31","completed","",NULL),
("966","0","77.81.80.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 22:54:53","completed","",NULL),
("967","0","188.210.183.225","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 22:56:01","completed","",NULL),
("968","0","77.81.80.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 22:56:55","completed","",NULL),
("969","0","77.81.80.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 22:59:43","completed","",NULL),
("970","0","2.187.220.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-27 23:05:39","completed","",NULL),
("971","0","185.103.85.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-27 23:16:09","completed","",NULL),
("972","0","185.103.85.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 23:16:34","completed","",NULL),
("973","0","86.104.244.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 23:16:39","completed","",NULL),
("974","0","185.103.85.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 23:16:39","completed","",NULL),
("975","0","192.119.14.236","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:16:47","completed","",NULL),
("976","0","185.103.85.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-27 23:17:39","completed","",NULL),
("977","0","185.103.85.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-27 23:23:00","completed","",NULL),
("978","0","5.126.35.150","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-27 23:34:44","completed","",NULL),
("979","0","86.107.15.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:38:58","completed","",NULL),
("980","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:47:25","completed","",NULL),
("981","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:47:33","completed","",NULL),
("982","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:47:36","completed","",NULL),
("983","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:48:27","completed","",NULL),
("984","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:48:53","completed","",NULL),
("985","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:49:14","completed","",NULL),
("986","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-27 23:49:19","completed","",NULL),
("987","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:50:04","completed","",NULL),
("988","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:50:06","completed","",NULL),
("989","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:50:08","completed","",NULL),
("990","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:50:09","completed","",NULL),
("991","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:51:38","completed","",NULL),
("992","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:51:42","completed","",NULL),
("993","0","89.39.107.201","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","113","114","","2019-10-27 23:51:59","completed","",NULL),
("994","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:52:04","completed","",NULL),
("995","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:52:18","completed","",NULL),
("996","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","93","94","","2019-10-27 23:52:23","completed","",NULL),
("997","0","2.182.207.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:52:33","completed","",NULL),
("998","0","5.120.204.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:53:02","completed","",NULL),
("999","0","5.120.204.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:53:02","completed","",NULL),
("1000","0","5.120.204.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 23:54:02","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("1001","0","5.210.43.3","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 23:54:31","completed","",NULL),
("1002","0","5.210.43.3","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-27 23:54:42","completed","",NULL),
("1003","0","2.182.207.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 23:55:07","completed","",NULL),
("1004","0","2.182.207.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 23:55:22","completed","",NULL),
("1005","0","151.238.194.58","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-27 23:56:13","completed","",NULL),
("1006","0","2.182.207.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-27 23:57:49","completed","",NULL),
("1007","0","188.159.98.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 00:14:01","completed","",NULL),
("1008","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-28 00:16:00","completed","",NULL),
("1009","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","113","114","","2019-10-28 00:16:05","completed","",NULL),
("1010","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 00:19:27","completed","",NULL),
("1011","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 00:19:33","completed","",NULL),
("1012","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 00:19:46","completed","",NULL),
("1013","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 00:19:52","completed","",NULL),
("1014","0","217.172.124.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 00:45:08","completed","",NULL),
("1015","0","217.172.124.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 00:45:43","completed","",NULL),
("1016","0","217.172.124.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 00:49:40","completed","",NULL),
("1017","0","217.172.124.102","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-28 00:51:22","completed","",NULL),
("1018","0","5.126.35.150","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 00:52:03","completed","",NULL),
("1019","0","5.126.35.150","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 00:57:10","completed","",NULL),
("1020","0","5.126.35.150","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 00:57:16","completed","",NULL),
("1021","0","5.114.234.175","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 01:00:31","completed","",NULL),
("1022","0","5.114.234.175","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 01:00:42","completed","",NULL),
("1023","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 01:21:07","completed","",NULL),
("1024","0","5.211.51.38","Mozilla/5.0 (Linux; Android 8.0.0; moto e5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","66","67","","2019-10-28 01:21:14","completed","",NULL),
("1025","0","5.219.153.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 03:05:52","completed","",NULL),
("1026","0","2.25.205.146","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.13; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-28 03:27:24","completed","",NULL),
("1027","0","2.25.205.146","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.13; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-28 03:27:47","completed","",NULL),
("1028","0","31.57.68.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 03:59:14","completed","",NULL),
("1029","0","31.57.68.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 03:59:21","completed","",NULL),
("1030","0","31.57.68.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","68","69","","2019-10-28 04:00:20","completed","",NULL),
("1031","0","54.36.194.237","Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-28 05:30:48","completed","",NULL),
("1032","0","54.36.194.237","Mozilla/5.0 (Linux; Android 8.0.0; SM-A520F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-28 05:32:06","completed","",NULL),
("1033","0","5.115.67.98","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 05:36:12","completed","",NULL),
("1034","0","5.115.67.98","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 05:36:19","completed","",NULL),
("1035","0","5.123.232.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-28 09:19:27","completed","",NULL),
("1036","0","5.123.232.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 09:20:05","completed","",NULL),
("1037","0","5.123.232.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 09:27:28","completed","",NULL),
("1038","0","46.225.116.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 09:37:08","completed","",NULL),
("1039","0","5.123.232.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 09:38:12","completed","",NULL),
("1040","0","5.123.232.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 09:38:14","completed","",NULL),
("1041","0","37.156.48.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-28 10:23:58","completed","",NULL),
("1042","0","37.156.48.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-28 10:24:26","completed","",NULL),
("1043","0","37.156.48.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 10:25:01","completed","",NULL),
("1044","0","5.217.231.122","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-28 10:25:40","completed","",NULL),
("1045","0","5.120.99.47","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-28 11:03:27","completed","",NULL),
("1046","0","5.160.182.193","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 11:34:42","completed","",NULL),
("1047","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 11:52:00","completed","",NULL),
("1048","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:27","completed","",NULL),
("1049","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:31","completed","",NULL),
("1050","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:33","completed","",NULL),
("1051","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:36","completed","",NULL),
("1052","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:40","completed","",NULL),
("1053","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:45","completed","",NULL),
("1054","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-28 11:52:49","completed","",NULL),
("1055","0","2.191.62.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-28 11:56:07","completed","",NULL),
("1056","0","2.190.88.112","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-10-28 12:24:38","completed","",NULL),
("1057","0","2.190.88.112","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 12:24:50","completed","",NULL),
("1058","0","2.190.88.112","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-28 12:25:10","completed","",NULL),
("1059","0","5.78.242.36","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 12:30:57","completed","",NULL),
("1060","0","5.78.242.36","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-28 12:31:31","completed","",NULL),
("1061","0","31.14.89.104","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-10-28 13:02:06","completed","",NULL),
("1062","0","217.146.82.159","Mozilla/5.0 (Linux; Android 4.3; C5303 Build/12.1.A.1.205) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.111 Mobile Safari/537.36","66","67","","2019-10-28 13:39:50","completed","",NULL),
("1063","0","217.69.4.18","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-28 14:46:57","completed","",NULL),
("1064","0","185.112.37.250","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 14:47:13","completed","",NULL),
("1065","0","217.69.4.18","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-10-28 14:47:18","completed","",NULL),
("1066","0","198.16.66.125","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 14:47:32","completed","",NULL),
("1067","0","185.112.37.250","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-28 14:47:38","completed","",NULL),
("1068","0","198.16.66.125","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 14:47:42","completed","",NULL),
("1069","0","95.80.142.63","Mozilla/5.0 (Linux; Android 9; Nexus 6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-10-28 16:00:14","completed","",NULL),
("1070","0","5.120.166.162","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 17:29:24","completed","",NULL),
("1071","0","93.119.81.104","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-28 17:37:54","completed","",NULL),
("1072","0","93.119.81.104","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-28 17:38:11","completed","",NULL),
("1073","0","46.4.169.34","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 20:58:08","completed","",NULL),
("1074","0","46.4.169.34","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-28 21:02:31","completed","",NULL),
("1075","0","89.41.11.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 00:59:08","completed","",NULL),
("1076","0","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 01:36:35","completed","",NULL),
("1077","0","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 01:36:59","completed","",NULL),
("1078","0","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-29 01:37:39","completed","",NULL),
("1079","0","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 01:47:45","completed","",NULL),
("1080","0","188.229.60.195","Mozilla/5.0 (Windows NT 6.3; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 02:14:55","completed","",NULL),
("1081","0","188.229.60.195","Mozilla/5.0 (Windows NT 6.3; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-29 02:15:18","completed","",NULL),
("1082","0","188.229.60.195","Mozilla/5.0 (Windows NT 6.3; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-29 02:15:40","completed","",NULL),
("1083","0","188.229.60.195","Mozilla/5.0 (Windows NT 6.3; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 02:16:49","completed","",NULL),
("1084","0","188.229.60.195","Mozilla/5.0 (Windows NT 6.3; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 02:17:51","completed","",NULL),
("1085","0","185.236.200.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-29 02:29:40","completed","",NULL),
("1086","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 03:19:30","completed","",NULL),
("1087","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-29 03:59:34","completed","",NULL),
("1088","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 03:59:45","completed","",NULL),
("1089","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 04:01:20","completed","",NULL),
("1090","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 04:01:38","completed","",NULL),
("1091","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-10-29 04:01:58","completed","",NULL),
("1092","14","5.218.45.53","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 04:02:16","completed","",NULL),
("1093","0","80.82.67.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-29 09:16:46","completed","",NULL),
("1094","0","80.82.67.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 09:18:18","completed","",NULL),
("1095","0","95.80.142.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 11:39:45","completed","",NULL),
("1096","0","95.80.142.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 11:40:07","completed","",NULL),
("1097","0","95.80.142.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-29 11:40:52","completed","",NULL),
("1098","0","95.80.142.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-29 11:41:00","completed","",NULL),
("1099","0","46.101.169.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 12:52:33","completed","",NULL),
("1100","0","2.191.78.153","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","99","100","","2019-10-29 12:55:18","completed","",NULL),
("1101","0","31.58.250.133","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-29 13:59:35","completed","",NULL),
("1102","0","89.47.135.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-29 13:59:49","completed","",NULL),
("1103","0","2.179.50.238","Mozilla/5.0 (Windows NT 6.2; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-10-29 14:28:17","completed","",NULL),
("1104","0","2.179.50.238","Mozilla/5.0 (Windows NT 6.2; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 14:29:29","completed","",NULL),
("1105","0","89.196.28.36","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 16:01:01","completed","",NULL),
("1106","0","5.122.157.1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 16:13:42","completed","",NULL),
("1107","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 16:21:32","completed","",NULL),
("1108","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-29 16:23:05","completed","",NULL),
("1109","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 16:23:49","completed","",NULL),
("1110","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 16:23:52","completed","",NULL),
("1111","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","101","102","","2019-10-29 16:24:26","completed","",NULL),
("1112","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 16:24:28","completed","",NULL),
("1113","0","31.56.79.6","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","101","102","","2019-10-29 16:24:30","completed","",NULL),
("1114","0","5.122.207.44","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 16:50:06","completed","",NULL),
("1115","0","5.122.207.44","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","97","98","","2019-10-29 16:50:15","completed","",NULL),
("1116","0","5.122.207.44","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 16:51:12","completed","",NULL),
("1117","16","31.56.74.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 18:33:16","completed","",NULL),
("1118","16","31.56.74.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-29 18:35:41","completed","",NULL),
("1119","16","31.56.74.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 18:37:04","completed","",NULL),
("1120","16","31.56.74.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 18:37:06","completed","",NULL),
("1121","16","31.56.74.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-29 18:45:49","completed","",NULL),
("1122","0","83.123.199.148","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-29 18:51:11","completed","",NULL),
("1123","0","83.123.199.148","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-29 18:52:06","completed","",NULL),
("1124","0","31.58.32.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 19:20:58","completed","",NULL),
("1125","0","31.58.32.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 19:23:02","completed","",NULL),
("1126","0","31.58.32.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-10-29 19:23:21","completed","",NULL),
("1127","0","31.58.32.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 19:29:13","completed","",NULL),
("1128","0","31.58.32.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-10-29 19:29:34","completed","",NULL),
("1129","0","95.82.9.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","66","67","","2019-10-29 19:50:48","completed","",NULL),
("1130","0","37.254.131.121","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 20:17:12","completed","",NULL),
("1131","0","37.254.131.121","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 20:17:34","completed","",NULL),
("1132","0","2.179.50.238","Mozilla/5.0 (Windows NT 6.2; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 20:22:47","completed","",NULL),
("1133","0","2.179.50.238","Mozilla/5.0 (Windows NT 6.2; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 20:24:24","completed","",NULL),
("1134","0","2.179.50.238","Mozilla/5.0 (Windows NT 6.2; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 20:24:35","completed","",NULL),
("1135","0","5.214.75.183","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-29 20:29:00","completed","",NULL),
("1136","0","5.214.75.183","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-10-29 20:30:06","completed","",NULL),
("1137","0","66.249.83.13","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-29 21:10:38","completed","",NULL),
("1138","0","66.249.83.13","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-29 21:10:40","completed","",NULL),
("1139","0","66.249.83.15","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","66","67","","2019-10-29 21:10:47","completed","",NULL),
("1140","0","66.249.83.11","Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19","93","94","","2019-10-29 21:10:49","completed","",NULL),
("1141","0","5.214.75.183","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-29 21:52:23","completed","",NULL),
("1142","0","5.214.75.183","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-29 21:53:43","completed","",NULL),
("1143","0","5.214.75.183","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-29 21:53:49","completed","",NULL),
("1144","0","5.123.86.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 21:57:29","completed","",NULL),
("1145","0","95.82.9.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","124","125","","2019-10-29 21:58:26","completed","",NULL),
("1146","0","95.82.9.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","124","125","","2019-10-29 21:58:45","completed","",NULL),
("1147","0","5.123.86.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-10-29 21:58:53","completed","",NULL),
("1148","0","5.123.86.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","97","98","","2019-10-29 21:58:57","completed","",NULL),
("1149","0","109.125.166.115","Mozilla/5.0 (Windows NT 6.3; WOW64; rv:66.0) Gecko/20100101 Firefox/66.0","93","94","","2019-10-29 22:08:46","completed","",NULL),
("1150","0","178.131.119.33","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 22:42:25","completed","",NULL),
("1151","0","178.131.119.33","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 22:43:00","completed","",NULL),
("1152","0","192.15.243.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-10-29 23:39:16","completed","",NULL),
("1153","0","5.218.99.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-29 23:39:22","completed","",NULL),
("1154","0","192.15.243.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-10-29 23:44:10","completed","",NULL),
("1155","0","192.15.243.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-10-29 23:44:17","completed","",NULL),
("1156","0","2.182.4.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 00:48:01","completed","",NULL),
("1157","0","2.182.4.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 00:48:27","completed","",NULL),
("1158","0","178.131.119.33","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 00:59:36","completed","",NULL),
("1159","0","95.64.83.101","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36","66","67","","2019-10-30 01:23:09","completed","",NULL),
("1160","0","5.78.245.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 01:52:56","completed","",NULL),
("1161","0","5.78.245.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 01:53:26","completed","",NULL),
("1162","0","5.78.245.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 01:53:33","completed","",NULL),
("1163","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-30 01:57:20","completed","",NULL),
("1164","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","93","94","","2019-10-30 01:59:17","completed","",NULL),
("1165","0","5.78.245.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 01:59:32","completed","",NULL),
("1166","0","5.78.245.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 01:59:50","completed","",NULL),
("1167","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","101","102","","2019-10-30 02:00:45","completed","",NULL),
("1168","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-30 02:01:36","completed","",NULL),
("1169","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2019-10-30 02:01:43","completed","",NULL),
("1170","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","68","69","","2019-10-30 02:01:59","completed","",NULL),
("1171","0","178.131.93.87","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","99","100","","2019-10-30 02:02:25","completed","",NULL),
("1172","0","5.124.43.218","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 05:36:07","completed","",NULL),
("1173","0","86.104.244.145","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 07:15:08","completed","",NULL),
("1174","0","151.241.129.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-30 09:42:47","completed","",NULL),
("1175","0","151.241.129.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-30 09:42:59","completed","",NULL),
("1176","0","151.241.129.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-30 09:43:30","completed","",NULL),
("1177","0","46.62.243.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-30 10:06:12","completed","",NULL),
("1178","0","5.121.144.57","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","66","67","","2019-10-30 10:29:28","completed","",NULL),
("1179","0","5.238.252.117","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 10:43:37","completed","",NULL),
("1180","0","5.238.252.117","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 10:43:39","completed","",NULL),
("1181","0","31.57.234.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-30 10:51:00","completed","",NULL),
("1182","0","5.122.159.109","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 11:23:38","completed","",NULL),
("1183","0","94.139.167.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-10-30 11:55:33","completed","",NULL),
("1184","0","94.139.167.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-10-30 11:55:42","completed","",NULL),
("1185","0","193.175.119.11","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 12:19:50","completed","",NULL),
("1186","0","85.133.244.245","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 12:22:58","completed","",NULL),
("1187","0","31.59.200.142","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","113","114","","2019-10-30 13:00:33","completed","",NULL),
("1188","0","31.59.200.142","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","66","67","","2019-10-30 13:00:39","completed","",NULL),
("1189","0","86.57.12.70","Mozilla/5.0 (Windows NT 10.0; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-30 13:02:52","completed","",NULL),
("1190","0","31.59.200.142","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","97","98","","2019-10-30 13:03:19","completed","",NULL),
("1191","0","31.59.200.142","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","97","98","","2019-10-30 13:03:22","completed","",NULL),
("1192","0","31.59.200.142","Mozilla/5.0 (Windows NT 6.1; rv:68.0) Gecko/20100101 Firefox/68.0","97","98","","2019-10-30 13:03:26","completed","",NULL),
("1193","0","46.245.111.40","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 13:25:55","completed","",NULL),
("1194","0","46.245.111.40","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 13:26:27","completed","",NULL),
("1195","0","5.250.26.244","Mozilla/5.0 (Linux; Android 8.0.0; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-30 13:39:46","completed","",NULL),
("1196","0","5.250.26.244","Mozilla/5.0 (Linux; Android 8.0.0; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-10-30 13:42:09","completed","",NULL),
("1197","0","93.114.23.129","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 14:29:22","completed","",NULL),
("1198","0","93.114.23.129","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","99","100","","2019-10-30 14:29:37","completed","",NULL),
("1199","0","93.114.23.129","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 14:30:17","completed","",NULL),
("1200","0","93.114.23.129","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 14:30:37","completed","",NULL),
("1201","0","93.114.23.129","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 14:35:16","completed","",NULL),
("1202","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","68","69","","2019-10-30 14:37:15","completed","",NULL),
("1203","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-10-30 14:37:22","completed","",NULL),
("1204","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","113","114","","2019-10-30 14:37:51","completed","",NULL),
("1205","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-30 15:03:37","completed","",NULL),
("1206","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-30 15:03:46","completed","",NULL),
("1207","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","68","69","","2019-10-30 15:03:59","completed","",NULL),
("1208","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","93","94","","2019-10-30 15:05:54","completed","",NULL),
("1209","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-10-30 15:09:45","completed","",NULL),
("1210","1","5.116.4.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 15:09:47","completed","",NULL),
("1211","1","5.116.4.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 15:09:49","completed","",NULL),
("1212","0","5.250.26.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-10-30 15:09:57","completed","",NULL),
("1213","1","5.116.4.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 15:10:00","completed","",NULL),
("1214","1","5.116.4.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-30 15:11:02","completed","",NULL),
("1215","0","95.82.60.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 15:45:58","completed","",NULL),
("1216","0","192.129.26.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","66","67","","2019-10-30 16:21:03","completed","",NULL),
("1217","0","192.129.26.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","66","67","","2019-10-30 16:21:15","completed","",NULL),
("1218","0","84.241.32.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 16:32:58","completed","",NULL),
("1219","0","84.241.32.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 16:33:05","completed","",NULL),
("1220","0","84.241.32.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 16:33:07","completed","",NULL),
("1221","0","87.98.232.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","66","67","","2019-10-30 17:19:46","completed","",NULL),
("1222","0","80.82.67.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-30 17:20:20","completed","",NULL),
("1223","0","178.63.238.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-10-30 18:27:00","completed","",NULL),
("1224","0","5.120.17.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.73","93","94","","2019-10-31 10:06:41","completed","",NULL),
("1225","0","134.19.177.26","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-10-31 11:33:40","completed","",NULL),
("1226","0","77.77.97.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-10-31 15:18:33","completed","",NULL),
("1227","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-31 15:30:56","completed","",NULL),
("1228","0","95.82.50.136","Mozilla/5.0 (Linux; Android 6.0; Che2-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","124","125","","2019-10-31 15:52:37","completed","",NULL),
("1229","0","5.117.43.7","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/78.0.3904.67 Mobile/15E148 Safari/604.1","66","67","","2019-10-31 18:46:54","completed","",NULL),
("1230","0","5.121.253.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-10-31 19:44:46","completed","",NULL),
("1231","0","104.237.225.118","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-10-31 20:04:51","completed","",NULL),
("1232","0","5.123.180.248","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-10-31 21:38:08","completed","",NULL),
("1233","0","5.115.28.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-10-31 22:18:55","completed","",NULL),
("1234","0","5.78.86.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-01 03:35:48","completed","",NULL),
("1235","0","37.255.168.175","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-11-01 10:25:03","completed","",NULL),
("1236","0","37.255.168.175","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-01 10:25:23","completed","",NULL),
("1237","0","89.196.239.80","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-01 11:08:51","completed","",NULL),
("1238","0","151.233.37.194","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-01 11:18:05","completed","",NULL),
("1239","0","158.58.97.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-01 11:23:06","completed","",NULL),
("1240","0","100.88.222.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","101","102","","2019-11-01 12:59:03","completed","",NULL),
("1241","0","77.111.247.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36 OPR/63.0.3368.107","93","94","","2019-11-01 15:55:38","completed","",NULL),
("1242","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-11-01 16:13:29","completed","",NULL),
("1243","0","83.123.15.195","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-01 16:33:22","completed","",NULL),
("1244","0","107.150.23.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-01 16:55:51","completed","",NULL),
("1245","0","5.126.5.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","124","125","","2019-11-01 18:13:27","completed","",NULL),
("1246","0","5.126.74.94","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-11-01 18:30:35","completed","",NULL),
("1247","0","5.78.62.119","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-01 19:36:44","completed","",NULL),
("1248","0","95.82.8.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","124","125","","2019-11-01 19:43:44","completed","",NULL),
("1249","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-01 19:51:15","completed","",NULL),
("1250","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-11-01 19:51:55","completed","",NULL),
("1251","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-11-01 19:53:23","completed","",NULL),
("1252","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-11-01 19:53:40","completed","",NULL),
("1253","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-01 19:58:45","completed","",NULL),
("1254","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","101","102","","2019-11-01 20:00:16","completed","",NULL),
("1255","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-11-01 20:00:39","completed","",NULL),
("1256","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-11-01 20:03:25","completed","",NULL),
("1257","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-11-01 20:05:36","completed","",NULL),
("1258","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-01 20:06:27","completed","",NULL),
("1259","0","5.122.135.252","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-11-01 20:09:50","completed","",NULL),
("1260","0","5.134.166.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-01 20:13:25","completed","",NULL),
("1261","0","46.62.135.190","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-01 23:14:45","completed","",NULL),
("1262","0","217.23.3.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-11-02 00:43:09","completed","",NULL),
("1263","0","5.121.253.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-02 00:45:27","completed","",NULL),
("1264","0","5.237.128.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-11-02 01:13:34","completed","",NULL),
("1265","0","31.59.151.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","68","69","","2019-11-02 01:24:25","completed","",NULL),
("1266","0","31.59.151.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","99","100","","2019-11-02 02:12:51","completed","",NULL),
("1267","0","5.122.199.75","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-02 05:54:46","completed","",NULL),
("1268","0","80.191.200.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36 OPR/63.0.3368.107 (Edition Campaign 34)","93","94","","2019-11-02 10:21:51","completed","",NULL),
("1269","0","83.120.36.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-02 13:43:26","completed","",NULL),
("1270","0","62.220.119.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-02 14:52:19","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1271","0","62.220.119.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-02 14:52:19","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1272","0","2.184.223.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","68","69","","2019-11-02 15:33:46","completed","",NULL),
("1273","0","82.102.10.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-02 16:41:38","completed","",NULL),
("1274","0","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-02 18:00:01","completed","",NULL),
("1275","0","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-02 18:01:02","completed","",NULL),
("1276","0","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-02 18:34:32","completed","",NULL),
("1277","0","5.106.144.252","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/7.4 Chrome/59.0.3071.125 Mobile Safari/537.36","66","67","","2019-11-02 19:07:51","completed","",NULL),
("1278","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-11-02 20:34:42","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1279","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-11-02 20:34:42","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1280","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-11-02 20:34:43","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1281","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-11-02 20:34:43","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1282","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-11-02 20:36:16","completed","",NULL),
("1283","0","5.120.16.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-11-02 20:36:25","completed","",NULL),
("1284","0","5.218.34.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36 OPR/63.0.3368.107","66","67","","2019-11-02 21:54:24","completed","",NULL),
("1285","0","5.114.112.173","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","97","98","","2019-11-02 23:37:40","completed","",NULL),
("1286","0","5.239.220.227","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36 OPR/64.0.3417.61","66","67","","2019-11-03 00:11:19","completed","",NULL),
("1287","0","151.238.161.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","68","69","","2019-11-03 01:19:23","completed","",NULL),
("1288","0","144.217.54.203","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.75 Safari/537.36","66","67","","2019-11-03 02:00:20","completed","",NULL),
("1289","21","2.181.208.29","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36","66","67","","2019-11-03 09:17:57","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1290","0","91.186.208.42","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-03 12:36:40","completed","",NULL),
("1291","0","89.187.177.67","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-03 17:55:46","completed","",NULL),
("1292","0","37.137.21.163","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-03 18:29:51","completed","",NULL),
("1293","0","74.207.235.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-11-03 18:30:15","completed","",NULL),
("1294","0","5.238.160.224","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-03 20:51:09","completed","",NULL),
("1295","22","176.218.203.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-03 23:13:47","completed","",NULL),
("1296","22","176.218.203.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-03 23:27:37","completed","",NULL),
("1297","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-11-04 00:21:07","completed","",NULL),
("1298","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2019-11-04 00:21:55","completed","",NULL),
("1299","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-04 00:24:03","completed","",NULL),
("1300","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","68","69","","2019-11-04 00:25:21","completed","",NULL),
("1301","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-11-04 00:28:10","completed","",NULL),
("1302","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-04 00:32:05","completed","",NULL),
("1303","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-11-04 00:33:46","completed","",NULL),
("1304","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","68","69","","2019-11-04 00:33:53","completed","",NULL),
("1305","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-04 00:35:29","completed","",NULL),
("1306","0","176.218.203.100","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-11-04 00:36:23","completed","",NULL),
("1307","14","83.120.208.182","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-04 04:18:50","completed","",NULL),
("1308","0","5.200.102.240","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-04 08:40:30","completed","",NULL),
("1309","0","62.220.119.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-04 10:03:56","completed","",NULL),
("1310","0","86.57.3.82","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-04 12:37:49","completed","",NULL),
("1311","0","5.117.207.0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-11-04 14:16:59","completed","",NULL),
("1312","0","5.113.97.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-04 14:29:02","completed","",NULL),
("1313","0","94.139.160.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-04 16:28:36","completed","",NULL),
("1314","0","77.77.122.130","Mozilla/5.0 (Linux; Android 4.4.2; Hol-U19) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.90 Mobile Safari/537.36","124","125","","2019-11-04 17:29:08","completed","",NULL),
("1315","0","5.236.171.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-04 18:22:57","completed","",NULL),
("1316","0","86.55.105.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-04 22:28:23","completed","",NULL),
("1317","0","5.124.62.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","113","114","","2019-11-04 23:07:21","completed","",NULL),
("1318","0","5.115.254.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","97","98","","2019-11-05 11:03:29","completed","",NULL),
("1319","0","5.115.254.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-05 11:07:12","completed","",NULL),
("1320","0","185.142.95.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-05 11:11:18","completed","",NULL),
("1321","0","188.212.243.9","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.75 Safari/537.36","99","100","","2019-11-05 11:36:05","completed","",NULL),
("1322","0","5.217.245.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-05 14:16:08","completed","",NULL),
("1323","0","5.126.178.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","66","67","","2019-11-05 14:46:01","completed","",NULL),
("1324","0","5.202.212.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-05 14:52:09","completed","",NULL),
("1325","0","84.241.39.60","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-05 15:52:57","completed","",NULL),
("1326","0","93.126.40.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","113","114","","2019-11-05 16:19:58","completed","",NULL),
("1327","0","2.178.101.78","Mozilla/5.0 (Linux; Android 4.4.2; GT-N5100) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Safari/537.36","93","94","","2019-11-05 17:08:35","completed","",NULL),
("1328","0","217.11.28.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18362","66","67","","2019-11-05 17:15:33","completed","",NULL),
("1329","0","54.38.23.34","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","113","114","","2019-11-05 17:24:44","completed","",NULL),
("1330","0","5.190.90.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","66","67","","2019-11-05 18:59:10","completed","",NULL),
("1331","0","5.115.41.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","101","102","","2019-11-05 18:59:34","completed","",NULL),
("1332","0","5.115.41.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","97","98","","2019-11-05 18:59:40","completed","",NULL),
("1333","0","86.55.111.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-05 20:11:26","completed","",NULL),
("1334","0","2.181.238.221","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-05 20:17:09","completed","",NULL),
("1335","0","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-06 10:34:19","completed","",NULL),
("1336","0","94.102.50.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","97","98","","2019-11-06 11:08:39","completed","",NULL),
("1337","0","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-06 11:39:57","completed","",NULL),
("1338","0","77.111.246.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36 OPR/63.0.3368.107 (Edition Campaign 34)","66","67","","2019-11-06 12:07:19","completed","",NULL),
("1339","0","5.119.16.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-06 12:34:18","completed","",NULL),
("1340","0","37.202.251.250","Mozilla/5.0 (Linux; Android 9; COL-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.90 Mobile Safari/537.36","66","67","","2019-11-06 13:54:00","completed","",NULL),
("1341","27","46.209.169.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-06 14:04:25","completed","",NULL),
("1342","14","83.121.100.45","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-06 15:18:50","completed","",NULL),
("1343","14","83.121.100.45","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","99","100","","2019-11-06 15:19:20","completed","",NULL),
("1344","0","46.224.210.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","99","100","","2019-11-06 15:38:33","completed","",NULL),
("1345","0","46.224.210.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-06 15:39:23","completed","",NULL),
("1346","0","46.224.210.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","99","100","","2019-11-06 15:40:43","completed","",NULL),
("1347","0","5.62.221.2","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","113","114","","2019-11-06 16:07:56","completed","",NULL),
("1348","0","5.62.221.2","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","97","98","","2019-11-06 16:08:11","completed","",NULL),
("1349","0","5.214.203.193","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36","66","67","","2019-11-06 17:26:00","completed","",NULL),
("1350","0","86.104.104.11","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","113","114","","2019-11-06 17:43:48","completed","",NULL),
("1351","0","37.254.140.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-06 17:51:49","completed","",NULL),
("1352","0","5.213.53.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-06 21:14:48","completed","",NULL),
("1353","0","188.215.221.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-06 22:26:26","completed","",NULL),
("1354","29","95.64.66.90","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-11-07 00:13:21","completed","",NULL),
("1355","29","95.64.66.90","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","97","98","","2019-11-07 00:14:16","completed","",NULL),
("1356","29","95.64.66.90","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","99","100","","2019-11-07 00:14:29","completed","",NULL),
("1357","0","5.115.168.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36","93","94","","2019-11-07 02:25:19","completed","",NULL),
("1358","0","5.115.168.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36","99","100","","2019-11-07 02:26:00","completed","",NULL),
("1359","0","78.141.218.155","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-07 10:03:53","completed","",NULL),
("1360","0","185.134.23.147","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-11-07 10:08:05","completed","",NULL),
("1361","0","185.134.23.147","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","101","102","","2019-11-07 10:08:56","completed","",NULL),
("1362","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2019-11-07 10:13:54","completed","",NULL),
("1363","0","185.134.23.147","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-07 10:14:28","completed","",NULL),
("1364","0","185.134.23.147","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-11-07 10:14:28","completed","",NULL),
("1365","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-11-07 10:16:30","completed","",NULL),
("1366","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-07 10:18:17","completed","",NULL),
("1367","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","101","102","","2019-11-07 10:18:21","completed","",NULL),
("1368","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-11-07 10:20:13","completed","",NULL),
("1369","0","188.253.126.90","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-11-07 10:22:04","completed","",NULL),
("1370","0","212.86.81.226","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","124","125","","2019-11-07 10:57:12","completed","",NULL),
("1371","0","5.200.118.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-07 23:12:24","completed","",NULL),
("1372","0","5.126.208.222","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-08 06:45:27","completed","",NULL),
("1373","0","109.169.65.139","Mozilla/5.0 (Linux; Android 7.0; HUAWEI VNS-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","124","125","","2019-11-08 09:15:59","completed","",NULL),
("1374","0","109.169.65.139","Mozilla/5.0 (Linux; Android 7.0; HUAWEI VNS-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Mobile Safari/537.36","124","125","","2019-11-08 09:15:59","completed","",NULL),
("1375","0","213.207.236.113","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-08 12:29:36","completed","",NULL),
("1376","0","46.224.125.95","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-08 16:21:37","completed","",NULL),
("1377","0","46.225.198.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-08 20:13:31","completed","",NULL),
("1378","0","46.225.198.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-08 20:14:19","completed","",NULL),
("1379","0","80.210.161.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-08 22:12:43","completed","",NULL),
("1380","0","5.190.211.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.92","113","114","","2019-11-08 23:29:29","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1381","0","2.180.102.154","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","113","114","","2019-11-09 08:27:26","completed","",NULL),
("1382","0","185.141.39.164","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-09 09:37:41","completed","",NULL),
("1383","0","212.103.50.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","113","114","","2019-11-09 13:08:10","completed","",NULL),
("1384","0","66.102.9.64","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","66","67","","2019-11-09 13:19:26","completed","",NULL),
("1385","0","66.102.9.64","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","99","100","","2019-11-09 13:19:26","completed","",NULL),
("1386","0","87.107.245.227","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-09 15:10:42","completed","",NULL),
("1387","0","46.245.76.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-09 16:34:05","completed","",NULL),
("1388","0","5.119.195.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-09 21:47:27","completed","",NULL),
("1389","0","204.18.61.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-10 04:57:40","completed","",NULL),
("1390","0","5.113.184.50","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-10 11:58:37","completed","",NULL),
("1391","30","81.19.210.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-10 12:14:04","completed","",NULL),
("1392","0","185.161.113.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-10 12:17:56","completed","",NULL),
("1393","0","86.107.159.208","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","124","125","","2019-11-10 12:30:28","completed","",NULL),
("1394","0","62.102.133.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-10 21:38:11","completed","",NULL),
("1395","0","62.102.133.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-10 21:39:54","completed","",NULL),
("1396","0","87.7.188.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-11 03:08:29","completed","",NULL),
("1397","0","14.47.233.40","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","66","67","","2019-11-11 11:09:34","completed","",NULL),
("1398","0","14.47.233.40","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","113","114","","2019-11-11 11:11:18","completed","",NULL),
("1399","0","14.47.233.40","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","113","114","","2019-11-11 11:11:29","completed","",NULL),
("1400","0","14.47.233.40","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","113","114","","2019-11-11 11:11:30","completed","",NULL),
("1401","0","91.106.93.98","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-11 16:32:41","completed","",NULL),
("1402","0","93.119.209.82","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-11 17:48:34","completed","",NULL),
("1403","0","37.27.205.125","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-11 18:17:35","completed","",NULL),
("1404","0","37.27.205.125","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-11 18:18:44","completed","",NULL),
("1405","0","199.247.13.114","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-11 23:01:42","completed","",NULL),
("1406","0","5.116.182.82","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-12 04:28:21","completed","",NULL),
("1407","0","89.36.48.116","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.137 Safari/537.36","68","69","","2019-11-12 07:55:46","completed","",NULL),
("1408","0","94.130.127.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-12 09:43:30","completed","",NULL),
("1409","0","94.130.127.140","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","124","125","","2019-11-12 09:46:01","completed","",NULL),
("1410","0","94.130.127.140","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","93","94","","2019-11-12 09:46:37","completed","",NULL),
("1411","0","94.130.127.140","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","66","67","","2019-11-12 09:46:37","completed","",NULL),
("1412","0","94.130.127.140","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","113","114","","2019-11-12 09:46:50","completed","",NULL),
("1413","0","93.119.212.175","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-12 13:18:20","completed","",NULL),
("1414","0","151.235.39.227","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-12 15:39:39","completed","",NULL),
("1415","0","151.235.39.227","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-12 15:40:21","completed","",NULL),
("1416","0","5.115.140.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","113","114","","2019-11-12 16:39:27","completed","",NULL),
("1417","34","5.115.140.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-12 16:53:46","completed","",NULL),
("1418","0","31.59.216.119","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-12 17:18:04","completed","",NULL),
("1419","0","151.238.165.66","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-12 18:48:50","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1420","0","151.238.165.66","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-12 18:48:52","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1421","0","5.236.176.37","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","97","98","","2019-11-12 21:48:46","completed","",NULL),
("1422","0","93.119.208.185","Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-13 00:14:20","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1423","0","77.77.95.194","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-11-13 01:15:12","completed","",NULL),
("1424","0","77.42.54.191","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-13 02:47:58","completed","",NULL),
("1425","0","103.119.24.75","Mozilla/5.0 (Linux; Android 6.0; LG-D855) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.90 Mobile Safari/537.36","66","67","","2019-11-13 10:55:45","completed","",NULL),
("1426","0","37.129.196.237","Mozilla/5.0 (Linux; Android 7.0; FRD-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","93","94","","2019-11-13 10:56:50","completed","",NULL),
("1427","0","37.129.196.237","Mozilla/5.0 (Linux; Android 7.0; FRD-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","93","94","","2019-11-13 10:56:53","completed","",NULL),
("1428","0","91.98.177.23","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-13 11:37:29","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1429","0","5.53.58.203","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-13 11:37:29","completed","",NULL),
("1430","0","46.4.153.184","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","124","125","","2019-11-13 11:57:26","completed","",NULL),
("1431","0","185.88.153.41","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-13 16:01:39","completed","",NULL),
("1432","0","46.224.126.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-13 17:19:32","completed","",NULL),
("1433","0","139.28.216.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-13 18:43:57","completed","",NULL),
("1434","0","5.122.95.229","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-13 20:45:30","completed","",NULL),
("1435","0","5.122.95.229","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-13 20:45:55","completed","",NULL),
("1436","0","5.116.211.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-13 20:50:33","completed","",NULL),
("1437","0","54.38.23.34","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-13 21:51:54","completed","",NULL),
("1438","0","5.114.38.254","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21 Build/HUAWEIRNE-L21; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.90 Mobile Safari/537.36 Instagram 117.0.0.28.123 Android (26/8.","93","94","","2019-11-14 00:41:58","completed","",NULL),
("1439","0","5.123.55.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 00:44:09","completed","",NULL),
("1440","0","5.112.116.162","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 01:03:35","completed","",NULL),
("1441","0","5.120.85.224","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-14 01:04:15","completed","",NULL),
("1442","0","5.115.103.20","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 01:50:20","completed","",NULL),
("1443","0","2.177.43.53","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","101","102","","2019-11-14 03:03:31","completed","",NULL),
("1444","0","185.134.97.35","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-14 08:59:03","completed","",NULL),
("1445","0","2.190.254.32","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","66","67","","2019-11-14 10:00:42","completed","",NULL),
("1446","0","188.118.96.229","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-14 11:35:19","completed","",NULL),
("1447","0","188.118.96.229","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-14 11:35:52","completed","",NULL),
("1448","0","94.139.160.213","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 11:55:11","completed","",NULL),
("1449","0","86.107.7.23","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A600F Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/9.4 Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-11-14 11:55:47","completed","",NULL),
("1450","0","195.181.117.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-14 13:17:51","completed","",NULL),
("1451","38","151.238.74.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 13:31:42","completed","",NULL),
("1452","38","151.238.74.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 13:31:43","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1453","0","95.216.210.169","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 14:22:27","completed","",NULL),
("1454","0","5.219.104.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-14 14:34:08","completed","",NULL),
("1455","0","95.216.210.169","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 14:37:12","completed","",NULL),
("1456","0","77.111.246.72","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.92","124","125","","2019-11-14 16:20:22","completed","",NULL),
("1457","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:57:30","completed","",NULL),
("1458","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:57:34","completed","",NULL),
("1459","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:57:51","completed","",NULL),
("1460","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:57:56","completed","",NULL),
("1461","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:58:10","completed","",NULL),
("1462","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 16:58:17","completed","",NULL),
("1463","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:01:38","completed","",NULL),
("1464","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:01:42","completed","",NULL),
("1465","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:02:03","completed","",NULL),
("1466","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:02:07","completed","",NULL),
("1467","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:02:24","completed","",NULL),
("1468","0","185.182.221.52","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15","66","67","","2019-11-14 17:02:29","completed","",NULL),
("1469","0","151.235.221.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-14 17:05:32","completed","",NULL),
("1470","0","77.234.44.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","70","71","","2019-11-14 17:11:30","completed","",NULL),
("1471","0","95.82.17.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-14 18:43:37","completed","",NULL),
("1472","0","5.120.44.25","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-14 19:05:41","completed","",NULL),
("1473","0","5.120.44.25","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-14 19:05:51","completed","",NULL),
("1474","0","46.245.125.146","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-14 19:38:34","completed","",NULL),
("1475","0","46.245.125.146","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 19:53:17","completed","",NULL),
("1476","0","31.59.211.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 20:09:23","completed","",NULL),
("1477","0","31.58.168.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-14 22:50:28","completed","",NULL),
("1478","0","185.81.98.142","Mozilla/5.0 (Linux; Android 9; SM-N950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.96 Mobile Safari/537.36","93","94","","2019-11-14 22:54:46","completed","",NULL),
("1479","0","86.104.100.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-15 00:07:57","completed","",NULL),
("1480","0","31.59.76.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-15 01:44:13","completed","",NULL),
("1481","0","5.112.194.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-15 01:53:05","completed","",NULL),
("1482","0","151.238.145.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 03:12:48","completed","",NULL),
("1483","0","5.78.227.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-15 10:01:22","completed","",NULL),
("1484","0","5.119.8.85","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-15 12:29:08","completed","",NULL),
("1485","0","5.120.135.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36","93","94","","2019-11-15 12:55:34","completed","",NULL),
("1486","0","2.177.129.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 12:55:49","completed","",NULL),
("1487","0","5.120.135.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36","97","98","","2019-11-15 12:56:09","completed","",NULL),
("1488","0","46.225.195.1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-15 13:18:48","completed","",NULL),
("1489","0","46.100.218.222","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-15 13:24:46","completed","",NULL),
("1490","0","185.239.173.199","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 13:36:39","completed","",NULL),
("1491","0","185.239.173.199","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 13:37:20","completed","",NULL),
("1492","0","66.249.93.58","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","93","94","","2019-11-15 13:58:01","completed","",NULL),
("1493","0","66.249.93.56","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","93","94","","2019-11-15 13:58:02","completed","",NULL),
("1494","0","66.249.93.58","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","93","94","","2019-11-15 13:58:03","completed","",NULL),
("1495","0","66.249.93.56","Mozilla/5.0 (Linux; Android 4.2.2; Nexus 4 Build/JDQ39) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.35 Mobile Safari/537.31","93","94","","2019-11-15 13:58:09","completed","",NULL),
("1496","0","198.23.143.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-15 13:59:44","completed","",NULL),
("1497","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","113","114","","2019-11-15 14:03:27","completed","",NULL),
("1498","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:03:50","completed","",NULL),
("1499","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:03:53","completed","",NULL),
("1500","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:03:53","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("1501","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:05:32","completed","",NULL),
("1502","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:05:33","completed","",NULL),
("1503","0","2.177.129.214","Mozilla/5.0 (Linux; Android 6.0.1; ASUS_Z00LD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","97","98","","2019-11-15 14:05:33","completed","",NULL),
("1504","0","178.63.252.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 14:40:41","completed","",NULL),
("1505","0","188.159.126.79","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-15 14:58:07","completed","",NULL),
("1506","0","94.183.224.155","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-15 15:00:30","completed","",NULL),
("1507","0","51.38.89.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-15 15:53:57","completed","",NULL),
("1508","0","5.114.134.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 15:55:23","completed","",NULL),
("1509","0","86.57.3.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-15 16:12:48","completed","",NULL),
("1510","0","5.213.173.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 16:24:07","completed","",NULL),
("1511","0","136.243.242.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 16:28:59","completed","",NULL),
("1512","0","89.38.91.147","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.92 (Edition Campaign 34)","113","114","","2019-11-15 16:30:27","completed","",NULL),
("1513","0","151.241.37.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36","93","94","","2019-11-15 16:43:21","completed","",NULL),
("1514","0","5.123.79.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 16:56:21","completed","",NULL),
("1515","0","95.82.41.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 17:21:16","completed","",NULL),
("1516","0","31.57.161.187","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-15 17:29:04","completed","",NULL),
("1517","0","151.238.248.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-15 18:34:49","completed","",NULL),
("1518","0","46.209.163.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-15 18:59:02","completed","",NULL),
("1519","0","91.133.215.151","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36","93","94","","2019-11-15 19:36:29","completed","",NULL),
("1520","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:43:46","completed","",NULL),
("1521","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","101","102","","2019-11-15 19:44:45","completed","",NULL),
("1522","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:45:02","completed","",NULL),
("1523","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:45:05","completed","",NULL),
("1524","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:49:46","completed","",NULL),
("1525","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:50:49","completed","",NULL),
("1526","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 19:51:05","completed","",NULL),
("1527","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:53:44","completed","",NULL),
("1528","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:54:35","completed","",NULL),
("1529","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:54:57","completed","",NULL),
("1530","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:55:22","completed","",NULL),
("1531","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:55:44","completed","",NULL),
("1532","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:56:06","completed","",NULL),
("1533","0","80.210.140.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-15 19:56:30","completed","",NULL),
("1534","0","5.75.93.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-11-15 20:00:19","completed","",NULL),
("1535","0","37.27.223.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-15 20:30:38","completed","",NULL),
("1536","0","5.210.129.188","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-15 20:48:38","completed","",NULL),
("1537","0","5.125.30.156","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.96 Mobile Safari/537.36","93","94","","2019-11-15 20:52:19","completed","",NULL),
("1538","0","5.113.43.239","Mozilla/5.0 (Linux; Android 6.0.1; ZTE A2017G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","99","100","","2019-11-15 21:09:00","completed","",NULL),
("1539","0","5.113.43.239","Mozilla/5.0 (Linux; Android 6.0.1; ZTE A2017G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","97","98","","2019-11-15 21:09:10","completed","",NULL),
("1540","0","151.238.182.122","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","97","98","","2019-11-15 21:58:51","completed","",NULL),
("1541","0","151.238.182.122","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 21:59:08","completed","",NULL),
("1542","0","93.117.177.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-15 23:26:32","completed","",NULL),
("1543","40","83.121.6.5","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-15 23:45:16","completed","",NULL),
("1544","0","80.210.9.107","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2019-11-16 01:21:07","completed","",NULL),
("1545","0","5.112.185.107","Mozilla/5.0 (Linux; Android 9; SM-G950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-11-16 07:42:43","completed","",NULL),
("1546","0","5.112.185.107","Mozilla/5.0 (Linux; Android 9; SM-G950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-11-16 07:42:49","completed","",NULL),
("1547","0","62.201.241.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36 OPR/64.0.3417.92","93","94","","2019-11-16 10:59:18","completed","",NULL),
("1548","0","5.232.165.18","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-16 11:07:46","completed","",NULL),
("1549","0","46.225.38.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-16 11:24:14","completed","",NULL),
("1550","0","86.55.215.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-16 12:00:02","completed","",NULL),
("1551","0","78.39.193.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-16 12:39:42","completed","",NULL),
("1552","41","46.224.137.5","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-11-16 16:01:53","completed","",NULL),
("1553","0","5.236.140.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-16 16:43:52","completed","",NULL),
("1554","0","5.236.140.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-16 16:45:25","completed","",NULL),
("1555","0","5.78.94.12","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","113","114","","2019-11-16 19:40:06","completed","",NULL),
("1556","0","2.190.134.144","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2019-11-16 21:00:37","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1557","0","2.191.110.57","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Brackets/1.14.0.0 Chrome/49.0.2623.110 Safari/537.36","66","67","","2019-11-17 12:25:23","completed","",NULL),
("1558","0","2.191.110.57","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-17 12:26:30","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1559","0","89.36.51.85","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-17 12:45:07","completed","",NULL),
("1560","0","89.36.51.85","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-17 12:46:09","completed","",NULL),
("1561","0","89.36.51.85","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-17 12:46:21","completed","",NULL),
("1562","0","5.113.48.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-17 12:54:37","completed","",NULL),
("1563","0","5.113.48.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-17 12:55:29","completed","",NULL),
("1564","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-17 17:58:17","completed","",NULL),
("1565","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-17 17:59:33","completed","",NULL),
("1566","14","192.15.77.145","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-17 18:14:48","completed","",NULL),
("1567","14","192.15.77.145","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-17 18:15:03","completed","",NULL),
("1568","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-17 18:25:06","completed","",NULL),
("1569","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-17 18:35:31","completed","",NULL),
("1570","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-17 18:48:07","completed","",NULL),
("1571","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-17 18:49:30","completed","",NULL),
("1572","0","93.119.220.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-18 09:52:04","completed","",NULL),
("1573","0","93.119.220.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-18 09:59:45","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1574","0","2.177.216.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-18 10:22:00","completed","",NULL),
("1575","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-18 11:45:19","completed","",NULL),
("1576","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-18 11:46:14","completed","",NULL),
("1577","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-18 11:47:01","completed","",NULL),
("1578","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-18 12:12:17","completed","",NULL),
("1579","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-18 12:56:09","completed","",NULL),
("1580","0","93.115.148.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-18 12:59:30","completed","",NULL),
("1581","0","151.239.230.114","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","97","98","","2019-11-18 15:39:18","completed","",NULL),
("1582","0","195.181.49.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-18 16:29:43","completed","",NULL),
("1583","46","151.239.230.114","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","97","98","","2019-11-18 17:24:30","completed","",NULL),
("1584","0","171.22.27.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-18 17:35:40","completed","",NULL),
("1585","0","204.18.221.80","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-18 20:09:34","completed","",NULL),
("1586","0","172.80.196.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-18 23:33:29","completed","",NULL),
("1587","0","185.135.228.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-19 12:58:36","completed","",NULL),
("1588","0","185.135.228.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-19 13:08:28","completed","",NULL),
("1589","0","5.122.225.171","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36","93","94","","2019-11-19 13:08:41","completed","",NULL),
("1590","0","151.239.230.114","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-19 16:26:42","completed","",NULL),
("1591","46","151.239.230.114","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-19 17:39:14","completed","",NULL),
("1592","0","5.112.21.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-19 23:11:49","completed","",NULL),
("1593","0","5.112.21.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","97","98","","2019-11-19 23:14:19","completed","",NULL),
("1594","0","46.245.85.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36","66","67","","2019-11-19 23:59:24","completed","",NULL),
("1595","0","46.245.107.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-20 00:44:22","completed","",NULL),
("1596","0","94.183.163.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-20 09:38:52","completed","",NULL),
("1597","0","2.182.180.45","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-20 11:11:38","completed","",NULL),
("1598","0","5.232.35.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-20 13:11:26","completed","",NULL),
("1599","0","77.237.179.75","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-20 16:06:58","completed","",NULL),
("1600","0","5.236.168.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-20 16:33:34","completed","",NULL),
("1601","0","5.123.22.11","Mozilla/5.0 (Android 6.0.1; Mobile; rv:68.0) Gecko/68.0 Firefox/68.0","97","98","","2019-11-20 22:20:38","completed","",NULL),
("1602","0","94.24.91.224","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","113","114","","2019-11-21 02:55:19","completed","",NULL),
("1603","0","94.24.91.224","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","99","100","","2019-11-21 02:55:30","completed","",NULL),
("1604","0","5.159.55.82","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-21 08:20:43","completed","",NULL),
("1605","0","5.202.217.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-21 10:41:17","completed","",NULL),
("1606","0","5.202.217.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-21 10:44:43","completed","",NULL),
("1607","0","94.183.187.154","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-21 11:43:17","completed","",NULL),
("1608","0","5.123.173.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-21 12:36:20","completed","",NULL),
("1609","0","185.165.116.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-21 16:06:05","completed","",NULL),
("1610","0","5.113.141.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-21 17:58:19","completed","",NULL),
("1611","0","5.78.23.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-21 19:05:37","completed","",NULL),
("1612","47","94.101.128.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-21 19:16:19","completed","",NULL),
("1613","0","31.184.180.215","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","99","100","","2019-11-21 20:21:24","completed","",NULL),
("1614","0","31.184.180.215","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-21 20:22:42","completed","",NULL),
("1615","0","31.184.180.215","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","101","102","","2019-11-21 20:23:08","completed","",NULL),
("1616","0","31.58.21.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-21 23:18:25","completed","",NULL),
("1617","0","217.60.215.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-21 23:44:04","completed","",NULL),
("1618","0","185.129.237.178","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-22 10:46:00","completed","",NULL),
("1619","0","151.239.250.137","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-11-22 12:32:50","completed","",NULL),
("1620","0","5.215.45.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-22 16:42:50","completed","",NULL),
("1621","0","31.56.84.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-22 19:50:57","completed","",NULL),
("1622","0","46.245.72.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-22 20:38:36","completed","",NULL),
("1623","0","5.123.5.213","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-22 22:27:02","completed","",NULL),
("1624","0","185.65.252.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-23 11:57:43","completed","",NULL),
("1625","0","82.102.10.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-23 14:09:34","completed","",NULL),
("1626","0","5.208.226.170","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.73 Mobile Safari/537.36","97","98","","2019-11-23 14:50:29","completed","",NULL),
("1627","0","5.208.226.170","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.73 Mobile Safari/537.36","66","67","","2019-11-23 15:10:36","completed","",NULL),
("1628","0","5.209.217.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-23 16:20:00","completed","",NULL),
("1629","0","217.218.67.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-23 16:27:54","completed","",NULL),
("1630","0","217.218.67.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-23 16:28:49","completed","",NULL),
("1631","0","82.102.13.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-23 16:34:03","completed","",NULL),
("1632","0","217.218.67.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-23 16:47:04","completed","",NULL),
("1633","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-23 19:42:57","completed","",NULL),
("1634","0","5.160.10.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-23 20:32:33","completed","",NULL),
("1635","0","5.160.10.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-23 20:39:43","completed","",NULL),
("1636","0","89.199.0.218","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A750FN) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-11-24 10:13:52","completed","",NULL),
("1637","0","89.199.0.218","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A750FN) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36","99","100","","2019-11-24 10:14:00","completed","",NULL),
("1638","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:24:00","completed","",NULL),
("1639","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:25:03","completed","",NULL),
("1640","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:25:23","completed","",NULL),
("1641","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:25:38","completed","",NULL),
("1642","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:25:52","completed","",NULL),
("1643","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:26:07","completed","",NULL),
("1644","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:26:23","completed","",NULL),
("1645","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:26:38","completed","",NULL),
("1646","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:26:53","completed","",NULL),
("1647","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:27:07","completed","",NULL),
("1648","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:27:23","completed","",NULL),
("1649","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:27:39","completed","",NULL),
("1650","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:27:55","completed","",NULL),
("1651","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:28:10","completed","",NULL),
("1652","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:28:26","completed","",NULL),
("1653","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:28:42","completed","",NULL),
("1654","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:28:58","completed","",NULL),
("1655","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:29:13","completed","",NULL),
("1656","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:29:29","completed","",NULL),
("1657","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:29:45","completed","",NULL),
("1658","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:30:00","completed","",NULL),
("1659","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:30:18","completed","",NULL),
("1660","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:30:34","completed","",NULL),
("1661","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:30:50","completed","",NULL),
("1662","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:31:06","completed","",NULL),
("1663","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:31:23","completed","",NULL),
("1664","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:31:39","completed","",NULL),
("1665","0","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-24 14:31:55","completed","",NULL),
("1666","0","5.239.165.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-24 15:25:17","completed","",NULL),
("1667","0","5.239.165.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-24 15:25:23","completed","",NULL),
("1668","0","5.239.165.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-24 15:25:51","completed","",NULL),
("1669","0","2.183.15.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-24 15:30:52","completed","",NULL),
("1670","0","95.82.18.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-24 17:28:44","completed","",NULL),
("1671","0","5.113.25.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-24 18:10:02","completed","",NULL),
("1672","0","5.113.25.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-24 18:10:05","completed","",NULL),
("1673","0","2.180.85.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-24 20:48:30","completed","",NULL),
("1674","0","217.218.67.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-24 22:10:14","completed","",NULL),
("1675","0","86.57.35.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-24 23:59:13","completed","",NULL),
("1676","0","86.57.35.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-25 00:06:02","completed","",NULL),
("1677","0","31.59.182.0","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-25 14:12:36","completed","",NULL),
("1678","0","31.59.182.0","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-11-25 14:16:14","completed","",NULL),
("1679","0","5.126.234.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-25 19:16:04","completed","",NULL),
("1680","0","5.126.234.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-25 19:17:08","completed","",NULL),
("1681","0","178.128.233.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-25 19:42:30","completed","",NULL),
("1682","0","178.128.233.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-25 19:43:50","completed","",NULL),
("1683","0","5.125.78.79","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-25 20:07:35","completed","",NULL),
("1684","0","5.125.78.79","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-25 20:09:15","completed","",NULL),
("1685","0","5.125.78.79","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-25 20:10:55","completed","",NULL),
("1686","0","178.131.121.2","Mozilla/5.0 (Linux; Android 9; SM-A750GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-11-25 22:28:21","completed","",NULL),
("1687","0","178.131.121.2","Mozilla/5.0 (Linux; Android 9; SM-A750GN) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-11-25 22:32:02","completed","",NULL),
("1688","0","5.127.54.190","Mozilla/5.0 (iPhone; CPU iPhone OS 12_1_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1","113","114","","2019-11-26 00:55:04","completed","",NULL),
("1689","0","5.78.144.161","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-11-26 01:02:26","completed","",NULL),
("1690","42","80.210.8.248","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","66","67","","2019-11-26 01:02:54","completed","",NULL),
("1691","0","46.225.193.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-26 01:57:19","completed","",NULL),
("1692","0","46.225.193.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-26 01:57:59","completed","",NULL),
("1693","0","5.213.131.229","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-26 06:11:26","completed","",NULL),
("1694","0","80.210.8.248","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","93","94","","2019-11-26 09:57:48","completed","",NULL),
("1695","0","80.210.8.248","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","97","98","","2019-11-26 09:58:18","completed","",NULL),
("1696","0","31.2.206.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-26 15:17:24","completed","",NULL),
("1697","0","5.114.56.245","Wget/1.19.1 (mingw32)","66","67","","2019-11-26 15:49:44","completed","",NULL),
("1698","52","2.180.52.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-26 18:26:59","completed","",NULL),
("1699","0","5.113.16.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-26 19:08:29","completed","",NULL),
("1700","0","5.113.16.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-26 19:08:33","completed","",NULL),
("1701","0","5.113.16.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-26 19:08:56","completed","",NULL),
("1702","0","5.113.16.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-26 19:09:00","completed","",NULL),
("1703","0","54.38.23.34","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-26 21:44:49","completed","",NULL),
("1704","0","46.225.55.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-26 22:32:37","completed","",NULL),
("1705","0","54.38.23.34","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","124","125","","2019-11-27 06:06:12","completed","",NULL),
("1706","0","185.180.15.205","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","68","69","","2019-11-27 10:12:08","completed","",NULL),
("1707","0","185.180.15.205","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36","93","94","","2019-11-27 10:14:50","completed","",NULL),
("1708","0","5.122.252.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-27 10:41:04","completed","",NULL),
("1709","0","5.122.252.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-27 10:41:38","completed","",NULL),
("1710","0","151.238.186.17","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-27 11:27:47","completed","",NULL),
("1711","0","89.187.177.77","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-27 14:55:19","completed","",NULL),
("1712","0","5.235.217.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-27 15:35:04","completed","",NULL),
("1713","0","5.113.170.21","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-27 16:58:22","completed","",NULL),
("1714","0","5.125.63.207","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-27 17:36:35","completed","",NULL),
("1715","0","5.116.169.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-27 18:07:31","completed","",NULL),
("1716","49","178.131.77.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-27 18:41:33","completed","",NULL),
("1717","0","100.88.244.192","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-27 18:43:34","completed","",NULL),
("1718","0","5.237.185.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-11-27 21:13:24","completed","",NULL),
("1719","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:32:47","completed","",NULL),
("1720","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:33:00","completed","",NULL),
("1721","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:33:03","completed","",NULL),
("1722","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:33:06","completed","",NULL),
("1723","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:33:13","completed","",NULL),
("1724","0","46.62.189.235","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-27 22:33:20","completed","",NULL),
("1725","0","212.86.81.7","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-28 06:42:45","completed","",NULL),
("1726","0","89.199.128.237","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-28 09:56:47","completed","",NULL),
("1727","0","188.136.144.43","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","66","67","","2019-11-28 10:37:46","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1728","0","5.202.211.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-28 11:54:10","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1729","0","5.202.211.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-28 11:54:20","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1730","0","5.202.211.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-28 11:54:26","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1731","0","5.202.211.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-28 11:54:33","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1732","0","84.241.63.147","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-28 12:54:06","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1733","0","188.211.191.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-28 13:04:36","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1734","0","188.211.191.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-28 13:05:20","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1735","0","5.121.176.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2019-11-28 13:38:03","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1736","0","212.103.50.243","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-28 15:16:00","completed","",NULL),
("1737","0","5.212.227.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-28 16:13:35","completed","",NULL),
("1738","0","217.60.230.163","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-28 16:32:53","completed","",NULL),
("1739","0","66.79.100.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-28 17:21:36","completed","",NULL),
("1740","0","89.187.177.51","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-29 00:16:13","completed","",NULL),
("1741","0","5.122.112.36","Mozilla/5.0 (Linux; U; Android 9; fa-ir; MI 8 Lite Build/PKQ1.181007.001) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/10.9.8-g","93","94","","2019-11-29 00:42:49","completed","",NULL),
("1742","0","62.102.129.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","113","114","","2019-11-29 01:53:06","completed","",NULL),
("1743","0","185.125.207.246","Mozilla/5.0 (Linux; Android 9; MAR-LX1M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-11-29 03:03:24","completed","",NULL),
("1744","0","151.240.128.54","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-29 12:09:37","completed","",NULL),
("1745","0","151.240.128.54","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-29 12:10:09","completed","",NULL),
("1746","0","151.240.128.54","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-29 12:10:24","completed","",NULL),
("1747","0","5.119.168.3","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-29 12:21:37","completed","",NULL),
("1748","0","151.240.128.54","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-11-29 12:29:14","completed","",NULL),
("1749","0","151.240.128.54","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-11-29 12:29:17","completed","",NULL),
("1750","0","151.240.128.54","Mozilla/5.0 (Linux; Android 9; SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-11-29 12:30:44","completed","",NULL),
("1751","0","5.121.212.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-29 13:14:28","completed","",NULL),
("1752","0","5.121.212.158","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 13:20:30","completed","",NULL),
("1753","0","5.116.19.122","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-29 13:26:04","completed","",NULL),
("1754","0","95.82.8.159","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-29 15:13:50","completed","",NULL),
("1755","0","146.0.42.49","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) CriOS/60.0.3112.89 Mobile/16G102 Safari/602.1","93","94","","2019-11-29 16:11:37","completed","",NULL),
("1756","0","146.0.42.49","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) CriOS/60.0.3112.89 Mobile/16G102 Safari/602.1","93","94","","2019-11-29 16:12:38","completed","",NULL),
("1757","0","31.57.234.61","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-29 16:15:14","completed","",NULL),
("1758","0","37.148.41.184","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 16:26:43","completed","",NULL),
("1759","0","100.88.248.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-29 16:30:42","completed","",NULL),
("1760","0","5.119.225.65","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-11-29 16:31:45","completed","",NULL),
("1761","0","93.117.11.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-29 17:09:39","completed","",NULL),
("1762","0","93.117.11.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-29 17:10:34","completed","",NULL),
("1763","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 17:26:00","completed","",NULL),
("1764","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","68","69","","2019-11-29 17:26:39","completed","",NULL),
("1765","0","37.59.140.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 17:31:35","completed","",NULL),
("1766","0","37.59.140.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-29 17:32:39","completed","",NULL),
("1767","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-29 17:36:02","completed","",NULL),
("1768","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 17:39:01","completed","",NULL),
("1769","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-29 17:45:41","completed","",NULL),
("1770","0","31.59.219.18","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI P7-L10) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36","93","94","","2019-11-29 17:49:06","completed","",NULL),
("1771","0","31.59.219.18","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI P7-L10) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36","93","94","","2019-11-29 17:49:06","completed","",NULL),
("1772","0","31.59.219.18","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI P7-L10) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36","93","94","","2019-11-29 17:49:35","completed","",NULL),
("1773","0","5.219.137.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-29 17:52:41","completed","",NULL),
("1774","0","5.113.213.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-29 18:12:55","completed","",NULL),
("1775","0","188.159.236.13","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-29 18:18:35","completed","",NULL),
("1776","0","5.126.211.61","Mozilla/5.0 (Linux; Android 7.0; SM-A510F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-11-29 18:34:48","completed","",NULL),
("1777","0","5.119.65.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-29 18:36:41","completed","",NULL),
("1778","0","93.117.11.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-29 18:36:53","completed","",NULL),
("1779","0","5.125.174.223","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.2 Safari/605.1.15","66","67","","2019-11-29 18:52:44","completed","",NULL),
("1780","0","2.190.169.88","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-29 18:55:49","completed","",NULL),
("1781","0","5.212.213.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 18:58:40","completed","",NULL),
("1782","0","5.126.181.63","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Safari/537.36","66","67","","2019-11-29 18:58:43","completed","",NULL),
("1783","0","5.239.179.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-11-29 18:59:56","completed","",NULL),
("1784","0","5.113.133.61","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36","66","67","","2019-11-29 19:01:51","completed","",NULL),
("1785","0","5.212.213.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-29 19:03:24","completed","",NULL),
("1786","0","93.117.11.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","97","98","","2019-11-29 19:09:09","completed","",NULL),
("1787","0","5.116.194.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-29 19:16:09","completed","",NULL),
("1788","0","91.184.64.168","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-11-29 19:20:26","completed","",NULL),
("1789","0","46.224.105.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","124","125","","2019-11-29 19:21:52","completed","",NULL),
("1790","0","5.126.181.63","Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-N920C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.1 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-11-29 19:41:01","completed","",NULL),
("1791","0","5.126.43.114","Mozilla/5.0 (Linux; Android 8.0.0; SM-G930F Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.108 Mobile Safari/537.36 Instagram 121.0.0.29.119 Android (26/8.0.0; 3","113","114","","2019-11-29 19:50:01","completed","",NULL),
("1792","0","5.126.43.114","Mozilla/5.0 (Linux; Android 8.0.0; SM-G930F Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.108 Mobile Safari/537.36 Instagram 121.0.0.29.119 Android (26/8.0.0; 3","66","67","","2019-11-29 19:50:40","completed","",NULL),
("1793","0","5.126.43.114","Mozilla/5.0 (Linux; Android 8.0.0; SM-G930F Build/R16NW; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.108 Mobile Safari/537.36 Instagram 121.0.0.29.119 Android (26/8.0.0; 3","66","67","","2019-11-29 19:50:40","completed","",NULL),
("1794","0","204.18.67.88","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-29 19:58:08","completed","",NULL),
("1795","0","204.18.67.88","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-11-29 20:02:51","completed","",NULL),
("1796","0","204.18.67.88","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-11-29 20:02:59","completed","",NULL),
("1797","0","86.57.79.45","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-29 20:28:53","completed","",NULL),
("1798","0","5.120.56.34","Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-29 23:59:48","completed","",NULL),
("1799","0","93.119.212.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-30 00:01:58","completed","",NULL),
("1800","0","204.18.212.103","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-30 00:04:42","completed","",NULL),
("1801","0","2.176.140.88","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","66","67","","2019-11-30 00:10:38","completed","",NULL),
("1802","0","89.199.124.243","Mozilla/5.0 (Linux; Android 7.1.2; Redmi 5A Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.98 Mobile Safari/537.36","66","67","","2019-11-30 02:51:43","completed","",NULL),
("1803","0","46.225.168.30","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-30 05:39:34","completed","",NULL),
("1804","0","5.201.178.199","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-11-30 09:04:38","completed","",NULL),
("1805","0","2.191.237.208","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36","93","94","","2019-11-30 10:09:04","completed","",NULL),
("1806","0","198.16.66.196","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-11-30 10:42:14","completed","",NULL),
("1807","0","94.23.150.74","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-30 10:53:37","completed","",NULL),
("1808","0","151.239.158.121","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Safari/605.1.15","66","67","","2019-11-30 10:53:40","completed","",NULL),
("1809","0","188.136.162.13","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","66","67","","2019-11-30 10:55:07","completed","",NULL),
("1810","0","188.136.162.13","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-30 10:56:14","completed","",NULL),
("1811","0","188.136.162.13","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","93","94","","2019-11-30 10:56:24","completed","",NULL),
("1812","0","5.117.156.84","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-11-30 13:02:39","completed","",NULL),
("1813","0","95.82.12.97","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-11-30 13:18:06","completed","",NULL),
("1814","0","95.82.12.97","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-30 13:18:37","completed","",NULL),
("1815","0","89.199.218.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-30 17:54:18","completed","",NULL),
("1816","0","89.199.218.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-11-30 17:56:15","completed","",NULL),
("1817","0","46.224.229.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-11-30 22:15:17","completed","",NULL),
("1818","0","62.168.186.66","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-11-30 22:48:32","completed","",NULL),
("1819","0","188.210.129.177","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36 OPR/65.0.3467.48","99","100","","2019-12-01 03:36:54","completed","",NULL),
("1820","0","188.210.129.177","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36 OPR/65.0.3467.48","68","69","","2019-12-01 03:37:23","completed","",NULL),
("1821","0","185.44.78.98","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-01 09:20:33","completed","",NULL),
("1822","0","185.44.78.98","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-01 09:27:18","completed","",NULL),
("1823","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:51:12","completed","",NULL),
("1824","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:52:14","completed","",NULL),
("1825","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:52:26","completed","",NULL),
("1826","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:52:38","completed","",NULL),
("1827","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:52:50","completed","",NULL),
("1828","0","178.131.146.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 09:57:25","completed","",NULL),
("1829","0","91.184.75.77","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-01 10:42:00","completed","",NULL),
("1830","0","82.102.10.22","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-12-01 16:00:28","completed","",NULL),
("1831","0","2.186.31.227","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-01 16:42:57","completed","",NULL),
("1832","0","46.245.38.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-01 17:43:46","completed","",NULL),
("1833","52","5.125.203.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-01 17:55:53","completed","",NULL),
("1834","0","86.57.46.17","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-01 18:34:20","completed","",NULL),
("1835","0","5.125.136.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-01 20:55:35","completed","",NULL),
("1836","0","5.126.112.224","Mozilla/5.0 (Linux; Android 9; JKM-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-02 00:06:26","completed","",NULL),
("1837","0","46.245.78.94","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36","113","114","","2019-12-02 00:45:39","completed","",NULL),
("1838","0","51.158.105.15","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-02 02:21:02","completed","",NULL),
("1839","0","198.23.143.126","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36 OPR/65.0.3467.48","99","100","","2019-12-02 02:54:43","completed","",NULL),
("1840","0","5.126.100.80","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-02 09:32:42","completed","",NULL),
("1841","0","5.126.100.80","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-02 09:45:27","completed","",NULL),
("1842","0","146.0.42.28","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) CriOS/60.0.3112.89 Mobile/16G102 Safari/602.1","66","67","","2019-12-02 15:53:24","completed","",NULL),
("1843","0","5.121.158.56","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-02 21:40:43","completed","",NULL),
("1844","0","5.121.158.56","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-02 21:41:08","completed","",NULL),
("1845","0","5.121.158.56","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-02 21:41:10","completed","",NULL),
("1846","0","87.107.208.195","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-03 00:35:01","completed","",NULL),
("1847","0","5.120.124.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-03 05:30:52","completed","",NULL),
("1848","0","5.120.124.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 05:40:55","completed","",NULL),
("1849","0","5.120.124.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 05:41:15","completed","",NULL),
("1850","0","91.92.212.128","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-03 09:39:36","completed","",NULL),
("1851","0","37.156.21.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-03 09:47:06","completed","",NULL),
("1852","0","62.102.135.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","101","102","","2019-12-03 12:40:23","completed","",NULL),
("1853","0","5.124.187.122","Mozilla/5.0 (Linux; Android 9; SM-A605F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-12-03 13:37:06","completed","",NULL),
("1854","0","37.27.213.103","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 14:07:58","completed","",NULL),
("1855","0","5.114.196.234","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-03 15:47:57","completed","",NULL),
("1856","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:11:07","completed","",NULL),
("1857","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:12:19","completed","",NULL),
("1858","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:12:32","completed","",NULL),
("1859","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:12:45","completed","",NULL),
("1860","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:12:57","completed","",NULL),
("1861","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:13:10","completed","",NULL),
("1862","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:13:23","completed","",NULL),
("1863","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:13:35","completed","",NULL),
("1864","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:13:47","completed","",NULL),
("1865","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:14:00","completed","",NULL),
("1866","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:14:13","completed","",NULL),
("1867","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:14:27","completed","",NULL),
("1868","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:14:40","completed","",NULL),
("1869","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:14:53","completed","",NULL),
("1870","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:15:08","completed","",NULL),
("1871","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:15:23","completed","",NULL),
("1872","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:15:36","completed","",NULL),
("1873","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:15:49","completed","",NULL),
("1874","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:16:02","completed","",NULL),
("1875","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:16:16","completed","",NULL),
("1876","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:16:30","completed","",NULL),
("1877","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:16:43","completed","",NULL),
("1878","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:16:56","completed","",NULL),
("1879","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:17:10","completed","",NULL),
("1880","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:17:24","completed","",NULL),
("1881","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:17:38","completed","",NULL),
("1882","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:17:52","completed","",NULL),
("1883","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 16:18:06","completed","",NULL),
("1884","0","5.119.94.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-03 20:18:31","completed","",NULL),
("1885","0","5.127.247.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 20:55:07","completed","",NULL),
("1886","0","5.127.247.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-03 20:55:07","completed","",NULL),
("1887","0","139.59.56.168","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2019-12-03 21:28:16","completed","",NULL),
("1888","0","2.191.26.187","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-04 01:08:34","completed","",NULL),
("1889","0","46.224.63.169","Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2019-12-04 06:49:57","completed","",NULL),
("1890","0","5.124.116.183","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-04 07:48:28","completed","",NULL),
("1891","0","89.235.98.167","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-12-04 10:31:36","completed","",NULL),
("1892","0","192.71.27.96","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-04 11:23:29","completed","",NULL),
("1893","0","192.71.27.96","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-04 11:25:22","completed","",NULL),
("1894","0","109.202.101.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-04 13:36:51","completed","",NULL),
("1895","0","37.137.215.148","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-04 15:14:18","completed","",NULL),
("1896","0","62.102.132.222","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-04 17:46:29","completed","",NULL),
("1897","0","62.102.132.222","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-04 18:28:14","completed","",NULL),
("1898","57","185.131.143.248","Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-04 22:49:41","completed","",NULL),
("1899","0","5.119.248.75","Mozilla/5.0 (Windows NT 6.1; rv:70.0) Gecko/20100101 Firefox/70.0","113","114","","2019-12-05 00:19:01","completed","",NULL),
("1900","0","37.255.94.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-05 00:35:11","completed","",NULL),
("1901","0","83.120.126.205","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-05 00:44:45","completed","",NULL),
("1902","0","109.230.76.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-05 10:57:40","completed","",NULL),
("1903","0","109.230.76.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-05 10:59:04","completed","",NULL),
("1904","0","109.230.76.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-05 12:49:17","completed","",NULL),
("1905","0","5.126.251.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-05 16:16:15","completed","",NULL),
("1906","0","5.126.21.238","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-05 17:53:32","completed","",NULL),
("1907","0","199.247.15.104","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-12-05 18:08:36","completed","",NULL),
("1908","0","89.198.103.187","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-06 01:05:44","completed","",NULL),
("1909","0","151.233.158.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-06 01:20:22","completed","",NULL),
("1910","0","217.171.150.129","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","99","100","","2019-12-06 02:25:08","completed","",NULL),
("1911","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-06 03:12:00","completed","",NULL),
("1912","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-06 03:12:05","completed","",NULL),
("1913","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-06 03:13:21","completed","",NULL),
("1914","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-06 03:16:59","completed","",NULL),
("1915","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-06 03:17:14","completed","",NULL),
("1916","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-06 03:18:58","completed","",NULL),
("1917","0","2.183.53.35","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-06 03:20:45","completed","",NULL),
("1918","0","95.174.65.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-06 04:32:54","completed","",NULL),
("1919","0","5.123.66.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-06 20:07:37","completed","",NULL),
("1920","0","151.235.222.30","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-06 21:16:32","completed","",NULL),
("1921","0","5.236.213.159","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-06 23:27:58","completed","",NULL),
("1922","0","185.103.84.178","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-07 00:08:07","completed","",NULL),
("1923","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-07 02:19:32","completed","",NULL),
("1924","0","5.121.11.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-07 02:45:41","completed","",NULL),
("1925","0","5.121.11.52","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","68","69","","2019-12-07 03:00:52","completed","",NULL),
("1926","0","5.121.11.52","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2019-12-07 03:02:53","completed","",NULL),
("1927","0","5.121.11.52","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2019-12-07 03:03:02","completed","",NULL),
("1928","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-07 03:13:37","completed","",NULL),
("1929","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-07 03:14:13","completed","",NULL),
("1930","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-12-07 03:14:19","completed","",NULL),
("1931","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-07 03:21:00","completed","",NULL),
("1932","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-07 03:21:10","completed","",NULL),
("1933","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2019-12-07 03:22:11","completed","",NULL),
("1934","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-07 03:22:59","completed","",NULL),
("1935","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-12-07 03:25:54","completed","",NULL),
("1936","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-07 03:28:48","completed","",NULL),
("1937","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-07 03:28:50","completed","",NULL),
("1938","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-07 03:29:48","completed","",NULL),
("1939","0","5.121.11.52","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-07 03:31:06","completed","",NULL),
("1940","0","5.117.165.90","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 09:45:23","completed","",NULL),
("1941","0","5.112.212.6","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-07 10:49:19","completed","",NULL),
("1942","0","151.238.109.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-07 11:51:12","completed","",NULL),
("1943","0","46.4.192.253","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.62","66","67","","2019-12-07 13:30:00","completed","",NULL),
("1944","0","91.184.78.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-07 16:59:42","completed","",NULL),
("1945","0","2.187.62.26","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-07 18:29:07","completed","",NULL),
("1946","0","91.184.78.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 20:32:04","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1947","0","46.41.249.88","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-07 21:06:09","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1948","0","198.143.178.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 21:35:30","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1949","0","91.184.78.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 22:03:58","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1950","0","188.212.74.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-07 22:34:29","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1951","67","188.212.74.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-07 22:41:38","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1952","67","188.212.74.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-07 22:41:41","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1953","67","188.212.74.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 22:43:11","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1954","67","188.212.74.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-07 22:43:11","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1955","0","151.232.172.152","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-08 00:53:22","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1956","0","151.232.172.152","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-08 00:55:52","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1957","0","192.15.2.53","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-08 01:53:50","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1958","0","192.15.2.53","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 01:54:34","redirected","تغییر مسیر به فایل راه دور.",NULL),
("1959","0","45.156.183.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-08 10:13:30","completed","",NULL),
("1960","0","5.119.228.241","Mozilla/5.0 (Linux; Android 9; ALP-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.73 Mobile Safari/537.36","113","114","","2019-12-08 10:45:00","completed","",NULL),
("1961","0","84.241.2.52","Mozilla/5.0 (iPhone; CPU iPhone OS 13_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0 Mobile/15E148 Safari/604.1","66","67","","2019-12-08 11:52:52","completed","",NULL),
("1962","0","84.241.2.52","Mozilla/5.0 (iPhone; CPU iPhone OS 13_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0 Mobile/15E148 Safari/604.1","66","67","","2019-12-08 11:52:55","completed","",NULL),
("1963","0","37.202.216.251","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-08 12:14:02","completed","",NULL),
("1964","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:29:30","completed","",NULL),
("1965","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:30:37","completed","",NULL),
("1966","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:30:49","completed","",NULL),
("1967","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:31:02","completed","",NULL),
("1968","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:31:14","completed","",NULL),
("1969","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:31:27","completed","",NULL),
("1970","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:31:39","completed","",NULL),
("1971","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:31:51","completed","",NULL),
("1972","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:32:04","completed","",NULL),
("1973","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:32:16","completed","",NULL),
("1974","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:32:29","completed","",NULL),
("1975","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:32:41","completed","",NULL),
("1976","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:32:54","completed","",NULL),
("1977","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:33:07","completed","",NULL),
("1978","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:33:21","completed","",NULL),
("1979","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:33:34","completed","",NULL),
("1980","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:33:47","completed","",NULL),
("1981","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:33:59","completed","",NULL),
("1982","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:34:12","completed","",NULL),
("1983","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:34:26","completed","",NULL),
("1984","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:34:39","completed","",NULL),
("1985","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:34:52","completed","",NULL),
("1986","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:35:17","completed","",NULL),
("1987","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:35:32","completed","",NULL),
("1988","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:35:45","completed","",NULL),
("1989","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:35:59","completed","",NULL),
("1990","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:36:12","completed","",NULL),
("1991","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:36:26","completed","",NULL),
("1992","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:36:40","completed","",NULL),
("1993","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-08 12:36:54","completed","",NULL),
("1994","0","167.114.92.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.62","66","67","","2019-12-08 15:43:56","completed","",NULL),
("1995","0","178.131.182.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-08 17:11:51","completed","",NULL),
("1996","0","5.123.186.214","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-08 19:41:48","completed","",NULL),
("1997","0","5.117.215.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-08 20:05:26","completed","",NULL),
("1998","0","2.190.228.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-08 22:54:43","completed","",NULL),
("1999","0","5.239.188.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-09 00:02:25","completed","",NULL),
("2000","0","5.239.188.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","97","98","","2019-12-09 00:03:37","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("2001","0","5.115.241.103","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 08:55:51","completed","",NULL),
("2002","0","5.126.91.241","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-09 09:18:33","completed","",NULL),
("2003","0","94.182.54.2","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-09 10:20:32","completed","",NULL),
("2004","0","83.123.48.123","Mozilla/5.0 (Linux; Android 9; Redmi Note 6 Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-09 10:33:44","completed","",NULL),
("2005","0","83.123.48.123","Mozilla/5.0 (Linux; Android 9; Redmi Note 6 Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-09 10:37:14","completed","",NULL),
("2006","68","94.182.54.2","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","101","102","","2019-12-09 11:15:59","completed","",NULL),
("2007","68","94.182.54.2","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-09 11:16:47","completed","",NULL),
("2008","0","5.114.152.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 14:10:09","completed","",NULL),
("2009","0","5.114.152.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-09 14:10:20","completed","",NULL),
("2010","0","5.114.152.253","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 14:10:27","completed","",NULL),
("2011","0","89.32.9.58","Mozilla/5.0 (Linux; Android 9; TA-1053) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-09 15:36:02","completed","",NULL),
("2012","0","89.32.9.58","Mozilla/5.0 (Linux; Android 9; TA-1053) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","99","100","","2019-12-09 15:36:09","completed","",NULL),
("2013","0","69.194.71.39","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 18:37:31","completed","",NULL),
("2014","0","5.125.65.15","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 18:59:56","completed","",NULL),
("2015","0","5.208.38.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-09 22:13:57","completed","",NULL),
("2016","0","31.59.114.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-10 01:01:18","completed","",NULL),
("2017","0","31.59.114.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-10 01:01:25","completed","",NULL),
("2018","0","46.2.188.176","Mozilla/5.0 (Linux; Android 8.0.0; PRA-LA1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","93","94","","2019-12-10 02:38:37","completed","",NULL),
("2019","0","46.2.188.176","Mozilla/5.0 (Linux; Android 8.0.0; PRA-LA1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","93","94","","2019-12-10 02:39:48","completed","",NULL),
("2020","0","5.122.205.89","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-10 02:43:56","completed","",NULL),
("2021","0","5.122.205.89","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-10 02:46:10","completed","",NULL),
("2022","0","5.236.142.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-10 09:32:28","completed","",NULL),
("2023","0","46.105.243.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.62","66","67","","2019-12-10 16:45:51","completed","",NULL),
("2024","0","195.181.117.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2019-12-10 18:34:51","completed","",NULL),
("2025","0","5.117.85.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-10 21:18:46","completed","",NULL),
("2026","0","51.38.120.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2019-12-10 22:42:19","completed","",NULL),
("2027","0","5.112.214.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2019-12-11 00:14:42","completed","",NULL),
("2028","0","5.126.174.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-11 02:32:02","completed","",NULL),
("2029","0","86.55.68.117","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-11 06:05:33","completed","",NULL),
("2030","0","86.55.68.117","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/78.0.3904.84 Mobile/15E148 Safari/605.1","93","94","","2019-12-11 06:12:22","completed","",NULL),
("2031","0","86.55.68.117","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/78.0.3904.84 Mobile/15E148 Safari/605.1","113","114","","2019-12-11 06:14:02","completed","",NULL),
("2032","0","5.120.171.111","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2019-12-11 06:40:24","completed","",NULL),
("2033","0","5.117.241.189","Mozilla/5.0 (Linux; Android 9; MRD-LX1F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-11 12:10:42","completed","",NULL),
("2034","0","5.117.241.189","Mozilla/5.0 (Linux; Android 9; MRD-LX1F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-11 12:10:46","completed","",NULL),
("2035","0","5.126.96.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-11 12:14:33","completed","",NULL),
("2036","0","89.199.108.105","Mozilla/5.0 (Linux; Android 8.0.0; WAS-LX1A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-12-11 15:13:45","completed","",NULL),
("2037","0","54.38.99.222","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-12-11 15:45:33","completed","",NULL),
("2038","0","109.230.76.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-11 16:08:39","completed","",NULL),
("2039","0","163.172.210.147","Mozilla/5.0 (Linux; Android 9; Mi 9T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-11 18:47:27","completed","",NULL),
("2040","0","151.238.248.9","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-11 19:39:15","completed","",NULL),
("2041","0","5.127.91.105","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-11 21:41:46","completed","",NULL),
("2042","0","5.250.48.143","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-12 00:01:34","completed","",NULL),
("2043","0","5.123.150.11","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-12 00:45:41","completed","",NULL),
("2044","0","46.248.63.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-12 00:53:45","completed","",NULL),
("2045","0","46.248.63.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 00:56:24","completed","",NULL),
("2046","0","46.248.63.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 00:57:40","completed","",NULL),
("2047","0","5.120.108.37","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 01:05:24","completed","",NULL),
("2048","0","46.248.63.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-12 01:23:03","completed","",NULL),
("2049","0","89.199.223.19","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 07:14:09","completed","",NULL),
("2050","0","89.187.177.51","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-12-12 10:22:22","completed","",NULL),
("2051","0","89.187.177.51","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-12-12 10:24:18","completed","",NULL),
("2052","0","95.80.182.45","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 10:38:05","completed","",NULL),
("2053","0","86.55.89.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 13:04:00","completed","",NULL),
("2054","0","188.210.107.5","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 13:35:33","completed","",NULL),
("2055","0","188.210.107.5","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 13:35:34","completed","",NULL),
("2056","0","188.210.107.5","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-12 13:35:40","completed","",NULL),
("2057","0","89.187.177.51","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-12-12 13:35:42","completed","",NULL),
("2058","0","46.225.202.118","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-12 15:12:57","completed","",NULL),
("2059","0","46.225.202.118","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","124","125","","2019-12-12 15:32:34","completed","",NULL),
("2060","0","46.225.202.118","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","93","94","","2019-12-12 15:32:43","completed","",NULL),
("2061","0","46.225.202.118","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","66","67","","2019-12-12 15:32:54","completed","",NULL),
("2062","0","46.225.202.118","Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; WOW64; Trident/7.0)","113","114","","2019-12-12 15:33:03","completed","",NULL),
("2063","0","185.217.68.251","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 17:38:58","completed","",NULL),
("2064","0","5.116.144.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.62","93","94","","2019-12-12 17:45:35","completed","",NULL),
("2065","0","5.219.192.93","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 19:37:45","completed","",NULL),
("2066","0","95.179.210.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-12-12 20:20:48","completed","",NULL),
("2067","72","95.179.210.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-12-12 20:24:46","completed","",NULL),
("2068","0","185.217.68.224","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-12 20:30:05","completed","",NULL),
("2069","0","5.234.246.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-12 22:33:19","completed","",NULL),
("2070","0","46.245.90.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-12 22:53:41","completed","",NULL),
("2071","0","5.124.179.12","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-12 22:53:46","completed","",NULL),
("2072","0","5.124.21.243","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-12 23:00:24","completed","",NULL),
("2073","0","5.210.242.245","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-13 00:38:09","completed","",NULL),
("2074","0","89.187.177.46","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-13 02:32:17","completed","",NULL),
("2075","0","37.129.28.94","Mozilla/5.0 (Linux; Android 6.0.1; SM-N910H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-13 13:04:31","completed","",NULL),
("2076","0","83.123.227.201","Mozilla/5.0 (Linux; Android 6.0.1; SM-N910H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-13 14:31:12","completed","",NULL),
("2077","0","83.123.227.201","Mozilla/5.0 (Linux; Android 6.0.1; SM-N910H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-13 14:31:46","completed","",NULL),
("2078","0","5.116.143.159","Mozilla/5.0 (Linux; Android 6.0.1; LG-K500) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-13 16:18:06","completed","",NULL),
("2079","0","94.182.237.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-13 20:10:36","completed","",NULL),
("2080","0","5.106.134.134","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-13 20:28:25","completed","",NULL),
("2081","0","5.106.134.134","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-13 21:21:26","completed","",NULL),
("2082","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-14 02:13:47","completed","",NULL),
("2083","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-14 02:22:03","completed","",NULL),
("2084","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-14 02:23:04","completed","",NULL),
("2085","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","113","114","","2019-12-14 02:23:08","completed","",NULL),
("2086","0","37.255.22.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","124","125","","2019-12-14 02:30:09","completed","",NULL),
("2087","0","5.112.103.17","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","124","125","","2019-12-14 03:09:09","completed","",NULL),
("2088","0","5.112.103.17","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","124","125","","2019-12-14 03:09:23","completed","",NULL),
("2089","0","5.113.7.0","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-14 04:49:48","completed","",NULL),
("2090","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-14 05:56:42","completed","",NULL),
("2091","0","5.126.15.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-14 05:56:57","completed","",NULL),
("2092","0","198.16.66.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-14 09:49:34","completed","",NULL),
("2093","0","5.115.164.207","Mozilla/5.0 (Linux; Android 9; Redmi Note 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","97","98","","2019-12-14 16:36:18","completed","",NULL),
("2094","0","54.39.233.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.62","93","94","","2019-12-14 16:47:56","completed","",NULL),
("2095","0","2.176.132.6","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-14 16:57:19","completed","",NULL),
("2096","0","178.252.135.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-14 17:18:50","completed","",NULL),
("2097","0","5.122.32.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-14 21:10:50","completed","",NULL),
("2098","0","5.74.11.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","93","94","","2019-12-14 22:40:10","completed","",NULL),
("2099","0","5.210.154.159","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-14 22:55:57","completed","",NULL),
("2100","0","151.233.201.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-15 12:38:21","completed","",NULL),
("2101","0","151.233.201.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-15 12:45:54","completed","",NULL),
("2102","0","5.62.190.167","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-15 13:28:51","completed","",NULL),
("2103","0","2001:ac8:31:98:7654:0:964:1030","Mozilla/5.0 (Linux; Android 8.0.0; ASUS_Z017D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","124","125","","2019-12-15 13:37:27","completed","",NULL),
("2104","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:37:50","completed","",NULL),
("2105","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:38:54","completed","",NULL),
("2106","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:39:00","completed","",NULL),
("2107","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:40:14","completed","",NULL),
("2108","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:40:28","completed","",NULL),
("2109","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:42:16","completed","",NULL),
("2110","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:42:29","completed","",NULL),
("2111","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:42:41","completed","",NULL),
("2112","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","93","94","","2019-12-15 13:42:53","completed","",NULL),
("2113","0","185.162.40.107","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","66","67","","2019-12-15 13:57:51","completed","",NULL),
("2114","0","185.162.40.107","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","97","98","","2019-12-15 13:59:03","completed","",NULL),
("2115","0","151.233.201.48","Mozilla/5.0 (Linux; Android 9; SM-A750F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-15 14:13:39","completed","",NULL),
("2116","0","2.179.61.168","Mozilla/5.0 (Windows NT 6.1; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-15 14:33:13","completed","",NULL),
("2117","0","2.179.61.168","Mozilla/5.0 (Windows NT 6.1; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-15 14:35:39","completed","",NULL),
("2118","0","151.238.150.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-15 18:21:35","completed","",NULL),
("2119","0","95.162.194.250","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-15 22:28:04","completed","",NULL),
("2120","0","5.124.132.39","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","124","125","","2019-12-16 01:52:39","completed","",NULL),
("2121","0","5.124.132.39","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-16 01:54:07","completed","",NULL),
("2122","0","54.38.156.210","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2019-12-16 02:27:01","completed","",NULL),
("2123","0","31.59.212.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-16 13:56:05","completed","",NULL),
("2124","0","31.59.212.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-16 13:57:02","completed","",NULL),
("2125","0","31.59.212.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-16 13:57:03","completed","",NULL),
("2126","0","31.59.212.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-16 13:57:06","completed","",NULL),
("2127","0","31.59.212.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-16 14:03:45","completed","",NULL),
("2128","0","176.101.33.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 16:46:07","completed","",NULL),
("2129","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:49:01","completed","",NULL),
("2130","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:50:02","completed","",NULL),
("2131","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:50:16","completed","",NULL),
("2132","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:50:29","completed","",NULL),
("2133","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:50:41","completed","",NULL),
("2134","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:50:54","completed","",NULL),
("2135","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:51:07","completed","",NULL),
("2136","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:51:20","completed","",NULL),
("2137","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:51:32","completed","",NULL),
("2138","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:51:45","completed","",NULL),
("2139","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:51:57","completed","",NULL),
("2140","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:52:09","completed","",NULL),
("2141","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:52:22","completed","",NULL),
("2142","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:52:34","completed","",NULL),
("2143","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:52:47","completed","",NULL),
("2144","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:53:00","completed","",NULL),
("2145","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:53:13","completed","",NULL),
("2146","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:53:27","completed","",NULL),
("2147","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:53:40","completed","",NULL),
("2148","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:53:53","completed","",NULL),
("2149","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:54:06","completed","",NULL),
("2150","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:54:20","completed","",NULL),
("2151","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:54:33","completed","",NULL),
("2152","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:54:47","completed","",NULL),
("2153","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:55:00","completed","",NULL),
("2154","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:55:15","completed","",NULL),
("2155","0","188.212.245.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-16 17:55:29","completed","",NULL),
("2156","0","5.236.188.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-16 18:42:14","completed","",NULL),
("2157","0","5.117.85.28","Mozilla/5.0 (Linux; Android 6.0.1; LG-K500) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-16 21:46:34","completed","",NULL),
("2158","0","5.123.200.186","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-16 22:48:54","completed","",NULL),
("2159","0","31.133.0.125","Mozilla/5.0 (Linux; Android 9; SM-A107F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-17 00:44:39","completed","",NULL),
("2160","0","188.151.45.213","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-17 01:27:41","completed","",NULL),
("2161","0","188.151.45.213","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","99","100","","2019-12-17 02:33:39","completed","",NULL),
("2162","0","188.151.45.213","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","68","69","","2019-12-17 02:33:47","completed","",NULL),
("2163","0","198.20.116.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-17 09:44:37","completed","",NULL),
("2164","0","5.236.188.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-17 10:52:37","completed","",NULL),
("2165","0","217.79.185.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-12-17 13:03:57","completed","",NULL),
("2166","0","5.121.111.151","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-17 14:21:38","completed","",NULL),
("2167","0","31.58.226.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","99","100","","2019-12-17 17:03:42","completed","",NULL),
("2168","0","31.58.226.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","97","98","","2019-12-17 17:03:50","completed","",NULL),
("2169","0","31.58.226.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-17 17:10:45","completed","",NULL),
("2170","0","51.79.19.31","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-17 23:19:43","completed","",NULL),
("2171","0","5.126.15.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-17 23:46:41","completed","",NULL),
("2172","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","97","98","","2019-12-17 23:50:25","completed","",NULL),
("2173","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","97","98","","2019-12-17 23:50:32","completed","",NULL),
("2174","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","99","100","","2019-12-17 23:51:18","completed","",NULL),
("2175","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","113","114","","2019-12-17 23:58:15","completed","",NULL),
("2176","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","97","98","","2019-12-17 23:59:26","completed","",NULL),
("2177","0","5.119.228.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","124","125","","2019-12-18 00:00:29","completed","",NULL),
("2178","0","5.116.179.192","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-18 05:42:28","completed","",NULL),
("2179","0","213.67.78.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-18 08:11:06","completed","",NULL),
("2180","0","176.9.251.236","Mozilla/5.0 (Linux; Android 10; SM-G973F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-18 11:14:44","completed","",NULL),
("2181","0","5.116.37.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","124","125","","2019-12-18 13:21:36","completed","",NULL),
("2182","0","86.57.89.183","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-18 19:07:59","completed","",NULL),
("2183","0","151.242.96.34","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-18 23:42:48","completed","",NULL),
("2184","0","151.242.96.34","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2019-12-18 23:51:13","completed","",NULL),
("2185","0","151.242.96.34","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-18 23:52:16","completed","",NULL),
("2186","0","151.242.96.34","Mozilla/5.0 (Linux; Android 6.0; HUAWEI MT7-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-18 23:53:06","completed","",NULL),
("2187","0","195.181.126.67","Mozilla/5.0 (Android 8.0.0; Mobile; rv:68.0) Gecko/68.0 Firefox/68.0","66","67","","2019-12-19 01:23:00","completed","",NULL),
("2188","0","31.59.135.136","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","124","125","","2019-12-19 03:01:39","completed","",NULL),
("2189","0","31.59.135.136","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2019-12-19 03:04:26","completed","",NULL),
("2190","0","188.212.206.236","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-19 15:44:12","completed","",NULL),
("2191","0","188.212.206.236","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-19 15:45:12","completed","",NULL),
("2192","0","188.212.206.236","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-19 15:46:46","completed","",NULL),
("2193","0","5.123.117.231","Mozilla/5.0 (Linux; Android 9; SM-A605F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-12-19 20:21:23","completed","",NULL),
("2194","0","5.116.144.255","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-19 21:38:05","completed","",NULL),
("2195","0","85.185.210.89","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-19 22:31:15","completed","",NULL),
("2196","0","178.131.138.103","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-20 00:10:22","completed","",NULL),
("2197","0","178.131.107.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","113","114","","2019-12-20 00:23:28","completed","",NULL),
("2198","0","178.131.107.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","99","100","","2019-12-20 00:25:22","completed","",NULL),
("2199","0","178.131.107.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 00:25:24","completed","",NULL),
("2200","0","151.233.72.51","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-20 00:40:22","completed","",NULL),
("2201","0","46.245.127.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 00:57:40","completed","",NULL),
("2202","0","31.58.18.202","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-20 01:09:12","completed","",NULL),
("2203","0","31.58.18.202","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 01:09:39","completed","",NULL),
("2204","0","178.131.151.211","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0","93","94","","2019-12-20 01:36:24","completed","",NULL),
("2205","0","94.23.166.49","Mozilla/5.0 (iPad; CPU OS 10_3_4 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) CriOS/71.0.3578.89 Mobile/14G61 Safari/602.1","66","67","","2019-12-20 01:38:52","completed","",NULL),
("2206","0","94.23.166.49","Mozilla/5.0 (iPad; CPU OS 10_3_4 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) CriOS/71.0.3578.89 Mobile/14G61 Safari/602.1","113","114","","2019-12-20 02:38:19","completed","",NULL),
("2207","0","82.145.42.114","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0","66","67","","2019-12-20 02:39:06","completed","",NULL),
("2208","0","5.112.73.53","Mozilla/5.0 (Linux; Android 9; POCOPHONE F1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-20 03:18:02","completed","",NULL),
("2209","0","5.112.73.53","Mozilla/5.0 (Linux; Android 9; POCOPHONE F1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","124","125","","2019-12-20 03:19:23","completed","",NULL),
("2210","0","5.112.73.53","Mozilla/5.0 (Linux; Android 9; POCOPHONE F1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","124","125","","2019-12-20 03:19:28","completed","",NULL),
("2211","0","37.129.241.219","Mozilla/5.0 (Linux; Android 9; SM-J730F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","68","69","","2019-12-20 04:37:34","completed","",NULL),
("2212","0","37.129.241.219","Mozilla/5.0 (Linux; Android 9; SM-J730F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","99","100","","2019-12-20 04:37:48","completed","",NULL),
("2213","0","37.129.241.219","Mozilla/5.0 (Linux; Android 9; SM-J730F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","113","114","","2019-12-20 04:40:05","completed","",NULL),
("2214","0","37.129.176.139","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2019-12-20 09:53:51","completed","",NULL),
("2215","0","213.67.78.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 10:01:40","completed","",NULL),
("2216","0","213.67.78.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-20 10:01:54","completed","",NULL),
("2217","0","213.67.78.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-20 10:01:56","completed","",NULL),
("2218","80","188.212.245.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-20 10:03:40","completed","",NULL),
("2219","0","5.114.140.18","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 10:10:22","completed","",NULL),
("2220","0","5.113.163.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-20 10:12:30","completed","",NULL),
("2221","0","86.57.103.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","64","65","","2019-12-20 10:36:24","completed","",NULL),
("2222","0","86.57.103.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-20 10:36:39","completed","",NULL),
("2223","0","86.57.103.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-20 10:38:27","completed","",NULL),
("2224","0","95.82.52.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15","66","67","","2019-12-20 10:55:32","completed","",NULL),
("2225","0","95.82.52.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15","113","114","","2019-12-20 10:56:56","completed","",NULL),
("2226","0","95.82.52.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15","66","67","","2019-12-20 10:58:43","completed","",NULL),
("2227","0","95.82.52.228","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15","93","94","","2019-12-20 10:59:50","completed","",NULL),
("2228","0","5.106.112.83","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2019-12-20 11:48:39","completed","",NULL),
("2229","0","77.77.105.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 11:53:53","completed","",NULL),
("2230","0","77.77.105.79","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 11:54:24","completed","",NULL),
("2231","0","5.119.185.190","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 11:57:39","completed","",NULL),
("2232","0","5.106.112.83","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","113","114","","2019-12-20 12:12:32","completed","",NULL),
("2233","0","5.106.112.83","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-12-20 12:12:51","completed","",NULL),
("2234","0","46.224.146.162","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","113","114","","2019-12-20 12:25:34","completed","",NULL),
("2235","0","85.203.44.20","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-20 12:26:50","completed","",NULL),
("2236","0","93.119.220.62","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-20 12:38:20","completed","",NULL),
("2237","0","46.224.49.236","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 12:41:16","completed","",NULL),
("2238","0","5.78.41.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","97","98","","2019-12-20 12:49:28","completed","",NULL),
("2239","0","46.245.127.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-20 12:54:16","completed","",NULL),
("2240","0","83.120.132.236","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 12:54:32","completed","",NULL),
("2241","0","46.245.127.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 12:58:33","completed","",NULL),
("2242","0","46.245.127.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","95","96","","2019-12-20 12:58:40","completed","",NULL),
("2243","0","37.129.117.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 13:18:49","completed","",NULL),
("2244","0","2.190.89.168","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-20 13:34:40","completed","",NULL),
("2245","0","5.235.31.63","Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","66","67","","2019-12-20 13:38:56","completed","",NULL),
("2246","0","104.222.32.157","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 13:47:00","completed","",NULL),
("2247","0","83.122.243.109","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","124","125","","2019-12-20 14:00:47","completed","",NULL),
("2248","0","5.113.251.179","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","93","94","","2019-12-20 14:32:00","completed","",NULL),
("2249","0","158.255.211.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","93","94","","2019-12-20 14:46:36","completed","",NULL),
("2250","0","5.113.251.179","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","124","125","","2019-12-20 14:51:29","completed","",NULL),
("2251","0","158.255.211.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","97","98","","2019-12-20 14:54:07","completed","",NULL),
("2252","0","109.125.151.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-20 14:56:27","completed","",NULL),
("2253","0","188.159.146.207","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","113","114","","2019-12-20 14:56:48","completed","",NULL),
("2254","0","5.126.193.97","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","66","67","","2019-12-20 15:09:54","completed","",NULL),
("2255","0","5.120.107.247","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 15:16:45","completed","",NULL),
("2256","0","5.116.106.207","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_3 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) GSA/41.0.178428663 Mobile/17A878 Safari/604.1","113","114","","2019-12-20 15:22:58","completed","",NULL),
("2257","0","5.116.106.207","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_3 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) GSA/41.0.178428663 Mobile/17A878 Safari/604.1","99","100","","2019-12-20 15:24:11","completed","",NULL),
("2258","0","46.224.105.137","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2019-12-20 15:44:07","completed","",NULL),
("2259","0","5.126.193.97","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","113","114","","2019-12-20 15:50:05","completed","",NULL),
("2260","0","5.126.193.97","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2019-12-20 15:51:09","completed","",NULL),
("2261","0","151.243.27.37","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 15:52:40","completed","",NULL),
("2262","0","5.234.243.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-20 16:18:47","completed","",NULL),
("2263","0","5.116.106.207","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_3 like Mac OS X) AppleWebKit/604.1.34 (KHTML, like Gecko) GSA/41.0.178428663 Mobile/17A878 Safari/604.1","93","94","","2019-12-20 16:25:55","completed","",NULL),
("2264","0","46.62.207.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 17:33:57","completed","",NULL),
("2265","0","37.32.23.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-20 17:35:22","completed","",NULL),
("2266","0","5.212.42.77","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 17:45:07","completed","",NULL),
("2267","0","5.119.56.219","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 17:49:09","completed","",NULL),
("2268","0","86.57.43.203","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 18:02:21","completed","",NULL),
("2269","0","95.82.59.213","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 18:10:38","completed","",NULL),
("2270","0","185.103.84.146","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","99","100","","2019-12-20 18:14:50","completed","",NULL),
("2271","0","2.178.133.49","Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-N910C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-12-20 18:19:11","completed","",NULL),
("2272","0","2.178.133.49","Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-N910C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-12-20 18:19:24","completed","",NULL),
("2273","0","2.178.133.49","Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-N910C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2019-12-20 18:19:39","completed","",NULL),
("2274","0","86.55.142.165","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-20 18:51:19","completed","",NULL),
("2275","0","217.219.134.219","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2019-12-20 19:20:13","completed","",NULL),
("2276","0","95.82.12.248","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","113","114","","2019-12-20 19:43:24","completed","",NULL),
("2277","0","95.82.12.248","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","113","114","","2019-12-20 19:43:43","completed","",NULL),
("2278","0","95.82.12.248","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","70","71","","2019-12-20 19:44:06","completed","",NULL),
("2279","0","5.219.66.115","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-20 19:44:29","completed","",NULL),
("2280","0","151.238.248.136","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-20 19:44:53","completed","",NULL),
("2281","0","85.203.44.169","Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.1 Mobile/15E148 Safari/604.1","113","114","","2019-12-20 20:32:11","completed","",NULL),
("2282","0","84.17.47.122","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 20:38:13","completed","",NULL),
("2283","0","45.9.249.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.72","93","94","","2019-12-20 20:45:01","completed","",NULL),
("2284","0","5.126.179.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-20 21:35:53","completed","",NULL),
("2285","0","5.113.251.179","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","66","67","","2019-12-20 21:37:48","completed","",NULL),
("2286","0","91.184.77.14","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-20 21:45:26","completed","",NULL),
("2287","0","37.98.28.253","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","66","67","","2019-12-20 21:56:42","completed","",NULL),
("2288","85","217.219.134.219","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","101","102","","2019-12-20 22:08:24","completed","",NULL),
("2289","85","217.219.134.219","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","97","98","","2019-12-20 22:08:37","completed","",NULL),
("2290","0","45.41.138.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-20 23:02:48","completed","",NULL),
("2291","0","151.238.146.109","Mozilla/5.0 (Linux; Android 7.1.2; Redmi 5A Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-12-20 23:09:03","completed","",NULL),
("2292","0","151.238.146.109","Mozilla/5.0 (Linux; Android 7.1.2; Redmi 5A Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-12-20 23:09:50","completed","",NULL),
("2293","0","151.238.146.109","Mozilla/5.0 (Linux; Android 7.1.2; Redmi 5A Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-12-20 23:10:22","completed","",NULL),
("2294","0","5.120.46.174","Mozilla/5.0 (Linux; Android 8.0.0; LND-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","93","94","","2019-12-20 23:17:56","completed","",NULL),
("2295","0","151.239.133.236","Mozilla/5.0 (Linux; Android 7.0; FRD-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","66","67","","2019-12-21 00:09:09","completed","",NULL),
("2296","0","151.239.133.236","Mozilla/5.0 (Linux; Android 7.0; FRD-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","113","114","","2019-12-21 00:10:37","completed","",NULL),
("2297","0","151.239.133.236","Mozilla/5.0 (Linux; Android 7.0; FRD-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","99","100","","2019-12-21 00:10:58","completed","",NULL),
("2298","0","151.239.133.236","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 00:12:30","completed","",NULL),
("2299","0","5.114.106.218","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","93","94","","2019-12-21 08:09:07","completed","",NULL),
("2300","0","5.114.106.218","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","93","94","","2019-12-21 08:12:29","completed","",NULL),
("2301","0","5.122.85.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-21 10:10:51","completed","",NULL),
("2302","0","5.212.61.126","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-21 11:09:51","completed","",NULL),
("2303","0","2.181.252.111","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-21 12:27:46","completed","",NULL),
("2304","0","2.187.108.217","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 13:56:44","completed","",NULL),
("2305","0","45.76.46.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-21 16:23:18","completed","",NULL),
("2306","0","45.76.46.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-21 16:23:23","completed","",NULL),
("2307","0","185.136.103.73","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-21 16:47:15","completed","",NULL),
("2308","1","5.117.216.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","64","65","","2019-12-21 17:03:50","completed","",NULL),
("2309","0","5.126.188.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-21 19:16:36","completed","",NULL),
("2310","0","5.114.106.218","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-21 19:22:07","completed","",NULL),
("2311","0","5.114.106.218","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-21 19:23:13","completed","",NULL),
("2312","52","5.126.188.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-21 19:29:15","completed","",NULL),
("2313","52","5.126.188.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 19:36:39","completed","",NULL),
("2314","52","5.126.188.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 19:36:40","completed","",NULL),
("2315","52","5.126.188.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 19:36:41","completed","",NULL),
("2316","0","77.237.182.1","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-21 20:05:44","completed","",NULL),
("2317","0","31.59.214.221","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-21 21:00:52","completed","",NULL),
("2318","0","5.114.223.47","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Mobile/15E148 Safari/604.1","113","114","","2019-12-21 21:56:15","completed","",NULL),
("2319","0","5.119.73.209","Mozilla/5.0 (Linux; Android 9; Mi A2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2019-12-22 01:11:36","completed","",NULL),
("2320","0","2.181.252.111","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-22 10:04:50","completed","",NULL),
("2321","0","5.119.128.54","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15","124","125","","2019-12-22 10:51:52","completed","",NULL),
("2322","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:54:37","completed","",NULL),
("2323","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:55:31","completed","",NULL),
("2324","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:55:43","completed","",NULL),
("2325","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:55:55","completed","",NULL),
("2326","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:56:08","completed","",NULL),
("2327","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:56:21","completed","",NULL),
("2328","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:56:34","completed","",NULL),
("2329","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:56:47","completed","",NULL),
("2330","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:56:59","completed","",NULL),
("2331","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:57:12","completed","",NULL),
("2332","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:57:25","completed","",NULL),
("2333","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:57:38","completed","",NULL),
("2334","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:57:51","completed","",NULL),
("2335","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:58:04","completed","",NULL),
("2336","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:58:17","completed","",NULL),
("2337","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:58:30","completed","",NULL),
("2338","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:58:43","completed","",NULL),
("2339","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:58:56","completed","",NULL),
("2340","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:59:09","completed","",NULL),
("2341","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:59:23","completed","",NULL),
("2342","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:59:37","completed","",NULL),
("2343","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 12:59:50","completed","",NULL),
("2344","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:00:03","completed","",NULL),
("2345","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:00:20","completed","",NULL),
("2346","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:00:33","completed","",NULL),
("2347","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:00:47","completed","",NULL),
("2348","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:01:00","completed","",NULL),
("2349","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:01:14","completed","",NULL),
("2350","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:01:28","completed","",NULL),
("2351","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:01:42","completed","",NULL),
("2352","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:01:56","completed","",NULL),
("2353","0","178.131.221.133","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:02:09","completed","",NULL),
("2354","0","5.120.60.15","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-22 13:19:09","completed","",NULL),
("2355","0","109.203.187.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-22 13:21:16","completed","",NULL),
("2356","0","95.82.37.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-22 13:39:21","completed","",NULL),
("2357","0","151.243.29.196","Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-22 15:32:19","completed","",NULL),
("2358","0","5.123.240.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-22 20:12:11","completed","",NULL),
("2359","0","5.120.189.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","66","67","","2019-12-22 21:59:08","completed","",NULL),
("2360","0","5.190.90.8","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-12-22 23:19:16","completed","",NULL),
("2361","0","5.190.90.8","Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1","66","67","","2019-12-22 23:20:38","completed","",NULL),
("2362","0","5.120.189.99","Mozilla/5.0 (Linux; Android 9; Mi A2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2019-12-23 00:48:29","completed","",NULL),
("2363","0","5.120.189.99","Mozilla/5.0 (Linux; Android 9; Mi A2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2019-12-23 17:52:22","completed","",NULL),
("2364","0","5.120.189.99","Mozilla/5.0 (Linux; Android 9; Mi A2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2019-12-23 17:52:51","completed","",NULL),
("2365","0","45.32.159.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-23 18:33:27","completed","",NULL),
("2366","0","5.116.122.112","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-23 18:33:48","completed","",NULL),
("2367","0","45.32.159.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-23 18:33:50","completed","",NULL),
("2368","0","46.225.50.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-23 21:10:54","completed","",NULL),
("2369","0","8.43.121.32","Mozilla/5.0 (Linux; Android 9; Nokia 7 plus) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-23 22:16:58","completed","",NULL),
("2370","0","5.120.189.99","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","66","67","","2019-12-23 22:42:12","completed","",NULL),
("2371","0","5.234.183.41","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/604.1","93","94","","2019-12-23 23:26:11","completed","",NULL),
("2372","0","31.40.5.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","113","114","","2019-12-24 02:32:23","completed","",NULL),
("2373","0","113.203.55.22","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-24 06:32:20","completed","",NULL),
("2374","0","113.203.55.22","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-24 06:32:23","completed","",NULL),
("2375","0","113.203.55.22","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-24 06:32:24","completed","",NULL),
("2376","0","113.203.55.22","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","66","67","","2019-12-24 06:32:40","completed","",NULL),
("2377","0","113.203.55.22","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Mobile Safari/537.36","99","100","","2019-12-24 06:40:26","completed","",NULL),
("2378","0","37.27.232.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-24 11:19:30","completed","",NULL),
("2379","0","31.214.147.239","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36","93","94","","2019-12-24 11:52:39","completed","",NULL),
("2380","0","5.117.92.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-24 13:53:51","completed","",NULL),
("2381","0","185.192.70.3","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-25 02:29:03","completed","",NULL),
("2382","0","185.192.70.3","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-25 02:29:04","completed","",NULL),
("2383","0","31.47.57.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-25 08:19:38","completed","",NULL),
("2384","0","83.123.231.7","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2019-12-25 08:37:47","completed","",NULL),
("2385","0","5.200.146.224","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-25 13:42:32","completed","",NULL),
("2386","0","5.200.146.224","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-25 13:50:29","completed","",NULL),
("2387","88","5.200.146.224","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-25 14:41:45","completed","",NULL),
("2388","88","5.200.146.224","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-25 14:41:46","completed","",NULL),
("2389","88","5.200.146.224","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","97","98","","2019-12-25 14:41:52","completed","",NULL),
("2390","0","5.210.209.160","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","66","67","","2019-12-25 14:55:47","completed","",NULL),
("2391","0","78.39.215.90","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","101","102","","2019-12-25 17:57:34","completed","",NULL),
("2392","0","151.238.138.205","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-12-25 21:03:53","completed","",NULL),
("2393","0","2.187.89.73","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-25 22:25:23","completed","",NULL),
("2394","0","8.43.121.54","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","124","125","","2019-12-25 22:53:11","completed","",NULL),
("2395","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-12-25 23:45:39","completed","",NULL),
("2396","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","124","125","","2019-12-25 23:46:01","completed","",NULL),
("2397","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-12-25 23:57:39","completed","",NULL),
("2398","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-12-25 23:58:28","completed","",NULL),
("2399","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-12-25 23:58:54","completed","",NULL),
("2400","0","31.59.114.178","Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2019-12-26 00:00:35","completed","",NULL),
("2401","0","2.187.89.73","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-26 01:16:31","completed","",NULL),
("2402","0","37.254.59.221","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2019-12-26 01:57:05","completed","",NULL),
("2403","0","89.249.64.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-26 06:32:26","completed","",NULL),
("2404","0","37.129.231.79","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 07:54:05","completed","",NULL),
("2405","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-26 11:22:36","completed","",NULL),
("2406","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-26 11:25:26","completed","",NULL),
("2407","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-26 11:26:41","completed","",NULL),
("2408","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:27:32","completed","",NULL),
("2409","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:27:50","completed","",NULL),
("2410","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:28:07","completed","",NULL),
("2411","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:28:26","completed","",NULL),
("2412","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-26 11:28:38","completed","",NULL),
("2413","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:29:00","completed","",NULL),
("2414","0","87.251.139.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 11:29:25","completed","",NULL),
("2415","0","37.254.157.239","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-26 12:18:00","completed","",NULL),
("2416","0","151.234.106.158","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:68.0) Gecko/20100101 Firefox/68.0","124","125","","2019-12-26 12:39:50","completed","",NULL),
("2417","0","2.181.184.253","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2019-12-26 12:56:24","completed","",NULL),
("2418","0","31.58.250.70","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","124","125","","2019-12-26 15:08:01","completed","",NULL),
("2419","0","212.16.91.122","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-26 16:20:19","completed","",NULL),
("2420","0","31.57.159.52","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-26 16:22:36","completed","",NULL),
("2421","0","93.119.211.230","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-26 19:16:28","completed","",NULL),
("2422","0","5.134.132.97","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI Y625-U32) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.101 Mobile Safari/537.36","113","114","","2019-12-26 21:46:36","completed","",NULL),
("2423","0","66.249.93.58","Mozilla/5.0 (Linux; Android 4.4.4; XT1034 Build/KXB21.14-L1.61) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36 PTST/170721.190705","113","114","","2019-12-26 21:46:37","completed","",NULL),
("2424","0","66.249.93.58","Mozilla/5.0 (Linux; U; Android 4.0.3; en-us; LG-L160L Build/IML74K) AppleWebkit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.74 Mobile Safari/537.36","113","114","","2019-12-26 21:46:41","completed","",NULL),
("2425","0","5.134.132.97","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI Y625-U32) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.101 Mobile Safari/537.36","113","114","","2019-12-26 21:48:53","completed","",NULL),
("2426","0","5.134.132.97","Mozilla/5.0 (Linux; Android 4.4.2; HUAWEI Y625-U32) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.101 Mobile Safari/537.36","66","67","","2019-12-26 21:49:42","completed","",NULL),
("2427","0","5.238.6.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0 Waterfox/56.3","93","94","","2019-12-26 22:13:43","completed","",NULL),
("2428","0","5.117.233.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","68","69","","2019-12-27 02:14:38","completed","",NULL),
("2429","0","5.117.233.235","Mozilla/5.0 (Linux; Android 9; Redmi Note 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","124","125","","2019-12-27 02:40:44","completed","",NULL),
("2430","0","151.242.178.49","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:71.0) Gecko/20100101 Firefox/71.0","124","125","","2019-12-27 09:20:37","completed","",NULL),
("2431","0","5.117.233.235","Mozilla/5.0 (Linux; Android 9; Redmi Note 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","124","125","","2019-12-27 09:46:32","completed","",NULL),
("2432","0","188.210.171.149","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-27 13:04:46","completed","",NULL),
("2433","0","188.210.171.149","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:71.0) Gecko/20100101 Firefox/71.0","99","100","","2019-12-27 13:05:46","completed","",NULL),
("2434","0","89.196.68.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-12-27 14:33:35","completed","",NULL),
("2435","0","89.196.68.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-12-27 14:33:36","completed","",NULL),
("2436","0","89.196.68.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","99","100","","2019-12-27 14:42:26","completed","",NULL),
("2437","93","94.102.57.163","Mozilla/5.0 (Linux; Android 6.0.1; SM-J700H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","124","125","","2019-12-27 19:43:26","completed","",NULL),
("2438","93","94.102.57.163","Mozilla/5.0 (Linux; Android 6.0.1; SM-J700H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","124","125","","2019-12-27 19:43:44","completed","",NULL),
("2439","0","5.117.233.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","93","94","","2019-12-27 20:16:06","completed","",NULL),
("2440","0","5.78.214.154","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-28 00:53:02","completed","",NULL),
("2441","0","5.117.25.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-28 01:05:15","completed","",NULL),
("2442","0","5.117.25.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-28 01:05:20","completed","",NULL),
("2443","0","5.117.25.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-28 01:07:05","completed","",NULL),
("2444","0","5.117.25.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","68","69","","2019-12-28 01:07:12","completed","",NULL),
("2445","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-12-28 10:05:18","completed","",NULL),
("2446","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-28 10:05:33","completed","",NULL),
("2447","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-28 10:06:34","completed","",NULL),
("2448","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-28 10:08:31","completed","",NULL),
("2449","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-12-28 10:10:33","completed","",NULL),
("2450","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2019-12-28 10:11:41","completed","",NULL),
("2451","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","101","102","","2019-12-28 10:13:05","completed","",NULL),
("2452","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","68","69","","2019-12-28 10:17:38","completed","",NULL),
("2453","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","97","98","","2019-12-28 10:18:54","completed","",NULL),
("2454","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-28 10:18:56","completed","",NULL),
("2455","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","70","71","","2019-12-28 10:22:39","completed","",NULL),
("2456","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2019-12-28 10:23:31","completed","",NULL),
("2457","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-28 10:24:30","completed","",NULL),
("2458","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2019-12-28 10:26:56","completed","",NULL),
("2459","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","101","102","","2019-12-28 10:28:21","completed","",NULL),
("2460","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","124","125","","2019-12-28 10:30:00","completed","",NULL),
("2461","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","68","69","","2019-12-28 10:30:43","completed","",NULL),
("2462","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","70","71","","2019-12-28 10:31:12","completed","",NULL),
("2463","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2019-12-28 10:31:53","completed","",NULL),
("2464","0","31.192.108.46","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2019-12-28 10:32:52","completed","",NULL),
("2465","0","5.219.127.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-28 11:23:33","completed","",NULL),
("2466","0","5.219.127.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-28 11:32:13","completed","",NULL),
("2467","0","5.124.32.225","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","93","94","","2019-12-28 13:54:10","completed","",NULL),
("2468","0","5.124.32.225","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36","93","94","","2019-12-28 13:54:10","completed","",NULL),
("2469","0","5.124.32.225","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","93","94","","2019-12-28 13:54:15","completed","",NULL),
("2470","0","5.124.32.225","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36","113","114","","2019-12-28 14:25:59","completed","",NULL),
("2471","0","5.119.133.58","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-28 16:03:29","completed","",NULL),
("2472","0","5.124.32.225","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","113","114","","2019-12-28 17:51:41","completed","",NULL),
("2473","0","5.124.32.225","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","93","94","","2019-12-28 17:55:41","completed","",NULL),
("2474","0","37.160.79.72","Mozilla/5.0 (Linux; Android 8.1.0; SAMSUNG SM-T585) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Safari/537.36","66","67","","2019-12-28 18:08:35","completed","",NULL),
("2475","0","188.229.70.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-28 19:20:48","completed","",NULL),
("2476","0","31.56.204.167","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-28 19:29:08","completed","",NULL),
("2477","0","188.229.70.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-28 19:34:51","completed","",NULL),
("2478","0","188.229.70.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","101","102","","2019-12-28 20:00:20","completed","",NULL),
("2479","0","188.229.70.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-28 20:09:27","completed","",NULL),
("2480","0","204.18.173.91","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-29 00:06:32","completed","",NULL),
("2481","0","95.38.94.180","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-29 14:43:01","completed","",NULL),
("2482","0","5.115.82.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-29 21:18:04","completed","",NULL),
("2483","0","5.115.82.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","68","69","","2019-12-29 21:18:23","completed","",NULL),
("2484","0","95.162.237.12","Mozilla/5.0 (Linux; Android 8.0.0; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.143 Mobile Safari/537.36","66","67","","2019-12-30 09:24:03","completed","",NULL),
("2485","0","91.99.32.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-30 10:55:41","completed","",NULL),
("2486","0","91.99.32.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","101","102","","2019-12-30 10:56:16","completed","",NULL),
("2487","0","84.241.63.147","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-30 11:56:38","completed","",NULL),
("2488","0","45.132.172.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-30 13:23:31","completed","",NULL),
("2489","0","45.132.172.1","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2019-12-30 13:28:58","completed","",NULL),
("2490","0","5.235.251.196","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-30 16:10:30","completed","",NULL),
("2491","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-30 16:53:55","completed","",NULL),
("2492","0","8.43.121.54","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","124","125","","2019-12-30 17:10:19","completed","",NULL),
("2493","0","5.123.32.209","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-12-30 19:42:06","completed","",NULL),
("2494","0","5.123.32.209","Mozilla/5.0 (Linux; Android 6.0; HUAWEI CAN-L11 Build/HUAWEICAN-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36","66","67","","2019-12-30 19:48:48","completed","",NULL),
("2495","0","188.158.157.134","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2019-12-30 20:35:30","completed","",NULL),
("2496","0","5.117.111.13","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2019-12-30 21:29:15","completed","",NULL),
("2497","0","5.233.129.106","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2019-12-31 00:06:50","completed","",NULL),
("2498","0","93.48.244.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2019-12-31 00:28:51","completed","",NULL),
("2499","0","2.180.9.177","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-31 09:25:28","completed","",NULL),
("2500","0","62.102.140.248","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 Edge/17.17134","113","114","","2019-12-31 11:18:17","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("2501","0","2.190.245.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2019-12-31 11:24:48","completed","",NULL),
("2502","0","45.9.249.102","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2019-12-31 11:24:53","completed","",NULL),
("2503","0","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2019-12-31 12:14:07","completed","",NULL),
("2504","0","5.123.32.209","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36","113","114","","2019-12-31 17:36:08","completed","",NULL),
("2505","0","5.115.67.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-31 17:47:47","completed","",NULL),
("2506","0","54.38.213.183","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-31 18:30:02","completed","",NULL),
("2507","93","31.59.153.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2019-12-31 19:37:41","completed","",NULL),
("2508","0","5.114.155.251","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-31 19:59:57","completed","",NULL),
("2509","0","83.123.85.66","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:68.0) Gecko/20100101 Firefox/68.0","99","100","","2019-12-31 21:04:26","completed","",NULL),
("2510","0","5.116.183.55","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2019-12-31 21:42:16","completed","",NULL),
("2511","0","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-01 09:16:11","completed","",NULL),
("2512","0","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-01 09:17:07","completed","",NULL),
("2513","0","5.115.14.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-01 10:50:59","completed","",NULL),
("2514","97","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-01 11:40:53","completed","",NULL),
("2515","97","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-01 11:41:03","completed","",NULL),
("2516","97","185.141.39.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-01 12:01:18","completed","",NULL),
("2517","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2020-01-01 12:22:20","completed","",NULL),
("2518","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-01 12:44:34","completed","",NULL),
("2519","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-01 12:44:34","completed","",NULL),
("2520","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-01 12:44:34","completed","",NULL),
("2521","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-01 12:44:35","completed","",NULL),
("2522","0","178.131.102.151","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","101","102","","2020-01-01 12:44:44","completed","",NULL),
("2523","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","113","114","","2020-01-01 12:54:25","completed","",NULL),
("2524","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","97","98","","2020-01-01 12:54:29","completed","",NULL),
("2525","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","99","100","","2020-01-01 12:54:33","completed","",NULL),
("2526","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","66","67","","2020-01-01 12:54:45","completed","",NULL),
("2527","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","68","69","","2020-01-01 12:54:52","completed","",NULL),
("2528","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","93","94","","2020-01-01 12:54:59","completed","",NULL),
("2529","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","101","102","","2020-01-01 12:55:35","completed","",NULL),
("2530","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","70","71","","2020-01-01 12:58:05","completed","",NULL),
("2531","0","86.57.106.65","CyotekWebCopy/1.7 CyotekHTTP/2.0","64","65","","2020-01-01 12:58:17","completed","",NULL),
("2532","0","5.125.91.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2020-01-01 16:23:23","completed","",NULL),
("2533","0","5.114.146.59","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","93","94","","2020-01-01 16:31:26","completed","",NULL),
("2534","0","5.202.223.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-01 17:25:42","completed","",NULL),
("2535","0","37.59.248.62","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2020-01-01 17:54:19","completed","",NULL),
("2536","0","2.177.241.39","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","113","114","","2020-01-01 21:26:13","completed","",NULL),
("2537","0","5.217.63.220","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-02 02:11:00","completed","",NULL),
("2538","0","5.122.225.221","Mozilla/5.0 (Linux; Android 9; Nokia 6.2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2020-01-02 10:15:41","completed","",NULL),
("2539","0","5.122.225.221","Mozilla/5.0 (Linux; Android 9; Nokia 6.2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2020-01-02 10:17:43","completed","",NULL),
("2540","1","5.117.112.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-02 10:53:11","completed","",NULL),
("2541","1","5.117.112.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2020-01-02 11:00:59","completed","",NULL),
("2542","0","31.25.129.153","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-02 11:37:04","completed","",NULL),
("2543","0","5.119.66.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","113","114","","2020-01-02 12:23:36","completed","",NULL),
("2544","0","5.119.66.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-02 12:26:54","completed","",NULL),
("2545","0","37.129.226.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-02 13:53:02","completed","",NULL),
("2546","0","37.129.226.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-02 13:54:11","completed","",NULL),
("2547","0","5.113.197.109","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-02 14:20:56","completed","",NULL),
("2548","0","94.101.254.73","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-02 15:32:50","completed","",NULL),
("2549","0","91.92.205.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","97","98","","2020-01-02 16:43:40","completed","",NULL),
("2550","0","5.232.55.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","101","102","","2020-01-02 20:12:06","completed","",NULL),
("2551","0","46.100.227.104","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","66","67","","2020-01-02 20:24:42","completed","",NULL),
("2552","99","51.75.172.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-02 23:19:25","completed","",NULL),
("2553","0","5.202.9.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-03 05:09:35","completed","",NULL),
("2554","0","78.158.171.143","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-03 13:22:26","completed","",NULL),
("2555","0","193.176.84.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-03 14:56:13","completed","",NULL),
("2556","0","193.176.84.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","101","102","","2020-01-03 14:56:35","completed","",NULL),
("2557","0","87.107.231.180","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-03 14:56:59","completed","",NULL),
("2558","0","5.121.43.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36 Edg/79.0.309.56","93","94","","2020-01-03 15:04:16","completed","",NULL),
("2559","0","5.121.43.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36 Edg/79.0.309.56","124","125","","2020-01-03 15:42:52","completed","",NULL),
("2560","0","5.121.43.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36 Edg/79.0.309.56","124","125","","2020-01-03 15:43:54","completed","",NULL),
("2561","73","193.176.84.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-03 20:28:21","completed","",NULL),
("2562","73","193.176.84.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-03 20:28:40","completed","",NULL),
("2563","0","5.126.206.71","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-03 20:38:37","completed","",NULL),
("2564","0","5.126.206.71","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-03 20:47:10","completed","",NULL),
("2565","0","2.187.79.118","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-03 22:32:09","completed","",NULL),
("2566","0","2.187.79.118","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-03 22:33:00","completed","",NULL),
("2567","0","5.124.182.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-04 14:40:56","completed","",NULL),
("2568","0","5.124.182.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","68","69","","2020-01-04 14:41:19","completed","",NULL),
("2569","0","151.233.149.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-04 15:27:41","completed","",NULL),
("2570","0","91.92.205.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-04 16:21:08","completed","",NULL),
("2571","0","91.92.205.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-04 16:25:59","completed","",NULL),
("2572","0","178.238.194.128","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-04 18:21:02","completed","",NULL),
("2573","0","178.131.146.247","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-04 19:00:25","completed","",NULL),
("2574","97","5.126.163.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-04 19:36:53","completed","",NULL),
("2575","0","78.129.204.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-04 19:37:03","completed","",NULL),
("2576","97","5.126.163.157","Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A372 Safari/604.1","113","114","","2020-01-04 20:34:11","completed","",NULL),
("2577","0","217.60.151.226","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-04 22:19:40","completed","",NULL),
("2578","0","217.60.151.226","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-04 22:26:38","completed","",NULL),
("2579","0","5.119.190.214","Mozilla/5.0 (Linux; Android 9; Mi A2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2020-01-05 03:15:56","completed","",NULL),
("2580","0","46.4.192.231","Mozilla/5.0 (Linux; Android 9; SM-G611F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","66","67","","2020-01-05 06:06:12","completed","",NULL),
("2581","0","185.129.219.4","Mozilla/5.0 (Windows NT 6.1; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0 SeaMonkey/2.49.4","93","94","","2020-01-05 13:27:25","completed","",NULL),
("2582","0","46.4.192.231","Mozilla/5.0 (Linux; Android 9; SM-G611F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","66","67","","2020-01-05 13:44:20","completed","",NULL),
("2583","0","5.125.124.156","Mozilla/5.0 (Linux; Android 6.0.1; SM-J500H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2020-01-05 14:45:25","completed","",NULL),
("2584","0","46.4.192.231","Mozilla/5.0 (Linux; Android 9; SM-G611F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","124","125","","2020-01-05 15:03:18","completed","",NULL),
("2585","0","46.4.192.231","Mozilla/5.0 (Linux; Android 9; SM-G611F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2020-01-05 15:05:15","completed","",NULL),
("2586","0","5.113.50.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","113","114","","2020-01-05 15:57:24","completed","",NULL),
("2587","0","5.113.50.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-05 15:57:59","completed","",NULL),
("2588","0","217.60.150.236","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2020-01-05 16:57:34","completed","",NULL),
("2589","0","5.202.98.196","Mozilla/5.0 (Linux; Android 9; SM-G611F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","124","125","","2020-01-05 19:00:17","completed","",NULL),
("2590","0","5.214.235.240","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-05 19:46:05","completed","",NULL),
("2591","0","37.148.108.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-05 19:49:10","completed","",NULL),
("2592","0","107.150.30.149","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2020-01-05 20:43:59","completed","",NULL),
("2593","0","5.217.95.16","AppleCoreMedia/1.0.0.15G77 (iPhone; U; CPU OS 11_4_1 like Mac OS X; en_us)","124","125","","2020-01-05 20:44:58","completed","",NULL),
("2594","0","178.63.185.59","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2020-01-05 22:04:48","completed","",NULL),
("2595","0","93.119.211.127","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_1) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Safari/605.1.15","124","125","","2020-01-06 11:00:52","completed","",NULL),
("2596","0","188.159.212.16","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-06 13:15:48","completed","",NULL),
("2597","0","188.212.245.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-06 13:57:39","completed","",NULL),
("2598","0","93.115.229.210","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","66","67","","2020-01-06 16:34:28","completed","",NULL),
("2599","0","93.115.229.210","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:71.0) Gecko/20100101 Firefox/71.0","93","94","","2020-01-06 16:35:13","completed","",NULL),
("2600","0","185.191.207.184","Mozilla/5.0 (Linux; Android 9; SM-G950F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","66","67","","2020-01-06 17:17:05","completed","",NULL),
("2601","0","5.232.55.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-06 21:08:34","completed","",NULL),
("2602","0","5.232.55.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-06 21:08:59","completed","",NULL),
("2603","0","5.232.55.53","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","97","98","","2020-01-06 21:09:05","completed","",NULL),
("2604","0","37.148.99.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-07 01:09:43","completed","",NULL),
("2605","0","37.148.99.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-07 01:10:36","completed","",NULL),
("2606","0","37.148.99.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-07 01:10:38","completed","",NULL),
("2607","0","37.148.99.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-07 01:10:42","completed","",NULL),
("2608","0","93.119.214.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","68","69","","2020-01-07 03:09:30","completed","",NULL),
("2609","0","93.119.214.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-07 03:09:35","completed","",NULL),
("2610","0","93.119.214.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-07 03:09:47","completed","",NULL),
("2611","0","5.116.73.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-07 04:00:03","completed","",NULL),
("2612","1","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-07 15:01:11","completed","",NULL),
("2613","0","130.193.242.255","Mozilla/5.0 (iPhone; CPU iPhone OS 12_1_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1","66","67","","2020-01-07 20:19:59","completed","",NULL),
("2614","93","164.132.144.184","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-07 21:04:52","completed","",NULL),
("2615","0","130.255.249.178","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-07 22:36:31","completed","",NULL),
("2616","0","5.112.44.75","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","66","67","","2020-01-08 03:43:07","completed","",NULL),
("2617","0","5.235.198.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","64","65","","2020-01-08 14:55:50","completed","",NULL),
("2618","0","109.169.15.24","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","66","67","","2020-01-08 21:10:24","completed","",NULL),
("2619","0","5.115.145.12","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","113","114","","2020-01-09 01:23:11","completed","",NULL),
("2620","0","5.216.109.144","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2020-01-09 02:05:28","completed","",NULL),
("2621","0","5.216.109.144","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","66","67","","2020-01-09 02:07:17","completed","",NULL),
("2622","0","5.112.44.75","Mozilla/5.0 (Linux; Android 9; Mi A2 Lite) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Mobile Safari/537.36","66","67","","2020-01-09 03:25:58","completed","",NULL),
("2623","0","94.139.161.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2020-01-09 07:27:26","completed","",NULL),
("2624","0","94.139.161.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-01-09 07:28:50","completed","",NULL),
("2625","0","94.139.161.33","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","66","67","","2020-01-09 07:29:33","completed","",NULL),
("2626","0","5.115.240.203","Mozilla/5.0 (Linux; Android 7.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2020-01-09 10:08:35","completed","",NULL),
("2627","0","185.189.113.59","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","68","69","","2020-01-09 11:47:20","completed","",NULL),
("2628","0","185.189.113.59","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","66","67","","2020-01-09 11:47:37","completed","",NULL),
("2629","0","5.112.115.32","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-01-09 11:48:26","completed","",NULL),
("2630","0","5.125.237.59","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-09 15:09:04","completed","",NULL),
("2631","0","5.239.211.172","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-09 22:59:11","completed","",NULL),
("2632","104","5.126.65.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-10 01:05:13","completed","",NULL),
("2633","0","78.169.119.208","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-10 16:21:00","completed","",NULL),
("2634","0","188.158.11.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-10 23:03:43","completed","",NULL),
("2635","0","5.119.75.144","Mozilla/5.0 (Linux; Android 8.0.0; SAMSUNG SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2020-01-11 19:39:01","completed","",NULL),
("2636","0","5.119.75.144","Mozilla/5.0 (Linux; Android 8.0.0; SAMSUNG SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2020-01-11 19:39:03","completed","",NULL),
("2637","0","5.119.75.144","Mozilla/5.0 (Linux; Android 8.0.0; SAMSUNG SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","113","114","","2020-01-11 19:39:04","completed","",NULL),
("2638","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:37:43","completed","",NULL),
("2639","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:38:42","completed","",NULL),
("2640","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:38:55","completed","",NULL),
("2641","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:39:08","completed","",NULL),
("2642","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:39:21","completed","",NULL),
("2643","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:39:34","completed","",NULL),
("2644","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:39:46","completed","",NULL),
("2645","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:39:59","completed","",NULL),
("2646","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:40:19","completed","",NULL),
("2647","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:40:32","completed","",NULL),
("2648","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:40:45","completed","",NULL),
("2649","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:40:58","completed","",NULL),
("2650","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:41:11","completed","",NULL),
("2651","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:41:25","completed","",NULL),
("2652","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:41:38","completed","",NULL),
("2653","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:41:51","completed","",NULL),
("2654","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:42:04","completed","",NULL),
("2655","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:42:18","completed","",NULL),
("2656","0","2.178.151.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","99","100","","2020-01-11 20:50:43","completed","",NULL),
("2657","0","5.127.150.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-12 11:58:15","completed","",NULL),
("2658","0","5.127.150.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","113","114","","2020-01-12 11:59:11","completed","",NULL),
("2659","0","178.131.140.87","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-12 12:08:01","completed","",NULL),
("2660","0","5.236.159.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-12 12:54:47","completed","",NULL),
("2661","0","212.8.249.177","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-12 16:01:36","completed","",NULL),
("2662","0","5.74.170.252","Mozilla/5.0 (iPad; CPU OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/605.1","93","94","","2020-01-12 22:45:02","completed","",NULL),
("2663","0","95.82.17.67","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-13 00:02:41","completed","",NULL),
("2664","0","5.213.254.182","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","124","125","","2020-01-13 02:40:00","completed","",NULL),
("2665","0","5.213.254.182","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2020-01-13 02:44:44","completed","",NULL),
("2666","0","5.213.254.182","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","93","94","","2020-01-13 02:46:42","completed","",NULL),
("2667","0","185.227.82.46","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2020-01-13 17:18:16","completed","",NULL),
("2668","0","185.227.82.46","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2020-01-13 17:19:37","completed","",NULL),
("2669","0","46.225.198.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-13 23:57:55","completed","",NULL),
("2670","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-14 15:38:30","completed","",NULL),
("2671","0","5.117.155.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-14 15:40:04","completed","",NULL),
("2672","0","5.117.155.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 15:40:20","completed","",NULL),
("2673","0","5.117.155.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 15:42:51","completed","",NULL),
("2674","0","5.117.155.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-14 15:44:24","completed","",NULL),
("2675","0","93.158.166.4","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","113","114","","2020-01-14 17:08:13","completed","",NULL),
("2676","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:34:22","completed","",NULL),
("2677","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:35:30","completed","",NULL),
("2678","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:35:42","completed","",NULL),
("2679","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:35:54","completed","",NULL),
("2680","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:36:07","completed","",NULL),
("2681","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:36:20","completed","",NULL),
("2682","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:36:32","completed","",NULL),
("2683","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:36:45","completed","",NULL),
("2684","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:36:57","completed","",NULL),
("2685","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:37:09","completed","",NULL),
("2686","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:37:23","completed","",NULL),
("2687","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:37:36","completed","",NULL),
("2688","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:37:49","completed","",NULL),
("2689","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:38:02","completed","",NULL),
("2690","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:38:15","completed","",NULL),
("2691","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:38:28","completed","",NULL),
("2692","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:38:41","completed","",NULL),
("2693","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:38:55","completed","",NULL),
("2694","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:39:08","completed","",NULL),
("2695","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:39:21","completed","",NULL),
("2696","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:39:34","completed","",NULL),
("2697","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:39:48","completed","",NULL),
("2698","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:40:01","completed","",NULL),
("2699","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:40:18","completed","",NULL),
("2700","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:40:31","completed","",NULL),
("2701","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:40:46","completed","",NULL),
("2702","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:40:59","completed","",NULL),
("2703","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:41:13","completed","",NULL),
("2704","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:41:27","completed","",NULL),
("2705","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-14 19:41:40","completed","",NULL),
("2706","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","97","98","","2020-01-15 02:06:54","completed","",NULL),
("2707","0","8.41.39.65","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","113","114","","2020-01-15 02:46:14","completed","",NULL),
("2708","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","68","69","","2020-01-15 05:09:56","completed","",NULL),
("2709","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:56:14","completed","",NULL),
("2710","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:57:20","completed","",NULL),
("2711","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:57:32","completed","",NULL),
("2712","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:57:44","completed","",NULL),
("2713","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:57:56","completed","",NULL),
("2714","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:58:09","completed","",NULL),
("2715","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:58:22","completed","",NULL),
("2716","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:58:34","completed","",NULL),
("2717","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:58:46","completed","",NULL),
("2718","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:58:59","completed","",NULL),
("2719","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:59:12","completed","",NULL),
("2720","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:59:25","completed","",NULL),
("2721","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:59:37","completed","",NULL),
("2722","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 09:59:49","completed","",NULL),
("2723","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:00:01","completed","",NULL),
("2724","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:00:16","completed","",NULL),
("2725","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:00:30","completed","",NULL),
("2726","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:00:43","completed","",NULL),
("2727","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:00:56","completed","",NULL),
("2728","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:01:10","completed","",NULL),
("2729","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:01:24","completed","",NULL),
("2730","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:01:38","completed","",NULL),
("2731","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:01:51","completed","",NULL),
("2732","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:02:05","completed","",NULL),
("2733","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:02:19","completed","",NULL),
("2734","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:02:33","completed","",NULL),
("2735","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:02:47","completed","",NULL),
("2736","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:03:01","completed","",NULL),
("2737","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:03:14","completed","",NULL),
("2738","0","93.117.179.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-15 10:03:28","completed","",NULL),
("2739","0","94.130.127.134","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","70","71","","2020-01-15 10:58:09","completed","",NULL),
("2740","0","151.235.57.162","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-15 13:59:15","completed","",NULL),
("2741","0","89.47.141.138","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-15 14:21:07","completed","",NULL),
("2742","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","101","102","","2020-01-15 15:38:42","redirected","تغییر مسیر به فایل راه دور.",NULL),
("2743","0","5.122.38.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","99","100","","2020-01-15 15:59:48","completed","",NULL),
("2744","0","5.122.38.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","99","100","","2020-01-15 15:59:49","completed","",NULL),
("2745","0","5.127.39.22","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-01-15 16:29:17","completed","",NULL),
("2746","0","5.127.39.22","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","99","100","","2020-01-15 16:30:20","completed","",NULL),
("2747","0","5.127.39.22","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","68","69","","2020-01-15 16:31:21","completed","",NULL),
("2748","0","85.185.159.17","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-15 17:45:23","completed","",NULL),
("2749","0","109.230.76.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","68","69","","2020-01-15 17:52:59","completed","",NULL),
("2750","0","109.230.76.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","97","98","","2020-01-15 18:03:27","completed","",NULL),
("2751","0","109.230.76.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-15 18:09:43","completed","",NULL),
("2752","0","109.230.76.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","99","100","","2020-01-15 18:09:59","completed","",NULL),
("2753","0","109.230.76.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","101","102","","2020-01-15 18:10:32","completed","",NULL),
("2754","106","5.202.140.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-15 18:15:44","completed","",NULL),
("2755","0","5.117.255.49","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","97","98","","2020-01-15 19:07:03","completed","",NULL),
("2756","106","5.202.140.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-15 20:24:00","completed","",NULL),
("2757","106","5.202.140.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-15 20:24:58","completed","",NULL),
("2758","0","91.207.57.242","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-16 00:55:23","completed","",NULL),
("2759","0","94.130.127.151","Mozilla/5.0 (Linux; Android 8.0.0; RNE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-01-16 01:14:27","completed","",NULL),
("2760","0","192.15.66.27","Mozilla/5.0 (Linux; Android 9; MAR-LX1M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Mobile Safari/537.36","93","94","","2020-01-16 07:57:06","completed","",NULL),
("2761","0","195.181.52.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-16 15:17:49","completed","",NULL),
("2762","0","5.125.152.147","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78 (Edition Campaign 34)","93","94","","2020-01-16 17:05:00","completed","",NULL),
("2763","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","66","67","","2020-01-16 19:11:59","completed","",NULL),
("2764","0","5.122.73.120","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","97","98","","2020-01-16 19:27:24","completed","",NULL),
("2765","0","2.191.52.25","Mozilla/5.0 (Linux; Android 4.4.2; SM-P901) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.80 Safari/537.36","66","67","","2020-01-17 01:52:48","completed","",NULL),
("2766","0","2.191.52.25","Mozilla/5.0 (Linux; Android 4.4.2; SM-P901) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.80 Safari/537.36","93","94","","2020-01-17 01:53:22","completed","",NULL),
("2767","0","2.191.52.25","Mozilla/5.0 (Linux; Android 4.4.2; SM-P901) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.80 Safari/537.36","93","94","","2020-01-17 01:53:23","completed","",NULL),
("2768","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","113","114","","2020-01-17 02:02:16","completed","",NULL),
("2769","0","46.225.208.128","Mozilla/5.0 (Linux; U; Android 8.1.0; en-us; MI PLAY Build/O11019) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.3.4-g","99","100","","2020-01-17 11:25:26","completed","",NULL),
("2770","0","5.119.44.192","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-17 18:40:02","completed","",NULL),
("2771","0","93.158.166.4","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","66","67","","2020-01-17 18:46:27","completed","",NULL),
("2772","0","78.141.211.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","66","67","","2020-01-17 20:10:56","completed","",NULL),
("2773","0","5.124.17.108","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-17 20:39:20","completed","",NULL),
("2774","0","86.57.32.129","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-01-17 22:06:52","completed","",NULL),
("2775","0","5.127.39.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-18 14:29:03","completed","",NULL),
("2776","0","5.127.39.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-18 14:29:24","completed","",NULL),
("2777","0","5.116.147.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","99","100","","2020-01-18 16:43:28","completed","",NULL),
("2778","0","5.119.141.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","68","69","","2020-01-18 16:43:29","completed","",NULL),
("2779","0","5.119.141.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","99","100","","2020-01-18 16:44:54","completed","",NULL),
("2780","0","5.119.141.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-18 16:45:34","completed","",NULL),
("2781","0","5.119.141.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-18 16:46:47","completed","",NULL),
("2782","0","5.116.147.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","99","100","","2020-01-18 16:49:13","completed","",NULL),
("2783","0","45.63.41.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","99","100","","2020-01-18 16:51:15","completed","",NULL),
("2784","0","45.63.41.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","66","67","","2020-01-18 16:51:39","completed","",NULL),
("2785","0","5.119.141.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-18 16:58:52","completed","",NULL),
("2786","0","45.63.41.64","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","93","94","","2020-01-18 17:07:30","completed","",NULL),
("2787","0","5.123.1.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","113","114","","2020-01-18 18:37:11","completed","",NULL),
("2788","0","5.123.1.174","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-18 18:37:40","completed","",NULL),
("2789","0","5.113.112.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-18 20:41:38","completed","",NULL),
("2790","0","5.208.31.11","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","113","114","","2020-01-18 23:41:54","completed","",NULL),
("2791","0","2a0d:5600:24:ad:b7b8:0:8a1:1019","Mozilla/5.0 (Linux; Android 8.1.0; LG-M700) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-01-18 23:51:26","completed","",NULL),
("2792","0","37.128.242.240","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.53 Safari/537.36 Edg/80.0.361.33","93","94","","2020-01-19 08:15:50","completed","",NULL),
("2793","0","31.56.187.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-19 10:35:27","completed","",NULL),
("2794","0","5.112.186.85","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-19 15:33:42","completed","",NULL),
("2795","0","5.122.48.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-01-19 18:17:09","completed","",NULL),
("2796","0","5.116.174.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-19 19:42:40","completed","",NULL),
("2797","0","5.116.174.140","Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Mobile Safari/537.36","124","125","","2020-01-19 19:56:25","completed","",NULL),
("2798","0","5.116.129.155","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-19 22:35:21","completed","",NULL),
("2799","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","99","100","","2020-01-20 08:05:21","completed","",NULL),
("2800","0","5.119.194.38","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2020-01-20 09:24:08","completed","",NULL),
("2801","0","5.119.194.38","Mozilla/5.0 (Linux; Android 8.1.0; SM-J710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36","66","67","","2020-01-20 09:25:53","completed","",NULL),
("2802","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","113","114","","2020-01-20 12:32:42","completed","",NULL),
("2803","0","5.114.113.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-20 12:53:26","completed","",NULL),
("2804","0","62.102.138.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","124","125","","2020-01-21 08:43:32","completed","",NULL),
("2805","0","5.115.225.136","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","93","94","","2020-01-21 13:32:55","completed","",NULL),
("2806","0","5.121.189.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-21 16:45:11","completed","",NULL),
("2807","0","5.121.189.78","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-21 16:46:27","completed","",NULL),
("2808","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-21 17:13:21","completed","",NULL),
("2809","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-21 17:16:53","completed","",NULL),
("2810","0","5.115.208.145","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/78.0.3904.84 Mobile/15E148 Safari/604.1","113","114","","2020-01-21 17:38:44","completed","",NULL),
("2811","0","89.36.50.183","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","113","114","","2020-01-21 19:53:46","completed","",NULL),
("2812","0","5.124.24.224","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.2 Safari/605.1.15","66","67","","2020-01-21 23:00:15","completed","",NULL),
("2813","0","5.124.24.224","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.2 Safari/605.1.15","66","67","","2020-01-21 23:10:29","completed","",NULL),
("2814","0","5.124.24.224","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.2 Safari/605.1.15","66","67","","2020-01-21 23:22:25","completed","",NULL),
("2815","0","2.178.3.153","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-22 01:42:47","completed","",NULL),
("2816","0","2.178.3.153","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-22 01:43:48","completed","",NULL),
("2817","0","2.178.3.153","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-22 01:44:00","completed","",NULL),
("2818","0","46.51.69.184","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","93","94","","2020-01-22 11:53:50","completed","",NULL),
("2819","0","83.122.235.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-22 18:47:10","completed","",NULL),
("2820","0","176.101.33.200","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","99","100","","2020-01-22 20:16:52","completed","",NULL),
("2821","0","83.122.215.205","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 10:29:27","completed","",NULL),
("2822","0","83.122.215.205","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-01-23 10:38:12","completed","",NULL),
("2823","0","95.82.34.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-23 11:22:12","completed","",NULL),
("2824","0","10.201.8.220","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-23 14:16:36","completed","",NULL),
("2825","112","10.201.8.222","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-23 14:58:14","completed","",NULL),
("2826","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:02","completed","",NULL),
("2827","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:34","completed","",NULL),
("2828","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:35","completed","",NULL),
("2829","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:37","completed","",NULL),
("2830","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:37","completed","",NULL),
("2831","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:37","completed","",NULL),
("2832","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:39","completed","",NULL),
("2833","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:39","completed","",NULL),
("2834","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:41","completed","",NULL),
("2835","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","113","114","","2020-01-23 15:24:43","completed","",NULL),
("2836","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-23 15:26:48","completed","",NULL),
("2837","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-23 15:27:52","completed","",NULL),
("2838","0","83.122.215.205","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-23 15:38:36","completed","",NULL),
("2839","0","5.22.118.125","Mozilla/5.0 (Linux; Android 10; LYA-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-01-23 16:40:54","completed","",NULL),
("2840","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-01-23 18:07:04","completed","",NULL),
("2841","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:07:54","completed","",NULL),
("2842","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:02","completed","",NULL),
("2843","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:07","completed","",NULL),
("2844","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:08","completed","",NULL),
("2845","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:13","completed","",NULL),
("2846","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:13","completed","",NULL),
("2847","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:14","completed","",NULL),
("2848","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-23 18:08:14","completed","",NULL),
("2849","0","5.120.239.48","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-23 18:10:59","redirected","تغییر مسیر به فایل راه دور.",NULL),
("2850","0","5.117.182.251","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36","66","67","","2020-01-23 18:57:20","completed","",NULL),
("2851","0","93.110.156.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2020-01-23 22:04:16","completed","",NULL),
("2852","111","5.126.228.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-24 01:12:21","completed","",NULL),
("2853","111","5.126.228.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-01-24 01:12:32","completed","",NULL),
("2854","111","5.126.228.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-01-24 01:13:12","completed","",NULL),
("2855","0","5.255.253.6","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","70","71","","2020-01-24 02:06:01","completed","",NULL),
("2856","0","5.78.96.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","93","94","","2020-01-24 07:20:54","completed","",NULL),
("2857","0","46.224.106.145","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-24 09:49:36","completed","",NULL),
("2858","0","37.228.135.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36 OPR/65.0.3467.78","93","94","","2020-01-24 11:47:46","completed","",NULL),
("2859","0","188.245.228.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-24 12:48:45","completed","",NULL),
("2860","0","151.80.62.229","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-24 14:15:12","completed","",NULL),
("2861","0","37.129.239.173","Mozilla/5.0 (Linux; Android 4.4.4; SM-J110F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-01-24 14:29:25","completed","",NULL),
("2862","0","113.203.76.132","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-24 14:54:38","completed","",NULL),
("2863","0","5.113.111.195","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-24 19:11:59","completed","",NULL),
("2864","113","5.113.111.195","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-24 19:13:21","completed","",NULL),
("2865","113","5.113.111.195","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-24 19:14:40","completed","",NULL),
("2866","113","5.113.111.195","Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-24 19:14:50","completed","",NULL),
("2867","0","5.119.153.215","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-24 23:42:24","completed","",NULL),
("2868","0","5.211.120.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-25 00:33:45","completed","",NULL),
("2869","0","5.126.2.3","Mozilla/5.0 (Linux; Android 9; POCOPHONE F1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2020-01-25 01:30:55","completed","",NULL),
("2870","0","193.176.87.230","Mozilla/5.0 (Linux; Android 9; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Safari/537.36","93","94","","2020-01-25 02:01:22","completed","",NULL),
("2871","0","193.176.87.230","Mozilla/5.0 (Linux; Android 9; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Safari/537.36","93","94","","2020-01-25 02:01:57","completed","",NULL),
("2872","0","193.176.87.230","Mozilla/5.0 (Linux; Android 9; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Safari/537.36","93","94","","2020-01-25 02:02:00","completed","",NULL),
("2873","0","193.176.87.230","Mozilla/5.0 (Linux; Android 9; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Safari/537.36","93","94","","2020-01-25 02:02:09","completed","",NULL),
("2874","0","5.112.174.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-25 12:59:34","completed","",NULL),
("2875","0","5.127.140.86","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-25 16:33:16","completed","",NULL),
("2876","115","37.98.25.138","Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Mobile Safari/537.36","66","67","","2020-01-25 19:47:08","completed","",NULL),
("2877","115","37.98.25.138","Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Mobile Safari/537.36","66","67","","2020-01-25 19:48:15","completed","",NULL),
("2878","115","37.98.25.138","Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Mobile Safari/537.36","66","67","","2020-01-25 19:48:27","completed","",NULL),
("2879","115","37.98.25.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-25 19:48:35","completed","",NULL),
("2880","115","37.98.25.138","Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Mobile Safari/537.36","93","94","","2020-01-25 19:49:39","completed","",NULL),
("2881","115","37.98.25.138","Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Mobile Safari/537.36","93","94","","2020-01-25 19:49:51","completed","",NULL),
("2882","115","37.98.25.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-25 19:50:04","completed","",NULL),
("2883","115","37.98.25.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-25 19:50:19","completed","",NULL),
("2884","115","37.98.25.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-25 19:50:20","completed","",NULL),
("2885","0","2001:ac8:25:6e:64b4:6c30:871:101c","Mozilla/5.0 (Linux; Android 9; Mi Note 10) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","66","67","","2020-01-25 20:07:49","completed","",NULL),
("2886","0","5.160.79.17","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-26 09:10:51","completed","",NULL),
("2887","0","10.201.8.217","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-26 11:25:05","completed","",NULL),
("2888","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","93","94","","2020-01-26 11:44:56","completed","",NULL),
("2889","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2020-01-26 11:47:06","completed","",NULL),
("2890","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2020-01-26 11:47:14","completed","",NULL),
("2891","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2020-01-26 11:50:55","completed","",NULL),
("2892","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2020-01-26 11:53:28","completed","",NULL),
("2893","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","99","100","","2020-01-26 11:53:46","completed","",NULL),
("2894","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2020-01-26 11:54:51","completed","",NULL),
("2895","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","113","114","","2020-01-26 11:57:33","completed","",NULL),
("2896","0","5.239.223.198","Mozilla/4.5 (compatible; HTTrack 3.0x; Windows 98)","66","67","","2020-01-26 11:59:28","completed","",NULL),
("2897","0","2.176.111.219","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-26 15:29:02","completed","",NULL),
("2898","0","2.176.111.219","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-26 15:31:09","completed","",NULL),
("2899","0","5.114.105.157","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Mobile/15E148 Safari/604.1","124","125","","2020-01-26 20:05:10","completed","",NULL),
("2900","0","37.129.184.184","Mozilla/5.0 (Linux; Android 10; SM-N975F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","113","114","","2020-01-26 21:16:08","completed","",NULL),
("2901","0","91.98.2.228","Mozilla/5.0 (Linux; Android 6.0.1; SM-J500H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","124","125","","2020-01-26 22:54:53","completed","",NULL),
("2902","0","91.98.2.228","Mozilla/5.0 (Linux; Android 6.0.1; SM-J500H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","124","125","","2020-01-26 22:55:01","completed","",NULL),
("2903","0","51.77.123.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-27 00:20:52","completed","",NULL),
("2904","0","51.77.123.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","97","98","","2020-01-27 00:21:15","completed","",NULL),
("2905","0","172.80.251.11","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-01-27 00:34:30","completed","",NULL),
("2906","0","5.124.61.6","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-27 13:15:06","completed","",NULL),
("2907","0","31.47.57.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-27 13:38:37","completed","",NULL),
("2908","0","89.165.44.242","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-27 14:01:42","completed","",NULL),
("2909","0","86.55.0.220","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","93","94","","2020-01-27 15:39:35","completed","",NULL),
("2910","0","2.176.108.134","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/604.1","66","67","","2020-01-27 16:04:46","completed","",NULL),
("2911","0","2.176.108.134","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/604.1","66","67","","2020-01-27 16:04:54","completed","",NULL),
("2912","0","2.176.108.134","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/604.1","66","67","","2020-01-27 16:06:04","completed","",NULL),
("2913","0","2.176.108.134","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/604.1","66","67","","2020-01-27 16:06:16","completed","",NULL),
("2914","0","2.182.105.56","Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-27 17:13:08","completed","",NULL),
("2915","0","194.35.233.90","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-27 20:32:54","completed","",NULL),
("2916","0","93.119.220.177","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-27 20:44:22","completed","",NULL),
("2917","0","5.115.91.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-27 21:25:48","completed","",NULL),
("2918","0","86.57.16.145","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-28 09:13:56","completed","",NULL),
("2919","0","5.236.140.165","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","68","69","","2020-01-28 09:59:03","completed","",NULL),
("2920","0","51.77.123.190","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-28 11:26:52","completed","",NULL),
("2921","0","37.9.113.156","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","68","69","","2020-01-28 11:33:32","completed","",NULL),
("2922","0","86.57.13.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-28 11:49:07","completed","",NULL),
("2923","0","5.119.155.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-01-28 13:21:23","completed","",NULL),
("2924","0","5.119.155.228","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-28 13:21:25","completed","",NULL),
("2925","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-28 13:41:07","completed","",NULL),
("2926","0","185.131.114.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-28 13:45:03","completed","",NULL),
("2927","0","178.131.15.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-28 14:09:21","completed","",NULL),
("2928","0","178.131.15.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-28 14:09:40","completed","",NULL),
("2929","0","178.131.15.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-28 14:09:40","completed","",NULL),
("2930","0","178.131.15.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-28 14:10:13","completed","",NULL),
("2931","0","91.251.168.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-28 15:42:49","completed","",NULL),
("2932","0","5.119.151.172","Mozilla/5.0 (Linux; Android 6.0.1; SM-A510F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2020-01-28 16:10:51","completed","",NULL),
("2933","0","5.119.151.172","Mozilla/5.0 (Linux; Android 6.0.1; SM-A510F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","93","94","","2020-01-28 16:33:13","completed","",NULL),
("2934","0","5.126.100.194","Mozilla/5.0 (Linux; Android 6.0; Redmi Note 4X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.62 Mobile Safari/537.36","66","67","","2020-01-28 17:01:01","completed","",NULL),
("2935","0","78.108.178.85","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-28 18:11:18","completed","",NULL),
("2936","0","190.2.144.24","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-01-28 19:36:34","completed","",NULL),
("2937","0","188.212.246.4","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","93","94","","2020-01-28 19:59:01","completed","",NULL),
("2938","0","5.106.135.186","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","113","114","","2020-01-28 23:18:48","completed","",NULL),
("2939","0","5.120.54.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-29 03:05:43","completed","",NULL),
("2940","0","5.126.228.106","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Safari/537.36 OPR/55.1.2719.50626","66","67","","2020-01-29 06:49:21","completed","",NULL),
("2941","0","78.46.93.48","Mozilla/5.0 (compatible; BLEXBot/1.0; +http://webmeup-crawler.com/)","66","67","","2020-01-29 10:13:47","completed","",NULL),
("2942","0","5.117.6.199","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-29 10:43:19","completed","",NULL),
("2943","0","62.102.134.51","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-29 10:57:30","completed","",NULL),
("2944","0","5.126.245.167","Mozilla/5.0 (Windows NT 6.3; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-29 13:40:35","completed","",NULL),
("2945","1","5.117.6.199","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-29 15:12:32","completed","",NULL),
("2946","0","5.122.58.7","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-01-29 15:38:07","completed","",NULL),
("2947","0","5.122.58.7","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-29 15:41:36","completed","",NULL),
("2948","0","5.117.111.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-01-29 17:43:07","completed","",NULL),
("2949","0","31.58.77.245","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-29 18:02:05","completed","",NULL),
("2950","0","46.221.240.136","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-29 22:03:48","completed","",NULL),
("2951","0","109.162.242.94","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-01-30 11:46:22","completed","",NULL),
("2952","0","5.236.140.165","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-30 11:46:31","completed","",NULL),
("2953","0","5.236.140.165","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-01-30 11:46:48","completed","",NULL),
("2954","0","5.117.111.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","113","114","","2020-01-30 12:38:39","completed","",NULL),
("2955","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:36:54","completed","",NULL),
("2956","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:37:11","completed","",NULL),
("2957","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:37:12","completed","",NULL),
("2958","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:37:43","completed","",NULL),
("2959","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:37:44","completed","",NULL),
("2960","2","5.117.190.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-30 14:37:52","completed","",NULL),
("2961","0","5.239.13.118","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-01-30 16:56:03","completed","",NULL),
("2962","0","5.119.68.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-30 18:49:31","completed","",NULL),
("2963","0","199.247.2.206","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-01-30 23:39:59","completed","",NULL),
("2964","0","78.39.216.218","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-01-30 23:57:44","completed","",NULL),
("2965","0","54.37.73.134","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-01-31 11:23:04","completed","",NULL),
("2966","0","54.37.73.134","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-01-31 11:23:14","completed","",NULL),
("2967","0","31.56.198.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 Edge/18.18362","93","94","","2020-01-31 11:52:55","completed","",NULL),
("2968","0","31.56.198.16","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A305F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","93","94","","2020-01-31 13:07:51","completed","",NULL),
("2969","0","54.37.73.134","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-01-31 14:56:27","completed","",NULL),
("2970","0","151.239.146.129","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","101","102","","2020-01-31 21:40:29","completed","",NULL),
("2971","120","151.239.146.129","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","113","114","","2020-01-31 21:44:01","completed","",NULL),
("2972","120","151.239.146.129","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-01-31 22:08:46","completed","",NULL),
("2973","0","5.235.250.57","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","97","98","","2020-02-01 09:59:03","completed","",NULL),
("2974","0","5.112.188.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-01 11:18:41","completed","",NULL),
("2975","0","5.235.250.57","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-02-01 15:57:43","completed","",NULL),
("2976","114","37.129.147.43","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-01 15:58:41","completed","",NULL),
("2977","0","5.124.119.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-01 16:21:57","completed","",NULL),
("2978","0","5.124.119.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-01 16:23:25","completed","",NULL),
("2979","0","2.177.239.36","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-01 19:12:00","completed","",NULL),
("2980","0","2.177.239.36","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","99","100","","2020-02-01 19:12:03","completed","",NULL),
("2981","0","31.58.253.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36","93","94","","2020-02-01 21:14:34","completed","",NULL),
("2982","0","50.7.62.3","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-02-02 05:34:28","completed","",NULL),
("2983","0","94.183.171.245","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","68","69","","2020-02-02 10:03:56","completed","",NULL),
("2984","0","5.124.119.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-02-02 16:08:27","completed","",NULL),
("2985","0","37.254.167.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","124","125","","2020-02-02 22:37:06","completed","",NULL),
("2986","0","151.238.219.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-03 00:29:15","completed","",NULL),
("2987","0","86.57.80.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-03 00:31:16","completed","",NULL),
("2988","0","5.200.151.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","101","102","","2020-02-03 11:15:47","completed","",NULL),
("2989","0","62.102.143.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-03 11:52:09","completed","",NULL),
("2990","0","93.114.21.155","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-03 12:17:35","completed","",NULL),
("2991","0","93.114.21.155","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-03 12:18:07","completed","",NULL),
("2992","0","93.117.177.123","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-03 12:52:22","completed","",NULL),
("2993","0","5.124.119.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-03 18:04:53","completed","",NULL),
("2994","0","5.124.119.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-03 18:12:25","completed","",NULL),
("2995","120","151.239.148.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-03 18:36:26","completed","",NULL),
("2996","0","5.117.115.118","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-03 21:30:30","completed","",NULL),
("2997","0","151.235.30.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-03 22:03:42","completed","",NULL),
("2998","0","188.214.176.21","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15","66","67","","2020-02-04 01:01:22","completed","",NULL),
("2999","0","5.125.43.72","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-04 11:48:49","completed","",NULL),
("3000","0","178.131.145.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-04 20:03:50","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("3001","0","5.121.173.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-05 01:27:27","completed","",NULL),
("3002","0","5.121.173.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-05 01:29:20","completed","",NULL),
("3003","0","84.241.29.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-05 12:48:47","completed","",NULL),
("3004","0","86.57.49.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-06 01:36:02","completed","",NULL),
("3005","0","188.118.96.229","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-06 12:44:48","completed","",NULL),
("3006","0","86.57.38.230","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","99","100","","2020-02-06 14:51:50","completed","",NULL),
("3007","0","193.118.41.78","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/605.1","93","94","","2020-02-06 16:55:02","completed","",NULL),
("3008","0","193.118.41.78","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/79.0.3945.73 Mobile/15E148 Safari/605.1","93","94","","2020-02-06 16:55:07","completed","",NULL),
("3009","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","97","98","","2020-02-06 18:52:18","completed","",NULL),
("3010","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","99","100","","2020-02-06 18:52:25","completed","",NULL),
("3011","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","66","67","","2020-02-06 18:52:45","completed","",NULL),
("3012","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","68","69","","2020-02-06 18:52:54","completed","",NULL),
("3013","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","93","94","","2020-02-06 18:53:08","completed","",NULL),
("3014","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","101","102","","2020-02-06 18:53:41","completed","",NULL),
("3015","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","70","71","","2020-02-06 18:56:46","completed","",NULL),
("3016","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","64","65","","2020-02-06 18:57:05","completed","",NULL),
("3017","0","151.238.253.29","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-06 19:11:44","completed","",NULL),
("3018","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","97","98","","2020-02-06 19:22:16","completed","",NULL),
("3019","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","99","100","","2020-02-06 19:22:23","completed","",NULL),
("3020","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","66","67","","2020-02-06 19:24:14","completed","",NULL),
("3021","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","68","69","","2020-02-06 19:24:24","completed","",NULL),
("3022","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","93","94","","2020-02-06 19:24:31","completed","",NULL),
("3023","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","101","102","","2020-02-06 19:24:53","completed","",NULL),
("3024","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","70","71","","2020-02-06 19:26:50","completed","",NULL),
("3025","0","151.238.253.29","CyotekWebCopy/1.7 CyotekHTTP/2.0","64","65","","2020-02-06 19:27:02","completed","",NULL),
("3026","0","46.225.161.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","66","67","","2020-02-06 20:28:39","completed","",NULL),
("3027","0","46.225.161.95","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","68","69","","2020-02-06 20:36:52","completed","",NULL),
("3028","0","198.143.178.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-06 22:35:54","completed","",NULL),
("3029","0","5.122.131.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-07 00:00:53","completed","",NULL),
("3030","0","212.38.168.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-07 01:40:26","completed","",NULL),
("3031","0","178.131.145.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","99","100","","2020-02-07 13:09:56","completed","",NULL),
("3032","0","94.101.249.172","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-07 23:19:26","completed","",NULL),
("3033","0","62.102.130.204","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-07 23:30:51","completed","",NULL),
("3034","0","62.102.130.204","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","101","102","","2020-02-07 23:31:01","completed","",NULL),
("3035","0","5.236.96.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-08 09:04:11","completed","",NULL),
("3036","0","5.114.16.147","Mozilla/5.0 (Linux; Android 10; Mi 9T Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-02-08 13:29:05","completed","",NULL),
("3037","0","5.114.16.147","Mozilla/5.0 (Linux; Android 10; Mi 9T Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","97","98","","2020-02-08 13:29:18","completed","",NULL),
("3038","0","5.114.16.147","Mozilla/5.0 (Linux; Android 10; Mi 9T Pro) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","66","67","","2020-02-08 13:30:19","completed","",NULL),
("3039","0","93.110.97.165","Mozilla/5.0 (Linux; Android 9; SM-J730F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-02-08 17:16:36","completed","",NULL),
("3040","0","93.110.97.165","Mozilla/5.0 (Linux; Android 9; SM-J730F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-02-08 17:19:13","completed","",NULL),
("3041","0","2.183.36.177","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","124","125","","2020-02-08 21:26:34","completed","",NULL),
("3042","0","2.181.190.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","99","100","","2020-02-08 22:53:04","completed","",NULL),
("3043","0","80.210.38.146","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15","66","67","","2020-02-09 09:35:30","completed","",NULL),
("3044","0","178.131.145.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","93","94","","2020-02-10 00:53:53","completed","",NULL),
("3045","0","2.183.143.82","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) snap Chromium/80.0.3987.87 Chrome/80.0.3987.87 Safari/537.36","99","100","","2020-02-10 12:34:48","completed","",NULL),
("3046","0","5.112.46.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","124","125","","2020-02-10 15:06:01","completed","",NULL),
("3047","0","51.68.161.9","Mozilla/5.0 (Android 8.0.0; Mobile; rv:67.0) Gecko/67.0 Firefox/67.0","99","100","","2020-02-10 15:17:37","completed","",NULL),
("3048","0","5.200.159.27","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","124","125","","2020-02-11 22:31:35","completed","",NULL),
("3049","0","5.123.132.209","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-12 10:36:58","completed","",NULL),
("3050","0","79.127.58.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-12 11:18:17","completed","",NULL),
("3051","0","5.123.21.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-12 14:23:39","completed","",NULL),
("3052","0","2.186.151.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.100 Safari/537.36","66","67","","2020-02-12 14:39:44","completed","",NULL),
("3053","0","31.56.72.248","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-12 15:40:37","completed","",NULL),
("3054","0","31.56.72.248","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-12 15:46:54","completed","",NULL),
("3055","0","85.203.45.140","Mozilla/5.0 (Linux; Android 8.0.0; WAS-LX1A) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","93","94","","2020-02-12 17:18:58","completed","",NULL),
("3056","0","31.56.72.248","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-12 19:13:58","completed","",NULL),
("3057","0","5.135.54.84","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-02-12 20:45:47","completed","",NULL),
("3058","0","5.135.54.84","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-12 20:48:16","completed","",NULL),
("3059","0","5.135.54.84","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-12 20:49:35","completed","",NULL),
("3060","0","31.58.162.136","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-13 11:35:55","completed","",NULL),
("3061","0","40.77.167.33","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","93","94","","2020-02-13 15:57:39","completed","",NULL),
("3062","0","94.130.237.170","Mozilla/5.0 (compatible; BLEXBot/1.0; +http://webmeup-crawler.com/)","66","67","","2020-02-13 23:46:31","completed","",NULL),
("3063","0","5.234.255.168","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-14 01:34:21","completed","",NULL),
("3064","0","136.244.110.88","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-14 05:24:34","completed","",NULL),
("3065","0","136.244.110.88","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-14 05:29:15","completed","",NULL),
("3066","0","5.52.18.201","Mozilla/5.0 (Linux; Android 7.1.1; E6633) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-14 14:13:03","completed","",NULL),
("3067","0","2.177.217.23","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-14 18:39:37","completed","",NULL),
("3068","0","2.177.217.23","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-02-14 18:41:20","completed","",NULL),
("3069","0","86.57.91.67","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36","99","100","","2020-02-15 00:37:24","completed","",NULL),
("3070","0","5.122.111.119","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-15 10:23:34","completed","",NULL),
("3071","0","8.43.121.219","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-02-15 15:41:56","completed","",NULL),
("3072","0","5.123.48.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-15 16:40:14","completed","",NULL),
("3073","0","5.22.58.96","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-15 17:16:18","completed","",NULL),
("3074","0","151.238.75.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2020-02-15 18:33:20","completed","",NULL),
("3075","0","5.22.58.96","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-15 19:27:29","completed","",NULL),
("3076","0","37.137.25.202","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","66","67","","2020-02-16 00:17:09","completed","",NULL),
("3077","0","37.137.25.202","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","97","98","","2020-02-16 00:19:17","completed","",NULL),
("3078","0","37.137.25.202","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","97","98","","2020-02-16 00:19:21","completed","",NULL),
("3079","0","5.202.191.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-16 16:24:50","completed","",NULL),
("3080","0","95.82.43.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-02-16 16:39:56","completed","",NULL),
("3081","0","37.148.48.177","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-02-16 20:46:28","completed","",NULL),
("3082","0","2.181.243.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-16 20:59:45","completed","",NULL),
("3083","0","2.181.243.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-16 20:59:46","completed","",NULL),
("3084","0","151.238.234.202","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-17 03:34:28","completed","",NULL),
("3085","0","5.208.183.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-17 12:03:35","completed","",NULL),
("3086","0","5.208.183.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-17 12:03:36","completed","",NULL),
("3087","0","5.117.72.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-17 13:00:31","completed","",NULL),
("3088","0","5.117.72.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-17 13:02:23","completed","",NULL),
("3089","0","5.117.72.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-17 13:02:27","completed","",NULL),
("3090","0","5.117.72.153","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","124","125","","2020-02-17 13:03:39","completed","",NULL),
("3091","0","81.16.117.98","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-17 16:48:01","completed","",NULL),
("3092","0","188.210.133.47","Mozilla/5.0 (Windows NT 6.1; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-17 17:17:46","completed","",NULL),
("3093","0","5.214.43.124","Mozilla/5.0 (Windows NT 6.1; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-17 19:31:01","completed","",NULL),
("3094","0","5.214.43.124","Mozilla/5.0 (Windows NT 6.1; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-17 19:35:27","completed","",NULL),
("3095","0","151.239.195.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-17 23:50:36","completed","",NULL),
("3096","0","151.239.195.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","99","100","","2020-02-17 23:52:40","completed","",NULL),
("3097","0","151.239.195.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-18 17:15:34","completed","",NULL),
("3098","0","45.76.45.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-18 23:09:33","completed","",NULL),
("3099","0","45.76.45.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-18 23:10:26","completed","",NULL),
("3100","0","45.76.45.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-18 23:14:14","completed","",NULL),
("3101","0","45.76.45.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","93","94","","2020-02-18 23:14:55","completed","",NULL),
("3102","0","45.76.45.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","93","94","","2020-02-18 23:15:13","completed","",NULL),
("3103","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-19 01:48:30","completed","",NULL),
("3104","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","124","125","","2020-02-19 01:49:06","completed","",NULL),
("3105","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-19 01:51:54","completed","",NULL),
("3106","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-19 01:51:59","completed","",NULL),
("3107","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","124","125","","2020-02-19 01:57:31","completed","",NULL),
("3108","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-19 01:57:33","completed","",NULL),
("3109","0","95.179.208.9","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-19 02:07:48","completed","",NULL),
("3110","0","5.113.197.159","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","66","67","","2020-02-19 02:09:14","completed","",NULL),
("3111","0","2.147.252.193","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-19 10:51:57","completed","",NULL),
("3112","0","91.98.69.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36 Edg/79.0.309.65","124","125","","2020-02-19 16:50:32","completed","",NULL),
("3113","0","2.183.13.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","93","94","","2020-02-19 18:29:57","completed","",NULL),
("3114","0","77.42.33.217","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","97","98","","2020-02-20 00:56:14","completed","",NULL),
("3115","0","91.98.69.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36 Edg/79.0.309.65","66","67","","2020-02-20 14:44:28","completed","",NULL),
("3116","0","91.98.69.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36 Edg/79.0.309.65","124","125","","2020-02-20 14:50:34","completed","",NULL),
("3117","1","2.147.183.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","99","100","","2020-02-20 16:09:29","completed","",NULL),
("3118","1","2.147.183.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","99","100","","2020-02-20 16:09:30","completed","",NULL),
("3119","1","2.147.183.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","99","100","","2020-02-20 16:09:32","completed","",NULL),
("3120","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-02-20 16:42:05","completed","",NULL),
("3121","0","46.225.162.104","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","68","69","","2020-02-21 12:48:32","completed","",NULL),
("3122","0","46.225.162.104","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","101","102","","2020-02-21 12:52:40","completed","",NULL),
("3123","0","37.129.21.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-21 13:49:22","completed","",NULL),
("3124","0","37.129.21.27","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","99","100","","2020-02-21 13:49:25","completed","",NULL),
("3125","0","95.179.167.85","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-21 16:08:25","completed","",NULL),
("3126","0","196.196.193.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-21 20:59:30","completed","",NULL),
("3127","0","196.196.193.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-21 21:01:23","completed","",NULL),
("3128","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-22 00:22:31","completed","",NULL),
("3129","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-22 00:23:41","completed","",NULL),
("3130","0","5.219.131.237","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","68","69","","2020-02-22 02:34:01","completed","",NULL),
("3131","0","82.102.14.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","66","67","","2020-02-22 10:25:02","completed","",NULL),
("3132","0","2.179.135.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:72.0) Gecko/20100101 Firefox/72.0","93","94","","2020-02-22 10:27:53","completed","",NULL),
("3133","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-02-22 11:21:22","completed","",NULL),
("3134","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-02-22 11:23:31","completed","",NULL),
("3135","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-02-22 11:31:38","completed","",NULL),
("3136","0","92.50.34.124","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","93","94","","2020-02-22 11:52:00","completed","",NULL),
("3137","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","93","94","","2020-02-22 12:49:42","completed","",NULL),
("3138","1","2.147.171.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","101","102","","2020-02-22 13:00:19","completed","",NULL),
("3139","1","2.147.171.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","101","102","","2020-02-22 13:00:22","completed","",NULL),
("3140","0","196.196.193.75","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-22 13:47:24","completed","",NULL),
("3141","0","89.196.40.170","Mozilla/5.0 (Linux; Android 9; SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Mobile Safari/537.36","93","94","","2020-02-22 14:01:26","completed","",NULL),
("3142","0","89.199.162.183","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","124","125","","2020-02-22 17:34:52","completed","",NULL),
("3143","0","89.199.162.183","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","93","94","","2020-02-22 18:01:12","completed","",NULL),
("3144","0","81.92.200.249","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","93","94","","2020-02-22 18:07:50","completed","",NULL),
("3145","0","81.92.200.249","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","97","98","","2020-02-22 18:08:17","completed","",NULL),
("3146","0","2.147.173.164","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","93","94","","2020-02-22 20:06:55","completed","",NULL),
("3147","0","62.102.130.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-23 12:28:56","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3148","0","84.17.50.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36","97","98","","2020-02-23 13:11:47","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3149","0","31.56.72.99","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-23 19:39:12","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3150","0","31.56.72.99","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-23 19:39:31","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3151","136","2.180.71.60","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.26 Safari/537.36","101","102","","2020-02-23 20:09:16","completed","",NULL),
("3152","0","40.77.167.155","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","93","94","","2020-02-23 21:49:49","completed","",NULL),
("3153","0","31.56.65.130","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-23 22:04:25","completed","",NULL),
("3154","0","31.56.65.130","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-23 22:11:47","completed","",NULL),
("3155","0","31.56.65.130","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-23 22:11:49","completed","",NULL),
("3156","0","31.56.70.92","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-23 22:22:27","completed","",NULL),
("3157","0","93.114.27.198","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-23 23:40:12","completed","",NULL),
("3158","0","207.46.13.117","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","99","100","","2020-02-24 01:57:33","completed","",NULL),
("3159","0","217.138.194.30","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","66","67","","2020-02-24 11:31:02","completed","",NULL),
("3160","0","51.68.141.253","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-24 11:40:42","completed","",NULL),
("3161","0","51.68.141.253","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-24 11:40:53","completed","",NULL),
("3162","0","37.129.190.10","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-24 11:49:31","completed","",NULL),
("3163","0","5.125.99.252","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-24 13:20:15","completed","",NULL),
("3164","0","204.18.158.226","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","99","100","","2020-02-24 13:31:19","completed","",NULL),
("3165","0","54.37.73.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-24 14:24:10","completed","",NULL),
("3166","0","54.37.73.110","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-24 14:24:10","completed","",NULL),
("3167","0","77.42.36.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-02-24 17:35:43","completed","",NULL),
("3168","0","151.246.230.134","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-24 18:25:05","completed","",NULL),
("3169","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:25:29","completed","",NULL),
("3170","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","93","94","","2020-02-24 18:26:21","completed","",NULL),
("3171","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:26:56","completed","",NULL),
("3172","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:27:02","completed","",NULL),
("3173","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:27:05","completed","",NULL),
("3174","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","93","94","","2020-02-24 18:27:18","completed","",NULL),
("3175","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","93","94","","2020-02-24 18:27:40","completed","",NULL),
("3176","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:28:12","completed","",NULL),
("3177","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","93","94","","2020-02-24 18:29:02","completed","",NULL),
("3178","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","93","94","","2020-02-24 18:29:03","completed","",NULL),
("3179","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:30:10","completed","",NULL),
("3180","0","151.246.230.134","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-24 18:30:22","completed","",NULL),
("3181","0","217.23.13.114","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-24 20:00:10","completed","",NULL),
("3182","0","2.178.103.247","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-24 22:48:55","completed","",NULL),
("3183","0","5.219.146.20","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-24 22:50:07","completed","",NULL),
("3184","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-02-24 23:22:45","completed","",NULL),
("3185","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-02-24 23:24:07","completed","",NULL),
("3186","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","124","125","","2020-02-24 23:24:48","completed","",NULL),
("3187","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-02-24 23:25:55","completed","",NULL),
("3188","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","93","94","","2020-02-24 23:27:10","completed","",NULL),
("3189","0","193.148.65.89","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","93","94","","2020-02-24 23:28:56","completed","",NULL),
("3190","0","5.52.214.240","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-A605G) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36","93","94","","2020-02-24 23:35:48","completed","",NULL),
("3191","138","5.122.141.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-24 23:57:54","completed","",NULL),
("3192","138","5.122.141.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-24 23:57:57","completed","",NULL),
("3193","138","5.122.141.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-24 23:57:59","completed","",NULL),
("3194","138","5.122.141.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-24 23:57:59","completed","",NULL),
("3195","0","31.47.57.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-02-25 08:48:01","completed","",NULL),
("3196","0","31.47.57.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","99","100","","2020-02-25 08:50:11","completed","",NULL),
("3197","0","31.47.57.130","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","68","69","","2020-02-25 08:55:26","completed","",NULL),
("3198","0","89.196.70.25","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Safari/537.36","66","67","","2020-02-25 11:06:09","completed","",NULL),
("3199","0","31.56.52.134","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","99","100","","2020-02-25 11:30:31","completed","",NULL),
("3200","0","5.124.221.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-25 17:22:58","completed","",NULL),
("3201","0","85.96.102.152","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","101","102","","2020-02-25 23:42:51","completed","",NULL),
("3202","0","8.18.50.102","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/95.0.296015020 Mobile/15E148 Safari/605.1","66","67","","2020-02-26 12:08:40","completed","",NULL),
("3203","0","89.196.124.219","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-26 12:18:11","completed","",NULL),
("3204","0","176.42.206.9","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","93","94","","2020-02-26 12:28:11","completed","",NULL),
("3205","0","77.42.2.21","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-26 13:14:56","completed","",NULL),
("3206","0","77.42.2.21","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-26 13:23:14","completed","",NULL),
("3207","0","78.129.171.168","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","68","69","","2020-02-26 15:21:10","completed","",NULL),
("3208","0","62.102.143.127","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","68","69","","2020-02-26 18:23:04","completed","",NULL),
("3209","0","2.147.227.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-26 21:23:04","completed","",NULL),
("3210","0","2.147.227.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-26 21:32:12","completed","",NULL),
("3211","0","5.113.166.232","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-27 02:28:17","completed","",NULL),
("3212","0","5.113.166.232","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-27 02:28:21","completed","",NULL),
("3213","0","5.113.166.232","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-27 02:52:35","completed","",NULL),
("3214","0","5.113.166.232","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-27 02:52:36","completed","",NULL),
("3215","0","157.55.39.103","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","97","98","","2020-02-27 18:47:10","completed","",NULL),
("3216","0","5.119.144.91","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-27 18:59:08","completed","",NULL),
("3217","0","5.115.1.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-02-27 20:19:13","completed","",NULL),
("3218","0","5.115.1.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-02-27 20:21:28","completed","",NULL),
("3219","0","2.147.90.104","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-27 21:11:39","completed","",NULL),
("3220","0","83.123.47.94","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)","93","94","","2020-02-27 21:15:55","completed","",NULL),
("3221","0","83.123.47.94","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)","124","125","","2020-02-27 21:15:56","completed","",NULL),
("3222","0","83.123.47.94","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)","66","67","","2020-02-27 21:16:00","completed","",NULL),
("3223","0","93.117.183.209","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-27 21:18:22","completed","",NULL),
("3224","0","5.115.1.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-27 21:40:00","completed","",NULL),
("3225","0","151.247.235.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-02-28 11:36:42","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3226","0","151.247.235.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-02-28 11:36:57","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3227","0","91.98.69.35","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36 Edg/79.0.309.65","66","67","","2020-02-28 11:57:50","redirected","تغییر مسیر به فایل راه دور.",NULL),
("3228","0","5.116.26.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-02-28 14:35:35","completed","",NULL),
("3229","0","5.116.26.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-02-28 14:35:53","completed","",NULL),
("3230","0","5.202.96.96","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-02-28 15:39:15","completed","",NULL),
("3231","0","46.4.213.194","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36 OPR/66.0.3515.115","124","125","","2020-02-28 16:35:36","completed","",NULL),
("3232","144","5.119.166.183","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-02-28 16:57:51","completed","",NULL),
("3233","0","2.191.214.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","99","100","","2020-02-28 17:03:19","completed","",NULL),
("3234","0","2.191.214.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","97","98","","2020-02-28 17:03:29","completed","",NULL),
("3235","0","2.191.214.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.106 Safari/537.36","93","94","","2020-02-28 17:05:31","completed","",NULL),
("3236","0","149.28.48.43","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","124","125","","2020-02-28 17:38:13","completed","",NULL),
("3237","0","151.247.235.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-02-28 18:55:38","completed","",NULL),
("3238","0","151.247.235.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","101","102","","2020-02-28 19:12:37","completed","",NULL),
("3239","0","91.132.138.86","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-28 19:38:47","completed","",NULL),
("3240","0","93.117.178.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","68","69","","2020-02-28 21:43:28","completed","",NULL),
("3241","0","93.117.178.106","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","68","69","","2020-02-28 21:43:32","completed","",NULL),
("3242","0","93.117.178.106","Mozilla/5.0 (Linux; Android 10; SM-G960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-28 21:53:52","completed","",NULL),
("3243","0","93.117.178.106","Mozilla/5.0 (Linux; Android 10; SM-G960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","99","100","","2020-02-28 21:53:58","completed","",NULL),
("3244","0","93.117.178.106","Mozilla/5.0 (Linux; Android 10; SM-G960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-28 21:54:00","completed","",NULL),
("3245","0","93.117.178.106","Mozilla/5.0 (Linux; Android 10; SM-G960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-28 21:54:12","completed","",NULL),
("3246","0","93.117.178.106","Mozilla/5.0 (Linux; Android 10; SM-G960F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-28 21:54:25","completed","",NULL),
("3247","0","176.42.206.9","Mozilla/5.0 (Linux; Android 7.0; SM-T715) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Safari/537.36","93","94","","2020-02-29 00:05:46","completed","",NULL),
("3248","0","176.42.206.9","Mozilla/5.0 (Linux; Android 7.0; SM-T715) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Safari/537.36","124","125","","2020-02-29 00:15:47","completed","",NULL),
("3249","0","176.42.206.9","Mozilla/5.0 (Linux; Android 7.0; SM-T715) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Safari/537.36","124","125","","2020-02-29 00:22:04","completed","",NULL),
("3250","0","176.42.206.9","Mozilla/5.0 (Linux; Android 7.0; SM-T715) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.105 Safari/537.36","93","94","","2020-02-29 00:27:56","completed","",NULL),
("3251","0","5.212.25.161","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-02-29 00:32:05","completed","",NULL),
("3252","0","5.212.25.161","Mozilla/5.0 (Linux; Android 9; SM-J730GM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","99","100","","2020-02-29 00:32:55","completed","",NULL),
("3253","0","82.99.214.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-02-29 09:26:13","completed","",NULL),
("3254","0","37.139.12.210","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-02-29 18:02:37","completed","",NULL),
("3255","0","5.121.208.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","93","94","","2020-02-29 18:23:41","completed","",NULL),
("3256","0","5.121.208.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-02-29 18:26:32","completed","",NULL),
("3257","0","5.121.208.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","68","69","","2020-02-29 18:29:12","completed","",NULL),
("3258","0","91.133.169.0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","99","100","","2020-02-29 22:43:18","completed","",NULL),
("3259","0","176.218.196.184","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-01 00:23:25","completed","",NULL),
("3260","0","5.127.74.161","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-01 01:00:16","completed","",NULL),
("3261","0","46.225.212.6","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-01 02:28:45","completed","",NULL),
("3262","0","46.224.229.83","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-01 03:34:29","completed","",NULL),
("3263","0","5.119.37.77","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","93","94","","2020-03-01 16:09:13","completed","",NULL),
("3264","0","5.120.26.10","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","124","125","","2020-03-01 19:41:45","completed","",NULL),
("3265","0","5.120.98.54","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-01 20:05:00","completed","",NULL),
("3266","0","5.120.98.54","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","93","94","","2020-03-01 20:24:52","completed","",NULL),
("3267","0","151.243.190.178","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-01 20:56:50","completed","",NULL),
("3268","0","78.46.11.251","Mozilla/5.0 (Linux; Android 10; SM-G975F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.117 Mobile Safari/537.36","66","67","","2020-03-02 00:13:21","completed","",NULL),
("3269","0","78.46.11.251","Mozilla/5.0 (Linux; Android 10; SM-G975F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.117 Mobile Safari/537.36","66","67","","2020-03-02 00:13:50","completed","",NULL),
("3270","0","94.183.114.21","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-02 10:27:56","completed","",NULL),
("3271","0","8.18.50.102","Mozilla/5.0 (iPhone; CPU iPhone OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/95.0.296015020 Mobile/15E148 Safari/605.1","66","67","","2020-03-02 10:59:58","completed","",NULL),
("3272","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-02 12:13:00","completed","",NULL),
("3273","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","99","100","","2020-03-02 12:15:30","completed","",NULL),
("3274","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","68","69","","2020-03-02 12:15:49","completed","",NULL),
("3275","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","99","100","","2020-03-02 12:16:04","completed","",NULL),
("3276","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-02 12:16:35","completed","",NULL),
("3277","0","5.121.162.246","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","68","69","","2020-03-02 12:16:42","completed","",NULL),
("3278","0","5.115.214.92","Mozilla/5.0 (Linux; Android 9; ANE-LX1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","66","67","","2020-03-02 14:54:50","completed","",NULL),
("3279","0","5.115.214.92","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Safari/537.36","66","67","","2020-03-02 15:01:21","completed","",NULL),
("3280","0","5.127.166.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-02 15:39:58","completed","",NULL),
("3281","0","5.127.166.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-02 15:42:15","completed","",NULL),
("3282","0","5.127.166.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-02 15:47:17","completed","",NULL),
("3283","0","5.127.166.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","99","100","","2020-03-02 15:48:09","completed","",NULL),
("3284","0","5.127.166.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-02 16:24:05","completed","",NULL),
("3285","0","178.62.188.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-03 10:32:24","completed","",NULL),
("3286","0","81.91.156.138","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-03 11:59:58","completed","",NULL),
("3287","0","92.242.213.73","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-03-03 12:11:35","completed","",NULL),
("3288","0","113.203.21.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-03 13:49:00","completed","",NULL),
("3289","0","37.98.37.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","101","102","","2020-03-03 13:50:09","completed","",NULL),
("3290","0","151.240.81.210","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-03 21:28:46","completed","",NULL),
("3291","0","151.240.81.210","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-03 21:30:01","completed","",NULL),
("3292","0","207.46.13.242","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","99","100","","2020-03-04 06:13:57","completed","",NULL),
("3293","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:42:31","completed","",NULL),
("3294","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:42:37","completed","",NULL),
("3295","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:42:37","completed","",NULL),
("3296","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:42:40","completed","",NULL),
("3297","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:42:56","completed","",NULL),
("3298","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","124","125","","2020-03-04 10:43:02","completed","",NULL),
("3299","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:43:21","completed","",NULL),
("3300","0","178.131.216.100","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-04 10:43:21","completed","",NULL),
("3301","0","40.77.167.9","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","93","94","","2020-03-04 14:06:58","completed","",NULL),
("3302","0","83.123.149.31","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-04 17:03:22","completed","",NULL),
("3303","0","5.209.223.14","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-04 17:25:45","completed","",NULL),
("3304","0","37.98.37.187","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","124","125","","2020-03-04 20:20:47","completed","",NULL),
("3305","0","5.239.12.6","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","99","100","","2020-03-04 21:10:34","completed","",NULL),
("3306","0","85.204.83.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","124","125","","2020-03-04 23:32:52","completed","",NULL),
("3307","0","85.204.83.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-05 00:05:36","completed","",NULL),
("3308","0","85.204.83.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-05 00:05:40","completed","",NULL),
("3309","0","46.101.13.124","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Safari/537.36","66","67","","2020-03-05 09:51:13","completed","",NULL),
("3310","1","2.147.54.209","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","113","114","","2020-03-05 12:42:54","completed","",NULL),
("3311","0","5.114.1.40","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-05 16:57:54","completed","",NULL),
("3312","0","5.114.1.40","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","93","94","","2020-03-05 17:02:42","completed","",NULL),
("3313","0","5.114.1.40","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-05 17:04:00","completed","",NULL),
("3314","0","5.117.164.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-05 19:42:00","completed","",NULL),
("3315","0","8.39.214.13","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.119 Mobile Safari/537.36","93","94","","2020-03-05 21:08:52","completed","",NULL),
("3316","0","8.39.214.25","Mozilla/5.0 (Linux; Android 9; SM-A205F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","66","67","","2020-03-06 01:54:45","completed","",NULL),
("3317","0","5.121.156.191","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-06 12:39:51","completed","",NULL),
("3318","0","5.124.73.237","Mozilla/5.0 (Linux; Android 6.0.1; HTC Desire 626s) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","66","67","","2020-03-06 13:44:10","completed","",NULL),
("3319","0","5.124.73.237","Mozilla/5.0 (Linux; Android 6.0.1; HTC Desire 626s) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-06 13:50:47","completed","",NULL),
("3320","0","5.124.73.237","Mozilla/5.0 (Linux; Android 6.0.1; HTC Desire 626s) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-06 13:51:57","completed","",NULL),
("3321","0","5.124.73.237","Mozilla/5.0 (Linux; Android 6.0.1; HTC Desire 626s) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-06 13:57:41","completed","",NULL),
("3322","0","5.115.207.74","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-06 17:02:59","completed","",NULL),
("3323","0","5.134.178.60","Mozilla/5.0 (Linux; Android 8.1.0; LAVA LN9810) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-03-06 17:44:43","completed","",NULL),
("3324","0","89.199.242.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-06 18:55:20","completed","",NULL),
("3325","0","83.121.166.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36 OPR/66.0.3515.44","99","100","","2020-03-06 20:39:28","completed","",NULL),
("3326","0","5.114.31.208","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-07 19:28:12","completed","",NULL),
("3327","0","5.114.105.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-07 20:57:01","completed","",NULL),
("3328","0","151.240.115.162","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","101","102","","2020-03-08 01:51:56","completed","",NULL),
("3329","0","91.185.155.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-08 02:12:36","completed","",NULL),
("3330","0","86.57.85.116","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-08 03:26:53","completed","",NULL),
("3331","0","176.42.206.9","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Mobile Safari/537.36","66","67","","2020-03-08 13:03:58","completed","",NULL),
("3332","0","176.42.206.9","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Mobile Safari/537.36","66","67","","2020-03-08 13:03:58","completed","",NULL),
("3333","0","176.42.206.9","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Mobile Safari/537.36","66","67","","2020-03-08 13:04:01","completed","",NULL),
("3334","0","176.42.206.9","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36","99","100","","2020-03-08 13:05:43","completed","",NULL),
("3335","0","5.212.26.11","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","93","94","","2020-03-08 14:13:58","completed","",NULL),
("3336","0","5.124.77.131","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-08 20:15:02","completed","",NULL),
("3337","0","157.55.39.176","Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)","97","98","","2020-03-08 21:29:47","completed","",NULL),
("3338","0","2.190.13.108","Mozilla/5.0 (Linux; Android 9; ZTE Blade V1000) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-09 06:08:24","completed","",NULL),
("3339","0","178.131.146.135","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-09 07:31:55","completed","",NULL),
("3340","0","5.22.77.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-09 12:51:55","completed","",NULL),
("3341","0","5.22.77.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-09 12:53:27","completed","",NULL),
("3342","0","5.22.77.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-09 12:53:48","completed","",NULL),
("3343","0","5.22.77.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-09 13:01:17","completed","",NULL),
("3344","0","5.22.77.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-09 13:11:47","completed","",NULL),
("3345","0","178.33.21.12","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-09 14:14:06","completed","",NULL),
("3346","0","178.33.21.12","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-09 14:16:08","completed","",NULL),
("3347","0","81.16.117.84","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-09 19:07:09","completed","",NULL),
("3348","0","217.69.7.200","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-09 23:57:45","completed","",NULL),
("3349","0","217.69.7.200","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","97","98","","2020-03-09 23:59:00","completed","",NULL),
("3350","0","91.99.130.143","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-11 00:00:56","completed","",NULL),
("3351","0","195.181.104.66","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-11 01:35:46","completed","",NULL),
("3352","0","5.119.205.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","99","100","","2020-03-11 03:52:38","completed","",NULL),
("3353","0","5.52.48.132","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Mobile Safari/537.36","66","67","","2020-03-11 14:45:58","completed","",NULL),
("3354","0","5.52.48.132","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Safari/537.36","66","67","","2020-03-11 14:46:11","completed","",NULL),
("3355","0","5.52.48.132","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Mobile Safari/537.36","93","94","","2020-03-11 14:52:59","completed","",NULL),
("3356","0","5.52.48.132","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Mobile Safari/537.36","93","94","","2020-03-11 14:54:03","completed","",NULL),
("3357","0","5.52.48.132","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Mobile Safari/537.36","93","94","","2020-03-11 15:01:06","completed","",NULL),
("3358","0","5.125.151.181","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","101","102","","2020-03-11 23:57:54","completed","",NULL),
("3359","0","5.160.105.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2020-03-12 00:26:47","completed","",NULL),
("3360","0","5.160.105.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","68","69","","2020-03-12 00:27:44","completed","",NULL),
("3361","0","5.160.105.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36","99","100","","2020-03-12 00:31:51","completed","",NULL),
("3362","0","46.225.215.217","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-12 00:41:09","completed","",NULL),
("3363","0","46.225.215.217","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","101","102","","2020-03-12 00:43:59","completed","",NULL),
("3364","0","2.179.141.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-12 07:56:07","completed","",NULL),
("3365","0","93.174.95.6","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-12 09:41:51","completed","",NULL),
("3366","0","151.246.224.11","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-12 13:36:15","completed","",NULL),
("3367","0","93.119.83.67","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-12 20:19:47","completed","",NULL),
("3368","0","2.191.37.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-12 21:46:44","completed","",NULL),
("3369","0","173.199.70.72","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.136 Mobile Safari/537.36","66","67","","2020-03-13 01:15:33","completed","",NULL),
("3370","0","5.121.55.196","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-13 13:51:53","completed","",NULL),
("3371","0","5.121.55.196","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","64","65","","2020-03-13 13:52:28","completed","",NULL),
("3372","0","5.22.50.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-14 02:10:25","completed","",NULL),
("3373","0","185.191.207.169","Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-J610F) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/11.1 Chrome/75.0.3770.143 Mobile Safari/537.36","66","67","","2020-03-14 06:21:33","completed","",NULL),
("3374","0","87.239.255.112","Mozilla/5.0 (Linux; Android 6.0.1; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","93","94","","2020-03-14 09:45:59","completed","",NULL),
("3375","0","87.239.255.112","Mozilla/5.0 (Linux; Android 6.0.1; SM-G570F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","93","94","","2020-03-14 09:47:44","completed","",NULL),
("3376","0","151.240.82.113","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Safari/537.36","93","94","","2020-03-14 13:55:36","completed","",NULL),
("3377","0","151.240.82.113","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Safari/537.36","99","100","","2020-03-14 13:55:59","completed","",NULL),
("3378","0","151.240.82.113","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Safari/537.36","93","94","","2020-03-14 13:56:07","completed","",NULL),
("3379","0","151.240.82.113","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Safari/537.36","101","102","","2020-03-14 13:56:12","completed","",NULL),
("3380","0","151.240.82.113","Mozilla/5.0 (Linux; Android 9; HRY-LX1MEB) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-14 13:56:48","completed","",NULL),
("3381","0","217.24.157.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-14 20:05:39","completed","",NULL),
("3382","0","5.121.98.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-15 00:17:06","completed","",NULL),
("3383","0","5.121.98.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-15 00:25:25","completed","",NULL),
("3384","0","5.121.98.68","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-15 00:55:10","completed","",NULL),
("3385","0","93.37.132.160","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-15 01:25:52","completed","",NULL),
("3386","0","151.245.155.93","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-15 04:06:04","completed","",NULL),
("3387","0","188.159.191.92","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","124","125","","2020-03-15 04:10:45","completed","",NULL),
("3388","0","46.209.177.67","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-15 10:45:59","completed","",NULL),
("3389","0","5.233.153.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-15 13:41:19","completed","",NULL),
("3390","0","5.200.246.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-15 22:52:16","completed","",NULL),
("3391","0","89.39.107.190","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-15 23:00:13","completed","",NULL),
("3392","0","5.200.246.163","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","101","102","","2020-03-16 00:38:08","completed","",NULL),
("3393","0","46.143.127.185","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","99","100","","2020-03-16 02:39:29","completed","",NULL),
("3394","158","5.232.93.137","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","97","98","","2020-03-16 11:36:57","completed","",NULL),
("3395","0","188.212.243.243","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-16 12:56:57","completed","",NULL),
("3396","0","5.126.201.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-03-16 14:52:57","completed","",NULL),
("3397","0","164.138.141.73","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","97","98","","2020-03-16 15:33:27","completed","",NULL),
("3398","0","164.138.141.73","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","66","67","","2020-03-16 15:34:03","completed","",NULL),
("3399","0","164.138.141.73","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","66","67","","2020-03-16 15:36:50","completed","",NULL),
("3400","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-16 17:19:31","completed","",NULL),
("3401","0","5.125.144.32","Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A372 Safari/604.1","99","100","","2020-03-16 17:20:28","completed","",NULL),
("3402","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-16 17:24:11","completed","",NULL),
("3403","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","97","98","","2020-03-16 17:32:58","completed","",NULL),
("3404","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-16 17:33:20","completed","",NULL),
("3405","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-16 17:33:25","completed","",NULL),
("3406","0","83.122.21.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-16 17:33:54","completed","",NULL),
("3407","0","83.122.21.182","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-16 17:34:55","completed","",NULL),
("3408","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-16 17:44:57","completed","",NULL),
("3409","0","37.137.14.87","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 17:45:05","completed","",NULL),
("3410","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-16 17:48:22","completed","",NULL),
("3411","0","5.208.99.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 17:50:51","completed","",NULL),
("3412","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:02:22","completed","",NULL),
("3413","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","68","69","","2020-03-16 18:02:39","completed","",NULL),
("3414","0","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-16 18:03:19","completed","",NULL),
("3415","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-16 18:06:30","completed","",NULL),
("3416","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:21:23","completed","",NULL),
("3417","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:22:34","completed","",NULL),
("3418","0","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:22:51","completed","",NULL),
("3419","0","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-16 18:23:20","completed","",NULL),
("3420","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:23:46","completed","",NULL),
("3421","0","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:23:58","completed","",NULL),
("3422","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:24:48","completed","",NULL),
("3423","159","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:25:01","completed","",NULL),
("3424","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:25:51","completed","",NULL),
("3425","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:27:04","completed","",NULL),
("3426","159","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:27:11","completed","",NULL),
("3427","159","5.125.144.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-16 18:28:09","completed","",NULL),
("3428","159","5.125.144.32","Mozilla/5.0 (Linux; Android 6.0.1; P024) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-16 18:29:54","completed","",NULL),
("3429","0","151.241.47.173","Mozilla/5.0 (iPhone; CPU iPhone OS 12_1_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1","124","125","","2020-03-17 04:35:40","completed","",NULL),
("3430","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:37","completed","",NULL),
("3431","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:47","completed","",NULL),
("3432","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:47","completed","",NULL),
("3433","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:47","completed","",NULL),
("3434","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:48","completed","",NULL),
("3435","0","93.119.210.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 10:16:49","completed","",NULL),
("3436","0","5.112.240.75","Mozilla/5.0 (Linux; Android 9; Nokia 6.2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","93","94","","2020-03-17 10:38:18","completed","",NULL),
("3437","1","2.147.6.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","113","114","","2020-03-17 11:12:49","completed","",NULL),
("3438","1","2.147.6.164","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","101","102","","2020-03-17 11:13:23","completed","",NULL),
("3439","0","178.33.10.41","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 12:25:42","completed","",NULL),
("3440","0","178.33.10.41","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 12:26:49","completed","",NULL),
("3441","0","178.33.10.41","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 12:27:52","completed","",NULL),
("3442","0","178.33.10.41","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 12:29:05","completed","",NULL),
("3443","0","5.124.149.38","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 14:42:39","completed","",NULL),
("3444","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:20:58","completed","",NULL),
("3445","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:21:57","completed","",NULL),
("3446","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:22:09","completed","",NULL),
("3447","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:22:26","completed","",NULL),
("3448","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:22:38","completed","",NULL),
("3449","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:22:51","completed","",NULL),
("3450","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:23:03","completed","",NULL),
("3451","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:23:15","completed","",NULL),
("3452","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:23:28","completed","",NULL),
("3453","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:23:40","completed","",NULL),
("3454","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:23:52","completed","",NULL),
("3455","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 17:24:04","completed","",NULL),
("3456","158","2.183.191.142","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-17 20:23:52","completed","",NULL),
("3457","0","2.182.93.121","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-17 21:10:27","completed","",NULL),
("3458","0","5.127.47.103","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-17 21:32:35","completed","",NULL),
("3459","0","5.123.92.52","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-17 23:38:50","completed","",NULL),
("3460","0","178.203.85.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-18 00:32:52","completed","",NULL),
("3461","0","178.203.85.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-18 00:33:45","completed","",NULL),
("3462","0","178.203.85.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-18 02:44:23","completed","",NULL),
("3463","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 09:57:10","completed","",NULL),
("3464","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:09:25","completed","",NULL),
("3465","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:10:23","completed","",NULL),
("3466","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:11:34","completed","",NULL),
("3467","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:12:35","completed","",NULL),
("3468","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:13:47","completed","",NULL),
("3469","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:14:55","completed","",NULL),
("3470","0","151.246.237.233","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 14:16:05","completed","",NULL),
("3471","0","2.191.5.72","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-18 16:22:56","completed","",NULL),
("3472","0","5.117.8.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-18 18:35:57","completed","",NULL),
("3473","0","89.199.250.0","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-03-18 20:04:25","completed","",NULL),
("3474","0","178.131.61.23","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","68","69","","2020-03-19 00:08:50","completed","",NULL),
("3475","0","86.55.62.197","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","99","100","","2020-03-19 00:33:50","completed","",NULL),
("3476","0","5.117.182.85","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-19 02:10:20","completed","",NULL),
("3477","0","204.18.180.131","Mozilla/5.0 (Linux; Android 7.0; SM-A710F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.136 Mobile Safari/537.36","97","98","","2020-03-19 02:30:57","completed","",NULL),
("3478","0","87.107.253.28","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","99","100","","2020-03-19 04:13:42","completed","",NULL),
("3479","0","89.199.131.48","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.104 Safari/537.36","66","67","","2020-03-19 08:20:59","completed","",NULL),
("3480","164","5.200.162.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-19 10:30:32","completed","",NULL),
("3481","164","5.200.162.231","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","95","96","","2020-03-19 10:34:07","completed","",NULL),
("3482","0","185.38.151.163","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-19 12:10:22","completed","",NULL),
("3483","0","185.38.151.163","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-19 12:12:58","completed","",NULL),
("3484","0","5.119.165.193","Mozilla/5.0 (Windows NT 6.1; rv:73.0) Gecko/20100101 Firefox/73.0","66","67","","2020-03-19 13:00:20","completed","",NULL),
("3485","0","2.182.100.37","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","99","100","","2020-03-19 13:21:16","completed","",NULL),
("3486","0","95.82.45.29","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-19 13:25:05","completed","",NULL),
("3487","0","185.165.241.36","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-19 14:14:03","completed","",NULL),
("3488","0","37.27.211.86","Mozilla/5.0 (Linux; Android 6.0; CHM-U01 Build/HonorCHM-U01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.81 Mobile Safari/537.36","93","94","","2020-03-19 14:53:28","completed","",NULL),
("3489","0","37.27.211.86","Mozilla/5.0 (Linux; Android 6.0; CHM-U01 Build/HonorCHM-U01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.81 Mobile Safari/537.36","93","94","","2020-03-19 14:53:30","completed","",NULL),
("3490","0","5.114.64.44","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-19 14:58:13","completed","",NULL),
("3491","0","95.82.45.29","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-19 15:17:28","completed","",NULL),
("3492","0","95.82.45.29","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-19 15:32:17","completed","",NULL),
("3493","0","93.110.171.186","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","93","94","","2020-03-19 16:13:17","completed","",NULL),
("3494","0","2.181.76.237","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-19 16:58:33","completed","",NULL),
("3495","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 17:12:34","completed","",NULL),
("3496","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 17:57:33","completed","",NULL),
("3497","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 17:58:37","completed","",NULL),
("3498","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 17:59:58","completed","",NULL),
("3499","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 18:01:14","completed","",NULL),
("3500","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 18:02:25","completed","",NULL);

INSERT INTO `wp_download_log` VALUES 
("3501","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 18:03:44","completed","",NULL),
("3502","0","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 18:04:56","completed","",NULL),
("3503","0","5.124.90.10","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-19 18:31:01","completed","",NULL),
("3504","166","5.160.168.99","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Safari/605.1.15","66","67","","2020-03-19 18:41:37","completed","",NULL),
("3505","0","2.147.150.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-19 19:23:25","completed","",NULL),
("3506","0","2.147.150.32","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-19 19:23:57","completed","",NULL),
("3507","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:18:07","completed","",NULL),
("3508","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:22:06","completed","",NULL),
("3509","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:22:19","completed","",NULL),
("3510","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:22:31","completed","",NULL),
("3511","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:22:43","completed","",NULL),
("3512","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:22:56","completed","",NULL),
("3513","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:23:08","completed","",NULL),
("3514","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:23:21","completed","",NULL),
("3515","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:23:33","completed","",NULL),
("3516","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:23:46","completed","",NULL),
("3517","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:23:59","completed","",NULL),
("3518","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:24:12","completed","",NULL),
("3519","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:24:28","completed","",NULL),
("3520","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:24:41","completed","",NULL),
("3521","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:24:54","completed","",NULL),
("3522","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:25:08","completed","",NULL),
("3523","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:25:24","completed","",NULL),
("3524","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:25:37","completed","",NULL),
("3525","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:25:50","completed","",NULL),
("3526","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:26:03","completed","",NULL),
("3527","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:26:16","completed","",NULL),
("3528","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:26:30","completed","",NULL),
("3529","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:26:43","completed","",NULL),
("3530","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:26:56","completed","",NULL),
("3531","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:27:09","completed","",NULL),
("3532","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:27:23","completed","",NULL),
("3533","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:27:37","completed","",NULL),
("3534","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:27:51","completed","",NULL),
("3535","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:28:04","completed","",NULL),
("3536","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:28:18","completed","",NULL),
("3537","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:28:32","completed","",NULL),
("3538","0","178.131.213.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 00:28:45","completed","",NULL),
("3539","0","2.181.99.33","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 01:17:34","completed","",NULL),
("3540","0","178.131.138.41","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-20 01:22:40","completed","",NULL),
("3541","0","87.107.77.70","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0","101","102","","2020-03-20 01:49:33","completed","",NULL),
("3542","0","188.212.90.175","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 02:24:22","completed","",NULL),
("3543","0","188.212.90.175","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 02:25:14","completed","",NULL),
("3544","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 05:05:41","completed","",NULL),
("3545","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 05:05:42","completed","",NULL),
("3546","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 05:05:44","completed","",NULL),
("3547","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 05:05:46","completed","",NULL),
("3548","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 05:05:48","completed","",NULL),
("3549","0","109.108.189.8","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","68","69","","2020-03-20 05:06:29","completed","",NULL),
("3550","0","93.110.32.212","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 06:19:11","completed","",NULL),
("3551","0","5.124.29.63","Mozilla/5.0 (Linux; Android 6.0; LG-K430) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","93","94","","2020-03-20 08:18:47","completed","",NULL),
("3552","0","5.117.85.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-20 09:28:59","completed","",NULL),
("3553","0","5.117.85.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-20 09:30:06","completed","",NULL),
("3554","0","5.117.85.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-20 09:31:10","completed","",NULL),
("3555","0","5.117.85.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-20 09:32:13","completed","",NULL),
("3556","0","5.117.85.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 09:47:15","completed","",NULL),
("3557","0","31.56.65.38","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","124","125","","2020-03-20 10:00:06","completed","",NULL),
("3558","0","31.56.65.38","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-20 10:00:53","completed","",NULL),
("3559","0","31.56.65.38","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-20 10:00:56","completed","",NULL),
("3560","0","5.114.64.116","Mozilla/5.0 (Linux; Android 8.0.0; MI 5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Mobile Safari/537.36","66","67","","2020-03-20 10:16:50","completed","",NULL),
("3561","0","81.19.208.112","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","93","94","","2020-03-20 10:23:13","completed","",NULL),
("3562","170","188.212.77.45","Mozilla/5.0 (Linux; Android 9; SM-A505F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","95","96","","2020-03-20 11:26:33","completed","",NULL),
("3563","0","5.114.141.187","Mozilla/5.0 (Windows NT 6.3; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-20 11:56:42","completed","",NULL),
("3564","0","192.99.220.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36","93","94","","2020-03-20 12:22:07","completed","",NULL),
("3565","0","37.27.68.254","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 12:52:53","completed","",NULL),
("3566","0","5.121.60.8","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","66","67","","2020-03-20 13:01:36","completed","",NULL),
("3567","0","5.213.132.109","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 13:24:24","completed","",NULL),
("3568","0","93.119.219.158","Mozilla/5.0 (Linux; Android 8.0; Pixel 2 Build/OPD3.170816.012) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-20 13:30:30","completed","",NULL),
("3569","171","51.158.125.167","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","124","125","","2020-03-20 13:37:14","completed","",NULL),
("3570","0","46.224.114.131","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","93","94","","2020-03-20 14:25:30","completed","",NULL),
("3571","0","2.181.191.121","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-20 14:33:31","completed","",NULL),
("3572","0","151.242.191.153","Mozilla/5.0 (Android 9; Mobile; rv:68.0) Gecko/68.0 Firefox/68.0","124","125","","2020-03-20 15:29:45","completed","",NULL),
("3573","0","5.212.99.71","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-20 15:36:36","completed","",NULL),
("3574","0","46.143.39.47","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-20 15:47:36","completed","",NULL),
("3575","0","46.225.185.157","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-20 17:24:08","completed","",NULL),
("3576","0","5.117.154.128","Mozilla/5.0 (Windows NT 6.1; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-20 18:12:29","completed","",NULL),
("3577","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:46:40","completed","",NULL),
("3578","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:47:12","completed","",NULL),
("3579","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:48:24","completed","",NULL),
("3580","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:49:37","completed","",NULL),
("3581","0","2.191.16.178","Mozilla/5.0 (Android 10; Mobile; rv:68.0) Gecko/68.0 Firefox/68.0","124","125","","2020-03-20 19:49:50","completed","",NULL),
("3582","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:50:40","completed","",NULL),
("3583","0","93.117.34.133","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36 OPR/67.0.3575.79","66","67","","2020-03-20 19:51:50","completed","",NULL),
("3584","0","207.244.109.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-20 19:56:19","completed","",NULL),
("3585","0","151.247.252.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 20:39:56","completed","",NULL),
("3586","0","151.247.252.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 20:41:24","completed","",NULL),
("3587","0","151.247.252.246","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36","97","98","","2020-03-20 20:42:36","completed","",NULL),
("3588","0","5.123.128.50","Mozilla/5.0 (Linux; Android 7.1.1; SM-J510F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","66","67","","2020-03-20 21:39:54","completed","",NULL),
("3589","0","5.123.112.174","Mozilla/5.0 (Linux; Android 6.0.1; SM-J700F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","66","67","","2020-03-20 21:43:22","completed","",NULL),
("3590","0","5.120.133.106","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-20 21:53:22","completed","",NULL),
("3591","0","86.57.22.246","Mozilla/5.0 (Linux; Android 9; SM-T515) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 21:58:45","completed","",NULL),
("3592","0","86.57.22.246","Mozilla/5.0 (Linux; Android 9; SM-T515) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 21:59:48","completed","",NULL),
("3593","0","5.78.234.123","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-20 22:24:45","completed","",NULL),
("3594","0","89.199.124.194","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-20 22:35:28","completed","",NULL),
("3595","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:40:57","completed","",NULL),
("3596","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:41:22","completed","",NULL),
("3597","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:42:28","completed","",NULL),
("3598","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:43:39","completed","",NULL),
("3599","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:44:48","completed","",NULL),
("3600","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:45:51","completed","",NULL),
("3601","0","89.165.66.19","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","66","67","","2020-03-20 22:46:52","completed","",NULL),
("3602","174","5.52.190.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 22:57:15","completed","",NULL),
("3603","174","5.52.190.210","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-20 22:58:20","completed","",NULL),
("3604","0","5.120.27.194","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-20 23:26:11","completed","",NULL),
("3605","0","5.62.186.17","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","124","125","","2020-03-21 19:19:32","completed","",NULL),
("3606","0","5.62.186.17","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-21 19:20:15","completed","",NULL),
("3607","0","5.218.208.2","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-21 20:28:24","completed","",NULL),
("3608","0","151.241.202.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2020-03-21 20:28:41","completed","",NULL),
("3609","0","151.241.202.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2020-03-21 20:28:46","completed","",NULL),
("3610","0","151.241.202.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","101","102","","2020-03-21 20:29:07","completed","",NULL),
("3611","0","151.241.202.89","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36","93","94","","2020-03-21 20:29:16","completed","",NULL),
("3612","0","2.179.91.175","Mozilla/5.0 (Linux; Android 7.1.1; SM-A530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","93","94","","2020-03-22 00:07:27","completed","",NULL),
("3613","0","5.115.208.255","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:73.0) Gecko/20100101 Firefox/73.0","97","98","","2020-03-22 01:07:10","completed","",NULL),
("3614","0","5.134.174.241","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 02:15:44","completed","",NULL),
("3615","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-22 11:20:31","completed","",NULL),
("3616","0","193.176.84.29","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-22 11:21:45","completed","",NULL),
("3617","0","87.107.145.53","Mozilla/5.0 (Linux; Android 10; SM-A515F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-22 12:34:33","completed","",NULL),
("3618","0","199.247.3.2","Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.4.3-g","93","94","","2020-03-22 13:23:37","completed","",NULL),
("3619","0","199.247.3.2","Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.4.3-g","93","94","","2020-03-22 13:24:29","completed","",NULL),
("3620","0","199.247.3.2","Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.4.3-g","93","94","","2020-03-22 13:26:35","completed","",NULL),
("3621","0","199.247.3.2","Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.4.3-g","93","94","","2020-03-22 13:27:57","completed","",NULL),
("3622","0","199.247.3.2","Mozilla/5.0 (Linux; U; Android 6.0.1; en-us; Redmi 4 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.4.3-g","93","94","","2020-03-22 13:29:10","completed","",NULL),
("3623","0","93.119.210.11","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-22 15:09:10","completed","",NULL),
("3624","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:12:40","completed","",NULL),
("3625","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:13:22","completed","",NULL),
("3626","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:14:35","completed","",NULL),
("3627","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:15:42","completed","",NULL),
("3628","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:16:44","completed","",NULL),
("3629","0","94.130.127.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 15:17:47","completed","",NULL),
("3630","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:10:34","completed","",NULL),
("3631","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:11:44","completed","",NULL),
("3632","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:12:55","completed","",NULL),
("3633","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:13:57","completed","",NULL),
("3634","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:14:58","completed","",NULL),
("3635","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:16:03","completed","",NULL),
("3636","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-22 18:17:15","completed","",NULL),
("3637","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","68","69","","2020-03-22 18:26:36","completed","",NULL),
("3638","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-22 18:27:54","completed","",NULL),
("3639","0","5.126.226.86","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-22 18:31:11","completed","",NULL),
("3640","0","151.235.61.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-22 20:50:04","completed","",NULL),
("3641","0","151.235.61.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-22 20:50:15","completed","",NULL),
("3642","0","151.235.61.86","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-22 20:50:53","completed","",NULL),
("3643","0","151.235.61.86","Mozilla/5.0 (Linux; Android 9; Redmi Note 8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-22 22:23:13","completed","",NULL),
("3644","0","151.235.61.86","Mozilla/5.0 (Linux; Android 9; Redmi Note 8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-22 22:24:15","completed","",NULL),
("3645","0","5.125.145.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-23 04:34:18","completed","",NULL),
("3646","0","5.125.145.176","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","68","69","","2020-03-23 04:34:25","completed","",NULL),
("3647","0","78.108.180.118","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-23 08:46:34","completed","",NULL),
("3648","0","104.238.189.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-23 11:34:35","completed","",NULL),
("3649","0","104.238.189.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-23 11:35:07","completed","",NULL),
("3650","0","104.238.189.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-23 11:35:31","completed","",NULL),
("3651","0","104.238.189.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-23 11:35:54","completed","",NULL),
("3652","0","104.238.189.63","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-23 11:44:40","completed","",NULL),
("3653","1","2.147.52.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-23 14:25:27","completed","",NULL),
("3654","1","2.147.52.211","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-23 14:25:34","completed","",NULL),
("3655","0","151.235.55.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","70","71","","2020-03-23 14:47:47","completed","",NULL),
("3656","0","5.126.215.96","AppleCoreMedia/1.0.0.15G77 (iPhone; U; CPU OS 11_4_1 like Mac OS X; en_us)","66","67","","2020-03-23 16:04:11","completed","",NULL),
("3657","0","5.126.215.96","AppleCoreMedia/1.0.0.15G77 (iPhone; U; CPU OS 11_4_1 like Mac OS X; en_us)","66","67","","2020-03-23 16:05:20","completed","",NULL),
("3658","0","5.126.215.96","AppleCoreMedia/1.0.0.15G77 (iPhone; U; CPU OS 11_4_1 like Mac OS X; en_us)","66","67","","2020-03-23 16:05:20","completed","",NULL),
("3659","0","104.248.242.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","97","98","","2020-03-23 18:12:09","completed","",NULL),
("3660","0","104.248.242.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-23 18:12:20","completed","",NULL),
("3661","0","77.77.100.108","Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-23 22:44:53","completed","",NULL),
("3662","0","5.124.70.152","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-23 22:50:09","completed","",NULL),
("3663","0","5.121.31.231","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36","66","67","","2020-03-24 07:40:57","completed","",NULL),
("3664","0","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:28:33","completed","",NULL),
("3665","0","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:30:46","completed","",NULL),
("3666","177","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:32:54","completed","",NULL),
("3667","177","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:34:00","completed","",NULL),
("3668","177","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:34:07","completed","",NULL),
("3669","177","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:38:06","completed","",NULL),
("3670","177","5.126.171.1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_1) AppleWebKit/604.3.5 (KHTML, like Gecko) Version/11.0.1 Safari/604.3.5","66","67","","2020-03-24 13:39:11","completed","",NULL),
("3671","144","5.119.244.195","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-24 16:35:56","completed","",NULL),
("3672","0","5.126.17.49","Mozilla/5.0 (Linux; Android 8.1.0; SM-J410F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","97","98","","2020-03-24 17:27:54","completed","",NULL),
("3673","0","5.126.17.49","Mozilla/5.0 (Linux; Android 8.1.0; SM-J410F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.99 Mobile Safari/537.36","97","98","","2020-03-24 17:27:54","completed","",NULL),
("3674","0","2.191.177.54","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","101","102","","2020-03-24 18:36:32","completed","",NULL),
("3675","0","5.216.166.209","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-03-24 20:47:01","completed","",NULL),
("3676","0","5.126.17.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-24 20:52:41","completed","",NULL),
("3677","0","5.125.149.13","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-24 21:42:33","completed","",NULL),
("3678","0","176.88.38.104","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-25 02:49:56","completed","",NULL),
("3679","0","46.224.179.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","97","98","","2020-03-25 19:19:25","completed","",NULL),
("3680","0","46.224.179.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-25 19:20:47","completed","",NULL),
("3681","0","192.15.137.240","Mozilla/5.0 (Linux; Android 6.0.1; HUAWEI ATH-UL01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","66","67","","2020-03-26 01:30:29","completed","",NULL),
("3682","0","192.15.244.76","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-03-26 02:09:01","completed","",NULL),
("3683","0","188.211.208.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-26 13:36:08","completed","",NULL),
("3684","0","5.74.22.220","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-26 13:46:24","completed","",NULL),
("3685","0","5.74.22.220","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-03-26 13:54:33","completed","",NULL),
("3686","0","83.122.142.122","Mozilla/5.0 (Linux; Android 9; Mi A3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.116 Mobile Safari/537.36","66","67","","2020-03-26 15:01:55","completed","",NULL),
("3687","0","5.121.52.245","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-26 20:08:51","completed","",NULL),
("3688","0","5.122.49.167","Mozilla/5.0 (Linux; Android 6.0.1; HUAWEI ATH-UL01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","66","67","","2020-03-27 01:02:10","completed","",NULL),
("3689","0","109.202.101.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-27 11:28:24","completed","",NULL),
("3690","0","5.122.49.167","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-27 11:41:21","completed","",NULL),
("3691","0","109.202.101.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-27 12:02:49","completed","",NULL),
("3692","0","195.206.181.23","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-27 12:46:24","completed","",NULL),
("3693","0","195.206.181.23","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","101","102","","2020-03-27 12:46:36","completed","",NULL),
("3694","0","5.117.85.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-27 12:58:47","completed","",NULL),
("3695","183","83.123.100.94","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-27 18:24:32","completed","",NULL),
("3696","0","5.126.220.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-03-27 19:53:14","completed","",NULL),
("3697","0","92.118.13.42","Mozilla/5.0 (Linux; Android 7.0; SM-J330F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36","124","125","","2020-03-27 21:19:30","completed","",NULL),
("3698","0","31.56.122.29","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-27 21:47:13","completed","",NULL),
("3699","0","5.126.139.103","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-27 21:56:20","completed","",NULL),
("3700","0","5.121.235.199","Mozilla/5.0 (Linux; Android 6.0.1; HUAWEI ATH-UL01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","124","125","","2020-03-28 11:46:38","completed","",NULL),
("3701","0","89.47.77.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-28 19:11:52","completed","",NULL),
("3702","0","2.182.9.168","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","68","69","","2020-03-28 23:27:34","completed","",NULL),
("3703","0","46.101.18.209","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 04:12:22","completed","",NULL),
("3704","0","46.101.18.209","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 04:13:24","completed","",NULL),
("3705","0","46.225.187.74","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 11:33:09","completed","",NULL),
("3706","0","151.247.153.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-29 12:40:37","completed","",NULL),
("3707","0","151.247.153.179","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","99","100","","2020-03-29 12:40:42","completed","",NULL),
("3708","0","81.12.38.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","124","125","","2020-03-29 13:38:13","completed","",NULL),
("3709","0","81.12.38.100","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36","97","98","","2020-03-29 13:39:41","completed","",NULL),
("3710","0","37.156.58.135","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-29 13:57:01","completed","",NULL),
("3711","0","188.211.201.22","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 15:55:11","completed","",NULL),
("3712","0","77.42.10.128","Mozilla/5.0 (Linux; Android 9; Redmi Note 7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-29 16:35:01","completed","",NULL),
("3713","97","5.126.187.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 17:26:17","completed","",NULL),
("3714","0","31.214.154.92","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-29 23:52:41","completed","",NULL),
("3715","0","91.99.212.101","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-30 00:03:35","completed","",NULL),
("3716","0","188.210.145.244","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-03-30 12:34:28","completed","",NULL),
("3717","0","31.56.81.165","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-30 17:29:25","completed","",NULL),
("3718","0","8.20.126.206","Mozilla/5.0 (iPhone; CPU iPhone OS 13_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Mobile/15E148 Safari/604.1","66","67","","2020-03-30 23:04:55","completed","",NULL),
("3719","0","8.20.126.206","Mozilla/5.0 (iPhone; CPU iPhone OS 13_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Mobile/15E148 Safari/604.1","68","69","","2020-03-30 23:05:25","completed","",NULL),
("3720","0","5.126.187.244","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-30 23:28:23","completed","",NULL),
("3721","0","2.147.56.198","Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","66","67","","2020-03-31 02:02:44","completed","",NULL),
("3722","0","2.147.56.198","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 02:05:29","completed","",NULL),
("3723","192","2.147.56.198","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","68","69","","2020-03-31 02:24:28","completed","",NULL),
("3724","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","66","67","","2020-03-31 04:24:11","completed","",NULL),
("3725","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","66","67","","2020-03-31 04:24:13","completed","",NULL),
("3726","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","66","67","","2020-03-31 04:24:23","completed","",NULL),
("3727","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2020-03-31 04:24:25","completed","",NULL),
("3728","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2020-03-31 04:24:26","completed","",NULL),
("3729","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2020-03-31 04:24:26","completed","",NULL),
("3730","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2020-03-31 04:24:27","completed","",NULL),
("3731","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","93","94","","2020-03-31 04:24:27","completed","",NULL),
("3732","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2020-03-31 04:24:58","completed","",NULL),
("3733","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2020-03-31 04:25:05","completed","",NULL),
("3734","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2020-03-31 04:25:13","completed","",NULL),
("3735","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2020-03-31 04:25:13","completed","",NULL),
("3736","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","101","102","","2020-03-31 04:25:13","completed","",NULL),
("3737","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","99","100","","2020-03-31 04:25:18","completed","",NULL),
("3738","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","99","100","","2020-03-31 04:25:20","completed","",NULL),
("3739","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","99","100","","2020-03-31 04:25:20","completed","",NULL),
("3740","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","99","100","","2020-03-31 04:25:21","completed","",NULL),
("3741","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","99","100","","2020-03-31 04:25:22","completed","",NULL),
("3742","0","5.119.209.194","Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko","97","98","","2020-03-31 04:26:22","completed","",NULL),
("3743","0","5.119.209.194","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-31 04:53:32","completed","",NULL),
("3744","0","46.166.142.217","Mozilla/5.0 (iPhone; CPU iPhone OS 13_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/80.0.3987.95 Mobile/15E148 Safari/604.1","66","67","","2020-03-31 11:40:36","completed","",NULL),
("3745","0","2.147.76.242","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-03-31 12:44:21","completed","",NULL),
("3746","0","5.235.97.194","Mozilla/5.0 (Linux; Android 8.0.0; BAC-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","93","94","","2020-03-31 13:19:58","completed","",NULL),
("3747","0","45.123.117.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-31 15:23:54","completed","",NULL),
("3748","0","45.123.117.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","68","69","","2020-03-31 16:14:59","completed","",NULL),
("3749","0","45.123.117.25","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","68","69","","2020-03-31 16:15:07","completed","",NULL),
("3750","0","62.102.137.221","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-03-31 16:18:27","completed","",NULL),
("3751","0","62.102.137.221","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-31 16:19:52","completed","",NULL),
("3752","182","109.202.101.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-31 17:23:24","completed","",NULL),
("3753","182","109.202.101.61","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-03-31 17:50:16","completed","",NULL),
("3754","0","62.102.137.221","Mozilla/5.0 (Linux; Android 4.4.2; HTC Desire 820G PLUS dual sim) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Mobile Safari/537.36","124","125","","2020-03-31 17:59:47","completed","",NULL),
("3755","193","62.102.137.221","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","113","114","","2020-03-31 19:06:41","completed","",NULL),
("3756","0","5.120.246.190","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 19:56:13","completed","",NULL),
("3757","0","185.251.118.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 20:12:30","completed","",NULL),
("3758","0","185.251.118.197","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 20:12:57","completed","",NULL),
("3759","0","45.123.117.14","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 20:40:41","completed","",NULL),
("3760","0","45.123.117.14","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-03-31 20:41:42","completed","",NULL),
("3761","0","185.182.220.28","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","66","67","","2020-04-01 13:54:13","completed","",NULL),
("3762","0","185.182.220.28","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","99","100","","2020-04-01 13:54:40","completed","",NULL),
("3763","0","185.182.220.28","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36","68","69","","2020-04-01 13:54:46","completed","",NULL),
("3764","0","5.202.10.21","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/12.1b10941 Mobile/15E148 Safari/605.1.15","66","67","","2020-04-01 16:18:46","completed","",NULL),
("3765","0","178.131.169.223","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-04-01 23:43:12","completed","",NULL),
("3766","0","5.202.10.21","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/12.1b10941 Mobile/15E148 Safari/605.1.15","93","94","","2020-04-02 20:06:16","completed","",NULL),
("3767","0","5.202.10.21","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/12.1b10941 Mobile/15E148 Safari/605.1.15","93","94","","2020-04-02 20:10:34","completed","",NULL),
("3768","0","5.202.10.21","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/12.1b10941 Mobile/15E148 Safari/605.1.15","93","94","","2020-04-02 20:10:40","completed","",NULL),
("3769","0","5.120.55.40","Mozilla/5.0 (Linux; Android 6.0.1; SM-J700F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36","66","67","","2020-04-03 01:15:24","completed","",NULL),
("3770","0","104.222.32.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-03 11:03:16","completed","",NULL),
("3771","1","2.147.34.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.162 Safari/537.36","113","114","","2020-04-03 11:08:38","completed","",NULL),
("3772","194","2.147.34.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.162 Safari/537.36","99","100","","2020-04-03 11:10:19","completed","",NULL),
("3773","0","2.147.34.126","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.162 Safari/537.36","99","100","","2020-04-03 11:11:08","completed","",NULL),
("3774","0","172.245.132.222","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/33.0","99","100","","2020-04-03 13:32:20","completed","",NULL),
("3775","0","74.208.159.196","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36","64","65","","2020-04-03 13:32:20","completed","",NULL),
("3776","0","204.27.60.124","Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; .NET4.0C; .NET4.0E; .NET CLR 2.0.50727; .NET CLR 3.0.30729; .NET CLR 3.5.30729; rv:11.0) like Gecko","93","94","","2020-04-03 13:32:22","completed","",NULL),
("3777","0","107.174.133.233","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36","97","98","","2020-04-03 13:32:26","completed","",NULL),
("3778","0","172.245.217.79","Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/36.0","70","71","","2020-04-03 13:32:31","completed","",NULL),
("3779","190","91.98.211.40","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-04-03 14:13:11","completed","",NULL),
("3780","0","151.240.71.195","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-04-03 15:49:34","completed","",NULL),
("3781","0","5.74.41.188","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-04-03 17:40:34","completed","",NULL),
("3782","0","5.74.41.188","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-04-03 17:45:36","completed","",NULL),
("3783","0","5.74.41.188","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","93","94","","2020-04-03 17:45:51","completed","",NULL),
("3784","0","5.74.41.188","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","124","125","","2020-04-03 17:46:07","completed","",NULL),
("3785","0","5.74.65.113","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.5 Mobile/15E148 Safari/604.1","66","67","","2020-04-03 18:03:15","completed","",NULL),
("3786","0","104.222.32.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-03 18:51:13","completed","",NULL),
("3787","0","5.119.203.77","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-03 19:16:32","completed","",NULL),
("3788","0","5.119.111.174","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-04-03 20:12:10","completed","",NULL),
("3789","0","2.147.57.252","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-04-03 21:09:42","completed","",NULL),
("3790","0","46.105.245.1","Mozilla/5.0 (iPhone; CPU iPhone OS 13_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Mobile/15E148 Safari/604.1","66","67","","2020-04-04 10:31:48","completed","",NULL),
("3791","0","5.74.57.17","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-04 14:18:20","completed","",NULL),
("3792","0","50.7.62.12","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-04-04 17:18:13","completed","",NULL),
("3793","0","5.121.171.94","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-04-04 18:28:01","completed","",NULL),
("3794","0","89.32.99.57","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-04-04 19:46:22","completed","",NULL),
("3795","0","5.208.147.59","AppleCoreMedia/1.0.0.15E302 (iPhone; U; CPU OS 11_3_1 like Mac OS X; en_gb)","93","94","","2020-04-04 19:47:53","completed","",NULL),
("3796","0","5.237.97.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0 Waterfox/56.3","93","94","","2020-04-04 19:48:11","completed","",NULL),
("3797","0","5.208.147.59","AppleCoreMedia/1.0.0.15E302 (iPhone; U; CPU OS 11_3_1 like Mac OS X; en_gb)","93","94","","2020-04-04 19:49:38","completed","",NULL),
("3798","0","5.78.152.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","97","98","","2020-04-04 21:53:25","completed","",NULL),
("3799","0","5.78.152.69","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","124","125","","2020-04-04 22:01:20","completed","",NULL),
("3800","0","217.23.3.96","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:68.0) Gecko/20100101 Firefox/68.0","99","100","","2020-04-05 08:20:24","completed","",NULL),
("3801","0","46.224.239.220","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-04-05 12:15:51","completed","",NULL),
("3802","0","5.237.68.143","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0 Waterfox/56.3","66","67","","2020-04-05 16:41:44","completed","",NULL),
("3803","0","86.55.24.52","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","97","98","","2020-04-05 23:40:42","completed","",NULL),
("3804","0","86.55.24.52","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-04-05 23:41:03","completed","",NULL),
("3805","0","86.55.24.52","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","97","98","","2020-04-05 23:44:21","completed","",NULL),
("3806","0","192.15.100.45","Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-05 23:56:52","completed","",NULL),
("3807","0","46.245.100.16","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-04-06 00:33:13","completed","",NULL),
("3808","0","86.55.24.52","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-06 01:11:41","completed","",NULL),
("3809","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-04-06 03:28:49","completed","",NULL),
("3810","0","90.225.199.49","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","124","125","","2020-04-06 03:29:34","completed","",NULL),
("3811","0","89.1.210.235","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-06 03:46:27","completed","",NULL),
("3812","1","2.147.86.125","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-06 16:12:30","completed","",NULL),
("3813","0","91.92.204.80","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-04-06 19:07:13","completed","",NULL),
("3814","0","37.255.197.62","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-06 19:21:17","completed","",NULL),
("3815","0","86.57.42.58","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-04-06 20:13:44","completed","",NULL),
("3816","0","77.81.159.137","Mozilla/5.0 (Windows NT 6.1; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-04-06 21:26:58","completed","",NULL),
("3817","0","77.81.159.137","Mozilla/5.0 (Windows NT 6.1; rv:74.0) Gecko/20100101 Firefox/74.0","93","94","","2020-04-06 21:29:11","completed","",NULL),
("3818","0","5.121.245.149","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:74.0) Gecko/20100101 Firefox/74.0","66","67","","2020-04-06 23:10:46","completed","",NULL),
("3819","0","151.245.133.60","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-07 11:15:29","completed","",NULL),
("3820","0","5.125.121.72","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","66","67","","2020-04-07 12:30:10","completed","",NULL),
("3821","0","188.212.242.91","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","93","94","","2020-04-07 20:46:15","completed","",NULL),
("3822","0","5.114.187.130","Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-07 22:03:15","completed","",NULL),
("3823","0","91.99.253.31","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-07 22:42:47","completed","",NULL),
("3824","0","5.124.86.115","Mozilla/5.0 (Linux; Android 4.4.2; Che2-L11) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Mobile Safari/537.36","66","67","","2020-04-08 11:57:25","completed","",NULL),
("3825","0","5.124.86.115","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.93 Safari/537.36","66","67","","2020-04-08 11:59:27","completed","",NULL),
("3826","0","5.126.1.33","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","101","102","","2020-04-08 13:47:30","completed","",NULL),
("3827","0","89.219.236.171","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","97","98","","2020-04-08 16:29:32","completed","",NULL),
("3828","0","5.122.74.198","Mozilla/5.0 (Windows NT 10.0; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-04-08 17:40:09","completed","",NULL),
("3829","0","5.122.74.198","Mozilla/5.0 (Windows NT 10.0; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-04-08 17:40:17","completed","",NULL),
("3830","0","5.122.74.198","Mozilla/5.0 (Windows NT 10.0; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-04-08 18:00:53","completed","",NULL),
("3831","0","91.251.206.212","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","99","100","","2020-04-08 20:29:56","completed","",NULL),
("3832","197","45.123.117.20","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-04-08 23:12:07","completed","",NULL),
("3833","0","5.127.107.42","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-09 17:19:34","completed","",NULL),
("3834","195","2.147.145.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-09 23:09:04","completed","",NULL),
("3835","195","2.147.145.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-09 23:09:37","completed","",NULL),
("3836","0","138.201.177.144","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-09 23:25:02","completed","",NULL),
("3837","0","89.198.246.143","Mozilla/5.0 (Linux; Android 9; TA-1053) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","97","98","","2020-04-09 23:35:08","completed","",NULL),
("3838","0","89.198.246.143","Mozilla/5.0 (Linux; Android 9; TA-1053) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-04-09 23:37:53","completed","",NULL),
("3839","0","5.121.47.55","Mozilla/5.0 (Windows NT 10.0; rv:74.0) Gecko/20100101 Firefox/74.0","124","125","","2020-04-09 23:43:07","completed","",NULL),
("3840","0","89.198.246.143","Mozilla/5.0 (Linux; Android 9; TA-1053) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.99 Mobile Safari/537.36","66","67","","2020-04-09 23:45:37","completed","",NULL),
("3841","1","2.147.101.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-10 11:14:54","completed","",NULL),
("3842","1","2.147.101.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","64","65","","2020-04-10 11:16:42","completed","",NULL),
("3843","0","5.209.242.173","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-10 12:58:14","completed","",NULL),
("3844","0","151.234.196.142","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.92 Safari/537.36","124","125","","2020-04-10 15:07:15","completed","",NULL),
("3845","0","5.119.80.170","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-10 16:17:56","completed","",NULL),
("3846","0","5.216.14.227","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-10 20:13:57","completed","",NULL),
("3847","0","5.120.224.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-10 20:16:52","completed","",NULL),
("3848","0","5.120.224.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","99","100","","2020-04-10 20:17:09","completed","",NULL),
("3849","0","5.120.224.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","99","100","","2020-04-10 20:17:41","completed","",NULL),
("3850","0","5.120.224.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","68","69","","2020-04-10 21:37:53","completed","",NULL),
("3851","0","5.120.224.113","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-10 21:38:10","completed","",NULL),
("3852","0","5.202.22.84","Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/12.1b10941 Mobile/15E148 Safari/605.1.15","93","94","","2020-04-10 22:16:54","completed","",NULL),
("3853","0","185.220.70.51","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-10 22:31:07","completed","",NULL),
("3854","0","185.220.70.51","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","97","98","","2020-04-10 22:31:47","completed","",NULL),
("3855","0","5.211.43.38","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-11 04:18:18","completed","",NULL),
("3856","0","37.98.80.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-11 11:22:52","completed","",NULL),
("3857","0","37.98.80.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","64","65","","2020-04-11 11:23:02","completed","",NULL),
("3858","0","37.98.80.234","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-11 11:23:07","completed","",NULL),
("3859","0","5.120.211.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-11 18:24:25","completed","",NULL),
("3860","0","5.120.211.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-11 18:24:32","completed","",NULL),
("3861","0","5.120.211.140","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-11 18:33:24","completed","",NULL),
("3862","0","2.147.143.156","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-11 19:23:21","completed","",NULL),
("3863","0","86.57.112.147","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-11 19:29:30","completed","",NULL),
("3864","0","77.42.33.168","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:76.0) Gecko/20100101 Firefox/76.0","124","125","","2020-04-11 20:42:00","completed","",NULL),
("3865","0","188.229.76.85","Mozilla/5.0 (Android 6.0.1; Mobile; rv:66.0) Gecko/66.0 Firefox/66.0","93","94","","2020-04-11 22:25:44","completed","",NULL),
("3866","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","93","94","","2020-04-11 22:27:06","completed","",NULL),
("3867","0","5.119.203.206","Mozilla/5.0 (Linux; Android 8.0.0; SM-G935F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Mobile Safari/537.36","66","67","","2020-04-12 00:44:03","completed","",NULL),
("3868","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","93","94","","2020-04-12 01:13:44","completed","",NULL),
("3869","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-12 01:33:08","completed","",NULL),
("3870","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-12 01:33:09","completed","",NULL),
("3871","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-12 01:33:09","completed","",NULL),
("3872","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-12 01:33:14","completed","",NULL),
("3873","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-12 01:33:32","completed","",NULL),
("3874","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-12 01:42:44","completed","",NULL),
("3875","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.92 Safari/537.36","66","67","","2020-04-12 01:56:47","completed","",NULL),
("3876","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.92 Safari/537.36","124","125","","2020-04-12 01:57:00","completed","",NULL),
("3877","0","5.120.161.150","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","97","98","","2020-04-12 01:58:42","completed","",NULL),
("3878","0","88.150.174.4","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-12 04:16:53","completed","",NULL),
("3879","0","192.95.52.178","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.92 Safari/537.36","66","67","","2020-04-12 11:03:57","completed","",NULL),
("3880","0","46.225.91.81","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","124","125","","2020-04-12 11:35:03","completed","",NULL),
("3881","0","188.158.4.21","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-12 17:42:06","completed","",NULL),
("3882","0","151.242.85.216","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.92 Safari/537.36","93","94","","2020-04-12 17:57:07","completed","",NULL),
("3883","0","5.117.15.97","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","66","67","","2020-04-12 18:02:22","completed","",NULL),
("3884","197","45.123.117.14","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36","99","100","","2020-04-12 18:21:52","completed","",NULL),
("3885","0","5.116.1.12","Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-12 21:18:45","completed","",NULL),
("3886","0","5.62.165.194","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","99","100","","2020-04-13 00:04:54","completed","",NULL),
("3887","0","5.62.165.194","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-13 00:10:45","completed","",NULL),
("3888","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-13 00:29:17","completed","",NULL),
("3889","0","5.62.165.194","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36","93","94","","2020-04-13 00:29:47","completed","",NULL),
("3890","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-13 00:30:37","completed","",NULL),
("3891","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","124","125","","2020-04-13 00:30:40","completed","",NULL),
("3892","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","66","67","","2020-04-13 00:30:53","completed","",NULL),
("3893","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0","99","100","","2020-04-13 00:32:11","completed","",NULL),
("3894","0","5.119.30.159","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Geck