<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( $upsells ) :


$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
$wc_loop = $product_type == 'file' ? 'mweb_loop_template_product_file' : 'mweb_loop_template_product_general';

$data_setting = array();

$data_setting['slidesPerView'] = !$breakpoints ? 1 : $breakpoints[1024]['slidesPerView'];
$data_setting['spaceBetween'] = 15;
$data_setting['watchSlidesVisibility'] = true;
$data_setting['loop'] = false;
$data_setting['autoplay'] = false;
$data_setting['touchMoveStopPropagation'] = true;
$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next', 'prevEl' => '.mweb-swiper-prev' );

$data_setting['breakpoints'] = array('575' => array('slidesPerView' => 1), '768' => array('slidesPerView' => 2), '1024' => array('slidesPerView' => 5));

if( $breakpoints )
	$data_setting['breakpoints'] = $breakpoints;


if( $spaceBetween )
	$data_setting['spaceBetween'] = 15;

 ?>

	<section class="up-sells upsells products mweb-block-wrap">

		<h2 class="block-title no_black"><span class="title"><i class="fal fa-lightbulb-on"></i><?php esc_html_e( 'You may also like&hellip;', 'woocommerce' ) ?></span></h2>

		<?php //woocommerce_product_loop_start(); ?>
		
		<div class="swiper xslider sl_upsell" dir="rtl" id="<?= wp_unique_id('sl_') ?>" data-slider="<?= esc_attr(wp_json_encode($data_setting)); ?>">
			<div class="swiper-wrapper">

			<?php foreach ( $upsells as $upsell ) : ?>

				<?php
				 	$post_object = get_post( $upsell->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );
					echo '<div class="swiper-slide">';
							echo $wc_loop();
					echo '</div>';
					?>

			<?php endforeach; ?>
		
			</div>
			<div class="mweb-swiper-next"><i class="fal fa-angle-right"></i></div><div class="mweb-swiper-prev"><i class="fal fa-angle-left"></i></div>
		</div>
		
		<?php //woocommerce_product_loop_end(); ?>

	</section>

<?php endif;

wp_reset_postdata();
