<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
$wc_loop = 'mweb_loop_template_product_general';
if( $product_type == 'file' )
	$wc_loop = 'mweb_loop_template_product_file';

$data_setting = array();

$data_setting['slidesPerView'] = 1;
$data_setting['spaceBetween'] = 15;
$data_setting['watchSlidesVisibility'] = true;
$data_setting['loop'] = false;
$data_setting['autoplay'] = false;
$data_setting['touchMoveStopPropagation'] = true;
$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next', 'prevEl' => '.mweb-swiper-prev' );

$data_setting['breakpoints'] = array('575' => array('slidesPerView' => 1), '768' => array('slidesPerView' => 2), '1024' => array('slidesPerView' => 5));


$arrow_ico = 'fa-angle';	
$attr_class = 'swiper xslider sl_related';

if( isset($slider_data) ){
	$data_setting = $slider_data;
	if( $slider_overflow ){
		$attr_class .= ' swiper-wrap-visible';
		$arrow_ico = 'fa-arrow';	
	}
}


if ( $related_products ) : ?>

	<section class="related products mweb-block-wrap">
		<?php
		$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );
		if ( $heading ) :
			?>
			<div class="block-title no_black"><div class="title"><i class="fal fa-repeat"></i><?php echo esc_html( $heading ); ?></div></div>
		<?php endif; ?>

		<?php //woocommerce_product_loop_start(); ?>
		<div class="<?= $attr_class ?>" dir="rtl" id="<?= wp_unique_id('sl_') ?>" data-slider="<?= esc_attr(wp_json_encode($data_setting)); ?>">
			<div class="swiper-wrapper">
				<?php foreach ( $related_products as $related_product ) : ?>

					<?php
						$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );
						echo '<div class="swiper-slide">';
							echo $wc_loop();
						echo '</div>';

						?>

				<?php endforeach; ?>
			</div>
			<?php 
			if( isset($slider_data) ){ 
				if ( isset($slider_data['pagination']) ) { 
					echo '<div class="mweb-swiper-pagination"></div>';
				} 
				if ( isset($slider_data['navigation']) ){
					echo '<div class="mweb-swiper-next"><i class="fal '.$arrow_ico.'-right"></i></div><div class="mweb-swiper-prev"><i class="fal '.$arrow_ico.'-left"></i></div>';
				}		
			} else { ?>
				<div class="mweb-swiper-next"><i class="fal fa-angle-right"></i></div><div class="mweb-swiper-prev"><i class="fal fa-angle-left"></i></div>
			<?php } ?>
		<?php //woocommerce_product_loop_end(); ?>
		</div>
	</section>

<?php endif; 

wp_reset_postdata();

?>