<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
$product_sidebar = mweb_theme_util::get_theme_option('mweb_product_single_sidebar'); 
$remove_addtocart = mweb_theme_util::get_theme_option('mweb_remove_addtocart'); 

$forced_prerequisites = apply_filters('product_forced_prerequisites' , false);

$is_bought = false;
if( is_user_logged_in() ){
	$is_bought = wc_customer_bought_product( '', get_current_user_id(), $product->get_id() );
}

if( $product->is_type('simple') && ($product->is_downloadable() || $product->is_virtual()) ){
	add_filter( 'woocommerce_product_tabs', 'mweb_review_product_tab' );
}

if($product->is_type('variable')){
	foreach ( $product->get_children() as $child_id ) {
		$variation = wc_get_product( $child_id );
		if( $variation->is_downloadable() || $variation->is_virtual() ){
			add_filter( 'woocommerce_product_tabs', 'mweb_review_product_tab' );
			break;
		}
	}
}

?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '' , $product ); ?>>
	<div class="primary_block row clearfix<?php echo $product_sidebar ? ' single_product_rsidebar' : ''; ?>">

		<div class="col-lg-9 col-md-12 col-12 single_pright">
			<?php
			
				switch($product_type){
					case 'file':
						mweb_woocommerce::mweb_render_product_type_file();
						add_filter( 'mweb_course_tab_title_hook', function($tab_title) { return 'دانلود فایل'; } );
						break;
					case 'audio':
						mweb_woocommerce::mweb_render_product_audios_preview();		
						break;
					default:
						mweb_woocommerce::mweb_render_product_videos_preview();		
				}
				
				//echo $product->get_type();
				if( !$product->is_type('skyroom') )
					mweb_product_info_box();
				
				mweb_product_calender_faq();
			?>
			<?php
				/**
				 * Hook: woocommerce_after_single_product_summary.
				 *
				 * @hooked woocommerce_output_product_data_tabs - 10
				 * @hooked woocommerce_upsell_display - 15
				 * @hooked woocommerce_output_related_products - 20
				 */

				//remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
				//remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

				do_action( 'woocommerce_after_single_product_summary' );
			?>
			
			
		</div>	

		<div class="col-lg-3 col-md-12 col-12 single_pleft">
			<div class="box_wrap entry-summary">
				<?php
					/**
					 * Hook: woocommerce_single_product_summary.
					 *
					 * @hooked woocommerce_template_single_title - 5
					 * @hooked woocommerce_template_single_rating - 10
					 * @hooked woocommerce_template_single_price - 10
					 * @hooked woocommerce_template_single_excerpt - 20
					 * @hooked woocommerce_template_single_add_to_cart - 30
					 * @hooked woocommerce_template_single_meta - 40
					 * @hooked woocommerce_template_single_sharing - 50
					 * @hooked WC_Structured_Data::generate_product_data() - 60
					 */
					 
					remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
					remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
					remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
					remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);

					add_action('woocommerce_single_product_summary', 'mweb_show_bought_product', 21);
					add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 16);
					
					if ( ! $product->managing_stock() && ! $product->is_in_stock() ){
						remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
						add_action('woocommerce_single_product_summary', 'add_out_of_stock_message', 30);	
					} elseif ( $product->managing_stock() ) {
						add_action('woocommerce_single_product_summary', 'mweb_get_stock_for_display', 25);	
					}
					
					if( ($is_bought == true && $remove_addtocart == true && !$product->is_type( 'variable')) || $forced_prerequisites == true ){
						remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
					}
					
					if( $product_type != 'file' ){
						add_action('woocommerce_single_product_summary', 'mweb_get_prerequisites_course', 29);	
					}
					
					do_action( 'woocommerce_single_product_summary' );
					
					
				?>
				
			
			</div>
			<div class="box_wrap wc_emoji_rating"><?php mweb_woocommerce::mweb_get_single_average_rating(); ?></div>
			<div class="box_wrap wc_additional_information">
				<?php
					if( $product_type == 'file' )
						remove_action( 'mweb_additional_information', 'woocommerce_product_additional_information_tab' , 1 );
					do_action('mweb_additional_information'); ?>
			</div>
			<?php mweb_the_rules_and_benefit_fixed(); ?>
			<?php mweb_woocommerce::mweb_get_product_author(); ?>
			<div class="box_wrap wc_product_meta_share">
				<?php echo wc_get_product_category_list( $product->get_id(), ' ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'woocommerce' ) . ' ', '</span>' ); ?>
				<?php echo wc_get_product_tag_list( $product->get_id(), ' ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'woocommerce' ) . ' ', '</span>' ); ?>
				<?php mweb_get_product_share(); ?>
			</div>
		</div>

	</div> 
</div> <!-- /.product -->	

<?php do_action( 'woocommerce_after_single_product' ); ?>

<?php
$sticky_desktop = mweb_theme_util::get_theme_option('mweb_cart_sticky_desktop');
$sticky_mobile = mweb_theme_util::get_theme_option('mweb_cart_sticky_mobile');

if( $is_bought == true && $remove_addtocart == true ){
}else{
	if($sticky_desktop && !wp_is_mobile()){
		echo '<div class="sticky_add_to_cart vr_desktop">';
			woocommerce_template_single_price();
			if( !$forced_prerequisites )
				woocommerce_template_single_add_to_cart();
		echo '</div>';
	}elseif( $sticky_mobile && wp_is_mobile() ){
		echo '<div class="sticky_add_to_cart vr_mobile">';
			woocommerce_template_single_price();
			if( !$forced_prerequisites )
				woocommerce_template_single_add_to_cart();
		echo '</div>';
	}
}
?>

