<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */
 
defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
// Extra post classes
$classes = '';

if ( is_product() ) {
	$classes = '';
}else {
	$classes = ' col-lg-4 col-md-4 col-sm-6 col-12';
}

?>
<li <?php wc_product_class($classes, $product); ?>>
<div class="product_item clear type_2">
	<?php
	/**
	 * Hook: woocommerce_before_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 */
	remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
	do_action( 'woocommerce_before_shop_loop_item' );
	
	?>
	
	<div class="product_image_area">
		<a class="product_image" href="<?php the_permalink(); ?>">
		<?php
			/**
			 * woocommerce_before_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked woocommerce_template_loop_product_thumbnail - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );
		?>
		</a>
		<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
		<?php mweb_woocommerce::mweb_get_product_preview(); ?>
	</div> 
	<div class="product_detail_area">
		<h3 class="product_name"><?= mweb_post_title(); ?></h3>
		<div class="product_item_meta">
			<?php 
				$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
				$meta_rating = mweb_woocommerce::mweb_get_average_rating();
				$meta_sales = mweb_woocommerce::mweb_get_product_sales();
			?>
			<?php if( $meta_rating > 0 ): ?><div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
			<?php endif;
			if( $meta_time ): ?>
				<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
			<?php endif; 
			if( $meta_sales ): ?>
				<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
			<?php endif; ?>		
		</div>
		<div class="product_item_bottom">
			<?php get_template_part( 'woocommerce/loop/price' ); ?>
			<a href="<?php the_permalink(); ?>" class="product_read_more">مشاهده <i class="fal fa-arrow-up-left"></i></a>
		</div>

	</div>
	<?php
		/**
		 * Hook: woocommerce_after_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		 
		if ( class_exists('YITH_WCQV_Frontend') ) {
			remove_action('woocommerce_after_shop_loop_item',  array( YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button'), 15);
		}
		if ( isset($yith_woocompare) ) {
			remove_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'add_compare_link' ), 20 );
		}
					
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
		do_action( 'woocommerce_after_shop_loop_item' );
		?>
</div>
</li>
