<?php
add_action('widgets_init', 'mweb_register_block_realtime_widget');

function mweb_register_block_realtime_widget()
{
    register_widget('mweb_block_realtime_widget');
}

class mweb_block_realtime_widget extends WP_Widget
{

	//register widget
    function __construct()
    {
        $widget_ops = array('classname' => 'block-realtime-widget', 'description' => '');
        parent::__construct('mweb_block_realtime_widget', THEME_NAME .' - پیشنهاد لحظه ای', $widget_ops);
    }


	//render widget
    function widget($args, $instance)
    {
        extract($args);
	    $mweb_options                   = array();
		$mweb_options['post_type']      = 'product';

	    $title                          = ! empty( $instance['title'] ) ? esc_attr( $instance['title'] ) : 'آخرین مطالب';
	    $mweb_options['posts_per_page'] = ! empty( $instance['posts_per_page'] ) ? $instance['posts_per_page'] : 4;
	    $mweb_options['orderby']        = ! empty( $instance['orderby'] ) ? $instance['orderby'] : 'date_post';
	    $mweb_options['category_id']    = ! empty( $instance['category'] ) ? $instance['category'] : '';


		//query data
        $query_data = mweb_theme_query::get_custom_query($mweb_options);

        echo $before_widget;

	    if ( ! empty( $title ) ) {
		    echo $before_title . esc_attr( $title ) . $after_title;
	    }
		
		

	    if ( $query_data->have_posts() ) {

				echo '<div class="owl-carousel owl-realtime">';
				    while ( $query_data->have_posts() ) {
					    $query_data->the_post();
					    echo mweb_loop_template_product_realtime();
				    };
				echo '</div>';

		    }


        

	    //reset post data
	    wp_reset_postdata();
        echo $after_widget;
    }


	//update forms
	function update( $new_instance, $old_instance ) {
		$instance                   = $old_instance;
		$instance['title']          = strip_tags( $new_instance['title'] );
		$instance['category']           = strip_tags( $new_instance['category'] );
		$instance['posts_per_page'] = absint( strip_tags( $new_instance['posts_per_page'] ) );
		$instance['orderby']        = strip_tags( $new_instance['orderby'] );

		return $instance;
	}


	//form settinga
    function form($instance)
    {
	    $defaults = array(
		    'title'          => 'پیشنهاد لحظه ای',
		    'orderby'        => '',
		    'posts_per_page' => 4,
		    'category'           => ''
		    
	    );
	    $instance = wp_parse_args( (array) $instance, $defaults ); ?>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>">عنوان</label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php if(!empty($instance['title'])) echo esc_attr($instance['title']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id('category')); ?>">دسته بندی</label>
		    <?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'show_option_none'  => 'همه دسته ها',
				'option_none_value' => 0,
				'hide_empty' => true,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'taxonomy'	 => 'product_cat',
				'selected'   => $instance['category']

			) );

			?>
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>">تعداد مطلب</label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_per_page' )); ?>" value="<?php if( !empty($instance['posts_per_page']) ) echo esc_attr($instance['posts_per_page']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>">نمایش بر اساس</label>
		    <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>" >
			    <option value="date_post" <?php if( !empty($instance['date_post']) && $instance['date_post'] == 'date_post' ) echo "selected=\"selected\""; else echo ""; ?>>دسته بندی</option>
			    <option value="rand" <?php if( !empty($instance['orderby']) && $instance['orderby'] == 'rand' ) echo "selected=\"selected\""; else echo ""; ?>>تصادفی</option>
			    <option value="best_selling" <?php if( !empty($instance['best_selling']) && $instance['best_selling'] == 'best_selling' ) echo "selected=\"selected\""; else echo ""; ?>>فروش</option>
			    <option value="top_rate" <?php if( !empty($instance['top_rate']) && $instance['top_rate'] == 'top_rate' ) echo "selected=\"selected\""; else echo ""; ?>>امتیاز</option>
			    <option value="recent" <?php if( !empty($instance['recent']) && $instance['recent'] == 'recent' ) echo "selected=\"selected\""; else echo ""; ?>>اخیر</option>
				
				
				
		    </select>
	    </p>
		
	
		
    <?php
    }
}

?>