<?php

$mweb_acc_head_foot = mweb_theme_util::get_theme_option( 'mweb_acc_head_foot');

//header
if( is_page_template('page-my-account.php') && $mweb_acc_head_foot ){
	remove_all_actions( 'mweb_theme_header' );
	if( is_user_logged_in() )
		get_template_part( 'templates/header/head', '2' );
}else{
	
	$mweb_preloader = mweb_theme_util::get_theme_option( 'mweb_preloader');
	if( $mweb_preloader ){
		$preloader_logo = '';
		$preloader_logo = mweb_theme_util::get_theme_option( 'mweb_preloader_logo');
		if( $preloader_logo ){
			$logo = mweb_theme_util::get_theme_option('mweb_logo', 'id');
			if( $logo ){
				$image_attributes = wp_get_attachment_image_src( $logo, 'full' ); 
				$preloader_logo = '<img class="preloader-logo-text" src="'.esc_url($image_attributes[0]).'" width="'.$image_attributes[1].'" height="'.$image_attributes[2].'" alt="'.esc_attr( get_bloginfo( 'name', 'display' ) ).'">';
			}
		}
		
		echo '<div id="mpreloader">
			<div class="preloader-center">
				<div class="preloader-center-absolute">
					<div class="preloader-content">'. $preloader_logo .'
						<div class="preloader-stroke"><i class="fal fa-arrow-pointer preloader-logo-icon"></i></div>
					</div>
				</div>
			</div>  
		</div>';
	}
	
	
	get_template_part( 'templates/header/module', 'nav_mobile' );

	$mweb_offer_text = mweb_theme_util::get_theme_option( 'mweb_offer_text');
	if( !empty($mweb_offer_text) ){
		$mweb_offer_link = mweb_theme_util::get_theme_option( 'mweb_offer_link' );
		echo '<div class="header_alert"><div class="container"><a href="'.$mweb_offer_link.'" target="_blank">'.esc_attr($mweb_offer_text).'</a><i class="fal fa-times close_alert"></i></div></div>';
	}
	
}

