<?php
/**
 * @param $options
 * @return string
 * render module blog archive
 */
if ( ! function_exists( 'mweb_loop_template_blog_archive' ) ) {
	function mweb_loop_template_blog_archive( $options = array() ) {
		$str = '<div class="list_blog_item"><div class="row"><div class="col-md-4 col-sm-12 col-12">';
			if ( has_post_thumbnail() ) {

				$param             		= array();
				$param['size']     		= 'blog_archive';
				$param['has_link'] 		= false;
				//$param['size_mobile_h'] = 'mweb_crop_380x380';
				//$param['size_mobile']   = 'mweb_crop_364x225';

				$str .= mweb_post_thumb( $param );

			} else {
				$str .= mweb_post_no_thumbnail();
			}
		$str .= '</div><div class="col-md-8 col-sm-12 col-12"><h2>'. mweb_post_title() .'</h2><div class="desc">'. mweb_get_post_excerpt(40) .'</div><div class="post_meta"><div class="post_date"><i class="fal fa-clock"></i>تاریخ انتشار	<span>'.get_the_date( 'j  F  Y', get_the_ID() ).'</span></div><a href="'. esc_attr( get_permalink() ) .'" target="_blank" title="ادامه مطلب" class="read_more"></a>';
		$str .= '</div></div></div></div>';
		
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module blog one
 */
if ( ! function_exists( 'mweb_loop_template_blog_1' ) ) {
	function mweb_loop_template_blog_1( $options = array() ) {

		$str = '<div class="blog_post_grid">';
			if ( has_post_thumbnail() ) {

				$param             		= array();
				$param['size']     		= 'blog_archive';
				$param['has_link'] 		= false;
				//$param['size_mobile_h'] = 'mweb_crop_380x380';
				//$param['size_mobile']   = 'mweb_crop_364x225';

				$str .= mweb_post_thumb( $param );

			} else {
				$str .= mweb_post_no_thumbnail();
			}
		$str .= '<h3>' .mweb_post_title() .'</h3>';

		$str .= '<div class="blog_post_foot"><div class="post_format">'. mweb_post_format_icon() .'</div>';
		$str .= '<div class="comment_view"><i class="fal fa-comment-alt-check"></i>'. mweb_get_post_comment_count() .'</div>';
		$str .= '</div></div>';

		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module blog two // expandable slide
 */
if ( ! function_exists( 'mweb_loop_template_blog_2' ) ) {
	function mweb_loop_template_blog_2( $options = array() ) {

		$str = '';

			$featured_img_url = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'full') : ''; 
  
			$str .= '<div class="el_slide" style="--optionBackground:url('. esc_url($featured_img_url) .')">';
			$str .= '<a href="'. esc_attr( get_permalink() ) .'" title="'. get_the_title() .'">';
			$str .= '<div class="label"><div class="icon">'. mweb_post_format_icon() .'</div><div class="info"><div class="main">'. get_the_title() .'</div>'. mweb_get_post_excerpt(10) .'</div></div>';
			$str .= '</a></div>';

		return $str;

	}
}





/**
 * @param $options
 * @return string
 * render module blog three - overlay
 */
if ( ! function_exists( 'mweb_loop_template_blog_3' ) ) {
	function mweb_loop_template_blog_3( $options = array() ) {
		
		$featured_img_url = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'medium') : ''; 
		
		$str = '<div class="blog_featured_post" style="background-image:url('. esc_url($featured_img_url) .')">';
		$str .= '<a href="'. esc_attr( get_permalink() ) .'" title="'. get_the_title() .'" target="_blank"><span class="post_format_i">'. mweb_post_format_icon() .'</span>';
		$str .= '<div class="overlay_info"><h2>'. get_the_title() .'</h2></div></a></div>';

		return $str;
		
	}
}






/**
 * @param $options
 * @return string
 * render module blog one
 */
if ( ! function_exists( 'mweb_loop_template_blog_4' ) ) {
	function mweb_loop_template_blog_4( $options = array() ) {
		
		$item_date = sprintf( esc_html__( '%s قبل', 'mweb' ), human_time_diff(get_the_time ( 'U' ), current_time( 'timestamp' ) ) );
		
		$str = '<div class="blog_post_grid type_2">';
			if ( has_post_thumbnail() ) {

				$param             		= array();
				$param['size']     		= 'blog_archive';
				$param['has_link'] 		= false;
				//$param['size_mobile_h'] = 'mweb_crop_380x380';
				//$param['size_mobile']   = 'mweb_crop_364x225';

				$str .= mweb_post_thumb( $param );

			} else {
				$str .= mweb_post_no_thumbnail();
			}
			$str .= '<h3>' .mweb_post_title() .'</h3>';
			$str .= '<div class="desc">'.mweb_get_post_excerpt(12).'</div>';

			$str .= '<div class="blog_post_foot">';
				$str .= '<span class="date_ago">'.$item_date.'</span>';
				$str .= '<a href="'. esc_attr( get_permalink() ) .'" target="_blank" title="ادامه مطلب" class="read_more">مشاهده</a>';
			$str .= '</div>';
		$str .= '</div>';

		return $str;
		
	}
}






/**
 * @param $options
 * @return string
 * render module blog overlay horizontal
 */
if ( ! function_exists( 'mweb_loop_template_blog_overlay_h' ) ) {
	function mweb_loop_template_blog_overlay_h( $options = array() ) {
		
		$featured_img_url = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'medium') : ''; 
		
		$str = '<div class="item_most" style="background-image:url('. esc_url($featured_img_url) .')">';
		$str .= '<a href="'. esc_attr( get_permalink() ) .'" title="'. get_the_title() .'" target="_blank"><h3>'. get_the_title() .'</h3></a>';
		$str .= '</div>';

		return $str;
		
	}
}




/**
 * @param $options
 * @return string
 * render module blog time line
 */
if ( ! function_exists( 'mweb_loop_template_blog_timeline' ) ) {
	function mweb_loop_template_blog_timeline( $options = array() ) {
		
		$str = '<li><a href="' . get_permalink() . '" rel="bookmark" title="' . esc_attr( strip_tags( get_the_title() ) ) . '">';
		$str .= '<div class="meta"><div class="post-date">'. get_the_time(' j  F  Y  - G:i') .'</div></div><h3>'. get_the_title() .'</h3></a></li>';

		return $str;
		
	}
}




/**
 * @param $options
 * @return string
 * render module blog simple horizontal
 */
if ( ! function_exists( 'mweb_loop_template_blog_simple_h' ) ) {
	function mweb_loop_template_blog_simple_h( $options = array() ) {

		$str = '<div class="post_with_thumb">';
			if ( has_post_thumbnail() ) {

				$param             		= array();
				$param['size']     		= 'thumbnail';
				$param['has_link'] 		= true;
				//$param['size_mobile_h'] = 'mweb_crop_380x380';
				//$param['size_mobile']   = 'mweb_crop_364x225';
				$param['class_name']    = 'post-thumb';

				$str .= mweb_post_thumb( $param );

			} else {
				$str .= mweb_post_no_thumbnail();
			}
			$str .= '<div class="inner">'.get_the_title().'</div>';
		$str .= '</div>';
		
		return $str;
		
	}
}




/**
 * @param $options
 * @return string
 * render module product as file
 */
if ( ! function_exists( 'mweb_loop_template_product_file' ) ) {
	function mweb_loop_template_product_file( $options = array() ) {
		
		$my_flag = empty($options['flag']) ? true : false;
		ob_start();
		?>
		<div class="product_item pfile clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>

			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info">
					<a href="<?php the_permalink(); ?>" class="file_read_more"><i class="fal fa-shopping-bag"></i></a>
					<?php woocommerce_template_loop_price(); ?>
				</div>
			</div>
		</div> 
	
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module product general
 */
if ( ! function_exists( 'mweb_loop_template_product_general' ) ) {
	function mweb_loop_template_product_general( $options = array() ) {
		
		ob_start();
		?>
		<div class="product_item clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
				<?php mweb_woocommerce::mweb_get_product_preview(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info">
					<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<?php woocommerce_template_loop_price(); ?>
				</div>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
						<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
						<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
			</div>
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module product general two
 */
if ( ! function_exists( 'mweb_loop_template_product_general_2' ) ) {
	function mweb_loop_template_product_general_2( $options = array() ) {
		
		ob_start();
		?>
		<div class="product_item clear type_2"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
				<?php mweb_woocommerce::mweb_get_product_preview(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
						<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
						<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
				<div class="product_item_bottom">
					<?php woocommerce_template_loop_price(); ?>
					<a href="<?php the_permalink(); ?>" class="product_read_more">مشاهده <i class="fal fa-arrow-up-left"></i></a>
				</div>
			</div>
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}







/**
 * @param $options
 * @return string
 * render module product general three
 */
if ( ! function_exists( 'mweb_loop_template_product_general_3' ) ) {
	function mweb_loop_template_product_general_3( $options = array() ) {
		
		ob_start();
		?>
		<div class="product_item clear is_horizontal"> 
			<div class="product_image_area col-xl-4 col-lg-5">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
				<?php mweb_woocommerce::mweb_get_product_preview(); ?>
			</div>
			<div class="product_detail_area col">
				<h3 class="product_name"><?= mweb_post_title(); ?></h3>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?><div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
						<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
			</div>
			<div class="product_detail_l col-md-auto">
				<?php woocommerce_template_loop_price(); ?>
				<a href="<?php the_permalink(); ?>" class="product_read_more" data-toggle="tooltip" data-original-title="مشاهده جزئیات"><i class="fal fa-long-arrow-left"></i></a>
				<?php mweb_wishlist::mweb_single_add_wishlist(get_the_ID(), 'product'); ?>
			</div>
		</div>
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}






/**
 * @param $options
 * @return string
 * render module product general
 */
if ( ! function_exists( 'mweb_loop_template_product_horizontal' ) ) {
	function mweb_loop_template_product_horizontal( $options = array() ) {
		
		$my_flag = empty($options['flag']) ? true : false;
		ob_start();
		?>
		<div class="product_horizontal"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<?php woocommerce_template_loop_price(); ?>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
						<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
						<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
			</div>
			<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-angle-left"></i></a>			
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}




/**
 * @param $options
 * @return string
 * render module product onsale
 */
if ( ! function_exists( 'mweb_loop_template_product_onsale_loop' ) ) {
	function mweb_loop_template_product_onsale_loop( $options = array() ) {
		
		$my_flag = empty($options['flag']) ? true : false;
		ob_start();
		?>
		<div class="product_item clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info">
					<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<?php woocommerce_template_loop_price(); ?>
				</div>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
					<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
					<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
			</div>
			<?php mweb_woocommerce::mweb_deal_countdown_timer(); ?>	
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module product onsale two
 */
if ( ! function_exists( 'mweb_loop_template_product_onsale_loop_2' ) ) {
	function mweb_loop_template_product_onsale_loop_2( $options = array() ) {
		
		$my_flag = empty($options['flag']) ? true : false;
		ob_start();
		?>
		<div class="product_item type_2 clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
					<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
					<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
			</div>
			<div class="onsale_bottom">
				<?php woocommerce_template_loop_price(); ?>
				<?php mweb_woocommerce::mweb_deal_countdown_timer(); ?>	
				<svg viewBox="0 0 196 55" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M196 55V0H0.5V1H4.05286C12.4067 1 20.1595 5.34387 24.5214 12.4685L43.5393 43.5315C47.9012 50.6561 55.654 55 64.0078 55H196Z"></path></svg>
			</div>
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module product realtime
 */
if ( ! function_exists( 'mweb_loop_template_product_realtime' ) ) {
	function mweb_loop_template_product_realtime( $options = array() ) {

		ob_start();
		?>
		<div class="product_item clear realtime_product"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>">
				<?php
					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>
				</a>
				<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>

			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info">
					<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<?php woocommerce_template_loop_price(); ?>
				</div>
				<div class="product_item_meta">
					<?php 
						$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
						$meta_rating = mweb_woocommerce::mweb_get_average_rating();
						$meta_sales = mweb_woocommerce::mweb_get_product_sales();
					
					if( $meta_rating > 0 ): ?>
					<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo round( $meta_rating , 1 ); ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
					<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo mweb_hoursandmins($meta_time); ?></span></div>
					<?php endif; 
					if( $meta_sales ): ?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $meta_sales; ?></span></div>
					<?php endif; ?>		
				</div>
				<div class="slide-progress"></div>
			</div>
			
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}




/**
 * @param $options
 * @return string
 * render module teacher
 */
if ( ! function_exists( 'mweb_loop_template_teacher' ) ) {
	function mweb_loop_template_teacher( $options = array() ) {

		ob_start();
		$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full'); 
		
		$facebook	= get_post_meta( get_the_ID(), '_facebook', true );
		$twitter	= get_post_meta( get_the_ID(), '_twitter', true );
		$linkedin	= get_post_meta( get_the_ID(), '_linkedin', true );
		$instagram	= get_post_meta( get_the_ID(), '_instagram', true );
		$telegram	= get_post_meta( get_the_ID(), '_telegram', true );
		$whatsapp	= get_post_meta( get_the_ID(), '_whatsapp', true );
		?>
		 <div class="teacher-box">
		   <div class="teacher-img-box">
				<div class="teacher-img back-img" style="background-image: url('<?= esc_url($featured_img_url) ?>');"></div>
				<div class="teacher-social">
					 <ul class="teacher-social-link">
						<?php if($telegram):?>
							<li><a href="<?php  echo esc_url( $telegram ); ?>" target="_blank"><i class="fab fa-telegram"></i></a></li>
						<?php endif;
						if($whatsapp):?>
							<li><a href="<?php  echo esc_url( $whatsapp ); ?>" target="_blank"><i class="fab fa-whatsapp"></i></a></li>
						<?php endif;
						if($instagram):?>
							<li><a href="<?php  echo esc_url( $instagram ); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
						<?php endif;
						if($linkedin):?>
							<li><a href="<?php  echo esc_url( $linkedin ); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
						<?php endif;
						if($twitter):?>
							<li><a href="<?php  echo esc_url( $twitter ); ?>" target="_blank"><i class="fab fa-twitter"></i></a></li>
						<?php endif;
						if($facebook):?>
							<li><a href="<?php  echo esc_url( $facebook ); ?>" target="_blank"><i class="fab fa-facebook"></i></a></li>
						<?php endif;?>
					</ul>
				</div>
			</div>
			<div class="teacher-text-box"><h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3></div>
		</div> 
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}






/**
 * @param $options
 * @return string
 * render module learn press course
 */
if ( ! function_exists( 'mweb_loop_learn_press_course' ) ) {
	function mweb_loop_learn_press_course( $options = array() ) {
		
		$course = learn_press_get_course(); 
		ob_start();
		?>
		<div class="product_item clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>"><?php echo $course->get_image( 'course_thumbnail' ); ?></a>
				<?php mweb_course_off_percentage_loop(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info"><a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<div class="price lp_price_loop">
						<?php if ( $course->has_sale_price() ) { ?>
							<ins><span class="amount"><?php echo $course->get_price_html(); ?></span></ins>
							<del><span class="amount"><?php echo $course->get_origin_price_html(); ?></span></del>
						<?php }else{ ?>
							<span class="amount_p"><?php echo $course->get_price_html(); ?></span>
						<?php } ?>
					</div>
				</div>
				<div class="product_item_meta">
					<?php 
						$meta_time = mweb_duration_time_calculator(get_the_ID());
						$meta_rating = mweb_get_single_course_average_rating(get_the_ID(),false);
					if( $meta_rating ): ?>
						<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo $meta_rating; ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo $meta_time; ?></span></div>
					<?php endif; ?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo intval($course->count_students());?></span></div>
				</div>
				<div class="meta_teacher"><i class="fal fa-chalkboard-teacher"></i><span>مدرس</span><?php echo ent2ncr($course->get_instructor_html()); ?></div>
			</div>
		</div>
		
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module learn press course - onsale
 */
if ( ! function_exists( 'mweb_loop_learn_press_course_on_sale' ) ) {
	function mweb_loop_learn_press_course_on_sale( $options = array() ) {
		
		$course = learn_press_get_course(); 
		ob_start();
		?>
		<div class="product_item clear"> 
			<div class="product_image_area">
				<a class="product_image" href="<?php the_permalink(); ?>"><?php echo $course->get_image( 'course_thumbnail' ); ?></a>
				<?php mweb_course_off_percentage_loop(); ?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info"><a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<div class="price lp_price_loop">
						<?php if ( $course->has_sale_price() ) { ?>
							<ins><span class="amount"><?php echo $course->get_price_html(); ?></span></ins>
							<del><span class="amount"><?php echo $course->get_origin_price_html(); ?></span></del>
						<?php }else{ ?>
							<span class="amount_p"><?php echo $course->get_price_html(); ?></span>
						<?php } ?>
					</div>
				</div>
				<div class="product_item_meta">
					<?php 
						$meta_time = mweb_duration_time_calculator(get_the_ID());
						$meta_rating = mweb_get_single_course_average_rating(get_the_ID(),false);
					if( $meta_rating ): ?>
						<div class="item_meta el_avarage_rate"><i class="fal fa-star"></i><span><?php echo $meta_rating; ?></span></div>
					<?php endif; 
					if( $meta_time ): ?>
						<div class="item_meta el_product_time"><i class="fal fa-clock"></i><span><?php echo $meta_time; ?></span></div>
					<?php endif; ?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo intval($course->count_students());?></span></div>
				</div>
				<div class="meta_teacher"><i class="fal fa-chalkboard-teacher"></i><span>مدرس</span><?php echo ent2ncr($course->get_instructor_html()); ?></div>
			</div>
			<?php mweb_course_deal_countdown_timer(); ?>	
		</div>
		
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





/**
 * @param $options
 * @return string
 * render module learn dash course
 */
if ( ! function_exists( 'mweb_loop_learn_dash_course' ) ) {
	function mweb_loop_learn_dash_course( $options = array() ) {
		
		global $post; $post_id = $post->ID;
	   $course_id = $post_id;
	   $user_id   = get_current_user_id();
	   $options   = get_option('sfwd_cpt_options');

	   $currency = null;

	   if ( ! is_null( $options ) ) {
		  if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
			 $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];

	   }

	   if( is_null( $currency ) )
		  $currency = 'تومان';

	   $course_options = get_post_meta($post_id, "_sfwd-courses", true);

	   $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : esc_html__( 'Free', 'mweb' );

	   $has_access   = sfwd_lms_has_access( $course_id, $user_id );
	   $is_completed = learndash_course_completed( $user_id, $course_id );

		if( $price == '' )
			$price .= __( 'رایگان', 'mweb' );

		if ( is_numeric( $price ) ) {
			if ( $currency == "USD" )
				$price = '$' . $price;
			else
				$price .= ' <span class="woocommerce-Price-currencySymbol">'.$currency.'</span>';
		}

		$class       = '';
		$ribbon_text = '';

		if ( $has_access && ! $is_completed ) {
			$class = 'ld_course_grid_price ribbon-enrolled';
			$ribbon_text = __( 'ثبت شده', 'mweb' );
		} elseif ( $has_access && $is_completed ) {
			$class = 'ld_course_grid_price';
			$ribbon_text = __( 'اتمام دوره', 'mweb' );
		} else {
			$class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
		}

		$cat_with_link = '';
		$taxonomy  = 'ld_course_category'; 
		$cat_with_link = get_the_term_list( $course_id, $taxonomy, ' ', '<span class="separator">,</span> '); 
	   
		ob_start();
		?>
		<div class="product_item clear"> 
			<div class="product_image_area">
				<?php
					if ( has_post_thumbnail() ) {

						$param             		= array();
						$param['size']     		= 'medium';
						$param['has_link'] 		= false;
						//$param['size_mobile_h'] = 'mweb_crop_380x380';
						//$param['size_mobile']   = 'mweb_crop_364x225';
						//$param['class_name']    = 'post-image';

						echo mweb_post_thumb( $param );

					} else {
						echo mweb_post_no_thumbnail();
					}
				
				?>
			</div>
			<div class="product_detail_area">
				<h3 class="product_name"><?php echo mweb_post_title(); ?></h3>
				<div class="product_item_info">
					<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-left"></i></a>
					<div class="price lp_price_loop"><span class="amount_p"><?= $price ?></span></div>
				</div>
				<div class="product_item_meta">
					<?php 
					$meta_time = get_post_meta( $course_id, '_product_time', true );
					if( $meta_time ):
					?>
					<div class="item_meta el_product_time">
						<i class="fal fa-clock"></i>
						<span><?php echo mweb_hoursandmins( $meta_time ); ?></span>
					</div>
					<?php endif; 
					$student_num = get_post_meta(get_the_ID(), '_student_num', true);
					if(!empty($student_num)):
					?>
					<div class="item_meta el_product_sales"><i class="fal fa-users-class"></i><span><?php echo $student_num; ?> </span></div>
					<?php endif; 
					if( !empty($ribbon_text ) ): ?>
					<div class="item_meta el_avarage_rate el_ribbon_text"><i class="fal fa-user"></i><span><?php echo esc_html($ribbon_text); ?></span></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
		$str = ob_get_clean();
		return $str;
		
	}
}





