<?php 	
	$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full'); 
	
	$facebook        = get_post_meta( get_the_ID(), '_facebook', true );
	$twitter         = get_post_meta( get_the_ID(), '_twitter', true );
	$linkedin        = get_post_meta( get_the_ID(), '_linkedin', true );
	$instagram       = get_post_meta( get_the_ID(), '_instagram', true );
	$telegram        = get_post_meta( get_the_ID(), '_telegram', true );
	$whatsapp        = get_post_meta( get_the_ID(), '_whatsapp', true );
?>
 <div class="teacher-box">
   <div class="teacher-img-box">
		<div class="teacher-img back-img" style="background-image: url('<?= esc_url($featured_img_url) ?>');"></div>
		<div class="teacher-social">
			 <ul class="teacher-social-link">
				<?php if($telegram):?>
					<li><a href="<?php  echo esc_url( $telegram ); ?>" target="_blank"><i class="fab fa-telegram"></i></a></li>
				<?php endif;?>
				<?php if($whatsapp):?>
					<li><a href="<?php  echo esc_url( $whatsapp ); ?>" target="_blank"><i class="fab fa-whatsapp"></i></a></li>
				<?php endif;?>
				<?php if($instagram):?>
					<li><a href="<?php  echo esc_url( $instagram ); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
				<?php endif;?>
				<?php if($linkedin):?>
					<li><a href="<?php  echo esc_url( $linkedin ); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
				<?php endif;?>
				<?php if($twitter):?>
					<li><a href="<?php  echo esc_url( $twitter ); ?>" target="_blank"><i class="fab fa-twitter"></i></a></li>
				<?php endif;?>
				<?php if($facebook):?>
					<li><a href="<?php  echo esc_url( $facebook ); ?>" target="_blank"><i class="fab fa-facebook"></i></a></li>
				<?php endif;?>
			</ul>
		</div>
	</div>
	<div class="teacher-text-box">
		<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	</div>
</div>