<?php $logo = mweb_theme_util::get_theme_option('mweb_logo', 'id'); ?>
<div class="logo" <?php mweb_theme_schema::makeup('logo'); ?>>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>"  title="<?php bloginfo( 'name' ); ?>">
		<?php if ( !empty($logo) ): 
			$image_attributes = wp_get_attachment_image_src( $logo, 'full' ); ?>
			<img src="<?php echo esc_url($image_attributes[0]); ?>"  width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" <?php mweb_theme_schema::makeup('image'); ?>>
		<?php else : ?>
			<img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" <?php mweb_theme_schema::makeup('image'); ?>>
		<?php endif; ?>
	</a>	
	<meta itemprop="name" content="<?php bloginfo( 'name' ) ?>">
</div>
