<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



/**
 * Elementor Woocommerce Breadcrumbs
 * @since 1.0.0
 */
class My_Woo_Breadcrumbs extends Widget_Base {

	
	public function get_name() {
		return 'mweb-breadcrumbs';
	}
	
	public function get_title() {
		return __( 'مسیر جاری', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#f44336',
				'selectors' => [
					'{{WRAPPER}} .woocommerce-breadcrumb' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => __( 'رنگ لینک', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#444444',
				'selectors' => [
					'{{WRAPPER}} .woocommerce-breadcrumb > a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .woocommerce-breadcrumb',
			]
		);
		
		$this->add_control(
			'sep_type',
			[
				'label' => __( 'تبدیل جداکننده به ممیز', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor_breadcrumb_sepslash_',
			]
		);
		
		$this->add_control(
			'sep_color',
			[
				'label' => __( 'رنگ جدا کننده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#888',
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-breadcrumb a:before' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#f44336',
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-breadcrumb i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-breadcrumb' => 'text-align: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'elm_bg',
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .woocommerce-breadcrumb'
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'elm_border',
				'selector' => '{{WRAPPER}} .woocommerce-breadcrumb',
			]
		);

		$this->add_control(
			'elm_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-breadcrumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'elm_box_shadow',
				'selector' => '{{WRAPPER}} .woocommerce-breadcrumb',
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
		woocommerce_breadcrumb();
	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Woocommerce Title
 * @since 1.0.0
 */
class My_Woo_Title extends Widget_Base {

	
	public function get_name() {
		return 'mweb-title';
	}
	
	public function get_title() {
		return __( 'عنوان محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-title';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_type',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'both',
				'options' => [
					'persian' => __( 'عنوان فارسی', 'mweb' ),
					'english' => __( 'عنوان انگلیسی', 'mweb' ),
					'both' => __( 'هر دو', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .product_title',
			]
		);

		$this->add_control(
			'title_en_color',
			[
				'label' => __( 'رنگ عنوان انگلیسی', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sub_head' => 'color: {{VALUE}}',
				],
				'condition' => [ 'title_type' => ['both', 'english'] ]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_en_typography',
				'selector' => '{{WRAPPER}} .sub_head',
				'condition' => [ 'title_type' => ['both', 'english'] ]
			]
		);

		$this->end_controls_section();
		


	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo '<div class="entry-title">';
			if( $settings['title_type'] == 'persian' || $settings['title_type'] == 'both' ){
				echo '<h1 class="product_title">';
					the_title();
				echo '</h1>';
			}
			if( $settings['title_type'] == 'english' || $settings['title_type'] == 'both' ){
				$p_subtitle = get_post_meta( get_the_ID(), '_product_subtitle', true );
				if( !empty($p_subtitle) )
					echo '<span class="sub_head">'.$p_subtitle.'</span>';
			}
		echo '</div>';
		
	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Woocommerce Rating Star
 * @since 1.0.0
 */
class My_Woo_Rating extends Widget_Base {

	
	public function get_name() {
		return 'mweb-rating';
	}
	
	public function get_title() {
		return __( 'امتیاز محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-rating';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'rate_type',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'emoji',
				'options' => [
					'star' => __( 'ستاره', 'mweb' ),
					'emoji' => __( 'شکلک', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'star_color',
			[
				'label' => __( 'رنگ ستاره پر', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .star_active i.is_gold' => 'color: {{VALUE}}',
				],
				'condition' => [ 'rate_type' => ['star'] ],
			]
		);

		$this->add_control(
			'empty_star_color',
			[
				'label' => __( 'رنگ ستاره یا شکلک خالی', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_rating_product i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'hide_text',
			[
				'label' => __( 'مخفی کردن متن', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .single_avg_rating',
				'condition' => [ 'hide_text!' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_avg_rating' => 'color: {{VALUE}}',
				],
				'condition' => [ 'hide_text!' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'num_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه اعداد', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_avg_rating span' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'hide_text!' => ['yes'] ]
			]
		);

		$this->add_control(
			'star_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .single_rating_product i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				],
			]
		);

		
		$this->end_controls_section();
		


	}

	
	protected function render() {
		if ( ! post_type_supports( 'product', 'comments' ) ) {
			return;
		}

		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$hide_text = $settings['hide_text'] == 'yes' ? false : true;

		\mweb_woocommerce::mweb_get_single_average_rating( $settings['rate_type'], $hide_text );
		
	}

	
	protected function content_template() {
		
	}
}





/**
 * Elementor Woocommerce Meta
 * @since 1.0.0
 */
class My_Woo_Meta extends Widget_Base {

	
	public function get_name() {
		return 'mweb-meta';
	}
	
	public function get_title() {
		return __( 'متای محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-meta';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'view',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'inline',
				'options' => [
					'table' => __( 'جدولی', 'mweb' ),
					'stacked' => __( 'سطری', 'mweb' ),
					'inline' => __( 'خطی', 'mweb' ),
				],
				'prefix_class' => 'elementor-woo-meta--view-',
			]
		);

		$this->add_responsive_control(
			'space_between',
			[
				'label' => __( 'فاصله', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}}:not(.elementor-woo-meta--view-inline) .product_meta .detail-container:not(:last-child)' => 'padding-bottom: calc({{SIZE}}{{UNIT}}/2)',
					'{{WRAPPER}}:not(.elementor-woo-meta--view-inline) .product_meta .detail-container:not(:first-child)' => 'margin-top: calc({{SIZE}}{{UNIT}}/2)',
					'{{WRAPPER}}.elementor-woo-meta--view-inline .product_meta .detail-container' => 'margin-right: calc({{SIZE}}{{UNIT}}/2); margin-left: calc({{SIZE}}{{UNIT}}/2)',
					'{{WRAPPER}}.elementor-woo-meta--view-inline .product_meta' => 'margin-right: calc(-{{SIZE}}{{UNIT}}/2); margin-left: calc(-{{SIZE}}{{UNIT}}/2)',
					'body:not.rtl {{WRAPPER}}.elementor-woo-meta--view-inline .detail-container:after' => 'left: calc( (-{{SIZE}}{{UNIT}}/2) - ({{divider_weight.SIZE}}px/2) )',
				],
			]
		);

		$this->add_control(
			'divider',
			[
				'label' => __( 'جداکننده', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_off' => __( 'بلی', 'mweb' ),
				'label_on' => __( 'خیر', 'mweb' ),
				'selectors' => [
					'{{WRAPPER}} .product_meta .detail-container:not(:last-child):after' => 'content: ""',
				],
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'divider_style',
			[
				'label' => __( 'استایل جداکننده', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'solid' => __( 'توپر', 'mweb' ),
					'double' => __( 'دوخطی', 'mweb' ),
					'dotted' => __( 'نقطه', 'mweb' ),
					'dashed' => __( 'خط فاصله', 'mweb' ),
				],
				'default' => 'solid',
				'condition' => [
					'divider' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}}:not(.elementor-woo-meta--view-inline) .product_meta .detail-container:not(:last-child):after' => 'border-top-style: {{VALUE}}',
					'{{WRAPPER}}.elementor-woo-meta--view-inline .product_meta .detail-container:not(:last-child):after' => 'border-left-style: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'divider_weight',
			[
				'label' => __( 'ضخامت جداکننده', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 1,
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
				],
				'condition' => [
					'divider' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}}:not(.elementor-woo-meta--view-inline) .product_meta .detail-container:not(:last-child):after' => 'border-top-width: {{SIZE}}{{UNIT}}; margin-bottom: calc(-{{SIZE}}{{UNIT}}/2)',
					'{{WRAPPER}}.elementor-woo-meta--view-inline .product_meta .detail-container:not(:last-child):after' => 'border-left-width: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'divider_width',
			[
				'label' => __( 'عرض جداکننده', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'default' => [
					'unit' => '%',
				],
				'condition' => [
					'divider' => 'yes',
					'view!' => 'inline',
				],
				'selectors' => [
					'{{WRAPPER}} .product_meta .detail-container:not(:last-child):after' => 'width: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'divider_height',
			[
				'label' => __( 'ارتفاع جداکننده', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'default' => [
					'unit' => '%',
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'condition' => [
					'divider' => 'yes',
					'view' => 'inline',
				],
				'selectors' => [
					'{{WRAPPER}} .product_meta .detail-container:not(:last-child):after' => 'height: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'divider_color',
			[
				'label' => __( 'رنگ جداکننده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ddd',
				'scheme' => [
					'type' => Schemes\Color::get_type(),
					'value' => Schemes\Color::COLOR_3,
				],
				'condition' => [
					'divider' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .product_meta .detail-container:not(:last-child):after' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'heading_text_style',
			[
				'label' => __( 'استایل متن', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}}',
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'heading_link_style',
			[
				'label' => __( 'استایل لینک', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'link_typography',
				'selector' => '{{WRAPPER}} a',
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => __( 'رنگ', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a' => 'color: {{VALUE}}',
					'{{WRAPPER}} span.sku' => 'color: {{VALUE}}',
				],
			]
		);
		
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$sku = $product->get_sku();
		
		$settings = $this->get_settings_for_display();
				
		?>
		<div class="product_meta">

			<?php do_action( 'woocommerce_product_meta_start' ); ?>

			<?php if ( $sku && wc_product_sku_enabled() && ( $sku || $product->is_type( 'variable' ) ) ) : ?>
				<span class="sku_wrapper detail-container"><span class="detail-label">شناسه محصول : </span> <span class="sku"><?php echo $sku; ?></span></span>
			<?php endif; ?>

			<?php if ( count( $product->get_category_ids() ) ) : ?>
				<span class="posted_in detail-container"><span class="detail-label">دسته : </span> <span class="detail-content"><?php echo get_the_term_list( $product->get_id(), 'product_cat', '', ' | ' ); ?></span></span>
			<?php endif; ?>

			<?php if ( count( $product->get_tag_ids() ) && false ) : ?>
				<span class="tagged_as detail-container">برچسب : </span> <span class="detail-content"><?php echo get_the_term_list( $product->get_id(), 'product_tag', '', ' | ' ); ?></span></span>
			<?php endif; ?>

			<?php do_action( 'woocommerce_product_meta_end' ); ?>

		</div>
		<?php

	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Woocommerce Additional Information
 * @since 1.0.0
 */
class My_Woo_Add_Info extends Widget_Base {

	
	public function get_name() {
		return 'mweb-additional';
	}
	
	public function get_title() {
		return __( 'ویژگی محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-checkbox';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_control(
			'extra_show',
			[
				'label' => __( 'نمایش اضافی', 'mweb' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => [
					'mweb_add_product_time' => __( 'مدت دوره', 'mweb' ),
					'mweb_add_publish_date' => __( 'تاریخ انتشار', 'mweb' ),
					'mweb_add_modified_date' => __( 'آخرین بروزرسانی', 'mweb' ),
					'mweb_add_number_of_views' => __( 'تعداد بازدید', 'mweb' ),
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .wc_additional_information',
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_meta>span' => 'color: {{VALUE}}',
					'.woocommerce {{WRAPPER}} table.shop_attributes th' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'value_color',
			[
				'label' => __( 'رنگ مقدار', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_meta>span>i' => 'color: {{VALUE}}',
					'.woocommerce {{WRAPPER}} table.shop_attributes td' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_meta>span:before' => 'color: {{VALUE}}',
					'.woocommerce {{WRAPPER}} table.shop_attributes th i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single_product_meta>span:before' => 'font-size: {{SIZE}}{{UNIT}}',
					'.woocommerce {{WRAPPER}} table.shop_attributes th i' => 'font-size: {{SIZE}}{{UNIT}}'
				],
			]
		);
		
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
				
		$settings = $this->get_settings_for_display();
				
		echo '<div class="wc_additional_information">';
			if( !empty($settings['extra_show']) ){
				echo '<div class="single_product_meta">';
					foreach( $settings['extra_show'] as $item ){
						$item();
					}
				echo '</div>';
			}
			
			$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
		
			if( $product_type != 'file' ){
				woocommerce_product_additional_information_tab();
			}
		echo '</div>';
		
	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Woocommerce Short Description
 * @since 1.0.0
 */
class My_Woo_Short_Description extends Widget_Base {

	
	public function get_name() {
		return 'mweb-short-description';
	}
	
	public function get_title() {
		return __( 'توضیحات کوتاه', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-description';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'تراز متن', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'justify' => [
						'title' => __( 'کشیده', 'mweb' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-product-details__short-description' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-product-details__short-description',
			]
		);
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}

		wc_get_template( 'single-product/short-description.php' );

	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Product Rules and Benefit Fixed()
 * @since 1.0.0
 */
class My_Woo_Product_Rules_and_Benefit extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-rules';
	}
	
	public function get_title() {
		return __( 'قوانین و مزایای استفاده', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-warning';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .product_sellinfo .el_info_icon',
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_sellinfo .el_info_icon' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_sellinfo .el_info_icon i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 15,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product_sellinfo .el_info_icon i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'تایپوگرافی محتوا', 'mweb' ),
				'selector' => '{{WRAPPER}} .product_sellinfo p',
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ محتوا', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_sellinfo p' => 'color: {{VALUE}}',
				],
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'benefit_typography',
				'label' => __( 'تایپوگرافی مزایا', 'mweb' ),
				'selector' => '{{WRAPPER}} .product_sellinfo ul li',
			]
		);
		
		$this->add_control(
			'benefit_color',
			[
				'label' => __( 'رنگ مزایا', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_sellinfo ul li' => 'color: {{VALUE}}',
				],
			]
		);

		
		$this->end_controls_section();
		


	}

	
	protected function render() {

		mweb_the_rules_and_benefit_fixed( '', false );

	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Product Level of Education
 * @since 1.0.0
 */
class My_Woo_Product_Level_Course extends Widget_Base {

	
	public function get_name() {
		return 'mweb-course-level';
	}
	
	public function get_title() {
		return __( 'سطح آموزش', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-rating';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_type',
			[
				'label' => __( 'نمایش عنوان', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => __( 'به صورت متن', 'mweb' ),
					'tooltip' => __( 'به صورت تولتیپ', 'mweb' ),
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .level_of_edu span',
				'condition' => [ 'title_type' => ['default'] ]
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .level_of_edu span' => 'color: {{VALUE}}',
				],
				'condition' => [ 'title_type' => ['default'] ]
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ ستاره', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .level_of_edu' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'active_icon_color',
			[
				'label' => __( 'رنگ ستاره فعال ', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .level_of_edu.leve_is_1 i:first-child' => 'color: {{VALUE}}',
					'{{WRAPPER}} .level_of_edu.leve_is_2 i:first-child' => 'color: {{VALUE}}',
					'{{WRAPPER}} .level_of_edu.leve_is_2 i:nth-child(2)' => 'color: {{VALUE}}',
					'{{WRAPPER}} .level_of_edu.leve_is_3 i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'تراز متن', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .level_of_edu' => 'text-align: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {

		$settings = $this->get_settings_for_display();
		$has_tooltip = $settings['title_type'] == 'tooltip' ? true : false;
		
		mweb_add_level_course( $has_tooltip );

	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Product / Course Teacher
 * @since 1.0.0
 */
class My_Woo_Product_Course_Teacher extends Widget_Base {

	
	public function get_name() {
		return 'mweb-course-teacher';
	}
	
	public function get_title() {
		return __( 'مدرس یا فروشنده', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-site-identity';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_control(
			'img_show',
			[
				'label' => __( 'نمایش تصویر', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		
		$this->add_control(
			'img_size',
			[
				'label' => __( 'حداکثر اندازه تصویر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .author_product_avatar img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'img_show' => ['yes'] ],
			]
		);
		
		$this->add_control(
			'img_border_radius',
			[
				'label' => __( 'گوشه های مدور تصویر', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .author_product_avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'img_show' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'img_margin',
			[
				'label' => esc_html__( 'فاصله خارجی تصویر', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .author_product_avatar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'img_show' => ['yes'] ]
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'img_border',
				'selector' => '{{WRAPPER}} .author_product_avatar img',
				'condition' => [ 'img_show' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'dvr_subtitle',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'subtitle_show',
			[
				'label' => __( 'نمایش سمت', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => __( 'تایپوگرافی سمت', 'mweb' ),
				'selector' => '{{WRAPPER}} .single_product_author > span',
				'condition' => [ 'subtitle_show' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'subtitle_color',
			[
				'label' => __( 'رنگ سمت', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_author > span' => 'color: {{VALUE}}',
				],
				'condition' => [ 'subtitle_show' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'subtitle_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_author > span' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'subtitle_show' => ['yes'] ]
			]
		);
		
		$this->add_control(
			'dvr_title',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .single_product_author h4',
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_product_author h4' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'تایپوگرافی متن', 'mweb' ),
				'selector' => '{{WRAPPER}} .author_product_desc',
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .author_product_desc' => 'color: {{VALUE}}',
				]
			]
		);
		
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'تراز متن', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .single_product_author' => 'text-align: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		$img_show = $settings['img_show'] == 'yes' ? true : false;
		$subtitle_show = $settings['subtitle_show'] == 'yes' ? true : false;
		
		\mweb_woocommerce::mweb_get_product_author( '', $img_show, $subtitle_show );

	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Product Share
 * @since 1.0.0
 */
class My_Woo_Product_Share extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-share';
	}
	
	public function get_title() {
		return __( 'اشتراک گذاری', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-share';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'share_type',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'static',
				'options' => [
					'static' => __( 'ثابت', 'mweb' ),
					'modal' => __( 'دکمه / مودال', 'mweb' ),
				]
			]
		);
		
		$this->start_controls_tabs( 'button_style_tabs', [ 'condition' => [ 'share_type' => ['modal'] ] ] );

		$this->start_controls_tab( 'button_style_normal',
			[
				'label' => __( 'حالت نرمال', 'mweb' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'رنگ متن دکمه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' => __( 'رنگ پس زمینه دکمه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_border_color',
			[
				'label' => __( 'رنگ حاشیه دکمه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'button_style_hover',
			[
				'label' => __( 'حالت هاور', 'mweb' ),
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color_hover',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_border_color_hover',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_transition',
			[
				'label' => __( 'مدت زمان تغییر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.2,
				],
				'range' => [
					'px' => [
						'max' => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .product_share_btn',
				'exclude' => [ 'color' ],
				'condition' => [ 'share_type' => ['modal'] ]
			]
		);


		$this->add_control(
			'btn_font_size',
			[
				'label' => __( 'اندازه فونت آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'share_type' => ['modal'] ]
			]
		);
		
		$this->add_control(
			'btn_padding',
			[
				'label' => esc_html__( 'فاصله داخلی دکمه', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'share_type' => ['modal'] ]
			]
		);
		
		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .product_share_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'share_type' => ['modal'] ]
			]
		);
		
		$this->add_control(
			'social_border_radius',
			[
				'label' => __( 'گوشه های مدور شبکه های اجتماعی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .product_share ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'#modal-share-wrap .product_share ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-end' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'flex-start' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product_share' => 'justify-content: {{VALUE}}',
					'#modal-share-wrap .product_share' => 'justify-content: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		$share_type = $settings['share_type'] == 'modal' ? true : false;
		
		mweb_get_product_share( null, $share_type );

	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Product Total Sales
 * @since 1.0.0
 */
class My_Woo_Product_Total_Sales extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-sales';
	}
	
	public function get_title() {
		return __( 'تعداد فروش یا دانشجو', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-my-account';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .total_sales'
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .total_sales' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'dvr_title',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .total_sales i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .total_sales i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'icon_margin',
			[
				'label' => esc_html__( 'فاصله خارجی آیکن', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .total_sales i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		
		$this->add_control(
			'dvr_value',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'value_typography',
				'label' => __( 'تایپوگرافی تعداد', 'mweb' ),
				'selector' => '{{WRAPPER}} .total_sales span'
			]
		);
		
		$this->add_control(
			'value_color',
			[
				'label' => __( 'رنگ تعداد', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .total_sales span' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'value_margin',
			[
				'label' => esc_html__( 'فاصله خارجی تعداد', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .total_sales span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'تراز متن', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .total_sales' => 'justify-content: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {

		$settings = $this->get_settings_for_display();
		//$has_tooltip = $settings['title_type'] == 'tooltip' ? true : false;
		
		mweb_add_total_sales();

	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Woocommerce CountDown
 * @since 1.0.0
 */
class My_Woo_CountDown extends Widget_Base {

	
	public function get_name() {
		return 'mweb-countdown';
	}
	
	public function get_title() {
		return __( 'شمارشگر فروش ویژه', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-countdown';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات نوشته', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'main_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'پیشنهاد شگفت انگیز', 'mweb' ),
			]
		);
		
		$this->add_control(
			'main_title_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_title .deal_title_main' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'main_title_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .deal_title .deal_title_main',
			]
		);
		
		
		$this->add_control(
			'hr_title',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'sub_title',
			[
				'label' => __( 'زیر عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'فرصت باقی مانده', 'mweb' ),
			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_title .deal_title_sub' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .deal_title .deal_title_sub',
			]
		);
		
		$this->add_responsive_control(
			'sub_title_space',
			[
				'label' => __( 'فاصله زیر عنوان', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .deal_title .deal_title_sub' => 'margin-right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [ 'cd_row_title!' => ['yes'] ],
			]
		);
		
		$this->add_control(
			'hr_box',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'cd_halign_element',
			[
				'label' => __( 'تراز افقی المان ها', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'space-between',
				'options' => [
					'flex-start' => __( 'راست', 'mweb' ),
					'center' => __( 'وسط', 'mweb' ),
					'space-between' => __( 'فاصله دار', 'mweb' ),
				],
				'selectors' => [
					'{{WRAPPER}} .woo_single_countdown' => 'justify-content: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'cd_row_title',
			[
				'label' => __( 'عناوین به صورت سطری', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-product-countdown-row-',
			]
		);
		
		$this->add_control(
			'cd_valign_title',
			[
				'label' => __( 'جایگاه عمودی عناوین', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'baseline',
				'options' => [
					'baseline' => __( 'بالا', 'mweb' ),
					'center' => __( 'وسط', 'mweb' ),
					'flex-end' => __( 'پایین', 'mweb' ),
				],
				'selectors' => [
					'{{WRAPPER}} .woo_single_countdown .deal_title' => 'align-self: {{VALUE}}',
				],
				'prefix_class' => 'elementor-woo-countdown--view-',
			]
		);
		
		$this->add_responsive_control(
			'st_icon_space',
			[
				'label' => __( 'فاصله از شمارنده', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'max' => 500,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .woo_single_countdown .deal_title' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_timer',
			[
				'label' => __( 'تنظیمات شمارنده', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_control(
			'cd_item_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.no' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'cd_item_bg_color',
			[
				'label' => __( 'پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.no' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'cd_item_size',
			[
				'label' => __( 'اندازه شمارشگر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.no' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'cd_item_font_size',
			[
				'label' => __( 'اندازه متن شمارشگر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.no' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'cd_item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.no' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'cd_item_sub_color',
			[
				'label' => __( 'رنگ زیر متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div span.text' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'hr_timer_active',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'cd_item_active_bg_color',
			[
				'label' => __( 'رنگ شمارنده فعال', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .deal_timer_single  .product-date>div.second span.no' => 'background-color: {{VALUE}}',
				],
			]
		);
		
	
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$product_id = $product->get_id();
		$product_type = $product->get_type();
		$sale_price_dates_from = $sale_price_dates_to = '';
		if( $product_type == 'variable' ) {
			$var_sale_price_dates_from = array();
			$var_sale_price_dates_to = array();
			$available_variations = $product->get_available_variations();
			foreach ( $available_variations as $key => $available_variation ) {
				$variation_id = $available_variation['variation_id']; 
				if( $date_from = get_post_meta( $variation_id, '_sale_price_dates_from', true ) ) {
					$var_sale_price_dates_from[] = date( 'Y-m-d 00:00:00', $date_from );
				}
				if( $date_to = get_post_meta( $variation_id, '_sale_price_dates_to', true ) ) {
					$var_sale_price_dates_to[] = date( 'Y-m-d 23:59:59', $date_to);
				}
			}

			if( ! empty( $var_sale_price_dates_from ) )
				$sale_price_dates_from = min( $var_sale_price_dates_from );
			if( ! empty( $var_sale_price_dates_to ) )
				$sale_price_dates_to = max( $var_sale_price_dates_to );
		} else {
			if( $date_from = get_post_meta( $product_id, '_sale_price_dates_from', true ) ) {
				$sale_price_dates_from = date( 'Y-m-d 00:00:00', $date_from );
			}
			if( $date_to = get_post_meta( $product_id, '_sale_price_dates_to', true ) ) {
				$sale_price_dates_to = date( 'Y-m-d 23:59:59', $date_to );
			}
		}
		
		$deal_start_date = $sale_price_dates_from;
		$deal_start_time = strtotime( $deal_start_date );
		
		$deal_end_date = $sale_price_dates_to;
		$deal_end_time = strtotime( $deal_end_date, current_time( 'timestamp' ) );
		
		//$current_date = current_time( 'Y-m-d H:i:s', true );
		$current_time = strtotime( 'NOW', current_time( 'timestamp' ) );
		
		$time_diff = ( $deal_end_time - $current_time );
		
		
		if( $time_diff > 0 && $deal_start_time < $current_time ) {
			?>
			<div class="deal_timer_single woo_single_countdown">  
			  <div class="deal_title">
				<?php if(!empty($settings['main_title'])){ ?><span class="deal_title_main"><?= $settings['main_title'] ?></span><?php } ?>
				<?php if(!empty($settings['sub_title'])){ ?><span class="deal_title_sub"><?= $settings['sub_title'] ?></span><?php } ?>
			  </div>
			  <div class="product-date" data-date="<?php echo $deal_end_date; ?>" data-xxx="<?= $date_to; ?>" data-yyy="<?= $current_time; ?>"></div>
			</div>
			<?php
		}

	}

	
	protected function content_template() {
		?>
		<div class="deal_timer_single woo_single_countdown">  
			<div class="deal_title">
				<span class="deal_title_main">{{{ settings.main_title }}}</span>
				<span class="deal_title_sub">{{{ settings.sub_title }}}</span>
			</div>
			<div class="product-date" data-date="2021-02-12 20:29:59"><div class="day"><span class="no">21</span><span class="text">روز</span></div><div class="hours"><span class="no">03</span><span class="text">ساعت</span></div><div class="min"><span class="no">53</span><span class="text">دقیقه</span></div><div class="second"><span class="no">36</span><span class="text">ثانیه</span></div></div>
		</div>
		<?php
	}
}







/**
 * Elementor Woocommerce Price
 * @since 1.0.0
 */
class My_Woo_Price extends Widget_Base {

	
	public function get_name() {
		return 'mweb-price';
	}
	
	public function get_title() {
		return __( 'قیمت', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-price';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'تـراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'price_color',
			[
				'label' => __( 'رنگ قیمت', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => Schemes\Color::get_type(),
					'value' => Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .price' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '.woocommerce {{WRAPPER}} .price',
			]
		);

		$this->add_control(
			'sale_heading',
			[
				'label' => __( 'حـراج', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sale_price_color',
			[
				'label' => __( 'رنگ', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .price ins' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sale_price_typography',
				'selector' => '.woocommerce {{WRAPPER}} .price ins',
			]
		);

		$this->add_control(
			'price_block',
			[
				'label' => __( 'زیر هم', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-product-price-block-',
			]
		);

		$this->add_responsive_control(
			'sale_price_spacing',
			[
				'label' => __( 'فاصله', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'body.rtl {{WRAPPER}}:not(.elementor-product-price-block-yes) del' => 'margin-left: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .elementor-product-price-block-yes del' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		
		$this->end_controls_section();
		


	}
		
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$variation_single = get_post_meta( $product->get_id(), '_variation_single', true ); 		
		if ( $variation_single == 'yes' ) {
			return;
		}
		
		echo '<p class="price">'.$product->get_price_html().'</p>';

	}

	
	protected function content_template() {
		
	}
	
}





/**
 * Elementor Woocommerce Add to Cart
 * @since 1.0.0
 */
class My_Woo_Add_To_Cart extends Widget_Base {

	
	public function get_name() {
		return 'mweb-add-to-cart';
	}
	
	public function get_title() {
		return __( 'افزودن به سبد', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-add-to-cart';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_atc_button_style',
			[
				'label' => __( 'دکمه افزودن به سبد', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تـراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'prefix_class' => 'elementor-add-to-cart%s--align-',
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .cart button',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .cart button',
				'exclude' => [ 'color' ],
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow',
				'selector' => '{{WRAPPER}} .cart button',
			]
		);
		
		$this->add_responsive_control(
			'btn_icon_space',
			[
				'label' => __( 'فاصله آیکن از چپ', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single_add_to_cart_button:before' => 'margin-left: {{SIZE}}{{UNIT}}',
				]
			]
		);

		$this->add_control(
			'button_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'button_style_tabs' );

		$this->start_controls_tab( 'button_style_normal',
			[
				'label' => __( 'حالت نرمال', 'mweb' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_border_color',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'button_style_hover',
			[
				'label' => __( 'حالت هاور', 'mweb' ),
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color_hover',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_border_color_hover',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cart button:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_transition',
			[
				'label' => __( 'مدت زمان تغییر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.2,
				],
				'range' => [
					'px' => [
						'max' => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cart button' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'variation_price_typography',
				'label' => __( 'تایپوگرافی قیمت متغییر', 'mweb' ),
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-variation-price span',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_atc_quantity_style',
			[
				'label' => __( 'تعداد', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'spacing',
			[
				'label' => __( 'فاسله', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .quantity + .button' => 'margin-left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .quantity + .button' => 'margin-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'quantity_typography',
				'selector' => '{{WRAPPER}} .quantity .qty',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'quantity_border',
				'selector' => '{{WRAPPER}} .quantity .qty',
				'exclude' => [ 'color' ],
			]
		);

		$this->add_control(
			'quantity_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->start_controls_tabs( 'quantity_style_tabs' );

		$this->start_controls_tab( 'quantity_style_normal',
			[
				'label' => __( 'حالت نرمال', 'mweb' ),
			]
		);

		$this->add_control(
			'quantity_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_border_color',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'quantity_btn_color',
			[
				'label' => __( 'رنگ متن دکمه افزایش و کاهش', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .plus-minus .items' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_btn_bg_color',
			[
				'label' => __( 'رنگ پس زمینه دکمه افزایش و کاهش', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .plus-minus .items' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'quantity_style_focus',
			[
				'label' => __( 'حالت انتخاب', 'mweb' ),
			]
		);

		$this->add_control(
			'quantity_text_color_focus',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty:focus' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_bg_color_focus',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty:focus' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_border_color_focus',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty:focus' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'quantity_btn_color_focus',
			[
				'label' => __( 'رنگ متن دکمه افزایش و کاهش', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .plus-minus .items:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .quantity .plus-minus .items:focus' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_btn_bg_color_focus',
			[
				'label' => __( 'رنگ پس زمینه دکمه افزایش و کاهش', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .plus-minus .items:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .quantity .plus-minus .items:focus' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'label_text_color',
			[
				'label' => __( 'رنگ متن برچسب', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity_label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'label_bg_color',
			[
				'label' => __( 'رنگ پس زمینه برچسب', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity_label' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_transition',
			[
				'label' => __( 'مدت زمان تغییر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.2,
				],
				'range' => [
					'px' => [
						'max' => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;

		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$remove_addtocart = \mweb_theme_util::get_theme_option('mweb_remove_addtocart'); 
		$is_bought = false;
		if( is_user_logged_in() ){
			$is_bought = wc_customer_bought_product( '', get_current_user_id(), $product->get_id() );
		}   
		
		if( $is_bought == true && $remove_addtocart == true && !$product->is_type( 'variable') ){
			return;
		}
			
		$forced_prerequisites = apply_filters('product_forced_prerequisites' ,false );
		
		if( $forced_prerequisites == true ){
			return;
		}

			
		?>

		<div class="elementor-add-to-cart elementor-product-<?php echo esc_attr( wc_get_product()->get_type() ); ?>">
			<?php woocommerce_template_single_add_to_cart(); ?>
		</div>

		<?php

	}

	
	protected function content_template() {
		
	}
}








/**
 * Elementor Woocommerce Add To Wishlist
 * @since 1.0.0
 */
class My_Woo_AddTo_Wishlist extends Widget_Base {

	
	public function get_name() {
		return 'mweb-addto-wishlist';
	}
	
	public function get_title() {
		return __( 'افزودن به علاقه مندی', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-favorite';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
			'wishlist_btn_onlyIcon',
			[
				'label' => __( 'تبدیل آیکن به قلب', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-single_wishlist_heart_icon_',
			]
		);

		$this->start_controls_tabs( 'wishlist_btn_style_tabs' );

		$this->start_controls_tab( 'wishlist_btn_style_normal',
			[
				'label' => __( 'حالت نرمال', 'mweb' ),
			]
		);
		
		$this->add_control(
			'wishlist_btn_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .single_add_to_wishlist:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'wishlist_btn_style_focus',
			[
				'label' => __( 'حالت انتخاب', 'mweb' ),
			]
		);
		
		$this->add_control(
			'wishlist_btn_icon_color_hover',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .add_to_wishlist_wrap:hover .single_add_to_wishlist:before' => 'color: {{VALUE}}',
					'.woocommerce {{WRAPPER}} .add_to_wishlist_wrap.added .single_add_to_wishlist:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantity_transition',
			[
				'label' => __( 'مدت زمان تغییر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.2,
				],
				'range' => [
					'px' => [
						'max' => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .single_add_to_wishlist' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}

		\mweb_wishlist::mweb_single_add_wishlist();

	}

	
	protected function content_template() {
		
	}
}





/**
 * Elementor Woocommerce Get Prerequisites Course
 * @since 1.0.0
 */
class My_Woo_Get_Prerequisites_Course extends Widget_Base {

	
	public function get_name() {
		return 'mweb-prerequisites-course';
	}
	
	public function get_title() {
		return __( 'پیش نیاز دوره', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-library-save';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات پیش نیاز دروس', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .prerequisites_course:after',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_course:after' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_course:after' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'items_typography',
				'label' => __( 'تایپوگرافی محتوا', 'mweb' ),
				'selector' => '{{WRAPPER}} .prerequisites_course',
			]
		);
		
		$this->add_control(
			'items_color',
			[
				'label' => __( 'رنگ محتوا', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_course' => 'color: {{VALUE}}',
					'{{WRAPPER}} .prerequisites_item' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'items_link_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه لینک', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_item:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .prerequisites_item:before' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .prerequisites_course',
			]
		);

		$this->add_control(
			'box_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_course' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		
		$this->end_controls_section();

		
		$this->start_controls_section(
			'section_content_warning',
			[
				'label' => __( 'تنظیمات پیام پیش نیاز', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'msg_typography',
				'selector' => '{{WRAPPER}} .prerequisites_forced',
			]
		);
		
		$this->add_control(
			'msg_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'msg_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'msg_border',
				'selector' => '{{WRAPPER}} .prerequisites_forced',
			]
		);

		$this->add_control(
			'msg_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced:before' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced:before' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);
		
		$this->add_responsive_control(
			'msg_icon_space',
			[
				'label' => __( 'فاصله آیکن از چپ', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .prerequisites_forced:before' => 'margin-left: {{SIZE}}{{UNIT}}',
				]
			]
		);
		

	
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
		
		if( $product_type != 'file' ){
			mweb_get_prerequisites_course();
		}

	}

	
	protected function content_template() {
		
		?>
		<div class="prerequisites_course" data-title="پیش نیاز های دوره"><a href="#" class="prerequisites_item" data-title="مشاهده">مثال : آموزش پروژه محور فتوشاپ | Photoshop</a></div>
		<div class="prerequisites_forced">برای خرید این دوره می بایست پیش نیاز ها را گذرانده باشید</div>
		<?php
		
	}
}






/**
 * Elementor Woocommerce Product Customers
 * @since 1.0.0
 */
class My_Woo_Product_Customers extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-customers';
	}
	
	public function get_title() {
		return __( 'آخرین مشتریان محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-site-identity';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'list_title',
			[
				'label' => __( 'متن عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'آخرین خریداران',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'list_title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '{{WRAPPER}} .memberlist_warp h5',
			]
		);

		$this->add_control(
			'list_title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .memberlist_warp h5' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'avatar_size',
			[
				'label' => __( 'اندازه آواتار', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .memberlist li img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .memberlist li.last-member span' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .memberlist li.last-member span' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .memberlist li.last-member span' => 'line-height: {{SIZE}}{{UNIT}};',
				]
			]
		);

		$this->add_control(
			'items_last_bgcolor',
			[
				'label' => __( 'شمارنده رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .memberlist li.last-member span' => 'color: {{VALUE}};',
				],
			]
		);

		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_show',
			[
				'label' => __( 'استایل', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
			
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .memberlist_warp',
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow',
				'selector' => '{{WRAPPER}} .memberlist_warp',
			]
		);
		
		$this->add_control(
			'box_border_radius',
			[
				'label' => __( 'گوشه های مدور باکس', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .memberlist_warp' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'box_background',
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '.woocommerce {{WRAPPER}} .memberlist_warp'
			]
		);
		
		$this->add_control(
			'box_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .memberlist_warp' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'box_margin',
			[
				'label' => __( 'فاصله خارجی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .memberlist_warp' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();


	}
		
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		
		
		(string) $avatar_size = !empty($settings['avatar_size']['size']) ? $settings['avatar_size']['size'] : 35 ;
		
		mweb_get_product_customers( $product->get_id(), $avatar_size, $settings['list_title'] );

	}

	
	protected function content_template() {
		
		?>
		<div class="memberlist_warp">
		<h5>{{{ settings.list_title }}}</h5>
			<ul class="memberlist">
				<li><img alt="" src="https://secure.gravatar.com/avatar/3f009d72559f51e7e454b16e5d0687a1?s=96&amp;d=mm&amp;r=g" srcset="https://secure.gravatar.com/avatar/3f009d72559f51e7e454b16e5d0687a1?s=96&amp;d=mm&amp;r=g 2x" class="avatar avatar-96 photo" height="96" width="96" loading="lazy"></li>
				<li><img alt="" src="https://secure.gravatar.com/avatar/46040c38d1cbe8ffcd3df6c8ba787951?s=96&amp;d=mm&amp;r=g" srcset="https://secure.gravatar.com/avatar/46040c38d1cbe8ffcd3df6c8ba787951?s=96&amp;d=mm&amp;r=g 2x" class="avatar avatar-96 photo" height="96" width="96" loading="lazy"></li>
			</ul>
		</div>
		<?php

	}
	
}







/**
 * Elementor Woocommerce Course Edu Calendar and FAQ
 * @since 1.0.0
 */
class My_Woo_Course_Calender_Faq extends Widget_Base {

	
	public function get_name() {
		return 'mweb-course-calendar-faq';
	}
	
	public function get_title() {
		return __( 'تقویم آموزشی و سوالات متداول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-calendar';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'tab_show',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => [
					'curriculum' => __( 'تقویم آموزشی', 'mweb' ),
					'faq'        => __( 'سوالات متداول', 'mweb' ),
				],
			]
		);
		
		$this->add_control(
			'show_as_acc',
			[
				'label' => __( 'غیرفعال سازی به صورت بازشو', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-product-calendar-faq-acc-',
			]
		);
		
		$this->add_control(
			'titles_size',
			[
				'label' => __( 'اندازه فونت عنوان', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .product_acc_title' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);
		
		$this->add_control(
			'titles_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه عناوین', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_acc_title' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'titles_border_color',
			[
				'label' => __( 'رنگ حاشیه عناوین', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_acc_title' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .product_acc_faq' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'titles_border_radius',
			[
				'label' => __( 'گوشه های مدور عناوین', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .product_acc_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .product_acc_title i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'acc_size',
			[
				'label' => __( 'اندازه فونت محتوا', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .product_acc_content .clr_item h5' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .accordion .accordion-item-title' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .product_acc_faq' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);
		
		$this->add_control(
			'acc_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه محتوا', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .clr_entry' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .product_acc_faq' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'acc_border_radius',
			[
				'label' => __( 'گوشه های مدور محتوا', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .clr_entry' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .product_acc_faq' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		
		$this->end_controls_section();
		


	}
		
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$show_as_acc = $settings['show_as_acc'] != 'yes' ? true : false ;
		
		mweb_product_calender_faq( $settings['tab_show'], $show_as_acc, false );

	}

	
	protected function content_template() {

	}
	
}







/**
 * Elementor Woocommerce Services
 * @since 1.0.0
 */
class My_Woo_Services extends Widget_Base {

	
	public function get_name() {
		return 'mweb-shop-services';
	}
	
	public function get_title() {
		return __( 'خدمات', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'بسته بندی زیبا', 'mweb' ),
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services_item' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .services_item',
			]
		);
		
		$this->add_control(
			'bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services_item' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'selector' => '{{WRAPPER}} .services_item',
			]
		);

		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .services_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'item_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .services_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'hr_icon',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'wc_service_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'از میان عکس یا آیکن یکی را می توانید انتخاب نمائید', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		
		$this->add_control(
			'item_img',
			[
				'label' => __( 'انتخاب آیکن(عکس)', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'description' => ''
			]
		);
		
		$this->add_control(
			'item_img_size',
			[
				'label' => __( 'اندازه عکس برند', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 32,
				],
				'selectors' => [
					'{{WRAPPER}} .services_item img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'wc_style_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'برای درج آیکن مورد دلخواه باید به ادرس زیر مراجعه کرده و کلاس آیکن مورد نظر را مثل نمونه پر کنید <br> https://fontawesome.com/icons?d=gallery&s=light', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		
		$this->add_control(
			'item_icon_name',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'fal fa-gift', 'mweb' ),
				'description' => 'جهت استفاده از fontawesome باید طبق نمونه بالا بکار ببرید'
			]
		);
				
		$this->add_control(
			'item_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services_item i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'item_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .services_item i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'item_icon_space',
			[
				'label' => __( 'فاصله آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .services_item i' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		$settings = $this->get_settings_for_display();
		
			$el_icon = !empty($settings['item_icon_name']) ? '<i class="'.$settings['item_icon_name'].'"></i>' : '';
			if(!empty($settings['item_img']['url']))
				$el_icon = '<img src="'.esc_url($settings['item_img']['url']).'" />';
			
			echo '<div class="services_item">'.$el_icon.$settings['item_title'].'</div>';

	}

	
	protected function content_template() {
		?>
		<div class="services_item"><i class="fal fa-{{{ settings.item_icon_name }}}"></i>{{{ settings.item_title }}}</div>
		<?php
	}
}





/**
 * Elementor Woocommerce Images
 * @since 1.0.0
 */
class My_Woo_Images extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-images';
	}
	
	public function get_title() {
		return __( 'تصویر شاخص محصول / ویدیو / صوت', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-images';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'wc_style_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'این گزینه با توجه به نوع محصول متفاوت است', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
	
		
		
		$this->end_controls_section();

	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
		
		switch($product_type){
			case 'file':
				\mweb_woocommerce::mweb_render_product_type_file();
				add_filter( 'mweb_course_tab_title_hook', function($tab_title) { return 'دانلود فایل'; } );
				break;
			case 'audio':
				\mweb_woocommerce::mweb_render_product_audios_preview();		
				break;
			default:
				\mweb_woocommerce::mweb_render_product_videos_preview();		
			
		}


	}

	
	/* protected function content_template() {
		
	} */
}






/**
 * Elementor Woocommerce Product Tabs
 * @since 1.0.0
 */
class My_Woo_Tabs extends Widget_Base {

	
	public function get_name() {
		return 'mweb-data-tabs';
	}
	
	public function get_title() {
		return __( 'تب های محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-tabs';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات کلی', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'is_scroll',
			[
				'label' => __( 'نمایش تب ها به صورت اسکرول', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_product_tabs_style',
			[
				'label' => __( 'تب ها', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'wc_style_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'استایل تب ها را میتوانید از طریق پنل مدیریت پوسته نیز تغییر دهید - تنها نوع استایل 3 از طریق زیر قابل استایل دهی است', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'tabs_background',
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs'
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tabs_box_shadow',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs'
			]
		);
		
		$this->add_control(
			'tabs_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'tabs_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'tabs_margin',
			[
				'label' => __( 'فاصله خارجی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_style' );

		$this->start_controls_tab( 'normal_tabs_style',
			[
				'label' => __( 'حالت پیشفرض', 'mweb' ),
			]
		);

		$this->add_control(
			'tab_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li a' => 'color: {{VALUE}}',
					'.woocommerce {{WRAPPER}} .wc-tabs > li a:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'alpha' => false,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li a' => 'background-color: {{VALUE}}',
				],
			]
		);

	

		$this->end_controls_tab();

		$this->start_controls_tab( 'active_tabs_style',
			[
				'label' => __( 'حالت فعال', 'mweb' ),
			]
		);

		$this->add_control(
			'active_tab_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li.active a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'active_tab_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'alpha' => false,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li.active a' => 'background-color: {{VALUE}}',
					'.woocommerce.tabs_three {{WRAPPER}} ul.tabs li.active:after' => 'border-top-color: {{VALUE}}',
					'.woocommerce.tabs_three {{WRAPPER}} .wc-tabs li.active a::after' => 'border-top-color: {{VALUE}}',

				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'separator_tabs_style',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li a',
			]
		);

		$this->add_control(
			'tab_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_panel_style',
			[
				'label' => __( 'محتوای تب', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-Tabs-panel--description.entry-content>p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel--description.entry-content',
			]
		);

		$this->add_control(
			'heading_panel_heading_style',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __( 'عناوین', 'mweb' ),
				'separator' => 'before',
			]
		);

		$this->add_control(
			'heading_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-Tabs-panel--description.entry-content h2' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_heading_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel--description.entry-content h2',
			]
		);

		$this->add_control(
			'separator_panel_style',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'panel_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'alpha' => false,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'panel_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					//'.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs' => 'margin-left: {{TOP}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'panel_box_shadow',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $product;

		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();

		setup_postdata( $product->get_id() );
		
		if( $product->is_type('simple') && ($product->is_downloadable() || $product->is_virtual()) ){
			add_filter( 'woocommerce_product_tabs', 'mweb_review_product_tab' );
		}

		if($product->is_type('variable')){
			foreach ( $product->get_children() as $child_id ) {
				$variation = wc_get_product( $child_id );
				if( $variation->is_downloadable() || $variation->is_virtual() ){
					add_filter( 'woocommerce_product_tabs', 'mweb_review_product_tab' );
					break;
				}
			}
		}
		
		
		
		$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
		if( $product_type == 'file' )
			add_filter( 'mweb_course_tab_title_hook', function($tab_title) { return 'دانلود فایل'; } );
		

		if( $settings['is_scroll'] == 'yes' )
			wc_get_template( 'single-product/tabs/tabs.php', array( 'scroll' => true ) );
		else
			wc_get_template( 'single-product/tabs/tabs.php' );
		
		
		



		// On render widget from Editor - trigger the init manually.
		if ( wp_doing_ajax() ) {
			?>
			<script>
				jQuery( '.wc-tabs-wrapper, .woocommerce-tabs, #rating' ).trigger( 'init' );
			</script>
			<?php
		}
	}

	public function render_plain_content() {}

}






/**
 * Elementor Woocommerce Prodcut Content
 * @since 1.0.0
 */
class My_Woo_Prodcut_Content extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-content';
	}
	
	public function get_title() {
		return __( 'محتوای محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-post-excerpt';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
			'content_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .entry-content' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .entry-content p',
			]
		);

		$this->end_controls_section();


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$the_content = apply_filters( 'the_content', get_the_content() );
		if ( !empty($the_content) ) {
			echo '<div class="entry-content">';
				echo $the_content;
			echo '</div>';
		}
	}

	
	protected function content_template() {

	}
}







/**
 * Elementor Woocommerce Product Related
 * @since 1.0.0
 */
class My_Woo_Related extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-related';
	}
	
	public function get_title() {
		return __( 'محصولات مرتبط', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-related';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		
		
		$this->start_controls_section(
			'section_block_title',
			[
				'label' => __( 'تنظیمات عنوان', 'mweb' ),
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .block-title .title',
			]
		);
		
		$this->add_control(
			'title_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 15,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
		
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'تعداد', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
				'min' => 1,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => __( 'بر اساس', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date' => __( 'تاریخ', 'mweb' ),
					'title' => __( 'عنوان', 'mweb' ),
					'price' => __( 'قیمت', 'mweb' ),
					'popularity' => __( 'محبوبیت', 'mweb' ),
					'rating' => __( 'امتیاز', 'mweb' ),
					'rand' => __( 'تصادفی', 'mweb' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __( 'ترتیب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' => __( 'صعودی', 'mweb' ),
					'desc' => __( 'نزولی', 'mweb' ),
				],
			]
		);
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'section_type',
			[
				'label' => __( 'نمـایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$slides_to_show = range( 1, 10 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'اسلاید جهت نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 3,
			]
		);
		
		$this->add_control(
			'slides_spaceBetween',
			[
				'label' => __( 'فاصله از هم', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'default' => 15,
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label' => __( 'جهت بندی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'both',
				'options' => [
					'both' => __( 'فلش و دکمه', 'mweb' ),
					'arrows' => __( 'فلش', 'mweb' ),
					'dots' => __( 'دکمه', 'mweb' ),
					'none' => __( 'هیچ', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'navigation_show',
			[
				'label' => __( 'نمایش دکمه فلش ثابت', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'swiper-slider-arrows-fixed-',
				'condition' => [ 'navigation' => ['both', 'arrows'] ],
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'پخش خودکار', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label' => __( 'توقف در هاور', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'infinite',
			[
				'label' => __( 'حلقه بی نهایت', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		$this->add_control(
			'overflow',
			[
				'label' => __( 'حذف چهارچوب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'centered_slider',
			[
				'label' => __( 'اسلایدر وسط', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'effect',
			[
				'label' => __( 'افکت اسلایدر', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __( 'هیچ', 'mweb' ),
					'coverflow' => __( 'coverflow', 'mweb' ),
					'cards'     => __( 'cards', 'mweb' ),
					'creative'  => __( 'creative', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .product_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .product_item .product_image_area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .product_item',
			]
		);
		

		$this->end_controls_section();
		

	}


	protected function render() {
	
		global $product;

		$product = wc_get_product();

		if ( ! $product ) {
			return;
		}

		$settings = $this->get_settings_for_display();

		$args = [
			'posts_per_page' => 4,
			'columns' => 4,
			'orderby' => $settings['orderby'],
			'order' => $settings['order'],
		];

		if ( ! empty( $settings['posts_per_page'] ) ) {
			$args['posts_per_page'] = $settings['posts_per_page'];
		}

		$args['related_products'] = array_filter( array_map( 'wc_get_product', wc_get_related_products( $product->get_id(), $args['posts_per_page'], $product->get_upsell_ids() ) ), 'wc_products_array_filter_visible' );

		$args['related_products'] = wc_products_array_orderby( $args['related_products'], $args['orderby'], $args['order'] );
		
		$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
		$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
		
		$data_setting = array();
		
		$data_setting['slidesPerView'] = 1;
		$data_setting['spaceBetween'] = $settings['slides_spaceBetween'];
		$data_setting['watchSlidesVisibility'] = true;
		
		if( $settings['centered_slider'] == 'yes'){
			$data_setting['centeredSlides'] = true;
		}
		
		if( $settings['effect'] != 'none' ){
			$data_setting['effect'] = $settings['effect'];
			$data_setting['grabCursor'] = true;
			//$data_setting['slidesPerView'] = 'auto';
			if( $settings['effect'] == 'coverflow' )
				$data_setting['coverflowEffect'] = array('rotate' => 30, 'stretch' => 0, 'depth' => 100, 'modifier' => 1, 'slideShadows' => true);
			
			//if( $settings['effect'] == 'cards' )
				//$data_setting['cardsEffect'] = array('slideShadows' => true);
			
			if( $settings['effect'] == 'creative' )
				$data_setting['creativeEffect'] = array('prev' => array('shadow' => true, 'translate' => [0, 0, -400]), 'next' => array('translate' => ["100%", 0, 0]) );
		}
		
		
		if( $settings['infinite'] == 'yes' ){
			$data_setting['loop'] = true;
		}
		if( $settings['autoplay'] == 'yes' ){
			$data_setting['autoplay'] = true;
		}
		if( $settings['pause_on_hover'] == 'yes' ) {
			$data_setting['touchMoveStopPropagation'] = true;
		}
		
		if( $show_dots ){
			$data_setting['pagination'] = array('el' => '.mweb-swiper-pagination','clickable' => true);
		}
		if( $show_arrows ){
			$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next','prevEl' => '.mweb-swiper-prev' );
		}
		
		
		
		$slide_tablet = empty($settings['slides_to_show_tablet']) ? 2 : $settings['slides_to_show_tablet'];
		$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];  

		$data_setting['breakpoints'] = array('575' => array('slidesPerView' => $slide_mobile), '768' => array('slidesPerView' => $slide_tablet), '1024' => array('slidesPerView' => $settings['slides_to_show']));

		$args['slider_data'] = $data_setting;
		
		$args['slider_overflow'] = $settings['overflow'] == 'yes' ? true : false;


		wc_get_template( 'single-product/related.php', $args );
		

	}

	
	protected function content_template() {
		
	}
}




/**
 * Elementor Woocommerce Product Upsell
 * @since 1.0.0
 */
class My_Woo_Upsell extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-upsell';
	}
	
	public function get_title() {
		return __( 'تشویق برای خرید بیشتر', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-upsell';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
	
		$this->add_control(
			'orderby',
			[
				'label' => __( 'بر اساس', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date' => __( 'تاریخ', 'mweb' ),
					'title' => __( 'عنوان', 'mweb' ),
					'price' => __( 'قیمت', 'mweb' ),
					'popularity' => __( 'محبوبیت', 'mweb' ),
					'rating' => __( 'امتیاز', 'mweb' ),
					'rand' => __( 'تصادفی', 'mweb' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __( 'ترتیب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' => __( 'صعودی', 'mweb' ),
					'desc' => __( 'نزولی', 'mweb' ),
				],
			]
		);
		
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'section_type',
			[
				'label' => __( 'نمـایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$slides_to_show = range( 1, 10 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'اسلاید جهت نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 3,
			]
		);
		
		$this->add_control(
			'slides_spaceBetween',
			[
				'label' => __( 'فاصله از هم', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'default' => 15,
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .product_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .product_item .product_image_area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .product_item',
			]
		);

		$this->end_controls_section();

	}

	
	protected function render() {
	
		$settings = $this->get_settings_for_display();
		
		global $product;

		if ( ! $product ) {
			return;
		}
	
		$limit = '-1';
		$columns = 0;
		$orderby = 'rand';
		$order = 'desc';

		if ( ! empty( $settings['orderby'] ) ) {
			$orderby = $settings['orderby'];
		}

		if ( ! empty( $settings['order'] ) ) {
			$order = $settings['order'];
		}


		// Handle the legacy filter which controlled posts per page etc.
		$args = apply_filters(
			'woocommerce_upsell_display_args',
			array(
				'posts_per_page' => $limit,
				'orderby'        => $orderby,
				'order'          => $order,
				'columns'        => $columns,
			)
		);
		wc_set_loop_prop( 'name', 'up-sells' );
		wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_upsells_columns', isset( $args['columns'] ) ? $args['columns'] : $columns ) );

		$orderby = apply_filters( 'woocommerce_upsells_orderby', isset( $args['orderby'] ) ? $args['orderby'] : $orderby );
		$order   = apply_filters( 'woocommerce_upsells_order', isset( $args['order'] ) ? $args['order'] : $order );
		$limit   = apply_filters( 'woocommerce_upsells_total', isset( $args['posts_per_page'] ) ? $args['posts_per_page'] : $limit );

		// Get visible upsells then sort them at random, then limit result set.
		$upsells = wc_products_array_orderby( array_filter( array_map( 'wc_get_product', $product->get_upsell_ids() ), 'wc_products_array_filter_visible' ), $orderby, $order );
		$upsells = $limit > 0 ? array_slice( $upsells, 0, $limit ) : $upsells;
		
		$args = array(
				'upsells'        => $upsells,

				// Not used now, but used in previous version of up-sells.php.
				'posts_per_page' => $limit,
				'orderby'        => $orderby,
				'columns'        => $columns,
			);
			
		$slide_tablet = empty($settings['slides_to_show_tablet']) ? 2 : $settings['slides_to_show_tablet'];
		$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];  
		$args['breakpoints'] = array('575' => array('slidesPerView' => $slide_mobile), '768' => array('slidesPerView' => $slide_tablet), '1024' => array('slidesPerView' => $settings['slides_to_show']));

		$args['spaceBetween'] = $settings['slides_spaceBetween'];


		wc_get_template( 'single-product/up-sells.php', $args );
				

	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Woocommerce Custom Field
 * @since 1.0.0
 */
class My_Woo_Custom_Field extends Widget_Base {

	
	public function get_name() {
		return 'mweb-custom-field';
	}
	
	public function get_title() {
		return __( 'زمینه دلخواه محصول', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-text-field';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		

		$this->add_control(
			'cf_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary, {{WRAPPER}} .custom_note_summary a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cf_text_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .custom_note_summary',
			]
		);
		
		$this->add_control(
			'cf_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'cf_border',
				'selector' => '{{WRAPPER}} .custom_note_summary',
			]
		);

		$this->add_control(
			'cf_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'cf_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'hr_icon',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'wc_style_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'برای درج آیکن مورد دلخواه باید به ادرس زیر مراجعه کرده و کلاس آیکن مورد نظر را مثل نمونه پر کنید <br> https://fontawesome.com/icons?d=gallery&s=light', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		
		$this->add_control(
			'cf_icon_name',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'bell-on', 'mweb' ),
			]
		);
		
		$this->add_control(
			'cf_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'cf_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'cf_icon_space',
			[
				'label' => __( 'فاصله آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom_note_summary i' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'hr_field',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'cf_field_name',
			[
				'label' => __( 'نام زمینه دلخواه', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '_custom_product_note', 'mweb' ),
			]
		);
		
		$this->add_control(
			'cf_field_checkbox',
			[
				'label' => __( 'فیلد چک باکس', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		
		$this->add_control(
			'cf_field_pattern',
			[
				'label' => __( 'پترن درج زمینه دلخواه', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'محتوای زمینه : [value]', 'mweb' ),
				'description' => __( 'برای درج مقدار زمینه دلخواه از [value] استفاده کنید', 'mweb' ),
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$custom_filed = get_post_meta( get_the_ID(), $settings['cf_field_name'], true );
		if( !empty($custom_filed) ){
			if($settings['cf_field_checkbox'] == 'yes' && $custom_filed != 'yes'){
				return false;
			}
			$el_icon = !empty($settings['cf_icon_name']) ? '<i class="fal fa-'.$settings['cf_icon_name'].'"></i>' : '';
			$el_content = !empty($settings['cf_field_pattern']) ? str_replace('[value]', $custom_filed, $settings['cf_field_pattern']) : $custom_filed;
			if( $settings['cf_field_name'] == '_custom_product_note')
				$el_content = wpautop(htmlspecialchars_decode($el_content));
			echo '<div class="custom_note_summary">'.$el_icon.$el_content.'</div>';
		}

	}

	
	protected function content_template() {
		?>
		<div class="custom_note_summary"><i class="fal fa-{{{ settings.cf_icon_name }}}"></i>{{{ settings.cf_field_pattern }}}</div>
		<?php
	}
}







/**
 * Elementor Woocommerce Stock
 * @since 1.0.0
 */
class My_Woo_Stock extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-stock';
	}
	
	public function get_title() {
		return __( 'موجودی', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-stock';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'stock_title',
			[
				'label' => __( 'عنوان موجودی', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'موجود است', 'mweb' ),
			]
		);
		
		$this->add_control(
			'outofstock_title',
			[
				'label' => __( 'عنوان ناموجود', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'موجود نیست', 'mweb' ),
			]
		);
		

		$this->add_control(
			'st_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_stock' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'st_text_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .product_stock',
			]
		);
		
		$this->add_control(
			'st_icon_checkbox',
			[
				'label' => __( 'نمایش آیکن', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		
		$this->add_control(
			'st_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .product_stock i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'st_icon_checkbox' => ['yes'] ],
			]
		);
		
		$this->add_responsive_control(
			'st_icon_space',
			[
				'label' => __( 'فاصله آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product_stock i' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [ 'st_icon_checkbox' => ['yes'] ],
			]
		);
		
		
		$this->add_control(
			'st_only_out_of_stock',
			[
				'label' => __( 'فقط نمایش هنگام ناموجود بودن', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$icon_one = $icon_two = $icon_three = '';
		
		if( $settings['st_icon_checkbox'] == 'yes' ){
			$icon_two = '<i class="fal fa-times-square"></i>';
			$icon_three = '<i class="fal fa-check-square"></i>';
		}
		
		
		if ( $product->is_type( 'variable' ) ) {

			$temp_stock = false;
			foreach ( $product->get_children() as $child_id ) {
				$variation = wc_get_product( $child_id );
				if($variation->is_in_stock() == true ){
					$temp_stock = true;
					break;
				}
				
			}
			if (  $temp_stock == false ){
				echo '<div class="product_stock no_avl">'.$icon_two.'<span>'.$settings['outofstock_title'].'</span></div>';
			}else {
				if($settings['st_only_out_of_stock'] != 'yes')
				echo '<div class="product_stock">'.$icon_three.'<span>'.$settings['stock_title'].'</span></div>';
			}
		}else{
			if ( $product->is_in_stock() && $settings['st_only_out_of_stock'] != 'yes') {
				echo '<div class="product_stock">'.$icon_three.'<span>'.$settings['stock_title'].'</span></div>';
			}else {
				echo '<div class="product_stock no_avl">'.$icon_two.'<span>'.$settings['outofstock_title'].'</span></div>';
			}
		}
	

	}

	
	protected function content_template() {
		?>
		<div class="product_stock">
		<# if ( 'yes' === settings.st_icon_checkbox ) { #>
			<i class="fal fa-check-square"></i>
		<# } #>
		<span>موجود در انبار</span></div>
		<?php
	}
}





/**
 * Elementor Woocommerce Product Recommend
 * @since 1.0.0
 */
class My_Woo_Recommend extends Widget_Base {

	
	public function get_name() {
		return 'mweb-product-recommend';
	}
	
	public function get_title() {
		return __( 'تعداد پیشنهاد خرید', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-product-info';
	}

	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'pr_text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_recommended' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pr_text_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .el_recommended',
			]
		);
		
		$this->add_control(
			'pr_icon_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_recommended i' => 'color: {{VALUE}}',
				],
			]
		);
	
		$this->add_control(
			'pr_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .el_recommended i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'pr_icon_space',
			[
				'label' => __( 'فاصله آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .el_recommended i' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'pr_field_pattern',
			[
				'label' => __( 'الگوی نوشته', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'پیشنهاد شده توسط بیش از [value] نفر از خریداران', 'mweb' ),
				'description' => __( 'برای درج تعداد پیشنهاد از [value] استفاده کنید', 'mweb' ),
			]
		);
		
		$this->add_control(
			'pr_show_condition',
			[
				'label' => __( 'شرط نمایش اگر بزرگتر n بود', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 1000,
				'step' => 1,
				'default' => 2,
			]
		);
		
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}
		
		$settings = $this->get_settings_for_display();
		
		$recommend_count = \mweb_wc_extra_comment::mweb_get_recommend_status_count();
		
		if($recommend_count > $settings['pr_show_condition'])
			echo '<div class="el_recommended"><i class="fal fa-file-certificate"></i>'.str_replace('[value]', '<span>'.$recommend_count.'</span>', $settings['pr_field_pattern']).'</div>';
	

	}

	
	protected function content_template() {
		?>
		<div class="el_recommended"><i class="fal fa-file-certificate"></i>پیشنهاد شده توسط بیش از <span>{{{ settings.pr_show_condition }}}</span> نفر از خریداران</div>
		<?php
	}
}







/**
 * Elementor Module Archive Product
 * @since 1.0.0
 */
class My_Woo_Archive_Product extends Widget_Base {
	
	public function get_name() {
		return 'block-archive-product';
	}


	public function get_title() {
		return __( 'آرشیو محصولات', 'mweb' );
	}


	public function get_icon() {
		return 'eicon-products';
	}


	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}


	protected function register_controls() {
	
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				//'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'show_title',
			[
				'label' => __( 'نمایش عنوان دسته', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'cat_title_color',
			[
				'label' => __( 'رنگ متن عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .block-title:before' => 'border-bottom: 2px dotted {{VALUE}}'
				],
				'condition' => [ 'show_title' => 'yes' ]
			]
		);
		
		$this->add_control(
			'show_thumbnail',
			[
				'label' => __( 'نمایش تصویر شاخص دسته', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 'show_title' => 'yes' ]
			]
		);
		
		$this->add_control(
			'loop_type',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __( 'یک', 'mweb' ),
					'2' => __( 'دو', 'mweb' ),
					'3' => __( 'سه', 'mweb' ),
					'4' => __( 'چهار', 'mweb' ),
				],
				'default' => '1',
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .item .item-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .item .item-area',
			]
		);
		
		$slides_to_show = array(1, 2, 3, 4, 5);
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'item_in_row',
			[
				'label' => __( 'تعداد آیتم در ردیف', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 4,
			]
		);
		
		$this->add_control(
			'chr_box',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'show_control_bar',
			[
				'label' => __( 'نمایش نوار ابزار فروشگاه', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'description' => 'شامل تعداد محصول ، فیلتر مرتب سازی و ...',
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_wc_result_count',
			[
				'label' => __( 'نمایش تعداد نتایج', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_control_bar' => 'yes' ]
			]
		);
		
		$this->add_control(
			'show_wc_ordering',
			[
				'label' => __( 'نمایش نوع مرتب سازی', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_control_bar' => 'yes' ]
			]
		);
		
		$this->add_control(
			'show_wc_ordering_as_list',
			[
				'label' => __( 'نوع مرتب سازی به صورت لیست', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'لیست', 'mweb' ),
				'label_off' => __( 'انتخابی', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_wc_ordering' => 'yes' ]
			]
		);
		
		$this->add_control(
			'ct_bar_radius',
			[
				'label' => __( 'گوشه های مدور نوار ابزار', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .shop-control-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_control_bar' => 'yes' ]
			]
		);
		
		$this->add_control(
			'ct_bar_color',
			[
				'label' => __( 'رنگ متن نوار ابزار', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .shop-control-bar' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shop-control-bar .woocommerce-result-count' => 'color: {{VALUE}}'
				],
				'condition' => [ 'show_control_bar' => 'yes' ]
			]
		);
		
		$this->add_control(
			'ct_bar_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه نوار ابزار', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .shop-control-bar' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_control_bar' => 'yes' ]
			]
		);
		
		
		
		
		$this->end_controls_section();
		
		
	}
	
	
	public function products_loop() {
		if ( is_product_taxonomy() || is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			if ( woocommerce_product_loop() ) {
				
				if( $this->get_settings('show_control_bar') == 'yes' ){
					echo '<div class="shop-control-bar clear'. ($this->get_settings('show_wc_ordering_as_list') == 'yes' ? ' order_as_list' : '') .'">';
						/**
						 * Hook: woocommerce_before_shop_loop.
						 *
						 * @hooked wc_print_notices - 10
						 * @hooked woocommerce_result_count - 20
						 * @hooked woocommerce_catalog_ordering - 30
						 */
						remove_action( 'woocommerce_before_shop_loop', 'wc_print_notices', 10 );
						
						if( $this->get_settings('show_wc_result_count') != 'yes' )
							remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
							
						if( $this->get_settings('show_wc_ordering') != 'yes' )
							remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
							
						
						do_action( 'woocommerce_before_shop_loop' );
					echo '</div>';
					if ( WC()->session ) {
						wc_print_notices();
					}
				}else{
					remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
					remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
					do_action( 'woocommerce_before_shop_loop' );
				}
						
				if( $this->get_settings('loop_type') == 1 ){
					$loop_name = 'mweb_loop_template_product_general';
				}else if( $this->get_settings('loop_type') == 4 ){
					$loop_name = 'mweb_loop_template_product_file';
				}else{
					$loop_name = 'mweb_loop_template_product_general_'.$this->get_settings('loop_type');
				}
				
				$item_mobile = empty($this->get_settings('item_in_row_mobile')) ? 12 / 1 : 12 / $this->get_settings('item_in_row_mobile');
				$item_tablet = empty($this->get_settings('item_in_row_tablet')) ? 12 / 2 : 12 / $this->get_settings('item_in_row_tablet');
				$item_desktop = $this->get_settings('item_in_row') == 5 ? '5c' : 12 / $this->get_settings('item_in_row');
				
				
				woocommerce_product_loop_start();

				if ( wc_get_loop_prop( 'total' ) ) {
					while ( have_posts() ) {
						the_post();

						do_action( 'woocommerce_shop_loop' );
						
						global $product;

						// Ensure visibility.
						if ( empty( $product ) || ! $product->is_visible() ) {
							return;
						}
						
						$my_class = 'item col-'. $item_mobile .' col-sm-'. $item_tablet.' col-lg-'. $item_desktop;
						echo '<div class=" '. esc_attr( implode( ' ', wc_get_product_class( $my_class, $product ) ) ) .'">';
						echo  $loop_name();
						echo '</div>';

					}
				}

				woocommerce_product_loop_end();

				wp_reset_postdata();
				
				woocommerce_pagination();
				
			} else {
				do_action( 'woocommerce_no_products_found' );
			}
		}
	}
	
	protected function render() {
	
		$settings = $this->get_settings_for_display();
		
		if( $settings['show_title'] == 'yes' ){
			echo '<header class="woocommerce-products-header block-title">';
				echo '<h1 class="woocommerce-products-header__title page-title title">';
					if( $settings['show_thumbnail'] == 'yes' ){
						if ( is_product_category() ){
							global $wp_query;
							$cat = $wp_query->get_queried_object();
							$thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
							$image = wp_get_attachment_url( $thumbnail_id );
							if ( $image ) {
								echo '<img class="archive_thumbnail" src="' . $image . '" alt="' . $cat->name . '" />';
							}
						}
					}else{
						echo '<i class="small fal fa-poll-h"></i>';
					}
				
					woocommerce_page_title();
				echo '</h1>';
			echo '</header>';
		}
		
		$this->products_loop();
		
	}
	
	protected function content_template() {
		
	}
}






/**
 * Elementor Module Archive Product Description
 * @since 1.0.0
 */
class My_Woo_Archive_Description extends Widget_Base {
	
	public function get_name() {
		return 'block-archive-desc';
	}


	public function get_title() {
		return __( 'توضیحات آرشیو', 'mweb' );
	}


	public function get_icon() {
		return 'eicon-single-post';
	}


	public function get_categories() {
		return [ 'digiacademy_woo' ];
	}


	protected function register_controls() {
	
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				//'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'box_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .term-description-wrap"' => 'color: {{VALUE}}'
				]
			]
		);
		
		/* $this->add_control(
			'box_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .term-description-wrap' => 'background-color: {{VALUE}}',
				]
			]
		); */
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'boxdc_typography',
				'selector' => '{{WRAPPER}} .term-description',
			]
		);
		
		$this->add_control(
			'boxdc_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .term-description-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'boxdc_shadow',
				'selector' => '{{WRAPPER}} .term-description-wrap',
			]
		);

		$this->end_controls_section();
		
		
	}
	
	protected function render() {
	
		$settings = $this->get_settings_for_display();
		
		ob_start();
		/**
		 * Hook: woocommerce_archive_description.
		 *
		 * @hooked woocommerce_taxonomy_archive_description - 10
		 * @hooked woocommerce_product_archive_description - 10
		 */
		do_action( 'woocommerce_archive_description' );
		$my_desc = ob_get_clean();

		if( !empty( $my_desc ) ){ 
			echo '<div class="term-description-wrap">';
				echo $my_desc;
				echo '<div class="loadmore">اطلاعات بیشتر ...</div>';
			echo '</div>';
		} 
				
	}
	
	protected function content_template() {
		
	}
}






/**
 * Elementor Module Category
 * @since 1.0.0
 */
class Block_Category_Slider extends Widget_Base {

	
	public function get_name() {
		return 'block-category-slider';
	}

	
	public function get_title() {
		return __( 'اسلایدر دسته بندی ها', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-library-save';
	}

	
	public function get_categories() {
		return [ 'digiacademy', 'digiacademy_woo' ];
	}


	protected function register_controls() {
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'عنوان', 'mweb' ),
			]
		);		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان بلاک', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fa-folders',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		
		$this->add_control(
			'hr_title',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .block-title .title',
			]
		);
		
		$this->add_control(
			'title_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .bk_view_more i' => 'background-color: {{VALUE}}'
				],
			]
		);
		
		$this->add_control(
			'title_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_filter',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);

		$this->add_control(
			'is_archive',
			[
				'label' => __( 'استفاده در آرشیو', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'block_type',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'is_inbox' => __( 'یک', 'mweb' ),
					'is_sepbox' => __( 'دو', 'mweb' ),
				],
				'default' => 'is_inbox',
			]
		);

		$this->add_control(
			'has_parent',
			[
				'label' => __( 'دسته والد', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => get_element_category_list('product_cat'),
			]
		);
		
		$this->add_control(
			'has_include',
			[
				'label' => __( 'انتخاب دسته ها ', 'mweb' ),
				'type' => Controls_Manager::SELECT2,
				'description' => '',
				'multiple' => true,
				'default' => 0,
				'options' => get_element_category_multiple_list('product_cat'),
			]
		);
		
		$this->add_control(
			'top_level',
			[
				'label' => __( 'فقط نمایش زیر شاخه اول', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'hide_empty',
			[
				'label' => __( 'نمایش دسته خالی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		
		$this->add_control(
			'cat_to_show',
			[
				'label' => __( 'تعداد نمایش دسته', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 8,
			]
		);
		
		$this->add_control(
			'show_count',
			[
				'label' => __( 'نمایش تعداد محصولات', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'counter_title',
			[
				'label' => __( 'واحد شمارنده', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'درس',
				'condition' => [ 'show_count' => ['yes'] ],
			]
		);
		
		$this->add_control(
			'only_has_img',
			[
				'label' => __( 'فقط نمایش عکس دار', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				],
				'condition' => [ 'block_type' => 'is_sepbox' ]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_tpo',
				'label' => __( 'تایپوگرافی نام دسته', 'mweb' ),
				'selector' => '{{WRAPPER}} .bk_cat_item strong',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'counter_tpo',
				'label' => __( 'تایپوگرافی تعداد محصولات', 'mweb' ),
				'selector' => '{{WRAPPER}} .bk_cat_item span',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'items_border',
				'selector' => '{{WRAPPER}} .bk_cat_item',
				'exclude' => [ 'color' ],
			]
		);
		
		$this->add_control(
			'items_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->start_controls_tabs( 'items_style_tabs' );

		$this->start_controls_tab( 'items_style_normal',
			[
				'label' => __( 'حالت نرمال', 'mweb' ),
			]
		);

		$this->add_control(
			'items_title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item strong' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'items_counter_color',
			[
				'label' => __( 'رنگ شمارنده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'items_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'items_border_color',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .bk_cat_item',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'items_style_hover',
			[
				'label' => __( 'حالت هاور', 'mweb' ),
			]
		);

		$this->add_control(
			'items_title_color_hover',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item:hover strong' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'items_counter_color_hover',
			[
				'label' => __( 'رنگ شمارنده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item:hover span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'items_bg_color_hover',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'items_border_color_hover',
			[
				'label' => __( 'رنگ حاشیه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'item_border_radius_hover',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'items_transition',
			[
				'label' => __( 'مدت زمان تغییر', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.2,
				],
				'range' => [
					'px' => [
						'max' => 2,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bk_cat_item' => 'transition: all {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$slides_to_show = range( 1, 20 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'اسلاید جهت نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 8,
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label' => __( 'جهت بندی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'both',
				'options' => [
					'both' => __( 'فلش و دکمه', 'mweb' ),
					'arrows' => __( 'فلش', 'mweb' ),
					'dots' => __( 'دکمه', 'mweb' ),
					'none' => __( 'هیچ', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'navigation_show',
			[
				'label' => __( 'نمایش دکمه فلش ثابت', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'swiper-slider-arrows-fixed-',
				'condition' => [ 'navigation' => ['both', 'arrows'] ],
			]
		);
		
		$this->add_control(
			'slides_spaceBetween',
			[
				'label' => __( 'فاصله از هم', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'default' => 15,
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'پخش خودکار', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label' => __( 'توقف در هاور', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'infinite',
			[
				'label' => __( 'حلقه بی نهایت', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		$this->add_control(
			'overflow',
			[
				'label' => __( 'حذف چهارچوب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'centered_slider',
			[
				'label' => __( 'اسلایدر وسط', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'effect',
			[
				'label' => __( 'افکت اسلایدر', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __( 'هیچ', 'mweb' ),
					'coverflow' => __( 'coverflow', 'mweb' ),
					'cards'     => __( 'cards', 'mweb' ),
					'creative'  => __( 'creative', 'mweb' ),
				]
			]
		);

		$this->end_controls_section();


	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();

		if( empty($settings['has_include']) && !isset($settings['has_parent']) ){
			
			echo mweb_error('دسته ای انتخاب نشده است !');
			
		} else {
		
		
			
			$cat_args = array(
				'taxonomy' => 'product_cat',
				'orderby' => 'name',
				'order'   => 'ASC'
			);
			
			if( $settings['hide_empty'] == 'yes'){
				$cat_args['hide_empty'] = false;
			}
			
			if( $settings['is_archive'] == 'no' ){
				if( !empty($settings['has_include']) ){
					$cat_args['include'] = implode(',', $settings['has_include']);
				}
				
				if( !empty($settings['has_parent']) ){
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = (int) $settings['has_parent'];
					}else{
						$cat_args['child_of'] = (int) $settings['has_parent'];
					}
				}else{
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = 0;
					}
				}
			}else{
				$category_ar = get_queried_object();

				if( !empty($category_ar) ){
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = (int) $category_ar->term_id;
					}else{
						$cat_args['child_of'] = (int) $category_ar->term_id;
					}
				}else{
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = 0;
					}
				}
			}
			

		   
			$categories = get_categories( $cat_args );
			
			if( !empty($categories) ){
				
		
				$block_options = array('block_id' => 'bk_'.$this->get_id() ,'block_name' => 'mweb_categories', 'block_options' => array( 'title' => $settings['title'],'icon' => $settings['icon'] ));
		
				
				$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
				$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
				
				$data_setting = array();
				
				$data_setting['slidesPerView'] = $settings['slides_to_show_mobile'];
				$data_setting['spaceBetween'] = $settings['slides_spaceBetween'];
				$data_setting['watchSlidesVisibility'] = true;
				
				if( $settings['centered_slider'] == 'yes'){
					$data_setting['centeredSlides'] = true;
				}
				
				if( $settings['effect'] != 'none' ){
					$data_setting['effect'] = $settings['effect'];
					$data_setting['grabCursor'] = true;
					//$data_setting['slidesPerView'] = 'auto';
					if( $settings['effect'] == 'coverflow' )
						$data_setting['coverflowEffect'] = array('rotate' => 30, 'stretch' => 0, 'depth' => 100, 'modifier' => 1, 'slideShadows' => true);
					
					//if( $settings['effect'] == 'cards' )
						//$data_setting['cardsEffect'] = array('slideShadows' => true);
					
					if( $settings['effect'] == 'creative' )
						$data_setting['creativeEffect'] = array('prev' => array('shadow' => true, 'translate' => [0, 0, -400]), 'next' => array('translate' => ["100%", 0, 0]) );
				}
				
				
				if( $settings['infinite'] == 'yes' ){
					$data_setting['loop'] = true;
				}
				if( $settings['autoplay'] == 'yes' ){
					$data_setting['autoplay'] = true;
				}
				if( $settings['pause_on_hover'] == 'yes' ) {
					$data_setting['touchMoveStopPropagation'] = true;
				}
				
				if( $show_dots ){
					$data_setting['pagination'] = array('el' => '.mweb-swiper-pagination','clickable' => true);
				}
				if( $show_arrows ){
					$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next','prevEl' => '.mweb-swiper-prev' );
				}
				
				
				
				$slide_tablet = empty($settings['slides_to_show_tablet']) ? 4 : $settings['slides_to_show_tablet'];
				$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];  

				$data_setting['breakpoints'] = array('575' => array('slidesPerView' => $slide_mobile), '768' => array('slidesPerView' => $slide_tablet), '1024' => array('slidesPerView' => $settings['slides_to_show']));

				$only_has_img = $settings['only_has_img'] == "yes" ? true : false;
				
				$item_count = count($categories);
				$item_counter = 0;
					
				$arrow_ico = 'fa-angle';	
					
				$attr_class = 'swiper xslider';
				if( $settings['overflow'] == 'yes' ){
					$attr_class .= ' swiper-wrap-visible';
					$arrow_ico = 'fa-arrow';	
				}
				
				$this->add_render_attribute( [
					'carousel-wrapper' => [
						'class' => $attr_class,
						'id' => 'sl_'.$this->get_id(),
						'dir' => 'rtl',
						'data-slider' => wp_json_encode($data_setting)
					],
				] );
							
				

				echo \mweb_theme_block::block_open( $block_options );
				echo \mweb_theme_block::block_header( $block_options );
				echo \mweb_theme_block::block_content_open();
				
					echo '<div '. $this->get_render_attribute_string( 'carousel-wrapper' ) .'>';
					echo '<div class="swiper-wrapper">';
					
					foreach( $categories as $category ) :
					
						$term_link = get_term_link( $category , 'product_cat' );
						$classes = 'bk_cat_item';
						$item_img = '';
						$image_id = get_term_meta ( $category->term_id, 'thumbnail_id', true );
						if(empty($image_id)){
							if(!empty($only_has_img))
								continue;
							
						}else{
							$item_img = wp_get_attachment_image( $image_id, 'thumbnail' );;
							$classes .= ' has_img';	
						}
						
						if ( $term_link ) {
							echo '<div class="swiper-slide"><a class="'.$classes.'" href="'.$term_link.'">'.$item_img.'<strong>'.$category->name.'</strong>';
							if( $settings['show_count'] == 'yes' ) echo '<span class="cat_count">+'.$category->count.' '.$settings['counter_title'].'</span>';
							echo '</a></div>';
						}
						$item_counter++;
						if( $item_counter > $settings['cat_to_show'] )
							break;
						
					endforeach;

					echo '</div>';	
						if ( $show_dots ) { 
							echo '<div class="mweb-swiper-pagination"></div>';
						} 
						if ( $show_arrows ){
							echo '<div class="mweb-swiper-next"><i class="fal '.$arrow_ico.'-right"></i></div><div class="mweb-swiper-prev"><i class="fal '.$arrow_ico.'-left"></i></div>';
						}			
					echo '</div>';		
					
				echo \mweb_theme_block::block_content_close();
				echo \mweb_theme_block::block_footer( $block_options );
				echo \mweb_theme_block::block_close();
				
	
			}
		
		}

	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Module Video
 * @since 1.0.0
 */
class Block_Video extends Widget_Base {

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script('plyr', 'https://cdn.jsdelivr.net/npm/video.js@7.8.4/dist/video.js', array(), '7.8.4');
		//wp_enqueue_script('plyr-hls', 'https://cdnjs.cloudflare.com/ajax/libs/videojs-contrib-hls/5.15.0/videojs-contrib-hls.js', array(), '7.8.4');
		wp_register_script('plyr-hls', THEME_ASSET . '/js/videojs-contrib-quality-levels.min.js', array(), '7.8.4');
		wp_register_script('plyr-hls-q', THEME_ASSET . '/js/videojs-hls-quality-selector.min.js', array(), '7.8.4');
		
		wp_register_style( 'plyr-css', 'https://cdn.jsdelivr.net/npm/video.js@7.8.4/dist/video-js.css' , false ,'7.8.4' );


	}

	public function get_script_depends() {
		return [ 'plyr', 'plyr-hls', 'plyr-hls-q' ];
	}
	
	 public function get_style_depends() {
       return [ 'plyr-css' ];
   }
   
	public function get_name() {
		return 'block-single-video';
	}

	
	public function get_title() {
		return __( 'ویدئو', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-video-playlist';
	}

	
	public function get_categories() {
		return [ 'digiacademy', 'digiacademy_woo' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'el_media',
			[
				'label' => __( 'لینک رسانه', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com/video.mp4', 'mweb' ),
				'options' => [ 'url' ],
			]
		);
		
		$this->add_control(
			'el_poster',
			[
				'label' => __( 'پوستر', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->end_controls_section();

	}

	
	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		$video_preview = $settings['el_media']['url']; 

		$product_thumb = !empty($settings['el_poster']['url']) ? ' poster="'.$settings['el_poster']['url'].'"' : '';

		$video_player = \mweb_theme_util::get_theme_option('mweb_video_player');

		if( !empty($video_preview) ){
			echo '<div class="box_wrap mweb_video_element player_is_'.$video_player.'">';
				if($video_player == 'videojs'){
					$array_ext = explode('.', $video_preview);
					$file_extension = end($array_ext);
					if( $file_extension == 'm3u8'){
						echo '<video class="video-js vjs-default-skin elm_video" id="v_'.$this->get_id().'" controls="controls" '.$product_thumb.'><source src="'.esc_attr(apply_filters('mweb_private_course_link', $video_preview)).'" type="application/x-mpegURL"></video>';
					}else{
						echo '<video class="video-js vjs-default-skin elm_video" id="v_'.$this->get_id().'" controls="controls" '.$product_thumb.'><source src="'.esc_attr(apply_filters('mweb_private_course_link', $video_preview)).'" type="video/mp4" title="mp4"><p>مرورگر شما از پخش ویدیو پشتیبانی نمی کند</p></video>';
					}
				}else{
					echo '<video class="elm_video" style="display:none;width:100%;height:100%;" oncontextmenu="return false;" controls="controls" '.$product_thumb.'><source src="'.esc_attr(apply_filters('mweb_private_course_link', $video_preview)).'" type="video/mp4" title="mp4"><p>مرورگر شما از پخش ویدیو پشتیبانی نمی کند</p></video>';
				}
			echo '</div>';	
		}


	}

	
	protected function content_template() {

	}
}
