<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Elementor Header Logo
 * @since 1.0.0
 */
class My_Header_Logo extends Widget_Base {

	
	public function get_name() {
		return 'my-header-logo';
	}
	
	public function get_title() {
		return __( 'لوگو', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-site-logo';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'لوگو', 'mweb' ),
			]
		);

		$this->add_control(
			'logo',
			[
				'label' => __( 'آپلود لوگو', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'description' => 'رها کردن = پیشفرض تنظیمات پوسته'
			]
		);
		$this->add_control(
			'link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'show_external' => false,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'description' => 'رها کردن = پیشفرض آدرس سایت'
			]
		);
		$this->add_control(
			'align',
			[
				'label' => __( 'چیدمان', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		
		
		$this->add_control(
			'width',
			[
				'label' => __( 'عرض', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .logo img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'max_height',
			[
				'label' => __( 'حداکثر ارتفاع', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .logo img' => 'max-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		

		/* $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->end_controls_section(); */
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$logo = empty( $settings['logo'] ) ? \mweb_theme_util::get_theme_option('mweb_logo', 'id') : $settings['logo']['id'];
		$link = empty( $settings['link']['url'] ) ? home_url( '/' ) : $settings['link']['url'];
		
		//print_r(\mweb_theme_util::get_theme_option('mweb_logo'));
		?>
		<div class="logo elm_logo align_<?= $settings['align'] ?>" <?php \mweb_theme_schema::makeup('logo'); ?>>
			<a href="<?php echo esc_url($link); ?>" title="<?php bloginfo( 'name' ); ?>">
				<?php if ( !empty($logo) ): 
					$image_attributes = wp_get_attachment_image_src( $logo, 'full' ); ?>
					<img src="<?php echo esc_url($image_attributes[0]); ?>"  width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" <?php \mweb_theme_schema::makeup('image'); ?>>
				<?php else : ?>
					<img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" <?php \mweb_theme_schema::makeup('image'); ?>>
				<?php endif; ?>
			</a>	
			<meta itemprop="name" content="<?php bloginfo( 'name' ) ?>">
		</div>
		<?php
	}

	
	protected function content_template() {
		
	}
}







/**
 * Elementor Header Cart
 * @since 1.0.0
 */
class My_Header_Cart extends Widget_Base {

	
	public function get_name() {
		return 'my-header-cart';
	}
	
	public function get_title() {
		return __( 'سبد خرید', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-cart-light';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'سبد خرید', 'mweb' ),
			]
		);
		
		$this->add_control(
			'cart_type',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					't_style_1'  => __( 'یک', 'mweb' ),
					't_style_2' => __( 'دو', 'mweb' ),
				],
				'default' => 't_style_1',
			]
		);
		
		$this->add_control(
			'btn_cart_icon_name',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'fal fa-shopping-bag', 'mweb' ),
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [
					'unit' => 'px',
					'size' => 18,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box i' => 'font-size: {{SIZE}}{{UNIT}}',
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .mini_cart_box'
			]
		);
		
		$this->add_responsive_control(
			'btn_lineheight',
			[
				'label' => __( 'ارتفاع خط', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 43,
				],
				'range' => [
					'px' => [
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box' => 'line-height: {{SIZE}}{{UNIT}}',
				
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_cart_box_shadow',
				'selector' => '{{WRAPPER}} .mini_cart_box',
			]
		);
		
		$this->add_control(
			'btn_cart_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'btn_cart_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'counter_text_color',
			[
				'label' => __( 'رنگ متن شمارنده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'counter_background',
			[
				'label' => __( 'رنگ پس زمینه شمارنده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mini_cart_box span' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .mini_cart_box.cart_t2 span:before' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		
		
		$this->end_controls_section();

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$btn_icon = empty($settings['btn_cart_icon_name']) ? 'fal fa-shopping-bag' : $settings['btn_cart_icon_name'];
		
			if( $settings['cart_type'] == 't_style_1' ) :
		?>
				<a class="mini_cart_box" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="مشاهده سبد خرید"><i class="<?= $btn_icon ?>"></i><span class="cart-count"><?php echo sprintf (_n( '%d ', '%d ', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ); ?></span></a>
		<?php
			else:
		?>
				<a class="mini_cart_box cart_t2" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="مشاهده سبد خرید"><i class="<?= $btn_icon ?>""></i><span class="cart-count"><?php echo sprintf (_n( '%d ', '%d ', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ); ?></span></a>	
		<?php
			endif;
	}

	
	protected function content_template() {
		
	}
}




/**
 * Elementor Header Button
 * @since 1.0.0
 */
class My_Header_Button extends Widget_Base {

	
	public function get_name() {
		return 'my-header-button';
	}
	
	public function get_title() {
		return __( 'آیکن / دکمه', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-button';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'دکمه', 'mweb' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => 'جهت نمایش آیکن تنها این فیلد را خالی رها کنید'
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fal fa-box-open',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		
				
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [
					'unit' => 'px',
					'size' => 18,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c i' => 'font-size: {{SIZE}}{{UNIT}}',
				]
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_margin',
			[
				'label' => __( 'فاصله خارجی آیکن', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .elm_btn_c',
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'background',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c' => 'background-color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'icon_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
			
		$this->add_control(
			'border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elm_btn_c' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow',
				'selector' => '{{WRAPPER}} .elm_btn_c',
			]
		);
		
		$this->add_control(
			'link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		
		$this->add_control(
			'is_login',
			[
				'label' => __( 'نمایش مخصوص اعضا', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
	

		$this->end_controls_section();

		
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
			$class = empty($settings['title']) ? '' : ' auto_width';
			
			if(!is_user_logged_in() && $settings['is_login'] === 'yes'){
				return false;
			}
			
			if(!empty($settings['link']['url'])){
				$target = $settings['link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : '';
				echo '<a class="elm_btn_c'.$class.'" href="' . esc_url( $settings['link']['url'] ) . '" title="' . esc_attr( $settings['title'] ) . '" ' . $target . $nofollow . '>';
			}else{
				echo '<div class="elm_btn_c'.$class.'">';
			}
			
			if(!empty($settings['icon'])){
				echo '<i class="'.$settings['icon'].'"></i>';
			}
			
			echo '<span>'.$settings['title'].'</span>';
			
			if(!empty($settings['link']['url'])){
				echo '</a>';
			}else{
				echo '</div>';
			}		
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * @access protected
	 */
	protected function content_template() {
		
	}
}








/**
 * Elementor Header User
 * @since 1.0.0
 */
class My_Header_User extends Widget_Base {

	
	public function get_name() {
		return 'my-header-user';
	}
	
	public function get_title() {
		return __( 'ورود و عضویت', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-site-identity';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'ورود و عضویت', 'mweb' ),
			]
		);
		
		$this->add_control(
			'login_type',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'u_style_1'  => __( 'نوع یک', 'mweb' ),
					'u_style_2' => __( 'نوع دو', 'mweb' ),
					'u_style_3' => __( 'سفارشی', 'mweb' ),
				],
				'default' => 'u_style_1',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => __( 'تایپوگرافی', 'mweb' ),
				'selector' => '{{WRAPPER}} .elm_user_btn, {{WRAPPER}} .login_wrap',
			]
		);
		
		$this->add_control(
			'background',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_user_btn' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap' => 'background-color: {{VALUE}}',
				],
			]
		);
	
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_user_btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap>span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap>a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'divider_color',
			[
				'label' => __( 'رنگ جداکننده', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .login_wrap>span:first-child:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap>a:first-child:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .header_type3 .login_wrap>span:first-child:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .header_type3 .login_wrap>a:first-child:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .fa-i-cursor' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elm_user_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .login_wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .logout_user_btn' => 'border-radius: {{TOP}}{{UNIT}} 0 0 {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'show_icon',
			[
				'label' => __( 'نمایش آیکن', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'login_type' => ['u_style_3'] ]
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_user_btn i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap>span i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .login_wrap>a i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elm_user_btn i' => 'font-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .login_wrap>span i' => 'font-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .login_wrap>a i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow',
				'selector' => '{{WRAPPER}} .elm_user_btn, {{WRAPPER}} .login_wrap',
			]
		);


		$this->end_controls_section();

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if( $settings['login_type'] != 'u_style_3' ){
			if($settings['login_type'] == 'u_style_2'){
				echo '<div class="header_type3 head_login">';
			}
			
			get_template_part( 'templates/header/module','login' );
			
			if($settings['login_type'] == 'u_style_2'){
				echo '</div>';
			}
		}else{
		
			$ajax_register_login = \mweb_theme_util::get_theme_option( 'ajax_register_login' );

			if($ajax_register_login){
				$user_text = ['<p><span class="singup_user_btn">عضویت</span><i class="fal fa-slash-forward"></i><span class="login_user_btn">ورود</span></p>', '<p>خوش آمدید <b>%s</b></p>'];
			}else{
				$user_text = ['<p><a href="'.esc_url($mweb_acc_url).'" class="singup_user_btn">عضویت</a><i class="fal fa-i-cursor"></i><a href="'.esc_url($mweb_acc_url).'" class="login_user_btn">ورود</a></p>', '<p>خوش آمدید <b>%s</b></p>'];
			} 
		
			$mweb_acc_url = \mweb_theme_util::get_theme_option('mweb_head_account_url'); 
			if(empty($mweb_acc_url)){
				$mweb_acc_url = get_permalink( get_option('woocommerce_myaccount_page_id'));
			}
			
			?>
			<?php if(is_user_logged_in()):
				  $current_user = wp_get_current_user(); ?>
				<a class="elm_user_btn el_is_text" href="<?php echo esc_url($mweb_acc_url); ?>">
					<?php 
						if($settings['show_icon'] === 'yes'){
							echo '<i class="fal fa-user-cog"></i>';
						}
						printf($user_text[1], $current_user->display_name);
					?>
				</a>
				<?php else: ?>
					<span class="elm_user_btn el_is_text" href="<?php echo esc_url($mweb_acc_url); ?>">
					<?php 
						if($settings['show_icon'] === 'yes'){
							echo '<i class="fal fa-user"></i>';
						}
						echo $user_text[0]; 
					?>
					<div class="account_action">
						<i class="close_modal fal fa-times-circle"></i>
						<div class="login_form acc_div">
							<form id="mweb_login" action="#0" method="post">
								<span class="username"><input id="signin_email" name="signin_email" type="text" placeholder="نام کاربری یا شماره موبایل" required=""></span>
								<span class="password"><input id="signin_password" name="signin_password" type="password" placeholder="گذرواژه" required=""></span>
								<label><input type="checkbox" id="remember-me" name="remember-me"><span>مرا به خاطر بسپار</span></label>
								<p id="message"></p>
								<input type="hidden" name="action" value="ajax_login">
								<input type="submit" value="ورود به حساب کاربری">
								<a class="lost" href="<?php echo wp_lostpassword_url(); ?>">فراموشی گذرواژه؟</a>
								<?php do_action('google_invre_render_widget_action'); ?>
							</form>
						</div>
						<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>
						<div class="register_form acc_div">
							<form id="mweb_register" action="#0" method="post">					
								<span class="name">
								  <input type="text" name="signup_name" id="signup_name" value="" placeholder="نام" required="">
								</span>
								
								<span class="nickname">
								  <input type="text" name="signup_family" id="signup_family" value="" placeholder="نام خانوادگی" required="">
								</span>
							 
								<span class="mail">
								  <input type="email" name="signup_email" id="signup_email" value="" placeholder="پست الکترونیک" required="">
								</span>

								<span class="mobile">
								  <input type="text" name="signup_mobile" id="signup_mobile" class="ltr_el" value="" placeholder="شماره موبایل 09120005511" size="20" required="">
								</span>
								
								<span class="username">
								  <input type="text" name="signup_username" id="signup_username" value="" placeholder="نام کاربری" size="20" required="">
								  <p class="help-block">لطفا از حروف a-z,A-Z,0-9 استفاده نمایید - حداقل 5 کاراکتر</p>
								</span>
							 
								<span class="password">
								  <input type="password" name="signup_pass" id="signup_pass" value="" placeholder="گذرواژه" required="">
								  <p class="help-block">حداقل 8 کاراکتر</p>
								</span>
								
								<p id="message"></p>
								<input type="hidden" name="action" value="ajax_register">
								<input type="submit" value="عضویت">
								<?php if(is_dokan_activated()){
										echo '<a class="lost" href="'.get_permalink( get_option('woocommerce_myaccount_page_id') ).'">فروشنده شوید</a>';
									  }
								?>
								
								<?php do_action('google_invre_render_widget_action'); ?>
							</form>
							
				
						</div>
						<?php else:  ?>
						<p><?php esc_html_e( 'امکان عضویت در سایت توسط مدیر غیر فعال شده است', 'woocommerce' ); ?></p>
						<?php endif; ?>

					</div>
					</span>
			<?php endif;
		} ?>
		<?php
		
	}

	
	protected function content_template() {
		
	}
}




/**
 * Elementor Header Menu
 * @since 1.0.0
 */
class My_Header_Menu extends Widget_Base {

	
	public function get_name() {
		return 'my-header-menu';
	}
	
	public function get_title() {
		return __( 'منو اصلی', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-menu-toggle';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'منو اصلی', 'mweb' ),
			]
		);
		
		$this->add_control(
			'menu',
			[
				'label' => __( 'انتخاب منو', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => get_element_menu_list(),
			]
		);
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu ul>li.level-0>a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .mobile-nav-button' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'hover_color',
			[
				'label' => __( 'رنگ متن هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu ul>li.level-0>a .caret, .mweb-main-menu ul>li.level-0>a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .mobile-nav-button a' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'hover_color_icon',
			[
				'label' => __( 'رنگ آیکن هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0:hover>a>.menu-item-text i' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'font_family',
			[
				'label' => __( 'خانواده فونت', 'mweb' ),
				'type' => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu' => 'font-family: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'lvl_one_size',
			[
				'label' => __( 'اندازه فونت سطح یک', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 13,
				],
				'range' => [
					'px' => [
						'min' => 12,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0>a' => 'font-size: {{SIZE}}{{UNIT}}',
					'.mobile-nav-button a' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_control(
			'lvl_two_size',
			[
				'label' => __( 'اندازه فونت سطح دو', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 12,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0 div.sub-menu li a' => 'font-size: {{SIZE}}{{UNIT}}',
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0>ul.sub-menu li a' => 'font-size: {{SIZE}}{{UNIT}}'
				],
			]
		);
		$this->add_control(
			'item_icon_size',
			[
				'label' => __( 'اندازه آیکن سطح یک', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 19,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 50,
						'step' => 1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0>a>.menu-item-text i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'item_padding_side',
			[
				'label' => __( 'فاصله داخلی چپ و راست سطح اول', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 50,
						'step' => 1,
					],
				],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .mweb-main-menu ul>li.level-0' => 'padding: 0px {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'icon_in_center',
			[
				'label' => __( 'آیکن سطر اول عمودی', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-menu-icon-vertical-',
			]
		);
		
		$this->add_control(
			'item_height',
			[
				'label' => __( 'ارتفاع سطح یک', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [
					'unit' => 'px',
					'size' => 49,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu ul>li.level-0' => 'height: {{SIZE}}{{UNIT}}',
				],
				'condition' => [ 'icon_in_center' => 'yes' ]
			]
		);
		
		$this->add_control(
			'item_line_height',
			[
				'label' => __( 'ارتفاع خط سطح یک', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'default' => [
					'unit' => 'px',
					'size' => 49,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu ul>li.level-0' => 'line-height: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'mobile_alignment',
			[
				'label' => __( 'تراز افقی دکمه منو موبایل', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mobile-nav-button' => 'text-align: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'menu_vertical_align',
			[
				'label' => __( 'منو عمودی', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'right_menu elm_mneu_r-',
				'condition' => [ 'icon_in_center!' => 'yes' ]
			]
		);
		
		$this->add_control(
			'mneu_item_show',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'both'   => __( 'هر دو', 'mweb' ),
					'main_menu'   => __( 'منو اصلی', 'mweb' ),
					'mobile_menu'   => __( 'منو همبرگری(موبایل)', 'mweb' ),
				],
				'default' => 'both',
				'description' => 'صرفا برای جداسازی آیکن همبرگری منو ریسپانسیو'
			]
		);
		
		$this->add_control(
			'menu_hm_only_icon',
			[
				'label' => __( 'فقط نمایش آیکن', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elm_menu_hm-',
				'condition' => [ 'mneu_item_show' => 'mobile_menu' ]
			]
		);
		
		$this->add_control(
			'menu_hm_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} #mweb-trigger' => 'font-size: {{SIZE}}{{UNIT}}',
				],
				'condition' => [ 'mneu_item_show' => 'mobile_menu' ]
			]
		);
		
		$this->add_control(
			'menu_hm_icon_color',
			[
				'label' => __( 'رنگ آیکن همبرگری', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #mweb-trigger' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'sub_menu_radius',
			[
				'label' => __( 'گوشه های مدور زیر منو', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .mweb-main-menu ul div.sub-menu, {{WRAPPER}} .mweb-main-menu ul ul.sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]			]
		);
		
		$this->add_control(
			'sub_menu_blur',
			[
				'label' => __( 'پس زمینه شفاف زیر منو', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'elementor-menu--blur-',
			]
		);
	
		
		
		$this->end_controls_section();
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if( in_array( $settings['mneu_item_show'], [ 'both', 'main_menu' ] ) ){
			echo '<div id="navigation" class="mweb-drop-down mweb-main-menu">';
				if( $settings['menu'] ){
					wp_nav_menu(
						array(
							'menu' => $settings['menu'],
							'container'      => false,
							'walker'         => new \mweb_mega_menu_walker,
							)
					);
				} else {
					if( has_nav_menu('main-menu') ){
						wp_nav_menu(
							array(
								'theme_location' => 'main-menu',
								'container'      => '',
								'walker'         => new \mweb_mega_menu_walker,
								)
						);
					}
				}
			echo '</div>';
		}
		
		if( in_array( $settings['mneu_item_show'], [ 'both', 'mobile_menu' ] ) ){
			get_template_part( 'templates/header/module', 'nav_mobile' ); 
			if( $settings['menu_hm_only_icon'] == 'yes' )
				echo '<a id="mweb-trigger" class="icon-wrap" href="#"><i class="fal fa-bars"></i></a>';
			else
				get_template_part( 'templates/header/module', 'menu_button' ); 

		}
		
	}

	
	protected function content_template() {
		
	}
}




/**
 * Elementor Header Menu Small
 * @since 1.0.0
 */
class My_Header_Menu_Small extends Widget_Base {

	
	public function get_name() {
		return 'my-header-menu-small';
	}
	
	public function get_title() {
		return __( 'منو فرعی', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-divider-shape';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'منو فرعی', 'mweb' ),
			]
		);
		
		$this->add_control(
			'menu_name',
			[
				'label' => __( 'انتخاب منو', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => get_element_menu_list(),
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top_menu ul li a' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'hover_color',
			[
				'label' => __( 'رنگ متن هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top_menu ul li a:hover' => 'color: {{VALUE}}',
				]
			]
		);
	
		
		$this->end_controls_section();
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$nav_menu = ! empty( $settings['menu_name'] ) ? wp_get_nav_menu_object( $settings['menu_name'] ) : false;

		if ( !$nav_menu )
			return;
		
		echo '<div class="top_menu">';
			wp_nav_menu( array(
				'mneu' => $nav_menu,
				'container' => false, 
				'menu_id' => '',
				'depth' => 1,
				'items_wrap' => '<ul>%3$s</ul>',
				'menu_class' => ''
			));
		echo '</div>';
			
	}

	
	protected function content_template() {
		
	}
}





/**
 * Elementor Header User
 * @since 1.0.0
 */
class My_Header_Social extends Widget_Base {

	
	public function get_name() {
		return 'my-header-social';
	}
	
	public function get_title() {
		return __( 'شبکه های اجتماعی', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-social-icons';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'شبکه های اجتماعی', 'mweb' ),
			]
		);
		
		$this->add_control(
			'more_options',
			[
				'label' => __( 'تنظیمات شبکه های اجتماعی را از پنل مدیریت پوسته تغییر دهید', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .head_social_wrap a' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'align',
			[
				'label' => __( 'چیدمان', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		
	
		
		$this->end_controls_section();
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$mweb_social_head = \mweb_theme_util::get_theme_option('mweb_social_head');

		if ( is_array($mweb_social_head) && !empty($mweb_social_head)){
			echo '<div class="head_social_wrap align_'.$settings['align'].'">'; 
			foreach ($mweb_social_head as $social => $key ) {
				if(!empty($key))
				echo '<a href="'.esc_url($key).'" class="el_'.esc_attr($social).'" target="_blank"><i class="fab fa-'.esc_attr($social).'"></i></a>';
			}
			echo '</div>';
		}
			
	}

	
	protected function content_template() {
		
	}
}






/**
 * Elementor Header Phone
 * @since 1.0.0
 */
class My_Header_Phone extends Widget_Base {

	
	public function get_name() {
		return 'mweb-call-us';
	}
	
	public function get_title() {
		return __( 'شماره تماس', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-tel-field';
	}

	public function get_categories() {
		return [ 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'view_type',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => [
					'one' => __( 'یک', 'mweb' ),
					'two' => __( 'دو', 'mweb' ),
					//'inline' => __( 'سه', 'mweb' ),
				],
				'prefix_class' => 'elementor-phone-number--view-',
			]
		);

		$this->add_control(
			'heading_phone_number',
			[
				'label' => __( 'شماره تماس', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'phone_number_code',
			[
				'label' => __( 'پیش شماره', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => '021',
			]
		);
		
		$this->add_control(
			'phone_number',
			[
				'label' => __( 'شماره', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => '42156644',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'phone_code_typography',
				'label' => __( 'تایپوگرافی پیش شماره', 'mweb' ),
				'selector' => '{{WRAPPER}} .call_number span',
			]
		);

		$this->add_control(
			'phone_code_color',
			[
				'label' => __( 'رنگ پیش شماره', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .call_number span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'phone_number_typography',
				'label' => __( 'تایپوگرافی شماره', 'mweb' ),
				'selector' => '{{WRAPPER}} .call_number strong',
			]
		);

		$this->add_control(
			'phone_number_color',
			[
				'label' => __( 'رنگ شماره', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .call_number strong' => 'color: {{VALUE}}',
				],
			]
		);

		
		$this->add_control(
			'heading_phone_alt',
			[
				'label' => __( 'متن یا توضیح', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'phone_alt',
			[
				'label' => __( 'متن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'با ما در تماس باشـید', 'mweb' ),
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'phone_alt_typography',
				'label' => __( 'تایپوگرافی متن', 'mweb' ),
				'selector' => '{{WRAPPER}} .call_number_alt',
			]
		);

		$this->add_control(
			'phone_alt_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .call_number_alt' => 'color: {{VALUE}}',
				],
			]
		);
		
		
		$this->add_control(
			'heading_phone_icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'phone_icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'fal fa-phone-volume', 'mweb' ),
			]
		);
		
		$this->add_control(
			'phone_icon_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'برای درج آیکن مورد دلخواه باید به ادرس زیر مراجعه کرده و کلاس آیکن مورد نظر را مثل نمونه پر کنید <br> https://fontawesome.com/icons?d=gallery&s=light', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'phone_icon_typography',
				'label' => __( 'تایپوگرافی آیکن', 'mweb' ),
				'selector' => '{{WRAPPER}} .el_call_number i',
			]
		);

		$this->add_control(
			'phone_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_call_number i' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'phone_icon_margin',
			[
				'label' => __( 'فاصله خارجی آیکن', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .el_call_number i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		


	}

	
	protected function render() {
	
		$settings = $this->get_settings_for_display();
		
		echo '<div class="el_call_number">';
			
			if($settings['view_type'] == 'two')
				echo '<div class="call_number_row">';
			
				echo '<div class="call_number">';
					printf('<strong>%1$s</strong><span>%2$s</span>', $settings['phone_number'], $settings['phone_number_code'] );
					if(!empty($settings['phone_icon']) && $settings['view_type'] == 'one'){
						echo '<i class="'.$settings['phone_icon'].'"></i>';
					}
				echo '</div>';
				
				if(!empty($settings['phone_alt'])){
					echo '<p class="call_number_alt">'.$settings['phone_alt'].'</p>';
				}
				
			if($settings['view_type'] == 'two')	
				echo '</div>';
			
			if(!empty($settings['phone_icon']) && $settings['view_type'] == 'two'){
				echo '<i class="'.$settings['phone_icon'].'"></i>';
			}
		
		echo '</div>';
		
		

	}

	
	protected function content_template() {
		
	}
}