<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Podcast
 * @since 1.0.0
 */
class Block_Podcast extends Widget_Base {

	
	public function get_name() {
		return 'block-podcast';
	}

	
	public function get_title() {
		return __( 'پادکست', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-play';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'پادکست', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'thumb',
			[
				'label' => __( 'تصویر', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'description' => ''
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => __( 'زیر عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		
		$this->add_control(
			'source',
			[
				'label' => __( 'لینک صوت', 'mweb' ),
				'type' => Controls_Manager::URL,
				'show_external' => false,
				'placeholder' => __( 'https://your-link.com/exp.mp3', 'mweb' ),
			]
		);

		

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'استایل', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .podcast_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .podcast_wrapper',
			]
		);
		$this->end_controls_section();
		

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo do_shortcode('[podcast title="'.$settings['title'].'" desc="'.$settings['desc'].'" poster="'.$settings['thumb']['url'].'" source="'.$settings['source']['url'].'"]');
		
	}

	
	protected function content_template() {
		
	}
}





/**
 * Elementor popup play
 * @since 1.0.0
 */
class Block_Popup_Play extends Widget_Base {

	
	public function get_name() {
		return 'block-popup-play';
	}

	
	public function get_title() {
		return __( 'دکمه پخش پاپ آپ', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-play';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'دکمه پخش', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'source',
			[
				'label' => __( 'لینک ویدیو', 'mweb' ),
				'type' => Controls_Manager::URL,
				'show_external' => false,
				'placeholder' => 'https://your-link.com/video.mp4',
			]
		);

		

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'استایل', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'btn_size',
			[
				'label' => __( 'اندازه دکمه', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .popup_video' => 'width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .popup_video' => 'height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .popup_video' => 'line-height: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .popup_video' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'btn_bg_color',
			[
				'label' => __( 'رنگ پس زمینه دکمه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .popup_video' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .popup_video:before, {{WRAPPER}} .popup_video:after' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'btn_icon_color',
			[
				'label' => __( 'رنگ آیکن دکمه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .popup_video' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'گوشه های مدور دکمه', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .popup_video, {{WRAPPER}} .popup_video:before, {{WRAPPER}} .popup_video:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		
		$this->end_controls_section();
		

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		echo '<span class="popup_video preview_btn" data-src="'.esc_url($settings['source']['url']).'"><i class="fal fa-play"></i></span>';
		
	}

	
	protected function content_template() {
		
	}
}





/**
 * Elementor Module Category
 * @since 1.0.0
 */
class Block_Category extends Widget_Base {

	
	public function get_name() {
		return 'block-category';
	}

	
	public function get_title() {
		return __( 'دسته بندی ها', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-library-save';
	}

	
	public function get_categories() {
		return [ 'digiacademy', 'digiacademy_woo' ];
	}


	protected function register_controls() {
		
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'عنوان', 'mweb' ),
			]
		);		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان بلاک', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fa-folders',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		
		$this->add_control(
			'hr_title',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_bgcolor',
			[
				'label' => __( 'رنگ پس زمینه عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .block-title .title',
			]
		);
		
		$this->add_control(
			'title_icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .bk_view_more i' => 'background-color: {{VALUE}}'
				],
			]
		);
		
		$this->add_control(
			'title_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .block-title .title i' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_filter',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);

		$this->add_control(
			'is_archive',
			[
				'label' => __( 'استفاده در آرشیو', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'has_parent',
			[
				'label' => __( 'دسته والد', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => get_element_category_list('product_cat'),
			]
		);
		
		$this->add_control(
			'has_include',
			[
				'label' => __( 'انتخاب دسته ها ', 'mweb' ),
				'type' => Controls_Manager::SELECT2,
				'description' => '',
				'multiple' => true,
				'default' => 0,
				'options' => get_element_category_multiple_list('product_cat'),
			]
		);
		
		$this->add_control(
			'top_level',
			[
				'label' => __( 'فقط نمایش زیر شاخه اول', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'hide_empty',
			[
				'label' => __( 'نمایش دسته خالی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		
		$this->add_control(
			'cat_to_show',
			[
				'label' => __( 'تعداد نمایش دسته', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 8,
			]
		);
		
		$this->add_control(
			'show_count',
			[
				'label' => __( 'نمایش تعداد محصولات', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'counter_title',
			[
				'label' => __( 'واحد شمارنده', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'درس',
				'condition' => [ 'show_count' => ['yes'] ],
			]
		);

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'block_type',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __( 'یک', 'mweb' ),
					'2' => __( 'دو', 'mweb' ),
					'3' => __( 'سه', 'mweb' ),
					'4' => __( 'چهار', 'mweb' ),
				],
				'default' => '1',
			]
		);
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'آیتم ردیف', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					1 => '12',
					2 => '6',
					3 => '4',
					4 => '3',
					6 => '2',
				], 
				'default' => 3,
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .el-item-category:not(.type3)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .el-item-category.type1 .el-category-icon-data' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		
		$this->add_responsive_control(
			'bottom_spacing',
			[
				'label' => __( 'فاصله از پایین', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .el-item-category' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();


	}
	
	
	public function product_category_type_1( $category, $cat_color, $cat_bg, $cat_thumb, $cat_link, $counter, $ctitle ) {
		
		?>
		<div class="el-item-category type1"<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.', 0.1); "' : '' ?>>
			<?= $cat_bg; ?>
			<div class="el-category-meta">
				<div class="el-category-icon-data"<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.'); "' : '' ?>>
					<?= $cat_thumb; ?>
				</div>
				<h3>
					<a href="<?= esc_url($cat_link) ?>"><?= $category->name; ?></a>
				</h3>
				<?php if($counter == 'yes'){ ?>
					<div class="el-category-total-items">
						<span<?= !empty($cat_color) ? ' style="color:rgb('.$cat_color.'); "' : '' ?>><?= $category->count ?></span>
						<p<?= !empty($cat_color) ? ' style="color:rgb('.$cat_color.'); "' : '' ?>><?= $ctitle ?></p>
					</div>
				<?php } ?>
			</div>
		</div>
		
		<?php
	}
	
	
	public function product_category_type_2( $category, $cat_color, $cat_bg, $cat_thumb, $cat_link, $counter, $ctitle ) {
		
		?>
		<div class="el-item-category type2">
			<?= $cat_bg; ?>
			<h3>
				<a href="<?= esc_url($cat_link) ?>"><?= $category->name; ?></a>
			</h3>
			<div class="el-category-icon-data"<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.'); "' : '' ?>>
				<?= $cat_thumb; ?>
			</div>
			<?php if($counter == 'yes'){ ?>
				<div class="el-category-total-items">
					<span<?= !empty($cat_color) ? ' style="color:rgb('.$cat_color.'); "' : '' ?>><?= $category->count ?></span>
					<p<?= !empty($cat_color) ? ' style="color:rgb('.$cat_color.'); "' : '' ?>><?= $ctitle ?></p>
				</div>
			<?php } ?>
		</div>

		<?php
	}
	
	
	public function product_category_type_3( $category, $cat_color, $cat_bg, $cat_thumb, $cat_link, $counter, $ctitle ) {
		
		?>
		<div class="el-item-category type4"<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.'); "' : '' ?>>
			<div class="el-category-meta">
				<h3>
					<a href="<?= esc_url($cat_link) ?>"><?= $category->name; ?></a>
				</h3>
				<?php if($counter == 'yes'){ ?>
					<div class="el-category-total-items">
						<span><?= $category->count ?></span><?= $ctitle ?>
					</div>
				<?php } ?>
			</div>
		</div>
		
		<?php
	}
	
	
	public function product_category_type_4( $category, $cat_color, $cat_bg, $cat_thumb, $cat_link, $counter, $ctitle ) {
		
		?>
		<div class="el-item-category type5">
			<?= $cat_bg; ?>
			<div class="el-category-meta">
				<span<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.'); "' : '' ?>>
					<?= $cat_thumb; ?>
				</span>
				<h3>
					<a href="<?= esc_url($cat_link) ?>"><?= $category->name; ?></a>
				</h3>
				<?php if($counter == 'yes'){ ?>
					<div class="el-category-total-items"<?= !empty($cat_color) ? ' style="background-color:rgb('.$cat_color.'); "' : '' ?>>
						<span><?= $category->count ?></span>
					</div>
				<?php } ?>
			</div>
		</div>
		
		<?php
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();

		if( empty($settings['has_include']) && !isset($settings['has_parent']) ){
			
			echo mweb_error('دسته ای انتخاب نشده است !');
			
		} else {
		
			$cat_args = array(
				'taxonomy' => 'product_cat',
				'orderby' => 'name',
				'order'   => 'ASC'
			);
			
			if( $settings['hide_empty'] == 'yes'){
				$cat_args['hide_empty'] = false;
			}
			
			if( $settings['is_archive'] == 'no' ){
				if( !empty($settings['has_include']) ){
					$cat_args['include'] = implode(',', $settings['has_include']);
				}
				
				if( !empty($settings['has_parent']) ){
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = (int) $settings['has_parent'];
					}else{
						$cat_args['child_of'] = (int) $settings['has_parent'];
					}
				}else{
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = 0;
					}
				}
			}else{
				$category_ar = get_queried_object();

				if( !empty($category_ar) ){
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = (int) $category_ar->term_id;
					}else{
						$cat_args['child_of'] = (int) $category_ar->term_id;
					}
				}else{
					if( $settings['top_level'] == 'yes' ){
						$cat_args['parent'] = 0;
					}
				}
			}
			

		   
			$categories = get_categories( $cat_args );
			
			if( !empty($categories) ){
				
		
				$block_options = array('block_id' => 'bk_'.$this->get_id() ,'block_name' => 'mweb_category', 'block_options' => array( 'title' => $settings['title'],'icon' => $settings['icon'] ));
		
				$slide_desktop = empty($settings['slides_to_show']) ? 4 : $settings['slides_to_show'];
				$slide_tablet = empty($settings['slides_to_show_tablet']) ? 4 : $settings['slides_to_show_tablet'];
				$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];  

				$item_class = sprintf('col-%d col-md-%d col-lg-%d', 12/$slide_mobile, 12/$slide_tablet, 12/$slide_desktop);
				
				$loop_name = 'product_category_type_'.$settings['block_type'];

				echo \mweb_theme_block::block_open( $block_options );
				echo \mweb_theme_block::block_header( $block_options );
				echo \mweb_theme_block::block_content_open();
				
					$item_counter = 1;
					echo '<div class="row">';
					
					foreach( $categories as $category ) :
						
						$cat_color = get_term_meta( $category->term_id, 'cat_color', true );
						$cat_color = !empty($cat_color) ? mweb_hex2rgb($cat_color) : '';
						$cat_bg = get_term_meta( $category->term_id, 'cat_bg', true );
						$cat_bg = !empty($cat_bg) ? wp_get_attachment_image( $cat_bg, 'full' ) : '';
						$cat_thumb = get_term_meta( $category->term_id, 'thumbnail_id', true );
						$cat_thumb = !empty($cat_thumb) ? wp_get_attachment_image( $cat_thumb, 'thumbnail' ) : '';
						$cat_link = get_term_link( $category , 'product_cat' );
						
						echo '<div class="'.$item_class.'">';
						
							$this->$loop_name( $category, $cat_color, $cat_bg, $cat_thumb, $cat_link, $settings['show_count'], $settings['counter_title'] );
					
							$item_counter++;
							if( $item_counter > $settings['cat_to_show'] )
								break;
						
						echo '</div>';		
						
					endforeach;

				
					echo '</div>';		
					
				echo \mweb_theme_block::block_content_close();
				echo \mweb_theme_block::block_footer( $block_options );
				echo \mweb_theme_block::block_close();
				
	
			}
		
		}

	}

	
	protected function content_template() {
		
	}
}
