<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Testimonial Slider
 * @since 1.0.0
 */
class Block_Testimonial_Slider extends Widget_Base {

	
	public function get_name() {
		return 'block-testimonial-slider';
	}

	
	public function get_title() {
		return __( 'نظرات کاربران', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-comments';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'el_title',
			[
				'label' => __( 'نام', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'el_post',
			[
				'label' => __( 'سمت', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'el_content',
			[
				'label' => __( 'توضیحات', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'el_avatar',
			[
				'label' => __( 'تصویر', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'ایتم ها', 'mweb' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ el_title }}}',
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'استایل', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial_content' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'تایپوگرافی متن', 'mweb' ),
				'selector' => '{{WRAPPER}} .el_testimonial_content',
			]
		);
		
		$this->add_control(
			'name_color',
			[
				'label' => __( 'رنگ نام', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial h5.name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'neme_typography',
				'label' => __( 'تایپوگرافی نام', 'mweb' ),
				'selector' => '{{WRAPPER}} .el_testimonial h5.name',
			]
		);
		
		$this->add_control(
			'semat_color',
			[
				'label' => __( 'رنگ سمت', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'semat_typography',
				'label' => __( 'تایپوگرافی سمت', 'mweb' ),
				'selector' => '{{WRAPPER}} .el_testimonial span',
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial.el_tsl_1:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .el_testimonial.el_tsl_3:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .el_testimonial.el_tsl_2 .el_testimonial_avatar:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial.el_tsl_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el_testimonial.el_tsl_2' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .el_testimonial' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swiper-slide-shadow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .el_testimonial',
			]
		);
		
		$this->add_control(
			'item_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .el_testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تراز متن', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .el_testimonial_content' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'اسلایدر', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'show_type',
			[
				'label' => __( 'نوع نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => [
					'one' => __( 'یک', 'mweb' ),
					'two' => __( 'دو', 'mweb' ),
					'three' => __( 'سه', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'active_slide_color',
			[
				'label' => __( 'رنگ حاشیه آیتم فعال', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ts_pagination .pagination__item::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [ 'show_type' => 'three' ],
			]
		);
		
		$this->add_control(
			'show_type_warning',
			[
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'موارد زیر شامل نوع نمایش 3 نمی شود', 'mweb' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		$slides_to_show = range( 1, 10 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'اسلاید جهت نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 3,
			]
		);
		
		$this->add_control(
			'navigation_show',
			[
				'label' => __( 'نمایش دکمه فلش ثابت', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'swiper-slider-arrows-fixed-',
				'condition' => [ 'navigation' => ['both', 'arrows'] ],
			]
		);
		
		$this->add_control(
			'slides_spaceBetween',
			[
				'label' => __( 'فاصله از هم', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'default' => 15,
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label' => __( 'جهت بندی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'both',
				'options' => [
					'both' => __( 'فلش و دکمه', 'mweb' ),
					'arrows' => __( 'فلش', 'mweb' ),
					'dots' => __( 'دکمه', 'mweb' ),
					'none' => __( 'هیچ', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'پخش خودکار', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label' => __( 'توقف در هاور', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'infinite',
			[
				'label' => __( 'حلقه بی نهایت', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		$this->add_control(
			'overflow',
			[
				'label' => __( 'حذف چهارچوب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'centered_slider',
			[
				'label' => __( 'اسلایدر وسط', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'effect',
			[
				'label' => __( 'افکت اسلایدر', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __( 'هیچ', 'mweb' ),
					'coverflow' => __( 'coverflow', 'mweb' ),
					'cards'     => __( 'cards', 'mweb' ),
					'creative'  => __( 'creative', 'mweb' ),
				]
			]
		);


		$this->end_controls_section();
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
		$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
		
		$data_setting = array();
		
		$data_setting['slidesPerView'] = 1;
		$data_setting['spaceBetween'] = $settings['slides_spaceBetween'];
		$data_setting['watchSlidesVisibility'] = true;
		
		if( $settings['infinite'] == 'yes'){
			$data_setting['loop'] = true;
		}
		if( $settings['autoplay'] == 'yes'){
			$data_setting['autoplay'] = true;
		}
		if( $settings['pause_on_hover'] == 'yes'){
			$data_setting['touchMoveStopPropagation'] = true;
		}
		if( $settings['centered_slider'] == 'yes'){
			$data_setting['centeredSlides'] = true;
		}
		
		if( $settings['effect'] != 'none' ){
			$data_setting['effect'] = $settings['effect'];
			$data_setting['grabCursor'] = true;
			//$data_setting['slidesPerView'] = 'auto';
			if( $settings['effect'] == 'coverflow' )
				$data_setting['coverflowEffect'] = array('rotate' => 30, 'stretch' => 0, 'depth' => 100, 'modifier' => 1, 'slideShadows' => true);
			
			//if( $settings['effect'] == 'cards' )
				//$data_setting['cardsEffect'] = array('slideShadows' => true);
			
			if( $settings['effect'] == 'creative' )
				$data_setting['creativeEffect'] = array('prev' => array('shadow' => true, 'translate' => [0, 0, -400]), 'next' => array('translate' => ["100%", 0, 0]) );
		}
		
		if( $show_dots ){
			$data_setting['pagination'] = array('el' => '.mweb-swiper-pagination','clickable' => true);
		}
		if( $show_arrows ){
			$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next','prevEl' => '.mweb-swiper-prev' );
		}
		
		
		
		$slide_tablet = empty($settings['slides_to_show_tablet']) ? 2 : $settings['slides_to_show_tablet'];
		$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];

		$data_setting['breakpoints'] = array('575' => array('slidesPerView' => $slide_mobile), '768' => array('slidesPerView' => $slide_tablet), '1024' => array('slidesPerView' => $settings['slides_to_show']));
			
		$arrow_ico = 'fa-arrow';	
			
		$attr_class = $settings['show_type'] == 'three' ? 'swiper testimonials_slider' : 'swiper xslider sl_testimonial';
		if( $settings['overflow'] == 'yes' ){
			$attr_class .= ' swiper-wrap-visible';
		}
		
		$this->add_render_attribute( [
			'carousel-wrapper' => [
				'class' => $attr_class,
				'id' => 'sl_'.$this->get_id(),
				'dir' => 'rtl',
				'data-slider' => wp_json_encode($data_setting)
			],
		] );
		
		
		if ( $settings['list'] ) {
			//echo '<div class="mweb-swiper">';
			echo '<div '. $this->get_render_attribute_string( 'carousel-wrapper' ) .'>';
				echo '<div class="swiper-wrapper">';
				
				if( $settings['show_type'] == 'two' ){
						
					foreach (  $settings['list'] as $item ) {
						echo '<div class="swiper-slide">';
							echo '<div class="el_testimonial el_tsl_2 elementor-repeater-item-' . $item['_id'] . '">';
								echo '<div class="el_testimonial_author">';
								echo '<div class="el_testimonial_avatar"><img src="'.esc_url(  $item['el_avatar']['url'] ).'" /></div>';
									echo '<div class="el_testimonial_detail">';
										echo '<div class="el_testimonial_content">'.$item['el_content'].'</div>';
										echo '<h5 class="name">'.$item['el_title'].'</h5>';
										echo '<span>'.$item['el_post'].'</span>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';	
					}
					
				}elseif( $settings['show_type'] == 'three' ){
					
					foreach (  $settings['list'] as $item ) {
						echo '<div class="swiper-slide">';
							echo '<div class="el_testimonial el_tsl_3 elementor-repeater-item-' . $item['_id'] . '">';
								echo '<div class="el_testimonial_content">'.$item['el_content'].'</div>';
								echo '<div class="el_testimonial_author">';
										echo '<h5 class="name">'.$item['el_title'].'</h5>';
										echo '<span>'.$item['el_post'].'</span>';
								echo '</div>';
							echo '</div>';
						echo '</div>';	
					}
				
				}else{
					
					foreach (  $settings['list'] as $item ) {
						echo '<div class="swiper-slide">';
							echo '<div class="el_testimonial el_tsl_1 elementor-repeater-item-' . $item['_id'] . '">';
								echo '<div class="el_testimonial_content">'.$item['el_content'].'</div>';
								echo '<div class="el_testimonial_author">';
									echo '<div class="el_testimonial_avatar"><img src="'.esc_url(  $item['el_avatar']['url'] ).'" /></div>';
									echo '<div class="el_testimonial_detail">';
										echo '<h5 class="name">'.$item['el_title'].'</h5>';
										echo '<span>'.$item['el_post'].'</span>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';	
					}
					
				}
				
			echo '</div>';	
			
				if( !empty($settings['list']) &&  $settings['show_type'] == 'three' ){
					echo '<div class="pagination justify-center ts_pagination">';
						$my_flag = true;
						foreach ( $settings['list'] as $item ) {
							if( $my_flag == true ){
								echo '<div class="pagination__item is_active"><img src="'.esc_url(  $item['el_avatar']['url'] ).'" /></div>';
								$my_flag = false;
								continue;
							}
							echo '<div class="pagination__item"><img src="'.esc_url(  $item['el_avatar']['url'] ).'" /></div>';
							
						}
					echo '</div>';	
				}
			
				if ( $show_dots && $settings['show_type'] != 'three' ) { 
					echo '<div class="mweb-swiper-pagination"></div>';
				} 
				if ( $show_arrows ){
					echo '<div class="mweb-swiper-next"><i class="fal '.$arrow_ico.'-right"></i></div><div class="mweb-swiper-prev"><i class="fal '.$arrow_ico.'-left"></i></div>';
				}			
			echo '</div>';
			//echo '</div>';
		}
		
		
	}

	
	protected function content_template() {
		
	}
}
