<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Search Box
 * @since 1.0.0
 */
class Block_Search extends Widget_Base {

	
	public function get_name() {
		return 'block-search';
	}

	public function get_title() {
		return __( 'جستجو', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-search';
	}

	public function get_categories() {
		return [ 'digiacademy', 'digiacademy_header' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'جستجو', 'mweb' ),
			]
		);
		
		$this->add_control(
			'title_placeholder',
			[
				'label' => __( 'متن نگه دارنده', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => 'کلید واژه مورد نظر ...'
			]
		);


		$this->add_control(
			'type_search',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'elm_one'   => __( 'ثابت', 'mweb' ),
					'elm_two'   => __( 'بازشو', 'mweb' ),
				],
				'default' => 'elm_one',
				'description' => ''
			]
		);

		$this->add_control(
			'el_color',
			[
				'label' => __( 'رنگ پس زمینه جستجو', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} form.elm_search' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} form.search_wrap input' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'type_search' => ['elm_one'] ],
			]
		);
		$this->add_control(
			'el_color_text',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} form.search_wrap input' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'تراز', 'mweb' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'چپ', 'mweb' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'وسط', 'mweb' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'راست', 'mweb' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}}',
				],
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);
		
		$this->add_control(
			'btn_color',
			[
				'label' => __( 'رنگ آیکن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn i' => 'color: {{VALUE}}',
					'{{WRAPPER}} form.search_wrap i.search_icon' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'btn_bg_color',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);
		
		$this->add_control(
			'btn_color_hover',
			[
				'label' => __( 'رنگ آیکن هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elm_search:hover i.search_icon, {{WRAPPER}} .elm_search:focus i.search_icon' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'btn_bg_color_hover',
			[
				'label' => __( 'رنگ پس زمینه هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} form.elm_search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'btn_padding',
			[
				'label' => __( 'فاصله داخلی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} form.elm_search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_margin',
			[
				'label' => __( 'فاصله خارجی', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow',
				'label' => __( 'سایه', 'mweb' ),
				'selector' => '.hs_search_btn',
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow_one',
				'label' => __( 'سایه', 'mweb' ),
				'selector' => 'form.elm_search',
				'condition' => [ 'type_search' => ['elm_one'] ],
			]
		);
	
		$this->add_control(
			'btn_icon_size',
			[
				'label' => __( 'اندازه آیکن', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 19,
				],
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'type_search' => ['elm_two'] ],
			]
		);
		
		$this->add_responsive_control(
			'btn_height',
			[
				'label' => __( 'ارتفاع', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 38,
				],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} form.search_wrap' => 'height: {{SIZE}}{{UNIT}}',
				
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_lineheight',
			[
				'label' => __( 'ارتفاع خط', 'mweb' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 39,
				],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .hs_search_btn' => 'line-height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} form.elm_search' => 'line-height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} form.search_wrap i.search_icon' => 'line-height: {{SIZE}}{{UNIT}}',
				
				]
			]
		);
		
		$this->add_control(
			'font_family',
			[
				'label' => __( 'خانواده فونت', 'mweb' ),
				'type' => Controls_Manager::FONT,
				'selectors' => [
					'{{WRAPPER}} .search_wrap' => 'font-family: {{VALUE}}',
					'{{WRAPPER}} form.search_wrap input' => 'font-family: {{VALUE}}',
					'{{WRAPPER}} .post_with_thumb .inner a' => 'font-family: {{VALUE}}',
				],
			]
		);
	

		$this->end_controls_section();
	
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * @access protected
	 */
	protected function render() {
		
		$settings = $this->get_settings_for_display();
		if($settings['type_search'] == 'elm_one'): 		
			echo mweb_render_search_form('elm_search', $settings['title_placeholder']);
		 else: ?>
			<div class="hs_icon hs_search_btn"><i class="fal fa-search"></i></div>
			<div class="search_overlay">
				<div class="search_toggle"><i class="fal fa-times"></i></div>
				<?php echo mweb_render_search_form('', $settings['title_placeholder']); ?>
			</div>
		<?php endif; 
		
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * @access protected
	 */
	protected function content_template() {
		
	}
}
