<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Featured Square
 * @since 1.0.0
 */
class Block_Featured_Square extends Widget_Base {

	
	public function get_name() {
		return 'block-featured-square';
	}

	
	public function get_title() {
		return __( 'آیکن همراه با عنوان', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-call-to-action';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'el_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'el_icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fal fa-box-open',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		$this->add_control(
			'el_int',
			[
				'label' => __( 'درج عدد', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'description' => 'اختیاری'
			]
		);
		$this->add_control(
			'el_style',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'align_rq',
				'options' => [
					'align_sq'  => __( 'مربع', 'mweb' ),
					'align_rq' => __( 'مستطیل افقی', 'mweb' ),
					'box_special' => __( 'متفاوت', 'mweb' )
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان', 'mweb' ),
				'selector' => '.mweb-body {{WRAPPER}} h4',
			]
		);
		
		$this->add_control(
			'el_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_rqs_inner' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'el_background',
			[
				'label' => __( 'تصویر پس زمینه', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_group_control(
			'background',
			[
				'name' => 'el_background_overlay',
				'label' => __( 'رنگ پوشش', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .el_featured_rqs_inner:before ,{{WRAPPER}} .el_loz_desc:before'
			]
		);
		
		$this->add_control(
			'el_link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_show',
			[
				'label' => __( 'استایل', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'item_border_radius',
			[
				'label' => __( 'گوشه های مدور', 'mweb' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .el_featured_rqs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .el_loz_desc' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .el_loz_desc:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .el_featured_rqs',
			]
		);
		
		$this->end_controls_section();
		
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$el_int = !empty($settings['el_int']) ? '<span class="count">'.$settings['el_int'].'</span>' : '';
		$el_background = !empty($settings['el_background']['url']) ? ' style="background-image:url('.$settings['el_background']['url'].')"' : '';
		$el_type = isset($settings['el_style']) ? $settings['el_style'] : '' ;
		
		if($el_type == 'box_special'){
			echo '<div class="el_featured_loz">';	
				if(!empty($settings['el_link']['url'])){
					$target = $settings['el_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $settings['el_link']['nofollow'] ? ' rel="nofollow"' : '';
					echo '<a href="' . esc_url( $settings['el_link']['url'] ) . '" title="' . esc_attr( $settings['el_title'] ) . '" ' . $target . $nofollow . '>';
				}
				if($settings['el_icon']){
					echo '<div class="el_loz_img"><i class="'.$settings['el_icon'].'"></i></div>';
				}
				echo '<div class="el_loz_desc"'.$el_background.'>';
					echo '<h4>'.$settings['el_title'].'</h4>'.$el_int;
				echo '</div>';	
				
				if(!empty($settings['el_link']['url'])){
					echo '</a>';
				}
			echo '</div>';
		}else{
			echo '<div class="el_featured_rqs '.$settings['el_style'].'"'.$el_background.'>';	
				if(!empty($settings['el_link']['url'])){
					$target = $settings['el_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $settings['el_link']['nofollow'] ? ' rel="nofollow"' : '';
					echo '<a href="' . esc_url( $settings['el_link']['url'] ) . '" title="' . esc_attr( $settings['el_title'] ) . '" ' . $target . $nofollow . '>';
				}
				echo '<div class="el_featured_rqs_inner">'.$el_int;
					if($settings['el_icon']){
						echo '<i class="'.$settings['el_icon'].'"></i>';	
					}
					echo '<h4>'.$settings['el_title'].'</h4>';
				echo '</div>';	
				
				if(!empty($settings['el_link']['url'])){
					echo '</a>';
				}
			echo '</div>';
		}
			
				
	}

	
	protected function content_template() {
		
	}
}
