<?php

// insert the your code here

// Remove Price Range
add_action('wp_dashboard_setup', 'wpdocs_remove_dashboard_widgets',999999999999999);

/**
 * Remove all dashboard widgets
 */
function wpdocs_remove_dashboard_widgets(){
	remove_meta_box('widget_freelanceswitch', 'dashboard', 'normal');   // Right Now
}

function mweb_disable_gutenberg($is_enabled, $post_type) {
	
	if ($post_type === 'page') return false; 
	
	return $is_enabled;
	
}
add_filter('use_block_editor_for_post_type', 'mweb_disable_gutenberg', 10, 2);


function _remove_script_version( $src ){
    $parts = explode( '?ver', $src );
    return $parts[0];
}
add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );

remove_action( 'set_comment_cookies', 'wp_set_comment_cookies' );





add_filter( 'woocommerce_variable_sale_price_html', 'mweb_variable_product_price_total', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'mweb_variable_product_price_total', 10, 2 );

function mweb_variable_product_price_total( $price, $product ) {
	
	$variation_single = get_post_meta( $product->get_id(), '_variation_single', true ); 
	if( $variation_single == 'yes' && !is_admin()){
		$total_price = 0;
		
		foreach ( $product->get_children() as $child_id ) {
			$variation = wc_get_product( $child_id );
			$total_price += (int) $variation->get_price();
		}
		
		$price = wc_price( $total_price, $product );
	}
	
	return $price;
	
}
