<?php

 /**
 * Custom Post Type Registration 
 */
 
if ( ! class_exists( 'mweb_post_type' ) ) {
	class mweb_post_type{
		function __construct(){
			
			//add_action( 'init', array($this,'mweb_post_type_brand') );
			add_action('init', array( $this,'mweb_post_type_teacher' ) );
			//add_action('init', array( $this,'mweb_teacher_taxonomy') );
			add_action( 'init', array( $this, 'mweb_post_type_slider' ) );
			add_action( 'init', array( $this, 'mweb_slider_taxonomy' ) );
			add_action( 'init', array( $this, 'mweb_post_type_notify' ) );
			add_action( 'init', array( $this, 'mweb_notify_taxonomy' ) );
			add_action( 'init', array( $this, 'mweb_post_type_megamenu' ) );
			
			add_action( 'admin_menu', array( $this, 'add_menu_admin' ) );
			
		}
		
		static function add_menu_admin(){
			add_submenu_page( 'themes.php', esc_html__( 'مگامنو', 'mweb' ), esc_html__( 'مگامنو', 'mweb' ), 'manage_options', 'edit.php?post_type=mweb_megamenu');
		}
		
		
		
		
		
		static function mweb_post_type_teacher(){
			$labels = array(
				'name' => __( 'مدرسین', 'mweb' ),
				'singular_name' => __( 'مدرس', 'mweb' ),
				'add_new' => __( 'افزودن مدرس جدید', 'mweb' ),
				'add_new_item' => __( 'افزودن مدرس جدید', 'mweb' ),
				'edit_item' => __( 'ویرایش مدرس', 'mweb' ),
				'new_item' => __( 'مدرس جدید', 'mweb' ),
				'view_item' => __( 'نمایش مدرس', 'mweb' ),
				'search_items' => __( 'جستجو مدرس', 'mweb' ),
				'not_found' => __( 'مدرسی پیدا نشد', 'mweb' ),
				'not_found_in_trash' => __( 'مدرسی در سطل زباله پیدا نشد', 'mweb' ),
				'parent_item_colon' => __( 'مدرس والد:', 'mweb' ),
				'menu_name' => __( 'مدرسین', 'mweb' ),
			);
			
			$args = array(
				'labels'             => $labels,
				'public'             => true,
				'publicly_queryable' => true,
				'show_in_menu'       => true,
				'show_in_admin_bar'  => true,
				'can_export'         => true,
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => 20,		
				'menu_icon'          => 'dashicons-businessman',
				'supports'           => array( 'title', 'thumbnail', 'editor', 'page-attributes' ),
				'show_ui'            => true,
				'exclude_from_search' => false,
				//'capability_type'    => 'page',
				//'rewrite'			 => array( 'slug' => 'teachers' ),
				'capability_type' => 'post',
				'rewrite' => array('slug' => 'teacher'),
			);
			
			register_post_type( 'teacher', $args );
	
		}  	
		
		
		
		static function mweb_teacher_taxonomy() {	
			register_taxonomy(
				'teacher-category',
				'teacher',
				array(
					'label' => esc_html__( 'دسته بندی مدرس','mweb'),			
					'hierarchical' => true,
					'show_admin_column' => true,	
					'show_ui'		=> true,
					'query_var' 	=> true,
					'rewrite'		=> true,
				)
			);
		}


		
		static function mweb_post_type_slider() {
	 
			$labels = array(
				'name' => _x('اسلایدر', 'mweb'),
				'singular_name' => _x('اسلایدر', 'mweb'),
				'add_new' => _x('اضافه کردن', 'mweb'),
				'add_new_item' => __('افزود اسلاید جدید'),
				'edit_item' => __('ویرایش اسلاید'),
				'new_item' => __('اسلاید جدید'),
				'view_item' => __('مشاهده اسلاید'),
				'search_items' => __('جستجوی اسلاید'),
				'not_found' =>  __('اسلایدی یافت نشد'),
				'not_found_in_trash' => __('اسلایدی در سطل زباله یافت نشد'),
				'parent_item_colon' => '',
			);
			 
			$args = array(
				'label' => __('اسلاید'),
				'labels' => $labels,
				'public' => true,
				'can_export' => true,
				'show_ui' => true,
				'_builtin' => false,
				'capability_type' => 'post',
				'menu_icon' => 'dashicons-image-flip-horizontal',
				'hierarchical' => false,
				//'rewrite' => array( "slug" => "slider" ),
				'supports'=> array('title', 'thumbnail') ,
				'show_in_nav_menus' => true,
				// This is where we add taxonomies to our CPT
				//'taxonomies'          => array( 'slider_category' ),
			);
			 
			register_post_type( 'slider', $args);
		 
		}
		
		
		
		static function mweb_slider_taxonomy() {

			$labels = array(
				'name'                       => _x( 'دسته بندی', 'Taxonomy General Name'),
				'singular_name'              => _x( 'دسته', 'Taxonomy Singular Name'),
				'menu_name'                  => __( 'دسته ها'),
				'all_items'                  => __( 'همه دسته ها'),
				'parent_item'                => __( 'والد'),
				'parent_item_colon'          => __( 'دسته والد:'),
				'new_item_name'              => __( 'دسته جدید'),
				'add_new_item'               => __( 'افزودن دسته جدید'),
				'edit_item'                  => __( 'ویرایش دسته'),
				'update_item'                => __( 'آپدیت دسته'),
				'view_item'                  => __( 'مشاهده دسته'),
				//'separate_items_with_commas' => __( 'Separate items with commas'),
				//'add_or_remove_items'        => __( 'Add or remove items'),
				//'choose_from_most_used'      => __( 'Choose from the most used'),
				//'popular_items'              => __( 'Popular Items'),
				'search_items'               => __( 'جستجو دسته'),
				'not_found'                  => __( 'پیدا نشد'),
				'no_terms'                   => __( 'دسته بندی ای وجود ندارد'),
				'items_list'                 => __( 'لیست دسته ها'),
				//'items_list_navigation'      => __( 'Items list navigation'),
			);
			$args = array(
				'hierarchical' 	=> true,
				'labels' 		=> $labels,
				'show_ui'		=> true,
				'query_var' 	=> true,
				'show_admin_column' => true,
				'rewrite'		=> array( 'slug' => 'slider-category' ),

			);
			register_taxonomy( 'slider_category', array( 'slider' ), $args );

		}
		
		
		
		
		
		/* ----------------------- Notify Post Type ---------------------------- */
		static function mweb_post_type_notify() {
	 
			$labels = array(
				'name' => _x('اطلاعیه', 'mweb'),
				'singular_name' => _x('اطلاعیه', 'mweb'),
				'add_new' => _x('اضافه کردن', 'mweb'),
				'add_new_item' => __('افزود اطلاعیه جدید'),
				'edit_item' => __('ویرایش اطلاعیه'),
				'new_item' => __('اسلاید اطلاعیه'),
				'view_item' => __('مشاهده اطلاعیه'),
				'search_items' => __('جستجوی اطلاعیه'),
				'not_found' =>  __('اطلاعیه ای یافت نشد'),
				'not_found_in_trash' => __('اطلاعیه ای در سطل زباله یافت نشد'),
				'parent_item_colon' => '',
			);
			 
			$args = array(
				'label' => __('اطلاعیه'),
				'labels' => $labels,
				'public' => false,
				//'can_export' => true,
				'show_ui' => true,
				'_builtin' => false,
				'capability_type' => 'post',
				'menu_icon' => 'dashicons-media-default',
				'hierarchical' => false,
				//'rewrite' => array( "slug" => "slider" ),
				'supports'=> array('title', 'editor') ,
				'show_in_nav_menus' => true,
				// This is where we add taxonomies to our CPT
				//'taxonomies'          => array( 'slider_category' ),
			);
			 
			register_post_type( 'notify', $args);
		 
		}
		
		
		
		static function mweb_notify_taxonomy() {

			$labels = array(
				'name'                       => _x( 'دسته بندی', 'Taxonomy General Name'),
				'singular_name'              => _x( 'دسته', 'Taxonomy Singular Name'),
				'menu_name'                  => __( 'دسته ها'),
				'all_items'                  => __( 'همه دسته ها'),
				'parent_item'                => __( 'والد'),
				'parent_item_colon'          => __( 'دسته والد:'),
				'new_item_name'              => __( 'دسته جدید'),
				'add_new_item'               => __( 'افزودن دسته جدید'),
				'edit_item'                  => __( 'ویرایش دسته'),
				'update_item'                => __( 'آپدیت دسته'),
				'view_item'                  => __( 'مشاهده دسته'),
				//'separate_items_with_commas' => __( 'Separate items with commas'),
				//'add_or_remove_items'        => __( 'Add or remove items'),
				//'choose_from_most_used'      => __( 'Choose from the most used'),
				//'popular_items'              => __( 'Popular Items'),
				'search_items'               => __( 'جستجو دسته'),
				'not_found'                  => __( 'پیدا نشد'),
				'no_terms'                   => __( 'دسته بندی ای وجود ندارد'),
				'items_list'                 => __( 'لیست دسته ها'),
				//'items_list_navigation'      => __( 'Items list navigation'),
			);
			$args = array(
				'hierarchical' 		=> true,
				'labels' 			=> $labels,
				'public'			=> false,
				'show_ui'			=> true,
				'query_var' 		=> true,
				'show_admin_column' => true,
				'default_term'		=> 'همه',
				'rewrite' 			=> array( 'slug' => 'notify-category' ),

			);
			register_taxonomy( 'notify_category', array( 'notify' ), $args );

		}
		
		
		static function mweb_post_type_megamenu() {

			$args = array(
				'labels' => array(
					'name' => __( 'مگامنو','mweb' ),
					'singular_name' => __( 'مگامنو','mweb' )
				),
				'public' => true,
				'has_archive' => true,
				'rewrite' => array('slug' => 'megamenus'),
				'menu_position' => 8,
				'show_in_menu' => false,
			);
			 
			register_post_type( 'mweb_megamenu', $args);
		 
		}
		
		

	}
	 new mweb_post_type();

}
	 
	 

