<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // No direct access allowed
final class mweb_theme_active {
    private static $RTL_THEME_SLUG = 'mwebdgacademywp'; // Product name
    private static $WEOWPS_RTL_OIEKS = 'd0a7e7997b6d5fcd55f4b5c32611b81';
    private static $RTL_OAUTH_PID = 121903; // Product ID
    private static $RTL_OAUTH_API = 'rtl4c12e462a43dfe8e80c6fbf2378c9a'; // API
    private static $RTL_OPTIONS_NAME = 'wp_access_options'; // {Product_name}_rtl_license_options
    private static $RTL_SECURE_ACTIVE = 'rtl4c12e462a43dfe8e80c6fbf2378c9amwebdgacademywpworkesactive'; // {API}_{Product_name}_workesactive
    private static $instance = null;
    private static $hash_method = 'AES-256-CBC';
    private $hash_key;

    public static function get_instance() {
        if ( self::$instance == null ) {
            self::$instance = new mweb_theme_active();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->hash_key = hash('sha256', 'd0a7e7997b6d5fcd55f4b5c32611b81');
		
        add_action('admin_menu', array($this, 'rtl_oauth_license_options'));

        if(@$_GET['page'] !== 'activator' && @$_GET['page'] !== 'deactivator') {
            add_action( 'admin_notices', array($this, 'sample_admin_notice__success') );
        }
       
    }
    public function mc_encrypt($encrypt, $key){
        $encrypt = serialize($encrypt);
        $iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC), MCRYPT_DEV_URANDOM);
        $key = pack('H*', $key);
        $mac = hash_hmac('sha256', $encrypt, substr(bin2hex($key), -32));
        $passcrypt = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $encrypt.$mac, MCRYPT_MODE_CBC, $iv);
        $encoded = base64_encode($passcrypt).'|'.base64_encode($iv);
        return $encoded;
    }
    public function mc_decrypt($decrypt, $key){
        $decrypt = explode('|', $decrypt.'|');
        $decoded = base64_decode($decrypt[0]);
        $iv = base64_decode($decrypt[1]);
        if(strlen($iv)!==mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC)){ return false; }
        $key = pack('H*', $key);
        $decrypted = trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $decoded, MCRYPT_MODE_CBC, $iv));
        $mac = substr($decrypted, -64);
        $decrypted = substr($decrypted, 0, -64);
        $calcmac = hash_hmac('sha256', $decrypted, substr(bin2hex($key), -32));
        if($calcmac!==$mac){ return false; }
        $decrypted = unserialize($decrypted);
        return $decrypted;
    }


    public function encrypt($data, $key, $method)
    {
        $ivSize = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($ivSize);

        $encrypted = openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv);

        // For storage/transmission, we simply concatenate the IV and cipher text
        $encrypted = base64_encode($iv . $encrypted);

        return $encrypted;
    }

    public function decrypt($data, $key, $method)
    {
        $data = base64_decode($data);
        $ivSize = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivSize);
        $data = openssl_decrypt(substr($data, $ivSize), $method, $key, OPENSSL_RAW_DATA, $iv);

        return $data;
    }





    public function rtloauthsend($api,$username,$order_id,$domain,$secret_key,$pid) {
        $url = 'http://www.rtl-theme.com/oauth/';
        $pid = $pid;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$url);
        if($pid == 'newproduct') {
            curl_setopt($ch,CURLOPT_POSTFIELDS,"api=$api&username=$username&order_id=$order_id&domain=$domain&secretkey=$secret_key");
        } else {
            curl_setopt($ch,CURLOPT_POSTFIELDS,"api=$api&username=$username&order_id=$order_id&domain=$domain&secretkey=$secret_key&pid=$pid");
        }
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }


    public function rtl_oauth_license_options() {
        add_theme_page('فعال سازی قالب', 'فعال سازی قالب', 'administrator', 'activator', array($this, 'rtl_oauth_license_settings_page')  );
    }
    public function rtl_oauth_license_settings_page() {
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        ?>
        <style>
            #wpwrap {
            }
            .rtl_logo {
                margin:  1em auto;
                position: absolute;
                top: 16%;
                left: 50px;
                width: 100%;
                max-width: 300px;
                text-align: center;
                border: 1px dashed #ddd;
                border-radius: 7px;
                padding: 10px;
                background: #fff;

            }
            .rtl_logo img {
                
                width: 170px;
                height: auto;
            }
            .rtl_logo a {
                text-decoration: none;
                text-transform: uppercase;
                color: #999;
            }
            @media only screen and (max-width: 1030px) {
                .rtl_logo {
                    position: static;
                }
            }
            #adminmenuback {
                display: none;
            }
			.send_post:before , .send_post:after{
				content:"";
				display:block;
				clear:both
			}
        </style>
        <div class="wrap">
        <h1>فعال سازی قالب</h1>
        <?php
        $error = 0;
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $variable = get_option(static::$RTL_OPTIONS_NAME);
            if (!empty($variable)) {
              delete_option(static::$RTL_OPTIONS_NAME);
            }
            $username = trim(@$_POST[static::$RTL_THEME_SLUG.'_rtl_username']);
            $order_id = trim(@$_POST[static::$RTL_THEME_SLUG.'_rtl_orderid']);
            $domain = trim(esc_attr( site_url() ));
            $deactivate_key = 'rtlsecrectkey'.substr( md5( uniqid( current_time('timestamp',0) ) ), 0, 20);
            $result = $this->rtloauthsend(static::$RTL_OAUTH_API,$username,$order_id,$domain,$deactivate_key,static::$RTL_OAUTH_PID);
            if($result > 0 && is_numeric($result)){
                $variable = array(

                    static::$RTL_THEME_SLUG.'_rtl_api' => $this->encrypt(static::$RTL_OAUTH_API, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_domain' => $this->encrypt($domain, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_orderid' => $this->encrypt($order_id, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_username' => $this->encrypt($username, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_secretkey' => $this->encrypt($deactivate_key, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_status' => $this->encrypt(static::$RTL_SECURE_ACTIVE, $this->hash_key, static::$hash_method)
                );
                $update = update_option(static::$RTL_OPTIONS_NAME, $variable);

                    echo '
                    <div class="notice notice-success is-dismissible">
                        <p>محصول با موفقیت فعال گردید.</p>
                    </div>
                    <div class="notice notice-error is-dismissible">
                        <p>لطفاً لینک غیرفعال سازی را در جای امنی نگه داری نمایید.</p>
                    </div>
                    <h2>برای غیر فعال کردن محصول در این دامنه از لینک زیر استفاده نمایید:</h2>
                    <table class="form-table">
                        <tr valign="top">
                            <td>
                                <input type="text" value="'.esc_attr( site_url() ).'/wp-admin/admin.php?page=deactivator&tokenkey='.$deactivate_key.'" style="width: 500px; direction:ltr" class="deactivatelink" readonly />
                                <button class="js-deactivatelinkcopybtn button button-primary" style="vertical-align: initial;">کپی لینک</button>
                            </td>
                        </tr>
                        <tr valign="top">
                            <td>
                                <a href="'.esc_attr( site_url() ).'/wp-admin/" class="button button-secondery">خروج از این برگه</a>
                            </td>
                        </tr>
                    </table>
                    <script type="text/javascript">
                        var copyTextareaBtn = document.querySelector(\'.js-deactivatelinkcopybtn\');

                        copyTextareaBtn.addEventListener(\'click\', function(event) {
                          var copyTextarea = document.querySelector(\'.deactivatelink\');
                          copyTextarea.select();

                          try {
                            var successful = document.execCommand(\'copy\');
                            var msg = successful ? \'successful\' : \'unsuccessful\';
                            //console.log(\'Copying text command was \' + msg);
                          } catch (err) {
                            //console.log(\'Oops, unable to copy\');
                          }
                        });
                    </script>';
					
					$my_mail = esc_attr( get_option( 'admin_email' ) );
					if(!empty($my_mail)){
							$to = $my_mail;
							$subject = 'لینک غیر فعال سازی محصول';
							$body = esc_attr( get_option( 'home' ) ) . '/wp-admin/themes.php?page=deactivator&tokenkey='.$deactivate_key;
							$headers = array('Content-Type: text/html; charset=UTF-8');
							 
							wp_mail( $to, $subject, $body, $headers );
					}

                    $error = -1;

            } else {
                if($result == '-1') {
                    $error = 1;
                    $error_msg = "کد API اشتباه است.";
                }
                if($result == '-2') {
                    $error = 1;
                    $error_msg = "نام کاربری اشتباه است.";
                }
                if($result == '-3') {
                    $error = 1;
                    $error_msg = "کد سفارش اشتباه است.";
                }
                if($result == '-4') {
                    $error = 1;
                    $error_msg = "کد سفارش قبلاً ثبت شده است.";
                }
                if($result == '-5') {
                    $error = 1;
                    $error_msg = "کد سفارش مربوط به این نام کاربری نمیباشد.";
                }
            }
        }
        if($error != -1) :
            if($error == 1) {
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo $error_msg; ?></p>
                </div>
                <?php
            }
            ?>
            <form method="post" class="send_post">
                <table class="form-table">
                    <tr valign="top">
                    <th scope="row">نام کاربری</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_username" value="<?php echo @$_POST[static::$RTL_THEME_SLUG.'_rtl_username']; ?>" /></td>
                    </tr>
                     
                    <tr valign="top">
                    <th scope="row">کد سفارش</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_orderid" value="<?php echo @$_POST[static::$RTL_THEME_SLUG.'_rtl_orderid']; ?>" /></td>
                    </tr>
                    
                    <tr valign="top">
                    <th scope="row">دامنه</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_domain" value="<?php echo esc_attr( site_url() ); ?>" disabled /></td>
                    </tr>
					
					<tr valign="top">
					<th scope="row">ایمیل</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_email" value="<?php echo esc_attr( get_option( 'admin_email' ) ); ?>" disabled /></td>
					</tr>
                </table>
                
                <?php submit_button('فعال‌سازی محصول'); ?>

            </form>

            <div class="rtl_logo">
				<img src="#" alt="گروه توسعه و طراحی  ماهدیس وب">
				<h3>راهنما</h3>
				<p>برای فعال سازی محصول کافیست <strong>نام کاربری</strong> و <strong>کد سفارش</strong> خود در <a href="http://www.rtl-theme.com" target="_blank">راست چین</a> را در فرم بالا وارد کرده و روی دکمه <strong>فعال‌سازی محصول</strong> کلیک کنید.</p>
				<p style="color:red">پوسته را بر روی دامنه اصلی فعال سازی نمایید</p>
				
				<p style="color:green">فیلد ایمیل به منظور ارسال لینک غیر فعال سازی محصول است.</p>

				<a href="#" target="_blank">توضیحات بیشتر</a>
			</div>
			</div>

            <?php
        endif;
        echo '</div>';
    }

    public function sample_admin_notice__success() {
        echo '<div class="notice notice-error"><p>محصول شما فعال نشده است، برای فعال سازی <a href="';
		echo esc_attr( get_option( 'home' ) );
		echo '/wp-admin/themes.php?page=activator">اینجا</a> کلیک کنید.</p></div>';
    }


    
}
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // No direct access allowed




final class mweb_theme_deactive {
    private static $RTL_THEME_SLUG = 'mwebdgacademywp'; // Product name
    private static $WEOWPS_RTL_OIEKS = 'd0a7e7997b6d5fcd55f4b5c32611b81';
    private static $RTL_OAUTH_PID = 121903; // Product ID
    private static $RTL_OAUTH_API = 'rtl4c12e462a43dfe8e80c6fbf2378c9a'; // API
    private static $RTL_OPTIONS_NAME = 'wp_access_options'; // {Product_name}_rtl_license_options
    private static $RTL_SECURE_ACTIVE = 'rtl4c12e462a43dfe8e80c6fbf2378c9amwebdgacademywpworkesactive'; // {API}_{Product_name}_workesactive
    private static $instance = null;
    private static $hash_method = 'AES-256-CBC';
    private $hash_key;
	
    public static function get_instance() {
        if ( self::$instance == null ) {
            self::$instance = new mweb_theme_deactive();
        }
        return self::$instance;
    }

    private function __construct() {

		$this->hash_key = hash('sha256', 'd0a7e7997b6d5fcd55f4b5c32611b81');
		
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        if(static::$RTL_SECURE_ACTIVE == $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_status'], 	$this->hash_key, static::$hash_method)) {
            add_action('admin_menu', array($this, 'rtl_oauth_license_deactivator'));
        }

      
        
    }
    
	public function mc_encrypt($encrypt, $key){
        $encrypt = serialize($encrypt);
        $iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC), MCRYPT_DEV_URANDOM);
        $key = pack('H*', $key);
        $mac = hash_hmac('sha256', $encrypt, substr(bin2hex($key), -32));
        $passcrypt = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $encrypt.$mac, MCRYPT_MODE_CBC, $iv);
        $encoded = base64_encode($passcrypt).'|'.base64_encode($iv);
        return $encoded;
    }
    public function mc_decrypt($decrypt, $key){
        $decrypt = explode('|', $decrypt.'|');
        $decoded = base64_decode($decrypt[0]);
        $iv = base64_decode($decrypt[1]);
        if(strlen($iv)!==mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC)){ return false; }
        $key = pack('H*', $key);
        $decrypted = trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $decoded, MCRYPT_MODE_CBC, $iv));
        $mac = substr($decrypted, -64);
        $decrypted = substr($decrypted, 0, -64);
        $calcmac = hash_hmac('sha256', $decrypted, substr(bin2hex($key), -32));
        if($calcmac!==$mac){ return false; }
        $decrypted = unserialize($decrypted);
        return $decrypted;
    }

	public function encrypt($data, $key, $method)
    {
        $ivSize = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($ivSize);

        $encrypted = openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv);

        // For storage/transmission, we simply concatenate the IV and cipher text
        $encrypted = base64_encode($iv . $encrypted);

        return $encrypted;
    }

    public function decrypt($data, $key, $method)
    {
        $data = base64_decode($data);
        $ivSize = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivSize);
        $data = openssl_decrypt(substr($data, $ivSize), $method, $key, OPENSSL_RAW_DATA, $iv);

        return $data;
    }

    public function rtloauthcheck() {
        $rtloauthcheckdomain = true;
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        if(isset($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_domain'])) {
			$my_domain = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_domain'], $this->hash_key, static::$hash_method);
            if(trim(esc_attr( site_url() )) !== $my_domain ) {
				
				$site_url = str_replace(array('http://','https://'), '', site_url());
				$my_domain = str_replace(array('http://','https://'), '', $my_domain);
				if($site_url == $my_domain){
					$rtloauthcheckdomain = true;
				}else{
					$variable = get_option(static::$RTL_OPTIONS_NAME);

					$status = array(
						static::$RTL_THEME_SLUG.'_rtl_status' => $this->encrypt('rtlthemeworkesdeactive', $this->hash_key, static::$hash_method)
					);

					$options = array_merge($variable, $status);
					update_option(static::$RTL_OPTIONS_NAME, $options);

					$rtloauthcheckdomain = false;
				}
                
            }
        } else {
            $rtloauthcheckdomain = false;
        }

		$allowed_hosts = array('localhost','127.0.0.1' ,'demos.mahdisweb.net','mahdisweb.net');
		if (isset($_SERVER['HTTP_HOST']) && in_array($_SERVER['HTTP_HOST'], $allowed_hosts)) {
				$rtloauthcheckdomain = true;
				add_action( 'admin_notices', array($this, 'mweb_admin_notice__local') );
			}	

        if($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_status'] == $this->encrypt(static::$RTL_SECURE_ACTIVE, $this->hash_key, static::$hash_method) || $rtloauthcheckdomain !== false) {
            return true;
        }
        else
        {
            return false;
        }
    }
    public function rtloauthdeactivesend($secret_key,$username,$orderid) {
        $url = 'http://www.rtl-theme.com/oauth/deactive/';
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"secretkey=$secret_key&username=$username&orderid=$orderid");
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
    public function rtl_oauth_license_deactivator() {
        //add_menu_page('فعال سازی قالب', 'فعالی سازی قالب', 'administrator', 'activator', 'rtl_oauth_license_deactivator_page' , 'dashicons-unlock', 3 );
        add_submenu_page('admin.php', 'غیرفعال سازی محصول', 'غیرفعال سازی محصول', 'administrator', 'deactivator', array($this, 'rtl_oauth_license_deactivator_page'));
    }

    public function rtl_oauth_license_deactivator_page() {
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        ?>
         <style>
            .rtl_logo{margin:1em auto;position:absolute;top:50px;left:50px;width:100%;max-width:300px;text-align:center;border:1px dashed #ddd;border-radius:7px;padding:10px;background:#fff}.rtl_logo img{width:80px;height:auto}.rtl_logo a{text-decoration:none;text-transform:uppercase;color:#999}@media only screen and (max-width: 1030px){.rtl_logo{position:static}}.modal{display:none;position:fixed;z-index:99999;right:0;top:0;width:100%;height:100%;overflow:auto;background-color:#000;background-color:rgba(0,0,0,0.4);-webkit-animation-name:fadeIn;-webkit-animation-duration:.4s;animation-name:fadeIn;animation-duration:.4s}.modal-content{position:fixed;top:0;background-color:#fefefe;width:100%;-webkit-animation-name:slideIn;-webkit-animation-duration:.4s;animation-name:slideIn;animation-duration:.4s;max-width:500px;right:50%;margin-right:-250px}.close{color:#fff;float:left;font-size:28px;font-weight:700;line-height:2}.close:hover,.close:focus{color:#000;text-decoration:none;cursor:pointer}.modal-header{padding:2px 16px;background-color:#5cb85c;color:#fff}.modal-header h2{color:#fff}.modal-body{padding:2px 16px}.modal-footer{padding:2px 16px;background-color:#5cb85c;color:#fff}.modal-footer h3{color:#fff;display:inline-block}@-webkit-keyframes slideIn{from{top:-300px;opacity:0}to{top:0;opacity:1}}@keyframes slideIn{from{top:-300px;opacity:0}to{top:0;opacity:1}}@-webkit-keyframes fadeIn{from{opacity:0}to{opacity:1}}@keyframes fadeIn{from{opacity:0}to{opacity:1}}@-webkit-keyframes fadeOut{from{opacity:1}to{opacity:0}}@keyframes fadeOut{from{opacity:1}to{opacity:0}}
        </style>
        <div class="wrap">
            <h1>غیرفعال سازی محصول</h1>

            <?php
            if(isset($_GET['tokenkey'])) {
                if($_GET['tokenkey'] == $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_secretkey"], $this->hash_key, static::$hash_method)) {
                    if(isset($_GET['runit'])) {
                        if($_GET['runit'] == 'yes') {
                            $secret_key = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_secretkey"], $this->hash_key, static::$hash_method);
                            $username = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_username"], $this->hash_key, static::$hash_method);
                            $orderid = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_orderid"], $this->hash_key, static::$hash_method);
                            $result = $this->rtloauthdeactivesend($secret_key,$username,$orderid);
                            if($result > 0 && is_numeric($result)){
                                delete_option(static::$RTL_OPTIONS_NAME);
                                echo 'غیر فعال سازی با موفقیت انجام شد.';
                            } else {

                                
                                if($result == '-1') {
                                    die('متاسفانه در غیرفعال سازی محصول خطایی رخ داده است.');
                                }
                                if($result == '-2') {
                                    die('کلید غیرفعال سازی اشتباه است.');
                                }
                                if($result == '-3' || $result == '0') {
                                    die('منظور؟');
                                }
                            }
                        }
                        else {
                            die('خطایی رخ داده است!');
                        }
                    }
                    else
                    {
                    ?>

                        <br><br>
                        <ul>
                            <li>• غیرفعال سازی محصول به شما کمک میکند تا این محصول را در سایت دیگری فعال نمایید.</li>
                            <li>• طبیعی است که وب سایت فعلی شما بعد از غیرفعال سازی عملکرد درستی نخواهد داشت.</li>
                            <li>• تعداد دفعات فعال سازی محصول برای یک دامنه محدود می باشد. (لطفاً از غیرفعال کردن محصول مطمئن باشید، سپس اقدام کنید.)</li>
                        </ul>
                        <br>
                        <button id="myBtn" class="button button-primary">غیر فعال سازی محصول</button>

                        <div id="myModal" class="modal">

                          <!-- Modal content -->
                          <div class="modal-content">
                            <div class="modal-header">
                              <span class="close">&times;</span>
                              <h2>غیرفعال سازی محصول</h2>
                            </div>
                            <div class="modal-body">
                              <p>غیرفعال سازی محصول به شما کمک میکند تا این محصول را در سایت دیگری فعال نمایید.</p>
                              <p>طبیعی است که وب سایت فعلی شما بعد از غیرفعال سازی عملکرد درستی نخواهد داشت.</p>
                              <p>تعداد دفعات فعال سازی محصول برای یک دامنه محدود می باشد. (لطفاً از غیرفعال کردن محصول مطمئن باشید، سپس اقدام کنید.)</p>
                            </div>
                            <div class="modal-footer">
                              <h3>آیا این مورد را تایید مینمایید؟ </h3>
                              <div class="pull-left" style="margin-top: 10px;">
                                <a href="<?php echo esc_attr( site_url() ).'/wp-admin/admin.php?page=deactivator&tokenkey='.$_GET['tokenkey']; ?>&runit=yes" class="button button-primary">بله</a> <span class="notok button button-secondery" id="notok">خیر</span>
                              </div>
                            </div>
                          </div>

                        </div>

                        <script>
                            var modal = document.getElementById('myModal');
                            var btn = document.getElementById("myBtn");
                            var span = document.getElementsByClassName("close")[0];
                            var notok = document.getElementsByClassName("notok")[0];
                            btn.onclick = function() {
                                modal.style.display = "block";
                            }
                            span.onclick = function() {
                                modal.style.display = "none";
                            }
                            notok.onclick = function() {
                                modal.style.display = "none";
                            }
                            window.onclick = function(event) {
                                if (event.target == modal) {
                                    modal.style.display = "none";
                                }
                            }
                        </script>
                        <?php
                    }
               }
                else
                {
                    //echo mc_decrypt($rtl_activate_options[RTL_THEME_SLUG."_rtl_secretkey"], static::$WEOWPS_RTL_OIEKS);
                    die('کلید غیرفعالسازی اشتباه است!');
                }
            }
            else
            {
                die('کلید غیرفعالسازی وارد نشده است!');
            }
            ?>
        </div>

        <?php		
	
    }
	public function mweb_admin_notice__local() {
		echo'<div class="notice notice-info"><p>توجه کنید : پوسته در لوکال هاست بدون نیاز به لایسنس عمل می کند</p></div>';
	}
	
}



?>