<?php
//frontend script
if ( ! function_exists( 'mweb_theme_register_frontend_script' ) ) {
	function mweb_theme_register_frontend_script() {
		
		$custom_file = mweb_theme_util::get_theme_option('mweb_custom_file_cssjs');
		$video_player = mweb_theme_util::get_theme_option('mweb_video_player');
		
		$style_deps = array(
			'woocommerce',
			'bootstrap',
			'font-icon',
			'magnific-popup',
			'modal',
			'owl-carousel',
			'swiper',
			'wp-mediaelement',
		);
		
		// Load the stylesheets
		wp_register_style( 'bootstrap', THEME_ASSET . '/css/bootstrap.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'font-icon', THEME_ASSET . '/css/font-awesome.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'magnific-popup', THEME_ASSET . '/css/magnific-popup.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'modal', THEME_ASSET . '/css/modal.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'owl-carousel', THEME_ASSET . '/css/owl-carousel.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'swiper', THEME_ASSET . '/css/swiper.css', array(), THEME_VERSION, 'all');
		wp_register_style( 'woocommerce', THEME_ASSET . '/css/woocommerce.css', array(), THEME_VERSION, 'all');

		
		if( is_singular(array( 'product', 'lp_course', 'sfwd-courses' )) && $video_player == 'videojs'){
			//wp_enqueue_style( 'plyr-css', 'https://cdn.plyr.io/3.6.2/plyr.css' , false ,'3.6.2' );
			//wp_enqueue_style( 'plyr-css', 'https://vjs.zencdn.net/7.8.4/video-js.css' , false ,'7.8.4' );
			$style_deps[] = 'plyr-css';
			//wp_enqueue_style( 'plyr-css', 'https://cdn.jsdelivr.net/npm/video.js@7.8.4/dist/video-js.css' , false ,'7.8.4' );
			wp_register_style( 'plyr-css', THEME_ASSET . '/css/video-js.css', array(), '7.8.4', 'all');
		}
		
		if( $custom_file ){
			$style_deps[] = 'custom-style';
			wp_enqueue_style( 'custom-style', get_template_directory_uri() . '/custom/custom.css', array(), THEME_VERSION, 'all');
		}

		wp_register_style( 'mweb-style', get_stylesheet_uri(), $style_deps, THEME_VERSION, 'all' );
		wp_enqueue_style( 'mweb-style' );
		
		wp_dequeue_style( 'woo-wallet-style' );
		
		


		// Register scripts	
		
		
		$script_deps = array(
			'jquery',
			'wp-mediaelement',
			'jquery-countdown',
			'jquery-magnific-popup',
			'jquery-mediaelementjs',
			'jquery-notifyjs',
			'jquery-owl-carousel',
			'jquery-progressbar',
			'jquery-swiper',
			'jquery-tooltip',
			'jquery-tabslet',
			'jquery-modal',
			'jquery-effects-core',
		);
		
		
		
		wp_register_script( 'jquery-countdown', THEME_ASSET . '/js/jquery.countdown.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-magnific-popup', THEME_ASSET . '/js/jquery.magnific.popup.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-mediaelementjs', THEME_ASSET . '/js/jquery.mediaelementjs.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-notifyjs', THEME_ASSET . '/js/jquery.notifyjs.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-owl-carousel', THEME_ASSET . '/js/jquery.owl.carousel.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-progressbar', THEME_ASSET . '/js/jquery.progressbar.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-swiper', THEME_ASSET . '/js/jquery.swiper.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-tabslet', THEME_ASSET . '/js/jquery.tabslet.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-tooltip', THEME_ASSET . '/js/jquery.tooltip.min.js', array('jquery'), THEME_VERSION, true );
		wp_register_script( 'jquery-modal', THEME_ASSET . '/js/jquery.modal.min.js', array('jquery'), THEME_VERSION, true );

		
		
		
		
		//wp_register_script('plugins-theme', THEME_ASSET . '/js/plugins-theme.js', array(),THEME_VERSION, true);
		//wp_register_script('my-script', THEME_ASSET . '/js/my-script.js', array('plugins-theme'),THEME_VERSION, true);

		//wp_enqueue_script("jquery");
		
		
		// Load the custom scripts
		//wp_enqueue_script( 'plugins-theme' );
		//wp_enqueue_script( 'jquery-effects-core' );
		//wp_enqueue_script( 'wp-mediaelement' );
		
		if( is_singular(array( 'product', 'lp_course', 'sfwd-courses' )) && $video_player == 'videojs'){
			$script_deps[] = 'plyr';
			$script_deps[] = 'plyr-hls';
			$script_deps[] = 'plyr-hls-q';
			//wp_enqueue_script('plyr', 'https://cdn.plyr.io/3.6.2/plyr.js', array(), '3.6.2');
			//wp_enqueue_script('plyr', 'https://vjs.zencdn.net/7.8.4/video.js', array(), '7.8.4');
			wp_register_script( 'plyr', THEME_ASSET . '/js/video.js', array(), '7.8.4', true );
			//wp_enqueue_script('plyr-hls', 'https://cdnjs.cloudflare.com/ajax/libs/videojs-contrib-hls/5.15.0/videojs-contrib-hls.js', array(), '7.8.4');
			wp_register_script( 'plyr-hls', THEME_ASSET . '/js/videojs-contrib-quality-levels.min.js', array(), '7.8.4', true );
			wp_register_script( 'plyr-hls-q', THEME_ASSET . '/js/videojs-hls-quality-selector.min.js', array(), '7.8.4', true );
		}
		
		if( is_singular(array( 'product')) ){
			$audio_preview = get_post_meta( get_the_ID(), '_audio_preview', true ); 
			if ( !empty( $audio_preview ) ){ 
				wp_enqueue_script('wavesurfer', 'https://unpkg.com/wavesurfer.js@7.0.0-beta.5/dist/wavesurfer.min.js', array(), '1.4.0', true);
			}
		}
		
		
		
	
	
		//load custom script
		if( $custom_file ){
			$script_deps[] = 'custom-script';
			wp_register_script( 'custom-script', get_template_directory_uri() . '/custom/custom.js', array('jquery'), '1.0', true );
		}


		//load comment script
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
			
			
			//wp_register_script( 'foxiz-global', get_theme_file_uri( 'assets/js/global.js' ), $script_deps, FOXIZ_THEME_VERSION, true );
			wp_register_script( 'my-script', THEME_ASSET . '/js/my-script.js', $script_deps, THEME_VERSION, true );
			wp_enqueue_script( 'my-script' );
		

	}

	if ( ! is_admin() ) {
		add_action( 'wp_enqueue_scripts', 'mweb_theme_register_frontend_script' );
	}
	
	
}




