<?php
/**
 * this file render dynamic css for theme
 */

//add css to header
//add_action( 'wp_head', 'mweb_theme_dynamic_css', 99 );
add_action( 'wp_enqueue_scripts', 'mweb_theme_dynamic_css' );

/**
 * @return string
 * this file get options and create css code as string
 */
if ( ! function_exists( 'mweb_theme_dynamic_css' ) ) {
	function mweb_theme_dynamic_css() {

		//get cache
		$mweb_dynamic_css_cache = get_option( 'mweb_theme_dynamic_css_cache', '' );	
		
		if ( empty( $mweb_dynamic_css_cache ) ) {
			
			$str = '';
			//$str .= '<style type="text/css" media="all">';

			$color_main = mweb_theme_util::get_theme_option( 'color_main' );

			$color_sec = mweb_theme_util::get_theme_option( 'color_sec' );
			
			$color_1 = mweb_theme_util::get_theme_option( 'color1' ); // bg
			$color_2 = mweb_theme_util::get_theme_option( 'color2' ); // badge
			
			$color_3 = mweb_theme_util::get_theme_option( 'color3' ); // color footer
			
			$color_5 = mweb_theme_util::get_theme_option( 'color5' ); // add to basket
			

			
			$body_background = mweb_theme_util::get_theme_option( 'mweb-body-pat' ); //  body background
			//$header_background = mweb_theme_util::get_theme_option( 'mweb-head-pat' ); //  header background
			$footer_background = mweb_theme_util::get_theme_option( 'mweb-footer-pat' ); //  footer background


			//$under_construction_background = mweb_theme_util::get_theme_option( 'under_construction_background' ); //  under construction background
			
			$mweb_offer_pat = mweb_theme_util::get_theme_option( 'mweb_offer_pat' ); //  offer background
			$mweb_offer_color = mweb_theme_util::get_theme_option( 'mweb_offer_color' ); //  offer text color


			$mweb_font_family = mweb_theme_util::get_theme_option( 'mweb_font_family' );
			
			
			$site_url = THEME_ASSET;
			$str_font = '';

			if( $mweb_font_family == 'dana' ){
				$font_array = ['Dana', 'Dananum'];
				$str_font .= '@font-face {
					font-family: "Dana";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/Dana-medium.woff") format("woff"), 
					url("[site_url]/fonts/Dana-medium.woff2") format("woff2"), 
					url("[site_url]/fonts/Dana-medium.ttf") format("truetype");
				}
				@font-face {
					font-family: "Dana";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/Dana-regular.woff") format("woff"), 
					url("[site_url]/fonts/Dana-regular.woff2") format("woff2"), 
					url("[site_url]/fonts/Dana-regular.ttf") format("truetype");
				}
				@font-face {
					font-family: "Dananum";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/Dana-medium-fanum.woff") format("woff"), 
					url("[site_url]/fonts/Dana-medium-fanum.woff2") format("woff2"), 
					url("[site_url]/fonts/Dana-medium-fanum.ttf") format("truetype");
				}
				@font-face {
					font-family: "Dananum";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/Dana-regular-fanum.woff") format("woff"), 
					url("[site_url]/fonts/Dana-regular-fanum.woff2") format("woff2"), 
					url("[site_url]/fonts/Dana-regular-fanum.ttf") format("truetype");
				}';
			} elseif( $mweb_font_family == 'iranyekan' ){
				$font_array = ['IRANYekan', 'IRANYekannum'];
				$str_font .= '@font-face {
					font-family: "IRANYekan";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/IRYekan-medium.eot");
					src: url("[site_url]/fonts/IRYekan-medium.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRYekan-medium.woff") format("woff"), 
					url("[site_url]/fonts/IRYekan-medium.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANYekan";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/IRYekan-regular.eot");
					src: url("[site_url]/fonts/IRYekan-regular.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRYekan-regular.woff") format("woff"), 
					url("[site_url]/fonts/IRYekan-regular.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANYekannum";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/IRYekan-medium-fanum.eot");
					src: url("[site_url]/fonts/IRYekan-medium-fanum.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRYekan-medium-fanum.woff") format("woff"), 
					url("[site_url]/fonts/IRYekan-medium-fanum.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANYekannum";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/IRYekan-regular-fanum.eot");
					src: url("[site_url]/fonts/IRYekan-regular-fanum.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRYekan-regular-fanum.woff") format("woff"), 
					url("[site_url]/fonts/IRYekan-regular-fanum.ttf") format("truetype");
				}';
			} else{
				$font_array = ['IRANSans', 'IRANSansnum'];
				$str_font .= '@font-face {
					font-family: "IRANSans";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/IRANSans-medium.eot");
					src: url("[site_url]/fonts/IRANSans-medium.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRANSans-medium.woff") format("woff"), 
					url("[site_url]/fonts/IRANSans-medium.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANSans";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/IRANSans.eot");
					src: url("[site_url]/fonts/IRANSans.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRANSans.woff") format("woff"), 
					url("[site_url]/fonts/IRANSans.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANSansnum";
					font-style: normal;
					font-weight: 500;
					font-display:block;
					src: url("[site_url]/fonts/IRANSans-medium-fanum.eot");
					src: url("[site_url]/fonts/IRANSans-medium-fanum.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRANSans-medium-fanum.woff") format("woff"), 
					url("[site_url]/fonts/IRANSans-medium-fanum.ttf") format("truetype");
				}
				@font-face {
					font-family: "IRANSansnum";
					font-style: normal;
					font-weight: normal;
					font-display:block;
					src: url("[site_url]/fonts/IRANSans-fanum.eot");
					src: url("[site_url]/fonts/IRANSans-fanum.eot?#iefix") format("embedded-opentype"), 
					url("[site_url]/fonts/IRANSans-fanum.woff") format("woff"), 
					url("[site_url]/fonts/IRANSans-fanum.ttf") format("truetype");
				}';
			}
				
			
			$str_font .= '@font-face {
				font-family: "Font Awesome 6";
				font-style: normal;
				font-weight: 300;
				font-display: swap;
				src: url("[site_url]/fonts/fa-light-300.woff2") format("woff2"),
				url("[site_url]/fonts/fa-light-300.ttf") format("truetype"); 
			}
			@font-face {
				font-family: "Font Awesome 6 Brands";
				font-style: normal;
				font-weight: 400;
				font-display: swap;
				src: url("[site_url]/fonts/fa-brands-400.woff2") format("woff2"),
				url("[site_url]/fonts/fa-brands-400.ttf") format("truetype");
			}
			'; 

			$str .= str_replace('[site_url]', $site_url, $str_font);
			
			
			
			$str .= ':root {';
			
				if( !empty($color_main) )
					$str .= '--maincolor: '.$color_main.';';
				if( !empty($color_sec) )
					$str .= '--secoundcolor: '.$color_sec.';';
				if( !empty($color_1) )
					$str .= '--bgcolor: '.$color_1.';';
				if( !empty($color_2) )
					$str .= '--badgecolor: '.$color_2.';';
				if( !empty($color_3) )
					$str .= '--footcolor: '.$color_3.';';
				if( !empty($color_5) )
					$str .= '--cartcolor: '.$color_5.';';
				
				
				$str .= '--mainfont: '.$font_array[0].';';
				$str .= '--mainfontnum: '.$font_array[1].';';

			$str .= '}';
			
			
			
			/* ----------------------------- body background --------------------------------- */

			if( !empty($body_background) && !empty($body_background['background-image']) ){
				$str .= 'body{ background-image: url('.$body_background['background-image'].'); background-position: '.$body_background['background-position'].'; background-repeat: '.$body_background['background-repeat'].'; background-size: '.$body_background['background-size'].'; }';
			}
			
			
			/* ----------------------------- head background --------------------------------- */

			/* if( !empty($header_background) && !empty($header_background['background-image']) ){
				$str .= '.logo_wrap , .full_header_wrap{ background-image: url('.$header_background['background-image'].');	background-position: '.$header_background['background-position'].';	background-repeat: '.$header_background['background-repeat'].';	background-size: '.$header_background['background-size'].';	}';
			} */


			/* ----------------------------- footer background --------------------------------- */

			if( !empty($footer_background) && !empty($footer_background['background-image']) ){
				$str .= '.footer_wrap{ background-image: url('.$footer_background['background-image'].'); background-position: '.$footer_background['background-position'].'; background-repeat: '.$footer_background['background-repeat'].'; background-size: '.$footer_background['background-size'].'; }';
			}
			
			
			/* ----------------------------- header alert --------------------------------- */

			if( !empty($mweb_offer_pat) ){
				$str .= '.header_alert{ background-color:'.$mweb_offer_pat['background-color'].';';
				if(!empty($mweb_offer_pat['background-image']))
				$str .= ' background-image: url('.$mweb_offer_pat['background-image'].'); background-position: '.$mweb_offer_pat['background-position'].'; background-repeat: '.$mweb_offer_pat['background-repeat'].';';
				$str .= ' }';
			}
			if( !empty($mweb_offer_color) ){
				$str .= '.header_alert a{ color:'.$mweb_offer_color.' }';
			}
			
			
			/* -----------------------------  product title style --------------------------------- */
			/* if( $mweb_product_title_style) {
				$str .= '.single_product_head{padding: 0px 15px 10px; background-color: #f5f6f7;}.woocommerce .entry-summary .product_meta{ padding:0}';
			} */
			
			/* ----------------------------- construction background --------------------------------- */

			/* if( !empty($under_construction_background) && !empty($under_construction_background['background-image']) ){
				$str .= '.under_construction{ background-image: url('.$under_construction_background['background-image'].'); background-position: '.$under_construction_background['background-position'].'; background-repeat: '.$under_construction_background['background-repeat'].'; background-size: '.$under_construction_background['background-size'].'; }';
			} */
			
			
			/* ----------------------------- typography ------------------------------- */
			
			$menu_typ = mweb_theme_util::get_theme_option( 'menu-typography' );
			$content_typ = mweb_theme_util::get_theme_option( 'content-typography' );
			$ch2_typ = mweb_theme_util::get_theme_option( 'ch2-typography' );
			$ch3_typ = mweb_theme_util::get_theme_option( 'ch3-typography' );
			$ch4_typ = mweb_theme_util::get_theme_option( 'ch4-typography' );
			
			if( !empty($menu_typ) )
				$str .= ".mweb-main-menu ul>li.level-0>a{font-size: {$menu_typ['font-size']}; font-weight: {$menu_typ['font-weight']}; color: {$menu_typ['color']}} .mweb-main-menu ul>li.level-0{line-height: {$menu_typ['line-height']};}";
						
			$str .= ".entry-content, .entry-content>p{";
				if(!empty($content_typ['font-size'])) 
					$str .= "font-size: {$content_typ['font-size']};";
				if(!empty($content_typ['font-weight'])) 
					$str .= "font-weight: {$content_typ['font-weight']};";
				if(!empty($content_typ['color'])) 
					$str .= "color: {$content_typ['color']};";
				if(!empty($content_typ['line-height'])) 
					$str .= "line-height: {$content_typ['line-height']};";
			$str .= "}";
			
			if(!empty($ch2_typ))
				$str .= ".entry-content>h2{font-size: {$ch2_typ['font-size']}; font-weight: {$ch2_typ['font-weight']}; color: {$ch2_typ['color']}; line-height: {$ch2_typ['line-height']};}";
			
			if(!empty($ch3_typ))
				$str .= ".entry-content>h3{font-size: {$ch3_typ['font-size']}; font-weight: {$ch3_typ['font-weight']}; color: {$ch3_typ['color']}; line-height: {$ch3_typ['line-height']};}";
			
			if(!empty($ch4_typ))
				$str .= ".entry-content>h3{font-size: {$ch4_typ['font-size']}; font-weight: {$ch4_typ['font-weight']}; color: {$ch4_typ['color']}; line-height: {$ch4_typ['line-height']};}";
		


			/************************ USER CUSTOM CSS **********************************/
			$mweb_custom_css = mweb_theme_util::get_theme_option( 'custom_css' );

			if ( ! empty( $mweb_custom_css ) ) {
				$str .= $mweb_custom_css;
			}
			
			
			//$str_all = apply_filters( 'custom_css_elm', $str );

			
			//$str .= mweb_theme_composer_render::dynamic_style();

			//$str .= '</style>';
			
			
			$str = mweb_minimize_CSS($str);

			//save to database
			$mweb_save_dynamic_css_cache = addslashes( $str );
			delete_option( 'mweb_theme_dynamic_css_cache' );
			add_option( 'mweb_theme_dynamic_css_cache', $mweb_save_dynamic_css_cache );
			
			update_option( 'mweb_css_cache_flag', 'active' );

			wp_add_inline_style( 'mweb-style', $str );


		} else {
			wp_add_inline_style( 'mweb-style', stripcslashes( $mweb_dynamic_css_cache ) );
		}
	}
}

if ( ! function_exists( 'mweb_theme_delete_dynamic_css_cache' ) ) {
	function mweb_theme_delete_dynamic_css_cache() {
		delete_option( 'mweb_theme_dynamic_css_cache' );
	}
}

// delete css cache
add_action( 'redux/options/shop_options/saved', 'mweb_theme_delete_dynamic_css_cache' );
add_action( 'redux/options/shop_options/reset', 'mweb_theme_delete_dynamic_css_cache' );
add_action( 'redux/options/shop_options/section/reset', 'mweb_theme_delete_dynamic_css_cache' );
//add_action( 'save_post', 'mweb_theme_delete_dynamic_css_cache' );