<?php

/**-------------------------------------------------------------------------------------------------------------------------
 * Class mweb_menu_walker_backend
 * this file edit menu in backend
 */
//admin menu setting

class  mweb_menu_walker_backend extends Walker_Nav_Menu {
	/**
	 * @see Walker_Nav_Menu::start_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function start_lvl(&$output, $depth = 0, $args = array()) {
	}

	/**
	 * @see Walker_Nav_Menu::end_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function end_lvl(&$output, $depth = 0, $args = array()) {
	}

	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param object $args
	 */
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
		global $_wp_nav_menu_max_depth;

		$_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

		$indent = ($depth) ? str_repeat("\t", $depth) : '';

		ob_start();
		$item_id      = esc_attr($item->ID);
		$removed_args = array(
			'action',
			'customlink-tab',
			'edit-menu-item',
			'menu-item',
			'page-tab',
			'_wpnonce',
		);

		$original_title = '';
		if('taxonomy' == $item->type) {
			$original_title = get_term_field('name', $item->object_id, $item->object, 'raw');
			if(is_wp_error($original_title)) {
				$original_title = false;
			}
		} elseif('post_type' == $item->type) {
			$original_object = get_post($item->object_id);
			$original_title  = $original_object->post_title;
		}

		$classes = array(
			'menu-item menu-item-depth-'.$depth,
			'menu-item-'.esc_attr($item->object),
			'menu-item-edit-'.((isset($_GET['edit-menu-item']) && $item_id == $_GET['edit-menu-item']) ? 'active' : 'inactive'),
		);

		$title = $item->title;

		if(!empty($item->_invalid)) {
			$classes[] = 'menu-item-invalid';
			/* translators: %s: title of menu item which is invalid */
			$title = sprintf(esc_html__('%s (Invalid)', 'mweb'), $item->title);
		} elseif(isset($item->post_status) && 'draft' == $item->post_status) {
			$classes[] = 'pending';
			/* translators: %s: title of menu item in draft status */
			$title = sprintf(esc_html__('%s (Pending)', 'mweb'), $item->title);
		}

		$title = empty($item->label) ? $title : $item->label;

		?>
	<li id="menu-item-<?php echo esc_attr($item_id); ?>" class="<?php echo esc_attr(implode(' ', $classes)); ?>">
		<dl class="menu-item-bar">
			<dt class="menu-item-handle">
				<span class="item-title"><?php echo esc_html($title); ?></span>
                <span class="item-controls">
                    <span class="spinner"></span>
                    <span class="item-type"><?php echo esc_html($item->type_label); ?></span>
                    <span class="item-order hide-if-js">
                        <a href="<?php
                        echo esc_url(wp_nonce_url(
	                        add_query_arg(
		                        array(
			                        'action'    => 'move-up-menu-item',
			                        'menu-item' => $item_id,
		                        ),
		                        remove_query_arg($removed_args, admin_url('nav-menus.php'))
	                        ),
	                        'move-menu_item'
                        ));
                        ?>" class="item-move-up"><abbr title="<?php esc_attr_e('انتقال به بالا', 'mweb'); ?>">&#8593;</abbr></a>
                        |
                        <a href="<?php
                        echo esc_url(wp_nonce_url(
	                        add_query_arg(
		                        array(
			                        'action'    => 'move-down-menu-item',
			                        'menu-item' => $item_id,
		                        ),
		                        remove_query_arg($removed_args, admin_url('nav-menus.php'))
	                        ),
	                        'move-menu_item'
                        ));
                        ?>" class="item-move-down"><abbr title="<?php esc_attr_e('انتقال به پایین', 'mweb'); ?>">&#8595;</abbr></a>
                    </span>
                    <a class="item-edit" id="edit-<?php echo esc_attr($item_id); ?>" title="<?php esc_attr_e('ویرایش این گزینه', 'mweb'); ?>" href="<?php
                    echo (isset($_GET['edit-menu-item']) && $item_id == $_GET['edit-menu-item']) ? admin_url('nav-menus.php') : esc_url(add_query_arg('edit-menu-item', $item_id, remove_query_arg($removed_args, admin_url('nav-menus.php#menu-item-settings-'.$item_id))));
                    ?>"><?php esc_html_e('ویزایش گزینه منو', 'mweb'); ?></a>
                </span>
			</dt>
		</dl>

		<div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr($item_id); ?>">
			<?php if('custom' == $item->type) : ?>
				<p class="field-url description description-wide">
					<label for="edit-menu-item-url-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e('آدرس', 'mweb'); ?><br/>
						<input type="text" id="edit-menu-item-url-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->url); ?>"/>
					</label>
				</p>
			<?php endif; ?>
			<p class="description description-thin">
				<label for="edit-menu-item-title-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('برچسب', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->title); ?>"/>
				</label>
			</p>

			<p class="description description-thin">
				<label for="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('مشخصه عنوان', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->post_excerpt); ?>"/>
				</label>
			</p>

			<p class="field-link-target description">
				<label for="edit-menu-item-target-<?php echo esc_attr($item_id); ?>">
					<input type="checkbox" id="edit-menu-item-target-<?php echo esc_attr($item_id); ?>" value="_blank" name="menu-item-target[<?php echo esc_attr($item_id); ?>]"<?php checked($item->target, '_blank'); ?> />
					<?php esc_html_e('بازکردن در تب جدید', 'mweb'); ?>
				</label>
			</p>

			<p class="field-css-classes description description-thin">
				<label for="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('کلاس اختیاری', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr(implode(' ', $item->classes)); ?>"/>
				</label>
			</p>

			<p class="field-xfn description description-thin">
				<label for="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('پیوند ارتباط (XFN)', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->xfn); ?>"/>
				</label>
			</p>

			<p class="field-description description description-wide">
				<label for="edit-menu-item-description-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('توضیحات', 'mweb'); ?><br/>
					<textarea id="edit-menu-item-description-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo esc_attr($item_id); ?>]"><?php echo esc_html($item->description); // textarea_escaped ?></textarea>
					<span class="description"><?php esc_html_e('توضیحات در منو نمایش داده خواهد شد اگر قالب فعلی آن را پشتیبانی کند.', 'mweb'); ?></span>
				</label>
			</p>
			<?php
			/* New fields insertion starts here */
			?>
			<p class="field-custom description description-thin description-thin-custom">
				<label for="edit-menu-item-anchor-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('لنگر', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-anchor-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-anchor" data-item-option data-name="menu_item_anchor_<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($item->anchor); ?>"/>
				</label>
			</p>

			<p class="field-custom description description-wide">
				<?php
				$value = $item->nolink;
				if($value != "") {
					$value = "checked";
				}
				?>
				<label for="edit-menu-item-nolink-<?php echo esc_attr($item_id); ?>">
					<input type="checkbox" id="edit-menu-item-nolink-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" data-item-option data-name="menu_item_nolink_<?php echo esc_attr($item_id); ?>" value="nolink" <?php echo esc_attr($value); ?> />
					<?php esc_html_e("بدون لینک", 'mweb'); ?>
				</label>
			</p>

			<p class="field-custom description description-wide">
				<?php
				$value = $item->hide;
				if($value != "") {
					$value = "checked";
				}
				?>
				<label for="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>">
					<input type="checkbox" id="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" data-item-option data-name="menu_item_hide_<?php echo esc_attr($item_id); ?>" value="hide" <?php echo esc_attr($value); ?> />
					<?php esc_html_e("عدم نمایش", 'mweb'); ?>
				</label>
			</p>

			<p class="field-custom description description-thin description-thin-custom">
				<label for="edit-menu-item-type-menu-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('نوع', 'mweb'); ?><br/>
					<select class="widefat" id="edit-menu-item-type-menu<?php echo esc_attr($item_id); ?>" data-item-option data-name="menu_item_type_menu_<?php echo esc_attr($item_id); ?>">
						<option value="" <?php if($item->type_menu == "") {
							echo 'selected="selected"';
						} ?>></option>
						<option value="wide" <?php if($item->type_menu == "wide") {
							echo 'selected="selected"';
						} ?>>تمام عرض
						</option>
						<option value="wide_icons" <?php if($item->type_menu == "wide_icons") {
							echo 'selected="selected"';
						} ?>>تمام عرض همراه با آیکن
						</option>
					</select>
				</label>
			</p>
			<p class="field-custom description description-thin description-thin-custom">
				<label for="edit-menu-item-wide-position-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('موقعیت', 'mweb'); ?><br/>
					<select class="widefat" id="edit-menu-item-wide-position<?php echo esc_attr($item_id); ?>" data-item-option data-name="menu_item_wide_position_<?php echo esc_attr($item_id); ?>">
						<option value="" <?php if($item->wide_position == "") {
							echo 'selected="selected"';
						} ?>></option>
						<option value="left" <?php if($item->wide_position == "left") {
							echo 'selected="selected"';
						} ?>>چپ
						</option>
						<option value="right" <?php if($item->wide_position == "right") {
							echo 'selected="selected"';
						} ?>>راست
						</option>
					</select>
				</label>
			</p>

			<p class="field-custom description description-wide">
				<label for="edit-menu-item-background-image-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('پس زمینه مگامنو', 'mweb'); ?><br/>
					<input type="text" id="edit-menu-item-background-image-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-background-image" data-item-option data-name="menu_item_background_image_<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($item->background_image); ?>"/>
					<br/>
				</label>
			</p>

		
			<p class="field-custom description description-wide">
				<label for="edit-menu-item-icon-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('آیکن', 'mweb'); ?><br/>
				<input type="text" id="edit-menu-item-icon<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-icon" data-item-option data-name="menu_item_icon_<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr( $item->icon ); ?>" />
				<div id="preview_icon_picker_<?php echo esc_attr( $item_id ); ?>" data-target="#edit-menu-item-icon<?php echo esc_attr( $item_id ); ?>" class="button icon-picker fal <?php echo esc_attr( $item->icon ); ?>"></div>
				
				</label>
			</p>

			
			<p class="field-custom description description-thin description-thin-custom" style="clear:both;">
				<label for="edit-menu-item-featured-icon-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('آیکن ویژه', 'mweb'); ?><br/>
					<select class="widefat" id="edit-menu-item-featured-icon<?php echo esc_attr($item_id); ?>" data-item-option data-name="menu_item_featured_icon_<?php echo esc_attr($item_id); ?>">
						<option value="" <?php if($item->featured_icon == "") {
							echo 'selected="selected"';
						} ?>></option>
						<option value="star" <?php if($item->featured_icon == "star") {
							echo 'selected="selected"';
						} ?>><?php esc_html_e('ستاره', 'mweb'); ?></option>
						<option value="heart " <?php if($item->featured_icon == "heart ") {
							echo 'selected="selected"';
						} ?>><?php esc_html_e('قلب', 'mweb'); ?></option>
						<option value="arrow-up" <?php if($item->featured_icon == "arrow-up") {
							echo 'selected="selected"';
						} ?>><?php esc_html_e('فلش', 'mweb'); ?></option>
					</select>
				</label>
			</p>

			<p class="field-custom description description-thin description-thin-custom">
			</p>

			<p class="field-custom description description-wide">
				<label for="edit-menu-item-sidebar-<?php echo esc_attr($item_id); ?>">
					<?php esc_html_e('سایدبار', 'mweb'); ?><br/>
					<select class="widefat" id="edit-menu-item-sidebar<?php echo esc_attr($item_id); ?>" data-item-option data-name="menu_item_sidebar_<?php echo esc_attr($item_id); ?>">
						<option value="" <?php if($item->sidebar == "") {
							echo 'selected="selected"';
						} ?>></option>
						<?php
						$custom_sidebars = mweb_theme_config::sidebar_name();
						foreach($custom_sidebars as $sidebar_key => $sidebar) { ?>
							<option value="<?php echo esc_attr($sidebar_key); ?>" <?php if($item->sidebar == $sidebar_key) { ?> selected="selected" <?php } ?>>
								<?php echo esc_html(ucwords($sidebar)); ?>
							</option>
						<?php } ?>
					</select>
					<br/><?php esc_html_e('تنها در صورت انتخاب نوع تمام عرض منو', 'mweb'); ?>
				</label>
			</p>
			<?php
			/* New fields insertion ends here */
			?>
			<div class="menu-item-actions description-wide submitbox">
				<?php if('custom' != $item->type && $original_title !== false) : ?>
					<p class="link-to-original">
						<?php printf(esc_html__('اصلی: %s', 'mweb'), '<a href="'.esc_attr($item->url).'">'.esc_html($original_title).'</a>'); ?>
					</p>
				<?php endif; ?>
				<a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($item_id); ?>" href="<?php
				echo esc_url(wp_nonce_url(
					add_query_arg(
						array(
							'action'    => 'delete-menu-item',
							'menu-item' => $item_id,
						),
						remove_query_arg($removed_args, admin_url('nav-menus.php'))
					),
					'delete-menu_item_'.$item_id
				)); ?>"><?php esc_html_e('Remove', 'mweb'); ?></a> <span class="meta-sep"> | </span>
				<a class="item-cancel submitcancel" id="cancel-<?php echo esc_attr($item_id); ?>" href="<?php echo esc_url(add_query_arg(array(
					'edit-menu-item' => $item_id,
					'cancel'         => time()
				), remove_query_arg($removed_args, admin_url('nav-menus.php'))));
				?>#menu-item-settings-<?php echo esc_attr($item_id); ?>"><?php esc_html_e('انصراف', 'mweb'); ?></a>
			</div>

			<input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item_id); ?>"/>
			<input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->object_id); ?>"/>
			<input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->object); ?>"/>
			<input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->menu_item_parent); ?>"/>
			<input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->menu_order); ?>"/>
			<input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item->type); ?>"/>
		</div>
		<!-- .menu-item-settings-->
		<ul class="menu-item-transport"></ul>
		<?php

		$output .= ob_get_clean();

	}
}

// add custom menu fields to menu
add_filter('wp_setup_nav_menu_item', 'hue_mikado_add_custom_nav_fields');

// save menu custom fields
add_action('wp_update_nav_menu_item', 'hue_mikado_update_custom_nav_fields', 10, 3);

// edit menu walker
add_filter('wp_edit_nav_menu_walker', 'hue_mikado_edit_walker', 10, 2);


/**
 * Define new Walker edit
 *
 * @access      public
 * @since       1.0
 * @return      void
 */
function hue_mikado_edit_walker($walker, $menu_id) {

	return 'mweb_menu_walker_backend';

}

function hue_mikado_add_custom_nav_fields($menu_item) {
	$menu_item->anchor           = get_post_meta($menu_item->ID, '_menu_item_anchor', true);
	$menu_item->nolink           = get_post_meta($menu_item->ID, '_menu_item_nolink', true);
	$menu_item->hide             = get_post_meta($menu_item->ID, '_menu_item_hide', true);
	$menu_item->type_menu        = get_post_meta($menu_item->ID, '_menu_item_type_menu', true);
	$menu_item->icon             = get_post_meta($menu_item->ID, '_menu_item_icon', true);
	$menu_item->sidebar          = get_post_meta($menu_item->ID, '_menu_item_sidebar', true);
	$menu_item->wide_position    = get_post_meta($menu_item->ID, '_menu_item_wide_position', true);
	$menu_item->background_image = get_post_meta($menu_item->ID, '_menu_item_background_image', true);
	$menu_item->featured_icon    = get_post_meta($menu_item->ID, '_menu_item_featured_icon', true);

	return $menu_item;

}

/**
 * Save menu custom fields
 *
 * @access      public
 * @since       1.0
 * @return      void
 */
function hue_mikado_update_custom_nav_fields($menu_id, $menu_item_db_id, $args) {

	$check = array(
		'anchor',
		'nolink',
		'hide',
		'type_menu',
		'icon',
		'sidebar',
		'wide_position',
		'background_image',
		'featured_icon'
	);

	if(isset($_POST['mweb_menu_options'])) {
		parse_str(urldecode($_POST['mweb_menu_options']), $parse_array);

		foreach($check as $key) {
			if(empty($parse_array['menu_item_'.$key.'_'.$menu_item_db_id]) || $parse_array['menu_item_'.$key.'_'.$menu_item_db_id] === 'null') {
				$parse_array['menu_item_'.$key.'_'.$menu_item_db_id] = "";
			}

			$value = $parse_array['menu_item_'.$key.'_'.$menu_item_db_id];
			update_post_meta($menu_item_db_id, '_menu_item_'.$key, $value);
		}
	}

}
