<?php
//registering admin css and script
if ( ! function_exists( 'mweb__register_backend_script' ) ) {
	function mweb_register_backend_script( $hook ) {
		
		wp_register_style( 'admin-style', get_template_directory_uri() . '/includes/admin/css/mweb-admin-style.css', array(), THEME_VERSION, 'all' );
		wp_enqueue_style( 'admin-style' );
		
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'wp-color-picker' );
		
		wp_enqueue_media();

		if ( $hook == 'edit.php' || $hook == 'nav-menus.php' || $hook == 'post.php' || $hook == 'edit-tags.php' || $hook == 'term.php' ) {
			wp_register_script( 'admin-script', get_template_directory_uri() . '/includes/admin/js/mweb-admin-script.js', array( 'jquery' ), THEME_VERSION, true );
			wp_enqueue_script( 'admin-script' );
		}
		
		wp_enqueue_style('vntd-admin', get_template_directory_uri() . '/assets/css/admin/vntd-admin.css');	
		
	}

	//check & do action
	add_action( 'admin_enqueue_scripts', 'mweb_register_backend_script' );
	
}



/*-----------------------------------------------------------------------------------*/
/* icon picker
/*-----------------------------------------------------------------------------------*/

function icon_picker_scripts() {
	
	wp_enqueue_style('icon-picker', get_template_directory_uri() . '/includes/admin/css/icon-picker.css');

	wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/admin/font-awesome.min.css');

	wp_enqueue_script( 'icon-picker-script', get_template_directory_uri() . '/includes/admin/js/icon-picker.js', array( 'jquery' ), THEME_VERSION, true );

}
// Make sure we only enqueue on our options page //
global $pagenow;
if (( $pagenow == 'edit.php' || $pagenow == 'widgets.php' || $pagenow == 'nav-menus.php') && is_admin()  ) {
	add_action( 'admin_enqueue_scripts', 'icon_picker_scripts' );
}
