(function($) {

	$(document).ready(function ($) {
		$('#cat_color').wpColorPicker();
	});
	
	function handle_images( frameArgs, callback ){
		var mw_frame = wp.media( frameArgs );

		mw_frame.on( 'select', function() {
			callback( mw_frame.state().get('selection') );
			mw_frame.close();
		});

		mw_frame.open();	
	}



	$(document).on( 'click', '.select-image', function(e) {
		e.preventDefault();
		var $parent = $(this).parents('.form-field');
		var frameArgs = {
			multiple: false,
			title: 'انتخاب عکس'
		};

		handle_images( frameArgs, function( selection ){
			model = selection.first();
			$parent.find('input').val(model.id);
			$parent.find('.mweb-image-wrap img').remove();
			$parent.find('.mweb-image-wrap').append( '<img src="'+model.attributes.url+'" width="150" height="auto" style="float: left"/>' );
			$parent.find('.remove-image').removeClass('hidden');
		});
	});



	$(document).on( 'click', '.remove-image', function(e) {
		e.preventDefault();
		var $parent = $(this).parents('.mweb-image-wrap');
		$parent.find('img').remove();
		$parent.find('input').val('');
		$(this).addClass('hidden');
	});

	// Bind to my upload butto
	$(document).on('click', '.mw_upload_image_button', function(event) {
		event.preventDefault();
		customUpload($(this));
		return false;
	});

	function customUpload(el) {
		custom_media = true;
		var _orig_send_attachment = wp.media.editor.send.attachment;
		wp.media.editor.send.attachment = function(props, attachment) {
			el = renderUpload(el, attachment, props);
		}
		wp.media.editor.open();
	}
	
	function renderUpload(field, attachment, props) {
		var inputText = field.data("image_id");
		var src = attachment.url;

		var size = props.size;

		if (attachment.sizes[size]) {
			src = attachment.sizes[size].url;
			$( '#'+inputText ).val( src );
			$( '.'+inputText).attr( 'src', src );
			$( '.'+inputText).show();
		}
		
	}
	
	$( ".mw_remove_image_button" ).on( "click", function() {
		var inputText = $(this).data("image_id");
		$( '.'+inputText).hide();
		$( '#'+inputText ).val( '' );
		return false;
	});




})(jQuery);
