<?php

if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('لطفا این صفحه را به طور مستقیم بار نکنید. با تشکر!');

if ( post_password_required() ) {
	_e('این مطلب خصوصی است.در صورتی که رمز آن را دارید در قسمت زیر وارد کنید.', 'mahdisweb');
	return;
}
	
$comments_calback = get_post_type( get_the_ID() ) == 'lp_course' ? 'mweb_course_comments' : 'mweb_layout_comments';

?>


<?php if ( have_comments() ) : ?>
<div class="comments-wrapper">
<div class="block-title no_black"><div class="title"><i class="fal fa-comment-alt-lines"></i>دیدگاه کاربران </div></div>            
<div id="comments" class="comments-area">

    <ul class="comments-list clear">
     <?php wp_list_comments(array(
          'style'			=> 'ul',
          'callback'		=> $comments_calback,
      )); ?>
    
    </ul>
	
<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
	<nav id="comment-nav-above" class="comment-navigation" role="navigation">
		<div class="nav-previous"><?php previous_comments_link( esc_html__( 'دیدگاه های قدیمی &larr;', 'mweb' ) ); ?></div>
		<div class="nav-next"><?php next_comments_link( esc_html__( '&rarr; دیدگاه های جدید', 'mweb' ) ); ?></div>
	</nav>
<?php endif; ?>
		
</div>
</div>

<?php 
	if( get_post_type() == 'lp_course' || get_post_type() == 'lp_lesson' ){
		$mweb_comment_rules = mweb_theme_util::get_theme_option('mweb_comment_rules');
		if($mweb_comment_rules){
			echo '<div class="review_rules">'.nl2br($mweb_comment_rules).'</div>';
		}
	}
?>
<?php endif; //if have_comments ?>



<?php
    // If comments are closed and there are comments, let's leave a little note, shall we?
    if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        ?>
        <p class="no-comments"><?php esc_html_e( 'دیدگاه ها بسته شده.', 'mweb' ); ?></p>
    <?php endif; ?>
	
<?php 

$commenter = wp_get_current_commenter();
$req = get_option( 'require_name_email' );


$form_args = array(
	'id_form'		=> 'comment-reply-form',
	'class_form'	=> 'comment-reply-form',
	'title_reply_before' => '<div class="block-title no_black">',
	'title_reply_after' => '</div>',
	'class_submit'      => 'submit',
	'comment_notes_after' => '',
	'label_submit'		=> __('ارسال','mahdisweb'),
	'title_reply'		=> __('<div class="title"><i class="fal fa-comment-alt-lines"></i>ارسال دیدگاه</div>','mahdisweb'),
	'title_reply_to'	=>  __('ترک ارسال پاسخ به %s','mahdisweb'),
	'comment_field' => '<div class="form-group">
							<textarea id="comment" name="comment" class="form-control" cols="45" placeholder="متن دیدگاه" rows="7" aria-describedby="form-allowed-tags"></textarea>	
						</div>',
						
	'fields' => apply_filters( 'comment_form_default_fields',array(
					'name' =>'<div class="row">
							<div class="col-12 col-sm-6">
								<input class="form-control" placeholder="نام" type="text" name="author" id="author" value="'. esc_attr( $commenter['comment_author'] ) .'">
							</div>',
					'email' =>'										
							<div class="col-12 col-sm-6">
								<input class="form-control" placeholder="ایمیل" type="text" name="email" id="email" value="'. esc_attr( $commenter['comment_author_email'] ) .'" >
							</div></div>',
					
				)
			)
);
comment_form(apply_filters( 'mweb_override_comment_form_args', $form_args )); 					


?>
