var mweb_instagram_popup;
var mweb_popup_pic;
var mweb_popup_day;
var mweb_popup_link;
var mweb_search_history = false;

(function($) {
    "use strict";

    var mweb_theme = {

        window: $(window),
        html: $('html, body'),
        document: $(document),
        body: $('body'),
        direction: '',
        is_mobile: $('body').hasClass('body_ismobile'),
        site_mask: $('.mweb-site-mask'),
        lazyload_instance: '',
        ajax_filter_item_last_width: [],
        ajax: {},
        cart_ajax: null,
        get_rtl: function() {
            return mweb_theme.body.hasClass('rtl');
        },

        document_ready: function() {
			mweb_theme.my_account_modal();
			mweb_theme.search_header();
			mweb_theme.canvas_menu_mobile();
			mweb_theme.go_to_top();
			mweb_theme.init_carousel();
			mweb_theme.init_swiper_slider();
			mweb_theme.init_count_down();
			mweb_theme.single_post_gallery();
			mweb_theme.init_multimedia();
			mweb_theme.redesign_variation_form();
			mweb_theme.instagram_popup_widget();
			mweb_theme.mweb_sticky_cart_box();
			mweb_theme.mweb_nav_to_select();
			mweb_theme.mweb_sticky_header();
			mweb_theme.mweb_init_rating();
			mweb_theme.mweb_init_quantity();
			mweb_theme.mweb_curriculum();
			mweb_theme.ajax_post_like();
			mweb_theme.initslider_realtime();
			mweb_theme.init_element_function();
			
			mweb_theme.get_swiper_slider($('.sl_related'));
			mweb_theme.get_swiper_slider($('.sl_upsell'));
			mweb_theme.get_swiper_slider($('.sl_testimonial'));
			mweb_theme.get_swiper_slider($('.sl_acc'));
			mweb_theme.get_swiper_slider($('.sl_teacher'));

			
			mweb_theme.block_dropdown_filter();
         
            mweb_theme.ajax_data_term();
            mweb_theme.ajax_header_search();
            mweb_theme.ajax_discount_filter();
            mweb_theme.ajax_dropdown_filter();
            mweb_theme.ajax_pagination();
            mweb_theme.ajax_loadmore();
            mweb_theme.ajax_like_dislike();
            mweb_theme.ajax_mega_cat_sub();
            mweb_theme.ajax_wishlist();
			
			mweb_theme.init_wc_tabs();
			
			mweb_theme.mweb_ajax_add_to_cart_multiple();

			 
        },

        document_load: function() {
            mweb_theme.window.load(function() {
				
                mweb_theme.body.addClass('mweb-js-loaded');
				if( mweb_popup_pic ){
					mweb_theme.mweb_popup_init(mweb_popup_pic,mweb_popup_link);
					mweb_theme.createCookie('run_popup',true,mweb_popup_day);
				}
				if( !mweb_theme.readCookie('haed_alert') ){
					$('.header_alert').show();
				}
				
				mweb_theme.init_console_bio();
				
				$("#mpreloader").fadeOut(500);
				
				if ($('.widget_product_categories .product-categories').length) {
					mweb_theme.init_listAccordion('.product-categories');
				}
				
            });
        },

        document_reload: function() {
			$("body *[data-toggle='tooltip']").each(function(){
				$(this).tooltip();
			});
			
			$('.yith-wcwl-add-button .add_to_wishlist, .yith-wcwl-wishlistaddedbrowse a, .yith-wcwl-wishlistexistsbrowse a').each(function(){
				$(this).attr('data-toggle', 'tooltip').attr('data-original-title', $(this).text().trim());
			});
			
			mweb_theme.ajax_view_add();
            mweb_theme.ajax_view_count();
        },

        document_resize: function() {
            mweb_theme.window.resize(function() {

                mweb_theme.calc_small_menu();
                clearTimeout(mweb_theme.resize_timer);
                mweb_theme.resize_timer = setTimeout(function() {
                    mweb_theme.block_dropdown_filter();
                }, 150);
            })
        },
		
		
		update_query_string: function (uri, key, value) {
            var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
            var separator = uri.indexOf('?') !== -1 ? "&" : "?";
            if (uri.match(re)) {
                if ( value == '' ) {
                    return uri.includes('?') ? uri.replace(re, '?') : uri.replace(re, '');
                } else {
                    return uri.replace(re, '$1' + key + "=" + value + '$2');
                }
            } else if ( value != '' ) {
                return uri + separator + key + "=" + value;
            }
        },
		
		//get width of item
        get_width: function(item) {
            return item.width();
        },

		calc_small_menu: function() {
            var small_menu = $('#mweb-small-menu');
            if (small_menu.length > 0) {
                var num_el = small_menu.find('.small-menu-inner').children().length;
                var menu_wrapper = small_menu.parents('.navbar-inner');
                if (menu_wrapper.length > 0) {
                    var wrapper_width = menu_wrapper.width();
                    if (parseInt(wrapper_width) < ( parseInt(num_el) + 1) * 215) {
                        small_menu.addClass('is-fw-small');
                        small_menu.css('width', wrapper_width);
                    } else {
                        small_menu.removeClass('is-fw-small');
                        small_menu.css('width', 'auto');
                    }
                }
            }
        },



        //ajax filter
        block_dropdown_filter: function() {

            var block_ajax_filter_wrap = $('.block-ajax-filter-wrap');
            if (block_ajax_filter_wrap.length > 0) {
                block_ajax_filter_wrap.each(function() {

                    var block_ajax_filter = $(this);
                    var block_ajax_filter_id = block_ajax_filter.attr('id');
                    var dropdown_counter = 1;
                    var list_counter = 1;
                    var header_inner = block_ajax_filter.parent('.block-title');
                    var header_inner_title = header_inner.find('.title');
                    var block_ajax_filter_max_width = mweb_theme.get_width(header_inner) - mweb_theme.get_width(header_inner_title);
                    var block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);

                    if (block_ajax_filter_width > block_ajax_filter_max_width * 0.5) {

                        while ((block_ajax_filter_width > block_ajax_filter_max_width * 0.5) && (dropdown_counter < 200)) {
                            var dropdown_flag = mweb_theme.block_dropdown_filter_add_el(block_ajax_filter);

                            if (0 == dropdown_flag) {
                                break;
                            }
                            block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);
                            dropdown_counter++;
                        }
                    } else {

                        if ('undefined' == typeof mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id]) {
                            mweb_theme.block_filter_hide_more(block_ajax_filter);
                        } else {

                            var ajax_filter_el_last_width = mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id];
                            while ((block_ajax_filter_width + ajax_filter_el_last_width < block_ajax_filter_max_width * 0.6) && (list_counter < 200)) {
                                var list_flag = mweb_theme.block_list_filter_add_el(block_ajax_filter);

                                if (0 == list_flag) {
                                    break;
                                }

                                block_ajax_filter_width = mweb_theme.get_width(block_ajax_filter);
                                list_counter++;
                            }
                        }
                    }

                    //touch action
                    mweb_theme.block_filter_touch_toggle(block_ajax_filter);
                })
            }
        },

        block_dropdown_filter_add_el: function(block_ajax_filter) {
            var block_ajax_filter_id = block_ajax_filter.attr('id');
            var list_ajax_filter = block_ajax_filter.find('.ajax-filter-list');
            var dropdown_ajax_filter = block_ajax_filter.find('.ajax-filter-dropdown-list');
            var list_ajax_filter_last_el = list_ajax_filter.children().last();

            if (list_ajax_filter_last_el.length > 0) {

                mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id] = list_ajax_filter_last_el.width();
                mweb_theme.block_filter_show_more(block_ajax_filter);
                list_ajax_filter_last_el.detach().prependTo(dropdown_ajax_filter);
                return 1;
            } else {
                return 0;
            }
        },

        block_list_filter_add_el: function(block_ajax_filter) {
            var block_ajax_filter_id = block_ajax_filter.attr('id');
            var list_ajax_filter = block_ajax_filter.find('.ajax-filter-list');
            var dropdown_ajax_filter = block_ajax_filter.find('.ajax-filter-dropdown-list');
            var dropdown_ajax_filter_first_el = dropdown_ajax_filter.children().first();

            //add to list
            if (dropdown_ajax_filter_first_el.length > 0) {
                dropdown_ajax_filter_first_el.css('opacity', '.1');
                dropdown_ajax_filter_first_el.detach().appendTo(list_ajax_filter);

                setTimeout(function() {
                    if (dropdown_ajax_filter.children().length == 0) {
                        mweb_theme.block_filter_hide_more(block_ajax_filter)
                    }
                    dropdown_ajax_filter_first_el.css('opacity', '1');
                }, 50);

                mweb_theme.ajax_filter_item_last_width[block_ajax_filter_id] = dropdown_ajax_filter_first_el.width();

                return 1;
            } else {
                return 0;
            }
        },

        //hide if over width
        block_filter_hide_more: function(block_ajax_filter) {
            var block_ajax_filter_btn = block_ajax_filter.find('.ajax-filter-dropdown');
            if (block_ajax_filter_btn.css('display') == 'inline-block') {
                block_ajax_filter_btn.hide();
            }
        },

        block_filter_show_more: function(block_ajax_filter) {
            var block_ajax_filter_btn = block_ajax_filter.find('.ajax-filter-dropdown');
            if (block_ajax_filter_btn.css('display') == 'none') {
                block_ajax_filter_btn.show(350);
            }
        },

        block_filter_touch_toggle: function(block_ajax_filter) {
            if (true === mweb_theme.touch) {
                var dropdown = block_ajax_filter.find('.ajax-filter-dropdown');
                dropdown.addClass('is-touch');
                dropdown.on('click touch', function() {
                    dropdown.toggleClass('touch-active');
                });
            }
        },


        ajax_cache: {

            //set data
            data: {},

            get: function(id) {
                return mweb_theme.ajax_cache.data[id];
            },
            set: function(id, data) {
                mweb_theme.ajax_cache.remove(id);
                mweb_theme.ajax_cache.data[id] = data;
            },
            remove: function(id) {
                delete mweb_theme.ajax_cache.data[id];
            },
            exist: function(id) {
                return mweb_theme.ajax_cache.data.hasOwnProperty(id) && mweb_theme.ajax_cache.data[id] !== null;
            }
        },

        ajax_data_term: function() {
            $('.mweb-block-wrap').each(function() {
                var block = $(this);
                var block_id = block.attr('id');

                if ('undefined' != typeof block_id) {
                    mweb_theme.ajax[block_id + '_category_id'] = block.data('category_id');
                    mweb_theme.ajax[block_id + '_category_ids'] = block.data('category_ids');
                    mweb_theme.ajax[block_id + '_tags'] = block.data('tags');
                    mweb_theme.ajax[block_id + '_orderby'] = block.data('orderby');
                }

                mweb_theme.ajax_pagination_check(block);
                mweb_theme.ajax_loadmore_check(block);
                mweb_theme.ajax_infinite_scroll_check(block);
            })
        },

        ajax_reinitiate_function: function() {

            mweb_theme.html.off();
            mweb_theme.document.off();
            mweb_theme.window.trigger('load');
            mweb_theme.document_reload();
        },

        
		add_notice : function ($message, $content, className){ 
		
			if ( !$.fn.notify ) {
				return;
			}
			
			$.notify.addStyle('mweb', {
				html: '<div>' + $message + '</div>'
			});
			$.notify($content, {
				autoHideDelay: 3000,
				className: className,
				style: 'mweb',
				showAnimation: 'fadeIn',
				hideAnimation: 'fadeOut',
				position: 'left',
				globalPosition: 'bottom center',
			});

		},
		
		

        ajax_header_search: function() {

            var delay = (function() {
                var timer = 0;
                return function(callback, ms) {
                    clearTimeout(timer);
                    timer = setTimeout(callback, ms);
                };
            })();

            $('.search-field').each(function(){
				
				var search_input = $(this);
				var search_result_wrapper = search_input.parents('form').find('.ajax-search-result');
				var search_clear = search_input.parents('form').find('.search_clear');
				var category = search_input.parents('form').find('input[name="cat_id"]');
				
				search_input.keyup(function() {
					var param = $(this).val();

					delay(function() {
						if (param.length > 1) {
							search_clear.addClass('go_in');
							search_result_wrapper.fadeIn(300).html('<div class="ajax-loader"></div>');
							if(search_input.closest('.search_overlay').length < 1)
								mweb_theme.body.addClass('search_mask');
							var my_data = {
								action: 'mweb_theme_ajax_search',
								cat_id: category.val(),
								s: param
							};
							/* $.post(mweb_ajax_url, data, function(data_response) {
								search_result_wrapper.hide().empty().html(data_response).fadeIn(300);		
							}); */
							$.ajax({
								type: 'POST',
								url: mweb_ajax_url,
								dataType: 'html',
								data: my_data,
								success: function(response) {
									search_result_wrapper.hide().empty().html(response).fadeIn(300);	
									//mweb_theme.add_search_history(param);
								}
							});
				
						} else{
							search_clear.removeClass('go_in');
							search_result_wrapper.fadeOut(300, function() {
								$(this).empty();
								mweb_theme.body.removeClass('search_mask');
							});
						}  

					}, 1000);
				});
				
				search_clear.click(function() {
					$(this).removeClass('go_in');
					search_input.val('');
					search_result_wrapper.fadeOut(300, function() {
						$(this).empty();
						mweb_theme.body.removeClass('search_mask');
					});
				});
			
				$( ".search_category li" ).click(function() {
					$( ".search_category li" ).removeClass('current');
					$(this).addClass('current');
					category.val($(this).data('id'));
					if($('.el_cat_title').length > 0){
						$('.el_cat_title').text($(this).text());
					}
					$(this).parent('.search_category').removeClass('active');
				});
				
				$( ".mweb-site-mask" ).click(function() {
					if(mweb_theme.body.hasClass('search_mask')){
						search_input.val('');
						search_clear.removeClass('go_in');
						mweb_theme.body.removeClass('search_mask');
						search_result_wrapper.empty().fadeOut(100);
					}
				});
			
			
			});

			
			
			$( ".more_search_btn" ).click(function() {
				$(this).parents('form').submit();
			});
			
			$( ".btn_search_cat" ).click(function() {
				$(this).parent('.search_category').addClass('active');
			});
			
			 mweb_theme.document.on('click', function (e) {
				if (!$(e.target).is('.btn_search_cat') && !$(e.target).is('.search_category ul') && $('.search_category ul').length > 0) {
					$('.search_category').removeClass('active');
				}
			});
			
			/* search_input.on('click', function () {
             
                var search_form = $(this).closest('#ajax-form-search');
                var searchresults = search_form.find('.ajax_search_list');
                if ( searchresults.find('.post_with_thumb').length < 1 && mweb_search_history ) {
					
                    var histories = mweb_theme.get_search_history( '', false ),
                        history_length = ( typeof histories == 'undefined' ) ? 0 : ( histories.length >= 4 ? 4 : histories.length );                    
					if ( history_length != 0 && search_result_wrapper.find( '.search_history' ).length < 1  ) {
						if(search_input.closest('.search_overlay').length < 1)
							mweb_theme.body.addClass('search_mask');
						search_result_wrapper.fadeIn(300);	
						search_result_wrapper.append('<div class="search_history"><i class="fal fa-history"></i>تاریخچه جستجوهای شما<div class="history_list"></div></div>');
						var histories_link = '',
							hostname = search_form.attr('action'),
							post_type = $(this).parents('form').find("input[name='post_type']").val();

						for ( var i=0; i < history_length; ++i ) {
							var url = mweb_theme.update_query_string( hostname, 's', histories[i] );
							url = mweb_theme.update_query_string( url, 'post_type', post_type);
							histories_link += '<a href="' + url +'">' + histories[i] + '</a>';
						}
						
						if ( search_result_wrapper.find( '.search_history' ).length > 0 ) {
							search_result_wrapper.find('.history_list').html( histories_link );
						}
					}
                }

            }); */

        },
		
		
		add_search_history: function( search ) {
            if ( search == 'undefined' ) {
                return;
            }
            var history = Cookies.get('search-history');
            if ( history != '' ) {
                if ( ! mweb_theme.get_search_history( search, true ) ) {
                    history = history + '|' + search;
                }
            } else {
                history = search;
            }
            Cookies.set( 'search-history', history, { expires: 30 } );
            return;
        },
		
		
        get_search_history: function ( search, same = false ) {
      
            var history = Cookies.get('search-history');
                var result = [];
                if( history == '' || typeof history == 'undefined' ) {
                    return;
                }

                var histories = history.split('|');
                // if search is empty return latest 4 history
                if ( search == '' ) {
                    var loop_num = histories.length >= 4 ? ( histories.length - 4 ) : 0; 
                    for ( var i = histories.length - 1; i >= loop_num; --i ) {
                        if ( histories[i] != 'undefined' ) {
                            result.push( histories[i] );
                        }
                    } 
                } else {
                    if ( same == true ) {
                        for(var i = 0; i < histories.length; ++i){
                            if ( histories[i] == search ) {
                                return true;
                            } 
                        }
                        return false;
                    }
                    for(var i = 0; i < histories.length; i++){
                        if ( histories[i].includes(search) ) {
                            if ( histories[i] != 'undefined' ) {
                                result.push(histories[i]);
                            }
                        }
                    }
                }

                return result;
        },


        ajax_block_data: function(block) {
            var param = {};
            param.block_id = block.data('block_id');
            param.block_name = block.data('block_name');
            param.post_type = block.data('post_type');
            param.my_column = block.data('column');
            param.posts_per_page = block.data('posts_per_page');
            param.ajax_dropdown = block.data('ajax_dropdown');
            param.block_page_max = block.data('block_page_max');
            param.block_page_current = block.data('block_page_current');
            param.category_id = block.data('category_id');
            param.category_ids = block.data('category_ids');
            param.orderby = block.data('orderby');
            param.authors = block.data('authors');
            param.tags = block.data('tags');
            param.post_format = block.data('post_format');
            param.offset = block.data('offset');
            param.excerpt = block.data('excerpt');
            param.excerpt_classic = block.data('excerpt_classic');
            param.block_style = block.data('block_style');
            param.thumb_position = block.data('thumb_position');
            param.summary_type = block.data('summary_type');
            param.array_range = block.data('array_range');
            param.cat_info = block.data('cat_info');
            param.meta_info = block.data('meta_info');

            return param;
        },
		
		
		// ajax discount filter
        ajax_discount_filter: function() {

            $('.discount_percent li').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var filter_link = $(this);
                var block = filter_link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');
				var var_option = $('.discount_num').find('option:selected');
				var block_perpage = var_option.val();

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }


                var filter_link_val = filter_link.attr('id');
                mweb_theme.ajax[block_id + '_processing'] = true;

                //disable other link
                block.find('.discount_percent li').removeClass('active');
                block.find('.discount_percent li').not(this).addClass('disable');
                filter_link.addClass('active');


                mweb_theme.ajax_animation_start(block);

                var param = mweb_theme.ajax_block_data(block);

				param.array_range = filter_link_val;
                block.data('array_range', filter_link_val);
				param.posts_per_page = block_perpage;
				block.data('posts_per_page', block_perpage);

				
                setTimeout(function() {
                    mweb_theme.ajax_discount_filter_process(block, param);
                }, 500);

            });
        },
		
		
		
		
		//request ajax discount
        ajax_discount_filter_process: function(block, param) {

            var param_cache = param;
            delete param_cache.block_page_max;
            var cache_id = JSON.stringify(param_cache);

            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_max) {
                    block.data('block_page_max', data.block_page_max);
                }

                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_ajax_discount',
                    data: param
                },
                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_max) {
                        block.data('block_page_max', data.block_page_max);
                    }
                    mweb_theme.ajax_cache.set(cache_id, data);
                    mweb_theme.ajax_animation_end(block, data.content);
                }
            });
        },
		

		
        // ajax dropdown filter
        ajax_dropdown_filter: function() {

            $('.ajax-filter-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var filter_link = $(this);
                var block = filter_link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }

                var filter_link_val = filter_link.data('ajax_filter_val');
                mweb_theme.ajax[block_id + '_processing'] = true;

                //disable other link
                block.find('.ajax-link').removeClass('is-active');
                block.find('.ajax-link').not(this).addClass('is-disable');
                filter_link.addClass('is-active');

                if (true === mweb_theme.touch) {
                    var dropdown = filter_link.parents('.ajax-filter-dropdown');
                    dropdown.removeClass('touch-active');
                }

                mweb_theme.ajax_animation_start(block);

                var param = mweb_theme.ajax_block_data(block);
                mweb_theme.ajax_dropdown_reset_param(block, param, filter_link_val);
                setTimeout(function() {
                    mweb_theme.ajax_dropdown_filter_process(block, param);
                }, 500);
            });
        },

        //reset param when filter
        ajax_dropdown_reset_param: function(block, param, filter_link_val) {

            param.block_page_current = 1;

            block.data('block_page_current', 1);
            var block_id = block.attr('id');

            if ('category' == param.ajax_dropdown) {

                if ('undefined' == typeof (mweb_theme.ajax[block_id + '_category_id'])) {
                    mweb_theme.ajax[block_id + '_category_id'] = 0;
                }

                if (0 == filter_link_val) {
                    param.category_id = mweb_theme.ajax[block_id + '_category_id'];
                    param.category_ids = mweb_theme.ajax[block_id + '_category_ids'];

                    block.data('category_id', mweb_theme.ajax[block_id + '_category_id']);
                    block.data('category_ids', mweb_theme.ajax[block_id + '_category_ids']);

                } else {

                    param.category_id = filter_link_val;
                    param.category_ids = 0;

                    block.data('category_id', filter_link_val);
                    block.data('category_ids', 0);
                }
            }

            if ('tag' == param.ajax_dropdown) {
                param.tags = filter_link_val;
                block.data('tags', filter_link_val);
            }

            if ('author' == param.ajax_dropdown) {
                param.authors = filter_link_val;
                block.data('authors', filter_link_val);
            }

            if ('popular' == param.ajax_dropdown) {

                block.data('orderby_term', block.data('orderby'));

                if ('featured' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'featured_product';
                    block.data('tags', '');
                    block.data('orderby', 'featured_product');
                }

                if ('best_selling' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'best_selling';
                    block.data('orderby', 'best_selling');
                    block.data('tags', '');
                }

                if ('top_rate' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'top_rate';
                    block.data('orderby', 'top_rate');
                    block.data('tags', '');
                }
				
				if ('on_sale' == filter_link_val) {
                    param.tags = null;
                    param.orderby = 'on_sale';
                    block.data('orderby', 'on_sale');
                    block.data('tags', '');
                }
				
                if (0 == filter_link_val) {
                    param.tags = mweb_theme.ajax[block_id + '_tags'];
                    param.orderby = mweb_theme.ajax[block_id + '_orderby'];
                    if ('undefined' == typeof mweb_theme.ajax[block_id + '_tags']) {
                        block.data('tags', '');
                    } else {
                        block.data('tags', mweb_theme.ajax[block_id + '_tags']);
                    }
                    block.data('orderby', mweb_theme.ajax[block_id + '_orderby']);
                }
            }
        },

        //request ajax dropdown
        ajax_dropdown_filter_process: function(block, param) {

            var param_cache = param;
            delete param_cache.block_page_max;
            var cache_id = JSON.stringify(param_cache);

            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_max) {
                    block.data('block_page_max', data.block_page_max);
                }

                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_theme_ajax_filter_data',
                    data: param
                },
                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_max) {
                        block.data('block_page_max', data.block_page_max);
                    }
					
                    mweb_theme.ajax_cache.set(cache_id, data);
                    //mweb_theme.ajax_animation_end(block, data.content);
					block.find('.ajax-link').removeClass('is-disable');
					block.find('.ajax-filter-more').removeClass('is-disable');

					var block_id = block.attr('id');
					var content_wrap = block.find('.block-content-wrap');
					var content_inner = content_wrap.find('.block-content-inner');

					content_wrap.find('.ajax-loader').remove();
					content_inner.stop();
					content_inner.html(data.content);

					content_inner.fadeTo(500, 1, function() {
					});

					content_inner.removeClass('is-overflow');
					mweb_theme.ajax[block_id + '_processing'] = false;
					
                }
            });
        },
		
		
		


        ajax_animation_start: function(block) {

            var content_wrap = block.find('.block-content-wrap');
            var content_inner = content_wrap.find('.block-content-inner');
            var content_inner_height = content_inner.outerHeight();

            //add height for ajax
            content_inner.css('height', content_inner_height);

            //hide content
            content_inner.stop();
            $('.ajax-loader').remove();
            content_wrap.prepend('<div class="ajax-loader">');
            content_inner.addClass('is-overflow');
            content_inner.fadeTo('500', 0.05, 'easeInOutCubic');
        },


        //add animation and append
        ajax_animation_end: function(block, content) {

            block.delay(100).queue(function() {

                block.find('.ajax-link').removeClass('is-disable');
                block.find('.ajax-filter-more').removeClass('is-disable');

                var block_id = block.attr('id');
                var content_wrap = block.find('.block-content-wrap');
                var content_inner = content_wrap.find('.block-content-inner');

                content_wrap.find('.ajax-loader').remove();
                //content_inner.stop();
                content_inner.html(content);

                content_inner.fadeTo(500, 1, function() {
                });

                content_inner.removeClass('is-overflow');

                if (block.hasClass('block-mega-menu')) {
                    setTimeout(function() {
                        content_inner.css('height', 'auto');
                    }, 250);
                } else {
                    setTimeout(function() {
                        content_inner.css('height', 'auto');
                    }, 100);
                }

                mweb_theme.ajax[block_id + '_processing'] = false;
                mweb_theme.ajax_pagination_check(block);
                mweb_theme.ajax_loadmore_check(block);
                mweb_theme.ajax_infinite_scroll_check(block);

                block.dequeue();
            });
        },


        // ajax pagination next prev
        ajax_pagination: function() {

            $('.ajax-pagination-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var link = $(this);
                var block = link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');

                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }
                mweb_theme.ajax[block_id + '_processing'] = true;

                block.find('.ajax-link').addClass('is-disable');
                block.find('.ajax-filter-more').addClass('is-disable');

                var pagination_link_val = link.data('ajax_pagination_link');
                var param = mweb_theme.ajax_block_data(block);
                mweb_theme.ajax_animation_start(block);
                setTimeout(function() {
                    mweb_theme.ajax_pagination_process(block, param, pagination_link_val);
                }, 200);
            });
        },

        ajax_pagination_process: function(block, param, pagination_link_val) {

            var page_current = param.block_page_current;
            if ('prev' == pagination_link_val) {
                --page_current;
            } else {
                ++page_current
            }

            param.block_page_next = page_current;

            var param_cache = param;
            delete param_cache.block_page_max;
            param_cache.block_page_current = page_current;

            var cache_id = JSON.stringify(param_cache);
            if (mweb_theme.ajax_cache.exist(cache_id)) {
                var data = mweb_theme.ajax_cache.get(cache_id);
                if ('undefined' != data.block_page_current) {
                    block.data('block_page_current', data.block_page_current);
                }
                mweb_theme.ajax_animation_end(block, data.content);
                return false;
            }

            $.ajax({
                type: 'POST',
                url: mweb_ajax_url,
                data: {
                    action: 'mweb_theme_pagination_data',
                    data: param
                },

                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.block_page_current) {
                        block.data('block_page_current', data.block_page_current);
                    }
                    mweb_theme.ajax_cache.set(cache_id, data);
                    mweb_theme.ajax_animation_end(block, data.content);
                }
            });
        },

        ajax_pagination_check: function(block) {

            var param = mweb_theme.ajax_block_data(block);

            if (param.block_page_max < 2) {
                block.find('.ajax-pagination-link').addClass('is-disable');
            }

            if (param.block_page_current >= param.block_page_max) {
                block.find('.ajax-next').addClass('is-disable');
            }

            if (param.block_page_current <= 1) {
                block.find('.ajax-prev').addClass('is-disable');
            }
        },


        ajax_loadmore: function() {
            $('.ajax-loadmore-link').off('click').on('click', function(e) {

                e.preventDefault();
                e.stopPropagation();

                var link = $(this);
                var block = link.parents('.mweb-block-wrap');
                var block_id = block.attr('id');
                if (true == mweb_theme.ajax[block_id + '_processing']) {
                    return;
                }
                var param = mweb_theme.ajax_block_data(block);
                if (param.block_page_current >= param.block_page_max) {
                    return;
                }
                mweb_theme.ajax[block_id + '_processing'] = true;
                var animation = link.next('.ajax-animation');
                link.animate({ opacity: 0 }, 200);
                setTimeout(function() {
                    animation.css({ 'display': 'block' });
                    animation.css({ 'visibility': 'visible' });
                    animation.delay(200).animate({ opacity: 1 }, 200);
                }, 100);
                setTimeout(function() {
                    mweb_theme.ajax_loadmore_process(block, param);
                }, 200);
            })
        },

        ajax_loadmore_process: function(block, param) {

            var block_id = block.attr('id');
            var page_current = param.block_page_current;
            var page_next = ++page_current;

            param.block_page_next = page_next;
            if (page_next <= param.block_page_max) {

                $.ajax({
                    type: 'POST',
                    url: mweb_ajax_url,
                    data: {
                        action: 'mweb_theme_pagination_data',
                        data: param
                    },

                    success: function(data) {

                        data = $.parseJSON(data);

                        if ('undefined' != data.block_page_current) {
                            block.data('block_page_current', data.block_page_current);
                        }

                        block.find('.block-content-inner').append(data.content);
                        mweb_theme.ajax[block_id + '_processing'] = false;

                        setTimeout(function() {
                            mweb_theme.ajax_reinitiate_function();
                        }, 50);

                        if (data.block_page_current < param.block_page_max) {
                            var animation = block.find('.ajax-animation');
                            animation.css({ 'display': 'none' });
                            animation.css({ 'visibility': 'hidden' });
                            animation.css({ 'opacity': 0 });
                            block.find('.ajax-loadmore-link').delay(100).animate({ opacity: 1 }, 200);
                        } else {
                            block.find('.ajax-loadmore-link').hide();
                            block.find('.ajax-animation').hide();
                        }
                    }
                });
            }
        },

        ajax_loadmore_check: function(block) {

            var param = mweb_theme.ajax_block_data(block);
            if (param.block_page_current >= param.block_page_max || param.block_page_max <= 1) {
                block.find('.ajax-loadmore-link').hide();
                block.find('.ajax-animation').hide();
            } else {
                block.find('.ajax-loadmore-link').css('opacity', 1);
                block.find('.ajax-loadmore-link').show();
            }
        },

        //ajax pagination infinite scroll
        ajax_infinite_scroll: function() {

            var infinite_scroll = $('.ajax-infinite-scroll');
            if (infinite_scroll.length > 0) {

                infinite_scroll.each(function() {
                    var infinite_scroll_el = $(this);

                    if (!infinite_scroll_el.hasClass('is-disable')) {

                        var animation = infinite_scroll_el.find('.ajax-animation');
                        var block = infinite_scroll_el.parents('.mweb-block-wrap');
                        var block_id = block.attr('id');

                        if (infinite_scroll_el.length > 0) {
                            mweb_theme.waypoint_item['infinite_scroll'] = new Waypoint({
                                element: infinite_scroll_el,
                                handler: function(direction) {
                                    if ('down' == direction) {

                                        var param = mweb_theme.ajax_block_data(block);

                                        if (param.block_page_current >= param.block_page_max) {
                                            infinite_scroll_el.addClass('is-disable');
                                            return;
                                        }

                                        if (true == mweb_theme.ajax[block_id + '_processing']) {
                                            return;
                                        }

                                        mweb_theme.ajax[block_id + '_processing'] = true;

                                        setTimeout(function() {
                                            animation.css({ 'display': 'block' });
                                            animation.css({ 'visibility': 'visible' });
                                            animation.animate({ opacity: 1 }, 200);
                                        }, 100);

                                        setTimeout(function() {
                                            mweb_theme.ajax_loadmore_process(block, param);
                                            mweb_theme.waypoint_item['infinite_scroll'].destroy();
                                        }, 200);
                                    }
                                },
                                offset: '99%'
                            })
                        }
                    }
                });
            }
        },

        ajax_infinite_scroll_check: function(block) {
            var param = mweb_theme.ajax_block_data(block);
            if (param.block_page_current >= param.block_page_max || param.block_page_max <= 1) {
                block.find('.ajax-infinite-scroll').addClass('is-disable');
            } else {
                block.find('.ajax-infinite-scroll').removeClass('is-disable');
            }
        },

        ajax_mega_cat_sub: function() {

            var hover_timer;
            var cat_sub = $('.mega-category-menu .menu-item');

            cat_sub.hover(function(event) {
                event.stopPropagation();
                cat_sub = $(this);
                cat_sub.addClass('is-current-sub').siblings().removeClass('is-current-sub current-menu-item');
                var wrapper = cat_sub.parents('.mega-category-menu');
                var block = wrapper.find('.block-mega-menu-sub');
                hover_timer = setTimeout(function() {
                    mweb_theme.ajax_cat_sub_process(cat_sub, block);
                }, 200);
            }, function() {
                clearTimeout(hover_timer);
            });
        },

        ajax_cat_sub_process: function(cat_sub, block) {

            var block_id = block.attr('id');
            if (true == mweb_theme.ajax[block_id + '_processing']) {
                return;
            }
            mweb_theme.ajax[block_id + '_processing'] = true;

            var param = mweb_theme.ajax_block_data(block);
            param.category_id = cat_sub.data('mega_sub_filter');
            param.block_page_current = 1;
            param.block_name = 'mweb_theme_mega_block_cat_sub';
            param.posts_per_page = 4;

            block.data('category_id', param.category_id);
            block.data('block_page_current', param.block_page_current);

            mweb_theme.ajax_animation_start(block);
            setTimeout(function() {
                mweb_theme.ajax_dropdown_filter_process(block, param);
            }, 200);
        },
		
		
		
        //ajax view
        ajax_view_count: function() {
            if (mweb_theme.body.hasClass('is-ajax-view')) {
                var ajax_view = $('.mweb-ajax-view');
                if (ajax_view.length > 0) {
                    ajax_view.each(function() {
                        var ajax_view_el = $(this);
                        var post_id = ajax_view_el.data('post_id');
                        ajax_view_el.css('width', ajax_view_el.width());
                        $.ajax({
                            type: 'POST',
                            url: mweb_ajax_url ,
                            data: {
                                action: 'mweb_theme_ajax_view_get',
                                post_id: post_id
                            },
                            success: function(data) {
                                data = $.parseJSON(data);
                                ajax_view_el.html(data);
                                ajax_view_el.css('width', 'auto');
                                ajax_view_el.removeClass('is-invisible');
                            }
                        });
                    })
                }
            }
        },

        //add post view
        ajax_view_add: function() {
            if (mweb_theme.body.hasClass('is-ajax-view')) {
                var ajax_view = $('.mweb-ajax-view-add');
                if (ajax_view.length > 0) {
                    ajax_view.each(function() {
                        var ajax_view_el = $(this);
                        var post_id = ajax_view_el.data('post_id');
                        $.ajax({
                            type: 'POST',
                            url: mweb_ajax_url ,
                            data: {
                                action: 'mweb_theme_ajax_view_add',
                                post_id: post_id
                            },
                            success: function(data) {
                                ajax_view_el.removeClass('mweb-ajax-view-add');
                            }
                        });
                    })
                }
            }
        } ,
		
		mweb_setCookie: function(cname, cvalue, exdays) {
			var d = new Date();
			d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
			var expires = "expires=" + d.toUTCString();
			document.cookie = cname + "=" + cvalue + "; " + expires;
		},

		mweb_getCookie: function(cname) {
			var name = cname + "=";
			var ca = document.cookie.split(';');
			for(var i=0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1,c.length);
					if (c.indexOf(name) == 0)
						return c.substring(name.length,c.length);

			}
			return null;
		},
		
		
		ajax_post_like: function() {

			var ajax_flag = 0;
			$('.btn_like').off('click').on('click', function(e) {				
				e.preventDefault();
				if ( ajax_flag == 0 ) {
					var mweb_this = $(this);
					var mweb_id = mweb_this.data('id');
					var mweb_cookie = mweb_theme.mweb_getCookie('like_' + mweb_id);
					if ( mweb_cookie == null ) {
						$.ajax({
							type: 'post',
							url: mweb_ajax_url,
							dataType: "json",
							data: {
								post_id: mweb_id,
								action: 'post_like',
								_wpnonce: admin_ajax_nonce
							},
							beforeSend: function (xhr) {
								ajax_flag = 1;
								mweb_this.addClass('loading');
							},
							success: function (res) {
								ajax_flag = 0;
								if (res.success) {
									var cookie_name = 'like_' + mweb_id;
									mweb_theme.mweb_setCookie(cookie_name, 1, 7);
									mweb_this.find('.count').text(res.data.count);
								}
								mweb_this.removeClass('loading');
							},
							error: function() {
								mweb_this.removeClass('loading');
							}

						});
					}
				}
				
			});
		},
		
		
		ajax_like_dislike: function() {
			var ajax_flag = 0;
				$('.like_dislike_btn').off('click').on('click', function(e) {
				e.preventDefault();
				if (ajax_flag == 0) {
					var restriction = $(this).data('restriction');
					var comment_id = $(this).data('comment-id');
					var trigger_type = $(this).data('trigger-type');
					var selector = $(this);
					var mweb_cookie = mweb_theme.mweb_getCookie('mweb_' + comment_id);
					var current_count = $(this).data('counter');
					var new_count = parseInt(current_count) + 1;
					var ip_check = $(this).attr('data-ip-check');
					var user_check = $(this).attr('data-user-check');
					
					
					var like_dislike_flag = 1;
					if (restriction == 'cookie' &&  mweb_cookie !== null) {
						like_dislike_flag = 0;

					}
					if (restriction == 'ip' && ip_check == '1') {
						like_dislike_flag = 0;

					}
					if(restriction == 'user' && user_check == '1'){
						like_dislike_flag = 0;
					}
					if (like_dislike_flag == 1) {
						$.ajax({
							type: 'post',
							url: mweb_ajax_url,
							data: {
								comment_id: comment_id,
								action: 'mweb_like_dislike_action',
								type: trigger_type,
								_wpnonce: admin_ajax_nonce
							},
							beforeSend: function (xhr) {
								ajax_flag = 1;
								selector.attr('data-counter',new_count);
							},
							success: function (res) {
								ajax_flag = 0;
								res = $.parseJSON(res);
								if (res.success) {
									if (restriction == 'ip') {
										selector.attr('data-ip-check', 1);
									}
									if (restriction == 'user') {
										selector.parent('.like_dislike_wrap').find('a').attr('data-user-check', 1);
									}
									var cookie_name = 'mweb_' + comment_id;
									mweb_theme.mweb_setCookie(cookie_name, 1, 365);
									var latest_count = res.latest_count;
									selector.attr('data-counter',latest_count);
								}
							}

						});
					}
				}
				
			});
		},
		
		ajax_wishlist: function() {
			
			$('.add_to_wishlist').off('click').on('click', function(e) {				
				var el_btn = $(this);
				if(el_btn.hasClass('user_logged') && !el_btn.parent().hasClass('added')){
					e.preventDefault();
					
					var p_id = el_btn.data('product-id');
					var p_action = el_btn.data('action');
					$.ajax({
						type: 'post',
						url: mweb_ajax_url,
						data: {
							action: 'mweb_wishlist_action',
							type: p_action,
							product_id : p_id,
							security_nonce : admin_ajax_nonce 
						}, 
						beforeSend: function (xhr) {
							el_btn.parent().addClass('loading');
						},
						success: function (res) {
							if ( res.success ) {
								if( p_action == 'wl_add' ){
									el_btn.parent().removeClass('loading').addClass('added');
									el_btn.attr('data-original-title', 'مشاهده علاقه مندی ها');
									if(el_btn.hasClass('single_add_to_wishlist'))
										el_btn.text('مشاهده علاقه مندی ها');
									el_btn.attr('href', res.data.url);
									if($('#wl_count').length > 0){
										$('#wl_count').text(parseInt(res.data.count));
									}
								}else if( p_action == 'wl_remove' ){
									el_btn.closest( ".item" ).remove();
								}
								
							}else{
								el_btn.parent().removeClass('loading');
								if( p_action == 'wl_add' ){
									el_btn.attr('data-original-title', 'خطا در عملیات');
								}else if(p_action == 'wl_remove'){
									el_btn.text('خطا');
									setTimeout(function() {
										el_btn.text('تلاش دوباره');
									}, 200);
								}
							}
						}

					});
					
				}else{
					$('html,body').animate({scrollTop:0},'slow');
					el_btn.attr('data-original-title', 'ابتدا ورود کنید');
					//$('.login_user_btn').trigger( "click" )
				}				
			});
			
		},
		
		initslider_realtime: function () {
			$(".owl-realtime").owlCarousel({
				items: 1,
				loop: true,
				rtl:true ,
				autoplay: true,
				dots: false,
				onInitialized: mweb_theme.startProgressBar,
				onTranslate: mweb_theme.resetProgressBar,
				onTranslated: mweb_theme.startProgressBar
			});
		},

		startProgressBar: function () {
			$(".slide-progress").css({
				width: "100%",
				transition: "width 5000ms"
			});
		},

		resetProgressBar: function () {
			$(".slide-progress").css({
				width: 0,
				transition: "width 0s"
			});
		},
		
		
		my_account_modal: function() {
			if( mweb_acc_digits ){
				return false;
			}
			var acc_form = $('.account_action');
			var mask_overlay = $('.mweb-site-mask');
			$('span.login_user_btn').on('click',function(){
				mask_overlay.addClass('active');
				acc_form.addClass('active');
				acc_form.find('.acc_div').hide();
				$('.login_form').show();
			});
			$('span.singup_user_btn').on('click',function(){
				mask_overlay.addClass('active');
				acc_form.addClass('active');
				acc_form.find('.acc_div').hide();
				$('.register_form').show();
			});
			
			$('.mweb-site-mask , .close_modal').on('click',function(){
				acc_form.removeClass('active');
				mask_overlay.removeClass('active');
			});
        },
		
		
		search_header: function() {
			
			$('.m_search').on('click',function(e){
				e.preventDefault();
				$('.search_wrap').toggleClass('active');
				if($('.search_wrap').hasClass('active')){
					$(this).find('i').removeClass('fa-search').addClass('fa-times');
				}else{
					$(this).find('i').removeClass('fa-times').addClass('fa-search');
				}
			});
			
			$('.hs_search_btn').click(function() {
				$('.search_overlay').addClass('active');
				mweb_theme.site_mask.addClass('active');
				
			});
			
			$('.search_toggle').click(function() {
				$('.search_overlay').removeClass('active');
				mweb_theme.site_mask.removeClass('active');
			});
			
        },
		
		
		canvas_menu_mobile: function() {
			var mweb_off_canvas_button = $('#mweb-trigger');
			var mweb_off_canvas_button_close = $('#mweb-close-off-canvas');
			var mweb_mask = $('.mweb-site-mask');

			mweb_off_canvas_button.click(function() {
				mweb_theme.body.toggleClass('mobile-js-menu');
				return false;
			});

			mweb_off_canvas_button_close.click(function() {
				mweb_theme.body.removeClass('mobile-js-menu');
				return false;
			});

			mweb_mask.click(function() {
				mweb_theme.body.removeClass('mobile-js-menu');
				return false;
			});


			var mobile_menu = $('.mobile-menu-wrap');
			var sub_mobile_menu = mobile_menu.find('li.menu-item-has-children');
			var sub_mobile_a = mobile_menu.find('li.menu-item-has-children > a');

			sub_mobile_a.append('<i class="explain-menu fal fa-angle-left"></i>');

			$('.explain-menu').off('click').on('touchend click', function(e) {
				e.preventDefault();
				$(this).parent('a').toggleClass('active').siblings('ul').slideToggle(500);
			});

			sub_mobile_menu.find('a').click(function(event) {
				event.stopPropagation();
			});

			mobile_menu.click(function(event) {
				event.stopPropagation();
			});
			
        },
		
		
		go_to_top: function() {
			$('.gototop').click(function(){
				$('html,body').animate({scrollTop:0},'slow');return false;
			});	
        },
		
		
		init_carousel: function() {
			$('.mw-owl-carousel').each(function() {
				
				var this_owl = $(this);
				
				var config = $(this).data();
				
				if( typeof config !== 'undefined' && !this_owl.hasClass('owl-loaded') ){

					config.navText = ['<i class="fal fa-angle-left"></i>', '<i class="fal fa-angle-right"></i>'];
					var animateOut = $(this).data('animateout');
					var animateIn = $(this).data('animatein');

					if (typeof animateOut != 'undefined') {
						config.animateOut = animateOut;
					}
					if (typeof animateIn != 'undefined') {
						config.animateIn = animateIn;
					}
			
					this_owl.owlCarousel(config);
					
					/* $(this).find('.owl-item').removeClass('last-item');
					$(this).find('.owl-item.active').last().addClass('last-item');

					var t = $(this);
					owl.on('changed.owl.carousel', function(event) {
						var item = event.item.index;
						t.find('.owl-item').removeClass('last-item');
						setTimeout(function() {
							t.find('.owl-item.active').last().addClass('last-item');
						}, 100);
					}); */
					
					if ( config.nav == true ) {
						var this_bk_title = this_owl.parents('.mweb-block-wrap').find('.block-title');
						if (this_bk_title.length) {
							this_bk_title.append('<div class="owl-nav"><div class="owl-prev"><i class="fal fa-angle-left"></i></div><div class="owl-next"><i class="fal fa-angle-right"></i></div></div>');
							this_bk_title.find('.owl-prev').click(function() {
								this_owl.trigger('next.owl.carousel');
							});
							this_bk_title.find('.owl-next').click(function() {
								this_owl.trigger('prev.owl.carousel');
							});
						}
					}
				
				}

			});
		},
		
		
		init_count_down: function(){
			if($('.product-date').length > 0){
				$('.product-date').each(function(i,item){
				  var date = $(item).attr('data-date');
				  $(item).countdown(date).on('update.countdown', function(event) {
					  var $this = $(this).html(event.strftime(''
						+ '<div class="day"><span class="no">%D</span><span class="text">روز</span></div>'
						+ '<div class="hours"><span class="no">%H</span><span class="text">ساعت</span></div>'
						+ '<div class="min"><span class="no">%M</span><span class="text">دقیقه</span></div>'
						+ '<div class="second"><span class="no">%S</span><span class="text">ثانیه</span></div>'));
					}).on('finish.countdown', function(event) {
					  $(this).html('تمام شد').parent().addClass('disabled');

					});
					
				});
			} 
		},
		
		
		init_swiper_slider: function() {
			
			/* $('.mweb-swiper').each(function() {
				var swiper_c = $(this).children('.swiper-container');
				if(swiper_c.length > 0){
					var configs = swiper_c.data('slider');
					var myswiper = new Swiper(swiper_c, configs );
					console.log(JSON.parse(configs));
					configs = undefined;
				}
			}); */
			//var j21 = $.noConflict(true);

			/* var nSlider = document.querySelectorAll('.xslider');
				console.log(nSlider);

			var defaultOptions = {
			  observeParents: true,
			  observer: true
			};
			if (!nSlider.length) return;

			[].forEach.call(nSlider, function( slider, index, arr )	{
				
				var data = slider.getAttribute('data-slider') || {};

				if (data){
					var dataOptions = JSON.parse(data);
				}

				slider.options = Object.assign({}, defaultOptions, dataOptions);

				//var swiper = new Swiper(slider, slider.options);
				
				if ('undefined' === typeof Swiper) {
					const asyncSwiper = window.elementorFrontend.utils.swiper;
					new asyncSwiper(slider, slider.options).then((newSwiperInstance) => {
						var wglSwiper = newSwiperInstance;
						wglSwiper.update();
					});
				} else {
					const wglSwiper = new Swiper(slider, slider.options);
					wglSwiper.update();
				}

			}); */ 
			
			
			if( $('.testimonials_slider').length >0 ){
				const slider = new Swiper('.testimonials_slider', {
					speed: 700,
					loop: true,
					lazy: {
					  loadPrevNext: true,
					},
				})

				const paginationItems = document.querySelectorAll('.testimonials_slider .ts_pagination > *')

				paginationItems.forEach((el, i) => {
					el.addEventListener('click', () => {
					  document
						.querySelector('.testimonials_slider .ts_pagination .is_active')
						.classList.remove('is_active')
					  el.classList.add('is_active')
					  slider.slideTo(i + 1)
					})
				})

				slider.on('slideChangeTransitionEnd', () => {
					document
					  .querySelector('.testimonials_slider .ts_pagination .is_active')
					  .classList.remove('is_active')
					paginationItems[slider.realIndex].classList.add('is_active')
				})
			}
		
		},
		
		get_swiper_slider: function ($element) {
		
			if( !$element.length )
				return false;
			
			var swiper_c = $('#'+ $element.attr('id'));
			var configs = swiper_c.data('slider') || {};
			configs.observer = true;
			configs.observeParents = true;
			configs.lazy = {
				loadPrevNext: true,
			};
		
			if ('undefined' === typeof Swiper) {
				const asyncSwiper = window.elementorFrontend.utils.swiper;
				new asyncSwiper('#'+ $element.attr('id'), configs).then((newSwiperInstance) => {
					var wglSwiper = newSwiperInstance;
					wglSwiper.update();
				});
			} else {
				const wglSwiper = new Swiper('#'+ $element.attr('id'), configs);
				wglSwiper.update();
			}

		},
		
		single_post_gallery: function() {
		
			/* if( $('#post_format_gallery').length >0 ){
			    $("#post_format_gallery").justifiedGallery({
					rowHeight : 140,
					captions: false,
					lastRow: "justify",
					margins : 5
				}); 
				$("#post_format_gallery").magnificPopup({
					delegate: "a",
					type: "image",
					zoom: {
						enabled: true,
						duration: 500, // duration of the effect, in milliseconds
						easing: 'ease', // CSS transition easing function
						opener: function (element) {
							return element.find('img');
						}
					},
					gallery: {
						enabled: true,
						navigateByImgClick: true,
						preload: [0, 1]
					}
				});
			} */
			
		},
		
		init_multimedia: function() {
		    $('video:not(#preview_product):not(.vjs-tech):not(.elementor-video):not(.elm_video):not(.elementor-background-video-hosted)').mediaelementplayer ({
				startLanguage:'fa',
				translations:['fa'],
				alwaysShowControls: true,
				videoVolume: 'horizontal',
				features: ['playpause','loop','current','progress','duration','tracks','volume', 'fullscreen'],

			});
			$('audio').mediaelementplayer ({
				startLanguage:'fa',
				translations:['fa'],
				videoVolume: 'horizontal',
				features: ['playpause','loop','current','progress','duration','volume'],

			});
			
			if( $('.product_thumbnail').length > 0 ){
				
				if( $('.product_thumbnail').hasClass('player_is_mediaelement') ){ 
				
					var player = $('#preview_product');
					player.mediaelementplayer ({
						startLanguage:'fa',
						translations:['fa'],
						videoVolume: 'horizontal',
						features: ['playpause','loop','current','progress','duration','tracks','volume', 'fullscreen'],
					}); 
					
					$('.free_play').on('click', function(e){
						e.preventDefault();
						e.stopPropagation();
						$('.course_item').removeClass('is_active');
						$(this).closest('.course_item').addClass('is_active');
						var media_src = $(this).closest('.course_item').data('preview');
						if (!player[0].paused) {
							player[0].pause();
						}
						player[0].setSrc(media_src);
						player[0].play();
						$('html, body').animate({
							scrollTop: ($('.product_thumbnail').offset().top)
						},500);
					});
					
				}else{
					
					if($('#preview_product').length > 0){
						var player = videojs('preview_product', {
							controls: true,
							autoplay: false,
							preload: 'auto',
							fluid: true,
							responsive: true,
							playbackRates: [0.7, 1.0, 1.5, 2.0]
						});
						
						player.hlsQualitySelector({
							displayCurrentQuality: true,
						});
						
						$('.free_play').on('click', function(e){
							e.preventDefault();
							e.stopPropagation();
							$('.course_item').removeClass('is_active');
							$(this).closest('.course_item').addClass('is_active');
							var media_src = $(this).closest('.course_item').data('preview');
							if (!player.paused) {
								player.pause();
							}
							player.src(media_src);
							player.play();
							$('html, body').animate({
								scrollTop: ($('.product_thumbnail').offset().top)
							},500);
						});
					}
				}
			
			}
			
			
			
			if( $('.mweb_video_element').length > 0 ){
				
				if( $('.mweb_video_element').hasClass('player_is_mediaelement') ){ 
				
					var player = $('.mweb_video_element').find('video');
					player.mediaelementplayer ({
						startLanguage:'fa',
						translations:['fa'],
						videoVolume: 'horizontal',
						features: ['playpause','loop','current','progress','duration','tracks','volume', 'fullscreen'],
					}); 
					
				}else{
					var video = $('.mweb_video_element').find('video');
					if( video.length > 0 ){
						var player = videojs( video.attr('id'), {
							controls: true,
							autoplay: false,
							preload: 'auto',
							fluid: true,
							responsive: true,
							playbackRates: [0.7, 1.0, 1.5, 2.0]
						});
						
						player.hlsQualitySelector({
							displayCurrentQuality: true,
						});
					}
				}
			}
			
			
			var wavesurfer = [];
			$('.podcast_shortcode').each(function(i) {
				
				if ( typeof wavesurfer[i] !== 'undefined' ) return;
				
				var main_podcast = $(this);
				var waveform_c = main_podcast.find('.js_waveform').attr('id');
				var play_pause_btn = main_podcast.find('.el_play_stop');
				var mute_btn = main_podcast.find('.el_mute');
			
				wavesurfer[i] = WaveSurfer.create({
					container: '#' + waveform_c,
					barWidth: 2,
					barHeight: 1,
					barGap: 2,
					barRadius: 10,
					cursorWidth: 0,
					height: 75,
					dragSelection: true,
					hideScrollbar: true,
					interact: true,
					normalize: true,
					waveColor: 'rgba(0,0,0,.1)',
					progressColor: mweb_color_sec,
					responsive: true
				});

				wavesurfer[i].load( main_podcast.data('audio') );
				play_pause_btn.on('click', function(){
					wavesurfer[i].playPause();
				});


				var m,s;

				function getMinutes( convTime ){
				  convTime = Number(convTime);
				  m = Math.floor(convTime% 3600 / 60);
				  return ((m < 10 ? "0" : "") + m);
				}

				function getSeconds( convTime ){
				  convTime = Number(convTime);
				  s = Math.floor(convTime % 3600 % 60);
				  return ((s < 10 ? "0" : "") + s);
				}

				var totalTime,
					timeJump,
					currentTime,
					currentTimeJump;

				wavesurfer[i].on('ready', function(){
					totalTime = wavesurfer[i].getDuration();
					//timeJump = 300 / totalTime;
					main_podcast.find('.podcast_player').fadeIn();
					main_podcast.find('.time-total').text( getMinutes( totalTime ) + ':' + getSeconds( totalTime ) );			  
				});

				function progressJump(){
					currentTime = wavesurfer[i].getCurrentTime();
					main_podcast.find('.time-current').text( getMinutes( currentTime ) + ':' + getSeconds( currentTime ) );
				}

				wavesurfer[i].on('audioprocess', function(){
					progressJump();
				}); 

				wavesurfer[i].on('pause', function(){
					main_podcast.removeClass('play');
				});

				wavesurfer[i].on('play', function(){
					main_podcast.addClass('play');
				});

				wavesurfer[i].on('seek', function(event){
					progressJump();
				});
				
				mute_btn.on('click', function(){
					wavesurfer[i].toggleMute();
					$(this).toggleClass('is_mute');
				});
				
				
				
				if( main_podcast.hasClass('podcast_single') ){
					
					$('.play_pdc_list').on('click', function(e){
						e.preventDefault();
						e.stopPropagation();
						$('.course_item').removeClass('is_active');
						$(this).closest('.course_item').addClass('is_active');
						var media_src = $(this).closest('.course_item').data('preview');
						if( wavesurfer[i].isPlaying() )
							wavesurfer[i].stop();
						wavesurfer[i].load( media_src );
						wavesurfer[i].on('ready', function() {
							wavesurfer[i].play();
						});
						
						var el = $(this).parent().html();
						var el_title = $('<div/>').html(el);
						el_title.children().remove();
						main_podcast.find('h5').text(el_title.text());
						
						$('html, body').animate({
							scrollTop: ( $('.podcast_single').offset().top )
						},500);
					});
				
				}
				
			});
			
			
			 mweb_theme.document.on('click', '.preview_btn', function(e) {
				e.preventDefault();
				var btn = $(this);
				var video_url = btn.data('src');
				//var def_html = '<div class="modal" id="perview_video_popup"><div class="popup_video_content"><div class="ajax-loader"></div></div></div>';
				//$(def_html).appendTo('body').modal();
				$('#perview_video_popup').find('.popup_video_content').html('<div class="ajax-loader"></div>');
				$('#perview_video_popup').modal();
				
				setTimeout(function () {
					if( !btn.hasClass('popup_video') ){
						$('.popup_video_content').html('<video controls autoplay preload="auto" poster="' + btn.parent('.product_image_area').find('img').attr('src') + '"><source src="' + video_url + '" type="video/mp4"></video>');
					}else{
						$('.popup_video_content').html('<video controls autoplay preload="auto"><source src="' + video_url + '" type="video/mp4"></video>');
					}
				}, 500);
	
				$('.popup_video_content').find('video').fadeIn();
			});
			
			$('#perview_video_popup').on($.modal.AFTER_CLOSE, function(event, modal) {
				$(this).find('.popup_video_content').empty();
			});
			
			

			
		},
		
		instagram_popup_widget: function () {
			if (1 == mweb_instagram_popup) {
				$('.instagram-el').find('a').magnificPopup({
					type: 'image',
					closeOnContentClick: true,
					closeBtnInside: true,
					removalDelay: 500,
					mainClass: 'mfp-fade',
					zoom: {
						enabled: true,
						duration: 500, // duration of the effect, in milliseconds
						easing: 'ease', // CSS transition easing function
						opener: function (element) {
							return element.find('img');
						}
					},
					gallery: {
						enabled: true,
						navigateByImgClick: true,
						preload: [0, 1]
					}
				});
			}
		},
		
		redesign_variation_form: function( $wrap ) {
        	if ( typeof $wrap == 'undefined') var $wrap = '';
        	if ( $wrap != '' ) {
	    		$wrap = $wrap+' .type-product.product-type-variable';
	    	}else{
	    		$wrap = '.type-product.product-type-variable';
	    	}
			if ( $($wrap).length  && typeof mw_arr_attr !== 'undefined' ) { 
				$($wrap).find('.variations select').each(function(){
					var select = $(this), select_div, var_attr = mw_arr_attr[select.attr('name')];
					if ( typeof var_attr == 'undefined') { return false; } 
					
					/* if (var_attr.type == 'select') { 
						$(this).niceSelect();
						return false;
					}  */
					select_div = $('<div />', {
				                	'class': 'sellect-wrap'
				            	}).insertAfter(select);
					select.hide();

					select.find( 'option' ).each(function (){
						var option_old = $(this), option;
						if ( option_old.attr('value')!='' ) {
							var inner_opt, class_sellect, val_opt = var_attr.key_val[option_old.attr('value')];
							if (var_attr.type == 'color') {
								inner_opt = $('<span/>', {
												'html': option_old.text()
											});
								var outer_opt = $('<i/>', {
												'style':'background:' + val_opt,
											}).appendTo(inner_opt);
								class_sellect = ' color';
							}else if (var_attr.type == 'image') {
								inner_opt = $('<span/>', {
												'style':'background-image:url("' + val_opt + '")'
											});
								class_sellect = ' image';
							}else if (var_attr.type == 'text') {
								inner_opt = $('<span/>', {
												'html': val_opt
											});
								class_sellect = ' text';
							}
							
							if (var_attr.type != 'select') { 
								option = $('<div/>', {
											'class': 'option'+class_sellect,
											'data-toggle':'tooltip',
											'data-original-title':option_old.text(),
											'data-value': option_old.attr('value')
										}).appendTo(select_div);
								inner_opt.appendTo(option);
								if ( option_old.val() == select.val() ){
									option.addClass('selected');
								}
								
								option.on('click', function () {
									// Update variation values
									if ( $(this).hasClass('selected') ) {
										select.val('').change();
									} else {
										select.val( option_old.val() ).change();
									}
									mweb_theme.set_selected_opt( $(this) );
								});
							}
						}
					});
					
				});
				$( document ).on( 'click', '.variations_form .reset_variations', function(event) {
					$('.variations_form .sellect-wrap .option').removeClass('selected');
				});
			}
		},
		
		
		set_selected_opt: function( option ) {
	        option.toggleClass('selected');
	        option.siblings().removeClass('selected');
	    },
		
		mweb_popup_init: function( $photo , $link ) {
						
			if(!mweb_theme.readCookie('run_popup')){
				
				$.magnificPopup.open({
				 
				  mainClass: 'mweb-popup',
				  tLoading: '',
				  tClose: 'دیگر نمایش نده',
				  items: { src: $('<div class="white-popup"><a href="'+$link+'"><img src="'+$photo+'" /></a></div>') },
				  type: 'inline'
				}, 0);
				
			}
		},
		
		
		mweb_sticky_cart_box: function() {
						
			if(mweb_theme.body.hasClass('single-product') && $('.entry-summary').length > 0){
			
				var add_tocart_top = $('.single_title_product').offset().top + $('.single_title_product').height();
				var add_tc = $('.vr_desktop');
				var add_tc_m = $('.vr_mobile');
				var content_el = $('#content').height() - $('.main_footer').height();
				$(window).scroll(function(event){
					var scl_top = $(this).scrollTop();
					if (scl_top > add_tocart_top && scl_top < content_el) { 
						add_tc.addClass('fixed');
					}else {
						add_tc.removeClass('fixed'); 
					}
					if (scl_top > add_tocart_top) { 
						add_tc_m.addClass('fixed');
					}else {
						add_tc_m.removeClass('fixed'); 
					}
				});
			
			}
		},
		
		mweb_sticky_header: function() {
						
			if($(".menu_sticky").length > 0){
			
				var offset_top = $('header').height();
				$(window).scroll(function(event){
					var currentScroll = $(this).scrollTop();
					if (currentScroll > offset_top ){
						$('.menu_sticky').addClass('my_sticky');
					} else {
						$('.menu_sticky').removeClass('my_sticky');
					}
				});
			
			}
		},
		
		mweb_init_rating: function() {
			
			$('.course_rating i').on('click',function(e){
				//e.preventDefault();
				$('.course_rating i').removeClass('active');
				var inx = $(this).attr("data-value");
				$(this).addClass('active');
				var el_select = $(this).parent().prev();
				el_select.val(inx);
			});			
			
		},
		
		mweb_init_quantity: function(){
			$(document).on('click', '.increase', function(e) {
				e.preventDefault(); 
				var currentVal = parseInt($(this).parents('.quantity').find('input.qty').val()); 
				var maxVal = parseInt($(this).parents('.quantity').find('input.qty').attr("max"));
				if(isNaN(maxVal)){ maxVal = 100; }
				if (!isNaN(currentVal) && currentVal < maxVal) {
				  $(this).parents('.quantity').find('input.qty').val(currentVal + 1).change();
				}
			});
			$(document).on('click', '.reduced', function(e) {
				e.preventDefault();
				var currentVal = parseInt($(this).parents('.quantity').find('input.qty').val());
				if (!isNaN(currentVal) && currentVal > 1) {
				  $(this).parents('.quantity').find('input.qty').val(currentVal - 1).change();
				}
			});
		},
		
		mweb_curriculum: function(){
			
			$('.prd_acc').click( function(e) {
				e.preventDefault(); 
				if($(this).hasClass('active')){
					$(this).removeClass('active');
					$(this).next().slideUp('slow');
				}else{
					$(this).addClass('active');
					$(this).next().slideDown('slow');
				}
			});
			
		},
		
		
		init_wc_tabs: function(){
			
			if( $('.scroll_wc_tab').length ){
				var el_content_section = $('.woocommerce-Tabs-panel');
				var el_navigation = $('.wc-tabs');
				
				var el_navigation_offset = el_navigation.offset().top;
				var el_navigation_height = el_navigation.height();
				
				el_navigation.on('click', 'a', function(event){
					event.preventDefault(); 
					$('body,html').animate({
						scrollTop: $(this.hash).offset().top
					}, 800);
				});
				
				mweb_theme.window.on('scroll', function(){
					mweb_theme.mweb_update_wc_nav_tabs(el_content_section);
					
					 var windowTop = mweb_theme.window.scrollTop();
					if ( el_navigation_offset + el_navigation_height < windowTop ) {
						el_navigation.addClass('is_active');
					} else {
						el_navigation.removeClass('is_active');
					}
		
				});
				
				mweb_theme.mweb_update_wc_nav_tabs(el_content_section);
			}
	
		
		},
		
		
		mweb_update_wc_nav_tabs : function( el_content_section ){
			el_content_section.each(function(){
				var sectionName = $(this).attr('id');
				var navigationMatch = $('.wc-tabs a[href="#' + sectionName + '"]');
				if( ($(this).offset().top - mweb_theme.window.height()/2 < mweb_theme.window.scrollTop()) &&
					  ($(this).offset().top + $(this).height() - mweb_theme.window.height()/2 > mweb_theme.window.scrollTop()))
					{
						navigationMatch.parent().addClass('active');
					}
				else {
					navigationMatch.parent().removeClass('active');
				}
			});
		},
		
		
		mweb_nav_to_select: function() {
			var el_area = $(".top_menu");
			if(el_area.find('ul').length > 0){
				var el_select = $("<select />");

				$("<option />", {
					"selected": "selected",
					"value"   : "",
					"text"    : "انتخاب فهرست"
				}).appendTo(el_select);

				$('.top_menu a').each(function() {
					var el = $(this);
					$("<option />", {
						"value"   : el.attr("href"),
						"text"    : el.text()
					}).appendTo(el_select);
				});
				
				el_area.append(el_select);
				
				$(el_select).change(function() {
					window.location = $(this).find("option:selected").val();
				});	
			}				
		},
		
		createCookie: function ($name,$value,$days) {
			if ($days) {
				var date = new Date();
				date.setTime(date.getTime()+($days*24*60*60*1000));
				var expires = "; expires="+date.toGMTString();
			}
		   else var expires = "";
		   document.cookie = $name+"="+$value+expires+"; path=/";
		},

		readCookie: function($name) {
			var nameEQ = $name + "=";
			var ca = document.cookie.split(';');
			for(var i=0;i < ca.length;i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1,c.length);
			   if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);

			}
			return null;
		},
		
		
		
		mweb_ajax_add_to_cart_multiple: function() {

			$('.multiple_add_to_cart').off('click').on('click', function(e) {		
			
				//e.preventDefault();
				var el_btn = $(this);
				
				$.ajax({
					type: 'post',
					url: mweb_ajax_url,
					data: {
						action: 'add_to_cart_multiple',
						product_ids : el_btn.data('ids'),
						security_nonce : admin_ajax_nonce 
					}, 
					beforeSend: function (xhr) {
						el_btn.addClass('loading');
					},
					success: function (res) {
						mweb_theme.add_notice( res.data.message, '&nbsp', 'success' );
						$(document.body).trigger('wc_fragment_refresh');
						el_btn.removeClass('loading');
					},
					error: function (res) {
						mweb_theme.add_notice( res.data.message, '&nbsp', 'info' );
						el_btn.removeClass('loading');
					}

				});
				
			});
			
		},
		
		
		
		init_smoothAccordion: function ( element ) {
			
            var accordionContent = $(element).find(".accordion-item-content");
            var link = $(element).find(".accordion-item-title");
            var ico = $(element).find("i.fal");
            link.click(function (e) {
                var $cnt = $(this);
                if ($cnt.hasClass("active")) {
                    $cnt.next().removeClass("active").slideUp();
                    $cnt.removeClass("active");
                    $cnt.find("i.fal").removeClass("fa-angle-down");
                    $cnt.find("i.fal").addClass("fa-angle-up");
                } else {
                    $cnt.next().addClass("active").slideDown();
                    $cnt.addClass("active");
                    $cnt.find("i.fal").removeClass("fa-angle-up").addClass("fa-angle-down");
                }
                e.preventDefault();
            });
        
		},
		
		
		init_listAccordion: function ( element ) {
			$(element).each(function () {
				var $main = $(this);
				$main.find('.cat-parent').each(function () {
					if ($(this).hasClass('current-cat-parent')) {
						$(this).addClass('show-sub');
						$(this).children('.children').slideDown(400);
					}
					$(this).children('.children').before('<span class="carets"></span>');
				});
				$main.children('.cat-parent').each(function () {
					var curent = $(this).find('.children');
					$(this).children('.carets').on('click', function () {
						$(this).parent().toggleClass('show-sub');
						$(this).parent().children('.children').slideToggle(400);
						$main.find('.children').not(curent).slideUp(400);
						$main.find('.cat-parent').not($(this).parent()).removeClass('show-sub');
					});
					var next_curent = $(this).find('.children');
					next_curent.children('.cat-parent').each(function () {
						var child_curent = $(this).find('.children');
						$(this).children('.carets').on('click', function () {
							$(this).parent().toggleClass('show-sub');
							$(this).parent().parent().find('.cat-parent').not($(this).parent()).removeClass('show-sub');
							$(this).parent().parent().find('.children').not(child_curent).slideUp(400);
							$(this).parent().children('.children').slideToggle(400);
						})
					});
				});
			});
		},

		
		init_element_function: function(){
						
			/* $('.product-categories').mwAccordion({
				btn_open: '<span class="ac-tongle open"></span>',
				btn_close: '<span class="ac-tongle close"></span>',
			}); */
			
			$.extend(true, $.magnificPopup.defaults, {
				tClose: 'بستن', 
				tLoading: 'بارگذاری ...', 
				gallery: {
					tPrev: 'قبل', 
					tNext: 'بعد', 
					tCounter: '%curr% از %total%' 
				},
				image: {
					tError: '<a href="%url%">عکس</a> نمی تواند بارگذاری شود.' 
				},
				ajax: {
					tError: '<a href="%url%">محتوا</a> نمی تواند بارگذاری شود.' 
				}
			});
			
			if ( $('.accordion-shortcode').length > 0 ){
				mweb_theme.init_smoothAccordion(".accordion-shortcode");
			}
			
			$('.progress .progress-bar').progressbar();
			//$('.recommended_warp select').niceSelect();
			
			$("body *[data-toggle='tooltip']").each(function(){
				$(this).tooltip();
			});
			
			$('.yith-wcwl-add-button .add_to_wishlist, .yith-wcwl-wishlistaddedbrowse a, .yith-wcwl-wishlistexistsbrowse a').each(function(){
				$(this).attr('data-toggle', 'tooltip').attr('data-original-title', $(this).text().trim());
			});
			
			$('.or_view').click(function(e) {
				e.preventDefault();
				$(this).parents('.morder_item').next().slideToggle();
			});
			
			$('.notify_item .el_more').click(function(e) {
				e.preventDefault();
				$(this).parents('.meta_notify').next().slideToggle();
			});
			
			$('.close_alert').click(function(e){
				e.preventDefault();
				$('.header_alert').hide('fast');
				mweb_theme.createCookie('haed_alert',true,1);
			});
			
			$('.term-description-wrap .loadmore').click(function(e){
				e.preventDefault(); 
				$('.term-description').toggleClass('desc_show', function() {
				  if ( $( this ).is( ".desc_show" ) ) {
					$('.loadmore').text('کمینه کردن اطلاعات ...');
				  } else {
					$('.loadmore').text('اطلاعات بیشتر ...');
				  }
				});
			});
			

			$('.fixed_elm_btn').click(function(e){
				e.preventDefault();
				$(this).toggleClass('is_active');
				$('body').toggleClass('nav-active');
			});
			
			$('.course_item.has_desc').each(function() {
				$(this).off('click').on('click', function(e) {
					e.preventDefault();
					$(this).toggleClass('i_active').next('.course_item_content').slideToggle();
				});
			});
			
			
			$(".el_slide:first-child").addClass("active");
			$(".el_slide").click(function(){
			   $(".el_slide").removeClass("active");
			   $(this).addClass("active");
			});
			
			
			var copy_btn = document.querySelector('.btn_copy');
			if( copy_btn ){
				copy_btn.addEventListener('click', function(event) {
					var copy_text = copy_btn.closest("div").querySelector('.text_copy');
					copy_text.focus();
					copy_text.select();

					try {
						var successful = document.execCommand('copy');
						var msg = successful ? 'کپی شد' : 'کپی نشد';
						var old_text = copy_text.value;
						copy_text.value = msg;
						setTimeout(() => { copy_text.value = old_text; }, 2000);
					} catch (err) {
						console.log('Oops, unable to copy');
					}
				});
			}
			
			if( mweb_acc_digits && !mweb_theme.body.hasClass('logged-in') ){
				$('.login_btn, .singup_user_btn, .login_user_btn, .comment_login').addClass('digits-login-modal');
			}
			
			$('.btn_print').on('click', function() {
			
			var contentToPrint = $('.elementor-widget-theme-post-content .elementor-widget-container').html(); 
			var printWindow = window.open('', 'Print Window'); 
			var styles = '';
			$('link[rel="stylesheet"]').each(function() {
				var href = $(this).attr('href');
				styles = styles + '<link rel="stylesheet" type="text/css" href="' + href + '">';
			});
			printWindow.document.write('<html><head>' + styles + '</head><body>' + contentToPrint + '</body></html>');
			printWindow.document.close();  
			printWindow.focus();
			setTimeout(function(){
				printWindow.print();
				printWindow.close(); 
			}, 2000);
			
		});
		
		
		if( $('.btn_fontsize').length ){

			var el_content = $('.elementor-widget-theme-post-content .elementor-widget-container'); 
			var el_fontsize = $('.btn_fontsize').find('b');
			var el_fontsize_n = parseInt(el_content.css("fontSize"));
			el_fontsize.text( el_fontsize_n );
			$('.btn_fontsize .increase').on('click', function() {	
				el_content.css("font-size", "+=1");
				el_fontsize.text( ++el_fontsize_n )
			});
			$('.btn_fontsize .decrease').on('click', function() {	
				el_content.css("font-size", "-=1");
				el_fontsize.text( --el_fontsize_n )
			});
		}


		},
		
		init_console_bio: function () {
			console.log(" ");
		},
		
	};


    $(document).ready(function() {
        mweb_theme.document_ready();
        mweb_theme.document_load();
        mweb_theme.document_reload();
        mweb_theme.document_resize();
		
		
		$( "#mweb_login" ).submit(function( e ) {
			var $form = $(e.target);
			var $message = $('#message', this);
			var all_data = $form.serializeArray();
			all_data.push({name: 'security-login', value: admin_ajax_nonce});

			e.preventDefault();
			$message.text('در حال ارسال اطلاعات ...');
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: mweb_ajax_url ,
				data: all_data,
				success: function (response) {
				console.log(response);
				$message.html(response.data.message);
					if (response.success && response.data.logged_in) {
							window.location.reload();
						
					} 
				}
			});

		});
		
		$( "#mweb_register" ).submit(function( e ) {
			var $form = $(e.target);
			var $message = $('#message', this);
			var all_data = $form.serializeArray();
			all_data.push({name: 'security-singup', value: admin_ajax_nonce});
			
			e.preventDefault();
			$message.text('در حال ارسال اطلاعات ...');
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: mweb_ajax_url ,
				data: all_data,
				success: function (response) {
				$message.html(response.data.message);
					if (response.success && response.data.logged_in) {
						if(response.data.verify){
							setTimeout(function(){
								window.location.replace(response.data.redirect);
							},3000);
							
						}else{
							window.location.reload();
							
						}

					}
				}
			});

		});
		
		
		function sms_timer(){
			var timer = $('.resend_sms');
			var now = new Date();
			now.setSeconds(now.getSeconds() + 180);
			var resend_time = now.getFullYear()+'/'+(now.getMonth()+1)+'/'+now.getDate()+' '+now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds();
		    timer.countdown(resend_time).on('update.countdown', function(event) {
				var $this = $(this).html(event.strftime('%M:%S ارسال مجدد'));
			}).on('finish.countdown', function(event) {
				$(this).html('');
				$('#get_otp').val('ارسال مجدد کد تایید').show();
			});
		}
		
		$( "#get_otp" ).on('click', function(e) {
			e.preventDefault();
			var this_e = $(this);
			var message = $('.sms_notice');
			var verifycode = $('.verifycode');
			var mobile = $('#phone_nubmber');
			var plable = $('.plable');
			var _nonce = $('#security_nonce_field').val();
			var data_action = (this_e.parents('form').attr('id') == 'verifysms_form') ? 'wp_sms_action_send': 'wp_lost_password_otp_send';
			if(!mobile.val()){
				mobile.focus();
			}else{
				
				message.addClass('on').html('در حال ارسال اطلاعات ...');
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: mweb_ajax_url ,
					data: {
						action: data_action,
						phone_number : mobile.val(),
						security_nonce_field : _nonce
					}, 
					success: function (response) {
						if (response.success) {
							this_e.hide();
							$('#submit_otp').removeClass('hide');
							sms_timer();
							message.html(response.data.message);
							verifycode.removeClass('hide');
							mobile.hide();
							$('#sms_retries').val(response.data.retries);
							plable.html('کد تایید را وارد کنید');							
						}else{
							message.addClass('off').html(response.data.message);
						}
						
					}
				});
			}

		});
		
		
		$( "#submit_otp" ).on('click', function(e) {
			e.preventDefault();
			var this_e = $(this);
			var message = $('.sms_notice');
			var otp_var = $('#sms_otp');
			var verifysms_wrap = $('.verifysms_wrap');
			var data_action = (this_e.parents('form').attr('id') == 'verifysms_form') ? 'wp_sms_action_verify': 'wp_lost_password_otp_verify';
			var _nonce = $('#security_nonce_field').val();
			if(!otp_var.val()){
				otp_var.focus();
			}else{

				message.addClass('on').text('در حال بررسی اطلاعات ...');
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: mweb_ajax_url ,
					data: {
						action: data_action,
						sms_otp : otp_var.val(),
						security_nonce_field : _nonce
					}, 
					success: function (response) {
						if (response.success) {
							if(message.hasClass('off')){
								message.removeClass('off');
							}
							message.addClass('on').html(response.data.message);		
							setTimeout(function(){
								if(response.data.redirect){
									window.location.replace(response.data.redirect);
								}else{
									verifysms_wrap.remove();
								}
								
							},2500);							
						}else{
							message.addClass('off').html(response.data.message);
						}
						
					}
				});
			}

		});
		
    });
	
	jQuery( window ).on( 'elementor/frontend/init', () => {
		
		elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {
			let sliderElement     = $scope.find('.xslider');
			mweb_theme.get_swiper_slider(sliderElement);
		} );
				
	}); 

	
	
	

})(jQuery);