<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<!--meta tag-->
	<meta charset="<?php bloginfo( 'charset' ); ?>"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0 , maximum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11"/>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>

	<?php wp_head(); ?>

</head>
<body <?php body_class(); mweb_theme_schema::makeup( 'body' ); ?>>
<div class="page-wrap clear page-404">
        <div class="container">
            <div class="content-404-inner content-inner">
	            <div class="icon-wrap">
					<img src="<?php echo get_template_directory_uri(); ?>/assets/images/404.gif" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
	            </div>
                <div class="content-404">
                    <div class="logo-404 post-title"><h1>صفحه مورد نظر یافت نشد که به چند دلیل این اتفاق افتاده است:</h1></div>
                    <div class="title-404 post-title">
						<ul>
						  <li>آدرس صفحه تغییر کرده است.</li>
						  <li>صفحه به طور کلی حذف شده است.</li>
						  <li>مشکلی در دیتابیس بوجود آمده است.</li>
					    </ul>
				    </div>
					<a href="<?php echo get_site_url(); ?>" class="back_to_site">بازگشت به صفحه اصلی</a>

                </div>
            </div>
        </div>
</div> 
<?php wp_footer(); ?>
</body>
</html>