<?php
/**
 * Plugin Name: المنتور فارسی
 * Plugin URI: 
 * Description: بسته فارسی ساز المنتور پرو با 36 فونت فارسی، تقویم شمسی و آیکون‌های ایرانی.
 * Version: 2.13.9
 * Author: المنتور فارسی
 * Author URI: 
 * Text Domain: persian-elementor
 * License: GPL2
 * Elementor tested up to: 3.23
 * Elementor Pro tested up to: 3.23
 */
if (!defined('ABSPATH')) {
    exit;
}

final class Persian_Elementor {
    private static $instance = null;
    private $options = [];

    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
    }

    public function init() {
        $this->define_constants();
        if (!did_action('elementor/loaded')) {
            return;
        }
        $this->load_textdomain();
        $this->include_files();
        $this->register_hooks();
    }

    private function define_constants() {
        define('PERSIAN_ELEMENTOR', plugin_dir_path(__FILE__));
    }

    public function load_textdomain() {
        load_plugin_textdomain('persian-elementor');
    }

    private function include_files() {
        $includes = [
            'plugin.php',
            'includes/translate.php',
            'includes/localization.php',
            'includes/fonts.php',
            'includes/icon.php',
            'includes/options.php'
        ];
        foreach ($includes as $file) {
            $path = PERSIAN_ELEMENTOR . $file;
            if (file_exists($path)) {
                require_once $path;
            } else {
                error_log("File missing: " . esc_html($path));
            }
        }
    }

    public function register_hooks() {
        $this->options = get_option('persian_elementor', []);
        
        add_action('elementor/widgets/register', [$this, 'register_new_widgets']);
        if ($this->options['efa-all-font'] ?? false) {
            add_action('elementor/controls/controls_registered', [$this, 'persian_elementor_typography_control']);
            $this->persian_elementor_typography_init();
        }
    }

    public function register_new_widgets($widgets_manager) {
        require_once PERSIAN_ELEMENTOR . 'widget/video-widget.php';
        $widgets_manager->register(new \Persian_Elementor_Video_Widget());
    }
    
    public function persian_elementor_typography_init() {
        if (did_action('elementor/loaded')) {
            include_once PERSIAN_ELEMENTOR . 'widget/class-group-control-typography.php';
        }
    }

    public function persian_elementor_typography_control($controls_manager) {
        require_once PERSIAN_ELEMENTOR . 'widget/class-group-control-typography.php';
        $controls_manager->add_group_control('typography', new \Elementor\Group_Control_Typography());
    }
}

Persian_Elementor::get_instance();

// Update
include(dirname(__FILE__) . '/updater.php');
$efa_plugin_data = get_file_data(__FILE__, array('Version' => 'Version'), false);
$efa_plugin_version = $efa_plugin_data['Version'];
$efa_license_key = trim(get_option('efa_11101_license_key'));
$edd_updater = new Elementorfa_Plugin_Updater('https://elementorfa.ir/', __FILE__, array(
    'version'    => $efa_plugin_version,
    'license'    => $efa_license_key,
    'item_id'    => 11101,
    'author'     => 'المنتور فارسی',
    'url'        => home_url(),
    'beta'       => false
));

if (get_option('efa_11101_license_status', false) == 'valid') {
    require_once plugin_dir_path(__FILE__) . 'lib/wp-package-updater/class-wp-package-updater.php';
    // Enable plugin updates with license check
    $persia_elementor_pro_updater = new WP_Package_Updater(
        'https://api.elementorfa.ir/',
        wp_normalize_path(__FILE__),
        wp_normalize_path(plugin_dir_path(__FILE__))
    );
}