<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$product_type = get_post_meta( get_the_ID(), '_product_type_select', true ); 
if($product_type == 'file'){
	$wc_loop = 'file';
}else{
	$wc_loop = 'general';
}

if ( $related_products ) : ?>

	<section class="related products mweb-block-wrap mweb-swiper">

		<?php
		$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );
		if ( $heading ) :
			?>
			<div class="block-title no_black"><div class="title"><i class="fal fa-repeat"></i><?php echo esc_html( $heading ); ?></div></div>
		<?php endif; ?>
		

		<?php //woocommerce_product_loop_start(); ?>
		<div class="swiper-slider swiper-container" dir="rtl" data-slider="<?php echo esc_attr('{"slidesPerView":"1","spaceBetween":10,"watchSlidesVisibility":true,"touchMoveStopPropagation":true,"navigation":{"nextEl":".mweb-swiper-next","prevEl":".mweb-swiper-prev"},"breakpoints":{"0":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"1024":{"slidesPerView":"3"}}}'); ?>">
			<div class="swiper-wrapper">
				<?php foreach ( $related_products as $related_product ) : ?>

					<?php
						$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );
						echo '<div class="swiper-slide">';
							get_template_part( 'templates/loop', $wc_loop );
						echo '</div>';

						?>

				<?php endforeach; ?>
			</div>
			<div class="mweb-swiper-next"><i class="fal fa-angle-right"></i></div><div class="mweb-swiper-prev"><i class="fal fa-angle-left"></i></div>

		<?php //woocommerce_product_loop_end(); ?>
		</div>
	</section>

<?php endif; 

wp_reset_postdata();


?>