<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );


$mweb_sidebar_position = mweb_theme_util::get_theme_option('product_archive_sidebar_position' );
$mweb_wrap_col = 'col-md-9';
if($mweb_sidebar_position =='default'){
	$mweb_sidebar_position = 'right';
}elseif($mweb_sidebar_position == 'none') {
	$mweb_wrap_col = 'col-md-12';
} 




/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );
echo '<div class="row is-sidebar-'.$mweb_sidebar_position.'">';
echo '<div class="content-wrap content-with-sidebar '.$mweb_wrap_col.' col-sm-12 col-12">';

?>
<header class="woocommerce-products-header block-title">
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<div class="title"><i class="fal fa-archive"></i><?php woocommerce_page_title(); ?></div>
	<?php endif; ?>

	
</header>
<?php
	ob_start();
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	do_action( 'woocommerce_archive_description' );
	$my_desc = ob_get_clean();
?>
<?php if( !empty( $my_desc ) ){ ?>
<div class="term-description-wrap">
<?php echo $my_desc; ?>
<div class="loadmore">اطلاعات بیشتر ...</div>
</div>
<?php } ?>

<?php
if ( woocommerce_product_loop() ) {

	echo '<div class="shop-control-bar clear">';

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked wc_print_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );
	
	echo '</div>';
	
	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 *
			 * @hooked WC_Structured_Data::generate_product_data() - 10
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();

	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}



echo '</div><!-- ./ content-wrap -->';

if($mweb_sidebar_position != 'none'){

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action( 'woocommerce_sidebar' );

}
echo '</div><!-- ./row -->';


/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
