<?php
//About widget
add_action('widgets_init', 'mweb_register_contact_widget');
function mweb_register_contact_widget()
{
    register_widget('mweb_contactus_widget');
}

class mweb_contactus_widget extends WP_Widget
{
    function __construct()
    {
        $widget_ops = array('classname' => 'contact-us-widget', 'description' => '' );
        parent::__construct('mweb_contactus_widget','footer - ارتباط با ما' , $widget_ops);
    }

    function widget($args, $instance)
    {
	    extract( $args );
	    $title   = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
	    $address = ( ! empty( $instance['address'] ) ) ? $instance['address'] : '';
	    $phone   = ( ! empty( $instance['phone'] ) ) ? $instance['phone'] : '';
	    $email   = ( ! empty( $instance['email'] ) ) ? $instance['email'] : '';
	    $social     = ( ! empty( $instance['social'] ) ) ? $instance['social'] : '';


	    echo $before_widget;

	    if ( ! empty( $title ) ) {
		    echo $before_title . esc_attr( $title ) . $after_title;
	    } ?>

		<?php
			if(!empty($address)){ 
				echo '<div class="contact_item address"><i class="fal fa-map-marked-alt"></i><span>'.$address.'</span></div>';
			}
			if(!empty($phone)){ 
				echo '<div class="contact_item phone"><i class="fal fa-phone-volume"></i><strong>'.substr($phone, 0, 4).'</strong>'.substr($phone, 4).'</div>';
			}
			if(!empty($email)){ 
				echo '<div class="contact_item email"><i class="fal fa-at"></i>'.$email.'</div>';
			}
			if (!empty($social)){
				echo mweb_theme_template_part::mweb_social_icons();
			}
        
		?>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
	    $instance               = $old_instance;
	    $instance['title']      = strip_tags( $new_instance['title'] );
	    $instance['address']    = strip_tags( $new_instance['address'] );
	    $instance['phone']      = strip_tags( $new_instance['phone'] );
	    $instance['email']      = strip_tags( $new_instance['email'] );
		$instance['social']     = strip_tags( $new_instance['social'] );

	    return $instance;
    }

    function form($instance)
    {
	    $defaults = array(
		    'title'      => esc_html__( 'ارتباط با ما', 'mweb' ),
		    'address'    => '',
		    'phone'      => '',
		    'email'      => '',
		    'social'     => ''
	    );
        $instance = wp_parse_args( (array) $instance, $defaults ); ?>
	    <p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('عنوان:','mweb');?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php if( !empty($instance['title']) ) echo esc_attr($instance['title']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'address' )); ?>"><?php esc_html_e('آدرس :','mweb'); ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'address' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'address' )); ?>" value="<?php if( !empty($instance['address']) ) echo esc_attr($instance['address']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'phone' )); ?>"><?php esc_html_e('تلفن :','mweb'); ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'phone' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'phone' )); ?>" value="<?php if( !empty($instance['phone']) ) echo esc_attr($instance['phone']); ?>" />
	    </p>

	    <p>
		    <label for="<?php echo esc_html($this->get_field_id( 'email' )); ?>"><?php esc_html_e('ایمیل :','mweb'); ?></label>
		    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'email' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'email' )); ?>" value="<?php if( !empty($instance['email']) ) echo esc_attr($instance['email']); ?>" />
	    </p>
		
		<p>
		    <label for="<?php echo esc_attr($this->get_field_id( 'social' )); ?>"><?php esc_attr_e('نمایش شبکه های اجتماعی','mweb') ?></label>
		    <input class="widefat" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'social' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'social' )); ?>" value="checked" <?php if( !empty( $instance['social'] ) ) echo 'checked="checked"'; ?>  />
	    </p>
		<p style="color:red; font-size:11px; font-family:Tahoma">لیست شبکه های اجتماعی از تنظیمات پوسته قابل تغییر می باشد</p>


    <?php
    }
}
?>
